/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Quaternion;

public class ZMatrixReader
extends AtomSetCollectionReader {
    protected int atomCount;
    protected List<Atom> vAtoms = new ArrayList<Atom>();
    private Map<String, Integer> atomMap = new Hashtable<String, Integer>();
    private String[] tokens;
    private boolean isJmolZformat;
    private List<String[]> lineBuffer = new ArrayList<String[]>();
    private Map<String, Float> symbolicMap = new Hashtable<String, Float>();
    private boolean isMopac;
    private boolean isHeader = true;
    private final Point3f pt0 = new Point3f();
    private final Vector3f v1 = new Vector3f();
    private final Vector3f v2 = new Vector3f();
    private final Point4f plane1 = new Point4f();
    private final Point4f plane2 = new Point4f();

    protected boolean checkLine() throws Exception {
        this.cleanLine();
        if (this.line.length() <= 2) {
            this.isHeader = false;
        }
        if (this.line.startsWith("#") || this.isMopac && this.isHeader) {
            if (this.line.startsWith("#ZMATRIX")) {
                this.isJmolZformat = this.line.toUpperCase().indexOf("GAUSSIAN") < 0 && !(this.isMopac = this.line.toUpperCase().indexOf("MOPAC") >= 0);
            }
            this.checkLineForScript();
            return true;
        }
        if (this.line.indexOf("#") >= 0) {
            this.line = this.line.substring(0, this.line.indexOf("#"));
        }
        if (this.line.indexOf(":") >= 0) {
            return true;
        }
        this.tokens = ZMatrixReader.getTokens(this.line);
        if (this.tokens.length == 2) {
            this.getSymbolic();
            return true;
        }
        this.lineBuffer.add(this.tokens);
        return true;
    }

    private void cleanLine() {
        int n;
        int n2;
        this.line = this.line.replace(',', ' ');
        while ((n2 = this.line.indexOf(40)) >= 0 && (n = this.line.indexOf(40, n2)) >= 0) {
            this.line = this.line.substring(0, n2) + " " + this.line.substring(n + 1);
        }
        this.line = this.line.trim();
    }

    protected void finalizeReader() throws Exception {
        int n;
        for (int i = n = 0; i < this.lineBuffer.size(); ++i) {
            this.tokens = this.lineBuffer.get(i);
            if (this.tokens.length <= 0) continue;
            this.getAtom();
        }
        super.finalizeReader();
    }

    private void getSymbolic() {
        if (this.symbolicMap.containsKey(this.tokens[0])) {
            return;
        }
        float f = this.parseFloat(this.tokens[1]);
        this.symbolicMap.put(this.tokens[0], Float.valueOf(f));
        Logger.info("symbolic " + this.tokens[0] + " = " + f);
    }

    private void getAtom() throws Exception {
        Atom atom = new Atom();
        String string = this.tokens[0];
        int n = string.length();
        while (--n >= 0 && Character.isDigit(string.charAt(n))) {
        }
        if (++n == 0) {
            throw new Exception("Bad Z-matrix atom name");
        }
        if (n == string.length()) {
            atom.atomName = string + (this.atomCount + 1);
        } else {
            atom.atomName = string;
            string = string.substring(0, n);
        }
        if (this.isMopac && n != this.tokens[0].length()) {
            string = this.tokens[0].substring(n) + string;
        }
        this.setElementAndIsotope(atom, string);
        int n2 = this.getAtomIndex(1);
        int n3 = 0;
        switch (this.tokens.length) {
            case 6: 
            case 8: {
                n3 = (int)this.getValue(this.tokens.length - 1);
            }
            case 5: {
                if (this.tokens.length == 5 && this.tokens[1].equals("0")) {
                    atom.set(this.getValue(2), this.getValue(3), this.getValue(4));
                    n3 = 0;
                    break;
                }
            }
            case 7: {
                float f;
                int n4;
                int n5;
                if (this.tokens.length < 7 && this.atomCount != 2 || (n5 = this.getAtomIndex(3)) < 0 || (n4 = this.tokens.length < 7 ? -2 : this.getAtomIndex(5)) == -1) {
                    atom = null;
                    break;
                }
                float f2 = this.getValue(2);
                float f3 = this.getValue(4);
                float f4 = f = this.tokens.length < 7 ? Float.MAX_VALUE : this.getValue(6);
                if (this.tokens.length == 8 && !this.isJmolZformat && !this.isMopac && n3 == 1) {
                    f2 = -Math.abs(f2);
                }
                atom = this.setAtom(atom, n2, n5, n4, f2, f3, f);
                break;
            }
            case 4: {
                if (this.getAtomIndex(1) < 0) {
                    atom.set(this.getValue(1), this.getValue(2), this.getValue(3));
                    break;
                }
                n3 = (int)this.getValue(3);
            }
            case 3: {
                float f = this.getValue(2);
                if (this.atomCount != 1 || (n2 = this.getAtomIndex(1)) != 0) {
                    atom = null;
                    break;
                }
                atom.set(f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (this.atomCount != 0) {
                    atom = null;
                    break;
                }
                atom.set(0.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                atom = null;
            }
        }
        if (atom == null) {
            throw new Exception("bad Z-Matrix line");
        }
        this.vAtoms.add(atom);
        this.atomMap.put(atom.atomName, this.atomCount);
        ++this.atomCount;
        if (string.startsWith("X") && JmolAdapter.getElementNumber(string) < 1) {
            Logger.info("#dummy atom ignored: atom " + this.atomCount + " - " + atom.atomName);
        } else {
            this.atomSetCollection.addAtom(atom);
            this.setAtomCoord(atom);
            Logger.info(atom.atomName + " " + atom.x + " " + atom.y + " " + atom.z);
            if (this.isJmolZformat && n3 > 0) {
                this.atomSetCollection.addBond(new Bond(atom.atomIndex, this.vAtoms.get((int)n2).atomIndex, n3));
            }
        }
    }

    private float getSymbolic(String string) {
        boolean bl = string.startsWith("-");
        Float f = this.symbolicMap.get(bl ? string.substring(1) : string);
        if (f == null) {
            return Float.NaN;
        }
        float f2 = f.floatValue();
        return bl ? -f2 : f2;
    }

    private float getValue(int n) throws Exception {
        float f = this.getSymbolic(this.tokens[n]);
        if (Float.isNaN(f)) {
            f = this.parseFloat(this.tokens[n]);
        }
        if (Float.isNaN(f)) {
            throw new Exception("Bad Z-matrix value: " + this.tokens[n]);
        }
        return f;
    }

    private int getAtomIndex(int n) {
        String string;
        if (n >= this.tokens.length || (string = this.tokens[n]).indexOf(".") >= 0 || !Character.isLetterOrDigit(string.charAt(0))) {
            return -1;
        }
        int n2 = this.parseInt(string);
        if (n2 <= 0 || string.length() != ("" + n2).length()) {
            Integer n3 = this.atomMap.get(string);
            if (n3 == null) {
                n = this.vAtoms.size();
                while (--n >= 0) {
                    Atom atom = this.vAtoms.get(n);
                    if (!atom.atomName.startsWith(string) || atom.atomName.length() <= string.length() || !Character.isDigit(atom.atomName.charAt(string.length()))) continue;
                    n3 = this.atomMap.get(atom.atomName);
                    break;
                }
            }
            n2 = n3 == null ? -1 : n3;
        } else {
            --n2;
        }
        return n2;
    }

    protected Atom setAtom(Atom atom, int n, int n2, int n3, float f, float f2, float f3) {
        if (Float.isNaN(f2) || Float.isNaN(f3)) {
            return null;
        }
        this.pt0.set(this.vAtoms.get(n));
        this.v1.sub(this.vAtoms.get(n2), this.pt0);
        this.v1.normalize();
        if (f3 == Float.MAX_VALUE) {
            this.v2.set(0.0f, 0.0f, 1.0f);
            new Quaternion(this.v2, f2).transform(this.v1, this.v2);
        } else if (f >= 0.0f) {
            this.v2.sub(this.vAtoms.get(n3), this.pt0);
            this.v2.cross(this.v1, this.v2);
            new Quaternion(this.v2, f2).transform(this.v1, this.v2);
            new Quaternion(this.v1, -f3).transform(this.v2, this.v2);
        } else {
            Measure.getPlaneThroughPoint(this.setAtom(atom, n, n2, n3, -f, f2, 0.0f), this.v1, this.plane1);
            Measure.getPlaneThroughPoint(this.setAtom(atom, n, n3, n2, -f, f3, 0.0f), this.v1, this.plane2);
            List<Object> list = Measure.getIntersection(this.plane1, this.plane2);
            if (list.size() == 0) {
                return null;
            }
            this.pt0.set((Point3f)list.get(0));
            f = (float)Math.sqrt(f * f - this.pt0.distanceSquared(this.vAtoms.get(n))) * Math.signum(f2) * Math.signum(f3);
            this.v2.set((Vector3f)list.get(1));
        }
        atom.scaleAdd(f, this.v2, this.pt0);
        return atom;
    }
}

