/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.adapter.readers.more.BinaryReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class BinaryDcdReader
extends BinaryReader {
    private int nModels;
    private int nAtoms;
    private int nFree;
    private BitSet bsFree;
    private float[] xAll;
    private float[] yAll;
    private float[] zAll;

    protected void initializeReader() {
        this.initializeTrajectoryFile();
    }

    protected void readDocument() throws Exception {
        int n;
        byte[] byArray = new byte[40];
        int n2 = this.doc.readInt();
        this.doc.setIsBigEndian(n2 != 84);
        n2 = this.doc.readInt();
        this.nModels = this.doc.readInt();
        this.doc.readInt();
        this.doc.readInt();
        this.doc.readInt();
        this.doc.readInt();
        this.doc.readInt();
        this.doc.readInt();
        int n3 = this.doc.readInt();
        this.nFree = n3 / 3;
        int n4 = this.doc.readInt();
        this.doc.readInt();
        this.doc.readByteArray(byArray, 0, 36);
        this.doc.readInt();
        n2 = this.doc.readInt();
        n2 = this.doc.readInt();
        n2 = this.doc.readInt();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.doc.readString(80).trim()).append('\n');
        }
        n2 = this.doc.readInt();
        Logger.info("BinaryDcdReadaer:\n" + stringBuffer);
        n2 = this.doc.readInt();
        this.nAtoms = this.doc.readInt();
        n2 = this.doc.readInt();
        this.nFree = this.nAtoms - n4;
        if (n4 != 0) {
            this.doc.readInt();
            this.bsFree = new BitSet(this.nFree);
            for (n = 0; n < this.nFree; ++n) {
                this.bsFree.set(this.doc.readInt() - 1);
            }
            n2 = this.doc.readInt() / 4;
            Logger.info("free: " + this.bsFree.cardinality() + " " + Escape.escape(this.bsFree));
        }
        this.readCoordinates();
        Logger.info("Total number of trajectory steps=" + this.trajectorySteps.size());
    }

    private float[] readFloatArray() throws Exception {
        int n = this.doc.readInt() / 4;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.doc.readFloat();
        }
        n = this.doc.readInt() / 4;
        if (Logger.debugging) {
            System.out.println(this.modelNumber + " " + this.doc.getPosition() + ": " + n + " " + fArray[0] + "\t" + fArray[1] + "\t" + fArray[2]);
        }
        return fArray;
    }

    private void readCoordinates() throws Exception {
        int n = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        for (int i = 0; i < this.nModels; ++i) {
            if (this.doGetModel(++this.modelNumber, null)) {
                Point3f[] point3fArray = new Point3f[n];
                if (!this.getTrajectoryStep(point3fArray)) {
                    return;
                }
                this.trajectorySteps.add(point3fArray);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            this.readFloatArray();
            this.readFloatArray();
            this.readFloatArray();
        }
    }

    private boolean getTrajectoryStep(Point3f[] point3fArray) throws Exception {
        try {
            BitSet bitSet;
            int n = point3fArray.length;
            int n2 = -1;
            float[] fArray = this.readFloatArray();
            float[] fArray2 = this.readFloatArray();
            float[] fArray3 = this.readFloatArray();
            BitSet bitSet2 = bitSet = this.xAll == null ? null : this.bsFree;
            if (bitSet == null) {
                this.xAll = fArray;
                this.yAll = fArray2;
                this.zAll = fArray3;
            }
            int n3 = 0;
            for (int i = 0; i < this.nAtoms; ++i) {
                Point3f point3f = new Point3f();
                if (bitSet == null || bitSet.get(i)) {
                    point3f.set(fArray[n3], fArray2[n3], fArray3[n3]);
                    ++n3;
                } else {
                    point3f.set(this.xAll[i], this.yAll[i], this.zAll[i]);
                }
                if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
                if (++n2 == n) {
                    return true;
                }
                point3fArray[n2] = point3f;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

