/*
 * Decompiled with CFR 0.152.
 */
package naga.packetreader;

import java.nio.ByteBuffer;
import naga.NIOUtils;
import naga.PacketReader;
import naga.exception.ProtocolViolationException;

public class RegularPacketReader
implements PacketReader {
    private final boolean m_bigEndian;
    private ByteBuffer m_header;
    private ByteBuffer m_content;
    private int m_contentSize = -1;

    public RegularPacketReader(int n, boolean bl) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Header must be between 1 and 4 bytes long.");
        }
        this.m_bigEndian = bl;
        this.m_header = ByteBuffer.allocate(n);
        this.m_contentSize = -1;
        this.m_content = null;
    }

    @Override
    public ByteBuffer getBuffer() throws ProtocolViolationException {
        if (this.m_header.hasRemaining()) {
            return this.m_header;
        }
        this.prepareContentBuffer();
        return this.m_content;
    }

    private void prepareContentBuffer() throws ProtocolViolationException {
        if (this.m_contentSize < 0 && !this.m_header.hasRemaining()) {
            this.m_contentSize = NIOUtils.getPacketSizeFromByteBuffer(this.m_header, this.m_bigEndian);
            if (this.m_contentSize < 0 || this.m_contentSize >= Integer.MAX_VALUE) {
                throw new ProtocolViolationException("Content size out of range, was: " + this.m_contentSize);
            }
            this.m_content = ByteBuffer.allocate(this.m_contentSize);
        }
    }

    @Override
    public byte[] getNextPacket() throws ProtocolViolationException {
        this.prepareContentBuffer();
        if (this.m_contentSize < 0 || this.m_content.hasRemaining()) {
            return null;
        }
        byte[] byArray = this.m_content.array();
        this.m_content = null;
        this.m_header.rewind();
        this.m_contentSize = -1;
        return byArray;
    }
}

