/*
 * Decompiled with CFR 0.152.
 */
package naga.packetreader;

import java.nio.ByteBuffer;
import naga.PacketReader;
import naga.exception.ProtocolViolationException;

public class DelimiterPacketReader
implements PacketReader {
    public static final int DEFAULT_READ_BUFFER_SIZE = 256;
    private ByteBuffer m_currentBuffer;
    private volatile int m_maxPacketSize;
    private byte[] m_buffer;
    private byte m_delimiter;

    public DelimiterPacketReader(byte by) {
        this(by, 256, -1);
    }

    public DelimiterPacketReader(byte by, int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Min buffer must at least be 1 byte.");
        }
        if (n2 > -1 && n > n2) {
            throw new IllegalArgumentException("Read buffer cannot be be larger than the max packet size.");
        }
        this.m_currentBuffer = ByteBuffer.allocate(n);
        this.m_buffer = null;
        this.m_delimiter = by;
        this.m_maxPacketSize = n2;
    }

    public int getMaxPacketSize() {
        return this.m_maxPacketSize;
    }

    public void setMaxPacketSize(int n) {
        this.m_maxPacketSize = n;
    }

    @Override
    public ByteBuffer getBuffer() throws ProtocolViolationException {
        if (this.m_maxPacketSize > -1 && this.m_buffer != null && this.m_buffer.length > this.m_maxPacketSize) {
            throw new ProtocolViolationException("Packet size exceeds " + this.m_maxPacketSize);
        }
        return this.m_currentBuffer;
    }

    @Override
    public byte[] getNextPacket() throws ProtocolViolationException {
        byte[] byArray;
        int n;
        if (this.m_currentBuffer.position() > 0) {
            this.m_currentBuffer.flip();
            n = this.m_buffer == null ? 0 : this.m_buffer.length;
            byArray = new byte[n + this.m_currentBuffer.remaining()];
            if (this.m_buffer != null) {
                System.arraycopy(this.m_buffer, 0, byArray, 0, this.m_buffer.length);
            }
            this.m_currentBuffer.get(byArray, n, this.m_currentBuffer.remaining());
            this.m_currentBuffer.clear();
            this.m_buffer = byArray;
        }
        if (this.m_buffer == null) {
            return null;
        }
        for (n = 0; n < this.m_buffer.length; ++n) {
            if (this.m_buffer[n] != this.m_delimiter) continue;
            byArray = new byte[n];
            System.arraycopy(this.m_buffer, 0, byArray, 0, n);
            if (n > this.m_buffer.length - 2) {
                this.m_buffer = null;
            } else {
                byte[] byArray2 = new byte[this.m_buffer.length - n - 1];
                System.arraycopy(this.m_buffer, n + 1, byArray2, 0, byArray2.length);
                this.m_buffer = byArray2;
            }
            return byArray;
        }
        return null;
    }
}

