/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import naga.ChannelResponder;
import naga.NIOService;
import naga.NIOSocket;
import naga.PacketReader;
import naga.PacketWriter;
import naga.SocketObserver;
import naga.packetreader.RawPacketReader;
import naga.packetwriter.RawPacketWriter;

class SocketChannelResponder
extends ChannelResponder
implements NIOSocket {
    private static final byte[] CLOSE_PACKET = new byte[0];
    private static final IOException CLOSE_EXCEPTION = new IOException("CLOSE");
    private int m_bytesRead;
    private int m_bytesWritten;
    private int m_maxQueueSize = -1;
    private long m_timeOpened = -1L;
    private final AtomicLong m_bytesInQueue;
    private ConcurrentLinkedQueue<byte[]> m_packetQueue;
    private PacketReader m_packetReader;
    private PacketWriter m_packetWriter = new RawPacketWriter();
    private volatile SocketObserver m_socketObserver = null;

    public SocketChannelResponder(NIOService nIOService, SocketChannel socketChannel, InetSocketAddress inetSocketAddress) {
        super(nIOService, socketChannel, inetSocketAddress);
        this.m_packetReader = new RawPacketReader();
        this.m_bytesInQueue = new AtomicLong(0L);
        this.m_packetQueue = new ConcurrentLinkedQueue();
    }

    @Override
    void keyInitialized() {
        if (!this.isConnected()) {
            this.addInterest(8);
        }
    }

    @Override
    public void closeAfterWrite() {
        this.m_packetQueue.offer(CLOSE_PACKET);
        this.addInterest(4);
    }

    @Override
    public boolean write(byte[] byArray) {
        if (byArray.length == 0) {
            return true;
        }
        long l = this.m_bytesInQueue.addAndGet(byArray.length);
        if (this.m_maxQueueSize > 0 && l > (long)this.m_maxQueueSize) {
            this.m_bytesInQueue.addAndGet(-byArray.length);
            return false;
        }
        this.m_packetQueue.offer(byArray);
        this.addInterest(4);
        return true;
    }

    public boolean isConnected() {
        return this.getChannel().isConnected();
    }

    @Override
    public void socketReadyForRead() {
        if (!this.isOpen()) {
            return;
        }
        try {
            int n;
            if (!this.isConnected()) {
                throw new IOException("Channel not connected.");
            }
            while ((n = this.getChannel().read(this.m_packetReader.getBuffer())) > 0) {
                byte[] byArray;
                this.m_bytesRead += n;
                while ((byArray = this.m_packetReader.getNextPacket()) != null) {
                    this.m_socketObserver.packetReceived(this, byArray);
                }
            }
            if (n < 0) {
                throw new EOFException("Buffer read -1");
            }
        }
        catch (Exception exception) {
            this.close(exception);
        }
    }

    private void fillCurrentOutgoingBuffer() throws IOException {
        if (this.m_packetWriter.isEmpty()) {
            byte[] byArray = this.m_packetQueue.poll();
            if (byArray == CLOSE_PACKET) {
                throw CLOSE_EXCEPTION;
            }
            if (byArray != null) {
                this.m_packetWriter.setPacket(byArray);
                this.m_bytesInQueue.addAndGet(-byArray.length);
            }
        }
    }

    @Override
    public void socketReadyForWrite() {
        try {
            this.deleteInterest(4);
            if (!this.isOpen()) {
                return;
            }
            this.fillCurrentOutgoingBuffer();
            if (this.m_packetWriter.isEmpty()) {
                return;
            }
            while (!this.m_packetWriter.isEmpty()) {
                int n = this.getChannel().write(this.m_packetWriter.getBuffer());
                this.m_bytesWritten += n;
                if (n == 0) {
                    this.addInterest(4);
                    return;
                }
                if (!this.m_packetWriter.isEmpty()) continue;
                this.fillCurrentOutgoingBuffer();
            }
        }
        catch (Exception exception) {
            this.close(exception == CLOSE_EXCEPTION ? null : exception);
        }
    }

    @Override
    public void socketReadyForConnect() {
        try {
            if (!this.isOpen()) {
                return;
            }
            if (this.getChannel().finishConnect()) {
                this.deleteInterest(8);
                this.m_timeOpened = System.currentTimeMillis();
                this.notifyObserverOfConnect();
            }
        }
        catch (Exception exception) {
            this.close(exception);
        }
    }

    public void notifyWasCancelled() {
        this.close();
    }

    public Socket getSocket() {
        return this.getChannel().socket();
    }

    @Override
    public long getBytesRead() {
        return this.m_bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.m_bytesWritten;
    }

    @Override
    public long getTimeOpen() {
        return this.m_timeOpened > 0L ? System.currentTimeMillis() - this.m_timeOpened : -1L;
    }

    @Override
    public long getWriteQueueSize() {
        return this.m_bytesInQueue.get();
    }

    @Override
    public String toString() {
        try {
            return this.getSocket().toString();
        }
        catch (Exception exception) {
            return "Closed NIO Socket";
        }
    }

    @Override
    public int getMaxQueueSize() {
        return this.m_maxQueueSize;
    }

    @Override
    public void setMaxQueueSize(int n) {
        this.m_maxQueueSize = n;
    }

    @Override
    public void listen(SocketObserver socketObserver) {
        this.markObserverSet();
        this.getNIOService().queue(new BeginListenEvent(this, socketObserver == null ? SocketObserver.NULL : socketObserver));
    }

    private void notifyObserverOfConnect() {
        if (this.m_socketObserver == null) {
            return;
        }
        try {
            this.m_socketObserver.connectionOpened(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void notifyObserverOfDisconnect(Exception exception) {
        if (this.m_socketObserver == null) {
            return;
        }
        try {
            this.m_socketObserver.connectionBroken(this, exception);
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    @Override
    public void setPacketReader(PacketReader packetReader) {
        this.m_packetReader = packetReader;
    }

    @Override
    public void setPacketWriter(PacketWriter packetWriter) {
        this.m_packetWriter = packetWriter;
    }

    @Override
    public SocketChannel getChannel() {
        return (SocketChannel)super.getChannel();
    }

    @Override
    protected void shutdown(Exception exception) {
        this.m_timeOpened = -1L;
        this.m_packetQueue.clear();
        this.m_bytesInQueue.set(0L);
        this.notifyObserverOfDisconnect(exception);
    }

    @Override
    public Socket socket() {
        return this.getChannel().socket();
    }

    private class BeginListenEvent
    implements Runnable {
        private final SocketObserver m_newObserver;
        private final SocketChannelResponder m_responder;

        private BeginListenEvent(SocketChannelResponder socketChannelResponder2, SocketObserver socketObserver) {
            this.m_responder = socketChannelResponder2;
            this.m_newObserver = socketObserver;
        }

        @Override
        public void run() {
            this.m_responder.m_socketObserver = this.m_newObserver;
            if (this.m_responder.isConnected()) {
                this.m_responder.notifyObserverOfConnect();
            }
            if (!this.m_responder.isOpen()) {
                this.m_responder.notifyObserverOfDisconnect(null);
            }
            this.m_responder.addInterest(1);
        }

        public String toString() {
            return "BeginListen[" + this.m_newObserver + "]";
        }
    }
}

