/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jspecview.common.Coordinate;
import jspecview.common.JDXDataObject;
import jspecview.common.JDXHeader;
import jspecview.common.JDXSpectrum;
import jspecview.common.PeakInfo;
import jspecview.exception.JDXSourceException;
import jspecview.exception.JSpecViewException;
import jspecview.source.AnIMLReader;
import jspecview.source.CMLReader;
import jspecview.source.JDXDecompressor;
import jspecview.source.JDXSource;
import jspecview.source.JDXSourceStreamTokenizer;
import jspecview.util.Escape;
import jspecview.util.FileManager;
import jspecview.util.Logger;
import jspecview.util.Parser;
import jspecview.util.ZipFileSequentialReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReader {
    public static final String[][] VAR_LIST_TABLE = new String[][]{{"PEAKTABLE", "XYDATA", "XYPOINTS"}, {"(XY..XY)", "(X++(Y..Y))", "(XY..XY)"}};
    static final String ERROR_SEPARATOR = "=====================\n";
    private static final String[] TABULAR_DATA_LABELS = new String[]{"##XYDATA", "##XYPOINTS", "##PEAKTABLE", "##DATATABLE", "##PEAKASSIGNMENTS"};
    private JDXSource source;
    private JDXSourceStreamTokenizer t;
    private StringBuffer errorLog;
    private boolean obscure;
    private boolean done;
    private boolean isZipFile;
    private String filePath;
    private boolean loadImaginary = true;
    private int firstSpec = 0;
    private int lastSpec = 0;
    private int nSpec = 0;
    private double blockID;
    private String piUnitsX;
    private String piUnitsY;

    static {
        Arrays.sort(TABULAR_DATA_LABELS);
    }

    private FileReader(String filePath, boolean obscure, boolean loadImaginary, int iSpecFirst, int iSpecLast) {
        this.filePath = filePath == null ? "string data" : filePath;
        this.obscure = obscure;
        this.firstSpec = iSpecFirst;
        this.lastSpec = iSpecLast;
        this.loadImaginary = loadImaginary;
    }

    public static JDXSource createJDXSource(InputStream in, boolean obscure, boolean loadImaginary) throws IOException, JSpecViewException {
        return FileReader.createJDXSource(FileManager.getBufferedReaderForInputStream(in), null, null, obscure, loadImaginary, -1, -1);
    }

    public static JDXSource createJDXSource(BufferedReader br, String filePath, URL appletDocumentBase, boolean obscure, boolean loadImaginary, int iSpecFirst, int iSpecLast) throws IOException, JSpecViewException {
        try {
            if (filePath != null) {
                br = FileManager.getBufferedReaderFromName(filePath, appletDocumentBase, "##TITLE");
            }
            br.mark(400);
            char[] chs = new char[400];
            br.read(chs);
            br.reset();
            String header = new String(chs);
            int pt1 = header.indexOf(35);
            int pt2 = header.indexOf(60);
            if (pt1 < 0 || pt2 >= 0 && pt2 < pt1) {
                JDXSource xmlSource = FileReader.getXMLSource(filePath, header, br);
                br.close();
                if (xmlSource != null) {
                    return xmlSource;
                }
                throw new JSpecViewException("File type not recognized");
            }
            return new FileReader(filePath, obscure, loadImaginary, iSpecFirst, iSpecLast).getJDXSource(br);
        }
        catch (JSpecViewException e) {
            br.close();
            throw new JSpecViewException("Error reading JDX format: " + e.getMessage());
        }
    }

    private static JDXSource getXMLSource(String filePath, String header, BufferedReader br) {
        String xmlType = header.toLowerCase();
        if (xmlType.contains("<animl") || xmlType.contains("<!doctype technique")) {
            return AnIMLReader.getAniMLInstance(filePath, br);
        }
        if (xmlType.contains("xml-cml")) {
            return CMLReader.getCMLInstance(filePath, br);
        }
        return null;
    }

    private JDXSource getJDXSource(BufferedReader br) throws JSpecViewException {
        this.source = new JDXSource(0, this.filePath);
        this.isZipFile = br instanceof ZipFileSequentialReader;
        this.t = new JDXSourceStreamTokenizer(br);
        this.errorLog = new StringBuffer();
        String label = null;
        while (!this.done && "##TITLE".equals(this.t.peakLabel())) {
            if (label != null && !this.isZipFile) {
                this.errorLog.append("Warning - file is a concatenation without LINK record -- does not conform to IUPAC standards!\n");
            }
            JDXSpectrum spectrum = new JDXSpectrum();
            ArrayList<String[]> dataLDRTable = new ArrayList<String[]>(20);
            while (!this.done && (label = this.t.getLabel()) != null && !this.isEnd(label)) {
                if (label.equals("##DATATYPE") && this.t.getValue().toUpperCase().equals("LINK")) {
                    this.getBlockSpectra(dataLDRTable);
                    spectrum = null;
                    continue;
                }
                if (label.equals("##NTUPLES") || label.equals("##VARNAME")) {
                    this.getNTupleSpectra(dataLDRTable, spectrum, label);
                    spectrum = null;
                    continue;
                }
                if (Arrays.binarySearch(TABULAR_DATA_LABELS, label) > 0) {
                    this.setTabularDataType(spectrum, label);
                    if (!this.processTabularData(spectrum, dataLDRTable)) {
                        throw new JDXSourceException("Unable to read JDX file");
                    }
                    this.addSpectrum(spectrum, false);
                    spectrum = null;
                    continue;
                }
                if (spectrum == null) {
                    spectrum = new JDXSpectrum();
                }
                if (FileReader.readDataLabel(spectrum, label, this.t, this.errorLog, this.obscure)) continue;
                String value = this.t.getValue();
                FileReader.addHeader(dataLDRTable, this.t.getRawLabel(), value);
                if (!label.equals("##$PEAKS")) continue;
                this.source.peakCount += spectrum.setPeakList(this.readPeakList(value, this.source.peakCount), this.piUnitsX, this.piUnitsY);
            }
        }
        this.source.setErrorLog(this.errorLog.toString());
        return this.source;
    }

    private boolean isEnd(String label) {
        if (!label.equals("##END")) {
            return false;
        }
        this.t.getValue();
        return true;
    }

    private boolean addSpectrum(JDXSpectrum spectrum, boolean forceSub) {
        if (!this.loadImaginary && spectrum.isImaginary()) {
            Logger.info("FileReader skipping imaginary spectrum -- use LOADIMAGINARY TRUE to load this spectrum.");
            return true;
        }
        ++this.nSpec;
        if (this.firstSpec > 0 && this.nSpec < this.firstSpec) {
            return true;
        }
        if (this.lastSpec > 0 && this.nSpec > this.lastSpec) {
            this.done = true;
            return !true;
        }
        spectrum.setBlockID(this.blockID);
        this.source.addJDXSpectrum(null, spectrum, forceSub);
        return true;
    }

    private JDXSource getBlockSpectra(List<String[]> sourceLDRTable) throws JSpecViewException {
        Logger.debug("--JDX block start--");
        String label = "";
        boolean isNew = this.source.type == 0;
        boolean forceSub = false;
        while ((label = this.t.getLabel()) != null && !label.equals("##TITLE")) {
            int nBlocks;
            if (isNew) {
                if (!FileReader.readHeaderLabel(this.source, label, this.t, this.errorLog, this.obscure)) {
                    FileReader.addHeader(sourceLDRTable, this.t.getRawLabel(), this.t.getValue());
                }
            } else {
                this.t.getValue();
            }
            if (!label.equals("##BLOCKS") || (nBlocks = Parser.parseInt(this.t.getValue())) <= 100 || this.firstSpec > 0) continue;
            forceSub = true;
        }
        if (!label.equals("##TITLE")) {
            throw new JSpecViewException("Unable to read block source");
        }
        if (isNew) {
            this.source.setHeaderTable(sourceLDRTable);
        }
        this.source.type = 1;
        this.source.isCompoundSource = true;
        JDXSpectrum spectrum = new JDXSpectrum();
        ArrayList<Object> dataLDRTable = new ArrayList<String[]>();
        FileReader.readDataLabel(spectrum, label, this.t, this.errorLog, this.obscure);
        try {
            String tmp;
            while ((tmp = this.t.getLabel()) != null) {
                if (label.equals("##END") && this.isEnd(tmp)) {
                    Logger.debug("##END= " + this.t.getValue());
                } else {
                    label = tmp;
                    if (Arrays.binarySearch(TABULAR_DATA_LABELS, label) > 0) {
                        this.setTabularDataType(spectrum, label);
                        if (this.processTabularData(spectrum, dataLDRTable)) continue;
                        throw new JDXSourceException("Unable to read Block Source");
                    }
                    if (label.equals("##DATATYPE") && this.t.getValue().toUpperCase().equals("LINK")) {
                        this.getBlockSpectra(dataLDRTable);
                        spectrum = null;
                        label = null;
                    } else if (label.equals("##NTUPLES") || label.equals("##VARNAME")) {
                        this.getNTupleSpectra(dataLDRTable, spectrum, label);
                        spectrum = null;
                        label = "";
                    } else if (label.equals("##JCAMPCS")) {
                        while (!(label = this.t.getLabel()).equals("##TITLE")) {
                            this.t.getValue();
                        }
                        spectrum = null;
                    } else {
                        this.t.getValue();
                    }
                    if (!this.done) {
                        if (spectrum == null) {
                            spectrum = new JDXSpectrum();
                            dataLDRTable = new ArrayList();
                            if (label == "") continue;
                            if (label == null) {
                                label = "##END";
                                continue;
                            }
                        }
                        if (FileReader.readDataLabel(spectrum, label, this.t, this.errorLog, this.obscure)) continue;
                        if (this.isEnd(label)) {
                            if (spectrum.getXYCoords().length > 0 && !this.addSpectrum(spectrum, forceSub)) {
                                return this.source;
                            }
                            spectrum = new JDXSpectrum();
                            dataLDRTable = new ArrayList();
                            this.t.getValue();
                            continue;
                        }
                        String value = this.t.getValue();
                        FileReader.addHeader(dataLDRTable, this.t.getRawLabel(), value);
                        if (!label.equals("##$PEAKS")) continue;
                        this.source.peakCount += spectrum.setPeakList(this.readPeakList(value, this.source.peakCount), this.piUnitsX, this.piUnitsY);
                        continue;
                    }
                }
                break;
            }
        }
        catch (NoSuchElementException nsee) {
            throw new JSpecViewException("Unable to Read Block Source");
        }
        catch (JSpecViewException jsve) {
            throw jsve;
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.debug("--JDX block end--");
        return this.source;
    }

    private void addErrorLogSeparator() {
        if (this.errorLog.length() > 0 && this.errorLog.lastIndexOf(ERROR_SEPARATOR) != this.errorLog.length() - ERROR_SEPARATOR.length()) {
            this.errorLog.append(ERROR_SEPARATOR);
        }
    }

    private JDXSource getNTupleSpectra(List<String[]> sourceLDRTable, JDXDataObject spectrum0, String label) throws JSpecViewException {
        boolean isNew;
        boolean isVARNAME;
        double[] minMaxY = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        this.blockID = Math.random();
        boolean isOK = true;
        if (this.firstSpec > 0) {
            spectrum0.numDim = 1;
        }
        if (!(isVARNAME = label.equals("##VARNAME"))) {
            label = "";
            this.t.getValue();
        }
        Hashtable<String, ArrayList<String>> nTupleTable = new Hashtable<String, ArrayList<String>>();
        String[] plotSymbols = new String[2];
        boolean bl = isNew = this.source.type == 0;
        if (isNew) {
            this.source.type = 2;
            this.source.isCompoundSource = true;
            this.source.setHeaderTable(sourceLDRTable);
        }
        while (!(label = isVARNAME ? label : this.t.getLabel()).equals("##PAGE")) {
            isVARNAME = false;
            StringTokenizer st = new StringTokenizer(this.t.getValue(), ",");
            ArrayList<String> attrList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                attrList.add(st.nextToken().trim());
            }
            nTupleTable.put(label, attrList);
        }
        ArrayList symbols = (ArrayList)nTupleTable.get("##SYMBOL");
        if (!label.equals("##PAGE")) {
            throw new JSpecViewException("Error Reading NTuple Source");
        }
        String page = this.t.getValue();
        JDXSpectrum spectrum = null;
        boolean isFirst = true;
        while (!this.done) {
            label = this.t.getLabel();
            if (label.equals("##ENDNTUPLES")) {
                this.t.getValue();
                break;
            }
            if (label.equals("##PAGE")) {
                page = this.t.getValue();
                continue;
            }
            if (spectrum == null) {
                int pt;
                spectrum = new JDXSpectrum();
                spectrum0.copyTo(spectrum);
                spectrum.setTitle(spectrum0.getTitle());
                if (!spectrum.is1D() && (pt = page.indexOf(61)) >= 0) {
                    try {
                        spectrum.setY2D(Double.parseDouble(page.substring(pt + 1).trim()));
                        String y2dUnits = page.substring(0, pt).trim();
                        int i = symbols.indexOf(y2dUnits);
                        if (i >= 0) {
                            spectrum.setY2DUnits((String)((ArrayList)nTupleTable.get("##UNITS")).get(i));
                        }
                    }
                    catch (Exception y2dUnits) {
                        // empty catch block
                    }
                }
            }
            ArrayList<String[]> dataLDRTable = new ArrayList<String[]>();
            spectrum.setHeaderTable(dataLDRTable);
            while (!label.equals("##DATATABLE")) {
                FileReader.addHeader(dataLDRTable, this.t.getRawLabel(), this.t.getValue());
                label = this.t.getLabel();
            }
            boolean continuous = true;
            String line = this.t.flushLine();
            if (line.trim().indexOf("PEAKS") > 0) {
                continuous = false;
            }
            int index1 = line.indexOf(40);
            int index2 = line.lastIndexOf(41);
            if (index1 == -1 || index2 == -1) {
                throw new JDXSourceException("Variable List not Found");
            }
            String varList = line.substring(index1, index2 + 1);
            int countSyms = 0;
            int i = 0;
            while (i < symbols.size()) {
                String sym = ((String)symbols.get(i)).trim();
                if (varList.indexOf(sym) != -1) {
                    plotSymbols[countSyms++] = sym;
                }
                if (countSyms == 2) break;
                ++i;
            }
            this.setTabularDataType(spectrum, "##" + (continuous ? "XYDATA" : "PEAKTABLE"));
            if (!this.readNTUPLECoords(spectrum, nTupleTable, plotSymbols, minMaxY)) {
                throw new JDXSourceException("Unable to read Ntuple Source");
            }
            if (!spectrum.nucleusX.equals("?")) {
                spectrum0.nucleusX = spectrum.nucleusX;
            }
            spectrum0.nucleusY = spectrum.nucleusY;
            spectrum0.freq2dX = spectrum.freq2dX;
            spectrum0.freq2dY = spectrum.freq2dY;
            spectrum0.y2DUnits = spectrum.y2DUnits;
            i = 0;
            while (i < sourceLDRTable.size()) {
                String[] entry = sourceLDRTable.get(i);
                String key = JDXSourceStreamTokenizer.cleanLabel(entry[0]);
                if (!(key.equals("##TITLE") || key.equals("##DATACLASS") || key.equals("##NTUPLES"))) {
                    dataLDRTable.add(entry);
                }
                ++i;
            }
            if (isOK) {
                this.addSpectrum(spectrum, !isFirst);
            }
            isFirst = false;
            spectrum = null;
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.info("NTUPLE MIN/MAX Y = " + minMaxY[0] + " " + minMaxY[1]);
        return this.source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<PeakInfo> readPeakList(String peakList, int index) {
        ArrayList<PeakInfo> peakData = new ArrayList<PeakInfo>();
        BufferedReader reader = new BufferedReader(new StringReader(peakList));
        try {
            String line = FileReader.discardLinesUntilContains(reader, "<Peaks");
            String type = Parser.getQuotedAttribute(line, "type");
            this.piUnitsX = Parser.getQuotedAttribute(line, "xLabel");
            this.piUnitsY = Parser.getQuotedAttribute(line, "yLabel");
            String path = Escape.escape(this.filePath.replace('\\', '/'));
            while (true) {
                line = reader.readLine();
                if (line == null) return peakData;
                if ((line = line.trim()).startsWith("</Peaks>")) {
                    return peakData;
                }
                if (!line.startsWith("<PeakData")) continue;
                String stringInfo = "<PeakData file=" + path + " index=\"" + ++index + "\" type=\"" + type + "\" " + line.substring(9).trim();
                Logger.info("JSpecView found " + stringInfo);
                PeakInfo peak = new PeakInfo(stringInfo);
                peakData.add(peak);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return peakData;
    }

    private static String discardLinesUntilContains(BufferedReader reader, String containsMatch) throws Exception {
        String line = reader.readLine();
        while (line != null && line.indexOf(containsMatch) < 0) {
        }
        return line;
    }

    private static boolean readDataLabel(JDXDataObject spectrum, String label, JDXSourceStreamTokenizer t, StringBuffer errorLog, boolean obscure) {
        if (FileReader.readHeaderLabel(spectrum, label, t, errorLog, obscure)) {
            return true;
        }
        if (label.equals("##MINX") || label.equals("##MINY") || label.equals("##MAXX") || label.equals("##MAXY") || label.equals("##FIRSTY") || label.equals("##DELTAX") || label.equals("##DATACLASS")) {
            t.getValue();
            return true;
        }
        if (label.equals("##FIRSTX")) {
            spectrum.fileFirstX = Double.parseDouble(t.getValue());
            return true;
        }
        if (label.equals("##LASTX")) {
            spectrum.fileLastX = Double.parseDouble(t.getValue());
            return true;
        }
        if (label.equals("##NPOINTS")) {
            spectrum.nPointsFile = Integer.parseInt(t.getValue());
            return true;
        }
        if (label.equals("##XFACTOR")) {
            spectrum.xFactor = Double.parseDouble(t.getValue());
            return true;
        }
        if (label.equals("##YFACTOR")) {
            spectrum.yFactor = Double.parseDouble(t.getValue());
            return true;
        }
        if (label.equals("##XUNITS")) {
            spectrum.setXUnits(t.getValue());
            return true;
        }
        if (label.equals("##YUNITS")) {
            spectrum.setYUnits(t.getValue());
            return true;
        }
        if (label.equals("##XLABEL")) {
            spectrum.setXLabel(t.getValue());
            return false;
        }
        if (label.equals("##YLABEL")) {
            spectrum.setYLabel(t.getValue());
            return false;
        }
        if (label.equals("##NUMDIM")) {
            spectrum.numDim = Integer.parseInt(t.getValue());
            return true;
        }
        if (label.equals("##.OBSERVEFREQUENCY")) {
            spectrum.observedFreq = Double.parseDouble(t.getValue());
            return true;
        }
        if (label.equals("##.OBSERVENUCLEUS")) {
            spectrum.setObservedNucleus(t.getValue());
            return true;
        }
        if (label.equals("##$OFFSET") && spectrum.shiftRefType != 0) {
            if (spectrum.offset == Double.MAX_VALUE) {
                spectrum.offset = Double.parseDouble(t.getValue());
            }
            spectrum.dataPointNum = 1;
            spectrum.shiftRefType = 1;
            return false;
        }
        if (label.equals("##$REFERENCEPOINT") && spectrum.shiftRefType != 0) {
            spectrum.offset = Double.parseDouble(t.getValue());
            spectrum.dataPointNum = 1;
            spectrum.shiftRefType = 2;
            return false;
        }
        if (label.equals("##.SHIFTREFERENCE")) {
            String val = t.getValue();
            if (!spectrum.dataType.toUpperCase().contains("SPECTRUM")) {
                return true;
            }
            StringTokenizer srt = new StringTokenizer(val, ",");
            if (srt.countTokens() != 4) {
                return true;
            }
            try {
                srt.nextToken();
                srt.nextToken();
                spectrum.dataPointNum = Integer.parseInt(srt.nextToken().trim());
                spectrum.offset = Double.parseDouble(srt.nextToken().trim());
            }
            catch (NumberFormatException nfe) {
                return true;
            }
            catch (NoSuchElementException nsee) {
                return true;
            }
            if (spectrum.dataPointNum <= 0) {
                spectrum.dataPointNum = 1;
            }
            spectrum.shiftRefType = 0;
            return true;
        }
        return false;
    }

    private static boolean readHeaderLabel(JDXHeader jdxHeader, String label, JDXSourceStreamTokenizer t, StringBuffer errorLog, boolean obscure) {
        if (label.equals("##TITLE")) {
            String value = t.getValue();
            jdxHeader.setTitle(obscure || value == null || value.equals("") ? "Unknown" : value);
            return true;
        }
        if (label.equals("##JCAMPDX")) {
            String value;
            jdxHeader.jcampdx = value = t.getValue();
            float version = Parser.parseFloat(value);
            if (((double)version >= 6.0 || Float.isNaN(version)) && errorLog != null) {
                errorLog.append("Warning: JCAMP-DX version may not be fully supported: " + value + "\n");
            }
            return true;
        }
        if (label.equals("##ORIGIN")) {
            String value = t.getValue();
            jdxHeader.origin = value != null && !value.equals("") ? value : "Unknown";
            return true;
        }
        if (label.equals("##OWNER")) {
            String value = t.getValue();
            jdxHeader.owner = value != null && !value.equals("") ? value : "Unknown";
            return true;
        }
        if (label.equals("##DATATYPE")) {
            jdxHeader.dataType = t.getValue();
            return true;
        }
        if (label.equals("##LONGDATE")) {
            jdxHeader.longDate = t.getValue();
            return true;
        }
        if (label.equals("##DATE")) {
            jdxHeader.date = t.getValue();
            return true;
        }
        if (label.equals("##TIME")) {
            jdxHeader.time = t.getValue();
            return true;
        }
        return false;
    }

    private void setTabularDataType(JDXDataObject spectrum, String label) {
        if (label.equals("##PEAKASSIGNMENTS")) {
            spectrum.setDataClass("PEAKASSIGNMENTS");
        } else if (label.equals("##PEAKTABLE")) {
            spectrum.setDataClass("PEAKTABLE");
        } else if (label.equals("##XYDATA")) {
            spectrum.setDataClass("XYDATA");
        } else if (label.equals("##XYPOINTS")) {
            spectrum.setDataClass("XYPOINTS");
        }
    }

    private boolean processTabularData(JDXDataObject spec, List<String[]> table) throws JSpecViewException {
        if (spec.dataClass.equals("PEAKASSIGNMENTS")) {
            return true;
        }
        spec.setHeaderTable(table);
        if (spec.dataClass.equals("XYDATA")) {
            spec.checkRequiredTokens();
            this.decompressData(spec, null);
            return true;
        }
        if (spec.dataClass.equals("PEAKTABLE") || spec.dataClass.equals("XYPOINTS")) {
            spec.setContinuous(spec.dataClass.equals("XYPOINTS"));
            try {
                this.t.readLineTrimmed();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Coordinate[] xyCoords = spec.xFactor != Double.MAX_VALUE && spec.yFactor != Double.MAX_VALUE ? Coordinate.parseDSV(this.t.getValue(), spec.xFactor, spec.yFactor) : Coordinate.parseDSV(this.t.getValue(), 1.0, 1.0);
            spec.setXYCoords(xyCoords);
            double fileDeltaX = Coordinate.deltaX(xyCoords[xyCoords.length - 1].getXVal(), xyCoords[0].getXVal(), xyCoords.length);
            spec.setIncreasing(fileDeltaX > 0.0);
            return true;
        }
        return false;
    }

    private boolean readNTUPLECoords(JDXDataObject spec, Map<String, ArrayList<String>> nTupleTable, String[] plotSymbols, double[] minMaxY) {
        if (spec.dataClass.equals("XYDATA")) {
            ArrayList<String> list = nTupleTable.get("##SYMBOL");
            int index1 = list.indexOf(plotSymbols[0]);
            int index2 = list.indexOf(plotSymbols[1]);
            list = nTupleTable.get("##VARNAME");
            spec.varName = list.get(index2).toUpperCase();
            list = nTupleTable.get("##FACTOR");
            spec.xFactor = Double.parseDouble(list.get(index1));
            spec.yFactor = Double.parseDouble(list.get(index2));
            list = nTupleTable.get("##LAST");
            spec.fileLastX = Double.parseDouble(list.get(index1));
            list = nTupleTable.get("##FIRST");
            spec.fileFirstX = Double.parseDouble(list.get(index1));
            list = nTupleTable.get("##VARDIM");
            spec.nPointsFile = Integer.parseInt(list.get(index1));
            list = nTupleTable.get("##UNITS");
            spec.setXUnits(list.get(index1));
            spec.setYUnits(list.get(index2));
            if (spec.nucleusX == null && (list = nTupleTable.get("##.NUCLEUS")) != null) {
                spec.setNucleus(list.get(0), false);
                spec.setNucleus(list.get(index1), true);
            } else if (spec.nucleusX == null) {
                spec.nucleusX = "?";
            }
            this.decompressData(spec, minMaxY);
            return true;
        }
        if (spec.dataClass.equals("PEAKTABLE") || spec.dataClass.equals("XYPOINTS")) {
            spec.setContinuous(spec.dataClass.equals("XYPOINTS"));
            ArrayList<String> list = nTupleTable.get("##SYMBOL");
            int index1 = list.indexOf(plotSymbols[0]);
            int index2 = list.indexOf(plotSymbols[1]);
            list = nTupleTable.get("##UNITS");
            spec.setXUnits(list.get(index1));
            spec.setYUnits(list.get(index2));
            spec.setXYCoords(Coordinate.parseDSV(this.t.getValue(), spec.xFactor, spec.yFactor));
            return true;
        }
        return false;
    }

    private void decompressData(JDXDataObject spec, double[] minMaxY) {
        double freq;
        int errPt = this.errorLog.length();
        double fileDeltaX = Coordinate.deltaX(spec.fileLastX, spec.fileFirstX, spec.nPointsFile);
        spec.setIncreasing(fileDeltaX > 0.0);
        spec.setContinuous(true);
        JDXDecompressor decompressor = new JDXDecompressor(this.t, spec.fileFirstX, spec.xFactor, spec.yFactor, fileDeltaX, spec.nPointsFile);
        double[] firstLastX = new double[2];
        Coordinate[] xyCoords = decompressor.decompressData(this.errorLog, firstLastX);
        spec.setXYCoords(xyCoords);
        double d = decompressor.getMinY();
        if (minMaxY != null) {
            if (d < minMaxY[0]) {
                minMaxY[0] = d;
            }
            if ((d = decompressor.getMaxY()) > minMaxY[1]) {
                minMaxY[1] = d;
            }
        }
        double d2 = freq = Double.isNaN(spec.freq2dX) ? spec.observedFreq : spec.freq2dX;
        if (spec.offset != Double.MAX_VALUE && freq != Double.MAX_VALUE && spec.dataType.toUpperCase().contains("SPECTRUM")) {
            Coordinate.applyShiftReference(xyCoords, spec.dataPointNum, spec.fileFirstX, spec.fileLastX, spec.offset, freq, spec.shiftRefType);
        }
        if (freq != Double.MAX_VALUE && spec.getXUnits().toUpperCase().equals("HZ")) {
            double xScale = freq;
            Coordinate.applyScale(xyCoords, 1.0 / xScale, 1.0);
            spec.setXUnits("PPM");
            spec.setHZtoPPM(true);
        }
        if (this.errorLog.length() != errPt) {
            this.errorLog.append(spec.getTitle()).append("\n");
            this.errorLog.append("firstX: " + spec.fileFirstX + " Found " + firstLastX[0] + "\n");
            this.errorLog.append("lastX from Header " + spec.fileLastX + " Found " + firstLastX[1] + "\n");
            this.errorLog.append("deltaX from Header " + fileDeltaX + "\n");
            this.errorLog.append("Number of points in Header " + spec.nPointsFile + " Found " + xyCoords.length + "\n");
        }
        if (Logger.debugging) {
            System.err.println(this.errorLog.toString());
        }
    }

    public static void addHeader(List<String[]> table, String label, String value) {
        int i = 0;
        while (i < table.size()) {
            String[] entry = table.get(i);
            if (entry[0].equals(label)) {
                entry[1] = value;
                return;
            }
            ++i;
        }
        table.add(new String[]{label, value, JDXSourceStreamTokenizer.cleanLabel(label)});
    }
}

