/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jspecview.common.Annotation;
import jspecview.common.AnnotationData;
import jspecview.common.JDXSpectrum;
import jspecview.common.Measurement;
import jspecview.common.Parameters;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementData
extends ArrayList<Measurement>
implements AnnotationData {
    private static final long serialVersionUID = 1L;
    private Annotation.AType type;
    protected JDXSpectrum spec;
    private boolean isON = true;
    protected Parameters myParams = new Parameters("MeasurementData");
    protected DecimalFormat df;
    private static final String[] HEADER = new String[]{"peak", "start", "end", "value"};
    protected String units;
    private String key;

    @Override
    public Annotation.AType getAType() {
        return this.type;
    }

    @Override
    public boolean getState() {
        return this.isON;
    }

    @Override
    public void setState(boolean b) {
        this.isON = b;
    }

    MeasurementData(Annotation.AType type, JDXSpectrum spec) {
        this.type = type;
        this.spec = spec;
    }

    List<Measurement> getMeasurements() {
        return this;
    }

    void setMeasurements(List<Measurement> measurements) {
    }

    @Override
    public Parameters getParameters() {
        return this.myParams;
    }

    String[] getDataHeader() {
        return HEADER;
    }

    String[][] getMeasurementListArray(String units) {
        this.units = units;
        double[][] ddata = this.getMeasurementListArrayReal(units);
        DecimalFormat dfx = TextFormat.getDecimalFormat(this.spec.isNMR() ? "#0.0000" : "#0.00");
        DecimalFormat dfdx = TextFormat.getDecimalFormat(this.spec.isHNMR() && units.equals("ppm") ? "#0.0000" : "#0.00");
        String[][] data = new String[this.size()][];
        int i = this.size();
        while (--i >= 0) {
            data[i] = new String[]{"" + (i + 1), dfx.format(ddata[i][0]), dfx.format(ddata[i][1]), dfdx.format(ddata[i][2])};
        }
        return data;
    }

    double[][] getMeasurementListArrayReal(String units) {
        boolean toHz = this.spec.isNMR() && units.equalsIgnoreCase("HZ");
        double[][] data = new double[this.size()][];
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            double y = ((Measurement)this.get(i)).getValue();
            if (toHz) {
                y *= this.spec.observedFreq;
            }
            data[pt++] = new double[]{((Measurement)this.get(i)).getXVal(), ((Measurement)this.get(i)).getXVal2(), y};
        }
        return data;
    }

    static boolean checkParameters(MeasurementData md, Parameters p) {
        if (md.size() == 0) {
            return false;
        }
        Parameters myParams = md.getParameters();
        switch (md.getAType()) {
            case Integration: {
                break;
            }
            case PeakList: {
                return p.peakListInterpolation.equals(myParams.peakListInterpolation) && p.peakListThreshold == myParams.peakListThreshold;
            }
        }
        return false;
    }

    @Override
    public JDXSpectrum getSpectrum() {
        return this.spec;
    }

    @Override
    public MeasurementData getData() {
        return this;
    }

    protected void clear(double x1, double x2) {
        int i = this.size();
        while (--i >= 0) {
            Measurement in = (Measurement)this.get(i);
            if (in.text.length() != 0 && !in.overlaps(x1, x2)) continue;
            this.remove(i);
        }
    }

    @Override
    public void addSpecShift(double dx) {
        int i = this.size();
        while (--i >= 0) {
            Measurement m = (Measurement)this.get(i);
            double x = m.getXVal() + dx;
            m.setXVal(x);
            m.setValue(x);
            m.text = this.df.format(x);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    void getInfo(Map<String, Object> info) {
        info.put("header", this.getDataHeader());
        info.put("table", this.getMeasurementListArrayReal("ppm"));
        if (this.units != null) {
            info.put("units", this.units);
        }
    }
}

