/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.List;
import java.util.Map;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVDialog;
import jspecview.common.JSVPanel;
import jspecview.common.Parameters;
import jspecview.source.JDXSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSVPanelNode {
    public Object treeNode;
    public JDXSource source;
    public String fileName;
    public JSVPanel jsvp;
    public String id;
    public JSVDialog legend;
    public boolean isSelected;
    public boolean isView;
    public String frameTitle;

    public JSVPanelNode(String id, String fileName, JDXSource source, JSVPanel jsvp) {
        this.id = id;
        this.source = source;
        this.fileName = fileName;
        this.jsvp = jsvp;
        if (jsvp != null) {
            jsvp.getPanelData().getSpectrumAt(0).setId(id);
            this.frameTitle = jsvp.getTitle();
        }
    }

    public void setTreeNode(Object node) {
        this.treeNode = node;
    }

    public Object getTreeNode() {
        return this.treeNode;
    }

    public void dispose() {
        this.source.dispose();
        if (this.jsvp != null) {
            this.jsvp.dispose();
        }
        this.source = null;
        this.jsvp = null;
        this.legend = null;
    }

    public JDXSpectrum getSpectrum() {
        return this.jsvp.getPanelData().getSpectrum();
    }

    JSVDialog setLegend(JSVDialog legend) {
        if (this.legend != null) {
            this.legend.dispose();
        }
        this.legend = legend;
        return legend;
    }

    public String toString() {
        return String.valueOf(this.id == null ? "" : String.valueOf(this.id) + ": ") + (this.frameTitle == null ? this.fileName : this.frameTitle);
    }

    public static JDXSource findSourceByNameOrId(String id, List<JSVPanelNode> panelNodes) {
        JSVPanelNode node;
        int i = panelNodes.size();
        while (--i >= 0) {
            node = panelNodes.get(i);
            if (!id.equals(node.id) && !id.equalsIgnoreCase(node.source.getFilePath())) continue;
            return node.source;
        }
        i = panelNodes.size();
        while (--i >= 0) {
            node = panelNodes.get(i);
            if (!id.equals(node.fileName)) continue;
            return node.source;
        }
        return null;
    }

    static JSVPanelNode findNodeById(String id, List<JSVPanelNode> panelNodes) {
        int i = panelNodes.size();
        while (--i >= 0) {
            if (!id.equals(panelNodes.get((int)i).id)) continue;
            return panelNodes.get(i);
        }
        return null;
    }

    static JSVPanelNode findNode(JSVPanel jsvp, List<JSVPanelNode> panelNodes) {
        int i = panelNodes.size();
        while (--i >= 0) {
            if (panelNodes.get((int)i).jsvp != jsvp) continue;
            return panelNodes.get(i);
        }
        return null;
    }

    static String getSpectrumListAsString(List<JSVPanelNode> panelNodes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < panelNodes.size()) {
            String id = panelNodes.get((int)i).id;
            sb.append(" ").append(id);
            ++i;
        }
        return sb.toString().trim();
    }

    static boolean isOpen(List<JSVPanelNode> panelNodes, String filePath) {
        if (filePath != null) {
            int i = panelNodes.size();
            while (--i >= 0) {
                if (!filePath.equals(panelNodes.get((int)i).source.getFilePath()) && !filePath.equals(panelNodes.get((int)i).frameTitle)) continue;
                return true;
            }
        }
        return false;
    }

    void setFrameTitle(String name) {
        this.frameTitle = name;
    }

    static JSVPanel getLastFileFirstNode(List<JSVPanelNode> panelNodes) {
        int n = panelNodes.size();
        JSVPanelNode node = n == 0 ? null : panelNodes.get(n - 1);
        int i = n - 1;
        while (--i >= 0) {
            if (panelNodes.get((int)i).source != node.source) break;
            node = panelNodes.get(i);
        }
        return node == null ? null : node.jsvp;
    }

    Map<String, Object> getInfo(String key) {
        Map<String, Object> info = this.jsvp.getPanelData().getInfo(false, key);
        Parameters.putInfo(key, info, "panelId", this.id);
        Parameters.putInfo(key, info, "panelFileName", this.fileName);
        Parameters.putInfo(key, info, "panelSource", this.source.getFilePath());
        return info;
    }
}

