/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDXHeader {
    public String title = "";
    public String jcampdx = "5.01";
    public String dataType = "";
    public String dataClass = "";
    public String origin = "";
    public String owner = "PUBLIC DOMAIN";
    public String longDate = "";
    public String date = "";
    public String time = "";
    static final String[] typeNames = new String[]{"ND NMR SPECTRUM   NMR", "NMR SPECTRUM      NMR", "INFRARED SPECTRUM IR", "MASS SPECTRUM     MS", "RAMAN SPECTRUM    RAMAN", "GAS CHROMATOGRAM  GC", "UV/VIS SPECTRUM   UV/VIS"};
    private String qualifiedType;
    protected List<String[]> headerTable = new ArrayList<String[]>();

    public void setTitle(String title) {
        this.title = title;
    }

    public void setJcampdx(String versionNum) {
        this.jcampdx = versionNum;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDataClass(String dataClass) {
        this.dataClass = dataClass;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setLongDate(String longDate) {
        this.longDate = longDate;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getTitle() {
        return this.title;
    }

    static String getTypeName(String type) {
        type = type.toUpperCase();
        int i = 0;
        while (i < typeNames.length) {
            if (typeNames[i].startsWith(type)) {
                return typeNames[i].substring(18);
            }
            ++i;
        }
        return type;
    }

    public String getQualifiedDataType() {
        return this.qualifiedType == null ? (this.qualifiedType = JDXHeader.getTypeName(this.dataType)) : this.qualifiedType;
    }

    public String getJcampdx() {
        return this.jcampdx;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getLongDate() {
        return this.longDate;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public void setHeaderTable(List<String[]> table) {
        this.headerTable = table;
    }

    public List<String[]> getHeaderTable() {
        return this.headerTable;
    }

    public String[][] getHeaderRowDataAsArray(boolean addDataClass, int nMore) {
        String[][] rowData = new String[(addDataClass ? 6 : 5) + this.headerTable.size() + nMore][];
        int i = 0;
        rowData[i++] = new String[]{"##TITLE", this.title};
        rowData[i++] = new String[]{"##JCAMP-DX", this.jcampdx};
        rowData[i++] = new String[]{"##DATA TYPE", this.dataType};
        if (addDataClass) {
            rowData[i++] = new String[]{"##DATA CLASS", this.dataClass};
        }
        rowData[i++] = new String[]{"##ORIGIN", this.origin};
        rowData[i++] = new String[]{"##OWNER", this.owner};
        int j = 0;
        while (j < this.headerTable.size()) {
            rowData[i++] = this.headerTable.get(j);
            ++j;
        }
        return rowData;
    }
}

