/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import jspecview.common.PrintLayout;

public class AwtPrintLayoutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private TitledBorder titledBorder3;
    private TitledBorder titledBorder4;
    private TitledBorder titledBorder5;
    private TitledBorder titledBorder6;
    private TitledBorder titledBorder7;
    private TitledBorder titledBorder8;
    private TitledBorder titledBorder9;
    private ButtonGroup layoutButtonGroup = new ButtonGroup();
    private ButtonGroup fontButtonGroup = new ButtonGroup();
    private ButtonGroup positionButtonGroup = new ButtonGroup();
    private PrintLayout pl;
    private PrintLayout plNew;
    private JPanel jPanel1 = new JPanel();
    private JPanel layoutPanel = new JPanel();
    private JPanel positionPanel = new JPanel();
    private JPanel layoutContentPanel = new JPanel();
    private JPanel previewPanel = new JPanel();
    private JPanel fontPanel = new JPanel();
    private JPanel elementsPanel = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JButton layoutButton = new JButton();
    private JButton previewButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton printButton = new JButton();
    private JButton pdfButton = new JButton();
    private GridBagLayout gridBagLayout7 = new GridBagLayout();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JCheckBox scaleXCheckBox = new JCheckBox();
    private JCheckBox scaleYCheckBox = new JCheckBox();
    private JCheckBox gridCheckBox = new JCheckBox();
    private JCheckBox titleCheckBox = new JCheckBox();
    private JRadioButton landscapeRadioButton = new JRadioButton();
    private JRadioButton defaultPosRadioButton = new JRadioButton();
    private JRadioButton centerRadioButton = new JRadioButton();
    private JRadioButton portraitRadioButton = new JRadioButton();
    private JRadioButton fitToPageRadioButton = new JRadioButton();
    private JRadioButton chooseFontRadioButton = new JRadioButton();
    private JRadioButton defaultFontRadioButton = new JRadioButton();
    private static JComboBox fontComboBox = new JComboBox();
    private static JComboBox paperComboBox = new JComboBox();
    private static ImageIcon portraitIcon;
    private static ImageIcon landscapeIcon;
    private static ImageIcon previewPortraitCenterIcon;
    private static ImageIcon previewPortraitDefaultIcon;
    private static ImageIcon previewPortraitFitIcon;
    private static ImageIcon previewLandscapeCenterIcon;
    private static ImageIcon previewLandscapeDefaultIcon;
    private static ImageIcon previewLandscapeFitIcon;

    public AwtPrintLayoutDialog(Frame frame, PrintLayout pl, boolean isJob) {
        super(frame, "Print Layout", true);
        if (pl == null) {
            pl = new PrintLayout();
        }
        this.pl = pl;
        try {
            this.jbInit(isJob);
            this.setSize(320, 400);
            this.setResizable(false);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setStaticElements() {
        if (previewLandscapeFitIcon != null) {
            return;
        }
        paperComboBox.addItem(MediaSizeName.NA_LETTER);
        paperComboBox.addItem(MediaSizeName.NA_LEGAL);
        paperComboBox.addItem(MediaSizeName.ISO_A4);
        paperComboBox.addItem(MediaSizeName.ISO_B4);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] allFontNames = ge.getAvailableFontFamilyNames();
        int i = 0;
        while (i < allFontNames.length) {
            fontComboBox.addItem(allFontNames[i]);
            ++i;
        }
        ClassLoader cl = AwtPrintLayoutDialog.class.getClassLoader();
        String path = "jspecview/application/icons/";
        portraitIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "portrait.gif"));
        landscapeIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "landscape.gif"));
        previewPortraitCenterIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "portraitCenter.gif"));
        previewPortraitDefaultIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "portraitDefault.gif"));
        previewPortraitFitIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "portraitFit.gif"));
        previewLandscapeCenterIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "landscapeCenter.gif"));
        previewLandscapeDefaultIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "landscapeDefault.gif"));
        previewLandscapeFitIcon = new ImageIcon(cl.getResource(String.valueOf(path) + "landscapeFit.gif"));
    }

    private void jbInit(boolean isJob) throws Exception {
        AwtPrintLayoutDialog.setStaticElements();
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.titledBorder3 = new TitledBorder("");
        this.titledBorder4 = new TitledBorder("");
        this.titledBorder5 = new TitledBorder("");
        this.titledBorder6 = new TitledBorder("");
        this.titledBorder7 = new TitledBorder("");
        this.titledBorder8 = new TitledBorder("");
        this.titledBorder9 = new TitledBorder("");
        this.titledBorder1.setTitle("Layout");
        this.titledBorder1.setTitleJustification(2);
        this.titledBorder2.setTitle("Position");
        this.titledBorder2.setTitleJustification(2);
        this.titledBorder3.setTitle("Elements");
        this.titledBorder3.setTitleJustification(2);
        this.titledBorder4.setTitle("Font");
        this.titledBorder4.setTitleJustification(2);
        this.titledBorder5.setTitle("Preview");
        this.titledBorder5.setTitleJustification(2);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.printButton.setToolTipText("");
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.printButton_actionPerformed(false);
            }
        });
        this.pdfButton.setToolTipText("");
        this.pdfButton.setText("Create PDF");
        this.pdfButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.printButton_actionPerformed(true);
            }
        });
        this.titledBorder6.setTitle("Printers");
        this.titledBorder7.setTitle("Paper");
        this.titledBorder8.setTitle("Copies");
        this.layoutPanel.setBorder(this.titledBorder1);
        this.layoutPanel.setLayout(this.gridBagLayout2);
        this.landscapeRadioButton.setActionCommand("Landscape");
        this.landscapeRadioButton.setText("Landscape");
        this.landscapeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.landscapeRadioButton_actionPerformed(e);
            }
        });
        this.positionPanel.setBorder(this.titledBorder2);
        this.positionPanel.setLayout(this.gridBagLayout3);
        this.layoutContentPanel.setLayout(this.gridBagLayout1);
        this.scaleXCheckBox.setText("X-Scale");
        this.scaleYCheckBox.setText("Y-Scale");
        this.previewPanel.setBorder(this.titledBorder5);
        this.previewPanel.setLayout(this.gridBagLayout6);
        this.previewButton.setBorder(null);
        this.previewButton.setIcon(previewLandscapeDefaultIcon);
        this.gridCheckBox.setText("Grid");
        this.defaultPosRadioButton.setActionCommand("Default");
        this.defaultPosRadioButton.setText("Default");
        this.defaultPosRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.defaultPosRadioButton_actionPerformed(e);
            }
        });
        this.centerRadioButton.setActionCommand("Center");
        this.centerRadioButton.setText("Center");
        this.centerRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.centerRadioButton_actionPerformed(e);
            }
        });
        this.portraitRadioButton.setActionCommand("Portrait");
        this.portraitRadioButton.setText("Portrait");
        this.portraitRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.portraitRadioButton_actionPerformed(e);
            }
        });
        this.fitToPageRadioButton.setActionCommand("Fit To Page");
        this.fitToPageRadioButton.setText("Fit to Page");
        this.fitToPageRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPrintLayoutDialog.this.fitToPageRadioButton_actionPerformed(e);
            }
        });
        this.layoutButton.setBorder(null);
        this.layoutButton.setIcon(portraitIcon);
        this.chooseFontRadioButton.setText("Choose font");
        this.defaultFontRadioButton.setText("Use default");
        this.fontPanel.setBorder(this.titledBorder4);
        this.fontPanel.setLayout(this.gridBagLayout5);
        this.titleCheckBox.setText("Title");
        this.elementsPanel.setBorder(this.titledBorder3);
        this.elementsPanel.setLayout(this.gridBagLayout4);
        this.jPanel2.setBorder(this.titledBorder9);
        this.jPanel2.setLayout(this.gridBagLayout7);
        this.titledBorder9.setTitle("Paper");
        this.titledBorder9.setTitleJustification(2);
        this.getContentPane().add((Component)this.jPanel1, "South");
        if (isJob) {
            this.jPanel1.add((Component)this.printButton, null);
        }
        this.jPanel1.add((Component)this.pdfButton, null);
        this.jPanel1.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.layoutContentPanel, "Center");
        this.layoutContentPanel.add((Component)this.previewPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.previewPanel.add((Component)this.previewButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutContentPanel.add((Component)this.layoutPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutPanel.add((Component)this.portraitRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutPanel.add((Component)this.landscapeRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutPanel.add((Component)this.layoutButton, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutContentPanel.add((Component)this.positionPanel, new GridBagConstraints(1, 0, 2, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.positionPanel.add((Component)this.centerRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.positionPanel.add((Component)this.fitToPageRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.positionPanel.add((Component)this.defaultPosRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutContentPanel.add((Component)this.elementsPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.elementsPanel.add((Component)this.gridCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.elementsPanel.add((Component)this.scaleXCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.elementsPanel.add((Component)this.scaleYCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.elementsPanel.add((Component)this.titleCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutContentPanel.add((Component)this.fontPanel, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fontPanel.add((Component)this.defaultFontRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fontPanel.add((Component)this.chooseFontRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fontPanel.add((Component)fontComboBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutContentPanel.add((Component)this.jPanel2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)paperComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.layoutButtonGroup.add(this.portraitRadioButton);
        this.layoutButtonGroup.add(this.landscapeRadioButton);
        this.positionButtonGroup.add(this.centerRadioButton);
        this.positionButtonGroup.add(this.fitToPageRadioButton);
        this.positionButtonGroup.add(this.defaultPosRadioButton);
        this.fontButtonGroup.add(this.defaultFontRadioButton);
        this.fontButtonGroup.add(this.chooseFontRadioButton);
        this.setDefaults();
    }

    void portraitRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    void landscapeRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    void centerRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    void fitToPageRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    private void setPreview() {
        int layout = " PL".indexOf(this.layoutButtonGroup.getSelection().getActionCommand().charAt(0));
        this.layoutButton.setIcon(layout == 1 ? portraitIcon : landscapeIcon);
        int position = " DCF".indexOf(this.positionButtonGroup.getSelection().getActionCommand().charAt(0));
        ImageIcon icon = null;
        switch ((layout << 4) + position) {
            default: {
                icon = previewPortraitDefaultIcon;
                break;
            }
            case 18: {
                icon = previewPortraitCenterIcon;
                break;
            }
            case 19: {
                icon = previewPortraitFitIcon;
                break;
            }
            case 33: {
                icon = previewLandscapeDefaultIcon;
                break;
            }
            case 34: {
                icon = previewLandscapeCenterIcon;
                break;
            }
            case 35: {
                icon = previewLandscapeFitIcon;
            }
        }
        this.previewButton.setIcon(icon);
    }

    void defaultPosRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    private void setDefaults() {
        int i;
        this.landscapeRadioButton.setSelected(this.pl.layout.equals("landscape"));
        this.scaleXCheckBox.setSelected(this.pl.showXScale);
        this.scaleYCheckBox.setSelected(this.pl.showYScale);
        this.gridCheckBox.setSelected(this.pl.showGrid);
        this.titleCheckBox.setSelected(this.pl.showTitle);
        this.defaultPosRadioButton.setSelected(this.pl.position.equals("default"));
        this.centerRadioButton.setSelected(this.pl.position.equals("center"));
        this.fitToPageRadioButton.setSelected(this.pl.position.equals("fit to page"));
        this.defaultFontRadioButton.setSelected(this.pl.font == null);
        if (this.pl.font != null) {
            i = fontComboBox.getItemCount();
            while (--i >= 0) {
                if (!fontComboBox.getItemAt(i).equals(this.pl.font)) continue;
                fontComboBox.setSelectedIndex(i);
                break;
            }
        }
        i = 0;
        while (i < paperComboBox.getItemCount()) {
            if (this.pl.paper == null || paperComboBox.getItemAt(i).equals(this.pl.paper)) {
                paperComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.setPreview();
    }

    void printButton_actionPerformed(boolean asPDF) {
        this.plNew = new PrintLayout();
        this.plNew.layout = this.layoutButtonGroup.getSelection().getActionCommand().toLowerCase();
        this.plNew.font = this.defaultFontRadioButton.isSelected() ? null : (String)fontComboBox.getSelectedItem();
        this.plNew.position = this.positionButtonGroup.getSelection().getActionCommand().toLowerCase();
        this.plNew.showGrid = this.gridCheckBox.isSelected();
        this.plNew.showXScale = this.scaleXCheckBox.isSelected();
        this.plNew.showYScale = this.scaleYCheckBox.isSelected();
        this.plNew.showTitle = this.titleCheckBox.isSelected();
        this.plNew.paper = (MediaSizeName)paperComboBox.getSelectedItem();
        this.plNew.asPDF = asPDF;
        this.dispose();
    }

    public PrintLayout getPrintLayout() {
        return this.plNew;
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

