/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import jspecview.common.Annotation;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.PanelData;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.util.Logger;
import jspecview.util.Parser;

public class AwtPopupMenu
extends JPopupMenu {
    protected boolean isApplet;
    private static final long serialVersionUID = 1L;
    private ScriptInterface scripter;
    public JMenuItem nextMenuItem = new JMenuItem();
    public JMenuItem previousMenuItem = new JMenuItem();
    public JMenuItem clearMenuItem = new JMenuItem();
    public JMenuItem resetMenuItem = new JMenuItem();
    public JMenuItem properties = new JMenuItem();
    protected JMenuItem userZoomMenuItem = new JMenuItem();
    protected JMenuItem scriptMenuItem = new JMenuItem();
    public JMenuItem overlayStackOffsetMenuItem = new JMenuItem();
    public JMenuItem integrationMenuItem = new JMenuItem();
    public JMenuItem measurementsMenuItem = new JMenuItem();
    public JMenuItem peakListMenuItem = new JMenuItem();
    public JMenuItem transAbsMenuItem = new JMenuItem();
    public JMenuItem solColMenuItem = new JMenuItem();
    public JCheckBoxMenuItem gridCheckBoxMenuItem = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem coordsCheckBoxMenuItem = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem reversePlotCheckBoxMenuItem = new JCheckBoxMenuItem();
    protected JMenu appletSaveAsJDXMenu;
    protected JMenu appletExportAsMenu;
    protected JMenuItem spectraMenuItem = new JMenuItem();
    public JMenuItem overlayKeyMenuItem = new JMenuItem();
    private String recentZoom = "";
    private String recentScript = "";
    protected String recentStackPercent = "5";
    private PanelData pd;
    private int thisX;
    private int thisY;
    JSVPanel thisJsvp;

    public void dispose() {
        this.pd = null;
    }

    public AwtPopupMenu(ScriptInterface scripter) {
        this.scripter = scripter;
        this.jbInit();
    }

    protected void jbInit() {
        final ScriptInterface scripter = this.scripter;
        this.nextMenuItem.setText("Next View");
        this.nextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().nextView();
                AwtPopupMenu.this.reboot();
            }
        });
        this.previousMenuItem.setText("Previous View");
        this.previousMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().previousView();
                AwtPopupMenu.this.reboot();
            }
        });
        this.clearMenuItem.setText("Clear Views");
        this.clearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().resetView();
            }
        });
        this.resetMenuItem.setText("Reset View");
        this.resetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().clearAllView();
            }
        });
        this.setOverlayItems();
        this.scriptMenuItem.setText("Script...");
        this.scriptMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPopupMenu.this.script(AwtPopupMenu.this.thisJsvp);
            }
        });
        this.userZoomMenuItem.setText("Set Zoom...");
        this.userZoomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPopupMenu.this.userZoom(AwtPopupMenu.this.thisJsvp);
            }
        });
        this.properties.setActionCommand("Properties");
        this.properties.setText("Properties");
        this.properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.showProperties();
            }
        });
        this.gridCheckBoxMenuItem.setText("Show Grid");
        this.gridCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AwtPopupMenu.runScript(scripter, "GRIDON " + (e.getStateChange() == 1));
                AwtPopupMenu.this.reboot();
            }
        });
        this.coordsCheckBoxMenuItem.setText("Show Coordinates");
        this.coordsCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AwtPopupMenu.runScript(scripter, "COORDINATESON " + (e.getStateChange() == 1));
                AwtPopupMenu.this.reboot();
            }
        });
        this.reversePlotCheckBoxMenuItem.setText("Reverse Plot");
        this.reversePlotCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AwtPopupMenu.runScript(scripter, "REVERSEPLOT " + (e.getStateChange() == 1));
                AwtPopupMenu.this.reboot();
            }
        });
        this.setPopupMenu();
    }

    protected void setOverlayItems() {
        this.spectraMenuItem.setText("Views...");
        this.spectraMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPopupMenu.this.overlay(AwtPopupMenu.this.thisJsvp, EnumOverlay.DIALOG);
            }
        });
        this.overlayStackOffsetMenuItem.setEnabled(false);
        this.overlayStackOffsetMenuItem.setText("Overlay Offset...");
        this.overlayStackOffsetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPopupMenu.this.overlay(AwtPopupMenu.this.thisJsvp, EnumOverlay.OFFSETY);
            }
        });
    }

    protected void setPopupMenu() {
        this.add(this.gridCheckBoxMenuItem);
        this.add(this.coordsCheckBoxMenuItem);
        this.add(this.reversePlotCheckBoxMenuItem);
        this.addSeparator();
        this.add(this.nextMenuItem);
        this.add(this.previousMenuItem);
        this.add(this.clearMenuItem);
        this.add(this.resetMenuItem);
        this.add(this.userZoomMenuItem);
        this.addSeparator();
        this.add(this.spectraMenuItem);
        this.add(this.overlayStackOffsetMenuItem);
        this.add(this.scriptMenuItem);
        this.addSeparator();
        this.add(this.properties);
    }

    protected void reboot() {
        if (this.thisJsvp == null) {
            return;
        }
        this.thisJsvp.doRepaint();
        this.show((Container)((Object)this.thisJsvp), this.thisX, this.thisY);
    }

    public void userZoom(JSVPanel jsvp) {
        if (jsvp == null) {
            return;
        }
        String zoom = jsvp.getInput("Enter zoom range", "Zoom", this.recentZoom);
        if (zoom == null) {
            return;
        }
        this.recentZoom = zoom;
        AwtPopupMenu.runScript(this.scripter, "zoom " + zoom);
    }

    public void script(JSVPanel jsvp) {
        if (jsvp == null) {
            return;
        }
        String script = jsvp.getInput("Enter a JSpecView script", "Script", this.recentScript);
        if (script == null) {
            return;
        }
        this.recentScript = script;
        AwtPopupMenu.runScript(this.scripter, script);
    }

    public static void setMenuItem(JMenuItem item, char c, String text, int accel, int mask, EventListener el) {
        if (c != '\u0000') {
            item.setMnemonic(c);
        }
        item.setText(text);
        if (accel > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accel, mask, false));
        }
        if (el instanceof ActionListener) {
            item.addActionListener((ActionListener)el);
        } else if (el instanceof ItemListener) {
            item.addItemListener((ItemListener)el);
        }
    }

    public void setProcessingMenu(JComponent menu) {
        final ScriptInterface scripter = this.scripter;
        AwtPopupMenu.setMenuItem(this.integrationMenuItem, 'I', "Integration", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getSelectedPanel().showDialog(Annotation.AType.Integration);
            }
        });
        AwtPopupMenu.setMenuItem(this.measurementsMenuItem, 'M', "Measurements", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getSelectedPanel().showDialog(Annotation.AType.Measurements);
            }
        });
        AwtPopupMenu.setMenuItem(this.peakListMenuItem, 'P', "Peaks", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getSelectedPanel().showDialog(Annotation.AType.PeakList);
            }
        });
        AwtPopupMenu.setMenuItem(this.transAbsMenuItem, '\u0000', "Transmittance/Absorbance", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPopupMenu.runScript(scripter, "IRMODE IMPLIED");
            }
        });
        AwtPopupMenu.setMenuItem(this.solColMenuItem, 'C', "Predicted Solution Colour", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPopupMenu.runScript(scripter, "GETSOLUTIONCOLOR");
            }
        });
        menu.add(this.measurementsMenuItem);
        menu.add(this.peakListMenuItem);
        menu.add(this.integrationMenuItem);
        menu.add(this.transAbsMenuItem);
        menu.add(this.solColMenuItem);
    }

    protected static void runScript(ScriptInterface scripter, String cmd) {
        if (scripter == null) {
            Logger.error("scripter was null for " + cmd);
        } else {
            scripter.runScript(cmd);
        }
    }

    public void overlay(JSVPanel jsvp, EnumOverlay overlay) {
        switch (overlay) {
            case DIALOG: {
                this.scripter.checkOverlay();
                break;
            }
            case OFFSETY: {
                if (jsvp == null) {
                    return;
                }
                String offset = jsvp.getInput("Enter a vertical offset in percent for stacked plots", "Overlay", this.recentStackPercent);
                if (offset == null || Float.isNaN(Parser.parseFloat(offset))) {
                    return;
                }
                this.recentStackPercent = offset;
                AwtPopupMenu.runScript(this.scripter, (Object)((Object)ScriptToken.STACKOFFSETY) + " " + offset);
            }
        }
    }

    public void show(JSVPanel jsvp, int x, int y) {
        this.setEnables(jsvp);
        this.thisX = x;
        this.thisY = y;
        this.thisJsvp = jsvp;
        super.show((Container)((Object)jsvp), x, y);
    }

    public void setEnables(JSVPanel jsvp) {
        this.pd = jsvp.getPanelData();
        JDXSpectrum spec0 = this.pd.getSpectrum();
        this.setSelected(this.gridCheckBoxMenuItem, this.pd.getBoolean(ScriptToken.GRIDON));
        this.setSelected(this.coordsCheckBoxMenuItem, this.pd.getBoolean(ScriptToken.COORDINATESON));
        this.setSelected(this.reversePlotCheckBoxMenuItem, this.pd.getBoolean(ScriptToken.REVERSEPLOT));
        boolean isOverlaid = this.pd.isShowAllStacked();
        boolean isSingle = this.pd.haveSelectedSpectrum();
        this.integrationMenuItem.setEnabled(this.pd.getSpectrum().canIntegrate());
        this.measurementsMenuItem.setEnabled(this.pd.hasCurrentMeasurements(Annotation.AType.Measurements));
        this.peakListMenuItem.setEnabled(this.pd.getSpectrum().is1D());
        this.solColMenuItem.setEnabled(isSingle && spec0.canShowSolutionColor());
        this.transAbsMenuItem.setEnabled(isSingle && spec0.canConvertTransAbs());
        this.overlayKeyMenuItem.setEnabled(isOverlaid && this.pd.getNumberOfGraphSets() == 1);
        this.overlayStackOffsetMenuItem.setEnabled(isOverlaid);
        if (this.appletSaveAsJDXMenu != null) {
            this.appletSaveAsJDXMenu.setEnabled(spec0.canSaveAsJDX());
        }
        if (this.appletExportAsMenu != null) {
            this.appletExportAsMenu.setEnabled(true);
        }
    }

    private void setSelected(JCheckBoxMenuItem item, boolean TF) {
        item.setEnabled(false);
        item.setSelected(TF);
        item.setEnabled(true);
    }

    public static void setMenus(JMenu saveAsMenu, JMenu saveAsJDXMenu, JMenu exportAsMenu, ActionListener actionListener) {
        saveAsMenu.setText("Save As");
        AwtPopupMenu.addMenuItem(saveAsMenu, "Original...", '\u0000', actionListener);
        saveAsJDXMenu.setText("JDX");
        AwtPopupMenu.addMenuItem(saveAsJDXMenu, "XY", '\u0000', actionListener);
        AwtPopupMenu.addMenuItem(saveAsJDXMenu, "DIF", '\u0000', actionListener);
        AwtPopupMenu.addMenuItem(saveAsJDXMenu, "DIFDUP", 'U', actionListener);
        AwtPopupMenu.addMenuItem(saveAsJDXMenu, "FIX", '\u0000', actionListener);
        AwtPopupMenu.addMenuItem(saveAsJDXMenu, "PAC", '\u0000', actionListener);
        AwtPopupMenu.addMenuItem(saveAsJDXMenu, "SQZ", '\u0000', actionListener);
        saveAsMenu.add(saveAsJDXMenu);
        AwtPopupMenu.addMenuItem(saveAsMenu, "CML", '\u0000', actionListener);
        AwtPopupMenu.addMenuItem(saveAsMenu, "XML (AnIML)", '\u0000', actionListener);
        if (exportAsMenu != null) {
            exportAsMenu.setText("Export As");
            AwtPopupMenu.addMenuItem(exportAsMenu, "JPG", '\u0000', actionListener);
            AwtPopupMenu.addMenuItem(exportAsMenu, "PNG", 'N', actionListener);
            AwtPopupMenu.addMenuItem(exportAsMenu, "SVG", '\u0000', actionListener);
            AwtPopupMenu.addMenuItem(exportAsMenu, "PDF", '\u0000', actionListener);
        }
    }

    private static void addMenuItem(JMenu m, String key, char keyChar, ActionListener actionListener) {
        JMenuItem jmi = new JMenuItem();
        jmi.setMnemonic(keyChar == '\u0000' ? key.charAt(0) : keyChar);
        jmi.setText(key);
        jmi.addActionListener(actionListener);
        m.add(jmi);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOverlay {
        DIALOG,
        OFFSETY;

    }
}

