/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jspecview.application.AboutDialog;
import jspecview.application.MainFrame;
import jspecview.application.TextDialog;
import jspecview.common.AwtPopupMenu;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelNode;
import jspecview.common.PanelData;
import jspecview.common.ScriptToken;
import jspecview.source.JDXSource;
import jspecview.util.FileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    protected MainFrame mainFrame;
    AwtPopupMenu jsvpPopupMenu;
    private JMenu fileMenu = new JMenu();
    private JMenuItem openMenuItem = new JMenuItem();
    private JMenuItem openURLMenuItem = new JMenuItem();
    private JMenuItem printMenuItem = new JMenuItem();
    private JMenuItem closeMenuItem = new JMenuItem();
    private JMenuItem closeAllMenuItem = new JMenuItem();
    private JMenu saveAsMenu = new JMenu();
    private JMenu saveAsJDXMenu = new JMenu();
    private JMenu exportAsMenu = new JMenu();
    private JMenuItem exitMenuItem = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenu optionsMenu = new JMenu();
    private JMenu displayMenu = new JMenu();
    private JMenu zoomMenu = new JMenu();
    JCheckBoxMenuItem gridCheckBoxMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem coordsCheckBoxMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem revPlotCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem scaleXCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem scaleYCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem nextZoomMenuItem = new JMenuItem();
    private JMenuItem prevZoomMenuItem = new JMenuItem();
    private JMenuItem fullZoomMenuItem = new JMenuItem();
    private JMenuItem clearZoomMenuItem = new JMenuItem();
    private JMenuItem userZoomMenuItem = new JMenuItem();
    private JMenuItem preferencesMenuItem = new JMenuItem();
    private JMenuItem contentsMenuItem = new JMenuItem();
    private JMenuItem aboutMenuItem = new JMenuItem();
    private JMenu openRecentMenu = new JMenu();
    private JCheckBoxMenuItem toolbarCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem sidePanelCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem statusCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem overlayStackOffsetYMenuItem = new JMenuItem();
    private JMenuItem spectraMenuItem = new JMenuItem();
    private JMenuItem sourceMenuItem = new JMenuItem();
    private JMenuItem propertiesMenuItem = new JMenuItem();
    private JMenuItem scriptMenuItem = new JMenuItem();
    JMenu processingMenu = new JMenu();
    private JMenuItem errorLogMenuItem = new JMenuItem();
    JMenuItem overlayKeyMenuItem;

    public AppMenu(MainFrame si, AwtPopupMenu popupMenu) throws Exception {
        this.mainFrame = si;
        this.jsvpPopupMenu = popupMenu;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        AwtPopupMenu.setMenuItem(this.openMenuItem, 'O', "Open...", 79, 2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.showFileOpenDialog();
            }
        });
        AwtPopupMenu.setMenuItem(this.openURLMenuItem, 'U', "Open URL...", 85, 2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.openURL();
            }
        });
        AwtPopupMenu.setMenuItem(this.printMenuItem, 'P', "Print...", 80, 2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.print("");
            }
        });
        AwtPopupMenu.setMenuItem(this.closeMenuItem, 'C', "Close", 115, 2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.runScript("CLOSE");
            }
        });
        AwtPopupMenu.setMenuItem(this.closeAllMenuItem, 'L', "Close All", 0, 2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.runScript("CLOSE ALL");
            }
        });
        AwtPopupMenu.setMenuItem(this.exitMenuItem, 'X', "Exit", 115, 8, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.exitJSpecView(false);
            }
        });
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.setText("Options");
        this.displayMenu.setMnemonic('D');
        this.displayMenu.setText("Display");
        this.displayMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                JSVPanel jsvp = AppMenu.this.mainFrame.getSelectedPanel();
                if (jsvp == null) {
                    return;
                }
                AppMenu.this.gridCheckBoxMenuItem.setSelected(jsvp.getPanelData().getBoolean(ScriptToken.GRIDON));
                AppMenu.this.coordsCheckBoxMenuItem.setSelected(jsvp.getPanelData().getBoolean(ScriptToken.COORDINATESON));
                AppMenu.this.revPlotCheckBoxMenuItem.setSelected(jsvp.getPanelData().getBoolean(ScriptToken.REVERSEPLOT));
                AppMenu.this.jsvpPopupMenu.setEnables(AppMenu.this.mainFrame.getSelectedPanel());
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        this.zoomMenu.setMnemonic('Z');
        this.zoomMenu.setText("Zoom");
        AwtPopupMenu.setMenuItem(this.gridCheckBoxMenuItem, 'G', "Grid", 71, 2, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.setBoolean(ScriptToken.GRIDON, e);
            }
        });
        AwtPopupMenu.setMenuItem(this.coordsCheckBoxMenuItem, 'C', "Coordinates", 67, 2, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.setBoolean(ScriptToken.COORDINATESON, e);
            }
        });
        AwtPopupMenu.setMenuItem(this.revPlotCheckBoxMenuItem, 'R', "Reverse Plot", 82, 2, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.setBoolean(ScriptToken.REVERSEPLOT, e);
            }
        });
        AwtPopupMenu.setMenuItem(this.scaleXCheckBoxMenuItem, 'X', "X Scale", 88, 2, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.setBoolean(ScriptToken.XSCALEON, e);
            }
        });
        AwtPopupMenu.setMenuItem(this.scaleYCheckBoxMenuItem, 'Y', "Y Scale", 89, 2, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.setBoolean(ScriptToken.YSCALEON, e);
            }
        });
        AwtPopupMenu.setMenuItem(this.nextZoomMenuItem, 'N', "Next View", 78, 3, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.runScript("zoom next");
            }
        });
        AwtPopupMenu.setMenuItem(this.prevZoomMenuItem, 'P', "Previous View", 80, 3, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.runScript("zoom previous");
            }
        });
        AwtPopupMenu.setMenuItem(this.fullZoomMenuItem, 'F', "Full View", 70, 3, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.runScript("zoom out");
            }
        });
        AwtPopupMenu.setMenuItem(this.clearZoomMenuItem, 'C', "Clear Views", 67, 3, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.runScript("zoom clear");
            }
        });
        AwtPopupMenu.setMenuItem(this.userZoomMenuItem, 'Z', "Set Zoom...", 90, 3, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.jsvpPopupMenu.userZoom(AppMenu.this.mainFrame.getSelectedPanel());
            }
        });
        AwtPopupMenu.setMenuItem(this.scriptMenuItem, 'T', "Script...", 83, 8, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.jsvpPopupMenu.script(AppMenu.this.mainFrame.getSelectedPanel());
            }
        });
        AwtPopupMenu.setMenuItem(this.preferencesMenuItem, 'P', "Preferences...", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.showPreferencesDialog();
            }
        });
        AwtPopupMenu.setMenuItem(this.contentsMenuItem, 'C', "Contents...", 112, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.showNotImplementedOptionPane();
            }
        });
        AwtPopupMenu.setMenuItem(this.aboutMenuItem, 'A', "About", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AboutDialog(AppMenu.this.mainFrame);
            }
        });
        this.openRecentMenu.setActionCommand("OpenRecent");
        this.openRecentMenu.setMnemonic('R');
        this.openRecentMenu.setText("Open Recent");
        this.saveAsMenu.setMnemonic('A');
        this.saveAsJDXMenu.setMnemonic('J');
        this.exportAsMenu.setMnemonic('E');
        AwtPopupMenu.setMenuItem(this.toolbarCheckBoxMenuItem, 'T', "Toolbar", 84, 9, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.mainFrame.enableToolbar(e.getStateChange() == 1);
            }
        });
        this.toolbarCheckBoxMenuItem.setSelected(true);
        AwtPopupMenu.setMenuItem(this.sidePanelCheckBoxMenuItem, 'S', "Side Panel", 83, 9, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.mainFrame.setSplitPane(e.getStateChange() == 1);
            }
        });
        this.sidePanelCheckBoxMenuItem.setSelected(true);
        AwtPopupMenu.setMenuItem(this.statusCheckBoxMenuItem, 'B', "Status Bar", 66, 9, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AppMenu.this.mainFrame.enableStatus(e.getStateChange() == 1);
            }
        });
        this.statusCheckBoxMenuItem.setSelected(true);
        AwtPopupMenu.setMenuItem(this.spectraMenuItem, 'S', "Spectra...", 83, 3, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.jsvpPopupMenu.overlay(AppMenu.this.mainFrame.getSelectedPanel(), AwtPopupMenu.EnumOverlay.DIALOG);
            }
        });
        AwtPopupMenu.setMenuItem(this.overlayStackOffsetYMenuItem, 'y', "Overlay Offset...", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.jsvpPopupMenu.overlay(AppMenu.this.mainFrame.getSelectedPanel(), AwtPopupMenu.EnumOverlay.OFFSETY);
            }
        });
        AwtPopupMenu.setMenuItem(this.sourceMenuItem, 'S', "Source ...", 83, 2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextDialog.showSource(AppMenu.this.mainFrame);
            }
        });
        AwtPopupMenu.setMenuItem(this.propertiesMenuItem, 'P', "Properties", 72, 2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.showProperties();
            }
        });
        this.overlayKeyMenuItem = this.jsvpPopupMenu.overlayKeyMenuItem;
        AwtPopupMenu.setMenuItem(this.overlayKeyMenuItem, '\u0000', "Overlay Key", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.toggleOverlayKey();
            }
        });
        AwtPopupMenu.setMenuItem(this.errorLogMenuItem, '\u0000', "Error Log ...", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextDialog.showError(AppMenu.this.mainFrame);
            }
        });
        this.processingMenu.setMnemonic('P');
        this.processingMenu.setText("Processing");
        this.processingMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                AppMenu.this.jsvpPopupMenu.setEnables(AppMenu.this.mainFrame.getSelectedPanel());
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        this.jsvpPopupMenu.setProcessingMenu(this.processingMenu);
        this.add(this.fileMenu);
        this.add(this.displayMenu).setEnabled(false);
        this.add(this.optionsMenu);
        this.add(this.processingMenu).setEnabled(false);
        this.add(this.helpMenu);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.add(this.openURLMenuItem);
        this.fileMenu.add(this.openRecentMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMenuItem).setEnabled(false);
        this.fileMenu.add(this.closeAllMenuItem).setEnabled(false);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.scriptMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveAsMenu).setEnabled(false);
        this.fileMenu.add(this.exportAsMenu).setEnabled(false);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.printMenuItem).setEnabled(false);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.sourceMenuItem).setEnabled(false);
        this.fileMenu.add(this.errorLogMenuItem).setEnabled(false);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.displayMenu.add(this.spectraMenuItem);
        this.displayMenu.add(this.overlayStackOffsetYMenuItem);
        this.displayMenu.add(this.overlayKeyMenuItem).setEnabled(false);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.gridCheckBoxMenuItem);
        this.displayMenu.add(this.coordsCheckBoxMenuItem);
        this.displayMenu.add(this.scaleXCheckBoxMenuItem);
        this.displayMenu.add(this.scaleYCheckBoxMenuItem);
        this.displayMenu.add(this.revPlotCheckBoxMenuItem);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.zoomMenu);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.propertiesMenuItem);
        this.zoomMenu.add(this.nextZoomMenuItem);
        this.zoomMenu.add(this.prevZoomMenuItem);
        this.zoomMenu.add(this.fullZoomMenuItem);
        this.zoomMenu.add(this.clearZoomMenuItem);
        this.zoomMenu.add(this.userZoomMenuItem);
        this.optionsMenu.add(this.preferencesMenuItem);
        this.optionsMenu.addSeparator();
        this.optionsMenu.add(this.toolbarCheckBoxMenuItem);
        this.optionsMenu.add(this.sidePanelCheckBoxMenuItem);
        this.optionsMenu.add(this.statusCheckBoxMenuItem);
        this.helpMenu.add(this.aboutMenuItem);
        AwtPopupMenu.setMenus(this.saveAsMenu, this.saveAsJDXMenu, this.exportAsMenu, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppMenu.this.mainFrame.exportSpectrumViaMenu(e.getActionCommand());
            }
        });
    }

    protected void setBoolean(ScriptToken st, ItemEvent e) {
        boolean isOn = e.getStateChange() == 1;
        this.mainFrame.runScript((Object)((Object)st) + " " + isOn);
    }

    public void setSourceEnabled(boolean b) {
        this.closeAllMenuItem.setEnabled(b);
        this.displayMenu.setEnabled(b);
        this.processingMenu.setEnabled(b);
        this.printMenuItem.setEnabled(b);
        this.sourceMenuItem.setEnabled(b);
        this.errorLogMenuItem.setEnabled(b);
        this.exportAsMenu.setEnabled(b);
        this.saveAsMenu.setEnabled(b);
    }

    void setCloseMenuItem(String fileName) {
        this.closeMenuItem.setEnabled(fileName != null);
        this.closeMenuItem.setText(fileName == null ? "Close" : "Close " + fileName);
    }

    void setError(boolean isError, boolean isWarningOnly) {
        this.errorLogMenuItem.setEnabled(isError);
    }

    public void setMenuEnables(JSVPanelNode node) {
        if (node == null) {
            this.setCloseMenuItem(null);
            this.setSourceEnabled(false);
        } else {
            this.setSourceEnabled(true);
            PanelData pd = node.jsvp.getPanelData();
            JDXSpectrum spec = pd.getSpectrum();
            this.setCheckBoxes(pd);
            this.overlayKeyMenuItem.setEnabled(pd.getNumberOfGraphSets() > 1);
            this.setCloseMenuItem(FileManager.getName(node.source.getFilePath()));
            this.exportAsMenu.setEnabled(true);
            this.saveAsMenu.setEnabled(true);
            this.saveAsJDXMenu.setEnabled(spec.canSaveAsJDX());
        }
    }

    public boolean toggleOverlayKeyMenuItem() {
        this.overlayKeyMenuItem.setSelected(this.overlayKeyMenuItem.isSelected());
        return this.overlayKeyMenuItem.isSelected();
    }

    void showPreferencesDialog() {
        this.mainFrame.showPreferences();
    }

    public void setSelections(boolean sidePanelOn, boolean toolbarOn, boolean statusbarOn, JSVPanel jsvp) {
        this.sidePanelCheckBoxMenuItem.setSelected(sidePanelOn);
        this.toolbarCheckBoxMenuItem.setSelected(toolbarOn);
        this.statusCheckBoxMenuItem.setSelected(statusbarOn);
        if (jsvp != null) {
            this.setCheckBoxes(jsvp.getPanelData());
        }
    }

    private void setCheckBoxes(PanelData pd) {
        this.gridCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.GRIDON));
        this.coordsCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.COORDINATESON));
        this.revPlotCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.REVERSEPLOT));
        this.scaleXCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.XSCALEON));
        this.scaleYCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.YSCALEON));
    }

    public void setRecentMenu(List<String> recentFilePaths) {
        this.openRecentMenu.removeAll();
        int i = 0;
        while (i < recentFilePaths.size()) {
            String path = recentFilePaths.get(i);
            JMenuItem menuItem = new JMenuItem(path);
            this.openRecentMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AppMenu.this.mainFrame.openFile(((JMenuItem)e.getSource()).getText(), true);
                }
            });
            ++i;
        }
    }

    public void updateRecentMenus(List<String> recentFilePaths) {
        this.openRecentMenu.removeAll();
        int i = 0;
        while (i < recentFilePaths.size()) {
            String path = recentFilePaths.get(i);
            JMenuItem menuItem = new JMenuItem(path);
            this.openRecentMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AppMenu.this.mainFrame.openFile(((JMenuItem)e.getSource()).getText(), true);
                }
            });
            ++i;
        }
    }

    public void clearSourceMenu(JDXSource source) {
        if (source == null) {
            this.setMenuEnables(null);
        } else {
            this.saveAsJDXMenu.setEnabled(true);
            this.saveAsMenu.setEnabled(true);
        }
    }
}

