/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshSurface {
    protected static final int SEED_COUNT = 25;
    public Vector3f[] spanningVectors;
    public String meshType;
    public int vertexCount;
    public Point3f[] vertices;
    public float[] vertexValues;
    public int[] vertexSource;
    public int polygonCount;
    public int[][] polygonIndexes;
    public boolean isTriangleSet;
    public boolean haveQuads;
    public short colix;
    public boolean isColorSolid = true;
    public Point3f offset;
    public Tuple3f[] altVertices;
    public short[] polygonColixes;
    public short[] vertexColixes;
    public Tuple3f[] normals;
    public int normalCount;
    protected int normixCount;
    public BitSet bsPolygons;
    public Matrix4f mat4;
    public BitSet[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    private int checkCount = 2;
    private int lastColor;
    private short lastColix;
    protected int iA;
    protected int iB;
    protected int iC;
    public int polygonCount0;
    public int vertexCount0;
    public BitSet bsSlabDisplay;
    public BitSet bsSlabGhost;
    public int slabMeshType;
    public short slabColix;
    public BitSet bsDisplay;
    public StringBuffer slabOptions;
    private boolean doClear;
    private boolean doGhost;
    private boolean doCap;
    private int iD;
    private int iE;
    public int mergeVertexCount0;
    public int mergePolygonCount0;
    public boolean isMerged;

    public MeshSurface() {
    }

    public MeshSurface(int[][] nArray, Tuple3f[] tuple3fArray, int n, Tuple3f[] tuple3fArray2, int n2) {
        this.polygonIndexes = nArray;
        if (tuple3fArray instanceof Point3f[]) {
            this.vertices = (Point3f[])tuple3fArray;
        } else {
            this.altVertices = tuple3fArray;
        }
        this.vertexCount = n == 0 ? tuple3fArray.length : n;
        this.normals = tuple3fArray2;
        this.normalCount = n2 == 0 && tuple3fArray2 != null ? tuple3fArray2.length : n2;
    }

    public MeshSurface(Point3f[] point3fArray, float[] fArray, int n, int[][] nArray, int n2, int n3) {
        this.vertices = point3fArray;
        this.vertexValues = fArray;
        this.vertexCount = n;
        this.polygonIndexes = nArray;
        this.polygonCount = n2;
        this.checkCount = n3;
    }

    public Tuple3f[] getVertices() {
        return this.altVertices == null ? this.vertices : this.altVertices;
    }

    public int[][] getFaces() {
        return this.polygonIndexes;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public int addVertexCopy(Point3f point3f) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(point3f);
        return this.vertexCount++;
    }

    public void addTriangle(int n, int n2, int n3) {
        this.addPolygon(new int[]{n, n2, n3}, null);
    }

    public void addQuad(int n, int n2, int n3, int n4) {
        this.haveQuads = true;
        this.addPolygon(new int[]{n, n2, n3, n4}, null);
    }

    public void setPolygonCount(int n) {
        this.polygonCount = n;
        if (n < 0) {
            return;
        }
        if (this.polygonIndexes == null || n > this.polygonIndexes.length) {
            this.polygonIndexes = new int[n][];
        }
    }

    public int addVertexCopy(Point3f point3f, float f) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = f;
        return this.addVertexCopy(point3f);
    }

    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.vertices == null || this.vertexValues != null && (Float.isNaN(this.vertexValues[n]) || Float.isNaN(this.vertexValues[n2]) || Float.isNaN(this.vertexValues[n3])) || Float.isNaN(this.vertices[n].x) || Float.isNaN(this.vertices[n2].x) || Float.isNaN(this.vertices[n3].x) ? -1 : this.addPolygon(n, n2, n3, n4, n5, n6, null);
    }

    private int addPolygon(int n, int n2, int n3, int n4, int n5, int n6, BitSet bitSet) {
        return this.checkCount == 2 ? this.addPolygon(new int[]{n, n2, n3, n4, n5}, n6, bitSet) : this.addPolygon(new int[]{n, n2, n3, n4}, bitSet);
    }

    protected int addPolygon(int[] nArray, int n, BitSet bitSet) {
        if (n != 0) {
            short s;
            if (this.polygonColixes == null || this.polygonCount == 0) {
                this.lastColor = 0;
            }
            if (n == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = n;
                s = this.lastColix = Graphics3D.getColix(this.lastColor);
            }
            short s2 = s;
            this.setPolygonColix(this.polygonCount, s2);
        }
        return this.addPolygon(nArray, bitSet);
    }

    private int addPolygon(int[] nArray, BitSet bitSet) {
        int n = this.polygonCount;
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        if (bitSet != null) {
            bitSet.set(this.polygonCount);
        }
        this.polygonIndexes[this.polygonCount++] = nArray;
        return n;
    }

    private void setPolygonColix(int n, short s) {
        if (this.polygonColixes == null) {
            this.polygonColixes = new short[25];
        } else if (n >= this.polygonColixes.length) {
            this.polygonColixes = ArrayUtil.doubleLength(this.polygonColixes);
        }
        this.polygonColixes[n] = s;
    }

    public void invalidatePolygons() {
        int n = this.polygonCount;
        while (--n >= this.mergePolygonCount0) {
            if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(n) || this.setABC(n)) continue;
            this.polygonIndexes[n] = null;
        }
    }

    protected boolean setABC(int n) {
        if (!(this.bsSlabDisplay == null || this.bsSlabDisplay.get(n) || this.bsSlabGhost != null && this.bsSlabGhost.get(n))) {
            return false;
        }
        int[] nArray = this.polygonIndexes[n];
        if (nArray == null) {
            return false;
        }
        this.iA = nArray[0];
        this.iB = nArray[1];
        this.iC = nArray[2];
        return this.vertexValues == null || !Float.isNaN(this.vertexValues[this.iA]) && !Float.isNaN(this.vertexValues[this.iB]) && !Float.isNaN(this.vertexValues[this.iC]);
    }

    public void setSlab(BitSet bitSet, BitSet bitSet2, String string, String string2, float f) {
        this.bsSlabDisplay = bitSet;
        this.bsSlabGhost = bitSet2;
        this.slabMeshType = string.equalsIgnoreCase("mesh") ? 1073742018 : 1073741938;
        this.slabColix = Graphics3D.getColixTranslucent(Graphics3D.getColix(string2), true, f);
    }

    public String getSlabColor() {
        return this.bsSlabGhost == null ? null : Graphics3D.getHexCode(this.slabColix);
    }

    public String getSlabTranslucency() {
        return this.bsSlabGhost == null ? null : "" + Graphics3D.getColixTranslucencyFractional(this.slabColix);
    }

    public String getSlabType() {
        return this.bsSlabGhost != null && this.slabMeshType == 1073742018 ? "mesh" : null;
    }

    public static Object[] getSlabWithinRange(float f, float f2) {
        return new Object[]{1073742114, new Float[]{Float.valueOf(f), Float.valueOf(f2)}, Boolean.FALSE, null};
    }

    public void resetSlab() {
        this.slabPolygons(MeshSurface.getSlabObject(0x10000B, null, false, null), false);
    }

    public static Object[] getSlabObject(int n, Object object, boolean bl, Object object2) {
        return new Object[]{n, object, bl, object2};
    }

    public static Object[] getCapSlabObject(String string, boolean bl) {
        try {
            if (string.indexOf("array") == 0) {
                String[] stringArray = TextFormat.split(string.substring(6, string.length() - 1), ",");
                return MeshSurface.getSlabObject(1679429641, new Point3f[]{(Point3f)Escape.unescapePoint(stringArray[0]), (Point3f)Escape.unescapePoint(stringArray[1]), (Point3f)Escape.unescapePoint(stringArray[2]), (Point3f)Escape.unescapePoint(stringArray[3])}, bl, null);
            }
            Object object = Escape.unescapePoint(string);
            if (object instanceof Point4f) {
                return MeshSurface.getSlabObject(135266319, object, bl, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void slabPolygons(List<Object[]> list, boolean bl) {
        for (int i = 0; i < list.size() && this.slabPolygons(list.get(i), bl); ++i) {
        }
    }

    public boolean slabPolygons(Object[] objectArray, boolean bl) {
        Object object;
        StringBuffer stringBuffer;
        block33: {
            boolean bl2;
            boolean bl3;
            if (this.polygonCount0 < 0) {
                return false;
            }
            int n = (Integer)objectArray[0];
            if (n == 0x10000B || n == 0x40000030) {
                if (this.bsSlabDisplay != null && (this.polygonCount0 != 0 || this.vertexCount0 != 0)) {
                    this.polygonCount = this.polygonCount0;
                    this.vertexCount = this.vertexCount0;
                    this.vertexCount0 = 0;
                    this.polygonCount0 = 0;
                    this.normixCount = this.isTriangleSet ? this.polygonCount : this.vertexCount;
                    this.bsSlabDisplay.set(0, this.polygonCount == 0 ? this.vertexCount : this.polygonCount);
                    this.slabOptions = new StringBuffer(this.meshType + " slab none");
                    this.bsSlabGhost = null;
                    this.slabMeshType = 0x10000B;
                }
                if (n == 0x10000B) {
                    return false;
                }
            }
            Object object2 = objectArray[1];
            boolean bl4 = bl3 = (Boolean)objectArray[2] != false && n != 0x40000030;
            if (bl3 && !bl) {
                return false;
            }
            Object[] objectArray2 = (Object[])objectArray[3];
            boolean bl5 = bl2 = objectArray2 != null;
            if (this.bsSlabDisplay == null || this.polygonCount0 == 0 && this.vertexCount0 == 0) {
                this.polygonCount0 = this.polygonCount;
                this.vertexCount0 = this.vertexCount;
                this.bsSlabDisplay = BitSetUtil.setAll(this.polygonCount == 0 ? this.vertexCount : this.polygonCount);
                this.bsSlabGhost = null;
                if (this.polygonCount == 0 && this.vertexCount == 0) {
                    return false;
                }
            } else if (this.isMerged) {
                if (this.polygonCount == 0) {
                    this.bsSlabDisplay.set(this.mergeVertexCount0, this.vertexCount);
                } else {
                    this.bsSlabDisplay.set(this.mergePolygonCount0, this.polygonCount);
                }
            }
            if (bl2) {
                if (this.bsSlabGhost == null) {
                    this.bsSlabGhost = new BitSet();
                }
                this.slabMeshType = (Integer)objectArray2[0];
                this.slabColix = (Short)objectArray2[1];
                if (Graphics3D.isColixColorInherited(this.slabColix)) {
                    this.slabColix = Graphics3D.copyColixTranslucency(this.slabColix, this.colix);
                }
                bl3 = false;
                this.colix = Graphics3D.getColixTranslucent(this.colix, false, 0.0f);
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(bl3 ? " cap " : " slab ");
            if (bl2) {
                stringBuffer.append("translucent ").append(Graphics3D.getColixTranslucencyFractional(this.slabColix)).append(" ").append(Graphics3D.getHexCode(this.slabColix)).append(" ");
            }
            block0 : switch (n) {
                case 0x40000030: {
                    stringBuffer.append("brillouin");
                    this.slabBrillouin((Point3f[])object2);
                    break;
                }
                case 3: {
                    this.getIntersection(0.0f, null, null, null, null, (BitSet)object2, null, bl3, false, 3, bl2);
                    break;
                }
                case 135266319: {
                    object = (Point4f)object2;
                    stringBuffer.append(Escape.escape(object));
                    this.getIntersection(0.0f, (Point4f)object, null, null, null, null, null, bl3, false, 135266319, bl2);
                    break;
                }
                case 1614417948: 
                case 1679429641: {
                    Point3f[] point3fArray = (Point3f[])object2;
                    stringBuffer.append("within ").append(Escape.escape(point3fArray));
                    Point4f[] point4fArray = BoxInfo.getFacesFromCriticalPoints(point3fArray);
                    for (int i = 0; i < point4fArray.length; ++i) {
                        this.getIntersection(0.0f, point4fArray[i], null, null, null, null, null, bl3, false, 135266319, bl2);
                    }
                    break;
                }
                case 135270407: {
                    this.getIntersection(0.0f, null, null, null, (float[])object2, null, null, false, false, 32, bl2);
                    break;
                }
                case 135266324: 
                case 1073742018: 
                case 1073742114: {
                    Object[] objectArray3 = (Object[])object2;
                    float f = ((Float)objectArray3[0]).floatValue();
                    switch (n) {
                        case 135266324: {
                            Point3f[] point3fArray = (Point3f[])objectArray3[1];
                            BitSet bitSet = (BitSet)objectArray3[2];
                            stringBuffer.append("within ").append(f).append(bitSet == null ? Escape.escape(point3fArray) : Escape.escape(bitSet));
                            this.getIntersection(f, null, point3fArray, null, null, null, null, bl3, false, f > 0.0f ? 1276118018 : 1073742154, bl2);
                            break block0;
                        }
                        case 1073742114: {
                            if (this.vertexValues == null) {
                                return false;
                            }
                            float f2 = ((Float)objectArray3[1]).floatValue();
                            stringBuffer.append("within range ").append(f).append(" ").append(f2);
                            BitSet bitSet = f2 < f ? BitSetUtil.copy(this.bsSlabDisplay) : null;
                            this.getIntersection(f, null, null, null, null, null, null, bl3, false, 32, bl2);
                            BitSet bitSet2 = bitSet == null ? null : BitSetUtil.copy(this.bsSlabDisplay);
                            BitSetUtil.copy(bitSet, this.bsSlabDisplay);
                            this.getIntersection(f2, null, null, null, null, null, null, bl3, false, 64, bl2);
                            if (bitSet2 != null) {
                                this.bsSlabDisplay.or(bitSet2);
                                break block0;
                            }
                            break block33;
                        }
                        case 1073742018: {
                            MeshSurface meshSurface = (MeshSurface)objectArray3[1];
                            this.getIntersection(0.0f, null, null, null, null, null, meshSurface, bl3, false, f < 0.0f ? 32 : 64, bl2);
                        }
                    }
                }
            }
        }
        object = stringBuffer.toString();
        if (this.slabOptions == null) {
            this.slabOptions = new StringBuffer();
        }
        if (this.slabOptions.indexOf((String)object) < 0) {
            this.slabOptions.append(this.slabOptions.length() > 0 ? "; " : "").append(this.meshType).append((String)object);
        }
        return true;
    }

    protected void slabBrillouin(Point3f[] point3fArray) {
    }

    protected int addIntersectionVertex(Point3f point3f, float f, int n, int n2, Map<String, Integer> map, int n3, int n4) {
        Integer n5;
        String string;
        String string2 = string = n3 > n4 ? n4 + "_" + n3 : n3 + "_" + n4;
        if (n3 >= 0 && (n5 = map.get(string)) != null) {
            return n5;
        }
        if (this.vertexSource != null) {
            if (this.vertexCount >= this.vertexSource.length) {
                this.vertexSource = ArrayUtil.doubleLength(this.vertexSource);
            }
            this.vertexSource[this.vertexCount] = n;
        }
        if (this.vertexSets != null) {
            if (this.vertexCount >= this.vertexSets.length) {
                this.vertexSets = ArrayUtil.doubleLength(this.vertexSets);
            }
            this.vertexSets[this.vertexCount] = n2;
        }
        int n6 = this.addVertexCopy(point3f, f, true, -4);
        map.put(string, n6);
        return n6;
    }

    protected int addVertexCopy(Point3f point3f, float f, boolean bl, int n) {
        return this.addVertexCopy(point3f, f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getIntersection(float f, Point4f point4f, Point3f[] point3fArray, List<Point3f[]> list, float[] fArray, BitSet bitSet, MeshSurface meshSurface, boolean bl, boolean bl2, int n, boolean bl3) {
        int n2;
        Object object;
        int n3;
        ArrayList<int[]> arrayList;
        boolean bl4 = list == null;
        Point3f[] point3fArray2 = null;
        if (fArray == null) {
            fArray = this.vertexValues;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        if (point3fArray != null || bl3) {
            bl = false;
        }
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        double d = Math.abs(f);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        ArrayList<int[]> arrayList2 = arrayList = bl ? new ArrayList<int[]>() : null;
        if (this.polygonCount == 0) {
            int n8 = this.mergeVertexCount0;
            while (true) {
                if (n8 >= this.vertexCount) {
                    return;
                }
                if (Float.isNaN(fArray[n8]) || MeshSurface.checkSlab(n, this.vertices[n8], fArray[n8], f, point4f, point3fArray, bitSet) > 0.0f) {
                    this.bsSlabDisplay.clear(n8);
                }
                ++n8;
            }
        }
        int n9 = this.polygonCount;
        block13: for (int i = this.mergePolygonCount0; i < n9; ++i) {
            if (!this.setABC(i)) continue;
            BitSet bitSet2 = this.bsSlabGhost != null && this.bsSlabGhost.get(i) ? this.bsSlabGhost : this.bsSlabDisplay;
            n3 = this.polygonIndexes[i][3];
            int n10 = this.checkCount == 2 ? this.polygonIndexes[i][4] : 0;
            object = this.vertices[this.iA];
            Point3f point3f = this.vertices[this.iB];
            Point3f point3f2 = this.vertices[this.iC];
            float f2 = fArray[this.iA];
            float f3 = fArray[this.iB];
            float f4 = fArray[this.iC];
            if (this.vertexSource != null) {
                n4 = this.vertexSource[this.iA];
                n5 = this.vertexSource[this.iB];
                n6 = this.vertexSource[this.iC];
            }
            if (this.vertexSets != null) {
                n7 = this.vertexSets[this.iA];
            }
            float f5 = MeshSurface.checkSlab(n, (Point3f)object, f2, bitSet == null ? f : (float)n4, point4f, point3fArray, bitSet);
            float f6 = MeshSurface.checkSlab(n, point3f, f3, bitSet == null ? f : (float)n5, point4f, point3fArray, bitSet);
            float f7 = MeshSurface.checkSlab(n, point3f2, f4, bitSet == null ? f : (float)n6, point4f, point3fArray, bitSet);
            n2 = (f5 != 0.0f && f5 < 0.0f ? 1 : 0) + (f6 != 0.0f && f6 < 0.0f ? 2 : 0) + (f7 != 0.0f && f7 < 0.0f ? 4 : 0);
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 6: {
                    if (point3fArray == null) {
                        point3fArray2 = new Point3f[]{MeshSurface.interpolatePoint((Point3f)object, point3f, -f5, f6, f2, f3, fArray2, fArray3, 0), MeshSurface.interpolatePoint((Point3f)object, point3f2, -f5, f7, f2, f4, fArray2, fArray3, 1)};
                        break;
                    }
                    point3fArray2 = new Point3f[]{this.interpolateSphere((Point3f)object, point3f, -f5, -f6, d, f2, f3, fArray2, fArray3, 0), this.interpolateSphere((Point3f)object, point3f2, -f5, -f7, d, f2, f4, fArray2, fArray3, 1)};
                    break;
                }
                case 2: 
                case 5: {
                    if (point3fArray == null) {
                        point3fArray2 = new Point3f[]{MeshSurface.interpolatePoint(point3f, (Point3f)object, -f6, f5, f3, f2, fArray2, fArray3, 1), MeshSurface.interpolatePoint(point3f, point3f2, -f6, f7, f3, f4, fArray2, fArray3, 0)};
                        break;
                    }
                    point3fArray2 = new Point3f[]{this.interpolateSphere(point3f, (Point3f)object, -f6, -f5, d, f3, f2, fArray2, fArray3, 1), this.interpolateSphere(point3f, point3f2, -f6, -f7, d, f3, f4, fArray2, fArray3, 0)};
                    break;
                }
                case 3: 
                case 4: {
                    point3fArray2 = point3fArray == null ? new Point3f[]{MeshSurface.interpolatePoint(point3f2, (Point3f)object, -f7, f5, f4, f2, fArray2, fArray3, 0), MeshSurface.interpolatePoint(point3f2, point3f, -f7, f6, f4, f3, fArray2, fArray3, 1)} : new Point3f[]{this.interpolateSphere(point3f2, (Point3f)object, -f7, -f5, d, f4, f2, fArray2, fArray3, 0), this.interpolateSphere(point3f2, point3f, -f7, -f6, d, f4, f3, fArray2, fArray3, 1)};
                }
            }
            this.doClear = true;
            this.doGhost = bl3;
            this.doCap = bl;
            if (bl4) {
                switch (n2) {
                    case 0: {
                        this.doCap = false;
                        break;
                    }
                    case 7: {
                        continue block13;
                    }
                    case 1: 
                    case 6: {
                        BitSet bitSet3;
                        boolean bl5;
                        boolean bl6 = bl5 = n2 == 1;
                        if (bl5 || bl3) {
                            if (!this.getDE(fArray3, 0, this.iA, this.iB, this.iC, bl5)) break;
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(point3fArray2[0], fArray2[0], n4, n7, hashtable, this.iA, this.iB);
                            }
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(point3fArray2[1], fArray2[1], n4, n7, hashtable, this.iA, this.iC);
                            }
                            bitSet3 = bl5 ? bitSet2 : this.bsSlabGhost;
                            this.addPolygon(this.iA, this.iD, this.iE, n3 & 5 | 2, n10, 0, bitSet3);
                            if (!bl3) break;
                        }
                        if (!this.getDE(fArray3, 1, this.iA, this.iC, this.iB, bl5)) break;
                        BitSet bitSet4 = bitSet3 = bl5 ? this.bsSlabGhost : bitSet2;
                        if (this.iE < 0) {
                            this.iE = this.addIntersectionVertex(point3fArray2[0], fArray2[0], n5, n7, hashtable, this.iA, this.iB);
                            this.addPolygon(this.iE, this.iB, this.iC, n3 & 3, n10, 0, bitSet3);
                        }
                        if (this.iD >= 0) break;
                        this.iD = this.addIntersectionVertex(point3fArray2[1], fArray2[1], n6, n7, hashtable, this.iA, this.iC);
                        this.addPolygon(this.iD, this.iE, this.iC, n3 & 4 | 1, n10, 0, bitSet3);
                        break;
                    }
                    case 2: 
                    case 5: {
                        boolean bl7;
                        BitSet bitSet3;
                        boolean bl8 = bl7 = n2 == 2;
                        if (bl7 || bl3) {
                            if (!this.getDE(fArray3, 0, this.iB, this.iC, this.iA, bl7)) break;
                            BitSet bitSet5 = bitSet3 = bl7 ? bitSet2 : this.bsSlabGhost;
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(point3fArray2[0], fArray2[0], n5, n7, hashtable, this.iB, this.iA);
                            }
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(point3fArray2[1], fArray2[1], n5, n7, hashtable, this.iB, this.iC);
                            }
                            this.addPolygon(this.iE, this.iB, this.iD, n3 & 3 | 4, n10, 0, bitSet3);
                            if (!bl3) break;
                        }
                        if (!this.getDE(fArray3, 1, this.iB, this.iA, this.iC, bl7)) break;
                        BitSet bitSet6 = bitSet3 = bl7 ? this.bsSlabGhost : bitSet2;
                        if (this.iD < 0) {
                            this.iD = this.addIntersectionVertex(point3fArray2[0], fArray2[0], n4, n7, hashtable, this.iB, this.iA);
                            this.addPolygon(this.iA, this.iD, this.iC, n3 & 5, n10, 0, bitSet3);
                        }
                        if (this.iE >= 0) break;
                        this.iE = this.addIntersectionVertex(point3fArray2[1], fArray2[1], n6, n7, hashtable, this.iB, this.iC);
                        this.addPolygon(this.iD, this.iE, this.iC, n3 & 2 | 1, n10, 0, bitSet3);
                        break;
                    }
                    case 3: 
                    case 4: {
                        boolean bl9;
                        BitSet bitSet3;
                        boolean bl10 = bl9 = n2 == 4;
                        if (bl9 || bl3) {
                            if (!this.getDE(fArray3, 0, this.iC, this.iA, this.iB, bl9)) break;
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(point3fArray2[0], fArray2[0], n6, n7, hashtable, this.iA, this.iC);
                            }
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(point3fArray2[1], fArray2[1], n6, n7, hashtable, this.iB, this.iC);
                            }
                            bitSet3 = bl9 ? bitSet2 : this.bsSlabGhost;
                            this.addPolygon(this.iD, this.iE, this.iC, n3 & 6 | 1, n10, 0, bitSet3);
                            if (!bl3) break;
                        }
                        if (!this.getDE(fArray3, 1, this.iC, this.iB, this.iA, bl9)) break;
                        BitSet bitSet7 = bitSet3 = bl9 ? this.bsSlabGhost : bitSet2;
                        if (this.iE < 0) {
                            this.iE = this.addIntersectionVertex(point3fArray2[0], fArray2[0], n4, n7, hashtable, this.iA, this.iC);
                            this.addPolygon(this.iA, this.iB, this.iE, n3 & 5, n10, 0, bitSet3);
                        }
                        if (this.iD >= 0) break;
                        this.iD = this.addIntersectionVertex(point3fArray2[1], fArray2[1], n5, n7, hashtable, this.iB, this.iC);
                        this.addPolygon(this.iE, this.iB, this.iD, n3 & 2 | 4, n10, 0, bitSet3);
                    }
                }
                if (this.doClear) {
                    bitSet2.clear(i);
                    if (this.doGhost) {
                        this.bsSlabGhost.set(i);
                    }
                }
                if (!this.doCap) continue;
                arrayList.add(new int[]{this.iD, this.iE});
                continue;
            }
            if (point3fArray2 == null) continue;
            list.add(point3fArray2);
        }
        if (bl && arrayList.size() > 0) {
            Point3f point3f = new Point3f();
            int n11 = arrayList.size();
            while (--n11 >= 0) {
                int[] nArray = (int[])arrayList.get(n11);
                point3f.add(this.vertices[nArray[0]]);
                point3f.add(this.vertices[nArray[1]]);
            }
            point3f.scale(0.5f / (float)arrayList.size());
            n11 = this.addIntersectionVertex(point3f, 0.0f, -1, n7, hashtable, -1, -1);
            n3 = arrayList.size();
            while (--n3 >= 0) {
                int[] nArray = (int[])arrayList.get(n3);
                this.addPolygon(nArray[0], n11, nArray[1], 0, 0, 0, this.bsSlabDisplay);
            }
        }
        if (!bl2) {
            return;
        }
        BitSet bitSet8 = new BitSet();
        BitSet bitSet9 = new BitSet();
        for (n3 = 0; n3 < this.polygonCount; ++n3) {
            if (this.polygonIndexes[n3] == null) continue;
            bitSet9.set(n3);
            for (int i = 0; i < 3; ++i) {
                bitSet8.set(this.polygonIndexes[n3][i]);
            }
        }
        n3 = 0;
        int n12 = bitSet9.cardinality();
        if (n12 == this.polygonCount) return;
        object = new int[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!bitSet8.get(i)) continue;
            object[i] = n3++;
        }
        Point3f[] point3fArray3 = new Point3f[n3];
        n3 = 0;
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!bitSet8.get(i)) continue;
            point3fArray3[n3++] = this.vertices[i];
        }
        int[][] nArrayArray = new int[n12][];
        n12 = 0;
        n2 = 0;
        while (true) {
            if (n2 >= this.polygonCount) {
                this.vertices = point3fArray3;
                this.vertexCount = n3;
                this.polygonIndexes = nArrayArray;
                this.polygonCount = n12;
                return;
            }
            if (this.polygonIndexes[n2] != null) {
                for (int i = 0; i < 3; ++i) {
                    this.polygonIndexes[n2][i] = (int)object[this.polygonIndexes[n2][i]];
                }
                nArrayArray[n12++] = this.polygonIndexes[n2];
            }
            ++n2;
        }
    }

    private static int setPoint(float[] fArray, int n, int n2, int n3) {
        return fArray[n] == 0.0f ? n2 : (fArray[n] == 1.0f ? n3 : -1);
    }

    private boolean getDE(float[] fArray, int n, int n2, int n3, int n4, boolean bl) {
        this.iD = MeshSurface.setPoint(fArray, n, n2, n3);
        this.iE = MeshSurface.setPoint(fArray, 1 - n, n2, n4);
        if (this.iD == n2 && this.iE == n2) {
            this.doClear = bl;
            this.doCap = false;
            return false;
        }
        if (this.iD == n3 && this.iE == n4) {
            this.doClear = !bl;
            return false;
        }
        if (this.iD == n2 || this.iE == n2) {
            this.doClear = bl;
            if (this.iD < 0) {
                this.iD = bl ? n3 : n4;
            } else if (this.iE < 0) {
                this.iE = bl ? n4 : n3;
            }
            return this.doCap;
        }
        this.doGhost = false;
        return true;
    }

    private static float checkSlab(int n, Point3f point3f, float f, float f2, Point4f point4f, Point3f[] point3fArray, BitSet bitSet) {
        float f3;
        switch (n) {
            case 3: {
                return bitSet.get((int)f) ? 1 : -1;
            }
            case 32: {
                f3 = f2 - f;
                break;
            }
            case 64: {
                f3 = f - f2;
                break;
            }
            case 135266319: {
                f3 = Measure.distanceToPlane(point4f, point3f);
                break;
            }
            case 1276118018: {
                f3 = MeshSurface.minDist(point3f, point3fArray) - f2;
                break;
            }
            default: {
                f3 = -MeshSurface.minDist(point3f, point3fArray) - f2;
            }
        }
        return Math.abs(f3) < 1.0E-4f ? 0.0f : f3;
    }

    private static float minDist(Point3f point3f, Point3f[] point3fArray) {
        float f = 2.1474836E9f;
        int n = point3fArray.length;
        while (--n >= 0) {
            float f2 = point3fArray[n].distance(point3f);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    private Point3f interpolateSphere(Point3f point3f, Point3f point3f2, float f, float f2, double d, float f3, float f4, float[] fArray, float[] fArray2, int n) {
        return MeshSurface.interpolateFraction(point3f, point3f2, MeshSurface.getSphericalInterpolationFraction(d, f, f2, point3f.distance(point3f2)), f3, f4, fArray, fArray2, n);
    }

    private static Point3f interpolatePoint(Point3f point3f, Point3f point3f2, float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, int n) {
        return MeshSurface.interpolateFraction(point3f, point3f2, f / (f + f2), f3, f4, fArray, fArray2, n);
    }

    private static Point3f interpolateFraction(Point3f point3f, Point3f point3f2, float f, float f2, float f3, float[] fArray, float[] fArray2, int n) {
        if ((double)f < 1.0E-4) {
            f = 0.0f;
        } else if ((double)f > 0.9999) {
            f = 1.0f;
        }
        fArray2[n] = f;
        fArray[n] = (f3 - f2) * f + f2;
        return new Point3f(point3f.x + (point3f2.x - point3f.x) * f, point3f.y + (point3f2.y - point3f.y) * f, point3f.z + (point3f2.z - point3f.z) * f);
    }

    public static float getSphericalInterpolationFraction(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d + d2) / d4;
        double d6 = Math.abs(d + d3) / d4;
        double d7 = d5 * d5;
        double d8 = d7 - d6 * d6 + 1.0;
        double d9 = 4.0 * ((d /= d4) * d - d7);
        double d10 = d5 < d6 ? 1 : -1;
        return (float)((d8 + d10 * Math.sqrt(d8 * d8 + d9)) / 2.0);
    }
}

