/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.api.ApiPlatform;
import org.jmol.util.DCT;
import org.jmol.util.Huffman;
import org.jmol.util.JpegInfo;
import org.jmol.util.Logger;

public class JpegEncoder {
    public static final String CONTINUE_STRING = " #Jmol...\u0000";
    private static final int CONTINUE_MAX = 65500;
    private static final int CONTINUE_MAX_BUFFER = 65510;
    private BufferedOutputStream outStream;
    private JpegInfo JpegObj;
    private Huffman Huf;
    private DCT dct;
    private int Quality;

    public JpegEncoder(ApiPlatform apiPlatform, Object object, int n, OutputStream outputStream, String string) {
        this.Quality = n;
        this.JpegObj = new JpegInfo(apiPlatform, object, string);
        this.outStream = new BufferedOutputStream(outputStream);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.JpegObj.imageWidth, this.JpegObj.imageHeight);
    }

    public static byte[] getBytes(ApiPlatform apiPlatform, Object object, int n, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JpegEncoder.write(apiPlatform, object, n, byteArrayOutputStream, string);
        try {
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void write(ApiPlatform apiPlatform, Object object, int n, OutputStream outputStream, String string) {
        new JpegEncoder(apiPlatform, object, n, outputStream, string).Compress();
    }

    public void setQuality(int n) {
        this.dct = new DCT(n);
    }

    public void Compress() {
        if (this.JpegObj == null) {
            return;
        }
        String string = JpegEncoder.WriteHeaders(this.outStream, this.JpegObj, this.dct);
        JpegEncoder.WriteCompressedData(this.outStream, this.JpegObj, this.dct, this.Huf);
        JpegEncoder.WriteEOI(this.outStream);
        if (string != null) {
            try {
                this.outStream.write(string.getBytes());
            }
            catch (IOException iOException) {
                System.out.println("ERROR WRITING COMMENT");
            }
        }
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            Logger.error("IO Error", iOException);
        }
    }

    private static void WriteCompressedData(BufferedOutputStream bufferedOutputStream, JpegInfo jpegInfo, DCT dCT, Huffman huffman) {
        int n;
        float[][] fArray = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[jpegInfo.NumberOfComponents];
        int n2 = huffman.ImageWidth % 8 != 0 ? (int)(Math.floor((double)huffman.ImageWidth / 8.0) + 1.0) * 8 : huffman.ImageWidth;
        int n3 = huffman.ImageHeight % 8 != 0 ? (int)(Math.floor((double)huffman.ImageHeight / 8.0) + 1.0) * 8 : huffman.ImageHeight;
        for (n = 0; n < jpegInfo.NumberOfComponents; ++n) {
            n2 = Math.min(n2, jpegInfo.BlockWidth[n]);
            n3 = Math.min(n3, jpegInfo.BlockHeight[n]);
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                n4 = j * 8;
                int n5 = i * 8;
                for (n = 0; n < jpegInfo.NumberOfComponents; ++n) {
                    float[][] fArray2 = jpegInfo.Components[n];
                    int n6 = jpegInfo.VsampFactor[n];
                    int n7 = jpegInfo.HsampFactor[n];
                    int n8 = jpegInfo.QtableNumber[n];
                    int n9 = jpegInfo.DCtableNumber[n];
                    int n10 = jpegInfo.ACtableNumber[n];
                    for (int k = 0; k < n6; ++k) {
                        for (int i2 = 0; i2 < n7; ++i2) {
                            int n11 = i2 * 8;
                            int n12 = k * 8;
                            for (int i3 = 0; i3 < 8; ++i3) {
                                for (int i4 = 0; i4 < 8; ++i4) {
                                    fArray[i3][i4] = fArray2[n5 + n12 + i3][n4 + n11 + i4];
                                }
                            }
                            dArray = DCT.forwardDCT(fArray);
                            nArray = DCT.quantizeBlock(dArray, dCT.divisors[n8]);
                            huffman.HuffmanBlockEncoder(bufferedOutputStream, nArray, nArray2[n], n9, n10);
                            nArray2[n] = nArray[0];
                        }
                    }
                }
            }
        }
        huffman.flushBuffer(bufferedOutputStream);
    }

    private static void WriteEOI(BufferedOutputStream bufferedOutputStream) {
        byte[] byArray = new byte[]{-1, -39};
        JpegEncoder.WriteMarker(byArray, bufferedOutputStream);
    }

    private static String WriteHeaders(BufferedOutputStream bufferedOutputStream, JpegInfo jpegInfo, DCT dCT) {
        int n;
        byte[] byArray = new byte[]{-1, -40};
        JpegEncoder.WriteMarker(byArray, bufferedOutputStream);
        byte[] byArray2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        JpegEncoder.writeArray(byArray2, bufferedOutputStream);
        String string = null;
        if (jpegInfo.Comment.length() > 0) {
            JpegEncoder.writeString(jpegInfo.Comment, (byte)-31, bufferedOutputStream);
        }
        JpegEncoder.writeString("JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.\n\n", (byte)-2, bufferedOutputStream);
        byte[] byArray3 = new byte[134];
        byArray3[0] = -1;
        byArray3[1] = -37;
        byArray3[2] = 0;
        byArray3[3] = -124;
        int n2 = 4;
        for (n = 0; n < 2; ++n) {
            byArray3[n2++] = (byte)(0 + n);
            int[] nArray = dCT.quantum[n];
            for (int i = 0; i < 64; ++i) {
                byArray3[n2++] = (byte)nArray[Huffman.jpegNaturalOrder[i]];
            }
        }
        JpegEncoder.writeArray(byArray3, bufferedOutputStream);
        byte[] byArray4 = new byte[19];
        byArray4[0] = -1;
        byArray4[1] = -64;
        byArray4[2] = 0;
        byArray4[3] = 17;
        byArray4[4] = (byte)jpegInfo.Precision;
        byArray4[5] = (byte)(jpegInfo.imageHeight >> 8 & 0xFF);
        byArray4[6] = (byte)(jpegInfo.imageHeight & 0xFF);
        byArray4[7] = (byte)(jpegInfo.imageWidth >> 8 & 0xFF);
        byArray4[8] = (byte)(jpegInfo.imageWidth & 0xFF);
        byArray4[9] = (byte)jpegInfo.NumberOfComponents;
        int n3 = 10;
        for (n = 0; n < byArray4[9]; ++n) {
            byArray4[n3++] = (byte)jpegInfo.CompID[n];
            byArray4[n3++] = (byte)((jpegInfo.HsampFactor[n] << 4) + jpegInfo.VsampFactor[n]);
            byArray4[n3++] = (byte)jpegInfo.QtableNumber[n];
        }
        JpegEncoder.writeArray(byArray4, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsDCluminance, Huffman.valDCluminance, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsACluminance, Huffman.valACluminance, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsDCchrominance, Huffman.valDCchrominance, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsACchrominance, Huffman.valACchrominance, bufferedOutputStream);
        byte[] byArray5 = new byte[14];
        byArray5[0] = -1;
        byArray5[1] = -38;
        byArray5[2] = 0;
        byArray5[3] = 12;
        byArray5[4] = (byte)jpegInfo.NumberOfComponents;
        n3 = 5;
        for (n = 0; n < byArray5[4]; ++n) {
            byArray5[n3++] = (byte)jpegInfo.CompID[n];
            byArray5[n3++] = (byte)((jpegInfo.DCtableNumber[n] << 4) + jpegInfo.ACtableNumber[n]);
        }
        byArray5[n3++] = (byte)jpegInfo.Ss;
        byArray5[n3++] = (byte)jpegInfo.Se;
        byArray5[n3++] = (byte)((jpegInfo.Ah << 4) + jpegInfo.Al);
        JpegEncoder.writeArray(byArray5, bufferedOutputStream);
        return string;
    }

    private static void writeString(String string, byte by, BufferedOutputStream bufferedOutputStream) {
        int n;
        int n2 = string.length();
        String string2 = CONTINUE_STRING;
        for (int i = 0; i < n2; i += n) {
            int n3;
            n = n2 - i;
            if (n > 65510 && (n3 = string.lastIndexOf(10, i + (n = 65500))) > i + 1) {
                n = n3 - i;
            }
            if (i + n == n2) {
                string2 = "";
            }
            JpegEncoder.writeTag(n + string2.length(), by, bufferedOutputStream);
            JpegEncoder.writeArray(string.substring(i, i + n).getBytes(), bufferedOutputStream);
            if (string2.length() <= 0) continue;
            JpegEncoder.writeArray(string2.getBytes(), bufferedOutputStream);
        }
    }

    private static void writeTag(int n, byte by, BufferedOutputStream bufferedOutputStream) {
        byte[] byArray = new byte[]{-1, by, (byte)((n += 2) >> 8 & 0xFF), (byte)(n & 0xFF)};
        JpegEncoder.writeArray(byArray, bufferedOutputStream);
    }

    static void WriteDHTHeader(int[] nArray, int[] nArray2, BufferedOutputStream bufferedOutputStream) {
        int n;
        int n2 = 4;
        int n3 = 4;
        byte[] byArray = new byte[17];
        byte[] byArray2 = new byte[4];
        byArray2[0] = -1;
        byArray2[1] = -60;
        int n4 = 0;
        byArray[n2++ - n3] = (byte)nArray[0];
        for (n = 1; n < 17; ++n) {
            int n5 = nArray[n];
            byArray[n2++ - n3] = (byte)n5;
            n4 += n5;
        }
        int n6 = n2;
        byte[] byArray3 = new byte[n4];
        for (n = 0; n < n4; ++n) {
            byArray3[n2++ - n6] = (byte)nArray2[n];
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray4, 0, n3);
        System.arraycopy(byArray, 0, byArray4, n3, 17);
        System.arraycopy(byArray3, 0, byArray4, n3 + 17, n4);
        byArray2 = byArray4;
        n3 = n2;
        byArray2[2] = (byte)(n2 - 2 >> 8 & 0xFF);
        byArray2[3] = (byte)(n2 - 2 & 0xFF);
        JpegEncoder.writeArray(byArray2, bufferedOutputStream);
    }

    static void WriteMarker(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            Logger.error("IO Error", iOException);
        }
    }

    static void writeArray(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            Logger.error("IO Error", iOException);
        }
    }
}

