/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumPalette;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.JmolEdge;

public class SticksRenderer
extends ShapeRenderer {
    private boolean showMultipleBonds;
    private float multipleBondSpacing;
    private float multipleBondRadiusFactor;
    private byte modeMultipleBond;
    private byte endcaps;
    private boolean ssbondsBackbone;
    private boolean hbondsBackbone;
    private boolean bondsBackbone;
    private boolean hbondsSolid;
    private Atom atomA;
    private Atom atomB;
    private Bond bond;
    private int xA;
    private int yA;
    private int zA;
    private int xB;
    private int yB;
    private int zB;
    private int dx;
    private int dy;
    private int mag2d;
    private short colixA;
    private short colixB;
    private int width;
    private boolean lineBond;
    private int bondOrder;
    private boolean renderWireframe;
    private boolean isAntialiased;
    private boolean slabbing;
    private boolean slabByAtom;
    private int[] dashDots;
    private final Vector3f x = new Vector3f();
    private final Vector3f y = new Vector3f();
    private final Vector3f z = new Vector3f();
    private final Point3f p1 = new Point3f();
    private final Point3f p2 = new Point3f();
    private final Point3i s1 = new Point3i();
    private final Point3i s2 = new Point3i();
    private Atom atomA0;
    private Atom atomB0;
    private int xAxis1;
    private int yAxis1;
    private int xAxis2;
    private int yAxis2;
    private int dxStep;
    private int dyStep;
    private static final int[] dashes = new int[]{12, 0, 0, 2, 5, 7, 10};
    private static final int[] hDashes = new int[]{10, 7, 6, 1, 3, 4, 6, 7, 9};
    private static final int[] sixdots = new int[]{12, 3, 6, 1, 3, 5, 7, 9, 11};
    private static final int[] fourdots = new int[]{13, 3, 5, 2, 5, 8, 11};
    private static final int[] twodots = new int[]{12, 3, 4, 3, 9};

    protected void render() {
        this.slabbing = this.viewer.getSlabEnabled();
        this.slabByAtom = this.viewer.getSlabByAtom();
        this.endcaps = (byte)3;
        this.dashDots = this.viewer.getPartialDots() ? sixdots : dashes;
        this.multipleBondSpacing = this.viewer.getMultipleBondSpacing();
        this.multipleBondRadiusFactor = this.viewer.getMultipleBondRadiusFactor();
        this.showMultipleBonds = this.multipleBondSpacing != 0.0f && this.viewer.getShowMultipleBonds();
        this.modeMultipleBond = this.viewer.getModeMultipleBond();
        this.renderWireframe = this.viewer.getInMotion() && this.viewer.getWireframeRotation();
        this.ssbondsBackbone = this.viewer.getSsbondsBackbone();
        this.hbondsBackbone = this.viewer.getHbondsBackbone();
        this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
        this.hbondsSolid = this.viewer.getHbondsSolid();
        this.isAntialiased = this.g3d.isAntialiased();
        Bond[] bondArray = this.modelSet.getBonds();
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            this.bond = bondArray[n];
            if ((this.bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0) continue;
            this.renderBond();
        }
    }

    private void renderBond() {
        this.atomA = this.atomA0 = this.bond.getAtom1();
        this.atomB = this.atomB0 = this.bond.getAtom2();
        int n = this.bond.order & 0xFFFDFFFF;
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (n & 0x100) != 0) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            } else if (this.hbondsBackbone && Bond.isHydrogen(n)) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            }
        }
        if (!this.atomA.isInFrame() || !this.atomB.isInFrame() || !this.g3d.isInDisplayRange(this.atomA.screenX, this.atomA.screenY) || !this.g3d.isInDisplayRange(this.atomB.screenX, this.atomB.screenY) || this.modelSet.isAtomHidden(this.atomA.getIndex()) || this.modelSet.isAtomHidden(this.atomB.getIndex())) {
            return;
        }
        if (this.slabbing) {
            if (this.g3d.isClippedZ(this.atomA.screenZ) && this.g3d.isClippedZ(this.atomB.screenZ)) {
                return;
            }
            if (this.slabByAtom && (this.g3d.isClippedZ(this.atomA.screenZ) || this.g3d.isClippedZ(this.atomB.screenZ))) {
                return;
            }
        }
        this.colixA = this.atomA0.getColix();
        this.colixB = this.atomB0.getColix();
        this.colix = this.bond.getColix();
        if ((this.colix & 0xFFFF87FF) == 2) {
            this.colix = (short)(this.colix & 0x7800);
            this.colixA = Graphics3D.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomA0, EnumPalette.CPK.id)), this.colixA);
            this.colixB = Graphics3D.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomB0, EnumPalette.CPK.id)), this.colixB);
        } else {
            this.colixA = Graphics3D.getColixInherited(this.colix, this.colixA);
            this.colixB = Graphics3D.getColixInherited(this.colix, this.colixB);
        }
        this.xA = this.atomA.screenX;
        this.yA = this.atomA.screenY;
        this.zA = this.atomA.screenZ;
        this.xB = this.atomB.screenX;
        this.yB = this.atomB.screenY;
        this.zB = this.atomB.screenZ;
        if (this.zA == 1 || this.zB == 1) {
            return;
        }
        this.bondOrder = n & 0xFFFDFFFF;
        if ((this.bondOrder & 0xE0) == 0) {
            if ((this.bondOrder & 0x100) != 0) {
                this.bondOrder &= 0xFFFFFEFF;
            }
            if ((this.bondOrder & 0x3FF) != 0 && (!this.showMultipleBonds || this.modeMultipleBond == 0 || this.modeMultipleBond == 2 && this.mad > 500)) {
                this.bondOrder = 1;
            }
        }
        int n2 = 0;
        switch (this.bondOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 17: 
            case 513: {
                this.bondOrder = 1;
                n2 = n == 513 ? 0 : 1;
                break;
            }
            case 514: 
            case 515: {
                this.bondOrder = 2;
                n2 = n == 515 ? this.getAromaticDottedBondMask() : 0;
                break;
            }
            default: {
                if ((this.bondOrder & 0xE0) != 0) {
                    this.bondOrder = JmolEdge.getPartialBondOrder(n);
                    n2 = JmolEdge.getPartialBondDotted(n);
                    break;
                }
                if (Bond.isHydrogen(this.bondOrder)) {
                    this.bondOrder = 1;
                    if (this.hbondsSolid) break;
                    n2 = -1;
                    break;
                }
                if (this.bondOrder != 32768) break;
                this.bondOrder = 1;
            }
        }
        this.mad = this.bond.getMad();
        if (this.multipleBondRadiusFactor > 0.0f && this.bondOrder > 1) {
            this.mad = (short)((float)this.mad * this.multipleBondRadiusFactor);
        }
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = this.viewer.scaleToScreen((this.zA + this.zB) / 2, this.mad);
        if (this.renderWireframe && this.width > 0) {
            this.width = 1;
        }
        boolean bl = this.lineBond = this.width <= 1;
        if (this.lineBond && this.isAntialiased) {
            this.width = 3;
            this.lineBond = false;
        }
        switch (n2) {
            case -1: {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, hDashes);
                break;
            }
            default: {
                this.drawBond(n2);
            }
        }
    }

    private void drawBond(int n) {
        boolean bl;
        boolean bl2;
        if (this.exportType == 1 && this.bondOrder == 1) {
            this.g3d.drawBond(this.atomA, this.atomB, this.colixA, this.colixB, this.endcaps, this.mad);
            return;
        }
        boolean bl3 = bl2 = this.dx == 0 && this.dy == 0;
        if (bl2 && this.lineBond) {
            return;
        }
        boolean bl4 = bl = this.bondOrder > 1 && this.multipleBondSpacing > 0.0f && (this.viewer.getHybridizationAndAxes(this.atomA.index, this.z, this.x, "pz") != null || this.viewer.getHybridizationAndAxes(this.atomB.index, this.z, this.x, "pz") != null) && !Float.isNaN(this.x.x);
        if (bl2 && !bl) {
            int n2 = this.width / 8 + 3;
            int n3 = this.width + n2;
            int n4 = this.yA - (this.bondOrder - 1) * n3 / 2;
            do {
                this.fillCylinder(this.colixA, this.colixA, this.endcaps, this.width, this.xA, n4, this.zA, this.xA, n4, this.zA);
                n4 += n3;
            } while (--this.bondOrder > 0);
            return;
        }
        if (this.bondOrder == 1) {
            if ((n & 1) != 0) {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        if (bl) {
            this.x.sub(this.atomB, this.atomA);
            this.y.cross(this.x, this.z);
            this.y.normalize();
            this.y.scale(this.multipleBondSpacing);
            this.x.set(this.y);
            this.x.scale((float)(this.bondOrder - 1) / 2.0f);
            this.p1.sub(this.atomA, this.x);
            this.p2.sub(this.atomB, this.x);
            while (true) {
                this.viewer.transformPoint(this.p1, this.s1);
                this.viewer.transformPoint(this.p2, this.s2);
                this.p1.add(this.y);
                this.p2.add(this.y);
                if ((n & 1) != 0) {
                    this.drawDashed(this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z, this.dashDots);
                } else {
                    this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z);
                }
                n >>= 1;
                if (--this.bondOrder <= 0) break;
                this.stepAxisCoordinates();
            }
            return;
        }
        int n5 = this.dx * this.dx;
        int n6 = this.dy * this.dy;
        this.mag2d = (int)(Math.sqrt(n5 + n6) + 0.5);
        this.resetAxisCoordinates();
        while (true) {
            if ((n & 1) != 0) {
                this.drawDashed(this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            n >>= 1;
            if (--this.bondOrder <= 0) break;
            this.stepAxisCoordinates();
        }
    }

    private void resetAxisCoordinates() {
        int n = this.mag2d >> 3;
        if (this.multipleBondSpacing != -1.0f && this.multipleBondSpacing < 0.0f) {
            n = (int)((float)n * -this.multipleBondSpacing);
        }
        int n2 = this.width + n;
        this.dxStep = n2 * this.dy / this.mag2d;
        this.dyStep = n2 * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        int n3 = this.bondOrder - 1;
        this.xAxis1 -= this.dxStep * n3 / 2;
        this.yAxis1 -= this.dyStep * n3 / 2;
        this.xAxis2 -= this.dxStep * n3 / 2;
        this.yAxis2 -= this.dyStep * n3 / 2;
    }

    private void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private int getAromaticDottedBondMask() {
        Atom atom = this.atomB.findAromaticNeighbor(this.atomA.getIndex());
        if (atom == null) {
            return 1;
        }
        int n = atom.screenY - this.yA;
        int n2 = atom.screenX - this.xA;
        return this.dx * n - this.dy * n2 < 0 ? 2 : 1;
    }

    private void drawDashed(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        boolean bl;
        int n7 = n4 - n;
        int n8 = n5 - n2;
        int n9 = n6 - n3;
        boolean bl2 = bl = nArray == sixdots;
        if (bl) {
            if (this.mad * 4 > 1500) {
                nArray = twodots;
            } else if (this.mad * 6 > 1500) {
                nArray = fourdots;
            }
        }
        float f = nArray[0];
        int n10 = nArray[1];
        int n11 = nArray[2];
        short s = this.colixA;
        short s2 = n11 == 0 ? this.colixB : this.colixA;
        for (int i = 3; i < nArray.length; ++i) {
            int n12 = nArray[i];
            int n13 = (int)((float)n + (float)(n7 * n12) / f);
            int n14 = (int)((float)n2 + (float)(n8 * n12) / f);
            int n15 = (int)((float)n3 + (float)(n9 * n12) / f);
            if (bl) {
                this.s1.set(n13, n14, n15);
                if (i == n10) {
                    this.g3d.setColix(this.colixA);
                } else if (i == n11) {
                    this.g3d.setColix(this.colixB);
                }
                this.g3d.fillSphere(this.width, this.s1);
                continue;
            }
            if (i == n10) {
                s = this.colixB;
            }
            n12 = nArray[++i];
            if (i == n11) {
                s2 = this.colixB;
            }
            int n16 = (int)((float)n + (float)(n7 * n12) / f);
            int n17 = (int)((float)n2 + (float)(n8 * n12) / f);
            int n18 = (int)((float)n3 + (float)(n9 * n12) / f);
            this.fillCylinder(s, s2, (byte)2, this.width, n13, n14, n15, n16, n17, n18);
        }
    }

    private void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.lineBond) {
            this.g3d.drawLine(s, s2, n2, n3, n4, n5, n6, n7);
        } else {
            this.g3d.fillCylinder(s, s2, by, !this.isExport || this.mad == 1 ? n : (int)this.mad, n2, n3, n4, n5, n6, n7);
        }
    }
}

