/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.ShapeRenderer;

public abstract class MeshRenderer
extends ShapeRenderer {
    protected Mesh mesh;
    protected Point3f[] vertices;
    protected short[] normixes;
    protected Point3i[] screens;
    protected Vector3f[] transformedVectors;
    protected int vertexCount;
    protected float imageFontScaling;
    protected float scalePixelsPerMicron;
    protected int diameter;
    protected float width;
    protected boolean isTranslucent;
    protected boolean frontOnly;
    protected boolean antialias;
    protected boolean haveBsDisplay;
    protected boolean haveBsSlabDisplay;
    protected boolean haveBsSlabGhost;
    protected Point4f thePlane;
    protected Point3f latticeOffset = new Point3f();
    protected final Point3f pt1f = new Point3f();
    protected final Point3f pt2f = new Point3f();
    protected final Point3i pt1i = new Point3i();
    protected final Point3i pt2i = new Point3i();
    protected final Point3i pt3i = new Point3i();
    protected int exportPass;
    private boolean doRender;
    protected boolean volumeRender;
    protected BitSet bsSlab;
    protected BitSet bsPolygons = new BitSet();

    protected void render() {
        this.antialias = this.g3d.isAntialiased();
        MeshCollection meshCollection = (MeshCollection)this.shape;
        int n = meshCollection.meshCount;
        while (--n >= 0) {
            this.render1(meshCollection.meshes[n]);
        }
    }

    public boolean render1(Mesh mesh) {
        this.mesh = mesh;
        if (!this.setVariables()) {
            return false;
        }
        if (!this.doRender) {
            return mesh.title != null;
        }
        this.latticeOffset.set(0.0f, 0.0f, 0.0f);
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.vertices[n] == null) continue;
            this.viewer.transformPoint(this.vertices[n], this.screens[n]);
        }
        if (mesh.lattice == null || mesh.modelIndex < 0) {
            this.render2(this.isExport);
        } else {
            SymmetryInterface symmetryInterface = mesh.unitCell;
            if (symmetryInterface == null) {
                symmetryInterface = this.viewer.getModelUnitCell(mesh.modelIndex);
            }
            if (symmetryInterface == null) {
                symmetryInterface = mesh.getUnitCell();
            }
            if (symmetryInterface != null) {
                Point3f point3f = new Point3f();
                Point3i point3i = new Point3i();
                Point3i point3i2 = new Point3i((int)mesh.lattice.x, (int)mesh.lattice.y, (int)mesh.lattice.z);
                symmetryInterface.setMinMaxLatticeParameters(point3i, point3i2);
                for (int i = point3i.x; i < point3i2.x; ++i) {
                    for (int j = point3i.y; j < point3i2.y; ++j) {
                        for (int k = point3i.z; k < point3i2.z; ++k) {
                            this.latticeOffset.set(i, j, k);
                            symmetryInterface.toCartesian(this.latticeOffset, false);
                            int n2 = this.vertexCount;
                            while (--n2 >= 0) {
                                point3f.set(this.vertices[n2]);
                                point3f.add(this.latticeOffset);
                                this.viewer.transformPoint(point3f, this.screens[n2]);
                            }
                            this.render2(this.isExport);
                        }
                    }
                }
            }
        }
        if (this.screens != null) {
            this.viewer.freeTempScreens(this.screens);
        }
        return true;
    }

    private boolean setVariables() {
        if (this.mesh.visibilityFlags == 0) {
            return false;
        }
        if (this.mesh.bsSlabGhost != null) {
            this.g3d.setColix(this.mesh.slabColix);
        }
        this.haveBsSlabGhost = this.mesh.bsSlabGhost != null && (this.isExport ? this.exportPass == 2 : this.g3d.isPass2());
        this.isTranslucent = this.haveBsSlabGhost || Graphics3D.isColixTranslucent(this.mesh.colix);
        boolean bl = this.doRender = this.setColix(this.mesh.colix) || this.mesh.showContourLines;
        if (!this.doRender) {
            return true;
        }
        if (this.haveBsSlabGhost && !(this.doRender = this.g3d.setColix(this.mesh.slabColix))) {
            return true;
        }
        Point3f[] point3fArray = this.vertices = this.mesh.scale3d == 0.0f && this.mesh.mat4 == null ? this.mesh.vertices : this.mesh.getOffsetVertices(this.thePlane);
        if (this.mesh.lineData == null) {
            this.vertexCount = this.mesh.vertexCount;
            if (this.vertexCount == 0) {
                return false;
            }
            this.normixes = this.mesh.normixes;
            if (this.normixes == null || this.vertices == null) {
                return false;
            }
            this.haveBsDisplay = this.mesh.bsDisplay != null;
            boolean bl2 = this.haveBsSlabDisplay = this.haveBsSlabGhost || this.mesh.bsSlabDisplay != null;
            this.bsSlab = this.haveBsSlabGhost ? this.mesh.bsSlabGhost : (this.haveBsSlabDisplay ? this.mesh.bsSlabDisplay : null);
            this.frontOnly = !this.viewer.getSlabEnabled() && this.mesh.frontOnly && !this.mesh.isTwoSided && !this.haveBsSlabDisplay;
            this.screens = this.viewer.allocTempScreens(this.vertexCount);
            this.transformedVectors = this.g3d.getTransformedVertexVectors();
        }
        return true;
    }

    protected boolean setColix(short s) {
        if (this.haveBsSlabGhost) {
            return true;
        }
        if (this.volumeRender && !this.isTranslucent) {
            s = Graphics3D.getColixTranslucent(s, true, 0.8f);
        }
        this.colix = s;
        if (Graphics3D.isColixLastAvailable(s)) {
            this.g3d.setColor(this.mesh.color);
        }
        return this.g3d.setColix(s);
    }

    protected boolean isPolygonDisplayable(int n) {
        return true;
    }

    protected void render2(boolean bl) {
        if (!this.g3d.setColix(this.haveBsSlabGhost ? this.mesh.slabColix : this.colix)) {
            return;
        }
        if (this.mesh.showPoints || this.mesh.polygonCount == 0) {
            this.renderPoints();
        }
        if (this.haveBsSlabGhost ? this.mesh.slabMeshType == 1073742018 : this.mesh.drawTriangles) {
            this.renderTriangles(false, this.mesh.showTriangles, false);
        }
        if (this.haveBsSlabGhost ? this.mesh.slabMeshType == 1073741938 : this.mesh.fillTriangles) {
            this.renderTriangles(true, this.mesh.showTriangles, bl);
        }
    }

    protected void renderPoints() {
        if (this.mesh.isTriangleSet) {
            int[][] nArray = this.mesh.polygonIndexes;
            BitSet bitSet = new BitSet(this.mesh.vertexCount);
            if (this.haveBsDisplay) {
                bitSet.set(0, this.mesh.vertexCount);
                bitSet.andNot(this.mesh.bsDisplay);
            }
            int n = this.mesh.polygonCount;
            while (--n >= 0) {
                if (!this.isPolygonDisplayable(n)) continue;
                int[] nArray2 = nArray[n];
                if (this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f) continue;
                int n2 = nArray2.length - 1;
                while (--n2 >= 0) {
                    int n3 = nArray2[n2];
                    if (bitSet.get(n3)) continue;
                    bitSet.set(n3);
                    this.g3d.fillSphere(4, this.screens[n3]);
                }
            }
            return;
        }
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.frontOnly && !(this.transformedVectors[this.normixes[n]].z >= 0.0f)) continue;
            this.g3d.fillSphere(4, this.screens[n]);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2, boolean bl3) {
        int[][] nArray = this.mesh.polygonIndexes;
        this.colix = this.haveBsSlabGhost ? this.mesh.slabColix : this.mesh.colix;
        this.g3d.setColix(this.colix);
        if (bl3) {
            if (this.frontOnly && bl) {
                this.frontOnly = false;
            }
            this.bsPolygons.clear();
        }
        int n = this.mesh.polygonCount;
        while (--n >= 0) {
            int n2;
            short s;
            if (!this.isPolygonDisplayable(n)) continue;
            int[] nArray2 = nArray[n];
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            if (this.haveBsDisplay && (!this.mesh.bsDisplay.get(n3) || !this.mesh.bsDisplay.get(n4) || !this.mesh.bsDisplay.get(n5))) continue;
            if (n4 == n5) {
                this.drawLine(n3, n4, bl, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                continue;
            }
            if (this.mesh.isTriangleSet) {
                s = this.normixes[n];
                if (!this.g3d.isDirectedTowardsCamera(s)) continue;
                if (bl) {
                    if (this.isExport) {
                        this.g3d.fillTriangle(this.screens[n5], this.colix, s, this.screens[n4], this.colix, s, this.screens[n3], this.colix, s);
                        continue;
                    }
                    if (bl2) {
                        this.g3d.fillTriangle(this.screens[n3], this.colix, s, this.screens[n4], this.colix, s, this.screens[n5], this.colix, s, 0.1f);
                        continue;
                    }
                    this.g3d.fillTriangle(this.screens[n3], this.colix, s, this.screens[n4], this.colix, s, this.screens[n5], this.colix, s);
                    continue;
                }
                n2 = nArray2[3];
                if (bl2) {
                    n2 = 7;
                }
                if ((n2 & 1) == 1) {
                    this.drawLine(n3, n4, true, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                }
                if ((n2 & 2) == 2) {
                    this.drawLine(n4, n5, true, this.vertices[n4], this.vertices[n5], this.screens[n4], this.screens[n5]);
                }
                if ((n2 & 4) != 4) continue;
                this.drawLine(n3, n5, true, this.vertices[n3], this.vertices[n5], this.screens[n3], this.screens[n5]);
                continue;
            }
            s = this.normixes[n3];
            short s2 = this.normixes[n4];
            short s3 = this.normixes[n5];
            n2 = this.checkNormals(s, s2, s3);
            if (bl && n2 != 7) continue;
            switch (nArray2.length) {
                case 3: {
                    if (bl) {
                        if (bl3) {
                            this.bsPolygons.set(n);
                            break;
                        }
                        if (bl2) {
                            this.g3d.fillTriangle(this.screens[n3], this.colix, s, this.screens[n4], this.colix, s2, this.screens[n5], this.colix, s3, 0.1f);
                            break;
                        }
                        this.g3d.fillTriangle(this.screens[n3], this.colix, s, this.screens[n4], this.colix, s2, this.screens[n5], this.colix, s3);
                        break;
                    }
                    this.drawTriangle(this.screens[n3], this.colix, this.screens[n4], this.colix, this.screens[n5], this.colix, n2, 1);
                    break;
                }
                case 4: {
                    int n6 = nArray2[3];
                    short s4 = this.normixes[n6];
                    if (this.frontOnly && (n2 != 7 || this.transformedVectors[s4].z < 0.0f)) break;
                    if (bl) {
                        if (bl3) {
                            this.bsPolygons.set(n);
                            break;
                        }
                        this.g3d.fillQuadrilateral(this.screens[n3], this.colix, s, this.screens[n4], this.colix, s2, this.screens[n5], this.colix, s3, this.screens[n6], this.colix, s4);
                        break;
                    }
                    this.g3d.drawQuadrilateral(this.colix, this.screens[n3], this.screens[n4], this.screens[n5], this.screens[n6]);
                }
            }
        }
        if (bl3) {
            this.exportSurface(this.colix);
        }
    }

    protected void drawTriangle(Point3i point3i, short s, Point3i point3i2, short s2, Point3i point3i3, short s3, int n, int n2) {
        if (this.antialias || n2 != 1) {
            if (this.antialias) {
                n2 <<= 1;
            }
            if ((n & 1) == 1) {
                this.g3d.fillCylinder(s, s2, (byte)1, n2, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z);
            }
            if ((n & 2) == 2) {
                this.g3d.fillCylinder(s2, s3, (byte)1, n2, point3i2.x, point3i2.y, point3i2.z, point3i3.x, point3i3.y, point3i3.z);
            }
            if ((n & 4) == 4) {
                this.g3d.fillCylinder(s, s3, (byte)1, n2, point3i.x, point3i.y, point3i.z, point3i3.x, point3i3.y, point3i3.z);
            }
        } else {
            this.g3d.drawTriangle(point3i, s, point3i2, s2, point3i3, s3, n);
        }
    }

    protected int checkNormals(short s, short s2, short s3) {
        int n = 7;
        if (this.frontOnly) {
            if (this.transformedVectors[s].z < 0.0f) {
                n ^= 1;
            }
            if (this.transformedVectors[s2].z < 0.0f) {
                n ^= 2;
            }
            if (this.transformedVectors[s3].z < 0.0f) {
                n ^= 4;
            }
        }
        return n;
    }

    protected void drawLine(int n, int n2, boolean bl, Point3f point3f, Point3f point3f2, Point3i point3i, Point3i point3i2) {
        byte by;
        byte by2 = n != n2 && !bl ? (byte)0 : (by = this.width < 0.0f || (double)this.width == -0.0 || n != n2 && this.isTranslucent ? (byte)2 : 3);
        if (this.width == 0.0f) {
            if (this.diameter == 0) {
                int n3 = this.mesh.diameter > 0 ? this.mesh.diameter : (this.diameter = n == n2 ? 7 : 3);
            }
            if (this.exportType == 1) {
                this.pt1f.set(point3f);
                this.pt1f.add(point3f2);
                this.pt1f.scale(0.5f);
                this.viewer.transformPoint(this.pt1f, this.pt1i);
                this.diameter = (int)(this.viewer.unscaleToScreen(this.pt1i.z, this.diameter) * 1000.0f);
            }
            if (n == n2) {
                this.g3d.fillSphere(this.diameter, point3i);
            } else {
                this.g3d.fillCylinder(by, this.diameter, point3i, point3i2);
            }
        } else {
            this.pt1f.set(point3f);
            this.pt1f.add(point3f2);
            this.pt1f.scale(0.5f);
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            int n4 = (int)(Math.abs(this.width) * 1000.0f);
            int n5 = this.diameter = this.exportType == 1 ? n4 : (int)this.viewer.scaleToScreen(this.pt1i.z, n4);
            if (this.diameter == 0) {
                this.diameter = 1;
            }
            this.viewer.transformPoint(point3f, this.pt1f);
            this.viewer.transformPoint(point3f2, this.pt2f);
            this.g3d.fillCylinderBits(by, this.diameter, this.pt1f, this.pt2f);
        }
    }

    protected void exportSurface(short s) {
        this.mesh.normals = this.mesh.getNormals(this.vertices, null);
        this.mesh.bsPolygons = this.bsPolygons;
        this.mesh.offset = this.latticeOffset;
        this.g3d.drawSurface(this.mesh, s);
        this.mesh.normals = null;
        this.mesh.bsPolygons = null;
    }
}

