/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumAnimationMode;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumStereoMode;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.script.ContextToken;
import org.jmol.script.ParallelProcessor;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.shape.Object2d;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEvaluator {
    public static final String SCRIPT_COMPLETED = "Script completed";
    private boolean tQuiet;
    protected boolean isSyntaxCheck;
    private boolean isCmdLine_C_Option;
    protected boolean isCmdLine_c_or_C_Option;
    private boolean historyDisabled;
    protected boolean logMessages;
    private boolean debugScript;
    private boolean interruptExecution;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean isExecuting;
    private long timeBeginExecution;
    private long timeEndExecution;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    ShapeManager shapeManager;
    private static final int scriptLevelMax = 100;
    private Thread currentThread;
    protected Viewer viewer;
    protected ScriptCompiler compiler;
    private Map<String, Object> definedAtomSets;
    private StringBuffer outputBuffer;
    private String contextPath = "";
    private String scriptFileName;
    private String functionName;
    private boolean isStateScript;
    int scriptLevel;
    private int scriptReportingLevel = 0;
    private int commandHistoryLevelMax = 0;
    private Token[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private Map<String, ScriptVariable> contextVariables;
    private String script;
    protected int pc;
    private String thisCommand;
    private String fullCommand;
    private Token[] statement;
    private int statementLength;
    private int iToken;
    private int lineEnd;
    private int pcEnd;
    private String scriptExtensions;
    private boolean forceNoAddHydrogens;
    private ParallelProcessor parallelProcessor;
    protected ScriptContext thisContext = null;
    private boolean error;
    private String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    private boolean ignoreError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    static final int ERROR_endOfStatementUnexpected = 13;
    static final int ERROR_expressionExpected = 14;
    static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    static final int ERROR_fileNotFoundException = 17;
    static final int ERROR_incompatibleArguments = 18;
    static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    static final int ERROR_invalidArgument = 22;
    static final int ERROR_invalidParameterOrder = 23;
    static final int ERROR_keywordExpected = 24;
    static final int ERROR_moCoefficients = 25;
    static final int ERROR_moIndex = 26;
    static final int ERROR_moModelError = 27;
    static final int ERROR_moOccupancy = 28;
    static final int ERROR_moOnlyOne = 29;
    static final int ERROR_multipleModelsDisplayedNotOK = 30;
    static final int ERROR_noData = 31;
    static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    static final int ERROR_what = 53;
    static final int ERROR_writeWhat = 54;
    static final int ERROR_multipleModelsNotOK = 55;
    static final int ERROR_cannotSet = 56;
    private Token[] tempStatement;
    private boolean isBondSet;
    private Object expressionResult;
    private int theTok;
    private Token theToken;
    private boolean coordinatesAreFractional;
    private Point3f fractionalPoint;
    private List<Token[]> vProcess;
    static int iProcess;
    private Object[] data;
    private static Object testData;
    private static Object testData2;

    public ScriptEvaluator(Viewer viewer) {
        this.viewer = viewer;
        this.compiler = this.compiler == null ? viewer.compiler : this.compiler;
        this.definedAtomSets = viewer.definedAtomSets;
        this.currentThread = Thread.currentThread();
    }

    public boolean compileScriptString(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = "[script]";
        return this.compileScript(null, string, this.debugScript);
    }

    private Object[] createFunction(String string, String string2, String string3) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator(this.viewer);
        try {
            scriptEvaluator.compileScript(null, "function " + string + "(" + string2 + ") { return " + string3 + "}", false);
            ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>();
            for (int i = 0; i < string2.length(); i += 2) {
                arrayList.add(ScriptVariable.getVariable(Float.valueOf(0.0f)).setName(string2.substring(i, i + 1)));
            }
            return new Object[]{scriptEvaluator.aatoken[0][1].value, arrayList};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean compileScriptFile(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = string;
        return this.compileScriptFileInternal(string, null, null, null);
    }

    public void evaluateCompiledScript(boolean bl, boolean bl2, boolean bl3, boolean bl4, StringBuffer stringBuffer) {
        boolean bl5 = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = bl2;
        this.viewer.pushHoldRepaint("runEval");
        this.executionPaused = false;
        this.interruptExecution = false;
        this.executionStepping = false;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.isSyntaxCheck = this.isCmdLine_c_or_C_Option = bl;
        this.timeBeginExecution = System.currentTimeMillis();
        this.historyDisabled = bl3;
        this.outputBuffer = stringBuffer;
        this.setErrorMessage(null);
        try {
            try {
                this.setScriptExtensions();
                this.instructionDispatchLoop(bl4);
                String string = this.viewer.getInterruptScript();
                if (string != "") {
                    this.runScript(string, null);
                }
            }
            catch (Error error) {
                this.viewer.handleError(error, false);
                this.setErrorMessage("" + error + " " + this.viewer.getShapeErrorState());
                this.errorMessageUntranslated = "" + error;
                this.scriptStatusOrBuffer(this.errorMessage);
            }
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            this.errorMessageUntranslated = scriptException.getErrorMessageUntranslated();
            this.scriptStatusOrBuffer(this.errorMessage);
            this.viewer.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
        }
        this.timeEndExecution = System.currentTimeMillis();
        this.isCmdLine_C_Option = bl5;
        if (this.errorMessage == null && this.interruptExecution) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && !this.isSyntaxCheck) {
            this.viewer.scriptStatus(SCRIPT_COMPLETED);
        }
        bl3 = false;
        bl = false;
        this.isSyntaxCheck = false;
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint("runEval");
    }

    public void runScript(String string, StringBuffer stringBuffer) throws ScriptException {
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = stringBuffer;
        if (this.compileScript(null, string + "\u0001## EDITOR_IGNORE ##", false)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext(false, false);
    }

    public ScriptContext checkScriptSilent(String string) {
        ScriptContext scriptContext = this.compiler.compile(null, string, false, true, false, true);
        if (scriptContext.errorType != null) {
            return scriptContext;
        }
        this.restoreScriptContext(scriptContext, false, false, false);
        this.isSyntaxCheck = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            scriptContext = this.getScriptContext();
        }
        this.isSyntaxCheck = false;
        return scriptContext;
    }

    public void setDebugging() {
        this.debugScript = this.viewer.getDebugScript();
        this.logMessages = this.debugScript && Logger.debugging;
    }

    public int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    public void haltExecution() {
        this.resumePausedExecution();
        this.interruptExecution = true;
    }

    public void pauseExecution(boolean bl) {
        if (this.isSyntaxCheck || this.viewer.isHeadless()) {
            return;
        }
        if (bl) {
            this.delay(-100L);
        }
        this.viewer.popHoldRepaint("pauseExecution");
        this.executionStepping = false;
        this.executionPaused = true;
    }

    public void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    public void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    public boolean isScriptExecuting() {
        return this.isExecuting && !this.interruptExecution;
    }

    public boolean isExecutionPaused() {
        return this.executionPaused;
    }

    public boolean isExecutionStepping() {
        return this.executionStepping;
    }

    public String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEvaluator.setErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.aatoken[this.pc], -9999, this.logMessages)) : "";
    }

    private String getCommand(int n, boolean bl, boolean bl2) {
        if (n >= this.lineIndices.length) {
            return "";
        }
        if (bl) {
            int n2 = -1;
            int n3 = this.script.length();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[n]) {
                    if (n2 < 0) {
                        n2 = this.lineIndices[i][0];
                    }
                    n3 = this.lineIndices[i][1];
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[n]) break;
            }
            if (n3 == this.script.length() - 1 && this.script.endsWith("}")) {
                ++n3;
            }
            return n2 == this.script.length() || n3 < n2 ? "" : this.script.substring(Math.max(n2, 0), Math.min(this.script.length(), n3));
        }
        int n4 = this.lineIndices[n][0];
        int n5 = this.lineIndices[n][1];
        String string = "";
        if (n4 < 0 || n5 <= n4 || n5 > this.script.length()) {
            return "";
        }
        try {
            string = this.script.substring(n4, n5);
            if (string.indexOf("\\\n") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\n", "  ");
            }
            if (string.indexOf("\\\r") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\r", "  ");
            }
            if (string.length() > 0 && !string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + n4 + " ichEnd=" + n5 + " len = " + this.script.length() + "\n" + exception);
        }
        return string;
    }

    private void logDebugScript(int n) {
        if (this.logMessages) {
            if (this.statement.length > 0) {
                Logger.debug(this.statement[0].toString());
            }
            for (int i = 1; i < this.statementLength; ++i) {
                Logger.debug(this.statement[i].toString());
            }
        }
        this.iToken = -9999;
        if (this.logMessages) {
            StringBuffer stringBuffer = new StringBuffer(80);
            String string = n > 0 ? "                          ".substring(0, n * 2) : "";
            stringBuffer.append(string).append(ScriptEvaluator.statementAsString(this.statement, this.iToken, this.logMessages));
            this.viewer.scriptStatus(stringBuffer.toString());
        } else {
            String string = this.getCommand(this.pc, false, false);
            if (string != "") {
                this.viewer.scriptStatus(string);
            }
        }
    }

    public static Object evaluateExpression(Viewer viewer, Object object) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator(viewer);
        return scriptEvaluator.evaluate(object);
    }

    private Object evaluate(Object object) {
        try {
            if (object instanceof String) {
                if (this.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + object, false)) {
                    this.contextVariables = this.viewer.getContextVariables();
                    this.setStatement(0);
                    return this.parameterExpressionString(2, 0);
                }
            } else if (object instanceof Token[]) {
                this.contextVariables = this.viewer.getContextVariables();
                return this.atomExpression((Token[])object, 0, 0, true, false, true, false);
            }
        }
        catch (Exception exception) {
            Logger.error("Error evaluating: " + object + "\n" + exception);
        }
        return "ERROR";
    }

    public static boolean evaluateContext(Viewer viewer, ScriptContext scriptContext, ShapeManager shapeManager) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator(viewer);
        scriptEvaluator.historyDisabled = true;
        scriptEvaluator.compiler = new ScriptCompiler(scriptEvaluator.compiler);
        scriptEvaluator.shapeManager = shapeManager;
        try {
            scriptEvaluator.restoreScriptContext(scriptContext, true, false, false);
            scriptEvaluator.instructionDispatchLoop(false);
        }
        catch (Exception exception) {
            viewer.setStringProperty("_errormessage", "" + exception);
            Logger.error("Error evaluating context");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static BitSet getAtomBitSet(ScriptEvaluator scriptEvaluator, Object object) {
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        BitSet bitSet = new BitSet();
        try {
            scriptEvaluator.pushContext(null);
            String string = "select (" + object + ")";
            string = TextFormat.replaceAllCharacters(string, "\n\r", "),(");
            string = TextFormat.simpleReplace(string, "()", "(none)");
            if (scriptEvaluator.compileScript(null, string, false)) {
                scriptEvaluator.statement = scriptEvaluator.aatoken[0];
                bitSet = scriptEvaluator.atomExpression(scriptEvaluator.statement, 1, 0, false, false, true, true);
            }
            scriptEvaluator.popContext(false, false);
        }
        catch (Exception exception) {
            Logger.error("getAtomBitSet " + object + "\n" + exception);
        }
        return bitSet;
    }

    public static List<Integer> getAtomBitSetVector(ScriptEvaluator scriptEvaluator, int n, Object object) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        BitSet bitSet = ScriptEvaluator.getAtomBitSet(scriptEvaluator, object);
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            arrayList.add(n2);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return arrayList;
    }

    private List<ScriptVariable> parameterExpressionList(int n, int n2, boolean bl) throws ScriptException {
        return (List)this.parameterExpression(n, -1, null, true, true, n2, bl, null, null);
    }

    private String parameterExpressionString(int n, int n2) throws ScriptException {
        return (String)this.parameterExpression(n, n2, "", true, false, -1, false, null, null);
    }

    private boolean parameterExpressionBoolean(int n, int n2) throws ScriptException {
        return (Boolean)this.parameterExpression(n, n2, null, true, false, -1, false, null, null);
    }

    private ScriptVariable parameterExpressionToken(int n) throws ScriptException {
        List<ScriptVariable> list = this.parameterExpressionList(n, -1, false);
        return list.size() > 0 ? list.get(0) : ScriptVariable.getVariable("");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parameterExpression(int n, int n2, String string, boolean bl, boolean bl2, int n3, boolean bl3, Map hashtable, String string2) throws ScriptException {
        ScriptVariable scriptVariable;
        boolean bl4 = string2 != null;
        boolean bl5 = n < 0;
        boolean bl6 = !bl2 && string == null;
        boolean bl7 = !bl2 && string != null && string.length() == 0;
        int n4 = 0;
        if (bl5) {
            n = -n;
        }
        int n5 = 0;
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, bl3, bl2, false);
        if (n == 0 && n2 == 0) {
            n = 2;
        }
        if (n2 < n) {
            n2 = this.statementLength;
        }
        block35: for (int i = n; i < n2; ++i) {
            void var10_19;
            Object var10_20 = null;
            int n6 = this.getToken((int)i).tok;
            if (bl4 && this.tokAt(i + 1) != 0x100008) {
                ScriptVariable scriptVariable2;
                ScriptVariable scriptVariable3 = scriptVariable2 = hashtable != null && hashtable.containsKey(this.theToken.value) ? null : this.getBitsetPropertySelector(i, false);
                if (scriptVariable2 != null) {
                    scriptMathProcessor.addX((ScriptVariable)hashtable.get(string2));
                    if (!scriptMathProcessor.addOp(scriptVariable2, this.tokAt(i + 1) == 0x10100010)) {
                        this.error(22);
                    }
                    if ((scriptVariable2.intValue == 135368713 || scriptVariable2.intValue == 102436) && this.tokAt(this.iToken + 1) != 0x10100010) {
                        scriptMathProcessor.addOp(Token.tokenLeftParen);
                        scriptMathProcessor.addOp(Token.tokenRightParen);
                    }
                    i = this.iToken;
                    continue;
                }
            }
            block1 : switch (n6) {
                case 1060866: {
                    void var10_24;
                    if (this.tokAt(++i) == 0x100001) {
                        ScriptVariable scriptVariable4 = this.parameterExpressionToken(++i);
                        i = this.iToken;
                    } else {
                        if (this.tokAt(i) == 2) {
                            BitSet bitSet = this.viewer.getAtomBits(1095763969, this.statement[i].intValue);
                            break;
                        }
                        Object object = this.getParameter(ScriptVariable.sValue(this.statement[i]), 1073742190);
                    }
                    Object object = this.getParameter(((ScriptVariable)var10_24).asString(), 1073742190);
                    break;
                }
                case 135369225: {
                    if (this.getToken((int)(++i)).tok != 0x10100010) {
                        this.error(22);
                    }
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    Object object3 = this.parameterExpression(++i, -1, null, bl, false, -1, false, hashtable, string2);
                    boolean bl8 = (Boolean)object3;
                    int n7 = this.iToken;
                    if (this.getToken((int)n7++).tok != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpressionBoolean(n7, -1);
                    int n8 = this.iToken;
                    if (this.tokAt(n8++) != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpression(-n8, -1, null, bl, false, 1, false, hashtable, string2);
                    int n9 = this.iToken;
                    if (this.tokAt(n9) != 0x10100011) {
                        this.error(22);
                    }
                    Object object2 = this.parameterExpression(bl8 ? n7 : n8, bl8 ? n8 : n9, "XXX", bl, false, 1, false, hashtable, string2);
                    i = n9;
                    break;
                }
                case 135280132: 
                case 135369224: {
                    int n10;
                    int n11;
                    String[] stringArray;
                    Object object;
                    String string3;
                    boolean bl9;
                    Object object3;
                    boolean bl10 = n > 0;
                    boolean bl11 = bl9 = bl10 && n6 == 135369224;
                    if (bl10) {
                        if (this.getToken((int)(++i)).tok != 0x10100010 || !Token.tokAttr(this.getToken((int)(++i)).tok, 0x40000000)) {
                            this.error(22);
                        }
                        string3 = this.parameterAsString(i);
                        if (this.getToken((int)(++i)).tok != 0x10000F) {
                            this.error(22);
                        }
                    } else {
                        string3 = "_x";
                    }
                    if (!((object = this.parameterExpressionToken((int)(-(++i))).value) instanceof BitSet)) {
                        this.error(22);
                    }
                    BitSet bitSet = (BitSet)object;
                    i = this.iToken;
                    if (bl10 && this.getToken((int)i++).tok != 0x10000F) {
                        this.error(22);
                    }
                    BitSet bitSet2 = new BitSet();
                    BitSet bitSet3 = new BitSet();
                    String[] stringArray2 = stringArray = bl9 ? new String[BitSetUtil.cardinalityOf(bitSet)] : null;
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    bitSet3.set(0);
                    ScriptVariable scriptVariable5 = new ScriptVariable(bitSet3, 0);
                    hashtable.put(string3, scriptVariable5.setName(string3));
                    int n12 = -1;
                    if (bl10) {
                        n12 = i - 1;
                        n11 = 0;
                        while (n11 >= 0 && ++n12 < n2) {
                            n10 = this.tokAt(n12);
                            if (n10 == 0x10100011) {
                                --n11;
                                continue;
                            }
                            if (n10 != 0x10100010) continue;
                            ++n11;
                        }
                    }
                    n11 = 0;
                    n10 = 0;
                    int n13 = bitSet.nextSetBit(0);
                    if (n13 < 0) {
                        this.iToken = n12 - 1;
                    } else if (!this.isSyntaxCheck) {
                        while (n13 >= 0) {
                            if (n10 >= 0) {
                                bitSet3.clear(n10);
                            }
                            n10 = n13;
                            bitSet3.set(n13);
                            scriptVariable5.index = n13;
                            object3 = this.parameterExpression(i, n12, bl9 ? "XXX" : null, bl, bl9, n13, false, hashtable, bl10 ? null : string3);
                            if (bl9) {
                                if (object3 == null || ((List)object3).size() == 0) {
                                    this.error(22);
                                }
                                stringArray[n11++] = ((ScriptVariable)((List)object3).get(0)).asString();
                            } else if (((Boolean)object3).booleanValue()) {
                                bitSet2.set(n13);
                            }
                            n13 = bitSet.nextSetBit(n13 + 1);
                        }
                    }
                    if (bl9) {
                        String[] stringArray3 = stringArray;
                    } else {
                        if (!bl10) return this.bitsetVariableVector(bitSet2);
                        BitSet bitSet4 = bitSet2;
                    }
                    i = this.iToken + 1;
                    break;
                }
                case 0x10000F: {
                    break block35;
                }
                case 3: {
                    scriptMathProcessor.addXNum(ScriptVariable.getVariable(this.theToken.value));
                    break;
                }
                case 2: 
                case 1048614: {
                    scriptMathProcessor.addXNum(ScriptVariable.intVariable(this.theToken.intValue));
                    break;
                }
                case 135266319: {
                    if (this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (scriptMathProcessor.addOp(this.theToken, true)) break;
                        this.error(22);
                        break;
                    }
                    scriptMathProcessor.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 0x100004: 
                case 0x100006: 
                case 0x10000C: 
                case 0x10000D: 
                case 135267335: 
                case 135267336: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373320: 
                case 1087375361: 
                case 1087375362: 
                case 1087375365: 
                case 1095761934: 
                case 1095761938: 
                case 1095766028: 
                case 1238369286: 
                case 1641025539: 
                case 1679429641: {
                    scriptMathProcessor.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 0x100007: {
                    this.ignoreError = true;
                    try {
                        Point3f point3f = this.centerParameter(i);
                        scriptMathProcessor.addX(new ScriptVariable(8, point3f));
                    }
                    catch (Exception exception) {
                        scriptMathProcessor.addX("");
                    }
                    this.ignoreError = false;
                    i = this.iToken;
                    break;
                }
                case 0x10000A: {
                    if (this.tokAt(i + 1) == 4) {
                        Map<String, Object> map = this.getHash(i);
                    } else {
                        Object object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    }
                    i = this.iToken;
                    break;
                }
                case 0x100001: {
                    if (this.tokAt(i + 1) == 0x100002) {
                        Hashtable hashtable2 = new Hashtable();
                        ++i;
                        break;
                    }
                    if (this.tokAt(i + 1) == 0x100003 && this.tokAt(i + 2) == 0x100002) {
                        n6 = 0x100003;
                        this.iToken += 2;
                    }
                }
                case 0x100003: {
                    void var10_37;
                    if (n6 == 0x100003) {
                        BitSet bitSet = this.viewer.getModelUndeletedAtomsBitSet(-1);
                    } else {
                        BitSet bitSet = this.atomExpression(this.statement, i, 0, true, true, true, true);
                    }
                    i = this.iToken++;
                    if (n5 != 0 || !bl5) break;
                    return this.bitsetVariableVector(var10_37);
                }
                case 1073742195: {
                    scriptMathProcessor.addOp(this.theToken);
                    continue block35;
                }
                case 0x100002: {
                    ++i;
                    break block35;
                }
                case 0x10000E: {
                    if (!bl && n5 == 0 && n4 == 0) break block35;
                    this.error(22);
                    break;
                }
                case 0x10100030: {
                    if (!bl && n5 == 0 && n4 == 0) break block35;
                    if (scriptMathProcessor.addOp(this.theToken)) break;
                    this.error(22);
                    break;
                }
                case 0x100008: {
                    ScriptVariable scriptVariable6 = this.getBitsetPropertySelector(i + 1, false);
                    if (scriptVariable6 == null) {
                        this.error(22);
                    }
                    boolean bl12 = scriptVariable6.intValue == 135368713;
                    boolean bl13 = true;
                    int n14 = this.tokAt(this.iToken + 2);
                    if (this.tokAt(this.iToken + 1) == 0x100008) {
                        switch (n14) {
                            case 0x100003: {
                                n14 = 480;
                                if (this.tokAt(this.iToken + 3) == 0x100008 && this.tokAt(this.iToken + 4) == 1276118529) {
                                    n14 = 224;
                                }
                            }
                            case 32: 
                            case 64: 
                            case 96: 
                            case 128: 
                            case 160: 
                            case 192: {
                                bl13 = bl12 || n14 == 480 || n14 == 224;
                                scriptVariable6.intValue |= n14;
                                this.getToken(this.iToken + 2);
                                break;
                            }
                        }
                    }
                    if (!scriptMathProcessor.addOp(scriptVariable6, bl13 &= this.tokAt(this.iToken + 1) == 0x10100010 || bl12)) {
                        this.error(22);
                    }
                    i = this.iToken;
                    if (scriptVariable6.intValue != 135368713 || this.tokAt(i + 1) == 0x10100010) break;
                    scriptMathProcessor.addOp(Token.tokenLeftParen);
                    scriptMathProcessor.addOp(Token.tokenRightParen);
                    break;
                }
                default: {
                    void var10_42;
                    Object v;
                    boolean bl14;
                    if (Token.tokAttr(this.theTok, 0x10100000) || Token.tokAttr(this.theTok, 0x8100000) && this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (!scriptMathProcessor.addOp(this.theToken)) {
                            if (n3 >= 0) break block35;
                            this.error(22);
                        }
                        switch (this.theTok) {
                            case 0x10100010: {
                                ++n5;
                                break block1;
                            }
                            case 0x10100011: {
                                if (--n5 > 0 || n4 != 0 || !bl5) break;
                                ++this.iToken;
                                break block35;
                            }
                            case 0x10100040: {
                                ++n4;
                                break block1;
                            }
                            case 0x10100041: {
                                if (--n4 != 0 || n5 != 0 || !bl5) break;
                                ++this.iToken;
                                break block35;
                            }
                        }
                        break;
                    }
                    String string4 = this.parameterAsString(i).toLowerCase();
                    boolean bl15 = bl14 = this.tokAt(i + 1) == 0x10100010;
                    if (this.isSyntaxCheck) {
                        String string5 = string4;
                    } else if (!(bl14 || hashtable != null && (v = hashtable.get(string4)) != null)) {
                        ScriptVariable scriptVariable7 = this.getContextVariableAsVariable(string4);
                    }
                    if (var10_42 != null) break;
                    if (Token.tokAttr(this.theTok, 0x40000000) && this.viewer.isFunction(string4)) {
                        if (!scriptMathProcessor.addOp(new ScriptVariable(135368713, this.theToken.value))) {
                            this.error(22);
                        }
                        if (bl14) break;
                        scriptMathProcessor.addOp(Token.tokenLeftParen);
                        scriptMathProcessor.addOp(Token.tokenRightParen);
                        break;
                    }
                    scriptMathProcessor.addX(this.viewer.getOrSetNewVariable(string4, false));
                }
            }
            if (var10_19 == null) continue;
            if (var10_19 instanceof BitSet) {
                scriptMathProcessor.addX((BitSet)var10_19);
                continue;
            }
            scriptMathProcessor.addX(var10_19);
        }
        if ((scriptVariable = scriptMathProcessor.getResult(false)) == null) {
            if (!this.isSyntaxCheck) {
                scriptMathProcessor.dumpStacks("null result");
            }
            this.error(13);
        }
        if (scriptVariable.tok == 135198) {
            return scriptVariable.value;
        }
        if (bl6) {
            return ScriptVariable.bValue(scriptVariable);
        }
        if (bl7) {
            if (scriptVariable.tok != 4) return scriptVariable.asString();
            scriptVariable.intValue = Integer.MAX_VALUE;
            return scriptVariable.asString();
        }
        switch (scriptVariable.tok) {
            case 0x10000C: 
            case 0x10000D: {
                boolean bl16;
                if (scriptVariable.intValue == 1) {
                    bl16 = true;
                    return bl16;
                }
                bl16 = false;
                return bl16;
            }
            case 2: {
                return scriptVariable.intValue;
            }
        }
        return scriptVariable.value;
    }

    private Map<String, Object> getHash(int n) throws ScriptException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ++n;
        while (n < this.statementLength && this.tokAt(n) != 0x10000E) {
            String string = this.stringParameter(n++);
            if (this.tokAt(n++) != 0x10100022) {
                this.error(22);
            }
            List list = (List)this.parameterExpression(n, 0, null, false, true, -1, false, null, null);
            hashtable.put(string, list.get(0));
            n = this.iToken;
            if (this.tokAt(n) != 0x10100030) break;
            ++n;
        }
        this.iToken = n;
        if (this.tokAt(n) != 0x10000E) {
            this.error(22);
        }
        return hashtable;
    }

    List<ScriptVariable> bitsetVariableVector(Object object) {
        ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>();
        if (object instanceof BitSet) {
            arrayList.add(new ScriptVariable(10, object));
        }
        return arrayList;
    }

    Object getBitsetIdent(BitSet bitSet, String stringArray, Object object, boolean bl, int n, boolean bl2) {
        int n2;
        Map<String, Object> map;
        int[] nArray;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = !(object instanceof Bond.BondSet);
        if (bl4) {
            if (stringArray == null) {
                stringArray = this.viewer.getStandardLabelFormat(0);
            } else if (stringArray.length() == 0) {
                stringArray = "%[label]";
            }
        }
        int n3 = stringArray == null ? -1 : stringArray.indexOf("%");
        boolean bl6 = bl3 = n != Integer.MAX_VALUE;
        if (bitSet == null || this.isSyntaxCheck || bl4 && n3 < 0) {
            String[] stringArray2;
            if (stringArray == null) {
                stringArray = "";
            }
            if (bl2) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = stringArray;
            } else {
                stringArray2 = stringArray;
            }
            return stringArray2;
        }
        ModelSet modelSet = this.viewer.getModelSet();
        int n4 = 0;
        int[] nArray2 = nArray = bl4 || !bl ? null : ((Bond.BondSet)object).getAssociatedAtoms();
        if (nArray == null && stringArray != null && stringArray.indexOf("%D") > 0) {
            nArray = this.viewer.getAtomIndices(bitSet);
        }
        boolean bl7 = stringArray == null || stringArray.length() == 0;
        Map<String, Object> map2 = map = bl4 || bl7 ? null : LabelToken.getBondLabelValues();
        LabelToken[] labelTokenArray = bl7 ? null : (bl4 ? LabelToken.compile(this.viewer, (String)stringArray, '\u0000', null) : LabelToken.compile(this.viewer, (String)stringArray, '\u0001', map));
        int n5 = bl3 ? 1 : BitSetUtil.cardinalityOf(bitSet);
        String[] stringArray4 = new String[n5];
        int n6 = n2 = bl3 ? n : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            String string;
            if (bl4) {
                string = bl7 ? modelSet.atoms[n2].getInfo() : LabelToken.formatLabel(this.viewer, modelSet.atoms[n2], labelTokenArray, '\u0000', nArray);
            } else {
                Bond bond = modelSet.getBondAt(n2);
                string = bl7 ? bond.getIdentity() : LabelToken.formatLabel(this.viewer, bond, labelTokenArray, map, nArray);
            }
            string = TextFormat.formatString(string, "#", n4 + 1);
            stringArray4[n4++] = string;
            if (bl3) break;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return n5 == 1 && !bl2 ? stringArray4[0] : stringArray4;
    }

    private ScriptVariable getBitsetPropertySelector(int n, boolean bl) throws ScriptException {
        int n2 = this.getToken((int)n).tok;
        switch (n2) {
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 1716520973: {
                break;
            }
            default: {
                if (Token.tokAttrOr(n2, 0x40500000, 0x44100000)) break;
                if (n2 != 806354977 && !Token.tokAttr(n2, 0x40000000)) {
                    return null;
                }
                String string = this.parameterAsString(n);
                if (!bl && this.viewer.isFunction(string)) {
                    n2 = 135368713;
                    break;
                }
                if (!string.endsWith("?")) {
                    return null;
                }
                n2 = 0x40000000;
            }
        }
        if (bl && !Token.tokAttr(n2, 2048)) {
            return null;
        }
        return new ScriptVariable(0x101000D1, n2, this.parameterAsString(n).toLowerCase());
    }

    private float[] getBitsetPropertyFloat(BitSet bitSet, int n, float f, float f2) throws ScriptException {
        int n2;
        float[] fArray = (float[])this.getBitsetProperty(bitSet, n, null, null, null, null, false, Integer.MAX_VALUE, false);
        if (!Float.isNaN(f)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] < f)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        if (!Float.isNaN(f2)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] > f2)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object getBitsetProperty(BitSet bitSet, int n, Point3f point3f, Point4f point4f, Object object, Object object2, boolean bl, int n2, boolean bl2) throws ScriptException {
        int n3;
        int n4;
        ArrayList<Object> arrayList;
        block143: {
            int n5;
            int n6;
            Point3f point3f2;
            float[] fArray;
            block142: {
                double d;
                double d2;
                float f;
                int n7;
                int n8;
                Point3f point3f3;
                boolean bl3;
                boolean bl4;
                int n9;
                block141: {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    block138: {
                        int n10;
                        ModelSet modelSet;
                        Point3f point3f4;
                        block140: {
                            int n11;
                            float[] fArray2;
                            ScriptVariable scriptVariable;
                            BitSet bitSet2;
                            List list;
                            String string;
                            int n12;
                            boolean bl8;
                            block139: {
                                bl8 = n2 != Integer.MAX_VALUE;
                                boolean bl9 = bl8 || !(object instanceof Bond.BondSet);
                                n9 = n & 0x1E0;
                                bl7 = n9 == 224;
                                n12 = this.viewer.getAtomCount();
                                fArray = n9 == 256 ? new float[n12] : null;
                                boolean bl10 = bl6 = n9 == 480 || bl7;
                                if ((n &= 0xFFFFFE1F) == 0) {
                                    n = bl9 ? 0x44100001 : 1678770178;
                                }
                                bl4 = false;
                                bl3 = false;
                                bl5 = false;
                                switch (n) {
                                    case 1146093582: 
                                    case 1146095626: 
                                    case 1146095627: 
                                    case 1146095628: 
                                    case 1146095629: 
                                    case 1146095631: 
                                    case 1766856708: {
                                        bl4 = true;
                                        break;
                                    }
                                    case 135368713: 
                                    case 1276118018: {
                                        break;
                                    }
                                    default: {
                                        bl3 = Token.tokAttr(n, 1095761920) && !Token.tokAttr(n, 1112539136);
                                        bl5 = !bl3 && Token.tokAttr(n, 0x40D00000);
                                    }
                                }
                                point3f2 = n9 == 256 ? new Point3f() : null;
                                Point3f point3f5 = point3f3 = bl4 || !bl9 ? new Point3f() : null;
                                if (bl6 || bl5 && !bl8 && n9 != 256 && n9 != 32) {
                                    n9 = 0x100003;
                                }
                                arrayList = n9 == 0x100003 ? new ArrayList<Object>() : null;
                                BitSet bitSet3 = null;
                                string = null;
                                list = null;
                                bitSet2 = null;
                                scriptVariable = null;
                                point3f4 = null;
                                fArray2 = null;
                                switch (n) {
                                    case 0x44100001: 
                                    case 1678770178: {
                                        int n13;
                                        if (this.isSyntaxCheck) {
                                            return bitSet;
                                        }
                                        bitSet3 = n == 0x44100001 ? (bl9 ? bitSet : this.viewer.getAtomBits(1678770178, bitSet)) : (bl9 ? new Bond.BondSet(this.viewer.getBondsForSelectedAtoms(bitSet)) : bitSet);
                                        switch (n9) {
                                            case 32: {
                                                n13 = bitSet3.nextSetBit(0);
                                                break;
                                            }
                                            case 64: {
                                                n13 = bitSet3.length() - 1;
                                                break;
                                            }
                                            case 128: 
                                            case 160: 
                                            case 192: {
                                                return Float.valueOf(Float.NaN);
                                            }
                                            default: {
                                                return bitSet3;
                                            }
                                        }
                                        bitSet3.clear();
                                        if (n13 < 0) return bitSet3;
                                        bitSet3.set(n13);
                                        return bitSet3;
                                    }
                                    case 1087373321: {
                                        switch (n9) {
                                            case 0: 
                                            case 0x100003: {
                                                return this.getBitsetIdent(bitSet, null, object, bl, n2, bl6);
                                            }
                                        }
                                        return "";
                                    }
                                    case 135368713: {
                                        string = (String)((Object[])object2)[0];
                                        list = (List)((Object[])object2)[1];
                                        bitSet2 = new BitSet(n12);
                                        scriptVariable = new ScriptVariable(10, bitSet2);
                                        break;
                                    }
                                    case 1112539148: 
                                    case 1112539149: {
                                        this.viewer.autoCalculate(n);
                                        break;
                                    }
                                    case 1276118018: {
                                        if (point3f != null || point4f != null) break;
                                        return new Point3f();
                                    }
                                    case 1766856708: {
                                        point3f4 = new Point3f();
                                        break;
                                    }
                                    case 1716520973: {
                                        fArray2 = this.viewer.getDataFloat((String)object2);
                                        break;
                                    }
                                }
                                n8 = 0;
                                n11 = 0;
                                n7 = 0;
                                f = 0.0f;
                                d2 = 0.0;
                                d = 0.0;
                                switch (n9) {
                                    case 32: {
                                        n7 = Integer.MAX_VALUE;
                                        f = Float.MAX_VALUE;
                                        break;
                                    }
                                    case 64: {
                                        n7 = Integer.MIN_VALUE;
                                        f = -3.4028235E38f;
                                        break;
                                    }
                                }
                                modelSet = this.viewer.getModelSet();
                                int n14 = bl4 ? 3 : (bl5 ? 2 : (n6 = bl3 ? 1 : 0));
                                if (bl9) break block139;
                                n4 = bitSet == null ? 1 : 0;
                                n5 = n4 != 0 ? 0 : bitSet.nextSetBit(0);
                                n3 = this.viewer.getBondCount();
                                n10 = n5;
                                break block140;
                            }
                            n4 = bitSet != null ? 1 : 0;
                            n5 = -1;
                            if (bl8) {
                                n3 = n2;
                                n10 = n2 + 1;
                            } else if (n4 != 0) {
                                n3 = bitSet.nextSetBit(0);
                                n10 = Math.min(n12, bitSet.length());
                            } else {
                                n3 = 0;
                                n10 = n12;
                            }
                            if (this.isSyntaxCheck) {
                                n10 = 0;
                            }
                            int n15 = n3;
                            while (n15 >= 0 && n15 < n10) {
                                block137: {
                                    ++n8;
                                    Atom atom = modelSet.atoms[n15];
                                    block25 : switch (n6) {
                                        case 0: {
                                            float f2 = Float.MAX_VALUE;
                                            switch (n) {
                                                case 135368713: {
                                                    bitSet2.set(n15);
                                                    f2 = ScriptVariable.fValue(this.runFunction(null, string, list, scriptVariable, true, true));
                                                    bitSet2.clear(n15);
                                                    break;
                                                }
                                                case 1716520973: {
                                                    f2 = fArray2 == null ? 0.0f : fArray2[n15];
                                                    break;
                                                }
                                                case 1276118018: {
                                                    if (point4f != null) {
                                                        f2 = Measure.distanceToPlane(point4f, atom);
                                                        break;
                                                    }
                                                    f2 = atom.distance(point3f);
                                                    break;
                                                }
                                                default: {
                                                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                                                }
                                            }
                                            if (f2 == Float.MAX_VALUE || Float.isNaN(f2) && n9 != 0x100003) {
                                                --n8;
                                                break block137;
                                            } else {
                                                switch (n9) {
                                                    case 32: {
                                                        if (!(f2 < f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 64: {
                                                        if (!(f2 > f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 256: {
                                                        fArray[n15] = f2;
                                                        break;
                                                    }
                                                    case 0x100003: {
                                                        arrayList.add(Float.valueOf(f2));
                                                        break;
                                                    }
                                                    case 160: 
                                                    case 192: {
                                                        d += (double)f2 * (double)f2;
                                                    }
                                                    default: {
                                                        d2 += (double)f2;
                                                        break;
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                        case 1: {
                                            Object object3;
                                            int n16 = 0;
                                            switch (n) {
                                                case 1297090050: {
                                                    if (atom.getModelIndex() != n5) {
                                                        n5 = atom.getModelIndex();
                                                    }
                                                    if ((object3 = atom.getAtomSymmetry()) == null) break;
                                                    int n17 = 0;
                                                    switch (n9) {
                                                        case 32: {
                                                            n11 = Integer.MAX_VALUE;
                                                            break;
                                                        }
                                                        case 64: {
                                                            n11 = Integer.MIN_VALUE;
                                                            break;
                                                        }
                                                    }
                                                    int n18 = ((BitSet)object3).nextSetBit(0);
                                                    while (n18 >= 0) {
                                                        n16 += n18 + 1;
                                                        switch (n9) {
                                                            case 32: {
                                                                n11 = Math.min(n11, n18 + 1);
                                                                break;
                                                            }
                                                            case 64: {
                                                                n11 = Math.max(n11, n18 + 1);
                                                                break;
                                                            }
                                                        }
                                                        ++n17;
                                                        n18 = ((BitSet)object3).nextSetBit(n18 + 1);
                                                    }
                                                    switch (n9) {
                                                        case 32: 
                                                        case 64: {
                                                            n16 = n11;
                                                            break;
                                                        }
                                                    }
                                                    n8 += n17 - 1;
                                                    break;
                                                }
                                                case 1095761925: 
                                                case 1095766022: {
                                                    this.error(45, Token.nameOf(n));
                                                    break;
                                                }
                                                default: {
                                                    n16 = Atom.atomPropertyInt(atom, n);
                                                }
                                            }
                                            switch (n9) {
                                                case 32: {
                                                    if (n16 >= n7) break;
                                                    n7 = n16;
                                                    break;
                                                }
                                                case 64: {
                                                    if (n16 <= n7) break;
                                                    n7 = n16;
                                                    break;
                                                }
                                                case 256: {
                                                    fArray[n15] = n16;
                                                    break;
                                                }
                                                case 0x100003: {
                                                    arrayList.add(n16);
                                                    break;
                                                }
                                                case 160: 
                                                case 192: {
                                                    d += (double)n16 * (double)n16;
                                                }
                                                default: {
                                                    d2 += (double)n16;
                                                    break;
                                                }
                                            }
                                            break;
                                        }
                                        case 2: {
                                            Object object3 = Atom.atomPropertyString(this.viewer, atom, n);
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n15] = Parser.parseFloat((String)object3);
                                                    break block25;
                                                }
                                            }
                                            if (arrayList == null) {
                                                return object3;
                                            }
                                            arrayList.add(object3);
                                            break;
                                        }
                                        case 3: {
                                            Tuple3f tuple3f = Atom.atomPropertyTuple(atom, n);
                                            if (tuple3f == null) {
                                                this.error(45, Token.nameOf(n));
                                            }
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n15] = (float)Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
                                                    break block25;
                                                }
                                                case 0x100003: {
                                                    arrayList.add(new Point3f(tuple3f));
                                                    break block25;
                                                }
                                            }
                                            point3f3.add(tuple3f);
                                        }
                                    }
                                    if (bl8) break block138;
                                }
                                n15 = n4 != 0 ? bitSet.nextSetBit(n15 + 1) : n15 + 1;
                            }
                            break block138;
                        }
                        while (n10 >= 0 && n10 < n3) {
                            ++n8;
                            Bond bond = modelSet.getBondAt(n10);
                            block72 : switch (n) {
                                case 1141899267: {
                                    float f3 = bond.getAtom1().distance(bond.getAtom2());
                                    switch (n9) {
                                        case 32: {
                                            if (!(f3 < f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 64: {
                                            if (!(f3 > f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 0x100003: {
                                            arrayList.add(Float.valueOf(f3));
                                            break;
                                        }
                                        case 160: 
                                        case 192: {
                                            d += (double)f3 * (double)f3;
                                        }
                                        default: {
                                            d2 += (double)f3;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 1146095626: {
                                    switch (n9) {
                                        case 0x100003: {
                                            point3f3.set(bond.getAtom1());
                                            point3f3.add(bond.getAtom2());
                                            point3f3.scale(0.5f);
                                            arrayList.add(new Point3f(point3f3));
                                            break block72;
                                        }
                                    }
                                    point3f3.add(bond.getAtom1());
                                    point3f3.add(bond.getAtom2());
                                    ++n8;
                                    break;
                                }
                                case 1766856708: {
                                    ColorUtil.colorPointFromInt(this.viewer.getColorArgbOrGray(bond.getColix()), point3f4);
                                    switch (n9) {
                                        case 0x100003: {
                                            arrayList.add(new Point3f(point3f4));
                                            break block72;
                                        }
                                    }
                                    point3f3.add(point3f4);
                                    break;
                                }
                                default: {
                                    this.error(46, Token.nameOf(n));
                                }
                            }
                            n10 = n4 != 0 ? n10 + 1 : bitSet.nextSetBit(n10 + 1);
                        }
                    }
                    if (n9 == 256) {
                        return fArray;
                    }
                    if (n9 != 0x100003) break block141;
                    if (bl2) {
                        return arrayList;
                    }
                    n4 = arrayList.size();
                    if (bl5 && !bl6 && n4 == 1) {
                        return arrayList.get(0);
                    }
                    if (bl7) break block142;
                    if (n == 1087373320) {
                        StringBuffer stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < n4) {
                            stringBuffer.append((String)arrayList.get(n3));
                            ++n3;
                        }
                        return stringBuffer.toString();
                    }
                    break block143;
                }
                if (bl4) {
                    Point3f point3f6;
                    if (n8 == 0) {
                        point3f6 = point3f3;
                        return point3f6;
                    }
                    point3f6 = new Point3f(point3f3.x / (float)n8, point3f3.y / (float)n8, point3f3.z / (float)n8);
                    return point3f6;
                }
                if (n8 == 0) return Float.valueOf(Float.NaN);
                if (n8 == 1 && n9 == 192) {
                    return Float.valueOf(Float.NaN);
                }
                if (bl3) {
                    switch (n9) {
                        case 32: 
                        case 64: {
                            return n7;
                        }
                        case 160: 
                        case 192: {
                            break;
                        }
                        case 128: {
                            return (int)d2;
                        }
                        default: {
                            if (d2 / (double)n8 != (double)((int)(d2 / (double)n8))) return Float.valueOf((float)(d2 / (double)n8));
                            return (int)(d2 / (double)n8);
                        }
                    }
                }
                switch (n9) {
                    case 32: 
                    case 64: {
                        d2 = f;
                        return Float.valueOf((float)d2);
                    }
                    case 128: {
                        return Float.valueOf((float)d2);
                    }
                    case 160: {
                        d2 = d;
                        return Float.valueOf((float)d2);
                    }
                    case 192: {
                        d2 = Math.sqrt((d - d2 * d2 / (double)n8) / (double)(n8 - 1));
                        return Float.valueOf((float)d2);
                    }
                }
                d2 /= (double)n8;
                return Float.valueOf((float)d2);
            }
            fArray = new float[n4];
            n5 = n4;
            block110: while (--n5 >= 0) {
                Object e = arrayList.get(n5);
                switch (n6) {
                    case 0: {
                        fArray[n5] = ((Float)e).floatValue();
                        break;
                    }
                    case 1: {
                        fArray[n5] = ((Integer)e).floatValue();
                        break;
                    }
                    case 2: {
                        fArray[n5] = Parser.parseFloat((String)e);
                        break;
                    }
                    case 3: {
                        fArray[n5] = ((Point3f)e).distance(point3f2);
                        continue block110;
                    }
                }
            }
            return fArray;
        }
        String[] stringArray = new String[n4];
        n3 = n4;
        while (--n3 >= 0) {
            Object e = arrayList.get(n3);
            if (e instanceof Point3f) {
                stringArray[n3] = Escape.escape((Point3f)e);
                continue;
            }
            stringArray[n3] = "" + arrayList.get(n3);
        }
        return stringArray;
    }

    private void setBitsetProperty(BitSet bitSet, int n, int n2, float f, Token token) throws ScriptException {
        if (this.isSyntaxCheck || BitSetUtil.cardinalityOf(bitSet) == 0) {
            return;
        }
        String[] stringArray = null;
        String string = null;
        float[] fArray = null;
        List<ScriptVariable> list = null;
        int n3 = 0;
        boolean bl = Token.tokAttr(n, 0x40D00000);
        if (token.tok == 7 && (n3 = (list = ((ScriptVariable)token).getList()).size()) == 0) {
            return;
        }
        switch (n) {
            case 1146095626: 
            case 1146095627: 
            case 1146095629: 
            case 1146095631: {
                switch (token.tok) {
                    case 8: {
                        this.viewer.setAtomCoord(bitSet, n, token.value);
                        break;
                    }
                    case 7: {
                        this.theToken = token;
                        this.viewer.setAtomCoord(bitSet, n, this.getPointArray(-1, n3));
                    }
                }
                return;
            }
            case 1766856708: {
                Object object = null;
                String string2 = "color";
                switch (token.tok) {
                    case 7: {
                        int[] nArray = new int[n3];
                        int n4 = n3;
                        while (--n4 >= 0) {
                            ScriptVariable scriptVariable = list.get(n4);
                            Point3f point3f = ScriptVariable.ptValue(scriptVariable);
                            if (point3f != null) {
                                nArray[n4] = ColorUtil.colorPtToInt(point3f);
                            } else if (scriptVariable.tok == 2) {
                                nArray[n4] = scriptVariable.intValue;
                            } else {
                                nArray[n4] = ColorUtil.getArgbFromString(scriptVariable.asString());
                                if (nArray[n4] == 0) {
                                    nArray[n4] = ScriptVariable.iValue(scriptVariable);
                                }
                            }
                            if (nArray[n4] != 0) continue;
                            this.error(50, "ARRAY", scriptVariable.asString());
                        }
                        object = nArray;
                        string2 = "colorValues";
                        break;
                    }
                    case 8: {
                        object = ColorUtil.colorPtToInt((Point3f)token.value);
                        break;
                    }
                    case 4: {
                        object = token.value;
                        break;
                    }
                    default: {
                        object = ScriptVariable.iValue(token);
                    }
                }
                this.setShapeProperty(0, string2, object, bitSet);
                return;
            }
            case 1288701960: 
            case 1826248715: {
                if (token.tok == 7) break;
                string = ScriptVariable.sValue(token);
                break;
            }
            case 1087375365: 
            case 1095763976: {
                this.clearDefinedVariableAtomSets();
                bl = false;
            }
        }
        switch (token.tok) {
            case 7: {
                if (bl) {
                    stringArray = ScriptVariable.listValue(token);
                    break;
                }
                fArray = ScriptVariable.flistValue(token, n3);
                break;
            }
            case 4: {
                if (string != null) break;
                stringArray = Parser.getTokens(ScriptVariable.sValue(token));
            }
        }
        if (stringArray != null) {
            n3 = stringArray.length;
            if (!bl) {
                fArray = new float[n3];
                int n5 = n3;
                while (--n5 >= 0) {
                    fArray[n5] = n == 1087375365 ? (float)Elements.elementNumberFromSymbol(stringArray[n5], false) : Parser.parseFloat(stringArray[n5]);
                }
            }
            if (token.tok != 7 && n3 == 1) {
                if (bl) {
                    string = stringArray[0];
                } else {
                    f = fArray[0];
                }
                n2 = (int)f;
                stringArray = null;
                fArray = null;
            }
        }
        this.viewer.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
    }

    public Map<String, ScriptVariable> getContextVariables() {
        return this.contextVariables;
    }

    public String getScript() {
        return this.script;
    }

    private boolean compileScript(String string, String string2, boolean bl) {
        this.scriptFileName = string;
        string2 = this.fixScriptPath(string2, string);
        this.restoreScriptContext(this.compiler.compile(string, string2, false, false, bl, false), false, false, false);
        this.isStateScript = this.script.indexOf("# Jmol state version ") >= 0;
        this.forceNoAddHydrogens = this.isStateScript && this.script.indexOf("pdbAddHydrogens") < 0;
        String string3 = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.isSyntaxCheck && this.viewer.isScriptEditorVisible() && string2.indexOf("\u0001## EDITOR_IGNORE ##") < 0) {
            this.viewer.scriptStatus("");
        }
        this.script = string3;
        return !this.error;
    }

    private String fixScriptPath(String string, String string2) {
        if (string2 != null && string.indexOf("$SCRIPT_PATH$") >= 0) {
            String string3 = string2;
            int n = Math.max(string2.lastIndexOf("|"), string2.lastIndexOf("/"));
            string3 = string3.substring(0, n + 1);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$/", string3);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$", string3);
        }
        return string;
    }

    private int setScriptExtensions() {
        String string = this.scriptExtensions;
        if (string == null) {
            return 0;
        }
        int n = string.indexOf("##SCRIPT_STEP");
        if (n >= 0) {
            this.executionStepping = true;
        }
        if ((n = string.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((n = Parser.parseInt(string.substring(n + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= n && this.lineIndices[this.pc][1] < n) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > n) {
            --this.pc;
        }
        return this.pc;
    }

    public void runScript(String string) throws ScriptException {
        if (!this.viewer.isPreviewOnly()) {
            this.runScript(string, this.outputBuffer);
        }
    }

    private boolean compileScriptFileInternal(String string, String string2, String string3, String string4) {
        String string5;
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(string, this.viewer.jsEval(string.substring(11)), this.debugScript);
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        if (!this.viewer.getFileAsString(stringArray, Integer.MAX_VALUE, false)) {
            this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
            return false;
        }
        if (("\n" + stringArray[1]).indexOf("\nJmolManifest.txt\n") >= 0) {
            if (string.endsWith(".all.pngj") || string.endsWith(".all.png")) {
                string5 = "|state.spt";
                string = string + "|";
            } else {
                stringArray[0] = string = string + "|JmolManifest.txt";
                if (!this.viewer.getFileAsString(stringArray, Integer.MAX_VALUE, false)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
                string5 = ZipUtil.getManifestScriptPath(stringArray[1]);
            }
            if (string5 != null && string5.length() > 0) {
                stringArray[0] = string = string.substring(0, string.lastIndexOf("|")) + string5;
                if (!this.viewer.getFileAsString(stringArray, Integer.MAX_VALUE, false)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
            }
        }
        this.scriptFileName = string;
        stringArray[1] = ScriptCompiler.getEmbeddedScript(stringArray[1]);
        string5 = this.fixScriptPath(stringArray[1], stringArray[0]);
        if (string4 == null) {
            string4 = this.viewer.getFilePath(string, false);
            string4 = string4.substring(0, Math.max(string4.lastIndexOf("|"), string4.lastIndexOf("/")));
        }
        string5 = FileManager.setScriptFileReferences(string5, string2, string3, string4);
        return this.compileScript(string, string5, this.debugScript);
    }

    private Object getParameter(String string, int n) {
        Object object = this.getContextVariableAsVariable(string);
        if (object == null) {
            object = this.viewer.getParameter(string);
        }
        switch (n) {
            case 1073742190: {
                return ScriptVariable.getVariable(object);
            }
            case 4: {
                if (!(object instanceof List)) break;
                ArrayList arrayList = (ArrayList)object;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuffer.append(((ScriptVariable)arrayList.get(i)).asString()).append('\n');
                }
                return stringBuffer.toString();
            }
        }
        return object instanceof ScriptVariable ? ScriptVariable.oValue((ScriptVariable)object) : object;
    }

    private String getParameterEscaped(String string) {
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        return scriptVariable == null ? "" + this.viewer.getParameterEscaped(string) : scriptVariable.escape();
    }

    private String getStringParameter(String string, boolean bl) {
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        if (scriptVariable != null) {
            return scriptVariable.asString();
        }
        String string2 = "" + this.viewer.getParameter(string);
        return string2.length() == 0 && bl ? string : string2;
    }

    private Object getNumericParameter(String string) {
        if (string.equalsIgnoreCase("_modelNumber")) {
            int n = this.viewer.getCurrentModelIndex();
            return n < 0 ? 0 : this.viewer.getModelFileNumber(n);
        }
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        if (scriptVariable == null) {
            Object object = this.viewer.getParameter(string);
            if (!(object instanceof String)) {
                return object;
            }
            scriptVariable = new ScriptVariable(4, object);
        }
        return ScriptVariable.nValue(scriptVariable);
    }

    private ScriptVariable getContextVariableAsVariable(String string) {
        if (string.equals("expressionBegin")) {
            return null;
        }
        string = string.toLowerCase();
        if (this.contextVariables != null && this.contextVariables.containsKey(string)) {
            return this.contextVariables.get(string);
        }
        ScriptContext scriptContext = this.thisContext;
        while (scriptContext != null) {
            if (scriptContext.isFunction) {
                return null;
            }
            if (scriptContext.contextVariables != null && scriptContext.contextVariables.containsKey(string)) {
                return scriptContext.contextVariables.get(string);
            }
            scriptContext = scriptContext.parentContext;
        }
        return null;
    }

    private Object getStringObjectAsVariable(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = ScriptVariable.unescapePointOrBitsetAsVariable(string);
        if (object instanceof String && string2 != null) {
            object = this.viewer.setUserVariable(string2, new ScriptVariable(4, object));
        }
        return object;
    }

    public float evalFunctionFloat(Object object, Object object2, float[] fArray) {
        try {
            List list = (List)object2;
            for (int i = 0; i < fArray.length; ++i) {
                ((ScriptVariable)list.get((int)i)).value = new Float(fArray[i]);
            }
            ScriptFunction scriptFunction = (ScriptFunction)object;
            return ScriptVariable.fValue(this.runFunction(scriptFunction, scriptFunction.name, list, null, true, false));
        }
        catch (Exception exception) {
            return Float.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScriptVariable runFunction(ScriptFunction scriptFunction, String string, List<ScriptVariable> list, ScriptVariable scriptVariable, boolean bl, boolean bl2) throws ScriptException {
        ScriptFunction scriptFunction2;
        if (scriptFunction == null) {
            scriptFunction = this.viewer.getFunction(string);
            if (scriptFunction == null) {
                return null;
            }
            if (bl2) {
                this.contextPath = this.contextPath + " >> function " + string;
            }
        } else if (bl2) {
            this.contextPath = this.contextPath + " >> " + string;
        }
        this.pushContext(null);
        boolean bl3 = scriptFunction.tok == 364558;
        this.thisContext.isFunction = !bl3;
        this.functionName = string;
        if (scriptFunction instanceof ParallelProcessor) {
            scriptFunction2 = scriptFunction;
            synchronized (scriptFunction2) {
                this.parallelProcessor = (ParallelProcessor)scriptFunction;
                this.vProcess = null;
                this.runFunction(scriptFunction, list, scriptVariable);
                ScriptContext scriptContext = this.getScriptContext();
                if (bl3) {
                    this.contextVariables.put("_breakval", ScriptVariable.intVariable(Integer.MAX_VALUE));
                    this.contextVariables.put("_errorval", ScriptVariable.getVariable(""));
                    this.viewer.resetError();
                    this.parallelProcessor.addProcess("try", scriptContext);
                }
                ((ParallelProcessor)scriptFunction).runAllProcesses(this.viewer, !bl3);
                if (bl3) {
                    String string2 = (String)this.viewer.getParameter("_errormessage");
                    if (string2.length() > 0) {
                        this.contextVariables.put("_errorval", ScriptVariable.getVariable(string2));
                        this.viewer.resetError();
                    }
                    this.contextVariables.put("_tryret", this.contextVariables.get("_retval"));
                    this.contextVariables.put("_retval", new ScriptVariable(0, this.contextVariables));
                }
            }
        } else {
            this.runFunction(scriptFunction, list, scriptVariable);
        }
        scriptFunction2 = bl ? this.getContextVariableAsVariable("_retval") : null;
        this.popContext(false, false);
        return scriptFunction2;
    }

    private void runFunction(ScriptFunction scriptFunction, List<ScriptVariable> list, ScriptVariable scriptVariable) throws ScriptException {
        this.aatoken = scriptFunction.aatoken;
        this.lineNumbers = scriptFunction.lineNumbers;
        this.lineIndices = scriptFunction.lineIndices;
        this.script = scriptFunction.script;
        this.pc = 0;
        if (scriptFunction.names != null) {
            this.contextVariables = new Hashtable<String, ScriptVariable>();
            scriptFunction.setVariables(this.contextVariables, list);
        }
        if (scriptVariable != null) {
            this.contextVariables.put("_x", scriptVariable);
        }
        if (scriptFunction.tok != 364558) {
            this.instructionDispatchLoop(false);
        }
    }

    private void clearDefinedVariableAtomSets() {
        this.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String string;
        int n;
        if (!this.definedAtomSets.containsKey("# static")) {
            for (n = 0; n < JmolConstants.predefinedStatic.length; ++n) {
                this.defineAtomSet(JmolConstants.predefinedStatic[n]);
            }
            this.defineAtomSet("# static");
        }
        if (this.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (n = 0; n < JmolConstants.predefinedVariable.length; ++n) {
            this.defineAtomSet(JmolConstants.predefinedVariable[n]);
        }
        n = Elements.elementNumberMax;
        while (--n >= 0) {
            string = " elemno=" + n;
            this.defineAtomSet("@" + Elements.elementNameFromNumber(n) + string);
            this.defineAtomSet("@_" + Elements.elementSymbolFromNumber(n) + string);
        }
        n = 4;
        while (--n >= 0) {
            string = "@" + Elements.altElementNameFromIndex(n) + " _e=" + Elements.altElementNumberFromIndex(n);
            this.defineAtomSet(string);
        }
        n = Elements.altElementMax;
        while (--n >= 4) {
            short s;
            short s2 = Elements.altElementNumberFromIndex(n);
            String string2 = " _e=" + s2;
            String string3 = "@_" + Elements.altElementSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex2(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@" + Elements.altElementNameFromIndex(n);
            if (string3.length() > 1) {
                this.defineAtomSet(string3 + string2);
            }
            if ((s2 = (short)Elements.getNaturalIsotope(s = Elements.getElementNumber(s2))) <= 0) continue;
            string2 = Elements.elementSymbolFromNumber(s);
            this.defineAtomSet("@_" + string2 + s2 + " _e=" + s);
            this.defineAtomSet("@_" + s2 + string2 + " _e=" + s);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String string) {
        if (string.indexOf("#") == 0) {
            this.definedAtomSets.put(string, Boolean.TRUE);
            return;
        }
        ScriptContext scriptContext = this.compiler.compile("#predefine", string, true, false, false, false);
        if (scriptContext.errorType != null) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + scriptContext.errorMessageUntranslated);
            return;
        }
        if (scriptContext.aatoken.length != 1) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
            return;
        }
        Token[] tokenArray = scriptContext.aatoken[0];
        if (tokenArray.length <= 2) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            return;
        }
        int n = tokenArray[1].tok;
        if (!Token.tokAttr(n, 0x40000000) && !Token.tokAttr(n, 0x300000)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
            return;
        }
        String string2 = ((String)tokenArray[1].value).toLowerCase();
        if (string2.startsWith("dynamic_")) {
            string2 = "!" + string2.substring(8);
        }
        this.definedAtomSets.put(string2, tokenArray);
    }

    private BitSet lookupIdentifierValue(String string) throws ScriptException {
        BitSet bitSet = this.lookupValue(string, false);
        if (bitSet != null) {
            return BitSetUtil.copy(bitSet);
        }
        bitSet = this.getAtomBits(0x40000000, string);
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet lookupValue(String string, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        this.defineSets();
        string = string.toLowerCase();
        Object object = this.definedAtomSets.get(string);
        boolean bl2 = false;
        if (object == null) {
            object = this.definedAtomSets.get("!" + string);
            boolean bl3 = bl2 = object != null;
        }
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        if (object instanceof Token[]) {
            this.pushContext(null);
            BitSet bitSet = this.atomExpression((Token[])object, -2, 0, true, false, true, true);
            this.popContext(false, false);
            if (!bl2) {
                this.definedAtomSets.put(string, bitSet);
            }
            return bitSet;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    public void deleteAtomsInVariables(BitSet bitSet) {
        for (Map.Entry<String, Object> entry : this.definedAtomSets.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof BitSet)) continue;
            BitSetUtil.deleteBits((BitSet)object, bitSet);
            if (entry.getKey().startsWith("!")) continue;
            this.viewer.setUserVariable("@" + entry.getKey(), ScriptVariable.getVariable(object));
        }
    }

    private boolean setStatement(int n) throws ScriptException {
        int n2;
        this.statement = this.aatoken[n];
        this.statementLength = this.statement.length;
        if (this.statementLength == 0) {
            return true;
        }
        for (n2 = 1; n2 < this.statementLength; ++n2) {
            if (this.statement[n2] == null) {
                this.statementLength = n2;
                return true;
            }
            if (this.statement[n2].tok == 1060866) break;
        }
        if (n2 == this.statementLength) {
            return n2 == this.statementLength;
        }
        switch (this.statement[0].tok) {
            case 102436: 
            case 135368713: 
            case 0x40000000: {
                if (this.tokAt(1) != 0x10100010) break;
                return true;
            }
        }
        Token[] tokenArray = new Token[this.statementLength];
        tokenArray[0] = this.statement[0];
        boolean bl = false;
        int n3 = 1;
        for (n2 = 1; n2 < this.statementLength; ++n2) {
            if (this.statement[n2] == null) continue;
            int n4 = this.getToken((int)n2).tok;
            switch (n4) {
                default: {
                    tokenArray[n3] = this.statement[n2];
                    break;
                }
                case 0x100001: 
                case 0x100002: {
                    bl = n4 == 0x100001;
                    tokenArray[n3] = this.statement[n2];
                    break;
                }
                case 1060866: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    if (++n2 == this.statementLength) {
                        this.error(22);
                    }
                    boolean bl3 = this.theToken.intValue == 4;
                    String string = this.parameterAsString(n2);
                    boolean bl4 = this.tokAt(n2) == 0x100001;
                    boolean bl5 = bl2 = n3 == 1 && this.statement[0] == Token.tokenSetCmd;
                    if (bl4) {
                        object2 = this.parameterExpressionToken(++n2);
                        n2 = this.iToken;
                        object = ((ScriptVariable)object2).tok == 7 ? object2 : ScriptVariable.oValue((ScriptVariable)object2);
                    } else {
                        object = this.tokAt(n2) == 2 ? this.viewer.getAtomBits(1095763969, this.statement[n2].intValue) : this.getParameter(string, 0);
                        if (!bl && !bl2) {
                            bl4 = true;
                        }
                    }
                    n4 = this.tokAt(0);
                    bl3 |= Token.tokAttr(n4, 20480) || n4 == 135271429;
                    if (object instanceof ScriptVariable) {
                        tokenArray[n3] = (Token)object;
                        if (bl && tokenArray[n3].tok == 7) {
                            object2 = ScriptVariable.getBitSet((ScriptVariable)object, true);
                            tokenArray[n3] = new ScriptVariable(10, object2 == null ? ScriptEvaluator.getAtomBitSet(this, ScriptVariable.sValue(tokenArray[n3])) : object2);
                        }
                    } else if (object instanceof Boolean) {
                        tokenArray[n3] = (Boolean)object != false ? Token.tokenOn : Token.tokenOff;
                    } else if (object instanceof Integer) {
                        tokenArray[n3] = new Token(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tokenArray[n3] = new Token(3, ScriptEvaluator.getFloatEncodedInt("" + object), object);
                    } else if (object instanceof String) {
                        if (!bl3) {
                            if ((n4 != 1085443 || n3 > 1 && this.statement[1].tok != 537022465) && Token.tokAttr(n4, 36864)) {
                                object = this.getParameter((String)object, 1073742190);
                            }
                            if (object instanceof String) {
                                object = this.getStringObjectAsVariable((String)object, null);
                            }
                        }
                        if (object instanceof ScriptVariable) {
                            tokenArray[n3] = (Token)object;
                        } else {
                            String string2 = (String)object;
                            if (bl && !bl3) {
                                tokenArray[n3] = new Token(10, ScriptEvaluator.getAtomBitSet(this, string2));
                            } else {
                                if (!bl) {
                                    // empty if block
                                }
                                n4 = bl2 ? Token.getTokFromName(string2) : (bl4 || bl3 || string2.length() == 0 || string2.indexOf(".") >= 0 || string2.indexOf(" ") >= 0 || string2.indexOf("=") >= 0 || string2.indexOf(";") >= 0 || string2.indexOf("[") >= 0 || string2.indexOf("{") >= 0 ? 4 : 0x40000000);
                                tokenArray[n3] = new Token(n4, object);
                            }
                        }
                    } else if (object instanceof BitSet) {
                        tokenArray[n3] = new ScriptVariable(10, object);
                    } else if (object instanceof Point3f) {
                        tokenArray[n3] = new ScriptVariable(8, object);
                    } else if (object instanceof Point4f) {
                        tokenArray[n3] = new ScriptVariable(9, object);
                    } else if (object instanceof Matrix3f) {
                        tokenArray[n3] = new ScriptVariable(11, object);
                    } else if (object instanceof Matrix4f) {
                        tokenArray[n3] = new ScriptVariable(12, object);
                    } else if (object instanceof Map) {
                        tokenArray[n3] = new ScriptVariable(6, object);
                    } else if (object instanceof List) {
                        object2 = (ArrayList)object;
                        BitSet bitSet = null;
                        for (int i = 0; i < object2.size(); ++i) {
                            ScriptVariable scriptVariable = (ScriptVariable)object2.get(i);
                            if (scriptVariable.tok != 10) {
                                bitSet = null;
                                break;
                            }
                            if (bitSet == null) {
                                bitSet = new BitSet();
                            }
                            bitSet.or((BitSet)scriptVariable.value);
                        }
                        tokenArray[n3] = bitSet == null ? ScriptVariable.getVariable(object) : new Token(10, bitSet);
                    } else {
                        object2 = this.getObjectCenter(string, Integer.MIN_VALUE, Integer.MIN_VALUE);
                        if (object2 == null) {
                            this.error(22);
                        }
                        tokenArray[n3] = new Token(8, object2);
                    }
                    if (!bl2 || Token.tokAttr(tokenArray[n3].tok, 0x20000000)) break;
                    this.error(22);
                }
            }
            ++n3;
        }
        this.statement = tokenArray;
        for (n2 = n3; n2 < this.statement.length; ++n2) {
            this.statement[n2] = null;
        }
        this.statementLength = n3;
        return true;
    }

    private void clearState(boolean bl) {
        this.thisContext = null;
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = bl;
    }

    private void pushContext(ContextToken contextToken) throws ScriptException {
        if (this.scriptLevel == 100) {
            this.error(44);
        }
        this.thisContext = this.getScriptContext();
        this.thisContext.token = contextToken;
        if (contextToken == null) {
            this.scriptLevel = ++this.thisContext.scriptLevel;
        } else {
            this.thisContext.scriptLevel = -1;
            this.contextVariables = new Hashtable<String, ScriptVariable>();
            if (contextToken.contextVariables != null) {
                for (String string : contextToken.contextVariables.keySet()) {
                    ScriptCompiler.addContextVariable(this.contextVariables, string);
                }
            }
        }
        if (this.debugScript || this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>-------------".substring(0, Math.max(17, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + contextToken + " " + this.thisContext);
        }
    }

    public ScriptContext getScriptContext() {
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.scriptLevel = this.scriptLevel;
        scriptContext.parentContext = this.thisContext;
        scriptContext.contextPath = this.contextPath;
        scriptContext.scriptFileName = this.scriptFileName;
        scriptContext.parallelProcessor = this.parallelProcessor;
        scriptContext.functionName = this.functionName;
        scriptContext.script = this.script;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.aatoken = this.aatoken;
        scriptContext.statement = this.statement;
        scriptContext.statementLength = this.statementLength;
        scriptContext.pc = this.pc;
        scriptContext.lineEnd = this.lineEnd;
        scriptContext.pcEnd = this.pcEnd;
        scriptContext.iToken = this.iToken;
        scriptContext.outputBuffer = this.outputBuffer;
        scriptContext.contextVariables = this.contextVariables;
        scriptContext.isStateScript = this.isStateScript;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorType = this.errorType;
        scriptContext.iCommandError = this.iCommandError;
        scriptContext.isSyntaxCheck = this.isSyntaxCheck;
        scriptContext.executionStepping = this.executionStepping;
        scriptContext.executionPaused = this.executionPaused;
        scriptContext.scriptExtensions = this.scriptExtensions;
        return scriptContext;
    }

    void popContext(boolean bl, boolean bl2) {
        if (this.thisContext == null) {
            return;
        }
        if (this.thisContext.scriptLevel > 0) {
            this.scriptLevel = this.thisContext.scriptLevel - 1;
        }
        ScriptContext scriptContext = bl ? this.getScriptContext() : null;
        this.restoreScriptContext(this.thisContext, true, bl, bl2);
        this.restoreScriptContext(scriptContext, true, false, true);
        if (this.debugScript || this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<-------------".substring(0, Math.max(17, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + (this.thisContext == null ? "" : "" + this.thisContext.token) + " " + this.thisContext);
        }
    }

    private void restoreScriptContext(ScriptContext scriptContext, boolean bl, boolean bl2, boolean bl3) {
        if (scriptContext == null) {
            return;
        }
        if (!bl2) {
            this.statement = scriptContext.statement;
            this.statementLength = scriptContext.statementLength;
            this.pc = scriptContext.pc;
            this.lineEnd = scriptContext.lineEnd;
            this.pcEnd = scriptContext.pcEnd;
            if (bl3) {
                return;
            }
        }
        this.script = scriptContext.script;
        this.lineNumbers = scriptContext.lineNumbers;
        this.lineIndices = scriptContext.lineIndices;
        this.aatoken = scriptContext.aatoken;
        this.contextVariables = scriptContext.contextVariables;
        this.scriptExtensions = scriptContext.scriptExtensions;
        if (bl) {
            this.contextPath = scriptContext.contextPath;
            this.scriptFileName = scriptContext.scriptFileName;
            this.parallelProcessor = scriptContext.parallelProcessor;
            this.functionName = scriptContext.functionName;
            this.iToken = scriptContext.iToken;
            this.outputBuffer = scriptContext.outputBuffer;
            this.isStateScript = scriptContext.isStateScript;
            this.thisContext = scriptContext.parentContext;
        } else {
            this.error = scriptContext.errorType != null;
            this.errorMessage = scriptContext.errorMessage;
            this.errorMessageUntranslated = scriptContext.errorMessageUntranslated;
            this.iCommandError = scriptContext.iCommandError;
            this.errorType = scriptContext.errorType;
        }
    }

    private String getContext(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        ScriptContext scriptContext = this.thisContext;
        while (scriptContext != null) {
            if (bl) {
                if (scriptContext.contextVariables != null) {
                    stringBuffer.append(this.getScriptID(scriptContext));
                    stringBuffer.append(StateManager.getVariableList(scriptContext.contextVariables, 80, true, false));
                }
            } else {
                stringBuffer.append(ScriptEvaluator.setErrorLineMessage(scriptContext.functionName, scriptContext.scriptFileName, this.getLinenumber(scriptContext), scriptContext.pc, ScriptEvaluator.statementAsString(scriptContext.statement, -9999, this.logMessages)));
            }
            scriptContext = scriptContext.parentContext;
        }
        if (bl) {
            if (this.contextVariables != null) {
                stringBuffer.append(this.getScriptID(null));
                stringBuffer.append(StateManager.getVariableList(this.contextVariables, 80, true, false));
            }
        } else {
            stringBuffer.append(ScriptEvaluator.setErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.statement, -9999, this.logMessages)));
        }
        return stringBuffer.toString();
    }

    private int getLinenumber(ScriptContext scriptContext) {
        return scriptContext == null ? this.lineNumbers[this.pc] : scriptContext.lineNumbers[scriptContext.pc];
    }

    private String getScriptID(ScriptContext scriptContext) {
        String string = scriptContext == null ? this.functionName : "function " + scriptContext.functionName;
        String string2 = scriptContext == null ? this.scriptFileName : scriptContext.scriptFileName;
        return "\n# " + string + " (file " + string2 + ")\n";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    private void setErrorMessage(String string) {
        this.errorMessageUntranslated = null;
        if (string == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    private void planeExpected() throws ScriptException {
        this.error(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx");
    }

    private void integerOutOfRange(int n, int n2) throws ScriptException {
        this.error(21, "" + n, "" + n2);
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.error(36, "" + f, "" + f2);
    }

    void error(int n, int n2) throws ScriptException {
        this.iToken = n2;
        this.error(n, null, null, null, false);
    }

    void error(int n) throws ScriptException {
        this.error(n, null, null, null, false);
    }

    void error(int n, String string) throws ScriptException {
        this.error(n, string, null, null, false);
    }

    void error(int n, String string, String string2) throws ScriptException {
        this.error(n, string, string2, null, false);
    }

    void error(int n, String string, String string2, String string3) throws ScriptException {
        this.error(n, string, string2, string3, false);
    }

    private void warning(int n, String string, String string2) throws ScriptException {
        this.error(n, string, string2, null, true);
    }

    void error(int n, String string, String string2, String string3, boolean bl) throws ScriptException {
        String string4;
        String string5 = this.ignoreError ? null : ScriptEvaluator.errorString(n, string, string2, string3, true);
        String string6 = string4 = !this.ignoreError && GT.getDoTranslate() ? ScriptEvaluator.errorString(n, string, string2, string3, false) : null;
        if (!bl) {
            this.evalError(string5, string4);
        }
        this.showString(string5);
    }

    void evalError(String string, String string2) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.isSyntaxCheck) {
            this.setCursorWait(false);
            this.viewer.setBooleanProperty("refreshing", true);
            this.viewer.setStringProperty("_errormessage", string2);
        }
        throw new ScriptException(string, string2);
    }

    static String errorString(int n, String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string4 = "Unknown error message number: " + n;
                break;
            }
            case 0: {
                string4 = GT._("x y z axis expected");
                break;
            }
            case 1: {
                string4 = GT._("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                string4 = GT._("bad argument count");
                break;
            }
            case 3: {
                string4 = GT._("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                string4 = GT._("bad [R,G,B] color");
                break;
            }
            case 5: {
                string4 = GT._("boolean expected");
                break;
            }
            case 6: {
                string4 = GT._("boolean or number expected");
                break;
            }
            case 7: {
                string4 = GT._("boolean, number, or {0} expected");
                break;
            }
            case 56: {
                string4 = GT._("cannot set value");
                break;
            }
            case 8: {
                string4 = GT._("color expected");
                break;
            }
            case 9: {
                string4 = GT._("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                string4 = GT._("command expected");
                break;
            }
            case 11: {
                string4 = GT._("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                string4 = GT._("draw object not defined");
                break;
            }
            case 13: {
                string4 = GT._("unexpected end of script command");
                break;
            }
            case 14: {
                string4 = GT._("valid (atom expression) expected");
                break;
            }
            case 15: {
                string4 = GT._("(atom expression) or integer expected");
                break;
            }
            case 16: {
                string4 = GT._("filename expected");
                break;
            }
            case 17: {
                string4 = GT._("file not found");
                break;
            }
            case 18: {
                string4 = GT._("incompatible arguments");
                break;
            }
            case 19: {
                string4 = GT._("insufficient arguments");
                break;
            }
            case 20: {
                string4 = GT._("integer expected");
                break;
            }
            case 21: {
                string4 = GT._("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                string4 = GT._("invalid argument");
                break;
            }
            case 23: {
                string4 = GT._("invalid parameter order");
                break;
            }
            case 24: {
                string4 = GT._("keyword expected");
                break;
            }
            case 25: {
                string4 = GT._("no MO coefficient data available");
                break;
            }
            case 26: {
                string4 = GT._("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                string4 = GT._("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                string4 = GT._("no MO occupancy data available");
                break;
            }
            case 29: {
                string4 = GT._("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                string4 = GT._("{0} require that only one model be displayed");
                break;
            }
            case 55: {
                string4 = GT._("{0} requires that only one model be loaded");
                break;
            }
            case 31: {
                string4 = GT._("No data available");
                break;
            }
            case 32: {
                string4 = GT._("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                string4 = GT._("No unit cell");
                break;
            }
            case 34: {
                string4 = GT._("number expected");
                break;
            }
            case 35: {
                string4 = GT._("number must be ({0} or {1})");
                break;
            }
            case 36: {
                string4 = GT._("decimal number out of range ({0} - {1})");
                break;
            }
            case 37: {
                string4 = GT._("object name expected after '$'");
                break;
            }
            case 38: {
                string4 = GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                string4 = GT._("property name expected");
                break;
            }
            case 40: {
                string4 = GT._("space group {0} was not found.");
                break;
            }
            case 41: {
                string4 = GT._("quoted string expected");
                break;
            }
            case 42: {
                string4 = GT._("quoted string or identifier expected");
                break;
            }
            case 43: {
                string4 = GT._("too many rotation points were specified");
                break;
            }
            case 44: {
                string4 = GT._("too many script levels");
                break;
            }
            case 45: {
                string4 = GT._("unrecognized atom property");
                break;
            }
            case 46: {
                string4 = GT._("unrecognized bond property");
                break;
            }
            case 47: {
                string4 = GT._("unrecognized command");
                break;
            }
            case 48: {
                string4 = GT._("runtime unrecognized expression");
                break;
            }
            case 49: {
                string4 = GT._("unrecognized object");
                break;
            }
            case 50: {
                string4 = GT._("unrecognized {0} parameter");
                break;
            }
            case 51: {
                string4 = GT._("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                string4 = GT._("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                string4 = "{0}";
                break;
            }
            case 54: {
                string4 = GT._("write what? {0} or {1} \"filename\"");
            }
        }
        if (string4.indexOf("{0}") < 0) {
            if (string != null) {
                string4 = string4 + ": " + string;
            }
        } else {
            if ((string4 = TextFormat.simpleReplace(string4, "{0}", string)).indexOf("{1}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{1}", string2);
            } else if (string2 != null) {
                string4 = string4 + ": " + string2;
            }
            if (string4.indexOf("{2}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{2}", string2);
            }
        }
        if (bl2) {
            GT.setDoTranslate(true);
        }
        return string4;
    }

    static String setErrorLineMessage(String string, String string2, int n, int n2, String string3) {
        String string4 = "\n----";
        if (string2 != null || string != null) {
            string4 = string4 + "line " + n + " command " + (n2 + 1) + " of " + (string == null ? string2 : (string.equals("try") ? "try" : "function " + string)) + ":";
        }
        string4 = string4 + "\n         " + string3;
        return string4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eval\n pc:");
        stringBuffer.append(this.pc);
        stringBuffer.append("\n");
        stringBuffer.append(this.aatoken.length);
        stringBuffer.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            stringBuffer.append("----\n");
            Token[] tokenArray = this.aatoken[i];
            for (int j = 0; j < tokenArray.length; ++j) {
                stringBuffer.append(tokenArray[j]);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("END\n");
        return stringBuffer.toString();
    }

    static String statementAsString(Token[] tokenArray, int n, boolean bl) {
        if (tokenArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = tokenArray[0].tok;
        switch (n2) {
            case 0: {
                return (String)tokenArray[0].value;
            }
            case 0x119009: {
                if (tokenArray.length != 2 || tokenArray[1].tok != 135368713 && tokenArray[1].tok != 102436) break;
                return ((ScriptFunction)tokenArray[1].value).toString();
            }
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = tokenArray.length > 1 && n2 == 1085443 && tokenArray[0].value.equals("") && (tokenArray[0].intValue == 61 || tokenArray[0].intValue == 35) && tokenArray[1].tok != 0x100001;
        int n3 = tokenArray.length;
        block32: for (int i = 0; i < n3; ++i) {
            Token token = tokenArray[i];
            if (token == null) {
                n3 = i;
                break;
            }
            if (n == i - 1) {
                stringBuffer.append(" <<");
            }
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if (i == 2 && bl5 && ((bl5 = token.tok != 269484436) || tokenArray[0].intValue == 35)) {
                stringBuffer.append(bl5 ? "= " : "== ");
                if (!bl5) continue;
            }
            if (n == i && token.tok != 0x100002) {
                stringBuffer.append(">> ");
            }
            switch (token.tok) {
                case 0x100001: {
                    if (!bl2) continue block32;
                    stringBuffer.append("{");
                    continue block32;
                }
                case 0x100002: {
                    if (bl4 && i == tokenArray.length - 1) {
                        bl2 = false;
                    }
                    if (!bl2) continue block32;
                    stringBuffer.append("}");
                    continue block32;
                }
                case 0x10100040: 
                case 0x10100041: {
                    break;
                }
                case 0x10000A: 
                case 0x10000E: {
                    bl3 = token.tok == 0x10000A;
                    break;
                }
                case 1060866: {
                    if (i <= 0 || !((String)token.value).equals("define")) break;
                    stringBuffer.append("@");
                    if (i + 1 >= tokenArray.length || tokenArray[i + 1].tok != 0x100001) continue block32;
                    if (!bl2) {
                        bl4 = true;
                    }
                    bl2 = true;
                    continue block32;
                }
                case 0x10000D: {
                    stringBuffer.append("true");
                    continue block32;
                }
                case 0x10000C: {
                    stringBuffer.append("false");
                    continue block32;
                }
                case 135280132: {
                    break;
                }
                case 2: {
                    stringBuffer.append(token.intValue);
                    continue block32;
                }
                case 8: 
                case 9: 
                case 10: {
                    stringBuffer.append(ScriptVariable.sValue(token));
                    continue block32;
                }
                case 6: 
                case 7: {
                    stringBuffer.append(((ScriptVariable)token).escape());
                    continue block32;
                }
                case 5: {
                    stringBuffer.append('^');
                    continue block32;
                }
                case 1048615: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                    } else {
                        stringBuffer.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    }
                    token = tokenArray[++i];
                    stringBuffer.append(' ');
                    stringBuffer.append(bl3 ? "-" : "- ");
                }
                case 1048614: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                        continue block32;
                    }
                    stringBuffer.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    continue block32;
                }
                case 0x100021: {
                    stringBuffer.append("*:");
                    stringBuffer.append((char)token.intValue);
                    continue block32;
                }
                case 0x10001F: {
                    stringBuffer.append("*%");
                    if (token.value == null) continue block32;
                    stringBuffer.append(token.value.toString());
                    continue block32;
                }
                case 0x100022: {
                    stringBuffer.append("*/");
                }
                case 3: 
                case 1048611: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        stringBuffer.append(Escape.escapeModelFileNumber(token.intValue));
                        continue block32;
                    }
                    stringBuffer.append("" + token.value);
                    continue block32;
                }
                case 1048613: {
                    stringBuffer.append('[');
                    stringBuffer.append(Group.getGroup3((short)token.intValue));
                    stringBuffer.append(']');
                    continue block32;
                }
                case 1048612: {
                    stringBuffer.append('[');
                    stringBuffer.append(token.value);
                    stringBuffer.append(']');
                    continue block32;
                }
                case 0x100020: {
                    stringBuffer.append("*.");
                    break;
                }
                case 1095761925: {
                    if (!(token.value instanceof Point3f)) break;
                    Point3f point3f = (Point3f)token.value;
                    stringBuffer.append("cell=").append(Escape.escape(point3f));
                    continue block32;
                }
                case 4: {
                    stringBuffer.append("\"").append(token.value).append("\"");
                    continue block32;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484438: {
                    if (token.intValue == 1716520973) {
                        stringBuffer.append((String)tokenArray[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    stringBuffer.append(Token.nameOf(token.intValue)).append(" ");
                    break;
                }
                case 364558: {
                    continue block32;
                }
                case 0x119009: {
                    stringBuffer.append("end");
                    continue block32;
                }
                default: {
                    if (Token.tokAttr(token.tok, 0x40000000) || !bl) break;
                    stringBuffer.append('\n').append(token.toString()).append('\n');
                    continue block32;
                }
            }
            if (token.value == null) continue;
            stringBuffer.append(token.value.toString());
        }
        if (n >= n3 - 1 && n != 9999) {
            stringBuffer.append(" <<");
        }
        return stringBuffer.toString();
    }

    private Object getShapeProperty(int n, String string) {
        return this.shapeManager.getShapeProperty(n, string, Integer.MIN_VALUE);
    }

    private boolean getShapeProperty(int n, String string, Object[] objectArray) {
        return this.shapeManager.getShapeProperty(n, string, objectArray);
    }

    private Object getShapeProperty(int n, String string, int n2) {
        return this.shapeManager.getShapeProperty(n, string, n2);
    }

    private void addShapeProperty(List<Object[]> list, String string, Object object) {
        if (this.isSyntaxCheck) {
            return;
        }
        System.out.println("addshapeprop " + string + " " + object);
        list.add(new Object[]{string, object});
    }

    private void setObjectMad(int n, String string, int n2) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setObjectMad(n, string, n2);
    }

    private void setObjectArgb(String string, int n) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setObjectArgb(string, n);
    }

    private void setShapeProperty(int n, String string, Object object) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeProperty(n, string, object, null);
    }

    private void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeProperty(n, string, object, bitSet);
    }

    private void setShapeSize(int n, int n2, BitSet bitSet) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeSize(n, n2, null, bitSet);
    }

    private void setShapeSize(int n, RadiusData radiusData) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeSize(n, 0, radiusData, null);
    }

    private void setBooleanProperty(String string, boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    private boolean setIntProperty(String string, int n) {
        if (!this.isSyntaxCheck) {
            this.viewer.setIntProperty(string, n);
        }
        return true;
    }

    private boolean setFloatProperty(String string, float f) {
        if (!this.isSyntaxCheck) {
            this.viewer.setFloatProperty(string, f);
        }
        return true;
    }

    private void setStringProperty(String string, String string2) {
        if (!this.isSyntaxCheck) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    private void showString(String string) {
        this.showString(string, false);
    }

    private void showString(String string, boolean bl) {
        if (this.isSyntaxCheck || string == null) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
        } else {
            this.viewer.showString(string, bl);
        }
    }

    private void scriptStatusOrBuffer(String string) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
            return;
        }
        this.viewer.scriptStatus(string);
    }

    private BitSet atomExpression(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(2, n);
        }
        return this.atomExpression(this.statement, n, 0, true, false, true, true);
    }

    private BitSet atomExpression(Token[] tokenArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ScriptException {
        this.isBondSet = false;
        if (tokenArray != this.statement) {
            this.tempStatement = this.statement;
            this.statement = tokenArray;
        }
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, false, false, bl3);
        int n3 = Integer.MAX_VALUE;
        boolean bl5 = false;
        this.iToken = 1000;
        boolean bl6 = n < 0;
        boolean bl7 = false;
        int n4 = 0;
        int n5 = this.viewer.getAtomCount();
        if (bl6) {
            n = -n;
        }
        bl6 |= this.isSyntaxCheck;
        if (n2 == 0 && tokenArray.length > n) {
            n2 = n + 1;
        }
        block38: for (int i = n; i < n2; ++i) {
            this.iToken = i;
            Token token = tokenArray[i];
            if (token == null) break;
            Object object = token.value;
            switch (token.tok) {
                case 0x100001: {
                    n = i;
                    n2 = tokenArray.length;
                    ++n4;
                    continue block38;
                }
                case 0x100002: {
                    if (--n4 <= 0) break block38;
                    continue block38;
                }
                case 0x10000A: {
                    Object object2;
                    if (!this.isPoint3f(i) || (object2 = this.getPoint3f(i, true)) == null) continue block38;
                    scriptMathProcessor.addX((Point3f)object2);
                    i = this.iToken;
                    continue block38;
                }
                case 0x10000E: {
                    if (i <= 0 || tokenArray[i - 1].tok != 0x10000A) continue block38;
                    scriptMathProcessor.addX(new BitSet());
                    continue block38;
                }
                case 0x10100040: {
                    bl7 = true;
                    scriptMathProcessor.addOp(token);
                    continue block38;
                }
                case 0x10100041: {
                    bl7 = false;
                    scriptMathProcessor.addOp(token);
                    continue block38;
                }
                case 1060866: {
                    scriptMathProcessor.addX(ScriptEvaluator.getAtomBitSet(this, object));
                    continue block38;
                }
                case 135267841: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(new ScriptVariable(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block38;
                }
                case 135266319: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(new ScriptVariable(9, this.planeParameter(i + 2)));
                    i = this.iToken;
                    continue block38;
                }
                case 0x100006: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block38;
                }
                case 4: {
                    BitSet bitSet;
                    Object object2 = (String)object;
                    if (((String)object2).indexOf("({") == 0 && (bitSet = Escape.unescapeBitset((String)object2)) != null) {
                        scriptMathProcessor.addX(bitSet);
                        continue block38;
                    }
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    if (!((String)object2).equals("hkl")) continue block38;
                    scriptMathProcessor.addX(new ScriptVariable(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block38;
                }
                case 135266310: 
                case 135266324: 
                case 135267335: 
                case 135267336: 
                case 135402505: 
                case 0x10100030: 
                case 1238369286: {
                    scriptMathProcessor.addOp(token);
                    continue block38;
                }
                case 0x100003: {
                    scriptMathProcessor.addX(this.viewer.getModelUndeletedAtomsBitSet(-1));
                    continue block38;
                }
                case 0x10000B: {
                    scriptMathProcessor.addX(new BitSet());
                    continue block38;
                }
                case 0x10000C: 
                case 0x10000D: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    continue block38;
                }
                case 1114638350: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getSelectionSet(false)));
                    continue block38;
                }
                case 0x303008: {
                    BitSet bitSet = this.viewer.getSelectionSubset();
                    scriptMathProcessor.addX(bitSet == null ? this.viewer.getModelUndeletedAtomsBitSet(-1) : BitSetUtil.copy(bitSet));
                    continue block38;
                }
                case 3145770: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getHiddenSet()));
                    continue block38;
                }
                case 1060869: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getMotionFixedAtoms()));
                    continue block38;
                }
                case 3145768: {
                    scriptMathProcessor.addX(BitSetUtil.copyInvert(this.viewer.getHiddenSet(), n5));
                    continue block38;
                }
                case 0x300030: {
                    scriptMathProcessor.addX(this.viewer.getBaseModelBitSet());
                    continue block38;
                }
                case 3145774: {
                    if (!this.isSyntaxCheck && !bl5) {
                        this.viewer.setModelVisibility();
                    }
                    bl5 = true;
                    scriptMathProcessor.addX(this.viewer.getVisibleSet());
                    continue block38;
                }
                case 3145766: {
                    if (!this.isSyntaxCheck && bl) {
                        this.refresh();
                    }
                    scriptMathProcessor.addX(this.viewer.getClickableSet());
                    continue block38;
                }
                case 0x100020: {
                    int n6;
                    if (this.viewer.allowSpecAtom()) {
                        n6 = token.intValue;
                        if (n6 > 0) {
                            scriptMathProcessor.addX(this.compareInt(1095761922, 269484436, n6));
                            continue block38;
                        }
                        scriptMathProcessor.addX(this.getAtomBits(token.tok, object));
                        continue block38;
                    }
                    scriptMathProcessor.addX(this.lookupIdentifierValue("_" + object));
                    continue block38;
                }
                case 0x100009: 
                case 0x10001F: 
                case 1048612: 
                case 0x300004: 
                case 0x30000E: 
                case 0x300010: 
                case 3145746: 
                case 3145748: 
                case 3145750: 
                case 3145764: 
                case 3145772: 
                case 1089470478: 
                case 0x60300006: 
                case 1614417948: {
                    scriptMathProcessor.addX(this.getAtomBits(token.tok, object));
                    continue block38;
                }
                case 0x100022: 
                case 1048611: {
                    int n6 = token.intValue;
                    if (n6 == Integer.MAX_VALUE && object instanceof Integer) {
                        n6 = (Integer)object;
                        if (!this.viewer.haveFileSet()) {
                            scriptMathProcessor.addX(this.getAtomBits(0x100022, n6));
                            continue block38;
                        }
                        if (n6 <= 2147) {
                            n6 *= 1000000;
                        }
                    }
                    scriptMathProcessor.addX(this.bitSetForModelFileNumber(n6));
                    continue block38;
                }
                case 0x100021: 
                case 1048613: {
                    scriptMathProcessor.addX(this.getAtomBits(token.tok, new Integer(token.intValue)));
                    continue block38;
                }
                case 1048614: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(token.intValue));
                        continue block38;
                    }
                    scriptMathProcessor.addX(this.getAtomBits(1048614, new Integer(ScriptEvaluator.getSeqCode(token))));
                    continue block38;
                }
                case 1048615: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(token.intValue));
                        scriptMathProcessor.addX(Token.tokenMinus);
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(tokenArray[++i].intValue));
                        continue block38;
                    }
                    int n7 = i + 3 < tokenArray.length && tokenArray[i + 2].tok == 0x10100080 && tokenArray[i + 3].tok == 0x100021 ? tokenArray[i + 3].intValue : 9;
                    scriptMathProcessor.addX(this.getAtomBits(1048615, new int[]{ScriptEvaluator.getSeqCode(token), ScriptEvaluator.getSeqCode(tokenArray[++i]), n7}));
                    if (n7 == 9) continue block38;
                    i += 2;
                    continue block38;
                }
                case 1095761925: {
                    Point3f point3f = (Point3f)object;
                    scriptMathProcessor.addX(this.getAtomBits(1095761925, new int[]{(int)(point3f.x * 1000.0f), (int)(point3f.y * 1000.0f), (int)(point3f.z * 1000.0f)}));
                    continue block38;
                }
                case 3145758: {
                    scriptMathProcessor.addX(this.viewer.getModelUndeletedAtomsBitSet(this.viewer.getCurrentModelIndex()));
                    continue block38;
                }
                case 0x300002: 
                case 0x300007: 
                case 0x300008: 
                case 0x30000A: 
                case 3145754: 
                case 3145756: 
                case 137363468: 
                case 1115297793: 
                case 1613758476: 
                case 1613758488: {
                    scriptMathProcessor.addX(this.lookupIdentifierValue((String)object));
                    continue block38;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484438: {
                    float[] fArray;
                    boolean bl8;
                    String string;
                    if (i + 1 == tokenArray.length) {
                        this.error(22);
                    }
                    Object object3 = tokenArray[++i].value;
                    int n8 = token.tok;
                    int n9 = token.intValue;
                    String string2 = string = n9 == 1716520973 ? (String)object3 : null;
                    if (string != null) {
                        if (i + 1 == tokenArray.length) {
                            this.error(22);
                        }
                        object3 = tokenArray[++i].value;
                    }
                    if (n9 == 1095766022 && n8 != 269484436) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        scriptMathProcessor.addX(new BitSet());
                        continue block38;
                    }
                    boolean bl9 = n9 == 1095766028;
                    boolean bl10 = Token.tokAttr(n9, 1095761920);
                    boolean bl11 = Token.tokAttr(n9, 1112539136);
                    boolean bl12 = bl10 && bl11;
                    boolean bl13 = bl8 = !bl10 && Token.tokAttr(n9, 0x40D00000);
                    if (n9 == 1087375365) {
                        bl8 = false;
                        bl10 = !false;
                    }
                    int n10 = tokenArray[i].tok;
                    n3 = tokenArray[i].intValue;
                    float f = Float.NaN;
                    if (object3 instanceof Point3f) {
                        if (n9 == 1766856708) {
                            n3 = ColorUtil.colorPtToInt((Point3f)object3);
                            n10 = 2;
                            bl10 = true;
                        }
                    } else if (object3 instanceof String) {
                        if (n9 == 1766856708) {
                            n3 = ColorUtil.getArgbFromString((String)object3);
                            if (n3 == 0 && Token.tokAttr(n10, 0x40000000)) {
                                n3 = ((String)(object3 = this.getStringParameter((String)object3, true))).startsWith("{") ? ((object3 = Escape.unescapePoint((String)object3)) instanceof Point3f ? ColorUtil.colorPtToInt((Point3f)object3) : 0) : ColorUtil.getArgbFromString((String)object3);
                            }
                            n10 = 2;
                            bl10 = true;
                        } else if (bl8) {
                            if (Token.tokAttr(n10, 0x40000000)) {
                                object3 = this.getStringParameter((String)object3, true);
                            }
                        } else {
                            if (Token.tokAttr(n10, 0x40000000)) {
                                object3 = this.getNumericParameter((String)object3);
                            }
                            if (object3 instanceof String) {
                                if (n9 == 1641025539 || n9 == 1238369286 || n9 == 1087375365) {
                                    bl10 = n3 != Integer.MAX_VALUE;
                                    bl8 = !bl10;
                                } else {
                                    object3 = ScriptVariable.nValue(tokenArray[i]);
                                }
                            }
                            if (object3 instanceof Integer) {
                                n3 = (Integer)object3;
                                f = n3;
                            } else if (object3 instanceof Float && bl9) {
                                n3 = ModelCollection.modelFileNumberFromFloat(((Float)object3).floatValue());
                            }
                        }
                    }
                    if (bl8 && !(object3 instanceof String)) {
                        object3 = "" + object3;
                    }
                    if (object3 instanceof Integer || n10 == 2) {
                        if (bl9) {
                            if (n3 >= 1000000) {
                                n9 = -1095766028;
                            }
                        } else if (bl12) {
                            bl11 = false;
                        } else if (bl11) {
                            f = n3;
                        }
                    } else if (object3 instanceof Float) {
                        if (bl9) {
                            n9 = -1095766028;
                        } else {
                            f = ((Float)object3).floatValue();
                            if (bl12) {
                                bl10 = false;
                            } else if (bl10) {
                                n3 = (int)f;
                            }
                        }
                    } else if (!bl8) {
                        ++this.iToken;
                        this.error(22);
                    }
                    if (bl9 && n3 >= 1000000 && n3 % 1000000 == 0) {
                        n3 /= 1000000;
                        n9 = 1229984263;
                        bl9 = false;
                    }
                    if (n9 == -1095766028 && n8 == 269484436) {
                        scriptMathProcessor.addX(this.bitSetForModelFileNumber(n3));
                        continue block38;
                    }
                    if (object != null && ((String)object).indexOf("-") >= 0) {
                        if (bl10) {
                            n3 = -n3;
                        } else if (!Float.isNaN(f)) {
                            f = -f;
                        }
                    }
                    float[] fArray2 = fArray = n9 == 1716520973 ? this.viewer.getDataFloat(string) : null;
                    scriptMathProcessor.addX(bl10 ? this.compareInt(n9, n8, n3) : (bl8 ? this.compareString(n9, n8, (String)object3) : this.compareFloat(n9, fArray, n8, f)));
                    continue block38;
                }
                case 2: 
                case 3: {
                    scriptMathProcessor.addXNum(new ScriptVariable(token));
                    continue block38;
                }
                case 10: {
                    BitSet bitSet = BitSetUtil.copy((BitSet)object);
                    scriptMathProcessor.addX(bitSet);
                    continue block38;
                }
                case 8: {
                    scriptMathProcessor.addX(object);
                    continue block38;
                }
                default: {
                    if (Token.tokAttr(token.tok, 0x10100000)) {
                        if (scriptMathProcessor.addOp(token)) continue block38;
                        this.error(22);
                        continue block38;
                    }
                    if (!(object instanceof String)) {
                        scriptMathProcessor.addX(object);
                        continue block38;
                    }
                    Object object3 = this.getParameter((String)object, 0);
                    if (bl7) {
                        scriptMathProcessor.addX(object3);
                        continue block38;
                    }
                    if (object3 instanceof String) {
                        object3 = this.getStringObjectAsVariable((String)object3, null);
                    }
                    if (object3 instanceof List) {
                        BitSet bitSet = ScriptVariable.unEscapeBitSetArray((ArrayList)object3, true);
                        object3 = bitSet == null ? object : bitSet;
                    }
                    if (object3 instanceof String) {
                        object3 = this.lookupIdentifierValue((String)object);
                    }
                    scriptMathProcessor.addX(object3);
                }
            }
        }
        this.expressionResult = scriptMathProcessor.getResult(bl2);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.isSyntaxCheck) {
                scriptMathProcessor.dumpStacks("after getResult");
            }
            this.error(13);
        }
        this.expressionResult = ((ScriptVariable)this.expressionResult).value;
        if (this.expressionResult instanceof String && (bl3 || ((String)this.expressionResult).startsWith("({"))) {
            Object object = this.expressionResult = this.isSyntaxCheck ? new BitSet() : ScriptEvaluator.getAtomBitSet(this, this.expressionResult);
        }
        if (!bl3 && !(this.expressionResult instanceof BitSet)) {
            return null;
        }
        BitSet bitSet = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : new BitSet();
        this.isBondSet = this.expressionResult instanceof Bond.BondSet;
        if (!this.isBondSet) {
            this.viewer.excludeAtoms(bitSet, bl6);
            if (bitSet.length() > this.viewer.getAtomCount()) {
                bitSet.clear();
            }
        }
        if (this.tempStatement != null) {
            this.statement = this.tempStatement;
            this.tempStatement = null;
        }
        return bitSet;
    }

    private BitSet compareFloat(int n, float[] fArray, int n2, float f) {
        BitSet bitSet = new BitSet();
        int n3 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        float f2 = 0.0f;
        this.viewer.autoCalculate(n);
        int n4 = n3;
        block3: while (--n4 >= 0) {
            boolean bl = false;
            Atom atom = atomArray[n4];
            switch (n) {
                default: {
                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                    break;
                }
                case 1716520973: {
                    if (fArray == null || fArray.length <= n4) continue block3;
                    f2 = fArray[n4];
                }
            }
            if (!(bl = ScriptEvaluator.compareFloat(n2, f2, f))) continue;
            bitSet.set(n4);
        }
        return bitSet;
    }

    private BitSet compareString(int n, int n2, String string) throws ScriptException {
        boolean bl;
        BitSet bitSet = new BitSet();
        Atom[] atomArray = this.viewer.getModelSet().atoms;
        int n3 = this.viewer.getAtomCount();
        boolean bl2 = bl = n == 0x40D00004 && this.viewer.getChainCaseSensitive();
        if (!bl) {
            string = string.toLowerCase();
        }
        int n4 = n3;
        while (--n4 >= 0) {
            String string2 = Atom.atomPropertyString(this.viewer, atomArray[n4], n);
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (!this.compareString(n2, string2, string)) continue;
            bitSet.set(n4);
        }
        return bitSet;
    }

    protected BitSet compareInt(int n, int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        BitSet bitSet = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        switch (n) {
            case 1297090050: {
                switch (n5) {
                    case 0x10100190: 
                    case 0x10100191: {
                        n8 = Integer.MAX_VALUE;
                    }
                }
                break;
            }
            case 1095761923: {
                try {
                    switch (n2) {
                        case 269484435: {
                            return BitSetUtil.newBitSet(0, n3);
                        }
                        case 269484434: {
                            return BitSetUtil.newBitSet(0, n3 + 1);
                        }
                        case 0x10100191: {
                            return BitSetUtil.newBitSet(n3, n7);
                        }
                        case 0x10100190: {
                            return BitSetUtil.newBitSet(n3 + 1, n7);
                        }
                        case 269484436: {
                            return n3 < n7 ? BitSetUtil.newBitSet(n3, n3 + 1) : new BitSet();
                        }
                    }
                    BitSet bitSet2 = BitSetUtil.setAll(n7);
                    if (n3 >= 0) {
                        bitSet2.clear(n3);
                    }
                    return bitSet2;
                }
                catch (Exception exception) {
                    return new BitSet();
                }
            }
        }
        BitSet bitSet3 = new BitSet(n7);
        block37: for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    n4 = Atom.atomPropertyInt(atom, n);
                    break;
                }
                case 1095766022: {
                    return BitSetUtil.copy(this.viewer.getConformation(-1, n3 - 1, false));
                }
                case 1297090050: {
                    int n12;
                    bitSet = atom.getAtomSymmetry();
                    if (bitSet == null) continue block37;
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    if (n6 >= 200) {
                        if (nArray == null) continue block37;
                        n3 = n6 % 1000;
                        n12 = n6 / 1000 - 1;
                        if (n12 < 0) {
                            bl = true;
                        } else if (n11 == 0 || n12 >= 0 && !(bl = bitSet.get(n12))) continue block37;
                        n5 = 0x10000B;
                        n4 = n12 < 0 ? atom.getCellTranslation(n3, nArray, n11) : atom.getSymmetryTranslation(n12, nArray, n11);
                    } else if (n11 > 0) {
                        if (n3 > n11 && n5 != 269484435 && n5 != 269484434) continue block37;
                        if (n5 == 269484438) {
                            if (n3 <= 0 || n3 > n11 || bitSet.get(n3)) continue block37;
                            bitSet3.set(i);
                            continue block37;
                        }
                    }
                    switch (n5) {
                        case 269484435: {
                            n8 = n3 - 1;
                            break;
                        }
                        case 269484434: {
                            n8 = n3;
                            break;
                        }
                        case 0x10100191: {
                            n9 = n3 - 1;
                            break;
                        }
                        case 0x10100190: {
                            n9 = n3;
                            break;
                        }
                        case 269484436: {
                            n8 = n3;
                            n9 = n3 - 1;
                            break;
                        }
                        case 269484438: {
                            boolean bl2 = bl = !bitSet.get(n3);
                        }
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if (n9 < n8 && (n12 = bitSet.nextSetBit(n9)) >= 0 && n12 < n8) {
                        bl = true;
                    }
                    if (bl && n4 != Integer.MAX_VALUE) break;
                    n2 = 0x10000B;
                }
            }
            switch (n2) {
                case 0x10000B: {
                    break;
                }
                case 269484435: {
                    bl = n4 < n3;
                    break;
                }
                case 269484434: {
                    bl = n4 <= n3;
                    break;
                }
                case 0x10100191: {
                    bl = n4 >= n3;
                    break;
                }
                case 0x10100190: {
                    bl = n4 > n3;
                    break;
                }
                case 269484436: {
                    bl = n4 == n3;
                    break;
                }
                case 269484438: {
                    boolean bl3 = bl = n4 != n3;
                }
            }
            if (!bl) continue;
            bitSet3.set(i);
        }
        return bitSet3;
    }

    private boolean compareString(int n, String string, String string2) throws ScriptException {
        switch (n) {
            case 269484436: 
            case 269484438: {
                return TextFormat.isMatch(string, string2, true, true) == (n == 269484436);
            }
        }
        this.error(22);
        return false;
    }

    private static boolean compareFloat(int n, float f, float f2) {
        switch (n) {
            case 269484435: {
                return f < f2;
            }
            case 269484434: {
                return f <= f2;
            }
            case 0x10100191: {
                return f >= f2;
            }
            case 0x10100190: {
                return f > f2;
            }
            case 269484436: {
                return f == f2;
            }
            case 269484438: {
                return f != f2;
            }
        }
        return false;
    }

    private BitSet getAtomBits(int n, Object object) {
        return this.isSyntaxCheck ? new BitSet() : this.viewer.getAtomBits(n, object);
    }

    private static int getSeqCode(Token token) {
        return token.intValue != Integer.MAX_VALUE ? Group.getSeqcode(token.intValue, ' ') : (Integer)token.value;
    }

    private int checkLast(int n) throws ScriptException {
        return this.checkLength(n + 1) - 1;
    }

    private int checkLength(int n) throws ScriptException {
        if (n >= 0) {
            return this.checkLength(n, 0);
        }
        if (this.statementLength > -n) {
            this.iToken = -n;
            this.error(2);
        }
        return this.statementLength;
    }

    private int checkLength(int n, int n2) throws ScriptException {
        if (this.statementLength != n) {
            this.iToken = n2 > 0 ? n2 : this.statementLength;
            this.error(n2 > 0 ? 22 : 2);
        }
        return this.statementLength;
    }

    private int checkLength23() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != 2 && this.statementLength != 3) {
            this.error(2);
        }
        return this.statementLength;
    }

    private int checkLength34() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != 3 && this.statementLength != 4) {
            this.error(2);
        }
        return this.statementLength;
    }

    private Token getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(13);
        }
        this.theToken = this.statement[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    private int tokAt(int n) {
        return n < this.statementLength && this.statement[n] != null ? this.statement[n].tok : 0;
    }

    private int tokAt(int n, Token[] tokenArray) {
        return n < tokenArray.length && tokenArray[n] != null ? tokenArray[n].tok : 0;
    }

    private Token tokenAt(int n, Token[] tokenArray) {
        return n < tokenArray.length ? tokenArray[n] : null;
    }

    private boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.statementLength;
    }

    private int modelNumberParameter(int n) throws ScriptException {
        int n2 = 0;
        boolean bl = false;
        switch (this.tokAt(n)) {
            case 2: {
                bl = true;
            }
            case 3: {
                n2 = this.getToken((int)n).intValue;
                break;
            }
            case 4: {
                n2 = ScriptEvaluator.getFloatEncodedInt(this.stringParameter(n));
                break;
            }
            default: {
                this.error(22);
            }
        }
        return this.viewer.getModelNumberIndex(n2, bl, true);
    }

    private String optParameterAsString(int n) throws ScriptException {
        if (n >= this.statementLength) {
            return "";
        }
        return this.parameterAsString(n);
    }

    private String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.error(13);
        }
        return ScriptVariable.sValue(this.theToken);
    }

    private int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    private int intParameter(int n, int n2, int n3) throws ScriptException {
        int n4 = this.intParameter(n);
        if (n4 < n2 || n4 > n3) {
            this.integerOutOfRange(n2, n3);
        }
        return n4;
    }

    private boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameter(int n, float f, float f2) throws ScriptException {
        float f3 = this.floatParameter(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 1048615: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1048614: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1048611: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(34);
        return 0.0f;
    }

    private float[] floatParameterSet(int n, int n2, int n3) throws ScriptException {
        int n4 = this.tokAt(n);
        if (n4 == 1073742195) {
            n4 = this.tokAt(++n);
        }
        boolean bl = n4 == 0x10000A;
        boolean bl2 = n4 == 0x10100040;
        float[] fArray = null;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n5 = 0;
        if (bl || bl2) {
            ++n;
        }
        String string = null;
        block0 : switch (this.tokAt(n)) {
            case 4: {
                string = ScriptVariable.sValue(this.statement[n]);
                string = TextFormat.replaceAllCharacters(string, "{},[]\"'", ' ');
                fArray = Parser.parseFloatArray(string);
                n5 = fArray.length;
                break;
            }
            case 7: {
                fArray = ScriptVariable.flistValue(this.statement[n++], 0);
                n5 = fArray.length;
                break;
            }
            default: {
                while (n5 < n3) {
                    n4 = this.tokAt(n);
                    if (bl && n4 == 0x10000E || bl2 && n4 == 0x10100041) break block0;
                    switch (n4) {
                        case 0x10000A: 
                        case 0x10000E: 
                        case 0x10100030: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 8: {
                            Point3f point3f = this.getPoint3f(n, false);
                            arrayList.add(Float.valueOf(point3f.x));
                            arrayList.add(Float.valueOf(point3f.y));
                            arrayList.add(Float.valueOf(point3f.z));
                            n5 += 3;
                            break;
                        }
                        case 9: {
                            Point4f point4f = this.getPoint4f(n);
                            arrayList.add(Float.valueOf(point4f.x));
                            arrayList.add(Float.valueOf(point4f.y));
                            arrayList.add(Float.valueOf(point4f.z));
                            arrayList.add(Float.valueOf(point4f.w));
                            n5 += 4;
                            break;
                        }
                        default: {
                            arrayList.add(Float.valueOf(this.floatParameter(n)));
                            if (++n5 != n3 || !bl2 || this.tokAt(n + 1) != 0x10000E) break;
                            ++n;
                        }
                    }
                    ++n;
                }
                break block0;
            }
        }
        if (bl && this.tokAt(n++) != 0x10000E || bl2 && this.tokAt(n++) != 0x10100041) {
            this.error(22);
        }
        this.iToken = n - 1;
        if (n5 < n2 || n5 > n3) {
            this.error(22);
        }
        if (fArray == null) {
            fArray = new float[n5];
            for (int i = 0; i < n5; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
        }
        return fArray;
    }

    private boolean isArrayParameter(int n) {
        switch (this.tokAt(n)) {
            case 7: 
            case 11: 
            case 12: 
            case 0x10100040: 
            case 1073742195: {
                return true;
            }
        }
        return false;
    }

    private Point3f[] getPointArray(int n, int n2) throws ScriptException {
        Point3f[] point3fArray = n2 < 0 ? null : new Point3f[n2];
        ArrayList<Point3f> arrayList = n2 < 0 ? new ArrayList<Point3f>() : null;
        int n3 = n < 0 ? 7 : this.getToken((int)n++).tok;
        switch (n3) {
            case 7: {
                List<ScriptVariable> list = ((ScriptVariable)this.theToken).getList();
                if (n2 >= 0 && list.size() != n2) {
                    this.error(22);
                }
                n2 = list.size();
                if (point3fArray == null) {
                    point3fArray = new Point3f[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    point3fArray[i] = ScriptVariable.ptValue(list.get(i));
                    if (point3fArray[i] != null) continue;
                    this.error(22);
                }
                return point3fArray;
            }
            case 1073742195: {
                n3 = this.tokAt(n++);
            }
        }
        if (n3 != 0x10100040) {
            this.error(22);
        }
        int n4 = 0;
        block9: while (n3 != 0x10100041 && n3 != 0) {
            n3 = this.getToken((int)n).tok;
            switch (n3) {
                case 0: 
                case 0x10100041: {
                    continue block9;
                }
                case 0x10100030: {
                    ++n;
                    continue block9;
                }
            }
            if (n2 >= 0 && n4 == n2) {
                n3 = 0;
                continue;
            }
            Point3f point3f = this.getPoint3f(n, true);
            if (point3fArray == null) {
                arrayList.add(point3f);
            } else {
                point3fArray[n4] = point3f;
            }
            ++n4;
            n = this.iToken + 1;
        }
        if (n3 != 0x10100041) {
            this.error(22);
        }
        if (point3fArray == null) {
            point3fArray = arrayList.toArray(new Point3f[arrayList.size()]);
        }
        return point3fArray;
    }

    private float[][] floatArraySet(int n, int n2, int n3) throws ScriptException {
        int n4;
        if ((n4 = this.tokAt(n++)) == 1073742195) {
            n4 = this.tokAt(n++);
        }
        if (n4 != 0x10100040) {
            this.error(22);
        }
        float[][] fArrayArray = new float[n2][];
        int n5 = 0;
        block5: while (n4 != 0x10100041) {
            n4 = this.getToken((int)n).tok;
            switch (n4) {
                case 0x10100041: 
                case 1073742195: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    ++n;
                    float[] fArray = new float[n3];
                    fArrayArray[n5++] = fArray;
                    for (int i = 0; i < n3; ++i) {
                        fArray[i] = this.floatParameter(n++);
                        if (this.tokAt(n) != 0x10100030) continue;
                        ++n;
                    }
                    if (this.tokAt(n++) != 0x10100041) {
                        this.error(22);
                    }
                    n4 = 0;
                    if (n5 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.error(22);
                    continue block5;
                }
            }
            this.error(22);
        }
        return fArrayArray;
    }

    private float[][][] floatArraySet(int n, int n2, int n3, int n4) throws ScriptException {
        int n5;
        if ((n5 = this.tokAt(n++)) == 1073742195) {
            n5 = this.tokAt(n++);
        }
        if (n5 != 0x10100040 || n2 <= 0) {
            this.error(22);
        }
        float[][][] fArrayArray = new float[n2][][];
        int n6 = 0;
        block5: while (n5 != 0x10100041) {
            n5 = this.getToken((int)n).tok;
            switch (n5) {
                case 0x10100041: 
                case 1073742195: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    fArrayArray[n6++] = this.floatArraySet(n, n3, n4);
                    n = ++this.iToken;
                    n5 = 0;
                    if (n6 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.error(22);
                    continue block5;
                }
            }
            this.error(22);
        }
        return fArrayArray;
    }

    private String stringParameter(int n) throws ScriptException {
        if (!this.checkToken(n) || this.getToken((int)n).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    private String[] stringParameterSet(int n) throws ScriptException {
        int n2;
        switch (this.tokAt(n)) {
            case 4: {
                Object object;
                String string = this.stringParameter(n);
                if (string.startsWith("[\"") && (object = this.viewer.evaluateExpression(string)) instanceof String) {
                    return TextFormat.split((String)object, '\n');
                }
                return new String[]{string};
            }
            case 1073742195: {
                n += 2;
                break;
            }
            case 0x10100040: {
                ++n;
                break;
            }
            case 7: {
                return ScriptVariable.listValue(this.getToken(n));
            }
            default: {
                this.error(22);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = this.tokAt(n)) != 0x10100041) {
            switch (n2) {
                case 0x10100030: {
                    break;
                }
                case 4: {
                    arrayList.add(this.stringParameter(n));
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            ++n;
        }
        this.iToken = n;
        int n3 = arrayList.size();
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private String objectNameParameter(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(37);
        }
        return this.parameterAsString(n);
    }

    private boolean booleanParameter(int n) throws ScriptException {
        if (this.statementLength == n) {
            return true;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
        }
        this.error(5);
        return false;
    }

    private Point3f atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 10: 
            case 0x100001: {
                BitSet bitSet = this.atomExpression(this.statement, n, 0, true, false, false, true);
                if (bitSet != null) {
                    return this.viewer.getAtomSetCenter(bitSet);
                }
                if (this.expressionResult instanceof Point3f) {
                    return (Point3f)this.expressionResult;
                }
                this.error(22);
                break;
            }
            case 8: 
            case 0x10000A: {
                return this.getPoint3f(n, true);
            }
        }
        this.error(22);
        return null;
    }

    private boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x100007 || n2 == 0x10000A || n2 == 0x100001 || n2 == 8 || n2 == 10;
    }

    private Point3f centerParameter(int n) throws ScriptException {
        return this.centerParameter(n, Integer.MIN_VALUE);
    }

    private Point3f centerParameter(int n, int n2) throws ScriptException {
        Point3f point3f = null;
        this.expressionResult = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    int n3 = Integer.MIN_VALUE;
                    if (this.tokAt(n + 1) == 0x10100040) {
                        n3 = ScriptVariable.iValue(this.parameterExpressionList(-n - 1, -1, true).get(0));
                        if (this.getToken((int)(--this.iToken)).tok != 0x10100041) {
                            this.error(22);
                        }
                    }
                    if (this.isSyntaxCheck) {
                        return new Point3f();
                    }
                    if (this.tokAt(n + 1) == 0x100008 && (this.tokAt(n + 2) == 1141899267 || this.tokAt(n + 2) == 1141899270)) {
                        n3 = Integer.MAX_VALUE;
                        this.iToken = n + 2;
                    }
                    if ((point3f = this.getObjectCenter(string, n3, n2)) != null) break;
                    this.error(12, string);
                    break;
                }
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x10000A: {
                    point3f = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (point3f == null) {
            this.error(11);
        }
        return point3f;
    }

    private Point4f planeParameter(int n) throws ScriptException {
        boolean bl;
        Tuple4f tuple4f;
        block28: {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            tuple4f = null;
            boolean bl2 = bl = this.tokAt(n) == 0x101000A0;
            if (bl) {
                ++n;
            }
            if (n >= this.statementLength) break block28;
            switch (this.getToken((int)n).tok) {
                case 9: {
                    tuple4f = new Point4f((Point4f)this.theToken.value);
                    break;
                }
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        return new Point4f();
                    }
                    int n2 = this.shapeManager.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 22: {
                            this.setShapeProperty(22, "thisID", string);
                            Point3f[] point3fArray = (Point3f[])this.getShapeProperty(22, "vertices");
                            if (point3fArray != null && point3fArray.length >= 3 && point3fArray[0] != null && point3fArray[1] != null) {
                                if (point3fArray[2] == null) break;
                                tuple4f = new Point4f();
                                Measure.getPlaneThroughPoints(point3fArray[0], point3fArray[1], point3fArray[2], new Vector3f(), vector3f, vector3f2, (Point4f)tuple4f);
                                break;
                            }
                            break block28;
                        }
                        case 23: {
                            this.setShapeProperty(23, "thisID", string);
                            tuple4f = (Point4f)this.getShapeProperty(23, "plane");
                        }
                    }
                    break;
                }
                case 1112541205: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("x=?", null);
                    }
                    tuple4f = new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541206: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("y=?", null);
                    }
                    tuple4f = new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541207: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("z=?", null);
                    }
                    tuple4f = new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                    break;
                }
                case 4: 
                case 0x40000000: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    break;
                }
                case 0x10000A: {
                    if (!this.isPoint3f(n)) {
                        tuple4f = this.getPoint4f(n);
                        break;
                    }
                }
                case 10: 
                case 0x100001: {
                    Point3f point3f = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f point3f2 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f point3f3 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    Vector3f vector3f3 = new Vector3f();
                    float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f3, vector3f, vector3f2);
                    tuple4f = new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                    if (this.isSyntaxCheck || !Logger.debugging) break;
                    Logger.debug("points: " + point3f + point3f2 + point3f3 + " defined plane: " + tuple4f);
                }
            }
        }
        if (tuple4f == null) {
            this.planeExpected();
        }
        if (bl) {
            tuple4f.scale(-1.0f);
        }
        return tuple4f;
    }

    private Point4f hklParameter(int n) throws ScriptException {
        Point3f point3f;
        Point4f point4f;
        if (!this.isSyntaxCheck && this.viewer.getCurrentUnitCell() == null) {
            this.error(33);
        }
        if ((point4f = this.getHklPlane(point3f = (Point3f)this.getPointOrPlane(n, false, true, false, true, 3, 3))) == null) {
            this.error(3);
        }
        if (!this.isSyntaxCheck && Logger.debugging) {
            Logger.info("defined plane: " + point4f);
        }
        return point4f;
    }

    protected Point4f getHklPlane(Point3f point3f) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f2 = new Point3f(point3f.x == 0.0f ? 1.0f : 1.0f / point3f.x, 0.0f, 0.0f);
        Point3f point3f3 = new Point3f(0.0f, point3f.y == 0.0f ? 1.0f : 1.0f / point3f.y, 0.0f);
        Point3f point3f4 = new Point3f(0.0f, 0.0f, point3f.z == 0.0f ? 1.0f : 1.0f / point3f.z);
        if (point3f.x == 0.0f && point3f.y == 0.0f && point3f.z == 0.0f) {
            return null;
        }
        if (point3f.x == 0.0f && point3f.y == 0.0f) {
            point3f2.set(1.0f, 0.0f, point3f4.z);
            point3f3.set(0.0f, 1.0f, point3f4.z);
        } else if (point3f.y == 0.0f && point3f.z == 0.0f) {
            point3f3.set(point3f2.x, 0.0f, 1.0f);
            point3f4.set(point3f2.x, 1.0f, 0.0f);
        } else if (point3f.z == 0.0f && point3f.x == 0.0f) {
            point3f4.set(0.0f, point3f3.y, 1.0f);
            point3f2.set(1.0f, point3f3.y, 0.0f);
        } else if (point3f.x == 0.0f) {
            point3f2.set(1.0f, point3f3.y, 0.0f);
        } else if (point3f.y == 0.0f) {
            point3f3.set(0.0f, 1.0f, point3f4.z);
        } else if (point3f.z == 0.0f) {
            point3f4.set(point3f2.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(point3f2, false);
        this.viewer.toCartesian(point3f3, false);
        this.viewer.toCartesian(point3f4, false);
        Vector3f vector3f3 = new Vector3f();
        float f = Measure.getNormalThroughPoints(point3f2, point3f3, point3f4, vector3f3, vector3f, vector3f2);
        return new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
    }

    private int getMadParameter() throws ScriptException {
        int n = 1;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                n = 0;
                break;
            }
            case 2: {
                int n2 = this.intParameter(1, 0, 750);
                n = n2 * 4 * 2;
                break;
            }
            case 3: {
                n = (int)(this.floatParameter(1, -3.0f, 3.0f) * 1000.0f * 2.0f);
                if (n >= 0) break;
                this.restrictSelected(false, false);
                n = -n;
                break;
            }
            default: {
                this.error(6);
            }
        }
        return n;
    }

    private int getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.statementLength) {
            return 1;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 0x40000066: {
                return -1;
            }
            case 2: {
                return this.intParameter(n, -1, 19);
            }
            case 3: {
                float f = this.floatParameter(n, 0.0f, 2.0f);
                return (int)(f * 1000.0f * 2.0f);
            }
        }
        this.error(7, "\"DOTTED\"");
        return 0;
    }

    private boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x22000022 || n2 == 1073742195 || n2 == 0x10100040 || n2 == 7 || n2 == 8 || this.isPoint3f(n) || (n2 == 4 || Token.tokAttr(n2, 0x40000000)) && ColorUtil.getArgbFromString((String)this.statement[n].value) != 0;
    }

    private int getArgbParam(int n) throws ScriptException {
        return this.getArgbParam(n, false);
    }

    private int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParam(n, bl);
        this.checkLast(this.iToken);
        return n2;
    }

    private int getArgbParam(int n, boolean bl) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                default: {
                    if (!Token.tokAttr(this.theTok, 0x40000000)) break;
                }
                case 4: 
                case 0x22000022: {
                    return ColorUtil.getArgbFromString(this.parameterAsString(n));
                }
                case 1073742195: {
                    return this.getColorTriad(n + 2);
                }
                case 0x10100040: {
                    return this.getColorTriad(++n);
                }
                case 7: {
                    float[] fArray = ScriptVariable.flistValue(this.theToken, 3);
                    if (fArray == null || fArray.length == 3) break;
                    point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
                    break;
                }
                case 8: {
                    point3f = (Point3f)this.theToken.value;
                    break;
                }
                case 0x10000A: {
                    point3f = this.getPoint3f(n, false);
                    break;
                }
                case 0x10000B: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        if (point3f == null) {
            this.error(8);
        }
        return ColorUtil.colorPtToInt(point3f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColorTriad(int n) throws ScriptException {
        Point3f point3f;
        String string;
        int n2;
        block22: {
            float[] fArray = new float[3];
            n2 = 0;
            string = "";
            this.getToken(n);
            point3f = null;
            float f = 0.0f;
            switch (this.theTok) {
                case 2: 
                case 3: 
                case 1048614: {
                    break;
                }
                case 8: {
                    point3f = (Point3f)this.theToken.value;
                    break block22;
                }
                case 0x40000000: {
                    string = this.parameterAsString(n);
                    break block22;
                }
                default: {
                    this.error(4);
                    break block22;
                }
            }
            while (n < this.statementLength) {
                block23: {
                    switch (this.getToken((int)n).tok) {
                        case 0x10100030: {
                            break block23;
                        }
                        case 0x40000000: {
                            if (n2 != 1 || fArray[0] != 0.0f) {
                                this.error(4);
                            }
                            string = "0" + this.parameterAsString(n);
                            break block22;
                        }
                        case 3: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.floatParameter(n);
                            break;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.theToken.intValue;
                            break;
                        }
                        case 1048614: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10100041: {
                            if (n2 != 3) {
                                this.error(4);
                            }
                            --n;
                            point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
                            break block22;
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    fArray[n2++] = f;
                }
                ++n;
            }
            this.error(4);
        }
        if (this.getToken((int)(++n)).tok != 0x10100041) {
            this.error(4);
        }
        if (point3f != null) {
            return ColorUtil.colorPtToInt(point3f);
        }
        n2 = ColorUtil.getArgbFromString("[" + string + "]");
        if (n2 == 0) {
            this.error(4);
        }
        return n2;
    }

    private boolean isPoint3f(int n) {
        boolean bl = this.tokAt(n) == 8;
        if (bl || this.tokAt(n) == 9 || this.isFloatParameter(n + 1) && this.isFloatParameter(n + 2) && this.isFloatParameter(n + 3) && this.isFloatParameter(n + 4)) {
            return bl;
        }
        this.ignoreError = true;
        int n2 = this.iToken;
        bl = true;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        this.iToken = n2;
        return bl;
    }

    private Point3f getPoint3f(int n, boolean bl) throws ScriptException {
        return (Point3f)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    private Point4f getPoint4f(int n) throws ScriptException {
        return (Point4f)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 8) {
            if (n2 <= 3 && n3 >= 3) {
                return this.getToken((int)n).value;
            }
            this.error(22);
        }
        if (this.tokAt(n) == 9) {
            if (n2 <= 4 && n3 >= 4) {
                return this.getToken((int)n).value;
            }
            this.error(22);
        }
        int n5 = 1;
        block9: for (int i = n; i < this.statement.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000A: 
                case 0x10100030: 
                case 0x10100060: 
                case 0x10100080: {
                    continue block9;
                }
                case 0x10000E: {
                    break block9;
                }
                case 0x101000A0: {
                    n5 = -1;
                    continue block9;
                }
                case 1048615: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block9;
                }
                case 2: 
                case 1048614: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block9;
                }
                case 0x100022: 
                case 0x101000B0: {
                    if (!bl2) {
                        this.error(22);
                    }
                    if (this.theTok == 0x101000B0) {
                        this.getToken(++i);
                    }
                    if (--n4 < 0 || bl) {
                        this.error(22);
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else if (this.theToken.value instanceof Float) {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block9;
                }
                case 3: 
                case 1048611: {
                    if (bl) {
                        this.error(22);
                    }
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block9;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.error(22);
        }
        if (n4 == 3) {
            Point3f point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3) {
                this.fractionalPoint = new Point3f(point3f);
                if (!this.isSyntaxCheck) {
                    this.viewer.toCartesian(point3f, !this.viewer.getFractionalRelative());
                }
            }
            return point3f;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.error(22);
            }
            Point4f point4f = new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
            return point4f;
        }
        return fArray;
    }

    private Point3f xypParameter(int n) throws ScriptException {
        boolean bl;
        int n2 = this.tokAt(n);
        if (n2 == 1073742195) {
            n2 = this.tokAt(++n);
        }
        if (n2 != 0x10100040 || !this.isFloatParameter(++n)) {
            return null;
        }
        Point3f point3f = new Point3f();
        point3f.x = this.floatParameter(n);
        if (this.tokAt(++n) == 0x10100030) {
            ++n;
        }
        if (!this.isFloatParameter(n)) {
            return null;
        }
        point3f.y = this.floatParameter(n);
        boolean bl2 = bl = this.tokAt(++n) == 269484210;
        if (bl) {
            ++n;
        }
        if (this.tokAt(n) != 0x10100041) {
            return null;
        }
        this.iToken = n;
        point3f.z = (float)(bl ? -1 : 1) * Float.MAX_VALUE;
        return point3f;
    }

    private boolean isCommandDisplayable(int n) {
        if (n >= this.aatoken.length || n >= this.pcEnd || this.aatoken[n] == null) {
            return false;
        }
        return this.lineIndices[n][1] > this.lineIndices[n][0];
    }

    private boolean checkContinue() {
        if (this.interruptExecution) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.viewer.scriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        if (Logger.debugging) {
            Logger.info("script execution paused at command " + (this.pc + 1) + " level " + this.scriptLevel + ": " + this.thisCommand);
        }
        try {
            this.refresh();
            while (this.executionPaused) {
                this.viewer.popHoldRepaint("pause");
                Thread.sleep(100L);
                String string = this.viewer.getInterruptScript();
                if (string != "") {
                    this.resumePausedExecution();
                    this.setErrorMessage(null);
                    ScriptContext scriptContext = this.getScriptContext();
                    --this.pc;
                    try {
                        this.runScript(string);
                    }
                    catch (Exception exception) {
                        this.setErrorMessage("" + exception);
                    }
                    catch (Error error) {
                        this.setErrorMessage("" + error);
                    }
                    if (this.error) {
                        this.scriptStatusOrBuffer(this.errorMessage);
                        this.setErrorMessage(null);
                    }
                    this.restoreScriptContext(scriptContext, true, false, false);
                    this.pauseExecution(false);
                }
                this.viewer.pushHoldRepaint("pause");
            }
            if (!(this.isSyntaxCheck || this.interruptExecution || this.executionStepping)) {
                this.viewer.scriptStatus("script execution " + (this.error || this.interruptExecution ? "interrupted" : "resumed"));
            }
        }
        catch (Exception exception) {
            this.viewer.pushHoldRepaint("pause");
        }
        Logger.debug("script execution resumed");
        return !this.error && !this.interruptExecution;
    }

    private void instructionDispatchLoop(boolean bl) throws ScriptException {
        long l = 0L;
        this.vProcess = null;
        boolean bl2 = false;
        if (this.shapeManager == null) {
            this.shapeManager = this.viewer.getShapeManager();
        }
        this.logMessages = false;
        this.debugScript = false;
        if (!this.isSyntaxCheck) {
            this.setDebugging();
        }
        if (this.logMessages) {
            l = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + l);
            this.viewer.scriptStatus(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        String string = "";
        if (this.aatoken == null) {
            return;
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd && (this.isSyntaxCheck || this.checkContinue()) && this.lineNumbers[this.pc] <= this.lineEnd) {
            block113: {
                block116: {
                    block115: {
                        block114: {
                            block112: {
                                String string2;
                                Token token = this.theToken = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                                if (!(this.historyDisabled || this.isSyntaxCheck || this.scriptLevel > this.commandHistoryLevelMax || this.tQuiet)) {
                                    string2 = this.getCommand(this.pc, true, true);
                                    if (!(this.theToken == null || string2.length() <= 0 || string2.equals(string) || this.theToken.tok != 135368713 && this.theToken.tok != 102436 && Token.tokAttr(this.theToken.tok, 102400))) {
                                        string = string2;
                                        this.viewer.addCommand(string);
                                    }
                                }
                                if (!this.isSyntaxCheck && (string2 = this.viewer.getInterruptScript()) != "") {
                                    this.runScript(string2);
                                }
                                if (this.setStatement(this.pc)) break block112;
                                Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                                break block113;
                            }
                            this.thisCommand = this.getCommand(this.pc, false, true);
                            this.fullCommand = this.thisCommand + this.getNextComment();
                            this.getToken(0);
                            this.iToken = 0;
                            if (bl || !this.isSyntaxCheck) {
                                int n = this.viewer.getScriptDelay();
                                if (bl || n > 0 && this.scriptLevel > 0) {
                                    if (n > 0) {
                                        this.delay(-((long)n));
                                    }
                                    this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                                }
                            }
                            if (this.vProcess == null || this.theTok == 0x119009 && this.statementLength >= 2 && this.statement[1].tok == 102439) break block114;
                            this.vProcess.add(this.statement);
                            break block113;
                        }
                        if (!this.isSyntaxCheck) break block115;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.statementLength != 1 || this.statement[0].tok == 135368713 || this.statement[0].tok == 102436) break block116;
                        break block113;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.scriptLevel == 0 && this.viewer.logCommands()) {
                        this.viewer.log(this.thisCommand);
                    }
                    if (this.logMessages && this.theToken != null) {
                        Logger.debug(this.theToken.toString());
                    }
                }
                if (this.theToken != null) {
                    if (Token.tokAttr(this.theToken.tok, 135168)) {
                        this.processShapeCommand(this.theToken.tok);
                    } else {
                        switch (this.theToken.tok) {
                            case 0: {
                                String string3;
                                if (this.isSyntaxCheck || !this.viewer.getMessageStyleChime() || (string3 = (String)this.theToken.value) == null) break;
                                if (this.outputBuffer == null) {
                                    this.viewer.showMessage(string3);
                                }
                                this.scriptStatusOrBuffer(string3);
                                break;
                            }
                            case 266280: {
                                this.pushContext((ContextToken)this.theToken);
                                break;
                            }
                            case 266278: {
                                this.popContext(true, false);
                                break;
                            }
                            case 0x10100022: {
                                break;
                            }
                            case 20500: 
                            case 528410: {
                                if (this.viewer.isHeadless()) break;
                            }
                            case 102402: 
                            case 102406: 
                            case 102407: 
                            case 102408: 
                            case 102410: 
                            case 102411: 
                            case 102412: 
                            case 102413: 
                            case 102439: 
                            case 364547: 
                            case 364548: 
                            case 0x119009: 
                            case 135369224: 
                            case 135369225: {
                                bl2 = this.flowControl(this.theToken.tok, bl2);
                                break;
                            }
                            case 4097: {
                                this.animation();
                                break;
                            }
                            case 4098: {
                                this.assign();
                                break;
                            }
                            case 1610616835: {
                                this.background(1);
                                break;
                            }
                            case 4100: {
                                this.bind();
                                break;
                            }
                            case 4101: {
                                this.bondorder();
                                break;
                            }
                            case 4102: {
                                this.calculate();
                                break;
                            }
                            case 1069064: {
                                this.cd();
                                break;
                            }
                            case 12289: {
                                this.center(1);
                                break;
                            }
                            case 4105: {
                                this.centerAt();
                                break;
                            }
                            case 1766856708: {
                                this.color();
                                break;
                            }
                            case 135270405: {
                                this.compare();
                                break;
                            }
                            case 1095766022: {
                                this.configuration();
                                break;
                            }
                            case 4106: {
                                this.connect(1);
                                break;
                            }
                            case 528395: {
                                this.console();
                                break;
                            }
                            case 135270407: {
                                this.data();
                                break;
                            }
                            case 1060866: {
                                this.define();
                                break;
                            }
                            case 528397: {
                                this.delay();
                                break;
                            }
                            case 12291: {
                                this.delete();
                                break;
                            }
                            case 554176526: {
                                this.slab(true);
                                break;
                            }
                            case 1610625028: {
                                this.display(true);
                                break;
                            }
                            case 266255: 
                            case 266281: {
                                if (this.isSyntaxCheck) break;
                                if (this.pc > 0 && this.theToken.tok == 266255) {
                                    this.viewer.clearScriptQueue();
                                }
                                this.interruptExecution = this.pc > 0 || !this.viewer.usingScriptQueue();
                                break;
                            }
                            case 266256: {
                                if (this.isSyntaxCheck) {
                                    return;
                                }
                                this.viewer.exitJmol();
                                break;
                            }
                            case 1229984263: {
                                this.file();
                                break;
                            }
                            case 1060869: {
                                this.fixed();
                                break;
                            }
                            case 4114: {
                                this.font(-1, 0.0f);
                                break;
                            }
                            case 4115: 
                            case 1095766028: {
                                this.frame(1);
                                break;
                            }
                            case 102436: 
                            case 135368713: 
                            case 0x40000000: {
                                this.function();
                                break;
                            }
                            case 135270410: {
                                this.getProperty();
                                break;
                            }
                            case 20482: {
                                this.help();
                                break;
                            }
                            case 12294: {
                                this.display(false);
                                break;
                            }
                            case 1612189718: {
                                this.hbond();
                                break;
                            }
                            case 1610616855: {
                                this.history(1);
                                break;
                            }
                            case 544771: {
                                this.hover();
                                break;
                            }
                            case 266264: {
                                if (this.isSyntaxCheck) break;
                                this.viewer.initialize(!this.isStateScript);
                                break;
                            }
                            case 4121: {
                                this.invertSelected();
                                break;
                            }
                            case 135287308: {
                                this.script(135287308, null, false);
                                break;
                            }
                            case 135271426: {
                                this.load();
                                break;
                            }
                            case 36869: {
                                this.log();
                                break;
                            }
                            case 0x10101C: {
                                this.mapProperty();
                                break;
                            }
                            case 20485: {
                                this.message();
                                break;
                            }
                            case 4126: {
                                this.minimize();
                                break;
                            }
                            case 4128: {
                                this.move();
                                break;
                            }
                            case 4130: {
                                this.moveto();
                                break;
                            }
                            case 4131: {
                                this.navigate();
                                break;
                            }
                            case 20487: {
                                this.pause();
                                break;
                            }
                            case 4133: 
                            case 1052714: 
                            case 0x8101011: {
                                this.plot(this.statement);
                                break;
                            }
                            case 36865: {
                                this.print();
                                break;
                            }
                            case 135304707: {
                                this.prompt();
                                break;
                            }
                            case 4139: 
                            case 4165: {
                                this.undoRedoMove();
                                break;
                            }
                            case 266284: {
                                this.refresh();
                                break;
                            }
                            case 4141: {
                                this.reset();
                                break;
                            }
                            case 4142: {
                                this.restore();
                                break;
                            }
                            case 12295: {
                                this.restrict();
                                break;
                            }
                            case 266287: {
                                if (this.isSyntaxCheck) break;
                                this.resumePausedExecution();
                                break;
                            }
                            case 36866: {
                                this.returnCmd(null);
                                break;
                            }
                            case 528432: {
                                this.rotate(false, false);
                                break;
                            }
                            case 4145: {
                                this.rotate(false, true);
                                break;
                            }
                            case 4146: {
                                this.save();
                                break;
                            }
                            case 1085443: {
                                this.set();
                                break;
                            }
                            case 135271429: {
                                this.script(135271429, null, bl);
                                break;
                            }
                            case 135280132: {
                                this.select(1);
                                break;
                            }
                            case 1611141171: {
                                this.selectionHalo(1);
                                break;
                            }
                            case 4148: {
                                this.show();
                                break;
                            }
                            case 554176565: {
                                this.slab(false);
                                break;
                            }
                            case 1611141175: {
                                this.rotate(true, false);
                                break;
                            }
                            case 1611141176: {
                                this.ssbond();
                                break;
                            }
                            case 266298: {
                                if (!this.pause()) break;
                                this.stepPausedExecution();
                                break;
                            }
                            case 528443: {
                                this.stereo();
                                break;
                            }
                            case 1641025539: {
                                this.structure();
                                break;
                            }
                            case 0x303008: {
                                this.subset();
                                break;
                            }
                            case 4156: {
                                this.sync();
                                break;
                            }
                            case 536875070: {
                                this.timeout(1);
                                break;
                            }
                            case 4160: {
                                this.translate(false);
                                break;
                            }
                            case 4162: {
                                this.translate(true);
                                break;
                            }
                            case 4164: {
                                this.unbind();
                                break;
                            }
                            case 4166: {
                                this.vibration();
                                break;
                            }
                            case 135270421: {
                                this.write(null);
                                break;
                            }
                            case 1060873: {
                                this.zap(true);
                                break;
                            }
                            case 4168: {
                                this.zoom(false);
                                break;
                            }
                            case 4170: {
                                this.zoom(true);
                                break;
                            }
                            default: {
                                this.error(47);
                            }
                        }
                    }
                    this.setCursorWait(false);
                    if (this.executionStepping) {
                        this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                    }
                }
            }
            ++this.pc;
        }
    }

    private void setCursorWait(boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(bl ? 4 : 0);
        }
    }

    private void processShapeCommand(int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1611272194: {
                n2 = 30;
                break;
            }
            case 1115297793: {
                n2 = 9;
                break;
            }
            case 1679429641: {
                n2 = 31;
                break;
            }
            case 1113200642: {
                n2 = 11;
                break;
            }
            case 135402505: {
                n2 = 24;
                break;
            }
            case 135174: {
                n2 = 17;
                break;
            }
            case 1113198595: {
                n2 = 16;
                break;
            }
            case 135176: {
                n2 = 22;
                break;
            }
            case 537022465: {
                n2 = 29;
                break;
            }
            case 1113198596: {
                n2 = 20;
                break;
            }
            case 1611272202: {
                n2 = 34;
                break;
            }
            case 1113198597: {
                n2 = 19;
                break;
            }
            case 1113200646: {
                n2 = 8;
                break;
            }
            case 135180: {
                n2 = 23;
                break;
            }
            case 1826248715: {
                n2 = 5;
                break;
            }
            case 135182: {
                n2 = 25;
                break;
            }
            case 0x20021010: 
            case 1746538509: {
                n2 = 6;
                break;
            }
            case 1113200647: {
                n2 = 13;
                break;
            }
            case 0x121012: {
                n2 = 26;
                break;
            }
            case 135190: {
                n2 = 28;
                break;
            }
            case 135188: {
                n2 = 27;
                break;
            }
            case 135192: {
                n2 = 21;
                break;
            }
            case 1113200649: {
                n2 = 14;
                break;
            }
            case 1113200650: {
                n2 = 15;
                break;
            }
            case 1113200651: {
                n2 = 0;
                break;
            }
            case 1113200652: {
                n2 = 7;
                break;
            }
            case 1650071565: {
                n2 = 12;
                break;
            }
            case 0x1A101A: {
                n2 = 4;
                break;
            }
            case 1113200654: {
                n2 = 10;
                break;
            }
            case 1614417948: {
                n2 = 32;
                break;
            }
            case 135198: {
                n2 = 18;
                break;
            }
            case 659488: {
                n2 = 1;
                break;
            }
            default: {
                this.error(47);
            }
        }
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                this.proteinShape(n2);
                return;
            }
            case 1113198595: 
            case 1113198597: {
                this.dots(n2);
                return;
            }
            case 1113198596: {
                this.ellipsoid();
                return;
            }
            case 1113200646: 
            case 1113200651: 
            case 1113200652: {
                this.setAtomShapeSize(n2, n == 1113200646 ? -1.0f : 1.0f);
                return;
            }
            case 1826248715: {
                this.label(1);
                return;
            }
            case 135182: {
                this.lcaoCartoon();
                return;
            }
            case 135192: {
                this.polyhedra();
                return;
            }
            case 0x1A101A: {
                this.struts();
                return;
            }
            case 135198: {
                this.vector();
                return;
            }
            case 659488: {
                this.wireframe();
                return;
            }
        }
        switch (n) {
            case 1611272194: {
                this.axes(1);
                return;
            }
            case 1679429641: {
                this.boundbox(1);
                return;
            }
            case 135402505: {
                this.contact();
                return;
            }
            case 135174: {
                this.dipole();
                return;
            }
            case 135176: {
                this.draw();
                return;
            }
            case 537022465: {
                this.echo(1, false);
                return;
            }
            case 1611272202: {
                this.frank(1);
                return;
            }
            case 135180: 
            case 135188: 
            case 135190: {
                this.isosurface(n2);
                return;
            }
            case 0x20021010: 
            case 1746538509: {
                this.measure();
                return;
            }
            case 0x121012: {
                this.mo(false);
                return;
            }
            case 1614417948: {
                this.unitcell(1);
                return;
            }
        }
    }

    private boolean flowControl(int n, boolean bl) throws ScriptException {
        int n2;
        switch (n) {
            case 20500: {
                this.gotoCmd(this.parameterAsString(this.checkLast(1)));
                return bl;
            }
            case 528410: {
                this.delay();
                if (!this.isSyntaxCheck) {
                    this.pc = -1;
                }
                return bl;
            }
        }
        boolean bl2 = n2 < 0 && !this.isSyntaxCheck;
        boolean bl3 = true;
        int n3 = 0;
        switch (n) {
            case 102412: {
                ContextToken contextToken = (ContextToken)this.theToken;
                this.pushContext(contextToken);
                if (!bl2 && contextToken.name0 != null) {
                    this.contextVariables.put(contextToken.name0, contextToken.contextVariables.get(contextToken.name0));
                }
                bl3 = !bl2;
                break;
            }
            case 102439: {
                this.pushContext((ContextToken)this.theToken);
                bl3 = true;
                bl2 = true;
                this.addProcess(this.pc, n2, true);
                break;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                switch (bl2 ? 0 : this.switchCmd((ContextToken)this.theToken, n)) {
                    case 0: {
                        n3 = -n3;
                        bl3 = false;
                        break;
                    }
                    case -1: {
                        bl3 = false;
                        break;
                    }
                }
                this.aatoken[this.pc][0].intValue = Math.abs(n2);
                this.theToken = this.aatoken[Math.abs(n2)][0];
                if (this.theToken.tok == 0x119009) break;
                this.theToken.intValue = n3;
                break;
            }
            case 102402: 
            case 135369225: {
                boolean bl4 = bl3 = !bl2 && this.ifCmd();
                if (this.isSyntaxCheck) break;
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                this.aatoken[Math.abs((int)n2)][0].intValue = n3 = bl2 || bl3 ? -n3 : n3;
                if (n != 102412) break;
                this.aatoken[this.pc][0].intValue = -n2;
                break;
            }
            case 364547: {
                this.checkLength(1);
                if (n2 >= 0 || this.isSyntaxCheck) break;
                this.pc = -n2 - 1;
                break;
            }
            case 364548: {
                this.checkLength(1);
                break;
            }
            case 102406: {
                if (!bl) {
                    this.pushContext((ContextToken)this.theToken);
                }
                bl = false;
                if (this.ifCmd() || this.isSyntaxCheck) break;
                this.pc = n2;
                this.popContext(true, false);
                break;
            }
            case 102407: {
                if (!this.isSyntaxCheck) {
                    this.breakCmd(n2);
                    break;
                }
                if (this.statementLength == 1) break;
                int n4 = this.intParameter(this.checkLast(1));
                if (this.isSyntaxCheck) break;
                for (int i = 0; i < n4; ++i) {
                    this.popContext(true, false);
                }
                break;
            }
            case 102408: {
                bl = true;
                if (!this.isSyntaxCheck) {
                    this.pc = n2 - 1;
                }
                if (this.statementLength <= 1) break;
                this.intParameter(this.checkLast(1));
                break;
            }
            case 135369224: {
                String string;
                Object object;
                List<ScriptVariable> list;
                Token token = this.theToken;
                int[] nArray = new int[2];
                int n5 = 0;
                Object object2 = null;
                int n6 = 0;
                block38: for (int i = 1; i < this.statementLength && n5 < 2; ++i) {
                    switch (this.tokAt(i)) {
                        case 0x10000F: {
                            if (n6 > 0) {
                                --n6;
                                continue block38;
                            }
                            nArray[n5++] = i;
                            continue block38;
                        }
                        case 1073741980: {
                            n6 -= 2;
                            if (this.tokAt(++i) == 0x100001 || this.tokAt(i) == 10) {
                                object2 = this.atomExpression(i);
                                if (this.isBondSet) {
                                    object2 = new Bond.BondSet((BitSet)object2);
                                }
                            } else {
                                list = this.parameterExpressionList(-i, 1, false);
                                if (list == null || list.size() < 1) {
                                    this.error(22);
                                }
                                object = list.get(0);
                                switch (((ScriptVariable)object).tok) {
                                    case 10: {
                                        object2 = ScriptVariable.getBitSet((ScriptVariable)object, false);
                                        break;
                                    }
                                    case 7: {
                                        object2 = ((ScriptVariable)object).getList();
                                        break;
                                    }
                                    default: {
                                        this.error(22);
                                    }
                                }
                            }
                            i = this.iToken;
                            continue block38;
                        }
                        case 135280132: {
                            n6 += 2;
                        }
                    }
                }
                if (bl) {
                    n5 = object2 == null ? nArray[1] + 1 : 2;
                } else {
                    this.pushContext((ContextToken)token);
                    n5 = 2;
                }
                if (this.tokAt(n5) == 36868) {
                    ++n5;
                }
                int n7 = n6 = (string = this.parameterAsString(n5)).equals("--") || string.equals("++") ? 1 : 0;
                if (n6 != 0) {
                    string = this.parameterAsString(++n5);
                }
                list = null;
                if (Token.tokAttr(this.tokAt(n5), 0x40000000) || (list = this.getContextVariableAsVariable(string)) != null) {
                    if (object2 == null && n6 == 0 && this.getToken((int)(++n5)).tok != 269484436) {
                        this.error(22);
                    }
                    if (object2 == null) {
                        if (n6 != 0) {
                            n5 -= 2;
                        }
                        this.setVariable(++n5, this.statementLength - 1, string, 0);
                    } else {
                        bl3 = true;
                        object = string + "_incr";
                        if (list == null) {
                            list = this.getContextVariableAsVariable((String)object);
                        }
                        if (list == null) {
                            if (string.startsWith("_")) {
                                this.error(22);
                            }
                            list = this.viewer.getOrSetNewVariable((String)object, true);
                        }
                        if (!bl || ((ScriptVariable)((Object)list)).tok != 10 && ((ScriptVariable)((Object)list)).tok != 7 || ((ScriptVariable)((Object)list)).intValue == Integer.MAX_VALUE) {
                            if (bl) {
                                bl3 = false;
                            } else {
                                ((ScriptVariable)((Object)list)).set(ScriptVariable.getVariable(object2), false);
                                ((ScriptVariable)((Object)list)).intValue = 1;
                            }
                        } else {
                            ++((ScriptVariable)((Object)list)).intValue;
                        }
                        boolean bl5 = bl3 && (object2 instanceof BitSet ? ScriptVariable.bsSelect((ScriptVariable)((Object)list)).cardinality() == 1 : ((ScriptVariable)((Object)list)).intValue <= ((ScriptVariable)((Object)list)).getList().size()) ? true : (bl3 = false);
                        if (bl3) {
                            list = ScriptVariable.selectItem((ScriptVariable)((Object)list));
                            ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
                            if (scriptVariable == null) {
                                scriptVariable = this.viewer.getOrSetNewVariable(string, true);
                            }
                            scriptVariable.set((ScriptVariable)((Object)list), false);
                        }
                    }
                }
                if (object2 == null) {
                    bl3 = this.parameterExpressionBoolean(nArray[0] + 1, nArray[1]);
                }
                ++n2;
                if (!bl3) {
                    this.popContext(true, false);
                }
                bl = false;
                break;
            }
            case 0x119009: {
                switch (this.getToken((int)this.checkLast((int)1)).tok) {
                    case 364558: {
                        int n8;
                        ScriptFunction scriptFunction = (ScriptFunction)this.getToken((int)1).value;
                        if (this.isSyntaxCheck) {
                            return false;
                        }
                        Map map = (Map)this.runFunction((ScriptFunction)scriptFunction, (String)"try", null, null, (boolean)true, (boolean)true).value;
                        ScriptVariable scriptVariable = (ScriptVariable)map.get("_tryret");
                        if (scriptVariable.value != null || scriptVariable.intValue != Integer.MAX_VALUE) {
                            this.returnCmd(scriptVariable);
                            return false;
                        }
                        String string = (String)((ScriptVariable)map.get((Object)"_errorval")).value;
                        if (string.length() == 0 && (n8 = ((ScriptVariable)map.get((Object)"_breakval")).intValue) != Integer.MAX_VALUE) {
                            this.breakCmd(this.pc - n8);
                            return false;
                        }
                        if (this.pc + 1 < this.aatoken.length && this.aatoken[this.pc + 1][0].tok == 102412) {
                            ContextToken contextToken = (ContextToken)this.aatoken[this.pc + 1][0];
                            if (contextToken.contextVariables != null && contextToken.name0 != null) {
                                contextToken.contextVariables.put(contextToken.name0, ScriptVariable.getVariable(string));
                            }
                            contextToken.intValue = (string.length() > 0 ? 1 : -1) * Math.abs(contextToken.intValue);
                        }
                        return false;
                    }
                    case 102412: {
                        this.popContext(true, false);
                        break;
                    }
                    case 102436: 
                    case 135368713: {
                        this.viewer.addFunction((ScriptFunction)this.theToken.value);
                        return bl;
                    }
                    case 102439: {
                        this.addProcess(n2, this.pc, false);
                        this.popContext(true, false);
                        break;
                    }
                    case 102410: {
                        if (n2 <= 0 || this.switchCmd((ContextToken)this.aatoken[n2][0], 0) != -1) break;
                        for (n2 = this.statement[0].intValue; n2 < this.pc && ((n = this.aatoken[n2][0].tok) == 102413 || n == 102411); ++n2) {
                        }
                        boolean bl6 = bl3 = this.pc == n2;
                    }
                }
                if (bl3) {
                    bl3 = this.theTok == 102412 || this.theTok == 102439 || this.theTok == 135369225 || this.theTok == 102410;
                }
                boolean bl7 = bl = this.theTok == 135369224 || this.theTok == 102406;
            }
        }
        if (!bl3 && !this.isSyntaxCheck) {
            this.pc = Math.abs(n2) - 1;
        }
        return bl;
    }

    private void gotoCmd(String string) throws ScriptException {
        int n;
        int n2;
        int n3 = string == null ? this.aatoken.length - 1 : -1;
        String string2 = null;
        block11: for (n2 = n3 + 1; n2 < this.aatoken.length; ++n2) {
            Token[] tokenArray = this.aatoken[n2];
            n = tokenArray[0].tok;
            switch (n) {
                case 0: 
                case 20485: {
                    string2 = (String)tokenArray[tokenArray.length - 1].value;
                    if (n != 0) break;
                    string2 = string2.substring(string2.startsWith("#") ? 1 : 2);
                    break;
                }
                default: {
                    continue block11;
                }
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            this.error(22);
        }
        if (string == null) {
            n3 = 0;
        }
        n2 = n3 < this.pc ? 1 : -1;
        int n4 = 0;
        block12: for (n = n3; n != this.pc; n += n2) {
            switch (this.aatoken[n][0].tok) {
                case 102406: 
                case 102412: 
                case 102439: 
                case 266280: 
                case 135369224: {
                    ++n4;
                    continue block12;
                }
                case 266278: {
                    --n4;
                    continue block12;
                }
                case 0x119009: {
                    switch (this.aatoken[n][1].tok) {
                        case 102406: 
                        case 102412: 
                        case 102439: 
                        case 135369224: {
                            --n4;
                        }
                    }
                }
            }
        }
        if (string == null) {
            n3 = Integer.MAX_VALUE;
            while (n4 > 0) {
                this.popContext(false, false);
                --n4;
            }
        }
        if (n4 != 0) {
            this.error(22);
        }
        if (!this.isSyntaxCheck) {
            this.pc = n3 - 1;
        }
    }

    private void breakCmd(int n) {
        if (n < 0) {
            this.getContextVariableAsVariable((String)"_breakval").intValue = -n;
            this.pcEnd = this.pc;
            return;
        }
        this.pc = Math.abs(this.aatoken[n][0].intValue);
        int n2 = this.aatoken[n][0].tok;
        if (n2 == 102411 || n2 == 102413) {
            this.theToken = this.aatoken[this.pc--][0];
            int n3 = Math.abs(this.theToken.intValue);
            if (this.theToken.tok != 0x119009) {
                this.theToken.intValue = -n3;
            }
        } else {
            while (this.thisContext != null && !ScriptCompiler.isBreakableContext(this.thisContext.token.tok)) {
                this.popContext(true, false);
            }
            this.popContext(true, false);
        }
    }

    private void addProcess(int n, int n2, boolean bl) {
        if (this.parallelProcessor == null) {
            return;
        }
        if (bl) {
            this.vProcess = new ArrayList<Token[]>();
        } else {
            Token[][] tokenArrayArray = new Token[n2][];
            for (int i = 0; i < this.vProcess.size(); ++i) {
                tokenArrayArray[i + 1 - n] = this.vProcess.get(i);
            }
            ScriptContext scriptContext = this.getScriptContext();
            scriptContext.aatoken = tokenArrayArray;
            scriptContext.pc = 1 - n;
            scriptContext.pcEnd = n2;
            this.parallelProcessor.addProcess("p" + ++iProcess, scriptContext);
            this.vProcess = null;
        }
    }

    private int switchCmd(ContextToken contextToken, int n) throws ScriptException {
        ScriptVariable scriptVariable;
        if (n == 102410) {
            contextToken.addName("_var");
        }
        if ((scriptVariable = contextToken.contextVariables.get("_var")) == null) {
            return 1;
        }
        if (n == 0) {
            contextToken.contextVariables.remove("_var");
            return -1;
        }
        if (n == 102413) {
            return -1;
        }
        ScriptVariable scriptVariable2 = this.parameterExpressionToken(1);
        if (n == 102411) {
            boolean bl = ScriptVariable.areEqual(scriptVariable, scriptVariable2);
            if (bl) {
                contextToken.contextVariables.remove("_var");
            }
            return bl ? 1 : -1;
        }
        contextToken.contextVariables.put("_var", scriptVariable2);
        return 1;
    }

    private boolean ifCmd() throws ScriptException {
        return this.parameterExpressionBoolean(1, 0);
    }

    private void returnCmd(ScriptVariable scriptVariable) throws ScriptException {
        ScriptVariable scriptVariable2;
        ScriptVariable scriptVariable3 = this.getContextVariableAsVariable("_retval");
        if (scriptVariable3 == null) {
            if (!this.isSyntaxCheck) {
                this.gotoCmd(null);
            }
            return;
        }
        ScriptVariable scriptVariable4 = scriptVariable2 = scriptVariable != null || this.statementLength == 1 ? null : this.parameterExpressionToken(1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (scriptVariable == null) {
            scriptVariable = scriptVariable2 == null ? ScriptVariable.intVariable(0) : scriptVariable2;
        }
        scriptVariable3.value = scriptVariable.value;
        scriptVariable3.intValue = scriptVariable.intValue;
        scriptVariable3.tok = scriptVariable.tok;
        this.gotoCmd(null);
    }

    private void help() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(1).toLowerCase();
        int n = 0;
        if (string.startsWith("mouse") && (n = string.indexOf(" ")) >= 0 && n == string.lastIndexOf(" ")) {
            this.showString(this.viewer.getBindingInfo(string.substring(n + 1)));
            return;
        }
        if (Token.tokAttr(Token.getTokFromName(string), 4096)) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    private void move() throws ScriptException {
        int n;
        if (this.statementLength > 11) {
            this.error(2);
        }
        Vector3f vector3f = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        Vector3f vector3f2 = new Vector3f(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.statementLength == 11 ? this.intParameter(10) : 30;
        if (this.isSyntaxCheck) {
            return;
        }
        this.refresh();
        this.viewer.move(vector3f, f, vector3f2, f2, f3, n);
    }

    private void moveto() throws ScriptException {
        if (this.statementLength == 2 && this.tokAt(1) == 1073742162) {
            if (!this.isSyntaxCheck) {
                this.viewer.stopMotion();
            }
            return;
        }
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            float f = this.floatParameter(1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (f > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(f, null, JmolConstants.axisZ, 0.0f, null, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        Vector3f vector3f = new Vector3f(Float.NaN, 0.0f, 0.0f);
        Point3f point3f = null;
        int n = 1;
        float f = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        float f2 = 90.0f;
        BitSet bitSet = null;
        switch (this.getToken((int)n).tok) {
            case 0x8101011: {
                Quaternion quaternion;
                boolean bl = false;
                if (this.tokAt(++n) == 1073742030) {
                    bl = true;
                    ++n;
                }
                if (this.tokAt(n) == 10 || this.tokAt(n) == 0x100001) {
                    bl = true;
                    point3f = this.centerParameter(n);
                    if (!(this.expressionResult instanceof BitSet)) {
                        this.error(22);
                    }
                    bitSet = (BitSet)this.expressionResult;
                    quaternion = this.isSyntaxCheck ? new Quaternion() : this.viewer.getAtomQuaternion(bitSet.nextSetBit(0));
                } else {
                    quaternion = this.getQuaternionParameter(n);
                }
                n = this.iToken + 1;
                if (quaternion == null) {
                    this.error(22);
                }
                AxisAngle4f axisAngle4f = quaternion.toAxisAngle4f();
                vector3f.set(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
                f2 = (float)(bl ? -1 : 1) * (float)((double)axisAngle4f.angle * 180.0 / Math.PI);
                break;
            }
            case 8: 
            case 9: 
            case 0x10000A: {
                if (this.isPoint3f(n)) {
                    vector3f.set(this.getPoint3f(n, true));
                    n = this.iToken + 1;
                    f2 = this.floatParameter(n++);
                    break;
                }
                Point4f point4f = this.getPoint4f(n);
                n = this.iToken + 1;
                vector3f.set(point4f.x, point4f.y, point4f.z);
                f2 = point4f.x == 0.0f && point4f.y == 0.0f && point4f.z == 0.0f ? Float.NaN : point4f.w;
                break;
            }
            case 1073741954: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                f2 = 0.0f;
                this.checkLength(++n);
                break;
            }
            case 0x40000024: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                f2 = 180.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741996: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073742128: {
                vector3f.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1074790748: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073741871: {
                vector3f.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            default: {
                vector3f = new Vector3f(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f2 = this.floatParameter(n++);
            }
        }
        if (Float.isNaN(vector3f.x) || Float.isNaN(vector3f.y) || Float.isNaN(vector3f.z)) {
            vector3f.set(0.0f, 0.0f, 0.0f);
        } else if (vector3f.length() == 0.0f && f2 == 0.0f) {
            f2 = Float.NaN;
        }
        boolean bl = !this.viewer.isInPosition(vector3f, f2);
        float f3 = this.isFloatParameter(n) ? this.floatParameter(n++) : Float.NaN;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (this.isFloatParameter(n) && !this.isCenterParameter(n)) {
            f4 = this.floatParameter(n++);
            f5 = this.floatParameter(n++);
            if (!bl && Math.abs(f4 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f5 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        if (bitSet == null && n != this.statementLength) {
            point3f = this.centerParameter(n);
            if (this.expressionResult instanceof BitSet) {
                bitSet = (BitSet)this.expressionResult;
            }
            n = this.iToken + 1;
        }
        float f6 = Float.NaN;
        float f7 = this.viewer.getZoomSetting();
        if (point3f != null) {
            if (!bl && (double)point3f.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n)) {
                f6 = this.floatParameter(n++);
            }
            if (!this.isCenterParameter(n)) {
                if ((f6 == 0.0f || Float.isNaN(f6)) && (f3 == 0.0f || Float.isNaN(f3))) {
                    float f8 = Math.abs(this.getZoom(0, n, bitSet, f3 == 0.0f ? 0.0f : f7));
                    n = this.iToken + 1;
                    f3 = f8;
                } else if (!bl && (double)Math.abs(f6 - this.viewer.getRotationRadius()) >= 0.1) {
                    bl = true;
                }
            }
        }
        if (f3 == 0.0f || Float.isNaN(f3)) {
            f3 = 100.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (!bl && Math.abs(f3 - f7) >= 1.0f) {
            bl = true;
        }
        Point3f point3f2 = null;
        float f9 = Float.NaN;
        float f10 = Float.NaN;
        float f11 = Float.NaN;
        if (n != this.statementLength) {
            point3f2 = this.centerParameter(n);
            n = this.iToken + 1;
            if (n != this.statementLength) {
                f9 = this.floatParameter(n++);
                f10 = this.floatParameter(n++);
            }
            if (n != this.statementLength) {
                f11 = this.floatParameter(n++);
            }
        }
        if (n != this.statementLength) {
            this.error(2);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (!bl) {
            f = 0.0f;
        }
        if (f > 0.0f) {
            this.refresh();
        }
        this.viewer.moveTo(f, point3f, vector3f, f2, null, f3, f4, f5, f6, point3f2, f9, f10, f11);
    }

    private void navigate() throws ScriptException {
        if (this.statementLength == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.setObjectMad(30, "axes", 1);
                    this.setShapeProperty(30, "position", new Point3f(50.0f, 50.0f, Float.MAX_VALUE));
                    this.setBooleanProperty("navigationMode", true);
                    this.viewer.setNavOn(this.theTok == 0x10000D);
                    return;
                }
                case 1073742162: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setNavXYZ(0.0f, 0.0f, 0.0f);
                    }
                    return;
                }
                case 8: {
                    break;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.viewer.getNavigationMode()) {
            this.setBooleanProperty("navigationMode", true);
        }
        block27: for (int i = 1; i < this.statementLength; ++i) {
            float f;
            float f2 = f = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (f < 0.0f) {
                this.error(22);
            }
            if (!this.isSyntaxCheck && f > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 8: 
                case 0x10000A: {
                    Point3f point3f = this.getPoint3f(i, true);
                    ++this.iToken;
                    if (this.iToken != this.statementLength) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setNavXYZ(point3f.x, point3f.y, point3f.z);
                    return;
                }
                case 554176526: {
                    float f3 = this.floatParameter(++i);
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.setNavigationDepthPercent(f, f3);
                    continue block27;
                }
                case 12289: {
                    Point3f point3f = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navigate(f, point3f);
                    continue block27;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541205: {
                            vector3f.set(1.0f, 0.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1112541206: {
                            vector3f.set(0.0f, 1.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1112541207: {
                            vector3f.set(0.0f, 0.0f, 1.0f);
                            ++i;
                            break;
                        }
                        case 8: 
                        case 0x10000A: {
                            vector3f.set(this.getPoint3f(i, true));
                            i = this.iToken + 1;
                            break;
                        }
                        case 0x40000000: {
                            this.error(22);
                        }
                    }
                    float f4 = this.floatParameter(i);
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navigate(f, vector3f, f4);
                    continue block27;
                }
                case 4160: {
                    Point3f point3f;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        f5 = this.floatParameter(i);
                        f6 = this.floatParameter(++i);
                    } else {
                        switch (this.tokAt(i)) {
                            case 1112541205: {
                                f5 = this.floatParameter(++i);
                                break;
                            }
                            case 1112541206: {
                                f6 = this.floatParameter(++i);
                                break;
                            }
                            default: {
                                point3f = this.centerParameter(i);
                                i = this.iToken;
                                if (this.isSyntaxCheck) continue block27;
                                this.viewer.navTranslate(f, point3f);
                                continue block27;
                            }
                        }
                    }
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navTranslatePercent(f, f5, f6);
                    continue block27;
                }
                case 0x101000B0: {
                    continue block27;
                }
                case 1113200654: {
                    ArrayList<Point3f[]> arrayList = new ArrayList<Point3f[]>();
                    BitSet bitSet = this.atomExpression(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bitSet, arrayList);
                    int n = arrayList.size();
                    if (n <= 0) continue block27;
                    Point3f[][] point3fArray = new Point3f[n][];
                    for (int j = 0; j < n; ++j) {
                        point3fArray[j] = (Point3f[])arrayList.get(j);
                    }
                    this.viewer.navigate(f, point3fArray);
                    continue block27;
                }
                case 3145756: {
                    if (i != 1) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.navigateSurface(f, this.optParameterAsString(2));
                    continue block27;
                }
                case 0x40000104: {
                    Object object;
                    float[] fArray = null;
                    if (this.getToken((int)(i + 1)).tok == 0x100007) {
                        ++i;
                        object = this.objectNameParameter(++i);
                        if (this.isSyntaxCheck) {
                            return;
                        }
                        this.setShapeProperty(22, "thisID", object);
                        Point3f[] point3fArray = (Point3f[])this.getShapeProperty(22, "vertices");
                        this.refresh();
                        if (point3fArray == null) {
                            this.error(22);
                        }
                        int n = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                        int n2 = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                        if (this.isSyntaxCheck) continue block27;
                        this.viewer.navigate(f, point3fArray, fArray, n, n2);
                        continue block27;
                    }
                    object = new ArrayList();
                    while (this.isCenterParameter(i + 1)) {
                        object.add(this.centerParameter(++i));
                        i = this.iToken;
                    }
                    if (object.size() > 0) {
                        Point3f[] point3fArray = object.toArray(new Point3f[object.size()]);
                        if (this.isSyntaxCheck) continue block27;
                        this.viewer.navigate(f, point3fArray, fArray, 0, Integer.MAX_VALUE);
                        continue block27;
                    }
                }
                default: {
                    this.error(22);
                }
            }
        }
    }

    private void bondorder() throws ScriptException {
        this.checkLength(-3);
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                n = JmolEdge.getBondOrderFromFloat(this.floatParameter(1));
                if (n != 131071) break;
                this.error(22);
                break;
            }
            default: {
                n = ScriptEvaluator.getBondOrderFromString(this.parameterAsString(1));
                if (n == 131071) {
                    this.error(22);
                }
                if (n != 33 || this.tokAt(2) != 3) break;
                n = ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(this.statement[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", n);
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(false);
                break;
            }
            case 0x10000D: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(true);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 0x40000002: {
                string = "absolute";
                break;
            }
            case 96: {
                string = "average";
                break;
            }
            case 1679429641: {
                string = "boundbox";
                break;
            }
            default: {
                this.error(22);
            }
        }
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            point3f.x = this.floatParameter(2);
            point3f.y = this.floatParameter(3);
            point3f.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            point3f = this.centerParameter(2);
            this.checkLast(this.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCenterAt(string, point3f);
        }
    }

    private void stereo() throws ScriptException {
        EnumStereoMode enumStereoMode = EnumStereoMode.DOUBLE;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = null;
        int n = 0;
        block6: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (n > 1) {
                    this.error(2);
                }
                if (n == 0) {
                    nArray = new int[2];
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n] = this.getArgbParam(i);
                if (n++ == 0) {
                    nArray[1] = ~nArray[0];
                }
                i = this.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    this.iToken = 1;
                    this.checkLast(1);
                    this.iToken = 1;
                    continue block6;
                }
                case 0x10000C: {
                    this.iToken = 1;
                    this.checkLast(1);
                    enumStereoMode = EnumStereoMode.NONE;
                    continue block6;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    continue block6;
                }
                case 0x40000000: {
                    if (!bl) {
                        f = 3.0f;
                    }
                    if ((enumStereoMode = EnumStereoMode.getStereoMode(this.parameterAsString(i))) != null) continue block6;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setStereoMode(nArray, enumStereoMode, f);
    }

    private void compare() throws ScriptException {
        BitSet[] bitSetArray;
        int n;
        boolean bl;
        BitSet bitSet;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        float f = Float.NaN;
        Quaternion[] quaternionArray = null;
        Quaternion[] quaternionArray2 = null;
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        ArrayList<BitSet[]> arrayList = null;
        ArrayList<Object[]> arrayList2 = null;
        BitSet bitSet4 = this.tokAt(1) == 0x303008 ? null : this.atomExpression(1);
        BitSet bitSet5 = bitSet = this.tokAt(++this.iToken) == 0x303008 ? null : this.atomExpression(this.iToken);
        if (bitSet4 == null || bitSet == null) {
            this.error(22);
        }
        BitSet bitSet6 = null;
        boolean bl6 = false;
        String string = null;
        BitSet bitSet7 = BitSetUtil.copy(bitSet4);
        bitSet7.or(bitSet);
        boolean bl7 = bl = bitSet7.equals(bitSet4);
        block14: for (n = this.iToken + 1; n < this.statementLength; ++n) {
            switch (this.getToken((int)n).tok) {
                case 4115: {
                    bl7 = true;
                    continue block14;
                }
                case 135267336: {
                    bl6 = true;
                }
                case 135267335: {
                    string = this.stringParameter(++n);
                    continue block14;
                }
                case 2: 
                case 3: {
                    f = Math.abs(this.floatParameter(n));
                    if (!(f > 0.0f)) continue block14;
                    bl5 = true;
                    continue block14;
                }
                case 0x10100030: {
                    continue block14;
                }
                case 0x303008: {
                    bitSet6 = this.atomExpression(++n);
                    n = this.iToken;
                    continue block14;
                }
                case 10: 
                case 0x100001: {
                    if (arrayList2 != null) {
                        this.error(22);
                    }
                    bitSet2 = this.atomExpression(this.iToken);
                    int n2 = bl ? 0 : this.tokAt(this.iToken + 1);
                    BitSet bitSet8 = bitSet3 = n2 == 10 || n2 == 0x100001 ? this.atomExpression(++this.iToken) : BitSetUtil.copy(bitSet2);
                    if (bitSet6 != null) {
                        bitSet2.and(bitSet6);
                        bitSet3.and(bitSet6);
                    }
                    bitSet3.and(bitSet);
                    if (arrayList == null) {
                        arrayList = new ArrayList<BitSet[]>();
                    }
                    arrayList.add(new BitSet[]{bitSet2, bitSet3});
                    n = this.iToken;
                    continue block14;
                }
                case 7: {
                    if (arrayList != null) {
                        this.error(22);
                    }
                    bl2 = true;
                    quaternionArray = ScriptMathProcessor.getQuaternionArray(((ScriptVariable)this.theToken).getList());
                    this.getToken(++n);
                    quaternionArray2 = ScriptMathProcessor.getQuaternionArray(((ScriptVariable)this.theToken).getList());
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Object[]>();
                    }
                    arrayList2.add(new Object[]{quaternionArray, quaternionArray2});
                    continue block14;
                }
                case 1073742077: {
                    bl2 = true;
                    continue block14;
                }
                case 0x8100010: 
                case 0x44100001: {
                    bl2 = false;
                    continue block14;
                }
                case 528432: {
                    bl3 = true;
                    continue block14;
                }
                case 4160: {
                    bl4 = true;
                    continue block14;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl7) {
            f = 0.0f;
        }
        if (Float.isNaN(f) || f < 0.0f) {
            f = 1.0f;
        } else if (!bl3 && !bl4) {
            bl4 = true;
            bl3 = true;
        }
        bl5 = f != 0.0f;
        int n3 = n = !bl2 && string == null ? 1 : 0;
        if (arrayList == null && arrayList2 == null) {
            if (bitSet6 == null) {
                BitSet bitSet9 = bitSet2 = n != 0 ? this.viewer.getAtomBitSet("spine") : new BitSet();
                if (bitSet2.nextSetBit(0) < 0) {
                    bitSet2 = bitSet4;
                    bitSet3 = bitSet;
                } else {
                    bitSet3 = BitSetUtil.copy(bitSet2);
                    bitSet2.and(bitSet4);
                    bitSet3.and(bitSet);
                }
            } else {
                bitSet2 = BitSetUtil.copy(bitSet4);
                bitSet3 = BitSetUtil.copy(bitSet);
                bitSet2.and(bitSet6);
                bitSet3.and(bitSet6);
                bitSet2.and(bitSet4);
                bitSet3.and(bitSet);
            }
            arrayList = new ArrayList();
            arrayList.add(new BitSet[]{bitSet2, bitSet3});
        }
        if (bl7) {
            BitSet bitSet10 = this.viewer.getModelBitSet(bitSet4, false);
            bitSetArray = new BitSet[bitSet10.cardinality()];
            int n4 = 0;
            int n5 = bitSet10.nextSetBit(0);
            while (n5 >= 0) {
                bitSetArray[n4] = this.viewer.getModelUndeletedAtomsBitSet(n5);
                n5 = bitSet10.nextSetBit(n5 + 1);
                ++n4;
            }
        } else {
            bitSetArray = new BitSet[]{bitSet4};
        }
        for (int i = 0; i < bitSetArray.length; ++i) {
            Object object;
            Vector3f vector3f;
            BitSet[] bitSetArray2;
            int n6;
            bitSet4 = bitSetArray[i];
            float[] fArray = new float[2];
            Quaternion quaternion = null;
            ArrayList<Quaternion> arrayList3 = new ArrayList<Quaternion>();
            Point3f[][] point3fArray = null;
            ArrayList<BitSet[]> arrayList4 = bl7 ? new ArrayList<BitSet[]>() : arrayList;
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                bitSetArray2 = (BitSet[])arrayList.get(n6);
                if (bl7) {
                    bitSetArray2 = new BitSet[]{BitSetUtil.copy(bitSetArray2[0]), bitSetArray2[1]};
                    arrayList4.add(bitSetArray2);
                }
                bitSetArray2[0].and(bitSet4);
            }
            if (n != 0) {
                point3fArray = this.viewer.getCenterAndPoints(arrayList4, true);
                quaternion = Measure.calculateQuaternionRotation(point3fArray, fArray, true);
                float f2 = Float.isNaN(fArray[1]) ? Float.NaN : (float)((int)(fArray[0] * 100.0f)) / 100.0f;
                float f3 = Float.isNaN(fArray[1]) ? Float.NaN : (float)((int)(fArray[1] * 100.0f)) / 100.0f;
                this.showString("RMSD " + f2 + " --> " + f3 + " Angstroms");
            } else if (bl2) {
                if (arrayList2 == null) {
                    for (n6 = 0; n6 < arrayList4.size(); ++n6) {
                        bitSetArray2 = (BitSet[])arrayList4.get(n6);
                        quaternionArray = this.viewer.getAtomGroupQuaternions(bitSetArray2[0], Integer.MAX_VALUE);
                        quaternionArray2 = this.viewer.getAtomGroupQuaternions(bitSetArray2[1], Integer.MAX_VALUE);
                        for (int j = 0; j < quaternionArray.length && j < quaternionArray2.length; ++j) {
                            arrayList3.add(quaternionArray2[j].div(quaternionArray[j]));
                        }
                    }
                } else {
                    for (n6 = 0; n6 < quaternionArray.length && n6 < quaternionArray2.length; ++n6) {
                        arrayList3.add(quaternionArray2[n6].div(quaternionArray[n6]));
                    }
                }
                fArray[0] = 0.0f;
                quaternionArray = arrayList3.toArray(new Quaternion[arrayList3.size()]);
                quaternion = Quaternion.sphereMean(quaternionArray, fArray, 1.0E-4f);
                this.showString("RMSD = " + fArray[0] + " degrees");
            } else {
                Matrix4f matrix4f = new Matrix4f();
                float f4 = this.getSmilesCorrelation(bitSet4, bitSet, string, null, null, matrix4f, null, !bl6, false);
                if (Float.isNaN(f4)) {
                    this.error(22);
                }
                vector3f = new Vector3f();
                matrix4f.get(vector3f);
                object = new Matrix3f();
                matrix4f.get((Matrix3f)object);
                quaternion = new Quaternion((Matrix3f)object);
            }
            if (point3fArray == null) {
                point3fArray = this.viewer.getCenterAndPoints(arrayList4, true);
            }
            Point3f point3f = new Point3f();
            float f5 = Float.NaN;
            vector3f = null;
            if (bl4) {
                vector3f = new Vector3f(point3fArray[1][0]);
                vector3f.sub(point3fArray[0][0]);
                f5 = 0.0f;
            }
            if (bl3) {
                if (quaternion == null) {
                    this.evalError("option not implemented", null);
                }
                point3f.set(point3fArray[0][0]);
                point3f.add(quaternion.getNormal());
                f5 = quaternion.getTheta();
            }
            if (Float.isNaN(f5) || Float.isNaN(point3f.x)) continue;
            object = null;
            if (bl3 && bl4 && f != 0.0f) {
                List<Point3f> list = this.viewer.getAtomPointVector(bitSet4);
                Matrix4f matrix4f = ScriptMathProcessor.getMatrix4f(quaternion.getMatrix(), vector3f);
                object = Measure.transformPoints(list, matrix4f, point3fArray[0][0]);
            }
            this.viewer.rotateAboutPointsInternal(point3fArray[0][0], point3f, f5 / f, f5, bl5, bitSet4, vector3f, (List<Point3f>)object);
        }
    }

    float getSmilesCorrelation(BitSet bitSet, BitSet bitSet2, String string, List<Point3f> list, List<Point3f> list2, Matrix4f matrix4f, List<BitSet> list3, boolean bl, boolean bl2) throws ScriptException {
        float f = 0.1f;
        try {
            int n;
            int n2;
            if (list == null) {
                list = new ArrayList<Point3f>();
                list2 = new ArrayList<Point3f>();
            }
            if (matrix4f == null) {
                matrix4f = new Matrix4f();
            }
            JmolNode[] jmolNodeArray = this.viewer.getModelSet().atoms;
            int n3 = this.viewer.getAtomCount();
            int[][] nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n3, bitSet, bl, true);
            if (nArray == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            if (nArray.length == 0) {
                return Float.NaN;
            }
            for (n2 = 0; n2 < nArray[0].length; ++n2) {
                list.add((Point3f)((Object)jmolNodeArray[nArray[0][n2]]));
            }
            nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n3, bitSet2, bl, false);
            if (nArray == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            if (nArray.length == 0) {
                return Float.NaN;
            }
            if (bl2) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    for (int i = 0; i < nArray[n2].length; ++i) {
                        list2.add((Point3f)((Object)jmolNodeArray[nArray[n2][i]]));
                    }
                }
                return 0.0f;
            }
            float f2 = Float.MAX_VALUE;
            int[] nArray2 = null;
            for (n = 0; n < nArray.length; ++n) {
                list2.clear();
                for (int i = 0; i < nArray[n].length; ++i) {
                    list2.add((Point3f)((Object)jmolNodeArray[nArray[n][i]]));
                }
                float f3 = Measure.getTransformMatrix4(list, list2, matrix4f, null);
                Logger.info("getSmilesCorrelation stddev=" + f3);
                if (list3 != null && f3 < f) {
                    BitSet bitSet3 = new BitSet();
                    for (int i = 0; i < nArray[n].length; ++i) {
                        bitSet3.set(nArray[n][i]);
                    }
                    list3.add(bitSet3);
                }
                if (!(f3 < f2)) continue;
                nArray2 = nArray[n];
                f2 = f3;
            }
            for (n = 0; n < nArray2.length; ++n) {
                list2.add((Point3f)((Object)jmolNodeArray[nArray2[n]]));
            }
            return f2;
        }
        catch (Exception exception) {
            this.evalError(exception.getMessage(), null);
            return 0.0f;
        }
    }

    Object getSmilesMatches(String string, String string2, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) throws ScriptException {
        Object object;
        BitSet[] bitSetArray;
        if (this.isSyntaxCheck) {
            if (bl2) {
                return new BitSet();
            }
            return new String[]{"({})"};
        }
        if (string.length() == 0) {
            boolean bl3 = !bl2;
            String string3 = this.viewer.getSmiles(0, 0, bitSet, bl3, false, true, true);
            if (string3 == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            return string3;
        }
        boolean bl4 = true;
        if (bitSet2 == null) {
            bl4 = string2 == null;
            bitSetArray = bl4 ? this.viewer.getSmilesMatcher().getSubstructureSetArray(string, this.viewer.getModelSet().atoms, this.viewer.getAtomCount(), bitSet, null, bl, false) : this.viewer.getSmilesMatcher().find(string, string2, bl, false);
            if (bitSetArray == null) {
                this.showString(this.viewer.getSmilesMatcher().getLastException(), false);
                if (!bl4 && !bl) {
                    return -1;
                }
                return "?";
            }
        } else {
            object = new ArrayList<BitSet>();
            float f = this.getSmilesCorrelation(bitSet2, bitSet, string, null, null, null, (List<BitSet>)object, bl, false);
            if (Float.isNaN(f)) {
                if (bl2) {
                    return new BitSet();
                }
                return new String[0];
            }
            this.showString("RMSD " + f + " Angstroms");
            bitSetArray = object.toArray(new BitSet[object.size()]);
        }
        if (bl2) {
            object = new BitSet();
            for (int i = 0; i < bitSetArray.length; ++i) {
                object.or(bitSetArray[i]);
            }
            if (bl4) {
                return object;
            }
            if (!bl) {
                return object.cardinality();
            }
            int[] nArray = new int[object.cardinality()];
            int n = 0;
            int n2 = object.nextSetBit(0);
            while (n2 >= 0) {
                nArray[n++] = n2 + 1;
                n2 = object.nextSetBit(n2 + 1);
            }
            return nArray;
        }
        object = new String[bitSetArray.length];
        for (int i = 0; i < bitSetArray.length; ++i) {
            object[i] = Escape.escape(bitSetArray[i], bl4);
        }
        return object;
    }

    private void connect(int n) throws ScriptException {
        Object object;
        int n2;
        float[] fArray = new float[2];
        BitSet[] bitSetArray = new BitSet[2];
        bitSetArray[0] = bitSetArray[1] = this.viewer.getSelectionSet(false);
        float f = Float.NaN;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = 131071;
        int n6 = 1073742026;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n7 = 0;
        int n8 = 0;
        BitSet bitSet = new BitSet();
        boolean bl5 = false;
        int n9 = 0;
        int n10 = 0;
        float f3 = 0.0f;
        boolean bl6 = false;
        if (this.statementLength == 1) {
            if (!this.isSyntaxCheck) {
                this.viewer.rebond(this.isStateScript);
            }
            return;
        }
        block22: for (n2 = n; n2 < this.statementLength; ++n2) {
            switch (this.getToken((int)n2).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.rebond(this.isStateScript);
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int n11;
                    if (n7 > 0) {
                        if (bl2 || bl4) {
                            this.error(23);
                        }
                        if ((n11 = JmolEdge.getBondOrderFromFloat(this.floatParameter(n2))) == 131071) {
                            this.error(22);
                        }
                        n5 = n11;
                        bl2 = true;
                        break;
                    }
                    if (++n8 > 2) {
                        this.error(2);
                    }
                    float f4 = this.floatParameter(n2);
                    if (this.tokAt(n2 + 1) == 269484210) {
                        f4 = -f4 / 100.0f;
                        ++n2;
                    }
                    fArray[n4++] = f4;
                    break;
                }
                case 10: 
                case 0x100001: {
                    int n12;
                    int n13;
                    if (n7 > 2 || bl5 && n7 > 0) {
                        this.error(2);
                    }
                    if (bl2 || bl4) {
                        this.error(23);
                    }
                    bitSetArray[n7++] = this.atomExpression(n2);
                    bl5 = this.isBondSet;
                    if (n7 == 2) {
                        n13 = this.iToken;
                        for (n12 = n2; n12 < n13; ++n12) {
                            if (this.tokAt(n12) != 0x40000000 || !this.parameterAsString(n12).equals("_1")) continue;
                            n9 = n2;
                            break;
                        }
                        this.iToken = n13;
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1087373318: {
                    bl6 = true;
                    break;
                }
                case 1766856708: {
                    int n13 = this.tokAt(n2 + 1);
                    if (n13 == 1073742180 || n13 == 1073742074) continue block22;
                    n10 = n2 + 1;
                    continue block22;
                }
                case 1073742074: 
                case 1073742180: {
                    if (string != null) {
                        this.error(22);
                    }
                    bl4 = true;
                    string = this.parameterAsString(n2);
                    if (this.theTok == 1073742180 && this.isFloatParameter(n2 + 1)) {
                        f2 = this.getTranslucentLevel(++n2);
                    }
                    n10 = n2 + 1;
                    break;
                }
                case 1074790662: {
                    int n12 = this.tokAt(2) == 1073741852 ? 1 : 0;
                    this.checkLength(n12 != 0 ? 3 : 2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setPdbConectBonding(n12 != 0, this.isStateScript);
                    }
                    return;
                }
                case 0x40000006: 
                case 1073741852: 
                case 0x40000050: 
                case 1073742025: 
                case 1073742026: {
                    bl3 = true;
                    if (++n2 != this.statementLength) {
                        this.error(23);
                    }
                    n6 = this.theTok;
                    if (this.theTok != 1073741852 || n5 == 131071 || n5 == 2048 || n5 == 515) break;
                    this.error(22);
                    break;
                }
                case 0x1A101A: {
                    if (!bl4) {
                        n3 = 0xFFFFFF;
                        string = "translucent";
                        f2 = 0.5f;
                        f = this.viewer.getStrutDefaultRadius();
                        bl4 = true;
                    }
                    if (!bl3) {
                        n6 = 1073742026;
                    }
                    bl3 = true;
                }
                case 0x40000000: 
                case 1076887572: 
                case 1612189718: {
                    int n11;
                    if (n2 > 0) {
                        if (n10 == n2) break;
                        if (this.isColorParam(n2)) {
                            n10 = -n2;
                            break;
                        }
                    }
                    if ((n11 = ScriptEvaluator.getBondOrderFromString((String)(object = this.parameterAsString(n2)))) == 131071) {
                        this.error(22);
                    }
                    if (bl2) {
                        this.error(18);
                    }
                    bl2 = true;
                    switch (n11) {
                        case 33: {
                            switch (this.tokAt(n2 + 1)) {
                                case 3: {
                                    n11 = ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(this.statement[++n2].intValue);
                                    break;
                                }
                                case 2: {
                                    n11 = (short)this.intParameter(++n2);
                                }
                            }
                            break;
                        }
                        case 2048: {
                            if (this.tokAt(n2 + 1) != 2) break;
                            n11 = (short)(this.intParameter(++n2) << 11);
                            f3 = this.floatParameter(++n2);
                        }
                    }
                    n5 = n11;
                    break;
                }
                case 1666189314: {
                    f = this.floatParameter(++n2);
                    bl4 = true;
                    break;
                }
                case 12291: 
                case 0x10000B: {
                    if (++n2 != this.statementLength) {
                        this.error(23);
                    }
                    n6 = 12291;
                    bl = true;
                    bl4 = false;
                    break;
                }
                default: {
                    n10 = n2;
                }
            }
            if (n2 <= 0) continue;
            if (n10 == -n2 || n10 == n2 && this.isColorParam(n2)) {
                n3 = this.getArgbParam(n2);
                n2 = this.iToken;
                bl4 = true;
                continue;
            }
            if (n10 != n2) continue;
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 < 2) {
            if (n4 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (string != null || !Float.isNaN(f) || n3 != Integer.MIN_VALUE) {
            if (!bl2) {
                n5 = 65535;
            }
            if (!bl3) {
                n6 = 1073742025;
            }
        }
        n2 = 0;
        int n14 = 0;
        if (n9 > 0) {
            BitSet bitSet2 = new BitSet();
            this.definedAtomSets.put("_1", bitSet2);
            object = bitSetArray[0];
            int n15 = ((BitSet)object).nextSetBit(0);
            while (n15 >= 0) {
                bitSet2.set(n15);
                int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bitSet2, this.atomExpression(n9), bitSet, bl5, false, 0.0f);
                n2 += Math.abs(nArray[0]);
                n14 += nArray[1];
                bitSet2.clear(n15);
                n15 = ((BitSet)object).nextSetBit(n15 + 1);
            }
        } else {
            int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bitSetArray[0], bitSetArray[1], bitSet, bl5, bl6, f3);
            n2 += Math.abs(nArray[0]);
            n14 += nArray[1];
        }
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatusOrBuffer(GT._("{0} connections deleted", n14));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bitSet);
            if (!Float.isNaN(f)) {
                this.setShapeSize(1, (int)(f * 2000.0f), null);
            }
            if (n3 != Integer.MIN_VALUE) {
                this.setShapeProperty(1, "color", n3, bitSet);
            }
            if (string != null) {
                if (f2 == Float.MAX_VALUE) {
                    f2 = this.viewer.getDefaultTranslucent();
                }
                this.setShapeProperty(1, "translucentLevel", Float.valueOf(f2));
                this.setShapeProperty(1, "translucency", string, bitSet);
            }
            this.viewer.selectBonds(null);
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} new bonds; {1} modified", new Object[]{n2, n14}));
        }
    }

    private float getTranslucentLevel(int n) throws ScriptException {
        float f = this.floatParameter(n);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private void getProperty() throws ScriptException {
        BitSet bitSet;
        if (this.isSyntaxCheck) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = string2;
        if (string3.indexOf(".") >= 0) {
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (string3.indexOf("[") >= 0) {
            string3 = string3.substring(0, string3.indexOf("["));
        }
        int n = PropertyManager.getPropertyNumber(string3);
        String string4 = this.optParameterAsString(2);
        int n2 = this.tokAt(2);
        BitSet bitSet2 = bitSet = n2 == 0x100001 || n2 == 10 ? this.atomExpression(2) : null;
        if (string2.length() > 0 && n < 0) {
            string2 = "";
            string4 = "";
        } else if (n >= 0 && this.statementLength < 3) {
            string4 = PropertyManager.getDefaultParam(n);
            if (string4.equals("(visible)")) {
                this.viewer.setModelVisibility();
                bitSet = this.viewer.getVisibleSet();
            }
        } else if (n == 3) {
            for (int i = 3; i < this.statementLength; ++i) {
                string4 = string4 + this.parameterAsString(i);
            }
        }
        string = (String)this.viewer.getProperty("readable", string2, bitSet == null ? string4 : bitSet);
        this.showString(string);
    }

    private void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.theTok == 1073741979) {
            String string = this.parameterAsString(this.checkLast(++n));
            if (this.isSyntaxCheck) {
                return;
            }
            String[] stringArray = new String[1];
            Object object = null;
            if (!string.equalsIgnoreCase("none") && string.length() > 0 && (object = this.viewer.getFileAsImage(string, stringArray)) == null) {
                this.evalError(stringArray[0], null);
            }
            this.viewer.setBackgroundImage(stringArray[0], object);
            return;
        }
        if (this.isColorParam(n) || this.theTok == 0x10000B) {
            int n2 = this.getArgbParamLast(n, true);
            if (this.isSyntaxCheck) {
                return;
            }
            this.setObjectArgb("background", n2);
            this.viewer.setBackgroundImage(null, null);
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void center(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        Point3f point3f = this.centerParameter(n);
        if (point3f == null) {
            this.error(22);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setNewRotationCenter(point3f);
        }
    }

    private String setObjectProperty() throws ScriptException {
        String string = "";
        String string2 = this.getShapeNameParameter(2);
        Object[] objectArray = new Object[]{string2, null};
        if (this.isSyntaxCheck) {
            return "";
        }
        int n = this.iToken;
        int n2 = this.tokAt(0);
        boolean bl = TextFormat.isWild(string2);
        int n3 = 17;
        do {
            if (n3 != 26 && this.getShapeProperty(n3, "checkID", objectArray)) {
                this.setShapeProperty(n3, "thisID", string2);
                switch (n2) {
                    case 12291: {
                        this.setShapeProperty(n3, "delete", null);
                        break;
                    }
                    case 12294: 
                    case 1610625028: {
                        this.setShapeProperty(n3, "hidden", n2 == 1610625028 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 4148: {
                        string = string + (String)this.getShapeProperty(n3, "command") + "\n";
                        break;
                    }
                    case 1766856708: {
                        this.colorShape(n3, n + 1, false);
                    }
                }
                if (!bl) break;
            }
            if (n3 != 17) continue;
            n3 = 30;
        } while (--n3 >= 22);
        return string;
    }

    private void color() throws ScriptException {
        int n = 1;
        if (this.isColorParam(1)) {
            this.theTok = 0x44100001;
        } else {
            int n2 = 0;
            n = 2;
            int n3 = this.getToken((int)1).tok;
            switch (n3) {
                case 0x100007: {
                    this.setObjectProperty();
                    return;
                }
                case 0x10000B: 
                case 0x300002: 
                case 1073741946: 
                case 1073741992: 
                case 0x400000D0: 
                case 1073742074: 
                case 1073742116: 
                case 0x40000140: 
                case 1073742180: 
                case 1073742186: 
                case 1087373315: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373322: 
                case 1095761934: 
                case 1095761935: 
                case 1112539148: 
                case 1112539149: 
                case 1112541196: 
                case 1112541199: 
                case 1113200651: 
                case 1114638346: 
                case 1632634889: 
                case 1641025539: 
                case 1649412112: 
                case 1716520973: {
                    this.theTok = 0x44100001;
                    n = 1;
                    break;
                }
                case 4: {
                    boolean bl;
                    n = 1;
                    String string = this.stringParameter(n++);
                    if (this.isArrayParameter(n)) {
                        string = string + "=" + ScriptVariable.sValue(ScriptVariable.getVariable(this.stringParameterSet(n))).replace('\n', ' ');
                        n = this.iToken + 1;
                    }
                    boolean bl2 = bl = this.tokAt(n) == 1073742180;
                    if (!this.isSyntaxCheck) {
                        this.viewer.setPropertyColorScheme(string, bl, true);
                    }
                    if (bl) {
                        ++n;
                    }
                    if (this.tokAt(n) == 1073742114 || this.tokAt(n) == 0x40000002) {
                        float f = this.floatParameter(++n);
                        float f2 = this.floatParameter(++n);
                        if (!this.isSyntaxCheck) {
                            this.viewer.setCurrentColorRange(f, f2);
                        }
                    }
                    return;
                }
                case 0x40000002: 
                case 1073742114: {
                    float f = this.floatParameter(2);
                    float f3 = this.floatParameter(this.checkLast(3));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCurrentColorRange(f, f3);
                    }
                    return;
                }
                case 1610616835: {
                    n2 = this.getArgbParamLast(2, true);
                    if (!this.isSyntaxCheck) {
                        this.setObjectArgb("background", n2);
                    }
                    return;
                }
                case 10: 
                case 0x100001: {
                    n = -1;
                    this.theTok = 0x44100001;
                    break;
                }
                case 1073742134: {
                    n2 = this.getArgbParamLast(2, false);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setRubberbandArgb(n2);
                    }
                    return;
                }
                case 0x20000008: 
                case 1611141171: {
                    n = 2;
                    if (this.tokAt(2) == 1073742074) {
                        ++n;
                    }
                    n2 = this.getArgbParamLast(n, true);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.shapeManager.loadShape(8);
                    this.setShapeProperty(8, n3 == 1611141171 ? "argbSelection" : "argbHighlight", n2);
                    return;
                }
                case 0x40000000: 
                case 1611272194: 
                case 1613758476: 
                case 1614417948: 
                case 1679429641: {
                    String string = this.parameterAsString(1);
                    if (this.checkToken(2)) {
                        switch (this.getToken((int)2).tok) {
                            case 1073742116: {
                                n2 = 1073742116;
                                break;
                            }
                            case 0x10000B: 
                            case 1073741992: {
                                n2 = 1073741992;
                                break;
                            }
                            default: {
                                n2 = this.getArgbParam(2);
                            }
                        }
                    }
                    if (n2 == 0) {
                        this.error(9);
                    }
                    this.checkLast(this.iToken);
                    if (string.equalsIgnoreCase("axes") || StateManager.getObjectIdFromName(string) >= 0) {
                        this.setObjectArgb(string, n2);
                        return;
                    }
                    if (this.changeElementColor(string, n2)) {
                        return;
                    }
                    this.error(22);
                    break;
                }
                case 135180: 
                case 135402505: {
                    this.setShapeProperty(JmolConstants.shapeTokenIndex(n3), "thisID", "+PREVIOUS_MESH+");
                }
            }
        }
        this.colorShape(this.getShapeType(this.theTok), n, false);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.elementNameFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.altElementNameFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + Elements.elementSymbolFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + Elements.altElementSymbolFromIndex(n2))) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + Elements.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        int n3;
        String string = null;
        Object object = null;
        Integer n4 = null;
        BitSet bitSet = null;
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = n == 23 || n == 24;
        int n5 = 0;
        boolean bl4 = false;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bitSet = this.atomExpression(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                bl4 = true;
                n = 1;
            }
        }
        if (bl) {
            this.getToken(n2);
        } else {
            bl = this.getToken((int)n2).tok == 1610616835;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        } else if (bl3) {
            switch (this.theTok) {
                case 1073742018: {
                    this.getToken(++n2);
                    string2 = "mesh";
                    break;
                }
                case 1073742094: {
                    n3 = this.getArgbParam(++n2, false);
                    n4 = n3 == 0 ? null : Integer.valueOf(n3);
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (this.theToken.value instanceof Bond.BondSet) {
                        bitSet = (Bond.BondSet)this.theToken.value;
                        string2 = "vertex";
                    } else {
                        bitSet = this.atomExpression(n2);
                        string2 = "atom";
                    }
                    f = Float.MIN_VALUE;
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                }
            }
        }
        if (!this.isSyntaxCheck && n == 26 && !this.mo(true)) {
            return;
        }
        int n6 = n3 = this.theTok == 1073742180 ? 1 : 0;
        if (n3 != 0 || this.theTok == 1073742074) {
            if (f == Float.MIN_VALUE) {
                this.error(22);
            }
            string = this.parameterAsString(n2++);
            if (n3 != 0 && this.isFloatParameter(n2)) {
                f = this.getTranslucentLevel(n2++);
            }
        }
        int n7 = 0;
        if (n2 < this.statementLength && this.tokAt(n2) != 0x10000D && this.tokAt(n2) != 0x10000C) {
            bl2 = true;
            n7 = this.getToken((int)n2).tok;
            if ((!bl3 || this.tokAt(n2 + 1) != 1074790746) && this.isColorParam(n2)) {
                int n8 = this.getArgbParam(n2, false);
                Integer n9 = object = n8 == 0 ? null : Integer.valueOf(n8);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    int n10 = n3 = this.theTok == 1073742180 ? 1 : 0;
                    if (n3 != 0 || this.theTok == 1073742074) {
                        string = this.parameterAsString(n2);
                        if (n3 != 0 && this.isFloatParameter(n2 + 1)) {
                            f = this.getTranslucentLevel(++n2);
                        }
                    }
                }
            } else if (n == 25) {
                --this.iToken;
            } else {
                BitSet bitSet2;
                EnumPalette enumPalette;
                boolean bl5;
                String string3 = this.parameterAsString(n2).toLowerCase();
                boolean bl6 = string3.indexOf("byelement") == 0;
                boolean bl7 = bl5 = bl6 || string3.indexOf("byresidue") == 0;
                EnumPalette enumPalette2 = bl5 || bl3 ? EnumPalette.PROPERTY : (enumPalette = n7 == 1113200651 ? EnumPalette.CPK : EnumPalette.getPalette(string3));
                if (enumPalette == EnumPalette.UNKNOWN || (enumPalette == EnumPalette.TYPE || enumPalette == EnumPalette.ENERGY) && n != 2) {
                    this.error(22);
                }
                float[] fArray = null;
                BitSet bitSet3 = bitSet2 = enumPalette != EnumPalette.PROPERTY && enumPalette != EnumPalette.VARIABLE || !this.viewer.isRangeSelected() ? null : this.viewer.getSelectionSet(false);
                if (enumPalette == EnumPalette.PROPERTY) {
                    if (bl5) {
                        if (!this.isSyntaxCheck) {
                            fArray = this.getBitsetPropertyFloat(bitSet2, (bl6 ? 1095763976 : 1095761930) | 0x100, Float.NaN, Float.NaN);
                        }
                    } else {
                        if (!bl5 && !bl3) {
                            ++n2;
                        }
                        if (string3.equals("property") && Token.tokAttr(n7 = this.getToken((int)n2).tok, 0x40500000) && !Token.tokAttr(n7, 0x40D00000) && !this.isSyntaxCheck) {
                            fArray = this.getBitsetPropertyFloat(bitSet2, this.getToken((int)n2++).tok | 0x100, Float.NaN, Float.NaN);
                        }
                    }
                } else if (enumPalette == EnumPalette.VARIABLE) {
                    int n11 = ++n2;
                    ++n2;
                    string3 = this.parameterAsString(n11);
                    fArray = new float[this.viewer.getAtomCount()];
                    Parser.parseStringInfestedFloatArray("" + this.getParameter(string3, 4), null, fArray);
                    enumPalette = EnumPalette.PROPERTY;
                }
                if (enumPalette == EnumPalette.PROPERTY) {
                    Object object2;
                    String string4 = null;
                    if (this.tokAt(n2) == 4) {
                        string4 = this.parameterAsString(n2++).toLowerCase();
                        if (this.isArrayParameter(n2)) {
                            string4 = string4 + "=" + ScriptVariable.sValue(ScriptVariable.getVariable(this.stringParameterSet(n2))).replace('\n', ' ');
                            n2 = this.iToken + 1;
                        }
                    } else if (bl3 && this.isColorParam(n2)) {
                        string4 = this.getColorRange(n2);
                        n2 = this.iToken + 1;
                    }
                    if (string4 != null && !bl3) {
                        this.setStringProperty("propertyColorScheme", (n3 != 0 && f == Float.MAX_VALUE ? "translucent " : "") + string4);
                        bl5 = string4.indexOf("byelement") == 0 || string4.indexOf("byresidue") == 0;
                    }
                    Object object3 = 0.0f;
                    Object object4 = Float.MAX_VALUE;
                    if (!(bl5 || this.tokAt(n2) != 0x40000002 && this.tokAt(n2) != 1073742114)) {
                        object3 = this.floatParameter(n2 + 1);
                        object4 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (object3 == object4 && bl3) {
                            object2 = (float[])this.getShapeProperty(n, "dataRange");
                            if (object2 != null) {
                                object3 = object2[0];
                                object4 = object2[1];
                            }
                        } else if (object3 == object4) {
                            object4 = Float.MAX_VALUE;
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        if (!bl3) {
                            if (fArray == null) {
                                this.viewer.setCurrentColorRange(string3);
                            } else {
                                this.viewer.setCurrentColorRange(fArray, bitSet2);
                            }
                        }
                        if (bl3) {
                            this.checkLength(n2);
                            bl2 = false;
                            object2 = this.viewer.getColorEncoder(string4);
                            if (object2 == null) {
                                return;
                            }
                            ((ColorEncoder)object2).isTranslucent = n3 != 0 && f == Float.MAX_VALUE;
                            ((ColorEncoder)object2).setRange((float)object3, (float)object4, object3 > object4);
                            if (object4 == Float.MAX_VALUE) {
                                ((ColorEncoder)object2).hi = object4;
                            }
                            this.setShapeProperty(n, "remapColor", object2);
                            this.showString(this.getIsosurfaceDataRange(n, ""));
                            if (f == Float.MAX_VALUE) {
                                return;
                            }
                        } else if (object4 != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange((float)object3, (float)object4);
                        }
                    }
                } else {
                    ++n2;
                }
                this.checkLength(n2);
                object = enumPalette;
            }
        }
        if (this.isSyntaxCheck || n < 0) {
            return;
        }
        switch (n) {
            case 4: {
                n5 = 32768;
                break;
            }
            case 2: {
                n5 = 30720;
                break;
            }
            case 3: {
                n5 = 256;
                break;
            }
            case 1: {
                n5 = 1023;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        if (n5 == 0) {
            this.shapeManager.loadShape(n);
            if (n == 5) {
                this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bitSet != null) {
                this.viewer.selectBonds(bitSet);
                bitSet = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", n5);
        }
        if (bl2) {
            switch (n7) {
                case 1112539148: 
                case 1112539149: {
                    this.viewer.autoCalculate(n7);
                    break;
                }
                case 1112541199: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 1087373318: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 0x400000D0: 
                case 1095761935: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 1095761934: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
            if (bl3 && n4 != null) {
                this.setShapeProperty(n, "colorPhase", new Object[]{n4, object});
            } else if (bitSet == null) {
                this.setShapeProperty(n, string2 + "color", object);
            } else {
                this.setShapeProperty(n, string2 + "color", object, bitSet);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f, bitSet);
        }
        if (n5 != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
        if (bl4) {
            this.viewer.selectBonds(null);
        }
    }

    private void colorShape(int n, int n2, int n3, String string, float f, BitSet bitSet) {
        if (n2 != 0) {
            n = 1;
            this.setShapeProperty(1, "type", n2);
        }
        this.setShapeProperty(n, "color", n3, bitSet);
        if (string != null) {
            this.setShapeTranslucency(n, "", string, f, bitSet);
        }
        if (n2 != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
    }

    private void setShapeTranslucency(int n, String string, String string2, float f, BitSet bitSet) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getDefaultTranslucent();
        }
        this.setShapeProperty(n, "translucentLevel", Float.valueOf(f));
        if (string == null) {
            return;
        }
        if (bitSet == null) {
            this.setShapeProperty(n, string + "translucency", string2);
        } else if (!this.isSyntaxCheck) {
            this.setShapeProperty(n, string + "translucency", string2, bitSet);
        }
    }

    private void cd() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.statementLength == 1 ? null : this.parameterAsString(1);
        this.showString(this.viewer.cd(string));
    }

    private void mapProperty() throws ScriptException {
        block19: {
            int n;
            Object object;
            Object[] objectArray;
            Object object2;
            String string;
            String string2;
            String string3;
            BitSet bitSet;
            BitSet bitSet2;
            int n2;
            int n3;
            int n4;
            block18: {
                block17: {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    if (this.tokAt(1) != 1114638350) break block17;
                    bitSet2 = this.viewer.getSelectionSet(false);
                    bitSet = this.atomExpression(2);
                    string3 = "selected";
                    string2 = "selected";
                    break block18;
                }
                bitSet2 = this.atomExpression(1);
                if (this.tokAt(++this.iToken) != 0x100008 || !Token.tokAttr(n4 = this.tokAt(++this.iToken), 0x40500000)) break block19;
                string2 = this.parameterAsString(this.iToken);
                bitSet = this.atomExpression(++this.iToken);
                if (this.tokAt(++this.iToken) != 0x100008 || !Token.tokAttr(n3 = this.tokAt(++this.iToken), 2048)) break block19;
                string3 = this.parameterAsString(this.iToken);
            }
            n2 = this.tokAt(this.iToken + 1);
            if (Token.tokAttr(n2, 0x40500000)) {
                string = this.parameterAsString(++this.iToken);
            } else {
                n2 = 1095763969;
                string = Token.nameOf(1095763969);
            }
            this.checkLast(this.iToken);
            if (this.isSyntaxCheck) {
                return;
            }
            BitSet bitSet3 = null;
            this.showString("mapping " + string2.toUpperCase() + " for " + bitSet2.cardinality() + " atoms to " + string3.toUpperCase() + " for " + bitSet.cardinality() + " atoms using " + string.toUpperCase());
            if (Token.tokAttrOr(n4, 1095761920, 1112539136) && Token.tokAttrOr(n3, 1095761920, 1112539136) && Token.tokAttrOr(n2, 1095761920, 1112539136)) {
                object2 = this.getBitsetPropertyFloat(bitSet2, n4 | 0xE0, Float.NaN, Float.NaN);
                objectArray = this.getBitsetPropertyFloat(bitSet2, n2 | 0xE0, Float.NaN, Float.NaN);
                object = this.getBitsetPropertyFloat(bitSet, n2 | 0xE0, Float.NaN, Float.NaN);
                n = n3 == 1716520973 ? 1 : 0;
                float[] fArray = new float[n != 0 ? this.viewer.getAtomCount() : ((float[])object).length];
                bitSet3 = new BitSet();
                if (((float[])object2).length == objectArray.length) {
                    int n5;
                    Hashtable<Float, Float> hashtable = new Hashtable<Float, Float>();
                    for (n5 = 0; n5 < ((float[])object2).length; ++n5) {
                        hashtable.put(Float.valueOf(objectArray[n5]), Float.valueOf(object2[n5]));
                    }
                    n5 = -1;
                    int n6 = 0;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        n5 = bitSet.nextSetBit(n5 + 1);
                        Float f = (Float)hashtable.get(Float.valueOf((float)object[i]));
                        if (f == null) continue;
                        bitSet3.set(n5);
                        fArray[n != 0 ? n5 : n6] = f.floatValue();
                        ++n6;
                    }
                    if (n != 0) {
                        this.viewer.setData(string3, new Object[]{string3, fArray, bitSet3}, this.viewer.getAtomCount(), 0, 0, Integer.MAX_VALUE, 0);
                    } else {
                        this.viewer.setAtomProperty(bitSet3, n3, 0, 0.0f, null, fArray, null);
                    }
                }
            }
            if (bitSet3 == null) {
                object2 = "{" + string + "=%[" + string + "]}." + string3 + " = %[" + string2 + "]";
                objectArray = (String[])this.getBitsetIdent(bitSet2, (String)object2, null, false, Integer.MAX_VALUE, false);
                object = new StringBuffer();
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n].indexOf("null") >= 0) continue;
                    ((StringBuffer)object).append((String)objectArray[n]).append('\n');
                }
                if (Logger.debugging) {
                    Logger.info(((StringBuffer)object).toString());
                }
                BitSet bitSet4 = BitSetUtil.copy(this.viewer.getSelectionSubset());
                this.viewer.setSelectionSubset(bitSet);
                try {
                    this.runScript(((StringBuffer)object).toString());
                }
                catch (Exception exception) {
                    this.viewer.setSelectionSubset(bitSet4);
                    this.error(-1, "Error: " + exception.getMessage());
                }
                catch (Error error) {
                    this.viewer.setSelectionSubset(bitSet4);
                    this.error(-1, "Error: " + error.getMessage());
                }
                this.viewer.setSelectionSubset(bitSet4);
            }
            this.showString("DONE");
            return;
        }
        this.error(22);
    }

    private void data() throws ScriptException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                string = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                string2 = this.parameterAsString(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int n = string2.indexOf("@");
                if (n >= 0) {
                    string = "" + this.getParameter(string2.substring(n + 1), 4);
                    string2 = string2.substring(0, n).trim();
                    break;
                }
                if (string != null || (n = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
                bl = true;
                break;
            }
            default: {
                this.error(2);
            }
        }
        String string3 = string2 + " ";
        string3 = string3.substring(0, string3.indexOf(" ")).toLowerCase();
        if (string3.equals("model") || string3.equals("append")) {
            this.load();
            return;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = string2.toLowerCase().indexOf("(default)") >= 0;
        this.data = new Object[3];
        if (string3.equals("element_vdw")) {
            this.data[0] = string3;
            this.data[1] = string.replace(';', '\n');
            int n = Elements.elementNumberMax;
            int[] nArray = new int[n + 1];
            for (int i = 1; i <= n; ++i) {
                nArray[i] = i;
            }
            this.data[2] = nArray;
            this.viewer.setData("element_vdw", this.data, n, 0, 0, 0, 0);
            return;
        }
        if (string3.equals("connect_atoms")) {
            this.viewer.connect(Parser.parseFloatArray2d(string));
            return;
        }
        if (string3.indexOf("ligand_") == 0) {
            this.viewer.setLigandModel(string2.substring(7), string.trim());
            return;
        }
        if (string3.indexOf("data2d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray2d(string);
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        if (string3.indexOf("data3d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray3d(string);
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        String[] stringArray = Parser.getTokens(string2);
        if (!(string3.indexOf("property_") != 0 || stringArray.length == 2 && stringArray[1].equals("set"))) {
            int n;
            BitSet bitSet = this.viewer.getSelectionSet(false);
            this.data[0] = string3;
            int n2 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
            int n3 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberColumnCount");
            int n4 = bl ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
            int n5 = n = bl ? 0 : (Integer)this.viewer.getParameter("propertyDataColumnCount");
            if (!bl && string2.indexOf(" ") >= 0) {
                if (stringArray.length == 3) {
                    string2 = stringArray[0];
                    n2 = Parser.parseInt(stringArray[1]);
                    n4 = Parser.parseInt(stringArray[2]);
                }
                if (stringArray.length == 5) {
                    string2 = stringArray[0];
                    n2 = Parser.parseInt(stringArray[1]);
                    n3 = Parser.parseInt(stringArray[2]);
                    n4 = Parser.parseInt(stringArray[3]);
                    n = Parser.parseInt(stringArray[4]);
                }
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            int n6 = this.viewer.getAtomCount();
            int[] nArray = null;
            BitSet bitSet2 = new BitSet(n6);
            if (n2 > 0) {
                int n7;
                nArray = new int[n6 + 2];
                for (n7 = 0; n7 <= n6; ++n7) {
                    nArray[n7] = -1;
                }
                n7 = bitSet.nextSetBit(0);
                while (n7 >= 0) {
                    int n8 = this.viewer.getAtomNumber(n7);
                    if (n8 <= n6 + 1 && n8 >= 0 && !bitSet2.get(n8)) {
                        bitSet2.set(n8);
                        nArray[n8] = n7;
                    }
                    n7 = bitSet.nextSetBit(n7 + 1);
                }
                this.data[2] = nArray;
            } else {
                this.data[2] = BitSetUtil.copy(bitSet);
            }
            this.data[1] = string;
            this.viewer.setData(string3, this.data, n6, n2, n3, n4, n);
            return;
        }
        int n = AtomCollection.getUserSettableType(string3);
        if (n >= 0) {
            this.viewer.setAtomData(n, string3, string, bl2);
            return;
        }
        this.data[0] = string2;
        this.data[1] = string;
        this.viewer.setData(string3, this.data, 0, 0, 0, 0, 0);
    }

    private void define() throws ScriptException {
        boolean bl;
        String string;
        if (this.statementLength < 3 || !(this.getToken((int)1).value instanceof String)) {
            this.error(22);
        }
        if (Parser.parseInt(string = ((String)this.getToken((int)1).value).toLowerCase()) != Integer.MIN_VALUE) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = string.startsWith("site_");
        boolean bl3 = bl = string.indexOf("dynamic_") == 0;
        if (bl || bl2) {
            Token[] tokenArray = new Token[this.statementLength];
            int n = this.statementLength;
            while (--n >= 0) {
                tokenArray[n] = this.statement[n];
            }
            this.definedAtomSets.put("!" + (bl2 ? string : string.substring(8)), tokenArray);
        } else {
            BitSet bitSet = this.atomExpression(2);
            this.definedAtomSets.put(string, bitSet);
            if (!this.isSyntaxCheck) {
                this.viewer.setUserVariable("@" + string, ScriptVariable.getVariable(bitSet));
            }
        }
    }

    private void echo(int n, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            if (bl) {
                String[] stringArray = new String[1];
                Object object = this.viewer.getFileAsImage(string, stringArray);
                if (object == null) {
                    string = stringArray[0];
                } else {
                    this.setShapeProperty(29, "text", stringArray[0]);
                    this.setShapeProperty(29, "image", object);
                    string = null;
                }
            } else if (string.startsWith("\u0001")) {
                string = string.substring(1);
                bl = true;
            }
            if (string != null) {
                this.setShapeProperty(29, "text", string);
            }
        }
        if (!bl && this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string));
        }
    }

    private void message() throws ScriptException {
        String string = this.parameterAsString(this.checkLast(1));
        if (this.isSyntaxCheck) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            this.viewer.showMessage(string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatusOrBuffer(string2);
        }
    }

    private void log() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(2);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterExpressionString(1, 0);
        if (this.tokAt(1) == 0x10000C) {
            this.setStringProperty("logFile", "");
        } else {
            this.viewer.log(string);
        }
    }

    private void label(int n) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.loadShape(5);
        String string = null;
        switch (this.getToken((int)n).tok) {
            case 0x10000D: {
                string = this.viewer.getStandardLabelFormat(0);
                break;
            }
            case 0x10000C: {
                break;
            }
            case 12294: 
            case 1610625028: {
                this.setShapeProperty(5, "display", this.theTok == 1610625028 ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            default: {
                string = this.parameterAsString(n);
            }
        }
        this.shapeManager.setLabel(string, this.viewer.getSelectionSet(false));
    }

    private void hover() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.setHoverLabel(string);
    }

    private void load() throws ScriptException {
        String string;
        String string2;
        Object object;
        Object object2;
        int n;
        String string3;
        String string4;
        int n2;
        boolean bl = !this.isSyntaxCheck || this.isCmdLine_C_Option;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = this.tokAt(0) == 135270407 ? 0 : 1;
        boolean bl6 = this.viewer.getAppendNew();
        String string5 = null;
        ArrayList<Object> arrayList = null;
        int n4 = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        int n5 = this.viewer.getAtomCount();
        StringBuffer stringBuffer = new StringBuffer("load");
        int n6 = 1;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.isStateScript && this.forceNoAddHydrogens) {
            hashtable.put("doNotAddHydrogens", Boolean.TRUE);
        }
        String string6 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string7 = null;
        String string8 = "";
        int n7 = 0;
        if (this.statementLength == 1) {
            n3 = 0;
        } else {
            string6 = this.parameterAsString(n3);
            if (this.statementLength == 2 && !this.isSyntaxCheck && (string6.endsWith(".spt") || string6.endsWith(".png") || string6.endsWith(".pngj"))) {
                this.script(0, string6, false);
                return;
            }
            n2 = this.tokAt(n3);
            switch (n2) {
                case 1073742015: {
                    String string9 = this.parameterAsString(this.checkLast(2));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setMenu(string9, true);
                    }
                    return;
                }
                case 135270407: {
                    bl5 = true;
                    stringBuffer.append(" /*data*/ data");
                    string4 = this.stringParameter(++n3).toLowerCase();
                    stringBuffer.append(" ").append(Escape.escape(string4));
                    bl2 = string4.startsWith("append");
                    string3 = string4.indexOf("@") >= 0 ? "" + this.getParameter(string4.substring(string4.indexOf("@") + 1), 4) : this.parameterAsString(++n3);
                    string3 = this.viewer.fixInlineString(string3, this.viewer.getInlineChar());
                    hashtable.put("fileData", string3);
                    hashtable.put("isData", Boolean.TRUE);
                    stringBuffer.append('\n');
                    stringBuffer.append(string3);
                    if (string4.indexOf("@") >= 0) break;
                    stringBuffer.append(" end ").append(Escape.escape(string4));
                    n3 += 2;
                    break;
                }
                case 0x4000000F: {
                    bl2 = true;
                    stringBuffer.append(" append");
                    string6 = this.optParameterAsString(++n3);
                    n2 = Token.getTokFromName(string6);
                    break;
                }
                case 0x40000000: {
                    ++n3;
                    stringBuffer.append(" " + string6);
                    int n8 = n7 = n2 == 0x40000000 && Parser.isOneOf(string6.toLowerCase(), "xyz;vxyz;vibration;temperature;occupancy;partialcharge") ? Token.getTokFromName(string6) : 0;
                    if (n7 == 0) break;
                    hashtable.put("atomDataOnly", Boolean.TRUE);
                    hashtable.put("modelNumber", 1);
                    if (n7 == 4166) {
                        n7 = 1146095631;
                    }
                    stringArray2 = this.viewer.getFileInfo();
                    bl2 = true;
                }
            }
            switch (n2) {
                case 1073741983: 
                case 1229984263: {
                    bl3 = n2 == 1073741983;
                    ++n3;
                    stringBuffer.append(" " + string6);
                    break;
                }
                case 135267336: {
                    bl4 = true;
                    ++n3;
                    break;
                }
                case 0x2000000E: 
                case 1095766028: {
                    ++n3;
                    stringBuffer.append(" " + string6);
                    if (n2 == 0x2000000E) {
                        hashtable.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(n3)) {
                        Point3f point3f = this.getPoint3f(n3, false);
                        n3 = this.iToken + 1;
                        hashtable.put("firstLastStep", new int[]{(int)point3f.x, (int)point3f.y, (int)point3f.z});
                        stringBuffer.append(" " + Escape.escape(point3f));
                        break;
                    }
                    if (this.tokAt(n3) == 10) {
                        BitSet bitSet = (BitSet)this.getToken((int)n3++).value;
                        hashtable.put("bsModels", bitSet);
                        stringBuffer.append(" " + Escape.escape(bitSet));
                        break;
                    }
                    hashtable.put("firstLastStep", new int[]{0, -1, 1});
                    break;
                }
                case 0x40000000: {
                    break;
                }
                default: {
                    string6 = "fileset";
                }
            }
            if (this.getToken((int)n3).tok != 4) {
                this.error(16);
            }
        }
        int n9 = n3;
        string4 = null;
        if (this.tokAt(n9 + 1) == 1073741848) {
            string4 = this.stringParameter(n3 += 2);
            if (this.viewer.getPathForAllFiles() != "") {
                string4 = null;
                n9 = n3;
            }
        }
        string3 = null;
        if (this.statementLength == n3 + 1) {
            if (n3 == 0 || (string3 = this.parameterAsString(n9)).length() == 0) {
                string3 = this.viewer.getFullPathName();
            }
            if (string3 == null) {
                this.zap(false);
                return;
            }
            if (bl4) {
                string3 = "$" + string3;
            } else if (!bl3) {
                if (string3.indexOf("[]") >= 0) {
                    return;
                }
                if (string3.indexOf("[") == 0 && (stringArray = Escape.unescapeStringArray(string3)) != null) {
                    if (n3 == 1) {
                        stringBuffer.append(" files");
                    }
                    if (stringBuffer.indexOf(" files") < 0) {
                        this.error(22);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        stringBuffer.append(" /*file*/").append(Escape.escape(stringArray[n]));
                    }
                }
            }
        } else if (this.getToken((int)(n3 + 1)).tok == 1073742010 || this.theTok == 2 || this.theTok == 7 || this.theTok == 0x10100040 || this.theTok == 1073742195 || this.theTok == 0x10000A || this.theTok == 8 || this.theTok == 0x40000100 || this.theTok == 1073741877 || this.theTok == 1073742163 || this.theTok == 1073742114 || this.theTok == 1073742152 || this.theTok == 1614417948 || this.theTok == 1073742066 || this.theTok == 0x40000074 && this.tokAt(n3 + 3) != 0x100006 || this.theTok == 0x40000000 && this.tokAt(n3 + 3) != 0x100006) {
            int n10;
            Object object3;
            string3 = this.parameterAsString(n9);
            if (string3.length() == 0 && (string3 = this.viewer.getFullPathName()) == null) {
                this.zap(false);
                return;
            }
            if (n9 == n3) {
                ++n3;
            }
            if (string3.indexOf("[]") >= 0) {
                return;
            }
            n2 = this.tokAt(n3);
            if (n2 == 1073742010) {
                String string10 = this.stringParameter(++n3);
                hashtable.put("manifest", string10);
                string8 = string8 + " MANIFEST " + Escape.escape(string10);
                n2 = this.tokAt(++n3);
            }
            switch (n2) {
                case 2: {
                    int n11 = this.intParameter(n3);
                    string8 = string8 + " " + n11;
                    if (n11 < 0) {
                        hashtable.put("vibrationNumber", -n11);
                    } else {
                        hashtable.put("modelNumber", n11);
                    }
                    n2 = this.tokAt(++n3);
                    break;
                }
                case 7: 
                case 0x10100040: 
                case 1073742195: {
                    object2 = this.floatParameterSet(n3, 1, Integer.MAX_VALUE);
                    n3 = this.iToken;
                    object = new BitSet();
                    for (int i = 0; i < ((float[])object2).length; ++i) {
                        if (!(object2[i] >= 1.0f) || object2[i] != (float)((int)object2[i])) continue;
                        object.set((int)object2[i] - 1);
                    }
                    hashtable.put("bsModels", object);
                    object3 = new int[object.cardinality()];
                    int n12 = 0;
                    n10 = object.nextSetBit(0);
                    while (n10 >= 0) {
                        object3[n12++] = n10 + 1;
                        n10 = object.nextSetBit(n10 + 1);
                    }
                    string8 = string8 + " " + Escape.escapeArray(object3);
                    n2 = this.tokAt(n3);
                }
            }
            Point3f point3f = null;
            if (n2 == 0x10000A || n2 == 8) {
                point3f = this.getPoint3f(n3, false);
                n3 = this.iToken + 1;
                n2 = this.tokAt(n3);
            }
            switch (n2) {
                case 1073741877: 
                case 0x40000100: 
                case 1073742114: 
                case 1073742152: 
                case 1073742163: 
                case 1614417948: {
                    if (point3f == null) {
                        point3f = new Point3f(555.0f, 555.0f, -1.0f);
                    }
                    this.iToken = n3 - 1;
                }
            }
            object2 = null;
            if (point3f != null) {
                hashtable.put("lattice", point3f);
                n3 = this.iToken + 1;
                string8 = string8 + " {" + (int)point3f.x + " " + (int)point3f.y + " " + (int)point3f.z + "}";
                if (this.tokAt(n3) == 0x40000100) {
                    hashtable.put("packed", Boolean.TRUE);
                    string8 = string8 + " PACKED";
                    ++n3;
                }
                if (this.tokAt(n3) == 1073741877) {
                    hashtable.put("centroid", Boolean.TRUE);
                    string8 = string8 + " CENTROID";
                    if (this.tokAt(++n3) == 0x40000100 && !hashtable.containsKey("packed")) {
                        hashtable.put("packed", Boolean.TRUE);
                        string8 = string8 + " PACKED";
                        ++n3;
                    }
                }
                if (this.tokAt(n3) == 1073742163) {
                    if (this.isPoint3f(++n3)) {
                        object3 = this.getPoint3f(n3, false);
                        if (((Point3f)object3).x != (float)((int)((Point3f)object3).x) || ((Point3f)object3).y != (float)((int)((Point3f)object3).y) || ((Point3f)object3).z != (float)((int)((Point3f)object3).z) || ((Point3f)object3).x < 1.0f || ((Point3f)object3).y < 1.0f || ((Point3f)object3).z < 1.0f) {
                            this.iToken = n3;
                            this.error(22);
                        }
                        object = object3;
                        n3 = this.iToken + 1;
                    } else {
                        object = this.stringParameter(n3++);
                    }
                    hashtable.put("supercell", object);
                }
                float f = 0.0f;
                if (this.tokAt(n3) == 1073742114) {
                    int n13 = ++n3;
                    ++n3;
                    f = this.floatParameter(n13);
                    string8 = string8 + " range " + f;
                }
                hashtable.put("symmetryRange", Float.valueOf(f));
                object3 = null;
                n10 = Integer.MIN_VALUE;
                if (this.tokAt(n3) == 1073742152) {
                    int n14 = ++n3;
                    ++n3;
                    object3 = TextFormat.simpleReplace(this.parameterAsString(n14), "''", "\"");
                    string8 = string8 + " spacegroup " + Escape.escape((String)object3);
                    if (((String)object3).equalsIgnoreCase("ignoreOperators")) {
                        n10 = -999;
                    } else {
                        if (((String)object3).length() == 0) {
                            SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                            if (symmetryInterface != null) {
                                object3 = symmetryInterface.getSpaceGroupName();
                            }
                        } else if (((String)object3).indexOf(",") >= 0 && point3f.x < 9.0f && point3f.y < 9.0f && point3f.z == 0.0f) {
                            object3 = (String)object3 + "#doNormalize=0";
                        }
                        hashtable.put("spaceGroupName", object3);
                        n10 = -2;
                    }
                }
                float[] fArray = null;
                if (this.tokAt(n3) == 1614417948) {
                    if (this.optParameterAsString(++n3).length() == 0) {
                        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                        if (symmetryInterface != null) {
                            fArray = symmetryInterface.getUnitCellAsArray(true);
                            object2 = symmetryInterface.getCartesianOffset();
                        }
                    } else {
                        fArray = this.floatParameterSet(n3, 6, 9);
                    }
                    if (fArray == null || fArray.length != 6 && fArray.length != 9) {
                        this.error(22);
                    }
                    string8 = string8 + " unitcell {";
                    for (int i = 0; i < fArray.length; ++i) {
                        string8 = string8 + (i == 0 ? "" : " ") + fArray[i];
                    }
                    string8 = string8 + "}";
                    hashtable.put("unitcell", fArray);
                    if (n10 == Integer.MIN_VALUE) {
                        n10 = -1;
                    }
                }
                n3 = this.iToken + 1;
                if (n10 != Integer.MIN_VALUE) {
                    hashtable.put("spaceGroupIndex", n10);
                }
            }
            if (object2 != null) {
                this.coordinatesAreFractional = false;
            } else if (this.tokAt(n3) == 1073742066) {
                object2 = this.getPoint3f(++n3, true);
            }
            if (object2 != null) {
                if (this.coordinatesAreFractional) {
                    ((Tuple3f)object2).set(this.fractionalPoint);
                    hashtable.put("unitCellOffsetFractional", this.coordinatesAreFractional ? Boolean.TRUE : Boolean.FALSE);
                    string8 = string8 + " offset {" + ((Point3f)object2).x + " " + ((Point3f)object2).y + " " + ((Point3f)object2).z + "/1}";
                } else {
                    string8 = string8 + " offset " + Escape.escape((Tuple3f)object2);
                }
                hashtable.put("unitCellOffset", object2);
                n3 = this.iToken + 1;
            }
            if (this.tokAt(n3) == 0x40000074) {
                string5 = this.stringParameter(++n3);
            }
        } else {
            if (n3 == 1) {
                ++n3;
                stringBuffer.append(" " + string6);
            }
            Point3f point3f = null;
            object2 = null;
            object = new ArrayList();
            block30: while (n3 < this.statementLength) {
                switch (this.tokAt(n3)) {
                    case 0x40000074: {
                        string5 = this.stringParameter(++n3);
                        ++n3;
                        continue block30;
                    }
                    case 0x100006: {
                        hashtable.remove("isTrajectory");
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>();
                            point3f = new Point3f(0.0f, -1.0f, 1.0f);
                        }
                        if (this.isPoint3f(++n3)) {
                            point3f = this.getPoint3f(n3, false);
                            n3 = this.iToken + 1;
                            break;
                        }
                        if (this.tokAt(n3) != 10) break;
                        object2 = (BitSet)this.getToken((int)n3).value;
                        point3f = null;
                        n3 = this.iToken + 1;
                        break;
                    }
                    case 0x40000000: {
                        this.error(22);
                    }
                }
                string3 = this.parameterAsString(n3++);
                object.add(string3);
                if (point3f != null) {
                    arrayList.add(new int[]{(int)point3f.x, (int)point3f.y, (int)point3f.z});
                    stringBuffer.append(" COORD " + Escape.escape(point3f));
                } else if (object2 != null) {
                    arrayList.add(object2);
                    stringBuffer.append(" COORD " + Escape.escape(object2));
                }
                stringBuffer.append(" /*file*/$FILENAME" + object.size() + "$");
            }
            if (arrayList != null) {
                hashtable.put("firstLastSteps", arrayList);
            }
            n6 = object.size();
            stringArray = new String[n6];
            for (int i = 0; i < n6; ++i) {
                stringArray[i] = (String)object.get(i);
            }
            string3 = "fileSet";
        }
        if (!bl) {
            return;
        }
        if (string5 == null) {
            string5 = this.viewer.getDefaultLoadFilter();
        }
        if (string5.length() > 0) {
            hashtable.put("filter", string5);
            if (string5.equalsIgnoreCase("2d")) {
                string5 = "2D-noMin";
            }
            string8 = string8 + " FILTER " + Escape.escape(string5);
        }
        n = 0;
        if (stringArray == null) {
            if (bl3) {
                hashtable.put("fileData", string3);
            } else if (string3.startsWith("@") && string3.length() > 1) {
                n = 1;
                object2 = this.getStringParameter(string3.substring(1), false);
                hashtable.put("fileData", object2);
                stringBuffer = new StringBuffer("{\n    var " + string3.substring(1) + " = " + Escape.escape((String)object2) + ";\n    " + stringBuffer);
            }
        }
        object2 = null;
        if (string4 != null) {
            if (string4.equals(".")) {
                string4 = this.viewer.getFilePath(string3, true);
            }
            if (string4.length() == 0 || this.viewer.getFilePath(string4, false).equalsIgnoreCase(this.viewer.getFilePath(string3, false))) {
                this.error(22);
            }
            if ((object2 = (Object)this.viewer.getOutputStream(string4, (String[])(object = new String[]{string4}))) == null) {
                Logger.error("Could not create output stream for " + object[0]);
            } else {
                hashtable.put("OutputStream", object2);
            }
        }
        if (stringArray == null && n7 == 0) {
            stringBuffer.append(" ");
            if (n != 0 || bl3) {
                stringBuffer.append(Escape.escape(string3));
            } else if (!bl5) {
                if (!string3.equals("string") && !string3.equals("string[]")) {
                    stringBuffer.append("/*file*/");
                }
                if (string4 != null) {
                    string4 = this.viewer.getFilePath(string4, false);
                }
                stringBuffer.append(string4 != null ? Escape.escape(string4) : "$FILENAME$");
            }
            if (string8.length() > 0) {
                stringBuffer.append(" /*options*/ ").append(string8);
            }
            if (n != 0) {
                stringBuffer.append("\n  }");
            }
            hashtable.put("loadScript", stringBuffer);
        }
        this.setCursorWait(true);
        string7 = this.viewer.loadModelFromFile(null, string3, stringArray, null, bl2, hashtable, stringBuffer, n7);
        if (object2 != null) {
            try {
                this.viewer.setFileInfo(new String[]{string4, string4, string4});
                Logger.info(GT._("file {0} created", string4));
                this.showString(this.viewer.getFilePath(string4, false) + " created");
                ((OutputStream)object2).close();
            }
            catch (IOException iOException) {
                Logger.error("error closing file " + iOException.getMessage());
            }
        }
        if (n7 > 0) {
            this.viewer.setFileInfo(stringArray2);
            if (string7 != null && !this.isCmdLine_c_or_C_Option) {
                this.evalError(string7, null);
            }
            return;
        }
        if (string7 != null && !this.isCmdLine_c_or_C_Option) {
            if (string7.indexOf("NOTE: file recognized as a script file: ") == 0) {
                string3 = string7.substring("NOTE: file recognized as a script file: ".length()).trim();
                this.script(0, string3, false);
                return;
            }
            this.evalError(string7, null);
        }
        if (bl2 && (bl6 || n6 > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(n4);
        }
        if (this.scriptLevel == 0 && !bl2 && n6 < 2) {
            this.showString((String)this.viewer.getModelSetAuxiliaryInfo("modelLoadNote"));
        }
        if (this.logMessages) {
            this.scriptStatusOrBuffer("Successfully loaded:" + (stringArray == null ? hashtable.get("fullPathName") : string6));
        }
        if ((object = this.viewer.getModelSetAuxiliaryInfo()) != null && object.containsKey("centroidMinMax") && this.viewer.getAtomCount() > 0) {
            this.viewer.setCentroid(bl2 ? n5 : 0, this.viewer.getAtomCount() - 1, (int[])object.get("centroidMinMax"));
        }
        String string11 = this.viewer.getDefaultLoadScript();
        String string12 = "";
        if (string11.length() > 0) {
            string12 = string12 + "\nUsing defaultLoadScript: " + string11;
        }
        if (object != null && this.viewer.getAllowEmbeddedScripts() && (string2 = (String)object.remove("jmolscript")) != null && string2.length() > 0) {
            string12 = string12 + "\nAdding embedded #jmolscript: " + string2;
            string11 = string11 + ";" + string2;
            this.setStringProperty("_loadScript", string11);
            string11 = "allowEmbeddedScripts = false;try{" + string11 + "} allowEmbeddedScripts = true;";
        }
        this.logLoadInfo(string12);
        String string13 = string = object == null ? null : (String)object.remove("sitescript");
        if (string != null) {
            string11 = string + ";" + string11;
        }
        if (string11.length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript(string11);
        }
    }

    private void logLoadInfo(String string) {
        if (string.length() > 0) {
            Logger.info(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.viewer.getModelCount();
        if (n > 1) {
            stringBuffer.append(n).append(" models\n");
        }
        for (int i = 0; i < n; ++i) {
            Map map = (Map)this.viewer.getModelAuxiliaryInfo(i, "moData");
            if (map == null) continue;
            stringBuffer.append(((List)map.get("mos")).size()).append(" molecular orbitals in model ").append(this.viewer.getModelNumberDotted(i)).append("\n");
        }
        if (stringBuffer.length() > 0) {
            this.showString(stringBuffer.toString());
        }
    }

    private String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.isSyntaxCheck || this.isCmdLine_C_Option ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.error(22);
        }
        return string;
    }

    private void measure() throws ScriptException {
        if (this.tokAt(1) == 135267335) {
            String string = this.stringParameter(this.statementLength == 3 ? 2 : 4);
            if (this.isSyntaxCheck) {
                return;
            }
            JmolNode[] jmolNodeArray = this.viewer.getModelSet().atoms;
            int n = this.viewer.getAtomCount();
            int[][] nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n, this.viewer.getSelectionSet(false), true, false);
            if (nArray == null) {
                return;
            }
            this.setShapeProperty(6, "maps", nArray);
            return;
        }
        switch (this.statementLength) {
            case 1: 
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0: 
                    case 0x10000D: {
                        this.setShapeProperty(6, "hideAll", Boolean.FALSE);
                        return;
                    }
                    case 0x10000C: {
                        this.setShapeProperty(6, "hideAll", Boolean.TRUE);
                        return;
                    }
                    case 1073742001: {
                        if (!this.isSyntaxCheck) {
                            this.showString(this.viewer.getMeasurementInfoAsString(), false);
                        }
                        return;
                    }
                    case 12291: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        this.setShapeProperty(6, "setFormats", this.stringParameter(1));
                        return;
                    }
                }
                this.error(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                switch (this.getToken((int)1).tok) {
                    case 12291: {
                        if (this.getToken((int)2).tok == 0x100003) {
                            if (!this.isSyntaxCheck) {
                                this.viewer.clearAllMeasurements();
                            }
                        } else {
                            int n = this.intParameter(2) - 1;
                            if (!this.isSyntaxCheck) {
                                this.viewer.deleteMeasurement(n);
                            }
                        }
                        return;
                    }
                }
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int[] nArray = new int[5];
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        RadiusData radiusData = null;
        Boolean bl5 = null;
        int n6 = 269484114;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BitSet bitSet = new BitSet();
        Serializable serializable = null;
        TickInfo tickInfo = null;
        int n7 = 0;
        block36: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000000: {
                    this.error(24, "ALL, ALLCONNECTED, DELETE");
                    continue block36;
                }
                default: {
                    this.error(15);
                    continue block36;
                }
                case 0x10100070: {
                    if (this.tokAt(i + 1) != 135266310) {
                        this.error(22);
                    }
                    ++i;
                    bl3 = true;
                    continue block36;
                }
                case 0x100003: 
                case 135266310: 
                case 0x4000000A: {
                    bl2 = this.theTok == 0x4000000A;
                    n4 = -1;
                    bl = true;
                    if (!bl2 || !bl3) continue block36;
                    this.error(22);
                    continue block36;
                }
                case 3: {
                    if (radiusData != null) {
                        this.error(22);
                    }
                    bl = true;
                    bl4 = true;
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = this.floatParameter(i);
                    continue block36;
                }
                case 12291: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 12291;
                    continue block36;
                }
                case 2: {
                    int n8 = this.intParameter(i);
                    if (bl) {
                        bl4 = true;
                        n5 = (n5 + 1) % 2;
                        fArray[n5] = n8;
                        continue block36;
                    }
                    n4 = this.viewer.getAtomIndexFromAtomNumber(n8);
                    if (!this.isSyntaxCheck && n4 < 0) {
                        return;
                    }
                    if (serializable != null) {
                        this.error(22);
                    }
                    if ((nArray[0] = ++n) > 4) {
                        this.error(2);
                    }
                    nArray[n] = n4;
                    continue block36;
                }
                case 1095761933: {
                    n3 = this.intParameter(++i);
                    continue block36;
                }
                case 0x10000C: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000C;
                    continue block36;
                }
                case 0x10000D: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000D;
                    continue block36;
                }
                case 1073742114: {
                    bl = true;
                    bl4 = true;
                    n4 = -1;
                    continue block36;
                }
                case 1073741989: 
                case 1073741990: {
                    bl5 = this.theTok == 1073741989;
                    bl = true;
                    bl3 = this.theTok == 1073741990;
                    continue block36;
                }
                case 1649412112: {
                    if (n5 >= 0) {
                        this.error(22);
                    }
                    radiusData = this.encodeRadiusParameter(i, false, true);
                    radiusData.values = fArray;
                    i = this.iToken;
                    bl3 = true;
                    bl = true;
                    bl5 = false;
                    if (n7 != 1) continue block36;
                    ++n7;
                    ++n;
                    Serializable serializable2 = BitSetUtil.copy(bitSet);
                    BitSetUtil.invertInPlace((BitSet)serializable2, this.viewer.getAtomCount());
                    ((BitSet)serializable2).and(this.viewer.getAtomsWithin(5.0f, bitSet, false, null));
                    arrayList.add(serializable2);
                    continue block36;
                }
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    Serializable serializable2;
                    if (this.theTok == 10 || this.theTok == 0x100001) {
                        ++n7;
                    }
                    if (n4 >= 0) {
                        this.error(22);
                    }
                    this.expressionResult = Boolean.FALSE;
                    serializable = this.centerParameter(i);
                    if (this.expressionResult instanceof BitSet) {
                        bitSet = (BitSet)this.expressionResult;
                        serializable = bitSet;
                        if (!this.isSyntaxCheck && bitSet.length() == 0) {
                            return;
                        }
                    }
                    if (serializable instanceof Point3f) {
                        serializable2 = new Point3fi();
                        ((Tuple3f)serializable2).set((Tuple3f)serializable);
                        ((Point3fi)serializable2).modelIndex = (short)n3;
                        serializable = serializable2;
                    }
                    if ((n = ++n2) > 4) {
                        this.error(2);
                    }
                    i = this.iToken;
                    arrayList.add(serializable);
                    continue block36;
                }
                case 4: {
                    string = this.stringParameter(i);
                    continue block36;
                }
                case 1073742164: {
                    tickInfo = this.checkTicks(i, false, true, true);
                    i = this.iToken;
                    n6 = 1060866;
                }
            }
        }
        if (radiusData != null && (n5 >= 0 || n != 2) || n < 2 && (tickInfo == null || n == 1)) {
            this.error(2);
        }
        if (string != null && string.indexOf(n + ":") != 0) {
            string = n + ":" + string;
        }
        if (bl4 && fArray[1] < fArray[0]) {
            fArray[1] = fArray[0];
            float f = fArray[0] = fArray[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (serializable != null || tickInfo != null) {
            if (radiusData == null) {
                radiusData = new RadiusData(fArray);
            }
            if (serializable == null) {
                tickInfo.id = "default";
            }
            if (serializable != null && string != null && n6 == 269484114) {
                n6 = 1060866;
            }
            this.setShapeProperty(6, "measure", new MeasurementData(this.viewer, arrayList, n6, radiusData, string, null, tickInfo, bl2, bl3, bl5, bl));
            return;
        }
        switch (n6) {
            case 12291: {
                this.setShapeProperty(6, "delete", nArray);
                break;
            }
            case 0x10000D: {
                this.setShapeProperty(6, "show", nArray);
                break;
            }
            case 0x10000C: {
                this.setShapeProperty(6, "hide", nArray);
                break;
            }
            default: {
                this.setShapeProperty(6, string == null ? "toggle" : "toggleOn", nArray);
                if (string == null) break;
                this.setShapeProperty(6, "setFormats", string);
            }
        }
    }

    private String plot(Token[] tokenArray) throws ScriptException {
        String string;
        Object object;
        int n;
        int n2 = this.viewer.getCurrentModelIndex();
        if (n2 < 0) {
            this.error(30, "plot");
        }
        n2 = this.viewer.getJmolDataSourceFrame(n2);
        int n3 = tokenArray.length - 1;
        boolean bl = tokenArray != this.statement;
        Token[] tokenArray2 = this.statement;
        if (bl) {
            this.statement = tokenArray;
        }
        int n4 = bl ? 4148 : tokenArray[0].tok;
        int n5 = bl || n4 == 0x8101011 || n4 == 1052714 ? 0 : 1;
        String string2 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        switch (n4) {
            case 4133: 
            case 1052714: 
            case 0x8101011: {
                break;
            }
            case 135176: {
                bl2 = false;
                bl3 = true;
                break;
            }
            case 4148: {
                bl2 = false;
                break;
            }
            case 135270421: {
                bl2 = false;
                if (this.tokAt(n3, tokenArray) == 4) {
                    string2 = this.stringParameter(n3--);
                    break;
                }
                if (this.tokAt(n3 - 1, tokenArray) == 0x100008) {
                    string2 = this.parameterAsString(n3 - 2) + "." + this.parameterAsString(n3);
                    n3 -= 3;
                    break;
                }
                this.statement = tokenArray2;
                this.iToken = this.statement.length;
                this.error(13);
            }
        }
        String string3 = "";
        Object[] objectArray = null;
        String string4 = "";
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        BitSet bitSet = BitSetUtil.copy(this.viewer.getSelectionSet(false));
        String string5 = "; select " + Escape.escape(bitSet) + ";\n ";
        String string6 = this.optParameterAsString(n3).toLowerCase();
        Point3f point3f = null;
        Point3f point3f2 = null;
        int n9 = this.tokAt(n5, tokenArray);
        if (n9 == 4) {
            n9 = Token.getTokFromName((String)tokenArray[n5].value);
        }
        switch (n9) {
            default: {
                this.iToken = 1;
                this.error(22);
                break;
            }
            case 135270407: {
                this.iToken = 1;
                string6 = "data";
                string5 = "";
                break;
            }
            case 1716520973: {
                this.iToken = n5 + 1;
                n6 = this.tokAt(this.iToken++);
                if (!Token.tokAttr(n6, 0x40500000) || !Token.tokAttr(n7 = this.tokAt(this.iToken++), 0x40500000)) {
                    this.error(22);
                }
                if (Token.tokAttr(n8 = this.tokAt(this.iToken), 0x40500000)) {
                    ++this.iToken;
                } else {
                    n8 = 0;
                }
                if (this.tokAt(this.iToken) == 32) {
                    point3f = this.getPoint3f(++this.iToken, false);
                    ++this.iToken;
                }
                if (this.tokAt(this.iToken) == 64) {
                    point3f2 = this.getPoint3f(++this.iToken, false);
                    ++this.iToken;
                }
                string6 = "property " + Token.nameOf(n6) + " " + Token.nameOf(n7) + (n8 == 0 ? "" : " " + Token.nameOf(n8));
                if (bitSet.nextSetBit(0) < 0) {
                    bitSet = this.viewer.getModelUndeletedAtomsBitSet(n2);
                }
                string4 = "select " + Escape.escape(bitSet) + ";\n ";
                break;
            }
            case 1052714: {
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl7 = n3 > n5 && string6.startsWith("r");
                string6 = "ramachandran" + (bl7 ? " r" : "") + (n4 == 135176 ? " draw" : "");
                break;
            }
            case 0x8101011: 
            case 137363468: {
                string3 = " \"" + this.viewer.getQuaternionFrame() + "\"";
                string4 = "set quaternionFrame" + string3 + ";\n  ";
                bl4 = true;
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl5 = string6.startsWith("deriv") || string6.startsWith("diff");
                boolean bl8 = bl6 = bl5 && string6.indexOf("2") > 0;
                if (bl5) {
                    --n3;
                }
                if (string6.equalsIgnoreCase("helix") || string6.equalsIgnoreCase("axis")) {
                    bl3 = true;
                    bl5 = true;
                    n3 = -1;
                }
                if ((string6 = ((n3 <= n5 ? "" : this.optParameterAsString(n3)) + "w").substring(0, 1)).equals("a") || string6.equals("r")) {
                    bl5 = true;
                }
                if (!Parser.isOneOf(string6, "w;x;y;z;r;a")) {
                    this.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                string6 = "quaternion " + string6 + (bl5 ? " difference" : "") + (bl6 ? "2" : "") + (bl3 ? " draw" : "");
            }
        }
        this.statement = tokenArray2;
        if (this.isSyntaxCheck) {
            return "";
        }
        if (bl2 && (n = this.viewer.getJmolDataFrameIndex(n2, string4 = string4 + "plot " + string6)) > 0 && n4 != 135270421 && n4 != 4148) {
            this.viewer.setCurrentModelIndex(n, true);
            return "";
        }
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        Point3f point3f3 = new Point3f(1.0f, 1.0f, 1.0f);
        if (n9 == 1716520973) {
            int n10;
            fArray = this.getBitsetPropertyFloat(bitSet, n6 | 0xE0, point3f == null ? Float.NaN : point3f.x, point3f2 == null ? Float.NaN : point3f2.x);
            fArray2 = this.getBitsetPropertyFloat(bitSet, n7 | 0xE0, point3f == null ? Float.NaN : point3f.y, point3f2 == null ? Float.NaN : point3f2.y);
            if (n8 != 0) {
                fArray3 = this.getBitsetPropertyFloat(bitSet, n8 | 0xE0, point3f == null ? Float.NaN : point3f.z, point3f2 == null ? Float.NaN : point3f2.z);
            }
            if (point3f == null) {
                point3f = new Point3f(ScriptEvaluator.getMinMax(fArray, false, n6), ScriptEvaluator.getMinMax(fArray2, false, n7), ScriptEvaluator.getMinMax(fArray3, false, n8));
            }
            if (point3f2 == null) {
                point3f2 = new Point3f(ScriptEvaluator.getMinMax(fArray, true, n6), ScriptEvaluator.getMinMax(fArray2, true, n7), ScriptEvaluator.getMinMax(fArray3, true, n8));
            }
            Logger.info("plot min/max: " + point3f + " " + point3f2);
            object = new Point3f(point3f2);
            ((Tuple3f)object).add(point3f);
            ((Tuple3f)object).scale(0.5f);
            point3f3.set(point3f2);
            point3f3.sub(point3f);
            point3f3.set(point3f3.x / 200.0f, point3f3.y / 200.0f, point3f3.z / 200.0f);
            if (Token.tokAttr(n6, 1095761920)) {
                point3f3.x = 1.0f;
                ((Point3f)object).x = 0.0f;
            } else if ((double)point3f3.x > 0.1 && point3f3.x <= 10.0f) {
                point3f3.x = 1.0f;
            }
            if (Token.tokAttr(n7, 1095761920)) {
                point3f3.y = 1.0f;
                ((Point3f)object).y = 0.0f;
            } else if ((double)point3f3.y > 0.1 && point3f3.y <= 10.0f) {
                point3f3.y = 1.0f;
            }
            if (Token.tokAttr(n8, 1095761920)) {
                point3f3.z = 1.0f;
                ((Point3f)object).z = 0.0f;
            } else if ((double)point3f3.z > 0.1 && point3f3.z <= 10.0f) {
                point3f3.z = 1.0f;
            }
            if (n8 == 0) {
                point3f3.z = 0.0f;
                point3f2.z = 0.0f;
                point3f.z = 0.0f;
                ((Point3f)object).z = 0.0f;
            }
            for (n10 = 0; n10 < fArray.length; ++n10) {
                fArray[n10] = (fArray[n10] - ((Point3f)object).x) / point3f3.x;
            }
            for (n10 = 0; n10 < fArray2.length; ++n10) {
                fArray2[n10] = (fArray2[n10] - ((Point3f)object).y) / point3f3.y;
            }
            if (n8 != 0) {
                for (n10 = 0; n10 < fArray3.length; ++n10) {
                    fArray3[n10] = (fArray3[n10] - ((Point3f)object).z) / point3f3.z;
                }
            }
            objectArray = new Object[]{bitSet, fArray, fArray2, fArray3, point3f, point3f2, point3f3, object};
        }
        if (n4 == 135270421) {
            return this.viewer.streamFileData(string2, "PLOT", string6, n2, objectArray);
        }
        Object object2 = object = string6.equals("data") ? "1 0 H 0 0 0 # Jmol PDB-encoded data" : this.viewer.getPdbData(n2, string6, objectArray);
        if (n4 == 4148) {
            return object;
        }
        if (Logger.debugging) {
            Logger.info((String)object);
        }
        if (n4 == 135176) {
            this.runScript((String)object);
            return "";
        }
        String[] stringArray = this.viewer.getFileInfo();
        boolean bl9 = this.viewer.getAppendNew();
        this.viewer.setAppendNew(true);
        boolean bl10 = object != null && this.viewer.loadInline((String)object, true) == null;
        this.viewer.setAppendNew(bl9);
        this.viewer.setFileInfo(stringArray);
        if (!bl10) {
            return "";
        }
        int n11 = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(string4, n2, n11 - 1);
        if (n9 != 1716520973) {
            string4 = string4 + ";\n" + string5;
        }
        ModelCollection.StateScript stateScript = this.viewer.addStateScript(string4, true, false);
        float f = 150.0f;
        switch (n9) {
            default: {
                string = "frame 0.0; frame last; reset;select visible;wireframe only;";
                f = 10.0f;
                break;
            }
            case 1716520973: {
                this.viewer.setFrameTitle(n11 - 1, string6 + " plot for model " + this.viewer.getModelNumberDotted(n2));
                float f2 = 3.0f;
                string = "frame 0.0; frame last; reset;select visible; spacefill " + f2 + "; wireframe 0;" + "draw plotAxisX" + n11 + " {100 -100 -100} {-100 -100 -100} \"" + Token.nameOf(n6) + "\";" + "draw plotAxisY" + n11 + " {-100 100 -100} {-100 -100 -100} \"" + Token.nameOf(n7) + "\";";
                if (n8 == 0) break;
                string = string + "draw plotAxisZ" + n11 + " {-100 -100 100} {-100 -100 -100} \"" + Token.nameOf(n8) + "\";";
                break;
            }
            case 1052714: {
                this.viewer.setFrameTitle(n11 - 1, "ramachandran plot for model " + this.viewer.getModelNumberDotted(n2));
                string = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + n11 + " {100 0 0} {-100 0 0} \"phi\";" + "draw ramaAxisY" + n11 + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 0x8101011: 
            case 137363468: {
                this.viewer.setFrameTitle(n11 - 1, string6.replace('w', ' ') + string3 + " for model " + this.viewer.getModelNumberDotted(n2));
                String string7 = Graphics3D.getHexCode(this.viewer.getColixBackgroundContrast());
                string = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + n11 + " color " + string7 + " sphere 100.0 mesh nofill frontonly translucent 0.8;" + "draw quatAxis" + n11 + "X {100 0 0} {-100 0 0} color red \"x\";" + "draw quatAxis" + n11 + "Y {0 100 0} {0 -100 0} color green \"y\";" + "draw quatAxis" + n11 + "Z {0 0 100} {0 0 -100} color blue \"z\";" + "color structure;" + "draw quatCenter" + n11 + "{0 0 0} scale 0.02;";
            }
        }
        this.runScript(string + string5);
        stateScript.setModelIndex(this.viewer.getCurrentModelIndex());
        this.viewer.setRotationRadius(f, true);
        this.shapeManager.loadShape(29);
        this.showString("frame " + this.viewer.getModelNumberDotted(n11 - 1) + (string6.length() > 0 ? " created: " + string6 + (bl4 ? string3 : "") : ""));
        return "";
    }

    private static float getMinMax(float[] fArray, boolean bl, int n) {
        if (fArray == null) {
            return 0.0f;
        }
        switch (n) {
            case 1112539142: 
            case 1112539143: 
            case 1112539144: {
                return bl ? 180 : -180;
            }
            case 1112539140: 
            case 1112539150: {
                return bl ? 360 : 0;
            }
            case 1112539148: {
                return bl ? 1 : -1;
            }
        }
        float f = bl ? -1.0E10f : 1.0E10f;
        int n2 = fArray.length;
        while (--n2 >= 0) {
            float f2 = fArray[n2];
            if (Float.isNaN(f2) || bl != f2 > f) continue;
            f = f2;
        }
        return f;
    }

    private boolean pause() throws ScriptException {
        if (this.isSyntaxCheck) {
            return false;
        }
        String string = this.optParameterAsString(1);
        if (!this.viewer.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.viewer.autoExit || !this.viewer.haveDisplay) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.viewer.scriptStatus("nothing to pause: " + string);
            return false;
        }
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.pauseExecution(true);
        this.viewer.scriptStatus("script execution paused" + string, "script paused for RESUME");
        return true;
    }

    private void print() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(2);
        }
        this.showString(this.parameterExpressionString(1, 0), true);
    }

    private void prompt() throws ScriptException {
        String string = null;
        if (this.statementLength == 1) {
            if (!this.isSyntaxCheck) {
                string = this.getScriptContext().getContextTrace(null, true).toString();
            }
        } else {
            string = this.parameterExpressionString(1, 0);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.prompt(string, "OK", null, true);
        }
    }

    private void refresh() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    private void reset() throws ScriptException {
        if (this.statementLength == 3 && this.tokAt(1) == 135368713) {
            if (!this.isSyntaxCheck) {
                this.viewer.removeFunction(this.stringParameter(2));
            }
            return;
        }
        this.checkLength(-2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.statementLength == 1) {
            this.viewer.reset(false);
            return;
        }
        switch (this.tokAt(1)) {
            case 1073741873: {
                this.viewer.cacheClear();
                return;
            }
            case 0x40000070: {
                this.viewer.resetError();
                return;
            }
            case 1087373323: {
                this.viewer.resetShapes(true);
                return;
            }
            case 135368713: {
                this.viewer.clearFunctions();
                return;
            }
            case 1641025539: {
                BitSet bitSet = new BitSet();
                this.runScript(this.viewer.getDefaultStructure(null, bitSet));
                this.viewer.resetBioshapes(bitSet);
                return;
            }
            case 1649412112: {
                this.viewer.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
                return;
            }
            case 1076887572: {
                this.viewer.resetAromatic();
                return;
            }
            case 1611141175: {
                this.viewer.reset(true);
                return;
            }
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.error(22);
        }
        this.viewer.unsetProperty(string);
    }

    private void restrict() throws ScriptException {
        boolean bl = this.tokAt(1) == 1678770178;
        this.select(bl ? 2 : 1);
        this.restrictSelected(bl, true);
    }

    private void restrictSelected(boolean bl, boolean bl2) {
        if (this.isSyntaxCheck) {
            return;
        }
        BitSet bitSet = BitSetUtil.copy(this.viewer.getSelectionSet(true));
        if (bl2) {
            this.viewer.invertSelection();
            BitSet bitSet2 = this.viewer.getSelectionSubset();
            if (bitSet2 != null) {
                bitSet = BitSetUtil.copy(this.viewer.getSelectionSet(true));
                bitSet.and(bitSet2);
                this.viewer.select(bitSet, false, null, true);
                BitSetUtil.invertInPlace(bitSet, this.viewer.getAtomCount());
                bitSet.and(bitSet2);
            }
        }
        BitSetUtil.andNot(bitSet, this.viewer.getDeletedAtoms());
        boolean bl3 = this.viewer.getBondSelectionModeOr();
        if (!bl) {
            this.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSize(1, 0, null);
        this.setShapeProperty(1, "type", 32768);
        this.setShapeSize(1, 0, null);
        this.setShapeProperty(1, "type", 1023);
        int n = 21;
        while (--n >= 0) {
            if (n == 6) continue;
            this.setShapeSize(n, 0, null);
        }
        this.setShapeProperty(21, "delete", null);
        this.shapeManager.setLabel(null, this.viewer.getSelectionSet(true));
        if (!bl) {
            this.setBooleanProperty("bondModeOr", bl3);
        }
        this.viewer.select(bitSet, false, null, true);
    }

    private void rotate(boolean bl, boolean bl2) throws ScriptException {
        float f;
        Object[] objectArray;
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000D: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 0x10000C: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        BitSet bitSet = null;
        float f2 = Float.MIN_VALUE;
        int n = 0;
        float f3 = Float.MAX_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        List<Point3f> list = null;
        Point3f[] point3fArray = new Point3f[2];
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f2 = null;
        Matrix4f matrix4f = null;
        Matrix3f matrix3f = null;
        int n2 = 1;
        Quaternion quaternion = null;
        boolean bl5 = false;
        List<Point3f> list2 = null;
        BitSet bitSet2 = null;
        Point3f point3f = null;
        Point4f point4f = null;
        boolean bl6 = this.viewer.getAxesOrientationRasmol();
        block23: for (int i = 1; i < this.statementLength; ++i) {
            int n3 = this.getToken((int)i).tok;
            switch (n3) {
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    if (!(n3 != 10 && n3 != 0x100001 || vector3f2 == null && quaternion == null && n != 2)) {
                        bitSet = this.atomExpression(i);
                        list2 = null;
                        bl2 = true;
                        break;
                    }
                    bl4 = true;
                    if (n == 2) {
                        n = 0;
                    }
                    objectArray = this.centerParameter(i, this.viewer.getCurrentModelIndex());
                    if (!this.isSyntaxCheck && n3 == 0x100007 && this.tokAt(i + 2) != 0x10100040) {
                        bl3 = true;
                        vector3f = this.getDrawObjectAxis(this.objectNameParameter(++i), this.viewer.getCurrentModelIndex());
                    }
                    point3fArray[n++] = objectArray;
                    break;
                }
                case 1611141175: {
                    bl = true;
                    continue block23;
                }
                case 0x400000A4: 
                case 1073742030: {
                    bl3 = true;
                    continue block23;
                }
                case 1114638350: {
                    bl2 = true;
                    break;
                }
                case 0x10100030: {
                    continue block23;
                }
                case 2: 
                case 3: {
                    if (bl) {
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            continue block23;
                        }
                        if (f3 == Float.MAX_VALUE) {
                            f3 = f2;
                            f2 = this.floatParameter(i);
                            continue block23;
                        }
                    } else {
                        if (f3 == Float.MAX_VALUE) {
                            f3 = this.floatParameter(i);
                            continue block23;
                        }
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            bl = true;
                            continue block23;
                        }
                    }
                    this.error(22);
                    break;
                }
                case 0x101000A0: {
                    n2 = -1;
                    continue block23;
                }
                case 1112541205: {
                    bl4 = true;
                    vector3f.set(n2, 0.0f, 0.0f);
                    continue block23;
                }
                case 1112541206: {
                    bl4 = true;
                    vector3f.set(0.0f, n2, 0.0f);
                    continue block23;
                }
                case 1112541207: {
                    bl4 = true;
                    vector3f.set(0.0f, 0.0f, bl6 && !bl3 ? -n2 : n2);
                    continue block23;
                }
                case 9: 
                case 0x8101011: {
                    if (n3 == 0x8101011) {
                        ++i;
                    }
                    bl4 = true;
                    quaternion = this.getQuaternionParameter(i);
                    vector3f.set(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    break;
                }
                case 135266307: {
                    bl4 = true;
                    if (this.isPoint3f(++i)) {
                        vector3f.set(this.centerParameter(i));
                        break;
                    }
                    Point4f point4f2 = this.getPoint4f(i);
                    vector3f.set(point4f2.x, point4f2.y, point4f2.z);
                    f3 = point4f2.w;
                    quaternion = new Quaternion(vector3f, f3);
                    break;
                }
                case 0x100004: {
                    bl4 = true;
                    int n4 = this.atomExpression(++i).nextSetBit(0);
                    int n5 = this.atomExpression(++this.iToken).nextSetBit(0);
                    if (n4 < 0 || n5 < 0) {
                        return;
                    }
                    bitSet = this.viewer.getBranchBitSet(n5, n4);
                    bl2 = true;
                    bl3 = true;
                    point3fArray[0] = this.viewer.getAtomPoint3f(n4);
                    point3fArray[1] = this.viewer.getAtomPoint3f(n5);
                    n = 2;
                    break;
                }
                case 4160: {
                    vector3f2 = new Vector3f(this.centerParameter(++i));
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 137363468: {
                    bl5 = true;
                    continue block23;
                }
                case 1297090050: {
                    Object[] objectArray2;
                    int n6 = this.intParameter(++i);
                    if (this.isSyntaxCheck) continue block23;
                    Map<String, Object> map = this.viewer.getSpaceGroupInfo(null);
                    Object[] objectArray3 = objectArray2 = map == null ? null : (Object[])map.get("operations");
                    if (n6 == 0 || objectArray2 == null || objectArray2.length < Math.abs(n6)) {
                        this.error(22);
                    }
                    objectArray2 = (Object[])objectArray2[Math.abs(n6) - 1];
                    vector3f2 = (Vector3f)objectArray2[5];
                    point3f = (Point3f)objectArray2[6];
                    point3fArray[0] = (Point3f)objectArray2[7];
                    if (objectArray2[8] != null) {
                        vector3f = (Vector3f)objectArray2[8];
                    }
                    f3 = ((Integer)objectArray2[9]).intValue();
                    if (n6 < 0) {
                        f3 = -f3;
                        if (vector3f2 != null) {
                            vector3f2.scale(-1.0f);
                        }
                    }
                    if (f3 == 0.0f && point3fArray[0] != null) {
                        vector3f.normalize();
                        point4f = new Point4f();
                        Measure.getPlaneThroughPoint(point3fArray[0], vector3f, point4f);
                    }
                    quaternion = new Quaternion(vector3f, f3);
                    n = point3fArray[0] == null ? 0 : 1;
                    bl3 = true;
                    bl4 = true;
                    bl2 = true;
                    continue block23;
                }
                case 11: 
                case 12: 
                case 135270405: {
                    bl4 = true;
                    if (n3 == 135270405) {
                        float f4;
                        if ((list = this.viewer.getAtomPointVector(bitSet2 = this.atomExpression(++i))) == null) {
                            this.error(22, i);
                        }
                        i = this.iToken;
                        if ((list2 = this.getPointVector(this.getToken(++i), i)) == null || list.size() != list2.size()) {
                            this.error(22, i);
                        }
                        matrix4f = new Matrix4f();
                        point3fArray[0] = new Point3f();
                        n = 1;
                        float f5 = f4 = this.isSyntaxCheck ? 0.0f : Measure.getTransformMatrix4(list, list2, matrix4f, point3fArray[0]);
                        if ((double)f4 > 0.001) {
                            list2 = null;
                        }
                    } else if (n3 == 12) {
                        matrix4f = (Matrix4f)this.theToken.value;
                    }
                    matrix3f = new Matrix3f();
                    if (matrix4f != null) {
                        vector3f2 = new Vector3f();
                        matrix4f.get(vector3f2);
                        matrix4f.get(matrix3f);
                    } else {
                        matrix3f = (Matrix3f)this.theToken.value;
                    }
                    quaternion = this.isSyntaxCheck ? new Quaternion() : new Quaternion(matrix3f);
                    vector3f.set(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    bl3 = true;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            i = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl2 && bitSet == null) {
            bitSet = this.viewer.getSelectionSet(false);
        }
        if (bitSet2 != null) {
            bl2 = true;
            if (bitSet == null) {
                bitSet = bitSet2;
            }
        }
        float f6 = f2 == Float.MIN_VALUE ? 10.0f : (f3 == Float.MAX_VALUE ? f2 : (f = f2 < 0.0f == f3 > 0.0f ? -f3 / f2 : f2));
        if (quaternion != null) {
            if (n == 0 && vector3f2 != null) {
                point3fArray[0] = this.viewer.getAtomSetCenter(bitSet != null ? bitSet : (bl2 ? this.viewer.getSelectionSet(false) : this.viewer.getModelUndeletedAtomsBitSet(-1)));
            }
            if (bl5 && vector3f2 != null) {
                point3fArray[1] = new Point3f(point3fArray[0]);
                point3fArray[1].add(vector3f2);
                objectArray = (Object[])Measure.computeHelicalAxis(null, 135266306, point3fArray[0], point3fArray[1], quaternion);
                point3fArray[0] = (Point3f)objectArray[0];
                float f7 = ((Point3f)objectArray[3]).x;
                if (f7 != 0.0f) {
                    vector3f2 = (Vector3f)objectArray[1];
                    vector3f = new Vector3f(vector3f2);
                    if (f7 < 0.0f) {
                        vector3f.scale(-1.0f);
                    }
                }
                matrix4f = null;
            }
            if (bl && matrix4f == null) {
                matrix4f = ScriptMathProcessor.getMatrix4f(quaternion.getMatrix(), vector3f2);
            }
            if (point3fArray[0] != null) {
                n = 1;
            }
        }
        if (point3f != null) {
            this.viewer.invertAtomCoord(point3f, bitSet);
            if (vector3f == null) {
                return;
            }
        }
        if (point4f != null) {
            this.viewer.invertAtomCoord(point4f, bitSet);
            if (vector3f == null) {
                return;
            }
        }
        if (n < 2) {
            if (!bl3) {
                this.viewer.rotateAxisAngleAtCenter(point3fArray[0], vector3f, f, f3, bl, bitSet);
                return;
            }
            if (n == 0) {
                point3fArray[0] = new Point3f();
            }
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].add(vector3f);
            n = 2;
        }
        if (n == 0) {
            point3fArray[0] = new Point3f();
        }
        if (n < 2 || point3fArray[0].distance(point3fArray[1]) == 0.0f) {
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].y = (float)((double)point3fArray[1].y + 1.0);
        }
        if (f3 == Float.MAX_VALUE) {
            f3 = 0.0f;
        }
        if (f3 != 0.0f && vector3f2 != null && !bl4) {
            vector3f2.scale(f3 / vector3f2.length());
        }
        if (bl && vector3f2 != null && (f3 == 0.0f || f2 == 0.0f)) {
            f3 = 0.01f;
            f = f2 == Float.MIN_VALUE ? 0.01f : (f2 < 0.0f ? -f3 / f2 : f2 * 0.01f / vector3f2.length());
            f2 = 0.01f;
        }
        if (bitSet != null && bl && list2 == null && matrix4f != null) {
            list = this.viewer.getAtomPointVector(bitSet);
            list2 = Measure.transformPoints(list, matrix4f, point3fArray[0]);
        }
        if (bitSet != null && !bl && list2 != null) {
            this.viewer.setAtomCoord(bitSet, 1146095626, list2);
        } else {
            this.viewer.rotateAboutPointsInternal(point3fArray[0], point3fArray[1], f, f3, bl, bitSet, vector3f2, list2);
        }
    }

    private Quaternion getQuaternionParameter(int n) throws ScriptException {
        if (this.tokAt(n) == 7) {
            List<ScriptVariable> list = ((ScriptVariable)this.getToken(n)).getList();
            Point4f point4f = null;
            if (list.size() == 0 || (point4f = ScriptVariable.pt4Value(list.get(0))) == null) {
                this.error(22);
            }
            return new Quaternion(point4f);
        }
        return new Quaternion(this.getPoint4f(n));
    }

    List<Point3f> getPointVector(Token token, int n) throws ScriptException {
        switch (token.tok) {
            case 10: {
                return this.viewer.getAtomPointVector((BitSet)token.value);
            }
            case 7: {
                ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
                List<ScriptVariable> list = ((ScriptVariable)token).getList();
                for (int i = 0; i < list.size(); ++i) {
                    Point3f point3f = ScriptVariable.ptValue(list.get(i));
                    if (point3f == null) {
                        return null;
                    }
                    arrayList.add(point3f);
                }
                return arrayList;
            }
        }
        if (n > 0) {
            return this.viewer.getAtomPointVector(this.atomExpression(n));
        }
        return null;
    }

    private Point3f getObjectCenter(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, n, n2};
        return this.getShapeProperty(22, "getCenter", objectArray) || this.getShapeProperty(23, "getCenter", objectArray) || this.getShapeProperty(24, "getCenter", objectArray) || this.getShapeProperty(26, "getCenter", objectArray) ? (Point3f)objectArray[2] : null;
    }

    private Point3f[] getObjectBoundingBox(String string) {
        Object[] objectArray = new Object[]{string, null, null};
        return this.getShapeProperty(23, "getBoundingBox", objectArray) || this.getShapeProperty(24, "getBoundingBox", objectArray) || this.getShapeProperty(26, "getBoundingBox", objectArray) ? (Point3f[])objectArray[2] : null;
    }

    private Vector3f getDrawObjectAxis(String string, int n) {
        Object[] objectArray = new Object[]{string, n, null};
        return this.getShapeProperty(22, "getSpinAxis", objectArray) ? (Vector3f)objectArray[2] : null;
    }

    private void script(int n, String string, boolean bl) throws ScriptException {
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        List<ScriptVariable> list = null;
        if (n == 135287308) {
            this.checkLength(2);
            if (!this.isSyntaxCheck) {
                this.viewer.jsEval(this.parameterAsString(1));
            }
            return;
        }
        if (string == null) {
            n = this.tokAt(1);
            if (n != 4) {
                this.error(16);
            }
            if ((string = this.parameterAsString(1)).equalsIgnoreCase("applet")) {
                String string6 = this.parameterAsString(2);
                string2 = this.parameterExpressionString(3, 0);
                this.checkLast(this.iToken);
                if (this.isSyntaxCheck) {
                    return;
                }
                if (string6.length() == 0 || string6.equals("all")) {
                    string6 = "*";
                }
                if (!string6.equals(".")) {
                    this.viewer.jsEval(string6 + "\u0001" + string2);
                    if (!string6.equals("*")) {
                        return;
                    }
                }
            } else {
                n = this.tokAt(this.statementLength - 1);
                boolean bl5 = bl4 = n == 266298;
                if (string.equalsIgnoreCase("inline")) {
                    string2 = this.parameterExpressionString(2, bl4 ? this.statementLength - 1 : 0);
                    n6 = this.iToken + 1;
                }
                while (string.equalsIgnoreCase("localPath") || string.equalsIgnoreCase("remotePath") || string.equalsIgnoreCase("scriptPath")) {
                    if (string.equalsIgnoreCase("localPath")) {
                        string3 = this.parameterAsString(n6++);
                    } else if (string.equalsIgnoreCase("scriptPath")) {
                        string5 = this.parameterAsString(n6++);
                    } else {
                        string4 = this.parameterAsString(n6++);
                    }
                    string = this.parameterAsString(n6++);
                }
                n = this.tokAt(n6);
                if (n == 1073741878) {
                    bl3 = true;
                    n = this.tokAt(++n6);
                }
                if (n == 1073742050) {
                    bl2 = false;
                    n = this.tokAt(++n6);
                }
                if (n == 1073741998 || n == 0x44100004) {
                    int n7 = ++n6;
                    n4 = n2 = Math.max(this.intParameter(n7), 0);
                    if (this.checkToken(++n6) && (n4 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.error(22);
                    }
                } else if (n == 0x40000042 || n == 0x40000044) {
                    int n8 = ++n6;
                    n3 = Math.max(this.intParameter(n8) - 1, 0);
                    n5 = n3 + 1;
                    if (this.checkToken(++n6) && (n5 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.error(22);
                    }
                }
                if (this.tokAt(n6) == 0x10100010) {
                    list = this.parameterExpressionList(n6, -1, false);
                    n6 = this.iToken + 1;
                }
                this.checkLength(bl4 ? n6 + 1 : n6);
            }
        }
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            bl3 = true;
        }
        boolean bl6 = this.isSyntaxCheck;
        boolean bl7 = this.isCmdLine_c_or_C_Option;
        if (bl3) {
            this.isCmdLine_c_or_C_Option = true;
            this.isSyntaxCheck = true;
        }
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> " + string;
        if (string2 == null ? this.compileScriptFileInternal(string, string3, string4, string5) : this.compileScript(null, string2, false)) {
            this.pcEnd = n5;
            this.lineEnd = n4;
            while (n3 < this.lineNumbers.length && this.lineNumbers[n3] < n2) {
                ++n3;
            }
            this.pc = n3;
            boolean bl8 = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= bl2;
            this.executionStepping |= bl4;
            this.contextVariables = new Hashtable<String, ScriptVariable>();
            this.contextVariables.put("_arguments", ScriptVariable.getVariable(list == null ? (Object)new int[0] : list));
            this.instructionDispatchLoop(bl3 || bl);
            if (this.debugScript && this.viewer.getMessageStyleChime()) {
                this.viewer.scriptStatus("script <exiting>");
            }
            this.isCmdLine_C_Option = bl8;
            this.popContext(false, false);
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext(false, false);
            if (bl7) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.isSyntaxCheck = bl6;
        this.isCmdLine_c_or_C_Option = bl7;
    }

    private void function() throws ScriptException {
        List<ScriptVariable> list;
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String string = (String)this.getToken((int)0).value;
        if (!this.viewer.isFunction(string)) {
            this.error(10);
        }
        List<ScriptVariable> list2 = list = this.statementLength == 1 || this.statementLength == 3 && this.tokAt(1) == 0x10100010 && this.tokAt(2) == 0x10100011 ? null : this.parameterExpressionList(1, -1, false);
        if (this.isSyntaxCheck) {
            return;
        }
        this.runFunction(null, string, list, null, false, true);
    }

    private void sync() throws ScriptException {
        this.checkLength(-3);
        String string = "";
        String string2 = "";
        switch (this.statementLength) {
            case 1: {
                string2 = "*";
                string = "ON";
                break;
            }
            case 2: {
                string2 = this.parameterAsString(1);
                if (string2.indexOf("jmolApplet") == 0 || Parser.isOneOf(string2, "*;.;^")) {
                    string = "ON";
                    if (!this.isSyntaxCheck) {
                        this.viewer.syncScript(string, string2, 0);
                    }
                    string2 = ".";
                    break;
                }
                if (this.tokAt(1) == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.syncScript(null, null, this.intParameter(1));
                    }
                    return;
                }
                string = string2;
                string2 = "*";
                break;
            }
            case 3: {
                if (this.isSyntaxCheck) {
                    return;
                }
                string2 = this.parameterAsString(1);
                String string3 = string = this.tokAt(2) == 528443 ? "GET_GRAPHICS" : this.parameterAsString(2);
                if (this.tokAt(1) != 2) break;
                this.viewer.syncScript(string, null, this.intParameter(1));
                return;
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.syncScript(string, string2, 0);
    }

    private void history(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            int n2 = this.intParameter(this.checkLast(2));
            if (n2 < 0) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        switch (this.getToken((int)this.checkLast((int)1)).tok) {
            case 0x10000D: 
            case 1073741882: {
                if (!this.isSyntaxCheck) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.error(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean bl) throws ScriptException {
        boolean bl2;
        BitSet bitSet = null;
        Boolean bl3 = null;
        int n = 1;
        int n2 = this.tokAt(1);
        switch (n2) {
            case 1073742119: 
            case 1276118017: {
                bl3 = n2 == 1276118017;
                n2 = this.tokAt(++n);
            }
        }
        boolean bl4 = bl2 = n2 == 1087373318;
        if (bl2) {
            n2 = this.tokAt(++n);
        }
        switch (n2) {
            case 0x100007: {
                this.setObjectProperty();
                return;
            }
            case 0: {
                break;
            }
            default: {
                bitSet = this.statementLength == 4 && this.tokAt(2) == 1678770178 ? new Bond.BondSet(BitSetUtil.newBitSet(0, this.viewer.getModelSet().getBondCount())) : this.atomExpression(n);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bitSet instanceof Bond.BondSet) {
            this.viewer.displayBonds((Bond.BondSet)bitSet, bl);
            return;
        }
        this.viewer.display(bitSet, bl, bl2, bl3, this.tQuiet);
    }

    private void delete() throws ScriptException {
        if (this.statementLength == 1) {
            this.zap(true);
            return;
        }
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BitSet bitSet = this.atomExpression(this.statement, 1, 0, true, false, true, false);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, false);
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
    }

    private void minimize() throws ScriptException {
        BitSet bitSet = null;
        int n = Integer.MAX_VALUE;
        float f = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        BitSet bitSet2 = null;
        MinimizerInterface minimizerInterface = this.viewer.getMinimizer(false);
        block12: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000004: {
                    bl = true;
                    continue block12;
                }
                case 1073741874: 
                case 1073742162: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty(this.parameterAsString(i), null);
                    return;
                }
                case 1073741882: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty("clear", null);
                    return;
                }
                case 0x40000046: {
                    if (i != 1) {
                        this.error(22);
                    }
                    int n2 = 0;
                    float f2 = 0.0f;
                    int[] nArray = new int[5];
                    if (this.tokAt(++i) == 1073741882) {
                        this.checkLength(3);
                    } else {
                        while (n2 < 4 && !this.isFloatParameter(i)) {
                            nArray[++n2] = this.atomExpression(i).nextSetBit(0);
                            i = this.iToken + 1;
                        }
                        nArray[0] = n2;
                        if (n2 == 1) {
                            this.error(22);
                        }
                        f2 = this.floatParameter(this.checkLast(i));
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.getMinimizer(true).setProperty("constraint", new Object[]{nArray, new int[n2], Float.valueOf(f2)});
                    }
                    return;
                }
                case 1073741905: {
                    f = this.floatParameter(++i);
                    continue block12;
                }
                case 1073741935: {
                    n = 0;
                    continue block12;
                }
                case 1060869: {
                    if (i != 1) {
                        this.error(22);
                    }
                    if ((bitSet2 = this.atomExpression(++i)).nextSetBit(0) < 0) {
                        bitSet2 = null;
                    }
                    i = this.iToken;
                    if (!this.isSyntaxCheck) {
                        this.viewer.getMinimizer(true).setProperty("fixed", bitSet2);
                    }
                    if (i + 1 != this.statementLength) continue block12;
                    return;
                }
                case 135280132: {
                    bitSet = this.atomExpression(++i);
                    i = this.iToken;
                    continue block12;
                }
                case 0x40000144: {
                    bl2 = true;
                    continue block12;
                }
                case 266298: {
                    n = this.intParameter(++i);
                    continue block12;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.minimize(n, f, bitSet, bitSet2, 0.0f, bl, bl2, false);
        }
    }

    private void select(int n) throws ScriptException {
        Object object;
        if (this.statementLength == 1) {
            this.viewer.select(null, false, null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        if (this.statementLength == 2 && this.tokAt(1) == 1073742072) {
            return;
        }
        this.viewer.setNoneSelected(this.statementLength == 4 && this.tokAt(2) == 0x10000B);
        if (this.tokAt(2) == 10 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 1678770178 && this.getToken((int)3).tok == 10) {
            if (this.statementLength == this.iToken + 2) {
                if (!this.isSyntaxCheck) {
                    this.viewer.selectBonds((BitSet)this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        if (this.getToken((int)2).tok == 1746538509) {
            if (this.statementLength == 5 && this.getToken((int)3).tok == 10) {
                if (!this.isSyntaxCheck) {
                    this.setShapeProperty(6, "select", this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        Object object2 = null;
        Boolean bl = null;
        boolean bl2 = false;
        if (this.getToken((int)1).intValue == 0) {
            object = this.parameterExpressionToken((int)0).value;
            if (!(object instanceof BitSet)) {
                this.error(22);
            }
            this.checkLast(this.iToken);
            object2 = (BitSet)object;
        } else {
            int n2 = this.tokAt(n);
            switch (n2) {
                case 1073742119: 
                case 1276118017: {
                    bl = n2 == 1276118017;
                    n2 = this.tokAt(++n);
                }
            }
            boolean bl3 = bl2 = n2 == 1087373318;
            if (bl2) {
                n2 = this.tokAt(++n);
            }
            object2 = this.atomExpression(n);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds((BitSet)object2);
        } else {
            if (((BitSet)object2).length() > this.viewer.getAtomCount()) {
                object = this.viewer.getModelUndeletedAtomsBitSet(-1);
                ((BitSet)object).and((BitSet)object2);
                object2 = object;
            }
            this.viewer.select((BitSet)object2, bl2, bl, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BitSet bitSet = null;
        if (!this.isSyntaxCheck) {
            this.viewer.setSelectionSubset(null);
        }
        if (!(this.statementLength == 1 || this.statementLength == 4 && this.getToken((int)2).value.equals("off"))) {
            bitSet = this.atomExpression(1);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setSelectionSubset(bitSet);
        }
    }

    private void invertSelected() throws ScriptException {
        Point3f point3f = null;
        Point4f point4f = null;
        BitSet bitSet = null;
        int n = Integer.MIN_VALUE;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.isSyntaxCheck) {
                    return;
                }
                bitSet = this.viewer.getSelectionSet(false);
                point3f = this.viewer.getAtomSetCenter(bitSet);
                this.viewer.invertAtomCoord(point3f, bitSet);
                return;
            }
            case 528443: {
                n = this.atomExpression(2).nextSetBit(0);
                bitSet = this.atomExpression(this.iToken + 1);
                break;
            }
            case 0x8100010: {
                point3f = this.centerParameter(2);
                break;
            }
            case 135266319: {
                point4f = this.planeParameter(2);
                break;
            }
            case 135267841: {
                point4f = this.hklParameter(2);
            }
        }
        this.checkLength(this.iToken + 1, 1);
        if (point4f == null && point3f == null && n == Integer.MIN_VALUE) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.viewer.invertSelected(point3f, point4f, n, bitSet);
    }

    private void translate(boolean bl) throws ScriptException {
        char c;
        float f;
        BitSet bitSet = null;
        int n = 1;
        if (this.tokAt(1) == 1114638350) {
            bl = true;
            ++n;
        }
        if (this.isPoint3f(n)) {
            Point3f point3f = this.getPoint3f(n, true);
            bitSet = !bl && this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
            this.checkLast(this.iToken);
            if (!this.isSyntaxCheck) {
                this.viewer.setAtomCoordRelative(point3f, bitSet);
            }
            return;
        }
        int n2 = this.getToken((int)n).tok;
        if (n2 != 1112541205 && n2 != 1112541206 && n2 != 1112541207) {
            this.error(0);
        }
        if ((f = this.floatParameter(++n)) == 0.0f) {
            return;
        }
        switch (this.tokAt(++n)) {
            case 0: 
            case 10: 
            case 0x100001: {
                c = '\u0000';
                break;
            }
            default: {
                c = (this.optParameterAsString(n).toLowerCase() + '\u0000').charAt(0);
            }
        }
        int n3 = this.iToken = c == '\u0000' ? 2 : 3;
        bitSet = bl ? this.viewer.getSelectionSet(false) : (this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null);
        this.checkLast(this.iToken);
        if (!this.isSyntaxCheck) {
            this.viewer.translate(this.parameterAsString(1).charAt(0), f, c, bitSet);
        }
    }

    private void zap(boolean bl) throws ScriptException {
        boolean bl2;
        if (this.statementLength == 1 || !bl) {
            this.viewer.zap(true, bl && !this.isStateScript, true);
            this.refresh();
            return;
        }
        BitSet bitSet = this.atomExpression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, true);
        boolean bl3 = bl2 = this.tQuiet || this.scriptLevel > this.scriptReportingLevel;
        if (!bl2) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
        this.viewer.select(null, false, null, bl2);
    }

    private void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.statementLength > 1 ? this.getToken((int)1).tok : 0x10000D;
            switch (n) {
                case 1073741980: 
                case 0x400000FF: {
                    break;
                }
                case 0x10000C: 
                case 0x10000D: {
                    if (this.statementLength > 2) {
                        this.error(2);
                    }
                    if (!this.isSyntaxCheck) {
                        this.setBooleanProperty("zoomEnabled", n == 0x10000D);
                    }
                    return;
                }
            }
        }
        Point3f point3f = null;
        int n = 1;
        float f2 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            --n;
            f = 0.0f;
        }
        int n2 = 0;
        BitSet bitSet = null;
        if (this.isCenterParameter(n)) {
            n2 = n;
            point3f = this.centerParameter(n);
            if (this.expressionResult instanceof BitSet) {
                bitSet = (BitSet)this.expressionResult;
            }
            n = this.iToken + 1;
        } else if (this.tokAt(n) == 2 && this.getToken((int)n).intValue == 0) {
            bitSet = this.viewer.getAtomBitSet("visible");
            point3f = this.viewer.getAtomSetCenter(bitSet);
        }
        boolean bl2 = false;
        float f3 = this.viewer.getZoomSetting();
        float f4 = this.getZoom(n2, n, bitSet, f3);
        n = this.iToken + 1;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        if (n != this.statementLength) {
            f5 = this.floatParameter(n++);
            f6 = this.floatParameter(n++);
        }
        if (n != this.statementLength) {
            this.error(22);
        }
        if (f4 < 0.0f) {
            f4 = -f4;
            if (bl) {
                if (this.statementLength == 1 || bl2) {
                    f4 *= 2.0f;
                } else if (point3f == null) {
                    f4 /= 2.0f;
                }
            }
        }
        float f7 = this.viewer.getMaxZoomPercent();
        if (f4 < 5.0f || f4 > f7) {
            this.numberOutOfRange(5.0f, f7);
        }
        if (!this.viewer.isWindowCentered()) {
            if (point3f != null) {
                BitSet bitSet2 = this.atomExpression(n2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCenterBitSet(bitSet2, false);
                }
            }
            point3f = this.viewer.getRotationCenter();
            if (Float.isNaN(f5)) {
                f5 = this.viewer.getTranslationXPercent();
            }
            if (Float.isNaN(f6)) {
                f6 = this.viewer.getTranslationYPercent();
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (Float.isNaN(f5)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (bl2 && Math.abs(f3 - f4) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(f, point3f, JmolConstants.center, Float.NaN, null, f4, f5, f6, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN);
    }

    private float getZoom(int n, int n2, BitSet bitSet, float f) throws ScriptException {
        float f2;
        float f3 = f2 = this.isFloatParameter(n2) ? this.floatParameter(n2++) : Float.NaN;
        if (f2 == 0.0f || f == 0.0f) {
            float f4 = Float.NaN;
            if (bitSet == null) {
                Point3f[] point3fArray;
                if (this.tokAt(n) == 0x100007 && ((point3fArray = this.getObjectBoundingBox(this.objectNameParameter(n + 1))) == null || (f4 = point3fArray[0].distance(point3fArray[1]) / 2.0f) == 0.0f)) {
                    this.error(22);
                }
            } else {
                f4 = this.viewer.calcRotationRadius(bitSet);
            }
            if (Float.isNaN(f4)) {
                this.error(22);
            }
            f = this.viewer.getRotationRadius() / f4 * 100.0f;
            f2 = Float.NaN;
        }
        if (f2 < 0.0f) {
            f2 += f;
        } else if (Float.isNaN(f2)) {
            int n3 = this.tokAt(n2);
            switch (n3) {
                case 1073741980: 
                case 0x400000FF: {
                    f2 = f * (n3 == 0x400000FF ? 0.5f : 2.0f);
                    ++n2;
                    break;
                }
                case 0x101000A1: 
                case 0x101000B0: 
                case 0x101000B1: {
                    float f5 = this.floatParameter(++n2);
                    ++n2;
                    switch (n3) {
                        case 0x101000B0: {
                            f2 = f / f5;
                            break;
                        }
                        case 0x101000B1: {
                            f2 = f * f5;
                            break;
                        }
                        case 0x101000A1: {
                            f2 = f + f5;
                        }
                    }
                    break;
                }
                default: {
                    f2 = bitSet == null ? -f : f;
                }
            }
        }
        this.iToken = n2 - 1;
        return f2;
    }

    private void delay() throws ScriptException {
        long l = 0L;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                l = 1L;
                break;
            }
            case 2: {
                l = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                l = (long)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        if (!this.isSyntaxCheck) {
            this.delay(l);
        }
    }

    private void delay(long l) {
        if (this.viewer.isHeadless()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        this.refresh();
        if (l < 0L) {
            l = -l;
        } else {
            int n = this.viewer.getDelayMaximum();
            if (n > 0 && l > (long)n) {
                l = n;
            }
        }
        int n = (int)(l -= System.currentTimeMillis() - l2) / 1000;
        if ((l -= (long)(n * 1000)) <= 0L) {
            l = 1L;
        }
        while (n >= 0 && l > 0L && !this.interruptExecution && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint("delay");
            try {
                Thread.sleep(n-- > 0 ? 1000L : l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint("delay");
        }
    }

    private void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        Point4f point4f = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 9) {
            point4f = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    int n = this.intParameter(this.checkLast(1));
                    if (!this.isSyntaxCheck) {
                        if (bl) {
                            this.viewer.depthToPercent(n);
                        } else {
                            this.viewer.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 0x10000D: {
                    this.checkLength(2);
                    bl2 = true;
                }
                case 0x10000C: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 4141: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 1085443: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x101000A0: {
                    String string = this.parameterAsString(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        point4f = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        point4f = this.planeParameter(3);
                    }
                    if (point4f == null) {
                        this.error(22);
                    }
                    point4f.scale(-1.0f);
                    break;
                }
                case 135266319: {
                    switch (this.getToken((int)2).tok) {
                        case 0x10000B: {
                            break block0;
                        }
                    }
                    point4f = this.planeParameter(2);
                    break;
                }
                case 135267841: {
                    point4f = this.getToken((int)2).tok == 0x10000B ? null : this.hklParameter(2);
                    break;
                }
                case 1073742118: {
                    return;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.slabInternal(point4f, bl);
        }
    }

    private void ellipsoid() throws ScriptException {
        int n = 0;
        int n2 = 1;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                n = 50;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            case 1085443: {
                this.checkLength(3);
                this.shapeManager.loadShape(20);
                this.setShapeProperty(20, "select", this.intParameter(2, 1, 3));
                return;
            }
            case 0x101000B1: 
            case 0x40000000: 
            case 1074790550: {
                this.shapeManager.loadShape(20);
                if (this.theTok == 1074790550) {
                    ++n2;
                }
                this.setShapeId(20, n2, false);
                n2 = this.iToken;
                block17: while (++n2 < this.statementLength) {
                    String string = this.parameterAsString(n2);
                    Object object = null;
                    switch (this.tokAt(n2)) {
                        case 1611272194: {
                            Vector3f[] vector3fArray = new Vector3f[3];
                            for (int i = 0; i < 3; ++i) {
                                vector3fArray[i] = new Vector3f();
                                vector3fArray[i].set(this.centerParameter(++n2));
                                n2 = this.iToken;
                            }
                            object = vector3fArray;
                            break;
                        }
                        case 12289: {
                            object = this.centerParameter(++n2);
                            n2 = this.iToken;
                            break;
                        }
                        case 1766856708: {
                            float f = Float.NaN;
                            if (this.tokAt(n2) == 1766856708) {
                                ++n2;
                            }
                            if ((this.theTok = this.tokAt(n2)) == 1073742180) {
                                object = "translucent";
                                f = this.isFloatParameter(++n2) ? this.getTranslucentLevel(n2++) : this.viewer.getDefaultTranslucent();
                            } else if (this.theTok == 1073742074) {
                                object = "opaque";
                                ++n2;
                            }
                            if (this.isColorParam(n2)) {
                                this.setShapeProperty(20, "color", this.getArgbParam(n2));
                                n2 = this.iToken;
                            }
                            if (object == null) continue block17;
                            if (!Float.isNaN(f)) {
                                this.setShapeProperty(20, "translucentLevel", Float.valueOf(f));
                            }
                            string = "translucency";
                            break;
                        }
                        case 12291: {
                            object = Boolean.TRUE;
                            this.checkLength(3);
                            break;
                        }
                        case 1095761933: {
                            object = this.intParameter(++n2);
                            break;
                        }
                        case 0x10000D: {
                            object = Boolean.TRUE;
                            break;
                        }
                        case 0x10000C: {
                            string = "on";
                            object = Boolean.FALSE;
                            break;
                        }
                        case 1073742138: {
                            object = Float.valueOf(this.floatParameter(++n2));
                        }
                    }
                    if (object == null) {
                        this.error(22);
                    }
                    this.setShapeProperty(20, string.toLowerCase(), object);
                }
                this.setShapeProperty(20, "thisID", null);
                return;
            }
            default: {
                this.error(22);
            }
        }
        this.setShapeSize(20, n, null);
    }

    private String getShapeNameParameter(int n) throws ScriptException {
        String string = this.parameterAsString(n);
        boolean bl = string.equals("*");
        if (string.length() == 0) {
            this.error(22);
        }
        if (bl) {
            switch (this.tokAt(n + 1)) {
                case 0: 
                case 12291: 
                case 0x10000C: 
                case 0x10000D: 
                case 3145768: 
                case 3145770: 
                case 1766856708: {
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(-1, 0, this.tokAt(n + 1))) break;
                    string = string + this.optParameterAsString(++n);
                }
            }
        }
        if (this.tokAt(n + 1) == 0x101000B1) {
            string = string + this.parameterAsString(++n);
        }
        this.iToken = n;
        return string;
    }

    private String setShapeId(int n, int n2, boolean bl) throws ScriptException {
        if (bl) {
            this.error(22);
        }
        String string = this.getShapeNameParameter(n2).toLowerCase();
        this.setShapeProperty(n, "thisID", string);
        return string;
    }

    private void setAtomShapeSize(int n, float f) throws ScriptException {
        RadiusData radiusData = null;
        int n2 = this.tokAt(1);
        boolean bl = false;
        switch (n2) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            case 3: {
                bl = this.floatParameter(1) < 0.0f;
            }
            default: {
                radiusData = this.encodeRadiusParameter(1, bl, true);
                if (!Float.isNaN(radiusData.value)) break;
                this.error(22);
            }
        }
        if (radiusData == null) {
            radiusData = new RadiusData(f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
        }
        if (bl) {
            this.restrictSelected(false, false);
        }
        this.setShapeSize(n, radiusData);
    }

    private RadiusData encodeRadiusParameter(int n, boolean bl, boolean bl2) throws ScriptException {
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        EnumVdw enumVdw = null;
        int n2 = n == -1 ? 1649412112 : this.getToken((int)n).tok;
        switch (n2) {
            case 1112539137: 
            case 1112539138: 
            case 1112541195: 
            case 1112541199: 
            case 1114638346: 
            case 1649412112: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                enumVdw = n2 == 1649412112 ? null : EnumVdw.getVdwType2(Token.nameOf(n2));
                n2 = this.tokAt(++n);
            }
        }
        switch (n2) {
            case 4141: {
                return this.viewer.getDefaultRadiusData();
            }
            case 1073741852: 
            case 0x40000020: 
            case 0x40000022: 
            case 1073741992: 
            case 1073742116: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                this.iToken = n - 1;
                break;
            }
            case 2: 
            case 3: 
            case 0x101000A1: {
                if (n2 == 0x101000A1) {
                    ++n;
                } else {
                    if (this.tokAt(n + 1) == 269484210) {
                        f = Math.round(this.floatParameter(n));
                        this.iToken = ++n;
                        enumType = RadiusData.EnumType.FACTOR;
                        if (f < 0.0f || f > 200.0f) {
                            this.integerOutOfRange(0, 200);
                        }
                        f /= 100.0f;
                        break;
                    }
                    if (n2 == 2) {
                        f = this.intParameter(n);
                        if (f > 749.0f || f < -200.0f) {
                            this.integerOutOfRange(-200, 749);
                        }
                        if (f > 0.0f) {
                            f /= 250.0f;
                            enumType = RadiusData.EnumType.ABSOLUTE;
                            break;
                        }
                        f /= -100.0f;
                        enumType = RadiusData.EnumType.FACTOR;
                        break;
                    }
                }
                f = this.floatParameter(n, bl || !bl2 ? -16 : 0, 16.0f);
                if (n2 == 0x101000A1 || !bl2) {
                    enumType = RadiusData.EnumType.OFFSET;
                } else {
                    enumType = RadiusData.EnumType.ABSOLUTE;
                    enumVdw = EnumVdw.NADA;
                }
                if (!bl) break;
                f = -f;
                break;
            }
            default: {
                if (f != 1.0f) break;
                --n;
            }
        }
        if (enumVdw == null && (enumVdw = EnumVdw.getVdwType(this.optParameterAsString(++this.iToken))) == null) {
            this.iToken = n;
            enumVdw = EnumVdw.AUTO;
        }
        return new RadiusData(f, enumType, enumVdw);
    }

    private void structure() throws ScriptException {
        EnumStructure enumStructure = EnumStructure.getProteinStructureType(this.parameterAsString(1));
        if (enumStructure == EnumStructure.NOT) {
            this.error(22);
        }
        BitSet bitSet = null;
        switch (this.tokAt(2)) {
            case 10: 
            case 0x100001: {
                bitSet = this.atomExpression(2);
                this.checkLast(this.iToken);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.viewer.setProteinType(enumStructure, bitSet);
    }

    private void wireframe() throws ScriptException {
        int n = Integer.MIN_VALUE;
        if (this.tokAt(1) == 4141) {
            this.checkLast(1);
        } else {
            n = this.getMadParameter();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", 1023);
        this.setShapeSize(1, n == Integer.MIN_VALUE ? 300 : n, null);
    }

    private void ssbond() throws ScriptException {
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 256);
        this.setShapeSize(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void struts() throws ScriptException {
        boolean bl = this.tokAt(1) == 1073742072 || this.tokAt(1) == 0x10000D || this.statementLength == 1;
        int n = this.getMadParameter();
        if (bl) {
            n = (int)(this.viewer.getStrutDefaultRadius() * 2000.0f);
        }
        this.setShapeProperty(1, "type", 32768);
        this.setShapeSize(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void hbond() throws ScriptException {
        if (this.statementLength == 2 && this.getToken((int)1).tok == 4102) {
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.viewer.autoHbond(null, null, false);
            this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", Math.abs(n)));
            return;
        }
        if (this.statementLength == 2 && this.getToken((int)1).tok == 12291) {
            if (this.isSyntaxCheck) {
                return;
            }
            this.connect(0);
            return;
        }
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSize(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void configuration() throws ScriptException {
        BitSet bitSet;
        if (this.statementLength == 1) {
            bitSet = this.viewer.setConformation();
            this.viewer.addStateScript("select", null, this.viewer.getSelectionSet(false), null, "configuration", true, false);
        } else {
            int n = this.intParameter(this.checkLast(1));
            if (this.isSyntaxCheck) {
                return;
            }
            bitSet = this.viewer.getConformation(this.viewer.getCurrentModelIndex(), n - 1, true);
            this.viewer.addStateScript("configuration " + n + ";", true, false);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSize(1, 0, bitSet);
        this.viewer.autoHbond(bitSet, bitSet, true);
        this.viewer.select(bitSet, false, null, this.tQuiet);
    }

    private void vector() throws ScriptException {
        RadiusData.EnumType enumType = RadiusData.EnumType.SCREEN;
        float f = 1.0f;
        this.checkLength(-3);
        this.iToken = this.statementLength;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        break block0;
                    }
                    case 0x10000C: {
                        f = 0.0f;
                        break block0;
                    }
                    case 2: {
                        f = this.intParameter(1, 0, 19);
                        break block0;
                    }
                    case 3: {
                        enumType = RadiusData.EnumType.ABSOLUTE;
                        f = this.floatParameter(1, 0.0f, 3.0f);
                        break block0;
                    }
                }
                this.error(6);
                break;
            }
            case 3: {
                if (this.tokAt(1) != 1073742138) break;
                this.setFloatProperty("vectorScale", this.floatParameter(2, -100.0f, 100.0f));
                return;
            }
        }
        this.setShapeSize(18, new RadiusData(f, enumType, null));
    }

    private void dipole() throws ScriptException {
        String string = null;
        Serializable serializable = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.shapeManager.loadShape(17);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(17)) {
            return;
        }
        this.setShapeProperty(17, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(17, "thisID", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            string = null;
            serializable = null;
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    string = "on";
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 12291: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "value";
                    serializable = Float.valueOf(this.floatParameter(i));
                    break;
                }
                case 10: {
                    string = "atomBitset";
                }
                case 0x100001: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    serializable = this.atomExpression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 8: 
                case 0x10000A: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    serializable = point3f;
                    bl2 = true;
                    break;
                }
                case 1678770178: {
                    string = "bonds";
                    break;
                }
                case 4102: {
                    string = "calculate";
                    break;
                }
                case 1074790550: {
                    this.setShapeId(17, ++i, bl3);
                    i = this.iToken;
                    break;
                }
                case 135267329: {
                    string = "cross";
                    serializable = Boolean.TRUE;
                    break;
                }
                case 1073742040: {
                    string = "cross";
                    serializable = Boolean.FALSE;
                    break;
                }
                case 1073742066: {
                    float f = this.floatParameter(++i);
                    if (this.theTok == 2) {
                        string = "offsetPercent";
                        serializable = Integer.valueOf((int)f);
                        break;
                    }
                    string = "offset";
                    serializable = Float.valueOf(f);
                    break;
                }
                case 0x400000F4: {
                    string = "offsetSide";
                    serializable = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1073742188: {
                    string = "value";
                    serializable = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1073742196: {
                    string = "width";
                    serializable = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                default: {
                    if (this.theTok == 0x101000B1 || Token.tokAttr(this.theTok, 0x40000000)) {
                        this.setShapeId(17, i, bl3);
                        i = this.iToken;
                        break;
                    }
                    this.error(22);
                }
            }
            boolean bl4 = bl3 = this.theTok != 12291 && this.theTok != 4102;
            if (string == null) continue;
            this.setShapeProperty(17, string, serializable);
        }
        if (bl2 || bl) {
            this.setShapeProperty(17, "set", null);
        }
    }

    private void animationMode() throws ScriptException {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.statementLength > 5) {
            this.error(2);
        }
        EnumAnimationMode enumAnimationMode = null;
        switch (this.getToken((int)2).tok) {
            case 1073742070: {
                enumAnimationMode = EnumAnimationMode.ONCE;
                f2 = 0.0f;
                f = 0.0f;
                break;
            }
            case 528410: {
                enumAnimationMode = EnumAnimationMode.LOOP;
                break;
            }
            case 1073742082: {
                enumAnimationMode = EnumAnimationMode.PALINDROME;
                break;
            }
            default: {
                this.error(22);
            }
        }
        if (this.statementLength >= 4) {
            f = f2 = this.floatParameter(3);
            if (this.statementLength == 5) {
                f2 = this.floatParameter(4);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationReplayMode(enumAnimationMode, f, f2);
        }
    }

    private void vibration() throws ScriptException {
        this.checkLength(-3);
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                this.checkLength(2);
                f = this.viewer.getVibrationPeriod();
                break;
            }
            case 0x10000C: {
                this.checkLength(2);
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                f = this.floatParameter(1);
                break;
            }
            case 1073742138: {
                this.setFloatProperty("vibrationScale", this.floatParameter(2, -10.0f, 10.0f));
                return;
            }
            case 1073742090: {
                this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                return;
            }
            case 0x40000000: {
                this.error(22);
                break;
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    private void animationDirection() throws ScriptException {
        int n = 2;
        int n2 = 0;
        switch (this.tokAt(n)) {
            case 0x101000A0: {
                n2 = -this.intParameter(++n);
                break;
            }
            case 0x101000A1: {
                n2 = this.intParameter(++n);
                break;
            }
            case 2: {
                n2 = this.intParameter(n);
                if (n2 <= 0) break;
                n2 = 0;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.checkLength(++n);
        if (n2 != 1 && n2 != -1) {
            this.error(35, "-1", "1");
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationDirection(n2);
        }
    }

    private void calculate() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        BitSet bitSet = null;
        int n = Integer.MIN_VALUE;
        this.iToken = this.statementLength;
        if (this.iToken >= 2) {
            this.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 0x40000000: {
                    this.checkLength(2);
                    break;
                }
                case 1076887572: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.assignAromaticBonds();
                    }
                    return;
                }
                case 1612189718: {
                    if (this.statementLength == 2) {
                        if (!this.isSyntaxCheck) {
                            n = this.viewer.autoHbond(null, null, false);
                            break;
                        }
                        return;
                    }
                    BitSet bitSet2 = null;
                    bl2 = this.tokAt(++this.iToken) == 1641025539;
                    bitSet2 = bl2 ? this.viewer.getSelectionSet(false) : this.atomExpression(this.iToken);
                    if (!bl2 && !(bl2 = this.tokAt(++this.iToken) == 1641025539)) {
                        bitSet = this.atomExpression(this.iToken);
                    }
                    if (!this.isSyntaxCheck) {
                        n = this.viewer.autoHbond(bitSet2, bitSet, false);
                        break;
                    }
                    return;
                }
                case 1613758476: {
                    BitSet bitSet3 = this.statementLength == 2 ? null : this.atomExpression(2);
                    this.checkLast(this.iToken);
                    if (!this.isSyntaxCheck) {
                        this.viewer.addHydrogens(bitSet3, false, false);
                    }
                    return;
                }
                case 1112541196: {
                    this.iToken = 1;
                    BitSet bitSet4 = this.statementLength == 2 ? null : this.atomExpression(2);
                    this.checkLast(this.iToken);
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculatePartialCharges(bitSet4);
                    }
                    return;
                }
                case 1073742102: {
                    this.pointGroup();
                    return;
                }
                case 1112539148: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculateStraightness();
                        this.viewer.addStateScript("set quaternionFrame '" + this.viewer.getQuaternionFrame() + "'; calculate straightness", false, true);
                    }
                    return;
                }
                case 1641025539: {
                    BitSet bitSet5 = this.statementLength < 4 ? null : this.atomExpression(2);
                    switch (this.tokAt(++this.iToken)) {
                        case 1052714: {
                            break;
                        }
                        case 1073741915: {
                            bl2 = true;
                            break;
                        }
                        case 0: {
                            bl2 = this.viewer.getDefaultStructureDSSP();
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        this.showString(this.viewer.calculateStructures(bitSet5, bl2, true));
                    }
                    return;
                }
                case 0x1A101A: {
                    BitSet bitSet6 = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
                    bitSet = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
                    this.checkLength(++this.iToken);
                    if (!this.isSyntaxCheck) {
                        n = this.viewer.calculateStruts(bitSet6, bitSet);
                        if (n > 0) {
                            this.colorShape(4, 32768, 0xFFFFFF, "translucent", 0.5f, null);
                        }
                        this.showString(GT._("{0} struts added", n));
                    }
                    return;
                }
                case 3145756: {
                    bl = true;
                }
                case 1112539149: {
                    boolean bl3 = false;
                    switch (this.tokAt(2)) {
                        case 135266324: {
                            ++this.iToken;
                            break;
                        }
                        case 0: {
                            bl3 = !bl;
                            break;
                        }
                        case 0x40000080: {
                            bl3 = true;
                            ++this.iToken;
                            break;
                        }
                        default: {
                            bl3 = true;
                        }
                    }
                    BitSet bitSet7 = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : this.viewer.getSelectionSet(false);
                    this.checkLength(++this.iToken);
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculateSurface(bitSet7, bl3 ? Float.MAX_VALUE : -1.0f);
                    }
                    return;
                }
            }
            if (n != Integer.MIN_VALUE) {
                this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", Math.abs(n)));
                return;
            }
        }
        this.error(53, "CALCULATE", "aromatic? hbonds? hydrogen? partialCharge? pointgroup? straightness? structure? struts? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void pointGroup() throws ScriptException {
        switch (this.tokAt(0)) {
            case 4102: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.calculatePointGroup());
                }
                return;
            }
            case 4148: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getPointGroupAsString(false, null, 0, 0.0f));
                }
                return;
            }
        }
        int n = 2;
        String string = this.tokAt(n) == 1073742138 ? "" : this.optParameterAsString(n);
        float f = 1.0f;
        int n2 = 0;
        if (string.length() > 0 && this.isFloatParameter(++n)) {
            n2 = this.intParameter(n++);
        }
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
        }
        if (!this.isSyntaxCheck) {
            this.runScript(this.viewer.getPointGroupAsString(true, string, n2, f));
        }
    }

    private void dots(int n) throws ScriptException {
        RadiusData radiusData;
        if (!this.isSyntaxCheck) {
            this.shapeManager.loadShape(n);
        }
        this.setShapeProperty(n, "init", null);
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        int n2 = 1;
        switch (this.getToken((int)n2).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                break;
            }
            case 0x10000D: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            case 2: {
                int n3 = this.intParameter(n2);
                if (this.tokAt(n2 + 1) != 1666189314) break;
                ++n2;
                this.setShapeProperty(n, "atom", n3);
                this.setShapeProperty(n, "radius", Float.valueOf(this.floatParameter(++n2)));
                if (this.tokAt(++n2) == 1766856708) {
                    this.setShapeProperty(n, "colorRGB", this.getArgbParam(++n2));
                    ++n2;
                }
                if (this.getToken((int)n2).tok != 10) {
                    this.error(22);
                }
                this.setShapeProperty(n, "dots", this.statement[n2].value);
                return;
            }
        }
        RadiusData radiusData2 = radiusData = Float.isNaN(f) ? this.encodeRadiusParameter(n2, false, true) : new RadiusData(f, enumType, EnumVdw.AUTO);
        if (Float.isNaN(radiusData.value)) {
            this.error(22);
        }
        this.setShapeSize(n, radiusData);
    }

    private void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                if (this.isSyntaxCheck) {
                    return;
                }
                this.restrictSelected(false, false);
                n2 = -1;
                break;
            }
            case 0x10000D: {
                n2 = -1;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 1641025539: {
                n2 = -2;
                break;
            }
            case 1073741922: 
            case 1112541199: {
                n2 = -4;
                break;
            }
            case 2: {
                n2 = this.intParameter(1, 0, 1000) * 8;
                break;
            }
            case 3: {
                n2 = (int)(this.floatParameter(1, -4.0f, 4.0f) * 2000.0f);
                if (n2 >= 0) break;
                this.restrictSelected(false, false);
                n2 = -n2;
                break;
            }
            case 10: {
                if (!this.isSyntaxCheck) {
                    this.shapeManager.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSize(n, n2, null);
    }

    private void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                bl = true;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 4115: {
                this.frame(2);
                break;
            }
            case 1073742024: {
                this.animationMode();
                break;
            }
            case 1073741918: {
                this.animationDirection();
                break;
            }
            case 1074790526: {
                this.setIntProperty("animationFps", this.intParameter(this.checkLast(2)));
                break;
            }
            default: {
                this.frameControl(1);
            }
        }
    }

    private void assign() throws ScriptException {
        Point3f point3f;
        int n = this.tokAt(1);
        int n2 = this.atomExpression(2).nextSetBit(0);
        int n3 = -1;
        String string = null;
        if (n2 < 0) {
            this.error(22);
        }
        if (n == 4106) {
            n3 = this.atomExpression(++this.iToken).nextSetBit(0);
        } else {
            string = this.parameterAsString(++this.iToken);
        }
        Point3f point3f2 = point3f = ++this.iToken < this.statementLength ? this.centerParameter(this.iToken) : null;
        if (this.isSyntaxCheck) {
            return;
        }
        switch (n) {
            case 0x44100001: {
                this.viewer.assignAtom(n2, point3f, string);
                break;
            }
            case 1678770178: {
                this.viewer.assignBond(n2, (string + "p").charAt(0));
                break;
            }
            case 4106: {
                this.viewer.assignConnect(n2, n3);
            }
        }
    }

    private void file() throws ScriptException {
        int n = this.intParameter(this.checkLast(1));
        if (this.isSyntaxCheck) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void fixed() throws ScriptException {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.atomExpression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setMotionFixedAtoms(bitSet);
    }

    private void frame(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = true;
        if (this.statementLength == 1 && n == 1) {
            int n4;
            int n5 = this.viewer.getCurrentModelIndex();
            if (!this.isSyntaxCheck && n5 >= 0 && (n4 = this.viewer.getJmolDataSourceFrame(n5)) >= 0) {
                this.viewer.setCurrentModelIndex(n4 == n5 ? Integer.MIN_VALUE : n4);
            }
            return;
        }
        switch (this.tokAt(1)) {
            case 10: 
            case 0x100001: {
                int n6 = this.atomExpression(1).nextSetBit(0);
                this.checkLength(this.iToken + 1);
                if (this.isSyntaxCheck || n6 < 0) {
                    return;
                }
                BitSet bitSet = new BitSet();
                bitSet.set(n6);
                this.viewer.setCurrentModelIndex(this.viewer.getModelBitSet(bitSet, false).nextSetBit(0));
                return;
            }
            case 1074790550: {
                this.checkLength(3);
                String string = this.stringParameter(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentModelID(string);
                }
                return;
            }
            case 528397: {
                long l = 0L;
                this.checkLength(3);
                switch (this.getToken((int)2).tok) {
                    case 2: 
                    case 3: {
                        l = (long)(this.floatParameter(2) * 1000.0f);
                        break;
                    }
                    default: {
                        this.error(20);
                    }
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setFrameDelayMs(l);
                }
                return;
            }
            case 1073742166: {
                if (this.checkLength23() > 0 && !this.isSyntaxCheck) {
                    this.viewer.setFrameTitle(this.statementLength == 2 ? "@{_modelName}" : (this.tokAt(2) == 7 ? ScriptVariable.listValue(this.statement[2]) : this.parameterAsString(2)));
                }
                return;
            }
            case 0x40000008: {
                BitSet bitSet;
                BitSet bitSet2 = bitSet = this.statementLength == 2 || this.tokAt(2) == 0x10000B ? null : this.atomExpression(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setFrameOffsets(bitSet);
                }
                return;
            }
        }
        if (this.getToken((int)n).tok == 0x101000A0) {
            if (this.getToken((int)this.checkLast((int)(++n))).tok != 2 || this.intParameter(n) != 1) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setAnimation(1073742108);
            }
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int[] nArray = new int[]{-1, -1};
        int n7 = 0;
        float f = 0.0f;
        boolean bl6 = this.viewer.haveFileSet();
        block19: for (n3 = n; n3 < this.statementLength; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 0x100003: 
                case 0x101000B1: {
                    this.checkLength(n + (bl3 ? 2 : 1));
                    bl4 = true;
                    continue block19;
                }
                case 0x101000A0: {
                    if (n7 != 1) {
                        this.error(22);
                    }
                    bl5 = true;
                    continue block19;
                }
                case 0x10000B: {
                    this.checkLength(n + 1);
                    continue block19;
                }
                case 3: {
                    float f2;
                    bl = false;
                    f = this.floatParameter(n3);
                    if (f2 < 0.0f) {
                        this.error(22);
                    }
                }
                case 2: 
                case 4: {
                    if (n7 == 2) {
                        this.error(22);
                    }
                    int n8 = n2 = this.theTok == 4 ? ScriptEvaluator.getFloatEncodedInt((String)this.theToken.value) : this.theToken.intValue;
                    if (n2 < 0 && n7 == 1) {
                        bl5 = true;
                        n2 = -n2;
                        if (bl6 && n2 < 1000000) {
                            n2 *= 1000000;
                        }
                    }
                    if (this.theTok == 3 && bl6 && f == (float)((int)f)) {
                        n2 = (int)f * 1000000;
                    }
                    if (n2 == Integer.MAX_VALUE) {
                        if (n3 == 1) {
                            int n9;
                            String string = this.theToken.value.toString();
                            int n10 = n9 = this.isSyntaxCheck ? -1 : this.viewer.getModelIndexFromId(string);
                            if (n9 >= 0) {
                                this.checkLength(2);
                                this.viewer.setCurrentModelIndex(n9);
                                return;
                            }
                        }
                        n2 = 0;
                    }
                    if (n2 == -1) {
                        this.checkLength(n + 1);
                        if (!this.isSyntaxCheck) {
                            this.viewer.setAnimation(1073742108);
                        }
                        return;
                    }
                    if (n2 >= 1000 && n2 < 1000000 && bl6) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl && n2 == 0 && n7 == 0) {
                        bl4 = true;
                    }
                    if (n2 >= 1000000) {
                        bl = false;
                    }
                    nArray[n7++] = n2;
                    continue block19;
                }
                case 0x40000110: {
                    bl2 = true;
                    continue block19;
                }
                case 1073742114: {
                    bl3 = true;
                    continue block19;
                }
                default: {
                    this.frameControl(n);
                    return;
                }
            }
        }
        if (bl3 && n7 == 0) {
            bl4 = true;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl4) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!bl3) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n7 == 2 && !bl3) {
            bl5 = true;
        }
        if (bl6) {
            bl = false;
        } else if (bl) {
            for (n3 = 0; n3 < n7; ++n3) {
                if (nArray[n3] < 0) continue;
                int n11 = n3;
                nArray[n11] = nArray[n11] % 1000000;
            }
        }
        n3 = this.viewer.getModelNumberIndex(nArray[0], bl, false);
        n2 = -1;
        if (bl6 && n3 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (n7 == 2 && nArray[1] < 1000000) {
                nArray[1] = nArray[1] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n3 = this.viewer.getModelNumberIndex(nArray[0], false, false);
                if (n3 >= 0) {
                    int n12 = n7 == 1 ? nArray[0] + 1000000 : (nArray[1] == 0 ? -1 : (nArray[1] % 1000000 == 0 ? nArray[1] + 1000001 : nArray[1] + 1));
                    n2 = this.viewer.getModelNumberIndex(n12, false, false);
                    if (n2 < 0) {
                        n2 = this.viewer.getModelCount();
                    }
                    --n2;
                    if (bl3) {
                        n7 = 2;
                    } else if (!bl5 && n2 != n3) {
                        bl5 = true;
                    }
                    bl3 = bl3 || n3 == n2;
                }
            } else {
                return;
            }
        }
        if (!bl2 && !bl3 || n3 >= 0) {
            this.viewer.setCurrentModelIndex(n3, false);
        }
        if (bl2 && n7 == 2 || bl3 || bl5) {
            if (n2 < 0) {
                n2 = this.viewer.getModelNumberIndex(nArray[1], bl, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n3, n2);
            this.viewer.setCurrentModelIndex(bl5 && !bl3 ? -1 : (n3 >= 0 ? n3 : 0), false);
        }
        if (bl2) {
            this.viewer.setAnimation(266287);
        }
    }

    BitSet bitSetForModelFileNumber(int n) {
        int n2;
        BitSet bitSet = new BitSet(this.viewer.getAtomCount());
        if (this.isSyntaxCheck) {
            return bitSet;
        }
        int n3 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        if (n < 1000000 && bl) {
            n *= 1000000;
        }
        if ((n2 = n % 1000000) == 0) {
            int n4;
            int n5 = this.viewer.getModelNumberIndex(n + 1, false, false);
            if (n5 < 0) {
                return bitSet;
            }
            int n6 = n4 = n == 0 ? n3 : this.viewer.getModelNumberIndex(n + 1000001, false, false);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = n3;
            }
            if (this.viewer.isTrajectory(n5)) {
                n4 = n5 + 1;
            }
            for (int i = n5; i < n4; ++i) {
                bitSet.or(this.viewer.getModelUndeletedAtomsBitSet(i));
            }
        } else {
            int n7 = this.viewer.getModelNumberIndex(n, false, true);
            if (n7 >= 0) {
                bitSet.or(this.viewer.getModelUndeletedAtomsBitSet(n7));
            }
        }
        return bitSet;
    }

    private void frameControl(int n) throws ScriptException {
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 20487: 
            case 266287: 
            case 1073741942: 
            case 1073741993: 
            case 1073742037: 
            case 0x40000110: 
            case 1073742098: 
            case 1073742108: 
            case 1073742126: {
                if (!this.isSyntaxCheck) {
                    this.viewer.setAnimation(this.theTok);
                }
                return;
            }
        }
        this.error(22);
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JmolConstants.shapeTokenIndex(n);
        if (n2 < 0) {
            this.error(49);
        }
        return n2;
    }

    private void font(int n, float f) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n2 = 0;
        float f2 = -1.0f;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 6: {
                f2 = this.floatParameter(5);
                if (f2 >= 5.0f) {
                    f2 = this.viewer.getZoomSetting() / f2 / this.viewer.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 0x40000000) {
                    this.error(22);
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 0x40000000) {
                    this.error(22);
                }
                string = this.parameterAsString(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                f = this.floatParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    f = this.floatParameter(2);
                    break;
                }
                if (!(f >= 1.0f)) break;
                n2 = 5;
                f += (float)5;
                break;
            }
            default: {
                if (n == 5) {
                    f = 13.0f;
                    break;
                }
                this.error(2);
            }
        }
        if (n == 5) {
            if (f < 0.0f || f >= 1.0f && (f < 6.0f || f > 63.0f)) {
                this.integerOutOfRange(6 - n2, 63 - n2);
            }
            this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (Graphics3D.getFontStyleID(string) >= 0) {
            string2 = string;
            string = "SansSerif";
        }
        Font3D font3D = this.viewer.getFont3D(string, string2, f);
        this.shapeManager.loadShape(n);
        this.setShapeProperty(n, "font", font3D);
        if (f2 >= 0.0f) {
            this.setShapeProperty(n, "scalereference", Float.valueOf(f2));
        }
    }

    private void set() throws ScriptException {
        boolean bl;
        int n;
        Object object;
        String string;
        if (this.statementLength == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean bl2 = this.parameterAsString(0).equals("set");
        String string2 = this.optParameterAsString(1);
        if (bl2 && this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        int n2 = this.getToken((int)1).tok;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        boolean bl3 = !this.isSyntaxCheck && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.statement[0].value).equals("var");
        switch (n2) {
            case 1611272194: {
                this.axes(2);
                return;
            }
            case 1610616835: {
                this.background(2);
                return;
            }
            case 1679429641: {
                this.boundbox(2);
                return;
            }
            case 1611272202: {
                this.frank(2);
                return;
            }
            case 1610616855: {
                this.history(2);
                return;
            }
            case 1826248715: {
                this.label(2);
                return;
            }
            case 1614417948: {
                this.unitcell(2);
                return;
            }
            case 0x20000008: {
                this.shapeManager.loadShape(8);
                this.setShapeProperty(8, "highlight", this.tokAt(2) == 0x10000C ? null : this.atomExpression(2));
                return;
            }
            case 1610625028: 
            case 1611141171: {
                this.selectionHalo(2);
                return;
            }
            case 536875070: {
                this.timeout(2);
                return;
            }
        }
        switch (n2) {
            case 1641025539: {
                float[] fArray;
                EnumStructure enumStructure = EnumStructure.getProteinStructureType(this.parameterAsString(2));
                if (enumStructure == EnumStructure.NOT) {
                    this.error(22);
                }
                if ((fArray = this.floatParameterSet(3, 0, Integer.MAX_VALUE)).length % 4 != 0) {
                    this.error(22);
                }
                this.viewer.setStructureList(fArray, enumStructure);
                this.checkLast(this.iToken);
                return;
            }
            case 545259526: {
                n4 = this.getArgbParam(2);
                if (!this.isSyntaxCheck) {
                    this.setObjectArgb("axes", n4);
                }
                return;
            }
            case 0x60000001: {
                this.setBondmode();
                return;
            }
            case 0x20000004: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n5 = this.tokAt(2) == 0x10000C || this.tokAt(2) == 2 && this.intParameter(2) == 0 ? 4 : 5;
                Logger.setLogLevel(n5);
                this.setIntProperty("logLevel", n5);
                if (n5 == 4) {
                    this.viewer.setDebugScript(false);
                    if (bl3) {
                        this.viewer.showParameter("debugScript", true, 80);
                    }
                }
                this.setDebugging();
                if (bl3) {
                    this.viewer.showParameter("logLevel", true, 80);
                }
                return;
            }
            case 537022465: {
                this.setEcho();
                return;
            }
            case 0x60000002: {
                this.font(5, this.checkLength23() == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 1612189718: {
                this.setHbond();
                return;
            }
            case 0x20021010: 
            case 1746538509: {
                this.setMonitor();
                return;
            }
            case 1611141176: {
                this.setSsbond();
                return;
            }
            case 0x60000005: {
                this.setLabel("toggle");
                return;
            }
            case 0x20000012: {
                this.setUserColors();
                return;
            }
            case 553648188: {
                this.setZslab();
                return;
            }
        }
        boolean bl4 = true;
        switch (n2) {
            case 0x20000002: {
                int n6;
                if (this.statementLength <= 2) break;
                String string3 = this.stringSetting(2, false);
                boolean bl5 = false;
                if (string3.indexOf(".") < 0) {
                    n6 = Parser.parseInt(string3);
                    bl5 = true;
                } else {
                    n6 = ScriptEvaluator.getFloatEncodedInt(string3);
                }
                if (this.isSyntaxCheck) {
                    return;
                }
                int n7 = this.viewer.getModelNumberIndex(n6, bl5, true);
                this.viewer.setBackgroundModelIndex(n7);
                return;
            }
            case 1649412112: {
                if (this.isSyntaxCheck) {
                    return;
                }
                this.viewer.setAtomProperty(this.viewer.getModelUndeletedAtomsBitSet(-1), 1649412112, -1, Float.NaN, null, null, null);
                switch (this.tokAt(2)) {
                    case 1073742109: {
                        this.runScript("#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,'[a]'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733");
                        return;
                    }
                }
                n3 = 545259555;
            }
            case 545259555: {
                if (this.statementLength <= 2) break;
                String string4 = string = this.statementLength == 3 && EnumVdw.getVdwType(this.parameterAsString(2)) == null ? this.stringSetting(2, false) : this.parameterAsString(2);
                if (EnumVdw.getVdwType(string) == null) {
                    this.error(22);
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x20000006: {
                if (this.statementLength <= 2) break;
                object = this.parameterExpressionToken(2);
                Point3f point3f = ((ScriptVariable)object).tok == 8 ? (Point3f)((ScriptVariable)object).value : ((n = ScriptVariable.iValue((Token)object)) < 555 ? new Point3f() : this.viewer.getSymmetry().ijkToPoint3f(n + 111));
                if (this.isSyntaxCheck) break;
                this.viewer.setDefaultLattice(point3f);
                break;
            }
            case 545259545: 
            case 0x20800020: {
                if (this.statementLength <= 2) break;
                this.theTok = this.tokAt(2);
                string = this.theTok == 1073741992 || this.theTok == 1073742116 ? this.parameterAsString(this.checkLast(2)) : this.stringSetting(2, false);
                this.setStringProperty(string2, string);
                break;
            }
            case 1632634889: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setFormalCharges(n4);
                }
                return;
            }
            case 553648148: {
                n4 = this.intSetting(2);
                if (this.isSyntaxCheck) break;
                if (n4 != Integer.MIN_VALUE) {
                    this.commandHistoryLevelMax = n4;
                }
                this.setIntProperty(string2, n4);
                break;
            }
            case 545259564: {
                if (this.statementLength <= 2) break;
                this.setStringProperty(string2, this.stringSetting(2, bl2));
                break;
            }
            case 545259558: 
            case 545259568: {
                if (this.statementLength <= 2) break;
                this.setUnits(this.stringSetting(2, bl2), n2);
                break;
            }
            case 545259572: {
                if (!this.isSyntaxCheck) {
                    this.viewer.setPicked(-1);
                }
                if (this.statementLength <= 2) break;
                this.setPicking();
                return;
            }
            case 545259574: {
                if (this.statementLength <= 2) break;
                this.setPickingStyle();
                return;
            }
            case 1716520973: {
                break;
            }
            case 553648168: {
                n4 = this.intSetting(2);
                if (this.isSyntaxCheck || n4 == Integer.MIN_VALUE) break;
                this.scriptReportingLevel = n4;
                this.setIntProperty(string2, this.scriptReportingLevel);
                break;
            }
            case 0x2000000C: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE || n4 == 0 || n4 == 1) {
                    bl4 = false;
                    break;
                }
                n2 = 553648174;
                string2 = "specularPercent";
                this.setIntProperty(string2, n4);
                break;
            }
            case 1650071565: {
                n2 = 553648178;
                string2 = "strandCount";
                this.setIntProperty(string2, this.intSetting(2));
                break;
            }
            default: {
                bl4 = false;
            }
        }
        if (bl4 && !bl3) {
            return;
        }
        boolean bl6 = bl = !bl4 && !bl2 && this.getContextVariableAsVariable(string2) != null;
        if (!bl4 && !bl) {
            switch (n2) {
                case 1678770178: {
                    n3 = 603979928;
                    break;
                }
                case 0x60300006: {
                    n3 = 603979908;
                    break;
                }
                case 1613758476: {
                    n3 = 603979910;
                    break;
                }
                case 0x60000003: {
                    n3 = 603979878;
                    break;
                }
                case 1666189314: {
                    n3 = 0x22000032;
                    this.setFloatProperty("solventProbeRadius", this.floatSetting(2));
                    bl4 = true;
                    break;
                }
                case 0x60000004: {
                    n3 = 0x2200002E;
                    break;
                }
                case 1613758488: {
                    n3 = 603979948;
                    break;
                }
                case 1766856708: {
                    n3 = 545259545;
                    break;
                }
                case 1611141175: {
                    string = this.parameterAsString(2).toLowerCase();
                    switch ("x;y;z;fps".indexOf(string + ";")) {
                        case 0: {
                            n3 = 570425398;
                            break;
                        }
                        case 2: {
                            n3 = 570425400;
                            break;
                        }
                        case 4: {
                            n3 = 570425402;
                            break;
                        }
                        case 6: {
                            n3 = 570425396;
                            break;
                        }
                        default: {
                            this.error(50, "set SPIN ", string);
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpin(string, (int)this.floatParameter(this.checkLast(3)));
                    }
                    bl4 = true;
                }
            }
        }
        if (n3 != 0) {
            n2 = n3;
            string2 = Token.nameOf(n2);
        } else if (!bl4 && !bl) {
            if (string2.length() == 0 || string2.charAt(0) == '_') {
                this.error(56);
            }
            if (((String)(object = string2.toLowerCase())).indexOf("label") == 0 && Parser.isOneOf(string2.substring(5).toLowerCase(), "front;group;atom;offset;offsetexact;pointer;alignment;toggle;scalereference") && this.setLabel(string2.substring(5))) {
                return;
            }
            if (((String)object).endsWith("callback")) {
                n2 = 0x20000000;
            }
        }
        if (bl2 && !Token.tokAttr(n2, 0x20000000)) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.error(50, "SET", string2);
            }
            this.warning(51, "SET", string2);
        }
        if (!bl4 && bl2) {
            switch (this.statementLength) {
                case 2: {
                    this.setBooleanProperty(string2, true);
                    bl4 = true;
                    break;
                }
                case 3: {
                    if (n4 == Integer.MAX_VALUE) break;
                    this.setIntProperty(string2, n4);
                    bl4 = true;
                }
            }
        }
        if (!bl4 && !bl2 && this.tokAt(2) == 0x10000B) {
            if (!this.isSyntaxCheck) {
                this.viewer.removeUserVariable(string2.toLowerCase());
            }
            bl4 = true;
        }
        if (!bl4) {
            int n8 = this.tokAt(1) == 0x100001 ? 0 : this.tokAt(2);
            n = this.statement[0].intValue;
            int n9 = n8 == 269484436 ? 3 : (n == 61 && !string2.equals("return") && n8 != 269484436 ? 0 : 2);
            this.setVariable(n9, 0, string2, n);
            if (!bl2) {
                return;
            }
        }
        if (bl3) {
            this.viewer.showParameter(string2, true, 80);
        }
    }

    private void setZslab() throws ScriptException {
        Point3f point3f = null;
        if (this.isFloatParameter(2)) {
            this.checkLength(3);
            this.setIntProperty("zSlab", (int)this.floatParameter(2));
        } else {
            if (!this.isCenterParameter(2)) {
                this.error(22);
            }
            point3f = this.centerParameter(2);
            this.checkLength(this.iToken + 1);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setZslabPoint(point3f);
        }
    }

    private void setBondmode() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)this.checkLast((int)2)).tok) {
            case 0x10100060: {
                break;
            }
            case 0x10100050: {
                bl = true;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    private void setEcho() throws ScriptException {
        String string = null;
        Object object = null;
        String string2 = null;
        boolean bl = true;
        int n = 2;
        switch (this.getToken((int)2).tok) {
            case 0x10000C: {
                string = "allOff";
                string2 = "allOff";
                this.checkLength(++n);
                break;
            }
            case 0x10000B: {
                bl = false;
            }
            case 0x100003: {
                string2 = this.parameterAsString(2);
                this.checkLength(++n);
                break;
            }
            case 4: 
            case 12289: 
            case 0x40000000: 
            case 1073741871: 
            case 1073741996: 
            case 1073742019: 
            case 1073742128: 
            case 1074790550: 
            case 1074790748: {
                if (this.theTok == 1074790550) {
                    // empty if block
                }
                int n2 = ++n;
                ++n;
                string2 = this.parameterAsString(n2);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setEchoStateActive(bl);
            this.shapeManager.loadShape(29);
            if (string2 != null) {
                this.setShapeProperty(29, string == null ? "target" : string, string2);
            }
        }
        if (n < this.statementLength) {
            block6 : switch (this.getToken((int)n++).tok) {
                case 0x40000008: {
                    string = "align";
                    switch (this.getToken((int)n).tok) {
                        case 12289: 
                        case 1073741996: 
                        case 1073742128: {
                            object = this.parameterAsString(n++);
                            break block6;
                        }
                    }
                    this.error(22);
                    break;
                }
                case 12289: 
                case 1073741996: 
                case 1073742128: {
                    string = "align";
                    object = this.parameterAsString(n - 1);
                    break;
                }
                case 554176526: {
                    string = "%zpos";
                    object = (int)this.floatParameter(n++);
                    break;
                }
                case 0x10000D: 
                case 3145768: 
                case 1610625028: {
                    string = "hidden";
                    object = Boolean.FALSE;
                    break;
                }
                case 12294: 
                case 3145770: {
                    string = "hidden";
                    object = Boolean.TRUE;
                    break;
                }
                case 1095766028: {
                    int n3;
                    int n4 = n3 = this.isSyntaxCheck ? 0 : this.modelNumberParameter(n++);
                    if (n3 >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    string = "model";
                    object = n3;
                    break;
                }
                case 0x10100040: 
                case 1073742195: {
                    string = "xypos";
                    object = this.xypParameter(--n);
                    if (object == null) {
                        --n;
                        break;
                    }
                    n = this.iToken + 1;
                    break;
                }
                case 2: {
                    int n5 = --n;
                    int n6 = this.intParameter(n5);
                    String string3 = "xpos";
                    if (this.tokAt(++n) == 269484210) {
                        string3 = "%xpos";
                    }
                    string = "ypos";
                    int n7 = ++n;
                    object = this.intParameter(n7);
                    if (this.tokAt(++n) == 269484210) {
                        string = "%ypos";
                        ++n;
                    }
                    this.checkLength(n);
                    this.setShapeProperty(29, string3, n6);
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 1073742138: {
                    string = "scale";
                    object = Float.valueOf(this.floatParameter(n++));
                    break;
                }
                case 135271429: {
                    string = "script";
                    object = this.parameterAsString(n++);
                    break;
                }
                case 4: 
                case 1073741979: {
                    if (this.theTok == 1073741979) {
                        ++n;
                    }
                    this.checkLength(n);
                    this.echo(n - 1, this.theTok == 1073741979);
                    return;
                }
                default: {
                    if (this.isCenterParameter(n - 1)) {
                        string = "xyz";
                        object = this.centerParameter(n - 1);
                        n = this.iToken + 1;
                        break;
                    }
                    this.error(22);
                }
            }
        }
        this.checkLength(n);
        if (!this.isSyntaxCheck && string != null) {
            this.setShapeProperty(29, string, object);
        }
    }

    private int intSetting(int n) throws ScriptException {
        if (n == this.statementLength) {
            return Integer.MIN_VALUE;
        }
        return ScriptVariable.iValue(this.parameterExpressionToken(n));
    }

    private float floatSetting(int n) throws ScriptException {
        if (n == this.statementLength) {
            return Float.NaN;
        }
        return ScriptVariable.fValue(this.parameterExpressionToken(n));
    }

    private String stringSetting(int n, boolean bl) throws ScriptException {
        if (bl && this.statementLength == n + 1) {
            return this.parameterAsString(n);
        }
        return this.parameterExpressionToken(n).asString();
    }

    private boolean setLabel(String string) throws ScriptException {
        this.shapeManager.loadShape(5);
        Object object = null;
        this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        if (string.equals("scalereference")) {
            float f = this.floatParameter(2);
            if (f >= 5.0f) {
                f = this.viewer.getZoomSetting() / f / this.viewer.getScalePixelsPerAngstrom(false);
            }
            object = Float.valueOf(f);
        } else if (string.equals("offset") || string.equals("offsetexact")) {
            int n = this.intParameter(2, -127, 127);
            int n2 = this.intParameter(3, -127, 127);
            object = Object2d.getOffset(n, n2);
        } else if (string.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 12289: 
                case 1073741996: 
                case 1073742128: {
                    string = "align";
                    object = this.theToken.value;
                    break;
                }
                default: {
                    this.error(22);
                    break;
                }
            }
        } else if (string.equals("pointer")) {
            int n = 0;
            switch (this.getToken((int)2).tok) {
                case 0x10000B: 
                case 0x10000C: {
                    break;
                }
                case 1610616835: {
                    n |= 2;
                }
                case 0x10000D: {
                    n |= 1;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            object = n;
        } else {
            boolean bl;
            if (string.equals("toggle")) {
                this.iToken = 1;
                BitSet bitSet = this.statementLength == 2 ? null : this.atomExpression(2);
                this.checkLast(this.iToken);
                if (!this.isSyntaxCheck) {
                    this.viewer.togglePickingLabel(bitSet);
                }
                return true;
            }
            this.iToken = 1;
            boolean bl2 = bl = this.statementLength == 2 || this.getToken((int)2).tok == 0x10000D;
            if (string.equals("front") || string.equals("group")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                if (!bl) {
                    string = "front";
                }
                object = bl ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals("atom")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                string = "front";
                object = bl ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BitSet bitSet = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
        this.checkLast(this.iToken);
        if (this.isSyntaxCheck) {
            return true;
        }
        if (bitSet == null) {
            this.setShapeProperty(5, string, object);
        } else {
            this.setShapeProperty(5, string, object, bitSet);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        int n = this.tokAt(this.checkLast(2));
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                this.setBooleanProperty("measurementlabels", n == 0x10000D);
                return;
            }
            case 2: 
            case 3: 
            case 0x40000066: {
                this.setShapeSize(6, this.getSetAxesTypeMad(2), null);
                return;
            }
        }
        this.setUnits(this.parameterAsString(2), 545259568);
    }

    private boolean setUnits(String string, int n) throws ScriptException {
        if (n == 545259568 && Parser.isOneOf(string.toLowerCase(), "angstroms;au;bohr;nanometers;nm;picometers;pm;vanderwaals;vdw")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setUnits(string, true);
            }
        } else if (n == 545259558 && Parser.isOneOf(string.toLowerCase(), "kcal;kj")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setUnits(string, false);
            }
        } else {
            this.error(50, "set " + Token.nameOf(n), string);
        }
        return true;
    }

    private void setSsbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
                break;
            }
            case 3145754: {
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    private void setHbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
            }
            case 3145754: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 1073742150: {
                bl = true;
            }
            case 0x40000066: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 135280132: 
            case 1611141175: 
            case 1746538509: {
                if (this.checkLength34() != 4) break;
                string = this.parameterAsString(2).toUpperCase();
                if (string.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                n = 3;
                break;
            }
            case 12291: {
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1073742056: {
                string2 = "identify";
                break;
            }
            case 0x10000B: 
            case 0x10000C: {
                string2 = "off";
                break;
            }
            case 135280132: {
                string2 = "atom";
                break;
            }
            case 1826248715: {
                string2 = "label";
                break;
            }
            case 1678770178: {
                string2 = "bond";
                break;
            }
            case 12291: {
                this.checkLength(4);
                if (this.tokAt(3) != 1678770178) {
                    this.error(22);
                }
                string2 = "deleteBond";
            }
        }
        int n2 = string2.indexOf("_");
        n2 = n2 >= 0 ? n2 : string2.length();
        n2 = ActionManager.getPickingMode(string2.substring(0, n2));
        if (n2 < 0) {
            this.error(50, "SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1746538509: {
                bl = true;
                string = "MEASURE";
            }
            case 135280132: {
                if (this.checkLength34() != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000B: 
            case 0x10000C: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 0x10000D: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (ActionManager.getPickingStyle(string2) < 0) {
            this.error(50, "SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void timeout(int n) throws ScriptException {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (this.statementLength == n) {
            this.showString(this.viewer.showTimeout(null));
            return;
        }
        block6: for (int i = n; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1074790550: {
                    string = this.parameterAsString(++i);
                    if (this.statementLength != 3) continue block6;
                    if (!this.isSyntaxCheck) {
                        this.viewer.triggerTimeout(string);
                    }
                    return;
                }
                case 0x10000C: {
                    continue block6;
                }
                case 2: {
                    n2 = this.intParameter(i);
                    continue block6;
                }
                case 3: {
                    n2 = (int)(this.floatParameter(i) * 1000.0f);
                    continue block6;
                }
                default: {
                    if (string == null) {
                        string = this.parameterAsString(i);
                        continue block6;
                    }
                    if (string2 == null) {
                        string2 = this.parameterAsString(i);
                        continue block6;
                    }
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck && !this.viewer.isHeadless()) {
            this.viewer.setTimeout(string, n2, string2);
        }
    }

    private void setUserColors() throws ScriptException {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 2; n < this.statementLength; ++n) {
            int n2 = this.getArgbParam(n);
            arrayList.add(n2);
            n = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = arrayList.size();
        int[] nArray = new int[n];
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = (Integer)arrayList.get(n3);
        }
        this.viewer.setUserScale(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setVariable(int n, int n2, String string, int n3) throws ScriptException {
        boolean bl;
        int n4;
        Object object;
        boolean bl2;
        BitSet bitSet = null;
        String string2 = "";
        int n5 = 0;
        boolean bl3 = n3 == 91;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = string.startsWith("property_");
        ScriptVariable scriptVariable = bl6 ? null : this.getContextVariableAsVariable(string);
        boolean bl7 = bl2 = scriptVariable != null;
        if (n > 0 && this.tokAt(n - 1) == 0x100001) {
            bitSet = this.atomExpression(n - 1);
            n = this.iToken + 1;
            bl5 = true;
        }
        if (this.tokAt(n) == 0x100008) {
            bl4 = true;
            if ((object = this.getBitsetPropertySelector(++n, true)) == null) {
                this.error(22);
            }
            if (this.tokAt(++n) != 269484436) {
                this.error(22);
            }
            ++n;
            n5 = ((ScriptVariable)object).intValue;
            string2 = (String)((ScriptVariable)object).value;
        }
        if (bl5 && !bl4) {
            this.error(22);
        }
        if ((n4 = (object = (List)this.parameterExpression(n, n2, string, true, true, -1, bl3, null, null)).size()) == 0 || !bl3 && n4 > 1 || bl3 && (n4 < 3 || n4 % 2 != 1)) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        ScriptVariable scriptVariable2 = (ScriptVariable)object.get(bl3 ? object.size() - 1 : 0);
        boolean bl8 = bl = !bl2 && !bl5 && !bl6 && (bl3 || bl4 || !(scriptVariable2.value instanceof String) && scriptVariable2.tok != 2 && !(scriptVariable2.value instanceof Integer) && !(scriptVariable2.value instanceof Float) && !(scriptVariable2.value instanceof Boolean));
        if (bl) {
            if (string.startsWith("_")) {
                this.error(22, string);
            }
            scriptVariable = this.viewer.getOrSetNewVariable(string, true);
            bl2 = true;
        }
        if (!bl3) {
            if (bl4) {
                if (!bl5 && (bitSet = ScriptVariable.getBitSet(scriptVariable, true)) == null) {
                    this.error(22);
                }
                if (!string2.startsWith("property_")) {
                    this.setBitsetProperty(bitSet, n5, ScriptVariable.iValue(scriptVariable2), ScriptVariable.fValue(scriptVariable2), scriptVariable2);
                    return;
                }
                this.viewer.setData(string2, new Object[]{string2, scriptVariable2.tok == 7 ? (Object)ScriptVariable.flistValue(scriptVariable2, ((List)scriptVariable2.value).size() == bitSet.cardinality() ? bitSet.cardinality() : this.viewer.getAtomCount()) : scriptVariable2.asString(), BitSetUtil.copy(bitSet)}, this.viewer.getAtomCount(), 0, 0, scriptVariable2.tok == 7 ? Integer.MAX_VALUE : Integer.MIN_VALUE, 0);
                return;
            }
            if (bl2) {
                scriptVariable.set(scriptVariable2, false);
                return;
            }
            Object object2 = ScriptVariable.oValue(scriptVariable2);
            if (string.startsWith("property_")) {
                if (scriptVariable2.tok == 7) {
                    object2 = scriptVariable2.asString();
                }
                this.viewer.setData(string, new Object[]{string, "" + object2, BitSetUtil.copy(this.viewer.getSelectionSet(false))}, this.viewer.getAtomCount(), 0, 0, Integer.MIN_VALUE, 0);
                return;
            }
            if (object2 instanceof Boolean) {
                this.setBooleanProperty(string, (Boolean)object2);
                return;
            }
            if (object2 instanceof Integer) {
                this.setIntProperty(string, (Integer)object2);
                return;
            }
            if (object2 instanceof Float) {
                this.setFloatProperty(string, ((Float)object2).floatValue());
                return;
            }
            if (object2 instanceof String) {
                this.setStringProperty(string, (String)object2);
                return;
            }
            if (object2 instanceof Bond.BondSet) {
                this.setStringProperty(string, Escape.escape((BitSet)object2, false));
                return;
            }
            if (!(object2 instanceof BitSet || object2 instanceof Point3f || object2 instanceof Point4f)) {
                Logger.error("ERROR -- return from propertyExpression was " + object2);
                return;
            }
            this.setStringProperty(string, Escape.escape(object2));
            return;
        }
        ScriptVariable scriptVariable3 = new ScriptVariable().set(scriptVariable2, false);
        int n6 = object.size() / 2;
        int n7 = 0;
        while (n7 < n6) {
            block34: {
                Object object3;
                ScriptVariable scriptVariable4;
                boolean bl9;
                block33: {
                    bl9 = n7 + 1 == n6;
                    scriptVariable4 = (ScriptVariable)object.get(n7 * 2);
                    if (scriptVariable.tok == 10) {
                        scriptVariable.tok = 6;
                        scriptVariable.value = new Hashtable();
                    }
                    if (scriptVariable.tok != 6) break block33;
                    String string3 = scriptVariable4.asString();
                    object3 = (Map)scriptVariable.value;
                    if (bl9) {
                        object3.put(string3, scriptVariable3);
                        return;
                    }
                    scriptVariable = (ScriptVariable)object3.get(string3);
                    break block34;
                }
                int n8 = ScriptVariable.iValue(scriptVariable4);
                if (scriptVariable.tok == 7) {
                    scriptVariable = ScriptVariable.selectItem(scriptVariable);
                }
                switch (scriptVariable.tok) {
                    case 7: {
                        object3 = scriptVariable.getList();
                        if (n8 > object3.size() || bl9) break;
                        if (n8 <= 0) {
                            n8 = object3.size() + n8;
                        }
                        if (--n8 < 0) {
                            n8 = 0;
                        }
                        scriptVariable = (ScriptVariable)object3.get(n8);
                        break block34;
                    }
                    case 11: 
                    case 12: {
                        int n9;
                        int n10;
                        int n11 = n10 = scriptVariable.tok == 11 ? 3 : 4;
                        if (n6 == 1 && Math.abs(n8) >= 1 && Math.abs(n8) <= n10 && scriptVariable3.tok == 7 && scriptVariable3.getList().size() == n10) break;
                        if (n6 == 2 && (n9 = ScriptVariable.iValue((Token)object.get(2))) >= 1 && n9 <= n10 && (scriptVariable3.tok == 2 || scriptVariable3.tok == 3)) {
                            ++n7;
                            n8 = n8 * 10 + n9;
                            break;
                        }
                        scriptVariable.toArray();
                        --n7;
                        break block34;
                    }
                }
                scriptVariable.setSelectedValue(n8, scriptVariable3);
                return;
            }
            ++n7;
        }
    }

    private void axes(int n) throws ScriptException {
        TickInfo tickInfo = this.checkTicks(n, true, true, false);
        n = this.iToken + 1;
        int n2 = this.tokAt(n);
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.statementLength == n + 1 && Parser.isOneOf(string, "window;unitcell;molecular")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        switch (n2) {
            case 12289: {
                Point3f point3f = this.centerParameter(n + 1);
                this.setShapeProperty(30, "origin", point3f);
                this.checkLast(this.iToken);
                return;
            }
            case 1073742138: {
                this.setFloatProperty("axesScale", this.floatParameter(this.checkLast(++n)));
                return;
            }
            case 1826248715: {
                n2 = this.tokAt(n + 1);
                switch (n2) {
                    case 0x10000C: 
                    case 0x10000D: {
                        this.checkLength(n + 2);
                        this.setShapeProperty(30, "labels" + (n2 == 0x10000D ? "On" : "Off"), null);
                        return;
                    }
                }
                if (this.statementLength == n + 7) {
                    this.setShapeProperty(30, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n)});
                } else {
                    this.checkLength(n + 4);
                    this.setShapeProperty(30, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n)});
                }
                return;
            }
        }
        if (string.equals("position")) {
            Point3f point3f;
            if (this.tokAt(++n) == 0x10000C) {
                point3f = new Point3f();
            } else {
                point3f = this.xypParameter(n);
                if (point3f == null) {
                    this.error(22);
                }
                n = this.iToken;
            }
            this.setShapeProperty(30, "position", point3f);
            return;
        }
        int n3 = this.getSetAxesTypeMad(n);
        if (this.isSyntaxCheck) {
            return;
        }
        this.setObjectMad(30, "axes", n3);
        if (tickInfo != null) {
            this.setShapeProperty(30, "tickInfo", tickInfo);
        }
    }

    private void boundbox(int n) throws ScriptException {
        int n2;
        boolean bl;
        TickInfo tickInfo = this.checkTicks(n, false, true, false);
        n = this.iToken + 1;
        float f = 1.0f;
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
            if (!this.isSyntaxCheck && f == 0.0f) {
                this.error(22);
            }
            if (++n == this.statementLength) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(null, null, true, f);
                }
                return;
            }
        }
        boolean bl2 = bl = this.tokAt(n) == 0x4000004E;
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            this.expressionResult = null;
            n2 = n;
            Point3f point3f = this.centerParameter(n);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                Point3f point3f2 = bl ? this.centerParameter(n) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(point3f, point3f2, bl, f);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BitSet) {
                if (!this.isSyntaxCheck) {
                    this.viewer.calcBoundBoxDimensions((BitSet)this.expressionResult, f);
                }
            } else if (this.expressionResult == null && this.tokAt(n2) == 0x100007) {
                Point3f[] point3fArray;
                if (this.isSyntaxCheck) {
                    return;
                }
                if ((point3fArray = this.getObjectBoundingBox(this.objectNameParameter(++n2))) == null) {
                    this.error(22);
                }
                this.viewer.setBoundBox(point3fArray[0], point3fArray[1], true, f);
                n = this.iToken + 1;
            } else {
                this.error(22);
            }
            if (n == this.statementLength) {
                return;
            }
        }
        n2 = this.getSetAxesTypeMad(n);
        if (this.isSyntaxCheck) {
            return;
        }
        if (tickInfo != null) {
            this.setShapeProperty(31, "tickInfo", tickInfo);
        }
        this.setObjectMad(31, "boundbox", n2);
    }

    private TickInfo checkTicks(int n, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        this.iToken = n - 1;
        if (this.tokAt(n) != 1073742164) {
            return null;
        }
        String string = " ";
        switch (this.tokAt(n + 1)) {
            case 1112541205: 
            case 1112541206: 
            case 1112541207: {
                string = this.parameterAsString(++n).toLowerCase();
                break;
            }
            case 0x40000000: {
                this.error(22);
            }
        }
        if (this.tokAt(++n) == 0x10000B) {
            TickInfo tickInfo = new TickInfo(null);
            tickInfo.type = string;
            this.iToken = n;
            return tickInfo;
        }
        TickInfo tickInfo = new TickInfo((Point3f)this.getPointOrPlane(n, false, true, false, false, 3, 3));
        if (this.coordinatesAreFractional || this.tokAt(this.iToken + 1) == 1614417948) {
            tickInfo.scale = new Point3f(Float.NaN, Float.NaN, Float.NaN);
            bl2 = false;
        }
        if (this.tokAt(this.iToken + 1) == 1614417948) {
            ++this.iToken;
        }
        tickInfo.type = string;
        if (this.tokAt(this.iToken + 1) == 1288701960) {
            tickInfo.tickLabelFormats = this.stringParameterSet(this.iToken + 2);
        }
        if (!bl2) {
            return tickInfo;
        }
        if (this.tokAt(this.iToken + 1) == 1073742138) {
            if (this.isFloatParameter(this.iToken + 2)) {
                float f = this.floatParameter(this.iToken + 2);
                tickInfo.scale = new Point3f(f, f, f);
            } else {
                tickInfo.scale = this.getPoint3f(this.iToken + 2, true);
            }
        }
        if (bl3 && this.tokAt(this.iToken + 1) == 1073741942) {
            tickInfo.first = this.floatParameter(this.iToken + 2);
        }
        return tickInfo;
    }

    private void unitcell(int n) throws ScriptException {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        Point3f point3f = null;
        TickInfo tickInfo = this.checkTicks(n, true, false, false);
        n = this.iToken;
        String string = null;
        Point3f[] point3fArray = null;
        switch (this.tokAt(n + 1)) {
            case 4: {
                string = this.objectNameParameter(++n);
                break;
            }
            case 0x100007: {
                ++n;
                string = this.objectNameParameter(++n);
                break;
            }
            default: {
                if (this.isArrayParameter(n + 1)) {
                    point3fArray = this.getPointArray(++n, 4);
                    n = this.iToken;
                    break;
                }
                if (this.statementLength == n + 2) {
                    if (this.getToken((int)(n + 1)).tok != 2 || this.intParameter(n + 1) < 111) break;
                    n2 = this.intParameter(++n);
                    break;
                }
                if (this.statementLength <= n + 1) break;
                point3f = (Point3f)this.getPointOrPlane(++n, false, true, false, true, 3, 3);
                n = this.iToken;
            }
        }
        n3 = this.getSetAxesTypeMad(++n);
        this.checkLast(this.iToken);
        if (this.isSyntaxCheck) {
            return;
        }
        if (n2 != Integer.MAX_VALUE) {
            this.viewer.setCurrentUnitCellOffset(n2);
        } else if (string != null) {
            this.viewer.setCurrentUnitCell(string);
        } else if (point3fArray != null) {
            this.viewer.setCurrentUnitCell(point3fArray);
        }
        this.setObjectMad(32, "unitCell", n3);
        if (point3f != null) {
            this.viewer.setCurrentUnitCellOffset(point3f);
        }
        if (tickInfo != null) {
            this.setShapeProperty(32, "tickInfo", tickInfo);
        }
    }

    private void frank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    private void selectionHalo(int n) throws ScriptException {
        boolean bl = false;
        switch (n == this.statementLength ? 0x10000D : this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1114638350: {
                bl = true;
            }
            case 0x10000B: 
            case 0x10000C: 
            case 1073742056: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void save() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1073742132: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1073742077: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 1073742158: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 1641025539: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveCoordinates(string, this.viewer.getSelectionSet(false));
                    }
                    return;
                }
                case 1073742140: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(53, "SAVE", "bonds? coordinates? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 1073742077) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 1073742132: {
                    float f;
                    float f2 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreRotation(string, f);
                    }
                    return;
                }
                case 1073742077: {
                    float f;
                    float f3 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreOrientation(string, f);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string2 = this.viewer.getSavedCoordinates(string);
                    if (string2 == null) {
                        this.error(22);
                    }
                    this.runScript(string2);
                    this.viewer.checkCoordinatesChanged();
                    return;
                }
                case 1073742158: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string3 = this.viewer.getSavedState(string);
                    if (string3 == null) {
                        this.error(22);
                    }
                    this.runScript(string3);
                    return;
                }
                case 1641025539: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string4 = this.viewer.getSavedStructure(string);
                    if (string4 == null) {
                        this.error(22);
                    }
                    this.runScript(string4);
                    return;
                }
                case 1073742140: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(53, "RESTORE", "bonds? coords? orientation? selection? state? structure?");
    }

    String write(Token[] tokenArray) throws ScriptException {
        Object object;
        boolean bl;
        boolean bl2;
        int n = 0;
        int n2 = 0;
        if (tokenArray == null) {
            tokenArray = this.statement;
            n2 = 1;
            n = 1;
            bl2 = true;
            bl = this.viewer.isApplet() && !this.viewer.isSignedApplet() || !this.viewer.isRestricted(Viewer.ACCESS.ALL) || this.viewer.getPathForAllFiles().length() > 0;
        } else {
            bl2 = false;
            bl = true;
        }
        int n3 = bl2 ? this.statementLength : tokenArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = Integer.MIN_VALUE;
        String string = this.viewer.getExportDriverList();
        String string2 = "PNGJ";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String[] stringArray = new String[1];
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        BitSet bitSet = null;
        String[] stringArray2 = null;
        String string10 = "SPT";
        int n9 = bl2 && tokenArray.length == 1 ? 1073741884 : this.tokAt(n, tokenArray);
        switch (n9) {
            case 0: {
                break;
            }
            case 4: {
                object = Token.getTokenFromName(ScriptVariable.sValue(tokenArray[n]).toLowerCase());
                if (object == null) break;
                n9 = ((Token)object).tok;
                string10 = ScriptVariable.sValue((Token)object).toUpperCase();
                break;
            }
            case 135271429: {
                if (!this.isArrayParameter(n + 1)) break;
                stringArray2 = this.stringParameterSet(++n);
                string6 = ".";
                string7 = ".";
                n2 = n = this.iToken + 1;
                n9 = this.tokAt(n);
                break;
            }
            default: {
                string10 = ScriptVariable.sValue(this.tokenAt(n, tokenArray)).toUpperCase();
            }
        }
        switch (n9) {
            case 0: {
                break;
            }
            case 1052714: 
            case 0x8101011: 
            case 1716520973: {
                string9 = this.plot(tokenArray);
                if (bl2) break;
                return string9;
            }
            case 1073742102: {
                string10 = "PGRP";
                string4 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                if (!string4.equals("draw")) break;
                ++n;
                break;
            }
            case 0x100006: {
                ++n;
                bl3 = true;
                break;
            }
            case 135271429: 
            case 1073742158: {
                string8 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                while (string8.equals("localpath") || string8.equals("remotepath")) {
                    if (string8.equals("localpath")) {
                        string6 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray));
                    } else {
                        string7 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray));
                    }
                    string8 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                }
                string10 = "SPT";
                break;
            }
            case 135180: 
            case 135188: 
            case 0x121012: 
            case 135368713: 
            case 1073742015: 
            case 1073742018: 
            case 1229984263: 
            case 1610616855: {
                ++n;
                break;
            }
            case 1073741992: {
                string10 = "ZIPALL";
                ++n;
                break;
            }
            case 36868: {
                string10 = "VAR";
                n += 2;
                break;
            }
            case 4: 
            case 4115: 
            case 4166: 
            case 0x40000000: 
            case 1073741979: 
            case 1073742139: {
                switch (n9) {
                    case 1073741979: {
                        ++n;
                        break;
                    }
                    case 4166: {
                        n5 = this.intParameter(++n, 1, 10);
                        if (!this.isSyntaxCheck) {
                            this.viewer.setVibrationOff();
                            this.delay(100L);
                        }
                        ++n;
                        break;
                    }
                    case 4115: {
                        if (n + 1 < n3 && tokenArray[++n].tok == 0x100001 || tokenArray[n].tok == 10) {
                            object = this.atomExpression(tokenArray, n, 0, true, false, true, true);
                            n = this.iToken + 1;
                        } else {
                            object = this.viewer.getModelUndeletedAtomsBitSet(-1);
                        }
                        if (this.isSyntaxCheck) break;
                        bitSet = this.viewer.getModelBitSet((BitSet)object, true);
                        break;
                    }
                    case 1073742139: {
                        string8 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toUpperCase();
                        if (!Parser.isOneOf(string8, "PNG;PNGJ")) break;
                        string2 = string8;
                        ++n;
                        break;
                    }
                    default: {
                        if (Parser.isOneOf(string10, string.toUpperCase())) {
                            ++n;
                            string10 = string10.substring(0, 1).toUpperCase() + string10.substring(1).toLowerCase();
                            bl4 = true;
                            if (!bl2) break;
                            string5 = "Jmol." + string10;
                            break;
                        }
                        if (string10.equals("ZIP")) {
                            ++n;
                            break;
                        }
                        if (string10.equals("ZIPALL")) {
                            ++n;
                            break;
                        }
                        string10 = "(image)";
                    }
                }
                if (this.tokAt(n, tokenArray) != 2) break;
                n6 = ScriptVariable.iValue(this.tokenAt(n++, tokenArray));
                n7 = ScriptVariable.iValue(this.tokenAt(n++, tokenArray));
            }
        }
        if (string9 == null) {
            string8 = ScriptVariable.sValue(this.tokenAt(n, tokenArray));
            if (string8.equalsIgnoreCase("clipboard")) {
                if (this.isSyntaxCheck) {
                    return "";
                }
            } else if (Parser.isOneOf(string8.toLowerCase(), "png;pngj;pngt;jpg;jpeg;jpg64;jpeg64") && this.tokAt(n + 1, tokenArray) == 2) {
                n8 = ScriptVariable.iValue(this.tokenAt(++n, tokenArray));
            } else if (Parser.isOneOf(string8.toLowerCase(), "xyz;xyzrn;xyzvib;mol;sdf;v2000;v3000;cd;pdb;pqr;cml")) {
                string10 = string8.toUpperCase();
                if (n + 1 == n3) {
                    ++n;
                }
            }
            if (string10.equals("(image)") && Parser.isOneOf(string8.toUpperCase(), "GIF;JPG;JPG64;JPEG;JPEG64;PNG;PNGJ;PNGT;PPM")) {
                string10 = string8.toUpperCase();
                ++n;
            }
            if (n + 2 == n3 && (string3 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray))).length() > 0 && string3.charAt(0) != '.') {
                string10 = string8.toUpperCase();
            }
            switch (this.tokAt(n, tokenArray)) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1073741884: {
                    break;
                }
                case 4: 
                case 0x40000000: {
                    string5 = ScriptVariable.sValue(this.tokenAt(n, tokenArray));
                    if (n == n3 - 3 && this.tokAt(n + 1, tokenArray) == 0x100008) {
                        string5 = string5 + "." + ScriptVariable.sValue(this.tokenAt(n + 2, tokenArray));
                    }
                    if (string10 != "VAR" && n == n2) {
                        string10 = "IMAGE";
                    } else if (string5.length() > 0 && string5.charAt(0) == '.' && (n == n2 + 1 || n == n2 + 2)) {
                        string5 = ScriptVariable.sValue(this.tokenAt(n - 1, tokenArray)) + string5;
                        if (string10 != "VAR" && n == n2 + 1) {
                            string10 = "IMAGE";
                        }
                    }
                    if (!string5.equalsIgnoreCase("clipboard") && this.viewer.isRestricted(Viewer.ACCESS.ALL)) break;
                    string5 = null;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            if (string10.equals("IMAGE") || string10.equals("FRAME") || string10.equals("VIBRATION")) {
                String string11 = string10 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "JPG";
                if (string10.equals("MNU")) {
                    string10 = "MENU";
                } else if (string10.equals("WRL") || string10.equals("VRML")) {
                    string10 = "Vrml";
                    bl4 = true;
                } else if (string10.equals("X3D")) {
                    string10 = "X3d";
                    bl4 = true;
                } else if (string10.equals("IDTF")) {
                    string10 = "Idtf";
                    bl4 = true;
                } else if (string10.equals("MA")) {
                    string10 = "Maya";
                    bl4 = true;
                } else if (string10.equals("OBJ")) {
                    string10 = "Obj";
                    bl4 = true;
                } else if (string10.equals("JVXL")) {
                    string10 = "ISOSURFACE";
                } else if (string10.equals("XJVXL")) {
                    string10 = "ISOSURFACE";
                } else if (string10.equals("JMOL")) {
                    string10 = "ZIPALL";
                } else if (string10.equals("HIS")) {
                    string10 = "HISTORY";
                }
            }
            if (string10.equals("COORD")) {
                string10 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
            }
            bl5 = Parser.isOneOf(string10, "GIF;JPEG64;JPEG;JPG64;JPG;PPM;PNG;PNGJ;PNGT;SCENE");
            if (stringArray2 != null) {
                if (string10.equals("PNG")) {
                    string10 = "PNGJ";
                }
                if (!string10.equals("PNGJ") && !string10.equals("ZIPALL")) {
                    this.error(22);
                }
            }
            if (bl5 && bl) {
                string10 = "JPG64";
            } else if (!(bl5 || bl4 || Parser.isOneOf(string10, "SCENE;JMOL;ZIP;ZIPALL;SPT;HISTORY;MO;ISOSURFACE;MESH;PMESH;VAR;FILE;FUNCTION;CD;CML;XYZ;XYZRN;XYZVIB;MENU;MOL;PDB;PGRP;PQR;QUAT;RAMA;SDF;V2000;V3000;"))) {
                this.error(54, "COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|ISOSURFACE|JMOL|MENU|MO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|SPT|STATE|VAR x|ZIP|ZIPALL  CLIPBOARD", "CML|GIF|JPG|JPG64|JMOL|JVXL|MESH|MOL|PDB|PMESH|PNG|PNGJ|PNGT|PPM|PQR|SDF|V2000|V3000|SPT|XJVXL|XYZ|XYZRN|XYZVIB|ZIP" + string.toUpperCase().replace(';', '|'));
            }
            if (this.isSyntaxCheck) {
                return "";
            }
            string3 = string10.intern();
            object = null;
            boolean bl6 = false;
            if (bl4) {
                stringArray[0] = string5;
                if ((string3 = this.viewer.generateOutput(string3, (String[])(bl2 || string5 != null ? stringArray : null), n6, n7)) == null || string3.length() == 0) {
                    return "";
                }
                if (!bl2) {
                    return string3;
                }
                if ((string10.equals("Povray") || string10.equals("Idtf")) && stringArray[0] != null) {
                    String string12 = string10.equals("Idtf") ? ".tex" : ".ini";
                    string5 = stringArray[0] + string12;
                    string9 = this.viewer.createImage(string5, string12, string3, null, Integer.MIN_VALUE, 0, 0, null, 0, stringArray);
                    if (string10.equals("Idtf")) {
                        string3 = string3.substring(0, string3.indexOf("\\begin{comment}"));
                    }
                    string3 = "Created " + stringArray[0] + ":\n\n" + string3;
                } else {
                    string9 = string3;
                }
                if (string9 != null) {
                    if (!string9.startsWith("OK")) {
                        this.evalError(string9, null);
                    }
                    this.scriptStatusOrBuffer(string3);
                }
                return "";
            }
            if (string3 == "MENU") {
                string3 = this.viewer.getMenu("");
            } else if (string3 == "PGRP") {
                string3 = this.viewer.getPointGroupAsString(string4.equals("draw"), null, 0, 1.0f);
            } else if (string3 == "PDB" || string3 == "PQR") {
                if (bl) {
                    string3 = this.viewer.getPdbData(null, null);
                } else {
                    bl6 = true;
                }
            } else if (string3 == "FILE") {
                if (bl) {
                    string3 = this.viewer.getCurrentFileAsString();
                } else {
                    bl6 = true;
                }
                if ("?".equals(string5)) {
                    string5 = "?Jmol." + this.viewer.getParameter("_fileType");
                }
            } else if ((string3 == "SDF" || string3 == "MOL" || string3 == "V2000" || string3 == "V3000" || string3 == "CD") && bl3) {
                if ((string3 = this.viewer.getModelExtract("selected", true, string3)).startsWith("ERROR:")) {
                    object = string3;
                }
            } else if (string3 == "XYZ" || string3 == "XYZRN" || string3 == "XYZVIB" || string3 == "MOL" || string3 == "SDF" || string3 == "V2000" || string3 == "V3000" || string3 == "CML" || string3 == "CD") {
                if ((string3 = this.viewer.getData("selected", string3)).startsWith("ERROR:")) {
                    object = string3;
                }
            } else if (string3 == "FUNCTION") {
                string3 = this.viewer.getFunctionCalls(null);
                string10 = "TXT";
            } else if (string3 == "VAR") {
                string3 = ((ScriptVariable)this.getParameter(ScriptVariable.sValue(this.tokenAt(bl2 ? 2 : 1, tokenArray)), 1073742190)).asString();
                string10 = "TXT";
            } else if (string3 == "SPT") {
                if (bl3) {
                    BitSet bitSet2 = this.viewer.getTaintedAtoms((byte)2);
                    this.viewer.setAtomCoordRelative(new Point3f(0.0f, 0.0f, 0.0f), null);
                    string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                    this.viewer.setTaintedAtoms(bitSet2, (byte)2);
                } else {
                    string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                    if (string6 != null || string7 != null) {
                        string3 = FileManager.setScriptFileReferences(string3, string6, string7, null);
                    }
                }
            } else if (string3 == "ZIP" || string3 == "ZIPALL") {
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                object = this.viewer.createZip(string5, string10, string3, stringArray2);
            } else if (string3 == "HISTORY") {
                string3 = this.viewer.getSetHistory(Integer.MAX_VALUE);
                string10 = "SPT";
            } else if (string3 == "MO") {
                string3 = this.getMoJvxl(Integer.MAX_VALUE);
                string10 = "XJVXL";
            } else if (string3 == "PMESH") {
                string3 = this.getIsosurfaceJvxl(true, 27);
                if (string3 == null) {
                    this.error(31);
                }
                string10 = "XJVXL";
            } else if (string3 == "ISOSURFACE" || string3 == "MESH") {
                if ((string3 = this.getIsosurfaceJvxl(string3 == "MESH", 23)) == null) {
                    this.error(31);
                }
                String string13 = string10 = string3.indexOf("<?xml") >= 0 ? "XJVXL" : "JVXL";
                if (!bl) {
                    this.showString((String)this.getShapeProperty(23, "jvxlFileInfo"));
                }
            } else {
                n4 = -1;
                if (n8 < 0) {
                    n8 = -1;
                }
            }
            if (string3 == null && !bl6) {
                string3 = "";
            }
            if (n4 == 0 && !bl6) {
                int n10 = object == null ? string3.length() : (n4 = object instanceof String ? ((String)object).length() : ((byte[])object).length);
            }
            if (bl5) {
                this.refresh();
                if (n6 < 0) {
                    n6 = this.viewer.getScreenWidth();
                }
                if (n7 < 0) {
                    n7 = this.viewer.getScreenHeight();
                }
            }
            if (!bl2) {
                return string3;
            }
            if (bl) {
                this.showString(string3, true);
                return "";
            }
            if (object != null && object instanceof String) {
                this.scriptStatusOrBuffer((String)object);
                return (String)object;
            }
            if (string10.equals("SCENE")) {
                object = string2;
            } else if (!(object != null || bl5 && string5 == null)) {
                object = string3;
            }
            string9 = bl6 ? this.viewer.streamFileData(string5, string10, string4, 0, null) : this.viewer.createImage(string5, string10, object, stringArray2, n8, n6, n7, bitSet, n5, stringArray);
        }
        if (!this.isSyntaxCheck && string9 != null) {
            if (!string9.startsWith("OK")) {
                this.evalError(string9, null);
            }
            this.scriptStatusOrBuffer(string9 + (bl5 ? "; width=" + n6 + "; height=" + n7 : ""));
            return string9;
        }
        return "";
    }

    private void show() throws ScriptException {
        int n;
        String string = null;
        String string2 = this.parameterAsString(1);
        String string3 = null;
        String string4 = null;
        int n2 = 2;
        Token token = this.getToken(1);
        int n3 = n = token instanceof ScriptVariable ? 0 : token.tok;
        if (n == 4 && (token = Token.getTokenFromName(string2.toLowerCase())) != null) {
            n = token.tok;
        }
        if (n != 1297090050 && n != 1073742158) {
            this.checkLength(-3);
        }
        if (this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        block0 : switch (n) {
            case 0: {
                string3 = ((ScriptVariable)this.theToken).escape();
                break;
            }
            case 1073741915: {
                this.checkLength(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.calculateStructures(null, true, false);
                break;
            }
            case 545259570: {
                this.checkLength(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getPathForAllFiles();
                break;
            }
            case 135267336: 
            case 1073741879: 
            case 1073741929: 
            case 1073742038: {
                this.checkLength(n == 1073741879 ? 3 : 2);
                if (this.isSyntaxCheck) {
                    return;
                }
                string3 = this.viewer.getSmiles(0, 0, this.viewer.getSelectionSet(false), false, true, false, false);
                switch (n) {
                    case 1073741929: {
                        if (string3.length() > 0) {
                            this.viewer.show2D(string3);
                            return;
                        }
                        string3 = "Could not show drawing -- Either insufficient atoms are selected or the model is a PDB file.";
                        break;
                    }
                    case 1073742038: {
                        if (string3.length() > 0) {
                            this.viewer.showNMR(string3);
                            return;
                        }
                        string3 = "Could not show nmr -- Either insufficient atoms are selected or the model is a PDB file.";
                        break;
                    }
                    case 1073741879: {
                        n2 = 3;
                        String string5 = null;
                        if (string3.length() > 0) {
                            char c = '/';
                            switch (this.getToken((int)2).tok) {
                                case 0x40000099: {
                                    c = 'I';
                                    break;
                                }
                                case 1073741978: {
                                    c = 'K';
                                    break;
                                }
                                case 1073742035: {
                                    c = 'N';
                                    break;
                                }
                                default: {
                                    string5 = this.parameterAsString(2);
                                }
                            }
                            string3 = this.viewer.getChemicalInfo(string3, c, string5);
                            if (string3.indexOf("FileNotFound") < 0) break block0;
                            string3 = "?";
                            break;
                        }
                        string3 = "Could not show name -- Either insufficient atoms are selected or the model is a PDB file.";
                    }
                }
                break;
            }
            case 1297090050: {
                int n4;
                if (this.statementLength > 3) {
                    Point3f point3f = this.centerParameter(2);
                    Point3f point3f2 = this.centerParameter(++this.iToken);
                    if (!this.isSyntaxCheck) {
                        string3 = this.viewer.getSymmetryOperation(null, 0, point3f, point3f2, false);
                    }
                    n2 = ++this.iToken;
                    break;
                }
                int n5 = n4 = this.checkLength23() == 2 ? 0 : this.intParameter(2);
                if (!this.isSyntaxCheck) {
                    string3 = this.viewer.getSymmetryOperation(null, n4, null, null, false);
                }
                n2 = -3;
                break;
            }
            case 1649412112: {
                EnumVdw enumVdw = null;
                if (this.statementLength > 2 && (enumVdw = EnumVdw.getVdwType(this.parameterAsString(2))) == null) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getDefaultVdwTypeNameOrData(0, enumVdw));
                }
                return;
            }
            case 135368713: {
                this.checkLength23();
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getFunctionCalls(this.optParameterAsString(2)));
                }
                return;
            }
            case 1085443: {
                this.checkLength(2);
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getAllSettings(null));
                }
                return;
            }
            case 1074790760: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                string4 = this.parameterAsString(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.showUrl(string4);
                }
                return;
            }
            case 1766856708: {
                string2 = "defaultColorScheme";
                break;
            }
            case 0x60000004: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 1052714: 
            case 0x8101011: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n6 = this.viewer.getCurrentModelIndex();
                if (n6 < 0) {
                    this.error(30, "show " + this.theToken.value);
                }
                string3 = this.plot(this.statement);
                n2 = this.statementLength;
                break;
            }
            case 1113200654: {
                if (this.isSyntaxCheck) break;
                string3 = this.getContext(false);
                break;
            }
            case 0x40000040: {
                string4 = this.optParameterAsString(2);
                if (string4.length() > 0) {
                    n2 = 3;
                }
                if (this.isSyntaxCheck) break;
                string = this.viewer.getColorSchemeList(string4);
                break;
            }
            case 1073742192: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getVariableList() + this.getContext(true);
                break;
            }
            case 0x2000000E: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getTrajectoryInfo();
                break;
            }
            case 553648148: {
                string = "" + this.commandHistoryLevelMax;
                break;
            }
            case 553648150: {
                string = "" + Logger.getLogLevel();
                break;
            }
            case 603979824: {
                string = "" + this.viewer.getDebugScript();
                break;
            }
            case 553648178: {
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 536875070: {
                n2 = this.statementLength;
                string3 = this.viewer.showTimeout(n2 == 2 ? null : this.parameterAsString(2));
                break;
            }
            case 0x20000006: {
                string = Escape.escape(this.viewer.getDefaultLattice());
                break;
            }
            case 4126: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMinimizationInfo();
                break;
            }
            case 1611272194: {
                switch (this.viewer.getAxesMode()) {
                    case UNITCELL: {
                        string3 = "set axesUnitcell";
                        break block0;
                    }
                    case BOUNDBOX: {
                        string3 = "set axesWindow";
                        break block0;
                    }
                }
                string3 = "set axesMolecular";
                break;
            }
            case 0x60000001: {
                string3 = "set bondMode " + (this.viewer.getBondSelectionModeOr() ? "OR" : "AND");
                break;
            }
            case 1650071565: {
                if (this.isSyntaxCheck) break;
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 1612189718: {
                string3 = "set hbondsBackbone " + this.viewer.getHbondsBackbone() + ";set hbondsSolid " + this.viewer.getHbondsSolid();
                break;
            }
            case 1611141175: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpinState();
                break;
            }
            case 1611141176: {
                string3 = "set ssbondsBackbone " + this.viewer.getSsbondsBackbone();
                break;
            }
            case 1610625028: 
            case 1611141171: {
                string3 = "selectionHalos " + (this.viewer.getSelectionHaloEnabled(false) ? "ON" : "OFF");
                break;
            }
            case 0x60300006: {
                string3 = "set selectHetero " + this.viewer.getRasmolSetting(n);
                break;
            }
            case 0x40000004: {
                string3 = Escape.escapeArray(this.viewer.getAdditionalHydrogens(null, true, true, null));
                break;
            }
            case 1613758476: {
                string3 = "set selectHydrogens " + this.viewer.getRasmolSetting(n);
                break;
            }
            case 0x2000000C: 
            case 0x21000002: 
            case 553648142: 
            case 553648172: 
            case 553648176: 
            case 1073741995: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpecularState();
                break;
            }
            case 4146: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.listSavedStates();
                break;
            }
            case 1614417948: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getUnitCellInfoText();
                break;
            }
            case 0x100006: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCoordinateState(this.viewer.getSelectionSet(false));
                    break;
                }
                String string6 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedCoordinates(string6);
                break;
            }
            case 1073742158: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStateInfo();
                    break;
                }
                string4 = this.parameterAsString(2);
                if (string4.equals("/") && (n2 = this.statementLength) == 4) {
                    string4 = this.parameterAsString(3).toLowerCase();
                    if (this.isSyntaxCheck) break;
                    String[] stringArray = TextFormat.split(this.viewer.getStateInfo(), '\n');
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].toLowerCase().indexOf(string4) < 0) continue;
                        stringBuffer.append(stringArray[i]).append('\n');
                    }
                    string3 = stringBuffer.toString();
                    break;
                }
                if (this.tokAt(2) == 1229984263 && (n2 = this.statementLength) == 4) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getEmbeddedFileState(this.parameterAsString(3));
                    break;
                }
                n2 = 3;
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedState(string4);
                break;
            }
            case 1641025539: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getProteinStructureState();
                    break;
                }
                String string7 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedStructure(string7);
                break;
            }
            case 135270407: {
                Object[] objectArray;
                String string8;
                n2 = this.statementLength;
                String string9 = string8 = n2 == 3 ? this.parameterAsString(2) : null;
                if (this.isSyntaxCheck) break;
                Object[] objectArray2 = objectArray = string8 == null ? this.data : this.viewer.getData(string8);
                string3 = objectArray == null ? "no data" : "data  \"" + objectArray[0] + "\"\n" + (objectArray[1] instanceof float[] ? Escape.escape((float[])objectArray[1], false) : (objectArray[1] instanceof float[][] ? Escape.escape((float[][])objectArray[1], false) : "" + objectArray[1])) + "\nend \"" + objectArray[0] + "\";";
                break;
            }
            case 1073742152: {
                Map<String, Object> map = null;
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (!this.isSyntaxCheck) {
                        map = this.viewer.getSpaceGroupInfo(null);
                    }
                } else {
                    String string10 = this.parameterAsString(2);
                    if (!this.isSyntaxCheck) {
                        map = this.viewer.getSpaceGroupInfo(TextFormat.simpleReplace(string10, "''", "\""));
                    }
                }
                if (map == null) break;
                string3 = "" + map.get("spaceGroupInfo") + map.get("symmetryInfo");
                break;
            }
            case 0x100007: {
                n2 = 3;
                string3 = this.setObjectProperty();
                break;
            }
            case 1679429641: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.isSyntaxCheck) break;
                string3 = "center " + Escape.escape(this.viewer.getRotationCenter());
                break;
            }
            case 135176: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.getShapeProperty(22, "command");
                break;
            }
            case 1229984263: {
                if (this.statementLength == 2) {
                    if (!this.isSyntaxCheck) {
                        string3 = this.viewer.getCurrentFileAsString();
                    }
                    if (string3 != null) break;
                    string3 = "<unavailable>";
                    break;
                }
                n2 = 3;
                string = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getFileAsString(string);
                break;
            }
            case 4115: {
                if (this.tokAt(2) == 0x100003) {
                    n2 = 3;
                    if (3 > 0) {
                        string3 = this.viewer.getModelFileInfoAll();
                        break;
                    }
                }
                string3 = this.viewer.getModelFileInfo();
                break;
            }
            case 1610616855: {
                int n7;
                n2 = this.statementLength;
                int n8 = n7 = n2 == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n7 < 1) {
                    this.error(22);
                }
                if (this.isSyntaxCheck) break;
                this.viewer.removeCommand();
                string3 = this.viewer.getSetHistory(n7);
                break;
            }
            case 135180: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.getShapeProperty(23, "jvxlDataXml");
                break;
            }
            case 0x121012: {
                int n9;
                if (this.optParameterAsString(2).equalsIgnoreCase("list")) {
                    string3 = this.viewer.getMoInfo(-1);
                    n2 = 3;
                    break;
                }
                n2 = this.statementLength;
                int n10 = n9 = n2 == 2 ? Integer.MIN_VALUE : this.intParameter(2);
                if (this.isSyntaxCheck) break;
                string3 = this.getMoJvxl(n9);
                break;
            }
            case 1095766028: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getModelInfoAsString();
                break;
            }
            case 0x20021010: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 4130: 
            case 1073742132: 
            case 1073742178: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getOrientationText(n, null);
                break;
            }
            case 1073742077: {
                n2 = 2;
                if (this.statementLength > 3) break;
                n = this.tokAt(2);
                switch (n) {
                    case 0: 
                    case 4130: 
                    case 1073742132: 
                    case 1073742178: {
                        if (this.isSyntaxCheck) break;
                        string3 = this.viewer.getOrientationText(n, null);
                        break;
                    }
                    default: {
                        string4 = this.optParameterAsString(2);
                        string3 = this.viewer.getOrientationText(0, string4);
                    }
                }
                n2 = this.statementLength;
                break;
            }
            case 1073742088: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getPDBHeader();
                break;
            }
            case 1073742102: {
                this.pointGroup();
                return;
            }
            case 1089470478: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 1073742176: {
                if (this.isSyntaxCheck) break;
                string3 = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 4168: {
                string3 = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomSetting() : "off");
                break;
            }
            case 1611272202: {
                string3 = this.viewer.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 1666189314: {
                string2 = "solventProbeRadius";
                break;
            }
            case 1073741864: 
            case 1073741982: 
            case 1073742120: 
            case 0x40D00004: 
            case 1087373318: 
            case 1087373320: 
            case 1114638350: 
            case 0x44100001: 
            case 1678770178: {
                string3 = this.viewer.getChimeInfo(n);
                break;
            }
            case 20482: 
            case 537022465: 
            case 0x60000002: 
            case 1613758488: 
            case 1716520973: {
                string = "?";
                break;
            }
            case 0x40000000: {
                String string11;
                if (string2.equalsIgnoreCase("fileHeader")) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getPDBHeader();
                    break;
                }
                if (string2.equalsIgnoreCase("menu")) {
                    if (this.isSyntaxCheck) break;
                    string = this.viewer.getMenu("");
                    break;
                }
                if (!string2.equalsIgnoreCase("mouse")) break;
                n2 = this.statementLength;
                String string12 = string11 = n2 == 2 ? null : this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBindingInfo(string11);
            }
        }
        this.checkLength(n2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (string3 != null) {
            this.showString(string3);
        } else if (string != null) {
            this.showString(string2 + " = " + string);
        } else if (string2 != null) {
            if (string2.indexOf(" ") >= 0) {
                this.showString(string2);
            } else {
                this.showString(string2 + " = " + this.getParameterEscaped(string2));
            }
        }
    }

    private String getIsosurfaceJvxl(boolean bl, int n) {
        if (this.isSyntaxCheck) {
            return "";
        }
        return (String)this.getShapeProperty(n, bl ? "jvxlMeshX" : "jvxlDataXml");
    }

    private String getMoJvxl(int n) throws ScriptException {
        Integer n2;
        Map map;
        this.shapeManager.loadShape(26);
        int n3 = this.viewer.getCurrentModelIndex();
        if (n3 < 0) {
            this.error(30, "MO isosurfaces");
        }
        if ((map = (Map)this.viewer.getModelAuxiliaryInfo(n3, "moData")) == null) {
            this.error(27);
        }
        if ((n2 = (Integer)this.getShapeProperty(26, "moNumber")) == null || n2 == 0) {
            this.setShapeProperty(26, "init", n3);
        } else if (n == Integer.MAX_VALUE) {
            // empty if block
        }
        this.setShapeProperty(26, "moData", map);
        return (String)this.getShapeProperty(26, "showMO", n);
    }

    private void draw() throws ScriptException {
        this.shapeManager.loadShape(22);
        switch (this.tokAt(1)) {
            case 1073742001: {
                if (!this.listIsosurface(22)) break;
                return;
            }
            case 1073742102: {
                this.pointGroup();
                return;
            }
            case 1052714: 
            case 0x8101011: 
            case 137363468: {
                this.plot(this.statement);
                return;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        String string = "";
        int n4 = 0;
        Point3f point3f = null;
        String string2 = this.initIsosurface(22);
        boolean bl7 = string2 != null;
        boolean bl8 = bl7 && this.getShapeProperty(22, "ID") == null;
        int[] nArray = null;
        int n5 = 0;
        block70: for (int i = this.iToken; i < this.statementLength; ++i) {
            String string3 = null;
            Object object = null;
            block5 : switch (this.getToken((int)i).tok) {
                case 1614417948: 
                case 1679429641: {
                    if (this.isSyntaxCheck) break;
                    List<Object> list = this.viewer.getPlaneIntersection(this.theTok, null, (float)n3 / 100.0f, 0);
                    n3 = 0;
                    string3 = "polygon";
                    object = list;
                    bl = true;
                    break;
                }
                case 4106: {
                    nArray = new int[4];
                    n5 = 4;
                    float[] fArray = this.floatParameterSet(++i, 4, 4);
                    i = this.iToken;
                    for (int j = 0; j < 4; ++j) {
                        nArray[j] = (int)fArray[j];
                    }
                    bl = true;
                    break;
                }
                case 0x44100001: 
                case 1678770178: {
                    if (nArray == null || n5 > (this.theTok == 1095761924 ? 2 : 3)) {
                        n5 = 0;
                        nArray = new int[]{-1, -1, -1, -1};
                    }
                    nArray[n5++] = this.atomExpression(++i).nextSetBit(0);
                    i = this.iToken;
                    nArray[n5++] = this.theTok == 1678770178 ? this.atomExpression(++i).nextSetBit(0) : -1;
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 554176565: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 0x100007: {
                            string3 = "slab";
                            object = this.objectNameParameter(++i);
                            i = this.iToken;
                            bl = true;
                            break block5;
                        }
                    }
                    this.error(22);
                    break;
                }
                case 135267842: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1614417948: 
                        case 1679429641: {
                            n = this.theTok;
                            bl5 = true;
                            continue block70;
                        }
                        case 0x100007: {
                            string3 = "intersect";
                            object = this.objectNameParameter(++i);
                            i = this.iToken;
                            bl5 = true;
                            bl = true;
                            break;
                        }
                        default: {
                            this.error(22);
                            break;
                        }
                    }
                    break;
                }
                case 1073742106: {
                    string3 = "polygon";
                    bl = true;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    int n6 = 0;
                    int n7 = 0;
                    Point3f[] point3fArray = null;
                    List<ScriptVariable> list = null;
                    if (this.isArrayParameter(++i)) {
                        point3fArray = this.getPointArray(i, -1);
                        n6 = point3fArray.length;
                    } else {
                        n6 = Math.max(0, this.intParameter(i));
                        point3fArray = new Point3f[n6];
                        for (int j = 0; j < n6; ++j) {
                            point3fArray[j] = this.centerParameter(++this.iToken);
                        }
                    }
                    switch (this.getToken((int)(++this.iToken)).tok) {
                        case 11: 
                        case 12: {
                            ScriptVariable scriptVariable = new ScriptVariable(this.theToken);
                            scriptVariable.toArray();
                            list = scriptVariable.getList();
                            n7 = list.size();
                            break;
                        }
                        case 7: {
                            list = ((ScriptVariable)this.theToken).getList();
                            n7 = list.size();
                            break;
                        }
                        default: {
                            n7 = Math.max(0, this.intParameter(this.iToken));
                        }
                    }
                    int[][] nArrayArray = new int[n7][];
                    for (int j = 0; j < n7; ++j) {
                        float[] fArray;
                        float[] fArray2 = fArray = list == null ? this.floatParameterSet(++this.iToken, 3, 4) : ScriptVariable.flistValue(list.get(j), 0);
                        if (fArray.length < 3 || fArray.length > 4) {
                            this.error(22);
                        }
                        nArrayArray[j] = new int[]{(int)fArray[0], (int)fArray[1], (int)fArray[2], fArray.length == 3 ? 7 : (int)fArray[3]};
                    }
                    if (n6 > 0) {
                        arrayList.add(point3fArray);
                        arrayList.add(nArrayArray);
                    } else {
                        arrayList = null;
                    }
                    object = arrayList;
                    i = this.iToken;
                    break;
                }
                case 1297090050: {
                    String string4 = null;
                    int n8 = 0;
                    Point4f point4f = null;
                    Point3f point3f2 = null;
                    switch (this.tokAt(++i)) {
                        case 4: {
                            string4 = this.stringParameter(i);
                            break;
                        }
                        case 12: {
                            string4 = ScriptVariable.sValue(this.getToken(i));
                            break;
                        }
                        default: {
                            if (!this.isCenterParameter(i)) {
                                n8 = this.intParameter(i++);
                            }
                            if (this.isCenterParameter(i)) {
                                point3f = this.centerParameter(i);
                            }
                            if (this.isCenterParameter(this.iToken + 1)) {
                                point3f2 = this.centerParameter(++this.iToken);
                            }
                            if (this.isSyntaxCheck) {
                                return;
                            }
                            i = this.iToken;
                        }
                    }
                    BitSet bitSet = null;
                    if (point3f == null && i + 1 < this.statementLength) {
                        point3f = this.centerParameter(++i);
                        bitSet = this.tokAt(i) == 10 || this.tokAt(i) == 0x100001 ? this.atomExpression(i) : null;
                        i = this.iToken + 1;
                    }
                    this.checkLast(this.iToken);
                    if (!this.isSyntaxCheck) {
                        this.runScript((String)this.viewer.getSymmetryInfo(bitSet, string4, n8, point3f, point3f2, string2, 135176));
                    }
                    return;
                }
                case 4115: {
                    bl6 = true;
                    continue block70;
                }
                case 8: 
                case 9: 
                case 0x10000A: {
                    if (this.theTok == 9 || !this.isPoint3f(i)) {
                        object = this.getPoint4f(i);
                        if (bl6) {
                            this.checkLast(this.iToken);
                            if (!this.isSyntaxCheck) {
                                this.runScript(new Quaternion((Point4f)object).draw(string2 == null ? "frame" : string2, " " + string, point3f == null ? new Point3f() : point3f, (float)n3 / 100.0f));
                            }
                            return;
                        }
                        string3 = "planedef";
                    } else {
                        point3f = this.getPoint3f(i, true);
                        object = point3f;
                        string3 = "coord";
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 135266319: 
                case 135267841: {
                    Object object2;
                    if (!bl && !bl5 && n == 0 && this.theTok != 135267841) {
                        string3 = "plane";
                        break;
                    }
                    Point4f point4f = this.theTok == 135266319 ? this.planeParameter(++i) : this.hklParameter(++i);
                    i = this.iToken;
                    if (n != 0) {
                        if (this.isSyntaxCheck) break;
                        object2 = this.viewer.getPlaneIntersection(n, point4f, (float)n3 / 100.0f, 0);
                        n3 = 0;
                        string3 = "polygon";
                        object = object2;
                    } else {
                        object = point4f;
                        string3 = "planedef";
                    }
                    bl = true;
                    break;
                }
                case 0x400000B0: {
                    string3 = "lineData";
                    object = this.floatParameterSet(++i, 0, Integer.MAX_VALUE);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    string3 = "atomSet";
                    object = this.atomExpression(i);
                    if (bl6) {
                        point3f = this.centerParameter(i);
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 7: {
                    string3 = "modelBasedPoints";
                    object = ScriptVariable.listValue(this.theToken);
                    bl = true;
                    break;
                }
                case 0x10100030: 
                case 1073742195: {
                    break;
                }
                case 0x10100040: {
                    object = this.xypParameter(i);
                    if (object != null) {
                        i = this.iToken;
                        string3 = "coord";
                        bl = true;
                        break;
                    }
                    if (bl3) {
                        this.error(22);
                    }
                    bl3 = true;
                    break;
                }
                case 0x10100041: {
                    if (!bl3) {
                        this.error(22);
                    }
                    bl3 = false;
                    break;
                }
                case 1141899269: {
                    string3 = "reverse";
                    break;
                }
                case 4: {
                    object = this.stringParameter(i);
                    string3 = "title";
                    break;
                }
                case 135198: {
                    string3 = "vector";
                    break;
                }
                case 1141899267: {
                    object = Float.valueOf(this.floatParameter(++i));
                    string3 = "length";
                    break;
                }
                case 3: {
                    object = Float.valueOf(this.floatParameter(i));
                    string3 = "length";
                    break;
                }
                case 1095761933: {
                    string3 = "modelIndex";
                    object = this.intParameter(++i);
                    break;
                }
                case 2: {
                    if (bl3) {
                        string3 = "modelIndex";
                        object = this.intParameter(i);
                        break;
                    }
                    n3 = this.intParameter(i);
                    break;
                }
                case 1073742138: {
                    if (++i >= this.statementLength) {
                        this.error(34);
                    }
                    switch (this.getToken((int)i).tok) {
                        case 2: {
                            n3 = this.intParameter(i);
                            continue block70;
                        }
                        case 3: {
                            n3 = (int)(this.floatParameter(i) * 100.0f);
                            continue block70;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 1074790550: {
                    string2 = this.setShapeId(22, ++i, bl7);
                    bl8 = this.getShapeProperty(22, "ID") == null;
                    i = this.iToken;
                    break;
                }
                case 0x400000CC: {
                    string3 = "fixed";
                    object = Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    string3 = "fixed";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742066: {
                    Object object2 = this.getPoint3f(++i, true);
                    i = this.iToken;
                    string3 = "offset";
                    object = object2;
                    break;
                }
                case 1073741906: {
                    string3 = "crossed";
                    break;
                }
                case 1073742196: {
                    object = Float.valueOf(this.floatParameter(++i));
                    string3 = "width";
                    string = string3 + " " + object;
                    break;
                }
                case 1073741998: {
                    string3 = "line";
                    object = Boolean.TRUE;
                    break;
                }
                case 0x40000054: {
                    string3 = "curve";
                    break;
                }
                case 0x40100010: {
                    string3 = "arc";
                    break;
                }
                case 1073741846: {
                    string3 = "arrow";
                    break;
                }
                case 1073741880: {
                    string3 = "circle";
                    break;
                }
                case 1073741912: {
                    string3 = "cylinder";
                    break;
                }
                case 1073742194: {
                    string3 = "vertices";
                    break;
                }
                case 0x400000E0: {
                    string3 = "nohead";
                    break;
                }
                case 1073741861: {
                    string3 = "isbarb";
                    break;
                }
                case 1073742130: {
                    string3 = "rotate45";
                    break;
                }
                case 1073742092: {
                    string3 = "perp";
                    break;
                }
                case 1073741916: 
                case 1666189314: {
                    boolean bl9 = this.theTok == 1666189314;
                    float f2 = this.floatParameter(++i);
                    if (bl9) {
                        f2 *= 2.0f;
                    }
                    object = Float.valueOf(f2);
                    string3 = bl9 || this.tokAt(i) == 3 ? "width" : "diameter";
                    string = string3 + (this.tokAt(i) == 3 ? " " + f2 : " " + (int)f2);
                    break;
                }
                case 0x100007: {
                    if (this.tokAt(i + 2) == 0x10100040 || bl6) {
                        Point3f point3f3 = point3f = this.centerParameter(i);
                        i = this.iToken;
                        string3 = "coord";
                        object = point3f3;
                        bl = true;
                        break;
                    }
                    object = this.objectNameParameter(++i);
                    string3 = "identifier";
                    bl = true;
                    break;
                }
                case 1073742074: 
                case 1073742180: 
                case 1766856708: {
                    if (this.theTok != 1766856708) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 1073742180) {
                        bl4 = true;
                        if (this.isFloatParameter(++i + 1)) {
                            f = this.getTranslucentLevel(++i);
                        }
                    } else if (this.tokAt(i + 1) == 1073742074) {
                        ++i;
                        bl4 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n2 = this.getArgbParam(++i);
                        i = this.iToken;
                    } else if (!bl4) {
                        this.error(22);
                    }
                    bl7 = true;
                    continue block70;
                }
                default: {
                    if (!this.setMeshDisplayProperty(22, 0, this.theTok)) {
                        if (this.theTok == 0x101000B1 || Token.tokAttr(this.theTok, 0x40000000)) {
                            string2 = this.setShapeId(22, i, bl7);
                            i = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n4 == 0) {
                        n4 = i;
                    }
                    i = this.iToken;
                    continue block70;
                }
            }
            boolean bl10 = bl7 = this.theTok != 12291;
            if (bl && !bl2 && !bl6) {
                this.setShapeProperty(22, "points", n3);
                bl2 = true;
                n3 = 0;
            }
            if (bl && bl8) {
                this.error(22);
            }
            if (string3 == null) continue;
            this.setShapeProperty(22, string3, object);
        }
        if (bl) {
            this.setShapeProperty(22, "set", nArray);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(22, "color", n2);
        }
        if (bl4) {
            this.setShapeTranslucency(22, "", "translucent", f, null);
        }
        if (n3 != 0) {
            this.setShapeProperty(22, "scale", n3);
        }
        if (n4 > 0 && !this.setMeshDisplayProperty(22, n4, 0)) {
            this.error(22);
        }
    }

    private void polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        this.shapeManager.loadShape(21);
        this.setShapeProperty(21, "init", null);
        String string = "centers";
        String string2 = "radius_";
        boolean bl6 = false;
        float f = Float.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        block15: for (int i = 1; i < this.statementLength; ++i) {
            String string3 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 12291: 
                case 0x10000C: 
                case 0x10000D: {
                    if (i + 1 != this.statementLength || bl || n2 > 1 || n2 == 0 && "to".equals(string)) {
                        this.error(18);
                    }
                    string3 = this.theTok == 0x10000C ? "off" : (this.theTok == 0x10000D ? "on" : "delete");
                    bl2 = true;
                    break;
                }
                case 0x10100030: 
                case 269484436: {
                    continue block15;
                }
                case 1678770178: {
                    if (n2 > 0) {
                        this.error(23);
                    }
                    bl = true;
                    string3 = "bonds";
                    break;
                }
                case 1666189314: {
                    string2 = "radius";
                    continue block15;
                }
                case 2: 
                case 3: {
                    if (n2 > 0 && !bl5) {
                        this.error(23);
                    }
                    if (this.theTok == 2 && string2 == "radius_") {
                        string3 = "nVertices";
                        object = this.intParameter(i);
                        bl = true;
                        break;
                    }
                    string3 = string2 == "radius_" ? "radius" : string2;
                    object = Float.valueOf(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (bl3) {
                        this.error(23);
                    }
                    if (++n2 > 2) {
                        this.error(2);
                    }
                    if ("to".equals(string)) {
                        bl = true;
                    }
                    string3 = string;
                    string = "to";
                    object = this.atomExpression(i);
                    i = this.iToken;
                    break;
                }
                case 1074790746: {
                    if (n2 > 1) {
                        this.error(23);
                    }
                    if (this.getToken((int)(i + 1)).tok == 10) {
                        string3 = "toBitSet";
                        object = this.getToken((int)(++i)).value;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.error(19);
                    }
                    string = "to";
                    continue block15;
                }
                case 1073741937: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "faceCenterOffset";
                    bl5 = true;
                    continue block15;
                }
                case 0x40000064: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "distanceFactor";
                    bl5 = true;
                    continue block15;
                }
                case 1073742074: 
                case 1073742180: 
                case 1766856708: {
                    bl6 = false;
                    if (this.theTok != 1766856708) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 1073742180) {
                        bl6 = true;
                        if (this.isFloatParameter(++i + 1)) {
                            f = this.getTranslucentLevel(++i);
                        }
                    } else if (this.tokAt(i + 1) == 1073742074) {
                        ++i;
                        bl6 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n3 = this.getArgbParam(i);
                        i = this.iToken;
                        continue block15;
                    }
                    if (bl6) continue block15;
                    this.error(22);
                    continue block15;
                }
                case 1073741886: 
                case 1073741948: {
                    string3 = "collapsed";
                    Object object2 = object = this.theTok == 1073741886 ? Boolean.TRUE : Boolean.FALSE;
                    if (bl3) {
                        this.error(18);
                    }
                    bl3 = true;
                    break;
                }
                case 1073741934: 
                case 0x40000084: 
                case 1073742044: {
                    if (bl4) {
                        this.error(18);
                    }
                    string3 = this.parameterAsString(i);
                    bl4 = true;
                    break;
                }
                case 1073741964: {
                    n = this.theTok;
                    continue block15;
                }
                default: {
                    if (this.isColorParam(i)) {
                        n3 = this.getArgbParam(i);
                        i = this.iToken;
                        continue block15;
                    }
                    this.error(22);
                }
            }
            this.setShapeProperty(21, string3, object);
            if (!bl2) continue;
            return;
        }
        if (!(bl || bl3 || bl4 || n != 0)) {
            this.error(19);
        }
        if (bl) {
            this.setShapeProperty(21, "generate", null);
        }
        if (n3 != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "colorThis", n3);
        }
        if (bl6) {
            this.setShapeTranslucency(21, "", "translucentThis", f, null);
        }
        if (n != 0) {
            this.setShapeProperty(21, "token", n);
        }
        this.setShapeProperty(21, "init", null);
    }

    private void contact() throws ScriptException {
        this.shapeManager.loadShape(24);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(24)) {
            return;
        }
        int n = 0;
        this.iToken = 1;
        String string = this.initIsosurface(24);
        boolean bl = string != null;
        boolean bl2 = bl && this.getShapeProperty(24, "ID") == null;
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        RadiusData radiusData = null;
        float[] fArray = null;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MAX_VALUE;
        int n3 = 135266319;
        int n4 = 0;
        float f = Float.NaN;
        float f2 = Float.NaN;
        boolean bl4 = true;
        Boolean bl5 = null;
        Object object = null;
        int n5 = 0;
        boolean bl6 = false;
        boolean bl7 = this.iToken > 1;
        block27: for (int i = this.iToken; i < this.statementLength; ++i) {
            int n6 = this.getToken((int)i).tok;
            switch (n6) {
                default: {
                    bl7 = true;
                    if (!this.setMeshDisplayProperty(24, 0, this.theTok)) {
                        if (this.theTok != 0x101000B1 && !Token.tokAttr(this.theTok, 0x40000000)) {
                            this.error(22);
                        }
                        string = this.setShapeId(24, i, bl);
                        i = this.iToken;
                        break;
                    }
                    if (n == 0) {
                        n = i;
                    }
                    i = this.iToken;
                    continue block27;
                }
                case 1074790550: {
                    bl7 = true;
                    this.setShapeId(24, ++i, bl);
                    bl2 = this.getShapeProperty(24, "ID") == null;
                    i = this.iToken;
                    break;
                }
                case 1766856708: {
                    switch (this.tokAt(i + 1)) {
                        case 1073741914: {
                            n6 = 0;
                            bl3 = true;
                            stringBuffer.append(" color density");
                            ++i;
                            break;
                        }
                        case 1141899272: {
                            n6 = 0;
                            bl6 = true;
                            stringBuffer.append(" color type");
                            ++i;
                        }
                    }
                    if (n6 == 0) break;
                }
                case 1073742074: 
                case 1073742180: {
                    bl7 = true;
                    if (n5 == 0) {
                        n5 = i;
                    }
                    this.setMeshDisplayProperty(24, i, this.theTok);
                    i = this.iToken;
                    break;
                }
                case 554176565: {
                    bl7 = true;
                    object = this.getCapSlabObject(i, false);
                    this.setShapeProperty(24, "slab", object);
                    i = this.iToken;
                    break;
                }
                case 1073741914: {
                    bl3 = true;
                    stringBuffer.append(" density");
                    if (!this.isFloatParameter(i + 1)) break;
                    if (fArray == null) {
                        fArray = new float[]{-Math.abs(this.floatParameter(++i))};
                    }
                    stringBuffer.append(" " + -fArray[0]);
                    break;
                }
                case 1073742122: {
                    float f3 = this.floatParameter(++i);
                    if (!(f3 > 0.0f)) break;
                    stringBuffer.append(" resolution ").append(f3);
                    this.setShapeProperty(24, "resolution", Float.valueOf(f3));
                    break;
                }
                case 135266324: 
                case 1276118018: {
                    f = this.floatParameter(++i);
                    stringBuffer.append(" within ").append(f);
                    break;
                }
                case 2: 
                case 3: 
                case 0x101000A1: {
                    radiusData = this.encodeRadiusParameter(i, false, false);
                    stringBuffer.append(" ").append(radiusData);
                    i = this.iToken;
                    break;
                }
                case 1073741989: 
                case 1073741990: {
                    bl5 = n6 == 1073741989 ? Boolean.TRUE : Boolean.FALSE;
                    stringBuffer.append(" ").append(this.theToken.value);
                    break;
                }
                case 0x400000C4: {
                    n2 = this.intParameter(++i);
                    break;
                }
                case 1073741881: 
                case 1612189718: 
                case 1649412112: {
                    n4 = n6;
                    stringBuffer.append(" ").append(this.theToken.value);
                    break;
                }
                case 1073742136: {
                    if (this.isFloatParameter(i + 1)) {
                        f2 = this.floatParameter(++i);
                    }
                }
                case 3145756: 
                case 0x400000D4: 
                case 1074790451: {
                    bl4 = false;
                }
                case 4106: 
                case 135266319: 
                case 1073741961: 
                case 1276117510: {
                    n3 = n6;
                    stringBuffer.append(" ").append(this.theToken.value);
                    if (n6 != 1073742136) break;
                    stringBuffer.append(" ").append(f2);
                    break;
                }
                case 1073742083: {
                    fArray = this.floatParameterSet(++i, 1, 10);
                    i = this.iToken;
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (bl2 || bitSet2 != null) {
                        this.error(22);
                    }
                    bitSet3 = BitSetUtil.copy(this.atomExpression(i));
                    i = this.iToken;
                    if (bitSet == null) {
                        bitSet = bitSet3;
                    } else {
                        bitSet2 = bitSet3;
                    }
                    stringBuffer.append(" ").append(Escape.escape(bitSet3));
                }
            }
            bl = this.theTok != 12291;
        }
        if (!bl7 && bitSet == null) {
            this.error(13);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bitSet != null) {
            RadiusData radiusData2 = radiusData == null ? new RadiusData(0.26f, RadiusData.EnumType.OFFSET, EnumVdw.AUTO) : radiusData;
            bitSet2 = n3 == 0x400000D4 && bitSet2 == null && bl5 != null && bl5 != false ? bitSet : this.setContactBitSets(bitSet, bitSet2, bl4, f, radiusData2, true);
            switch (n3) {
                case 1073742136: 
                case 1074790451: {
                    BitSet bitSet4 = this.lookupIdentifierValue("solvent");
                    bitSet.andNot(bitSet4);
                    bitSet2.andNot(bitSet4);
                    bitSet2.andNot(bitSet);
                    break;
                }
                case 3145756: {
                    bitSet2.andNot(bitSet);
                    break;
                }
                case 0x400000D4: {
                    if (n2 == Integer.MAX_VALUE) {
                        n2 = 100;
                    }
                    this.setShapeProperty(24, "minset", n2);
                    stringBuffer.append(" minSet ").append(n2);
                    if (fArray != null) break;
                    fArray = new float[]{0.5f, 2.0f};
                }
            }
            if (bl5 != null) {
                fArray = fArray == null ? new float[2] : ArrayUtil.ensureLength(fArray, 2);
                fArray[1] = bl5 != false ? 1 : 2;
            }
            if (fArray != null) {
                stringBuffer.append(" parameters ").append(Escape.escape(fArray));
            }
            this.setShapeProperty(24, "set", new Object[]{n4, n3, bl3, bl6, bitSet, bitSet2, radiusData, Float.valueOf(f2), fArray, stringBuffer.toString()});
            if (n5 > 0) {
                this.setMeshDisplayProperty(24, n5, 0);
            }
        }
        if (n > 0 && !this.setMeshDisplayProperty(24, n, 0)) {
            this.error(22);
        }
        if (object != null && bitSet != null) {
            this.setShapeProperty(24, "slab", object);
        }
        if (bitSet != null && (n3 == 0x400000D4 || bl4)) {
            Object object2 = this.getShapeProperty(24, "volume");
            if (object2 instanceof double[]) {
                double[] dArray = (double[])object2;
                double d = 0.0;
                for (int i = 0; i < dArray.length; ++i) {
                    d += Math.abs(dArray[i]);
                }
                object2 = Float.valueOf((float)d);
            }
            int n7 = (Integer)this.getShapeProperty(24, "nSets");
            if (bl3 || n3 != 1276117510) {
                this.showString((n7 == 0 ? "" : n7 + " contacts with ") + "net volume " + object2 + " A^3");
            }
        }
    }

    BitSet setContactBitSets(BitSet bitSet, BitSet bitSet2, boolean bl, float f, RadiusData radiusData, boolean bl2) {
        int n;
        BitSet bitSet3;
        boolean bl3;
        if (bitSet2 == null) {
            bitSet2 = BitSetUtil.setAll(this.viewer.getAtomCount());
            BitSetUtil.andNot(bitSet2, this.viewer.getDeletedAtoms());
            bitSet2.andNot(bitSet);
            bl3 = false;
        } else {
            bitSet3 = BitSetUtil.copy(bitSet);
            bitSet3.or(bitSet2);
            n = this.viewer.getModelBitSet(bitSet3, false).cardinality();
            boolean bl4 = bl3 = n > 1;
            if (bl2 && n > 1 && !this.tQuiet) {
                this.showString(GT._("Note: More than one model is involved in this contact!"));
            }
        }
        if (!bitSet.equals(bitSet2)) {
            int n2 = n = !bl || bitSet.cardinality() < bitSet2.cardinality() ? 1 : 0;
            if (n != 0) {
                bitSet3 = this.viewer.getAtomsWithin(f, bitSet, bl3, Float.isNaN(f) ? radiusData : null);
                bitSet2.and(bitSet3);
            }
            if (bl) {
                bitSet3 = this.viewer.getAtomsWithin(f, bitSet2, bl3, Float.isNaN(f) ? radiusData : null);
                bitSet.and(bitSet3);
                if (n == 0) {
                    bitSet3 = this.viewer.getAtomsWithin(f, bitSet, bl3, Float.isNaN(f) ? radiusData : null);
                    bitSet2.and(bitSet3);
                }
                bitSet3 = BitSetUtil.copy(bitSet2);
                bitSet3.and(bitSet);
                if (bitSet3.equals(bitSet)) {
                    bitSet2.andNot(bitSet);
                } else if (bitSet3.equals(bitSet2)) {
                    bitSet.andNot(bitSet2);
                }
            }
        }
        return bitSet2;
    }

    private void lcaoCartoon() throws ScriptException {
        this.shapeManager.loadShape(25);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(25)) {
            return;
        }
        this.setShapeProperty(25, "init", this.fullCommand);
        if (this.statementLength == 1) {
            this.setShapeProperty(25, "lcaoID", null);
            return;
        }
        boolean bl = false;
        String string = null;
        block24: for (int i = 1; i < this.statementLength; ++i) {
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 554176565: 
                case 1074790451: {
                    string2 = (String)this.theToken.value;
                    if (this.tokAt(i + 1) == 0x10000C) {
                        this.iToken = i + 1;
                    }
                    object = this.getCapSlabObject(i, true);
                    i = this.iToken;
                    break;
                }
                case 12289: {
                    this.isosurface(25);
                    return;
                }
                case 528432: {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541205: {
                            f = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541206: {
                            f2 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541207: {
                            f3 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    string2 = "rotationAxis";
                    object = new Vector3f(f, f2, f3);
                    break;
                }
                case 0x10000D: 
                case 3145768: 
                case 1610625028: {
                    string2 = "on";
                    break;
                }
                case 12294: 
                case 0x10000C: 
                case 3145770: {
                    string2 = "off";
                    break;
                }
                case 12291: {
                    string2 = "delete";
                    break;
                }
                case 10: 
                case 0x100001: {
                    string2 = "select";
                    object = this.atomExpression(i);
                    i = this.iToken;
                    break;
                }
                case 1766856708: {
                    string = this.setColorOptions(null, i + 1, 25, -2);
                    if (string != null) {
                        this.setShapeProperty(25, "settranslucency", string);
                    }
                    i = this.iToken;
                    bl = true;
                    continue block24;
                }
                case 1073742074: 
                case 1073742180: {
                    this.setMeshDisplayProperty(25, i, this.theTok);
                    i = this.iToken;
                    bl = true;
                    continue block24;
                }
                case 4: 
                case 1113200651: {
                    object = this.parameterAsString(i).toLowerCase();
                    if (object.equals("spacefill")) {
                        object = "cpk";
                    }
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 135280132: {
                    if (this.tokAt(i + 1) == 10 || this.tokAt(i + 1) == 0x100001) {
                        string2 = "select";
                        object = this.atomExpression(i + 1);
                        i = this.iToken;
                        break;
                    }
                    string2 = "selectType";
                    if (!(object = this.parameterAsString(++i)).equals("spacefill")) break;
                    object = "cpk";
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    string2 = "lonePair";
                    break;
                }
                case 1073742110: 
                case 1073742112: {
                    string2 = "radical";
                    break;
                }
                case 1073742030: {
                    string2 = "molecular";
                    break;
                }
                case 0x40000050: {
                    object = this.parameterAsString(++i);
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 1074790550: {
                    object = this.getShapeNameParameter(++i);
                    i = this.iToken;
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                    break;
                }
                default: {
                    if (this.theTok != 0x101000B1 && !Token.tokAttr(this.theTok, 0x40000000)) break;
                    if (this.theTok != 0x101000B1) {
                        object = this.parameterAsString(i);
                    }
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                }
            }
            if (this.theTok != 12291) {
                bl = true;
            }
            if (string2 == null) {
                this.error(22);
            }
            this.setShapeProperty(25, string2, object);
        }
        this.setShapeProperty(25, "clear", null);
    }

    private Object getCapSlabObject(int n, boolean bl) throws ScriptException {
        Object[] objectArray;
        if (n < 0) {
            return MeshSurface.getSlabWithinRange(n, 0.0f);
        }
        Object object = null;
        int n2 = this.tokAt(n);
        boolean bl2 = n2 == 554176565;
        int n3 = this.tokAt(n + 1);
        Point4f point4f = null;
        Point3f[] point3fArray = null;
        BitSet bitSet = null;
        Short s = null;
        Integer n4 = null;
        if (n3 == 1073742180) {
            float f;
            float f2 = f = this.isFloatParameter(++n + 1) ? this.floatParameter(++n) : 0.5f;
            if (this.isColorParam(n + 1)) {
                s = Graphics3D.getColixTranslucent(Graphics3D.getColix(this.getArgbParam(n + 1)), f != 0.0f, f);
                n = this.iToken;
            } else {
                s = Graphics3D.getColixTranslucent((short)1, f != 0.0f, f);
            }
            n3 = this.tokAt(n + 1);
            switch (n3) {
                case 1073741938: 
                case 1073742018: {
                    n4 = n3;
                    n3 = this.tokAt(++n + 1);
                    break;
                }
                default: {
                    n4 = 1073741938;
                }
            }
        }
        switch (n3) {
            case 10: 
            case 0x100001: {
                object = this.atomExpression(n + 1);
                n3 = 3;
                ++this.iToken;
                break;
            }
            case 0x10000C: {
                this.iToken = n + 1;
                return new Integer(Integer.MIN_VALUE);
            }
            case 0x10000B: {
                this.iToken = n + 1;
                break;
            }
            case 0x100007: {
                ++n;
                object = new Object[]{Float.valueOf(1.0f), this.parameterAsString(++n)};
                n3 = 1073742018;
                break;
            }
            case 135266324: {
                ++n;
                if (this.tokAt(++n) == 1073742114) {
                    float f = this.floatParameter(++n);
                    float f3 = this.floatParameter(++n);
                    object = new Object[]{Float.valueOf(f), Float.valueOf(f3)};
                    n3 = 1073742114;
                    break;
                }
                if (this.isFloatParameter(n)) {
                    float f = this.floatParameter(n);
                    if (this.isCenterParameter(++n)) {
                        Point3f point3f = this.centerParameter(n);
                        if (this.isSyntaxCheck || !(this.expressionResult instanceof BitSet)) {
                            point3fArray = new Point3f[]{point3f};
                        } else {
                            Atom[] atomArray = this.viewer.getModelSet().atoms;
                            bitSet = (BitSet)this.expressionResult;
                            point3fArray = new Point3f[bitSet.cardinality()];
                            int n5 = 0;
                            int n6 = bitSet.nextSetBit(0);
                            while (n6 >= 0) {
                                point3fArray[n5] = atomArray[n6];
                                n6 = bitSet.nextSetBit(n6 + 1);
                                ++n5;
                            }
                        }
                    } else {
                        point3fArray = this.getPointArray(n, -1);
                    }
                    if (point3fArray.length == 0) {
                        this.iToken = n;
                        this.error(22);
                    }
                    object = new Object[]{Float.valueOf(f), point3fArray, bitSet};
                    break;
                }
                object = this.getPointArray(n, 4);
                n3 = 1679429641;
                break;
            }
            case 1679429641: {
                this.iToken = n + 1;
                object = BoxInfo.getCriticalPoints(this.viewer.getBoundBoxVertices(), null);
                break;
            }
            case 0x40000030: 
            case 1614417948: {
                this.iToken = n + 1;
                SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                if (symmetryInterface == null) {
                    if (n3 != 1614417948) break;
                    this.error(22);
                    break;
                }
                point3fArray = BoxInfo.getCriticalPoints(symmetryInterface.getUnitCellVertices(), symmetryInterface.getCartesianOffset());
                int n7 = (int)symmetryInterface.getUnitCellInfo(6);
                Vector3f vector3f = null;
                Vector3f vector3f2 = null;
                switch (n7) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        vector3f2 = new Vector3f(point3fArray[2]);
                        vector3f2.sub(point3fArray[0]);
                        vector3f2.scale(1000.0f);
                    }
                    case 2: {
                        vector3f = new Vector3f(point3fArray[1]);
                        vector3f.sub(point3fArray[0]);
                        vector3f.scale(1000.0f);
                        point3fArray[0].sub(vector3f);
                        point3fArray[1].scale(2000.0f);
                        if (n7 != 1) break;
                        point3fArray[0].sub(vector3f2);
                        point3fArray[2].scale(2000.0f);
                    }
                }
                object = point3fArray;
                break;
            }
            default: {
                float f;
                if (!bl && bl2 && this.isFloatParameter(n + 1)) {
                    float f4 = this.floatParameter(++n);
                    if (!this.isFloatParameter(n + 1)) {
                        return new Integer((int)f4);
                    }
                    float f5 = this.floatParameter(++n);
                    object = new Object[]{Float.valueOf(f4), Float.valueOf(f5)};
                    n3 = 1073742114;
                    break;
                }
                point4f = this.planeParameter(++n);
                float f6 = f = this.isFloatParameter(this.iToken + 1) ? this.floatParameter(++this.iToken) : Float.NaN;
                if (!Float.isNaN(f)) {
                    point4f.w -= f;
                }
                object = point4f;
                n3 = 135266319;
            }
        }
        if (n4 == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = n4;
            objectArray = objectArray2;
            objectArray2[1] = s;
        }
        Object[] objectArray3 = objectArray;
        return MeshSurface.getSlabObject(n3, object, !bl2, objectArray3);
    }

    private boolean mo(boolean bl) throws ScriptException {
        int n = Integer.MAX_VALUE;
        boolean bl2 = false;
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n2 = 1;
        if (this.tokAt(1) == 1095766028 || this.tokAt(1) == 4115) {
            n2 = this.modelNumberParameter(2);
            if (n2 < 0) {
                this.error(22);
            }
            bitSet.clear();
            bitSet.set(n2);
            n2 = 3;
        }
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            this.shapeManager.loadShape(26);
            int n4 = n2;
            if (this.tokAt(n4) == 1073742001 && this.listIsosurface(26)) {
                return true;
            }
            this.setShapeProperty(26, "init", n3);
            String string = null;
            int n5 = (Integer)this.getShapeProperty(26, "moNumber");
            float[] fArray = (float[])this.getShapeProperty(26, "moLinearCombination");
            if (bl) {
                return true;
            }
            if (n5 == 0) {
                n5 = Integer.MAX_VALUE;
            }
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)n4).tok) {
                case 554176565: 
                case 1074790451: {
                    string2 = (String)this.theToken.value;
                    object = this.getCapSlabObject(n4, false);
                    n4 = this.iToken;
                    break;
                }
                case 2: {
                    float[] fArray2;
                    n5 = this.intParameter(n4);
                    if (n5 >= 0) {
                        fArray2 = null;
                    } else {
                        float[] fArray3 = new float[2];
                        fArray3[0] = -100.0f;
                        fArray2 = fArray3;
                        fArray3[1] = -n5;
                    }
                    fArray = fArray2;
                    break;
                }
                case 0x101000A0: {
                    switch (this.tokAt(++n4)) {
                        case 1073741973: 
                        case 1073742008: {
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    bl2 = true;
                }
                case 1073741973: 
                case 1073742008: {
                    fArray = null;
                    n = this.moOffset(n4);
                    if (n == Integer.MAX_VALUE) {
                        this.error(22);
                    }
                    n5 = 0;
                    break;
                }
                case 1073742037: {
                    fArray = null;
                    n5 = 1073742037;
                    break;
                }
                case 1073742108: {
                    fArray = null;
                    n5 = 1073742108;
                    break;
                }
                case 1766856708: {
                    this.setColorOptions(null, n4 + 1, 26, 2);
                    break;
                }
                case 135266319: {
                    string2 = "plane";
                    object = this.planeParameter(n4 + 1);
                    break;
                }
                case 0x8100010: {
                    this.addShapeProperty(arrayList, "randomSeed", this.tokAt(n4 + 2) == 2 ? Integer.valueOf(this.intParameter(n4 + 2)) : null);
                    string2 = "monteCarloCount";
                    object = this.intParameter(n4 + 1);
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 1073741910: {
                    if (this.tokAt(n4 + 1) == 0x101000A1) {
                        string2 = "cutoffPositive";
                        object = Float.valueOf(this.floatParameter(n4 + 2));
                        break;
                    }
                    string2 = "cutoff";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 0x20000004: {
                    string2 = "debug";
                    break;
                }
                case 1073742054: {
                    string2 = "plane";
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    string2 = "resolution";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 1073742156: {
                    string2 = "squareData";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742168: {
                    if (n4 + 1 >= this.statementLength || this.tokAt(n4 + 1) != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(n4 + 1);
                    break;
                }
                case 0x40000000: {
                    this.error(22);
                    break;
                }
                default: {
                    if (this.isArrayParameter(n4)) {
                        fArray = this.floatParameterSet(n4, 2, Integer.MAX_VALUE);
                        break;
                    }
                    int n6 = this.iToken;
                    if (!this.setMeshDisplayProperty(26, 0, this.theTok)) {
                        this.error(22);
                    }
                    this.setShapeProperty(26, "setProperties", arrayList);
                    this.setMeshDisplayProperty(26, n6, this.tokAt(n6));
                    return true;
                }
            }
            if (string2 != null) {
                this.addShapeProperty(arrayList, string2, object);
            }
            if (n5 != Integer.MAX_VALUE || fArray != null) {
                if (this.tokAt(n4 + 1) == 4) {
                    string = this.parameterAsString(n4 + 1);
                }
                this.setCursorWait(true);
                this.setMoData(arrayList, n5, fArray, n, bl2, n3, string);
                this.addShapeProperty(arrayList, "finalize", null);
            }
            if (arrayList.size() > 0) {
                this.setShapeProperty(26, "setProperties", arrayList);
            }
            arrayList.clear();
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        return true;
    }

    private String setColorOptions(StringBuffer stringBuffer, int n, int n2, int n3) throws ScriptException {
        this.getToken(n);
        String string = "opaque";
        if (this.theTok == 1073742180) {
            string = "translucent";
            if (n3 < 0) {
                float f = this.isFloatParameter(n + 1) ? this.floatParameter(++n) : Float.MAX_VALUE;
                this.setShapeTranslucency(n2, null, "translucent", f, null);
                if (stringBuffer != null) {
                    stringBuffer.append(" translucent");
                    if (f != Float.MAX_VALUE) {
                        stringBuffer.append(" ").append(f);
                    }
                }
            } else {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else if (this.theTok == 1073742074) {
            if (n3 >= 0) {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else {
            --this.iToken;
        }
        n3 = Math.abs(n3);
        for (int i = 0; i < n3; ++i) {
            if (this.isColorParam(this.iToken + 1)) {
                int n4 = this.getArgbParam(++this.iToken);
                this.setShapeProperty(n2, "colorRGB", n4);
                if (stringBuffer == null) continue;
                stringBuffer.append(" ").append(Escape.escapeColor(n4));
                continue;
            }
            if (this.iToken >= n) break;
            this.error(22);
        }
        return string;
    }

    private int moOffset(int n) throws ScriptException {
        int n2;
        boolean bl = this.getToken((int)n).tok == 1073741973;
        int n3 = bl ? 0 : 1;
        if ((n2 = this.tokAt(++n)) == 2 && this.intParameter(n) < 0) {
            n3 += this.intParameter(n);
        } else if (n2 == 0x101000A1) {
            n3 += this.intParameter(++n);
        } else if (n2 == 0x101000A0) {
            n3 -= this.intParameter(++n);
        }
        return n3;
    }

    private void setMoData(List<Object[]> list, int n, float[] fArray, int n2, boolean bl, int n3, String string) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        if (n3 < 0 && (n3 = this.viewer.getCurrentModelIndex()) < 0) {
            this.error(30, "MO isosurfaces");
        }
        int n4 = n;
        Map map = (Map)this.viewer.getModelAuxiliaryInfo(n3, "moData");
        if (fArray == null) {
            int n5;
            int n6;
            if (map == null) {
                this.error(27);
            }
            int n7 = n6 = map.containsKey("lastMoNumber") ? (Integer)map.get("lastMoNumber") : 0;
            if (n == 1073742108) {
                n = n6 - 1;
            } else if (n == 1073742037) {
                n = n6 + 1;
            }
            List list2 = (List)map.get("mos");
            int n8 = n5 = list2 == null ? 0 : list2.size();
            if (n5 == 0) {
                this.error(25);
            }
            if (n5 == 1 && n > 1) {
                this.error(29);
            }
            if (n2 != Integer.MAX_VALUE) {
                if (map.containsKey("HOMO")) {
                    n = (Integer)map.get("HOMO") + n2;
                } else {
                    n = -1;
                    for (int i = 0; i < n5; ++i) {
                        Map map2 = (Map)list2.get(i);
                        Float f = (Float)map2.get("occupancy");
                        if (f != null) {
                            if (!(f.floatValue() < 0.5f)) continue;
                            n = i;
                            break;
                        }
                        f = (Float)map2.get("energy");
                        if (f == null) break;
                        if (!(f.floatValue() > 0.0f)) continue;
                        n = i;
                        break;
                    }
                    if (n < 0) {
                        this.error(28);
                    }
                    n += n2;
                }
                Logger.info("MO " + n);
            }
            if (n < 1 || n > n5) {
                this.error(26, "" + n5);
            }
        }
        map.put("lastMoNumber", n);
        if (bl) {
            fArray = new float[]{-100.0f, n};
        }
        this.addShapeProperty(list, "moData", map);
        if (string != null) {
            this.addShapeProperty(list, "title", string);
        }
        if (n4 < 0) {
            this.addShapeProperty(list, "charges", this.viewer.getAtomicCharges());
        }
        this.addShapeProperty(list, "molecularOrbital", fArray != null ? fArray : (float[])(n4 < 0 ? -n : n));
        this.addShapeProperty(list, "clear", null);
    }

    private String initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.fullCommand);
        this.iToken = 0;
        int n2 = this.tokAt(1);
        int n3 = this.tokAt(2);
        if (n2 == 12291 || n3 == 12291 && this.tokAt(++this.iToken) == 0x100003) {
            this.setShapeProperty(n, "delete", null);
            this.iToken += 2;
            if (this.statementLength > this.iToken) {
                this.setShapeProperty(n, "init", this.fullCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return null;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(n, 0, n2)) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 22) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
            if (n2 != 1074790550 && (n3 == 0x101000B1 || n2 == 0x101000B1 && this.setMeshDisplayProperty(n, 0, n3))) {
                String string = this.setShapeId(n, 1, false);
                ++this.iToken;
                return string;
            }
        }
        return null;
    }

    private String getNextComment() {
        String string = this.getCommand(this.pc + 1, false, true);
        return string.startsWith("#") ? string : "";
    }

    private boolean listIsosurface(int n) throws ScriptException {
        this.checkLength23();
        if (!this.isSyntaxCheck) {
            this.showString((String)this.getShapeProperty(n, "list" + (this.tokAt(2) == 0 ? "" : " " + this.getToken((int)2).value)));
        }
        return true;
    }

    private void isosurface(int n) throws ScriptException {
        Object object;
        Object object2;
        int n2;
        this.shapeManager.loadShape(n);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(n)) {
            return;
        }
        int n3 = 0;
        boolean bl = n == 23;
        boolean bl2 = n == 27;
        boolean bl3 = n == 28;
        boolean bl4 = n == 25;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        float[] fArray = null;
        String string = null;
        int n4 = -1;
        int n5 = 0;
        float f = Float.NaN;
        float f2 = Float.NaN;
        int n6 = 0;
        Boolean bl18 = null;
        int n7 = Integer.MAX_VALUE;
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n8 = this.isSyntaxCheck ? 0 : Integer.MIN_VALUE;
        this.setCursorWait(true);
        boolean bl19 = this.initIsosurface(n) != null;
        boolean bl20 = bl19 && this.getShapeProperty(n, "ID") == null;
        boolean bl21 = false;
        Object object3 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        short[] sArray = null;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl22 = false;
        if (bl2 || bl3) {
            this.addShapeProperty(arrayList, "fileType", "Pmesh");
        }
        block102: for (n2 = this.iToken; n2 < this.statementLength; ++n2) {
            object2 = null;
            object = null;
            this.getToken(n2);
            if (this.theTok == 0x40000000) {
                string2 = this.parameterAsString(n2);
            }
            block3 : switch (this.theTok) {
                case 603979871: {
                    Boolean bl23 = this.getToken((int)(++n2)).tok == 0x10000D ? Boolean.TRUE : (bl18 = this.theTok == 0x10000C ? Boolean.FALSE : null);
                    if (bl18 != null) continue block102;
                    this.error(22);
                    continue block102;
                }
                case 553648149: {
                    n7 = this.intParameter(++n2);
                    continue block102;
                }
                case 4128: {
                    object2 = "moveIsosurface";
                    if (this.tokAt(++n2) != 12) {
                        this.error(22);
                    }
                    object = this.getToken((int)n2++).value;
                    break;
                }
                case 1073742066: {
                    object2 = "offset";
                    object = this.centerParameter(++n2);
                    n2 = this.iToken;
                    break;
                }
                case 528432: {
                    object2 = "rotate";
                    this.iToken = ++n2;
                    object = this.tokAt(this.iToken) == 0x10000B ? null : this.getPoint4f(n2);
                    n2 = this.iToken;
                    break;
                }
                case 0x60000004: {
                    object2 = "scale3d";
                    object = Float.valueOf(this.floatParameter(++n2));
                    break;
                }
                case 1073742090: {
                    stringBuffer.append(" periodic");
                    object2 = "periodic";
                    break;
                }
                case 266298: 
                case 0x8100010: 
                case 1073742078: {
                    object2 = this.theToken.value.toString();
                    stringBuffer.append(" ").append(this.theToken.value);
                    object = this.centerParameter(++n2);
                    stringBuffer.append(" ").append(Escape.escape(object));
                    n2 = this.iToken;
                    break;
                }
                case 1679429641: {
                    Point3f[] point3fArray;
                    if (this.fullCommand.indexOf("# BBOX=") >= 0) {
                        String[] stringArray = TextFormat.split(Parser.getQuotedAttribute(this.fullCommand, "# BBOX"), ',');
                        point3fArray = new Point3f[]{(Point3f)Escape.unescapePoint(stringArray[0]), (Point3f)Escape.unescapePoint(stringArray[1])};
                    } else if (this.isCenterParameter(n2 + 1)) {
                        point3fArray = new Point3f[]{this.getPoint3f(n2 + 1, true), this.getPoint3f(this.iToken + 1, true)};
                        n2 = this.iToken;
                    } else {
                        point3fArray = this.viewer.getBoundBoxVertices();
                    }
                    stringBuffer.append(" boundBox " + Escape.escape(point3fArray[0]) + " " + Escape.escape(point3fArray[point3fArray.length - 1]));
                    object2 = "boundingBox";
                    object = point3fArray;
                    break;
                }
                case 135188: {
                    bl2 = true;
                    stringBuffer.append(" pmesh");
                    object2 = "fileType";
                    object = "Pmesh";
                    break;
                }
                case 135267842: {
                    bitSet2 = this.atomExpression(++n2);
                    if (this.isSyntaxCheck) {
                        bitSet = new BitSet();
                    } else if (this.tokAt(this.iToken + 1) == 0x100001 || this.tokAt(this.iToken + 1) == 10) {
                        bitSet = this.atomExpression(++this.iToken);
                        bitSet.and(this.viewer.getAtomsWithin(5.0f, bitSet2, false, null));
                    } else {
                        bitSet = this.viewer.getAtomsWithin(5.0f, bitSet2, true, null);
                        bitSet.andNot(this.viewer.getAtomBits(1095761934, bitSet2));
                    }
                    bitSet.andNot(bitSet2);
                    stringBuffer.append(" intersection ").append(Escape.escape(bitSet2)).append(" ").append(Escape.escape(bitSet));
                    n2 = this.iToken;
                    if (this.tokAt(n2 + 1) == 135368713) {
                        ++n2;
                        Object[] objectArray = (Object[])this.getToken((int)(++n2)).value;
                        stringBuffer.append(" function ").append(Escape.escape((String)objectArray));
                        if (!this.isSyntaxCheck) {
                            this.addShapeProperty(arrayList, "func", objectArray.equals("a+b") || objectArray.equals("a-b") ? objectArray : this.createFunction("__iso__", "a,b", (String)objectArray));
                        }
                    } else {
                        bl17 = true;
                    }
                    object2 = "intersection";
                    object = new BitSet[]{bitSet2, bitSet};
                    break;
                }
                case 135266324: 
                case 1610625028: {
                    float f3;
                    boolean bl24;
                    boolean bl25 = bl24 = this.theTok == 1610625028;
                    if (bl24) {
                        stringBuffer.append(" display");
                        n3 = n2;
                        int n9 = this.tokAt(n2 + 1);
                        if (n9 == 0) continue block102;
                        ++n2;
                        this.addShapeProperty(arrayList, "token", 0x10000D);
                        if (n9 == 10 || n9 == 0x100003) {
                            object2 = "bsDisplay";
                            if (n9 == 0x100003) {
                                stringBuffer.append(" all");
                            } else {
                                object = this.statement[n2].value;
                                stringBuffer.append(" ").append(Escape.escape(object));
                            }
                            this.checkLast(n2);
                            break;
                        }
                        if (n9 != 135266324) {
                            this.iToken = n2;
                            this.error(22);
                        }
                    } else {
                        n6 = n2;
                    }
                    Point3f point3f = null;
                    bitSet = null;
                    boolean bl26 = false;
                    if (this.tokAt(n2 + 1) == 0x100001) {
                        f3 = this.floatParameter(n2 + 3);
                        if (this.isPoint3f(n2 + 4)) {
                            point3f = this.centerParameter(n2 + 4);
                            bl26 = true;
                            this.iToken += 2;
                        } else if (this.isPoint3f(n2 + 5)) {
                            point3f = this.centerParameter(n2 + 5);
                            bl26 = true;
                            this.iToken += 2;
                        } else {
                            bitSet = this.atomExpression(this.statement, n2 + 5, this.statementLength, true, false, false, true);
                            if (bitSet == null) {
                                this.error(22);
                            }
                        }
                    } else {
                        f3 = this.floatParameter(++n2);
                        point3f = this.centerParameter(++n2);
                    }
                    if (bl24) {
                        this.checkLast(this.iToken);
                    }
                    n2 = this.iToken;
                    if (this.fullCommand.indexOf("# WITHIN=") >= 0) {
                        bitSet = Escape.unescapeBitset(Parser.getQuotedAttribute(this.fullCommand, "# WITHIN"));
                    } else if (!bl26) {
                        BitSet bitSet4 = bitSet = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : null;
                    }
                    if (this.isSyntaxCheck) continue block102;
                    if (bitSet != null && n8 >= 0) {
                        bitSet.and(this.viewer.getModelUndeletedAtomsBitSet(n8));
                    }
                    if (point3f == null) {
                        point3f = this.viewer.getAtomSetCenter(bitSet);
                    }
                    this.getWithinDistanceVector(arrayList, f3, point3f, bitSet, bl24);
                    stringBuffer.append(" within ").append(f3).append(" ").append(bitSet == null ? Escape.escape(point3f) : Escape.escape(bitSet));
                    continue block102;
                }
                case 1073742083: {
                    object2 = "parameters";
                    float[] fArray2 = this.floatParameterSet(++n2, 1, 10);
                    n2 = this.iToken;
                    object = fArray2;
                    stringBuffer.append(" parameters ").append(Escape.escape(fArray2));
                    break;
                }
                case 1073742190: 
                case 1716520973: {
                    Object object4;
                    boolean bl27;
                    object3 = this.theToken.value;
                    boolean bl28 = bl27 = this.theTok == 1073742190;
                    if (string5 == null) {
                        if (!(bl5 || bl7 || bl6)) {
                            this.addShapeProperty(arrayList, "sasurface", Float.valueOf(0.0f));
                            if (bl5) {
                                stringBuffer.append(" vdw");
                            }
                            bl5 = true;
                        }
                        object2 = "property";
                        if (bl18 == null) {
                            bl18 = this.viewer.getIsosurfacePropertySmoothing(false) == 1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        this.addShapeProperty(arrayList, "propertySmoothing", bl18);
                        stringBuffer.append(" isosurfacePropertySmoothing " + bl18);
                        if (n7 == Integer.MAX_VALUE) {
                            n7 = this.viewer.getIsosurfacePropertySmoothing(true);
                        }
                        this.addShapeProperty(arrayList, "propertySmoothingPower", n7);
                        if (bl18 == Boolean.TRUE) {
                            stringBuffer.append(" isosurfacePropertySmoothingPower " + n7);
                        }
                        if (this.viewer.isRangeSelected()) {
                            this.addShapeProperty(arrayList, "rangeSelected", Boolean.TRUE);
                        }
                    } else {
                        object2 = string5;
                    }
                    string2 = this.parameterAsString(n2);
                    if (bl5) {
                        stringBuffer.append(" ").append(string2);
                    }
                    if (string2.toLowerCase().indexOf("property_") == 0) {
                        fArray = new float[this.viewer.getAtomCount()];
                        if (this.isSyntaxCheck) continue block102;
                        fArray = this.viewer.getDataFloat(string2);
                        if (fArray == null) {
                            this.error(22);
                        }
                        this.addShapeProperty(arrayList, (String)object2, fArray);
                        continue block102;
                    }
                    int n10 = this.viewer.getAtomCount();
                    fArray = new float[n10];
                    if (bl27) {
                        if (((String)(object4 = this.parameterAsString(++n2))).length() == 0) {
                            fArray = this.floatParameterSet(n2, n10, n10);
                        } else {
                            fArray = new float[n10];
                            if (!this.isSyntaxCheck) {
                                Parser.parseStringInfestedFloatArray("" + this.getParameter((String)object4, 4), null, fArray);
                            }
                        }
                        if (!this.isSyntaxCheck && bl5) {
                            stringBuffer.append(" \"\" ").append(Escape.escape(fArray));
                        }
                    } else {
                        int n11 = this.getToken((int)(++n2)).tok;
                        if (!this.isSyntaxCheck) {
                            stringBuffer.append(" " + this.theToken.value);
                            Atom[] atomArray = this.viewer.getModelSet().atoms;
                            this.viewer.autoCalculate(n11);
                            int n12 = n10;
                            while (--n12 >= 0) {
                                fArray[n12] = Atom.atomPropertyFloat(this.viewer, atomArray[n12], n11);
                            }
                        }
                        if (n11 == 1766856708) {
                            string4 = "colorRGB";
                        }
                        if (this.tokAt(n2 + 1) == 135266324) {
                            float f4 = this.floatParameter(n2 += 2);
                            stringBuffer.append(" within " + f4);
                            this.addShapeProperty(arrayList, "propertyDistanceMax", Float.valueOf(f4));
                        }
                    }
                    object = fArray;
                    break;
                }
                case 1095766028: {
                    if (bl5) {
                        this.error(22);
                    }
                    n8 = this.modelNumberParameter(++n2);
                    stringBuffer.append(" model " + n8);
                    if (n8 < 0) {
                        object2 = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    object2 = "modelIndex";
                    object = n8;
                    break;
                }
                case 135280132: {
                    boolean bl29;
                    object2 = "select";
                    Object object4 = this.atomExpression(++n2);
                    object = object4;
                    n2 = this.iToken;
                    boolean bl30 = bl29 = this.tokAt(n2 + 1) == 1073742072;
                    if (bl29) {
                        ++n2;
                        BitSet bitSet5 = BitSetUtil.copy((BitSet)object4);
                        BitSetUtil.invertInPlace(bitSet5, this.viewer.getAtomCount());
                        this.addShapeProperty(arrayList, "ignore", bitSet5);
                        stringBuffer.append(" ignore ").append(Escape.escape(bitSet5));
                    }
                    if (bl5 || bl7) {
                        stringBuffer.append(" select " + Escape.escape(object));
                        break;
                    }
                    bitSet2 = (BitSet)object;
                    if (n8 >= 0 || bitSet2.nextSetBit(0) < 0) break;
                    n8 = this.viewer.getAtomModelIndex(bitSet2.nextSetBit(0));
                    break;
                }
                case 1085443: {
                    n4 = this.intParameter(++n2);
                    break;
                }
                case 12289: {
                    object2 = "center";
                    object = this.centerParameter(++n2);
                    stringBuffer.append(" center " + Escape.escape(object));
                    n2 = this.iToken;
                    break;
                }
                case 1073742147: 
                case 1766856708: {
                    boolean bl31;
                    bl19 = true;
                    boolean bl32 = bl31 = this.theTok == 1073742147;
                    if (bl31) {
                        stringBuffer.append(" sign");
                        this.addShapeProperty(arrayList, "sign", Boolean.TRUE);
                    } else {
                        if (this.tokAt(n2 + 1) == 1073741914) {
                            ++n2;
                            object2 = "colorDensity";
                            stringBuffer.append(" color density");
                            break;
                        }
                        if (this.getToken((int)(n2 + 1)).tok == 4) {
                            if ((string4 = this.parameterAsString(++n2)).indexOf(" ") > 0 && (sArray = Graphics3D.getColixArray(string4)) == null) {
                                this.error(4);
                            }
                        } else if (this.theTok == 1073742018) {
                            ++n2;
                            stringBuffer.append(" color mesh");
                            int n13 = this.getArgbParam(++n2);
                            this.addShapeProperty(arrayList, "meshcolor", n13);
                            stringBuffer.append(" ").append(Escape.escapeColor(n13));
                            n2 = this.iToken;
                            continue block102;
                        }
                        if ((this.theTok = this.tokAt(n2 + 1)) == 1073742180 || this.theTok == 1073742074) {
                            stringBuffer.append(" color");
                            string3 = this.setColorOptions(stringBuffer, n2 + 1, 23, -2);
                            n2 = this.iToken;
                            continue block102;
                        }
                        switch (this.tokAt(n2 + 1)) {
                            case 0x40000002: 
                            case 1073742114: {
                                this.getToken(++n2);
                                stringBuffer.append(" color range");
                                this.addShapeProperty(arrayList, "rangeAll", null);
                                if (this.tokAt(n2 + 1) == 0x100003) {
                                    ++n2;
                                    stringBuffer.append(" all");
                                    continue block102;
                                }
                                float f5 = this.floatParameter(++n2);
                                float f6 = this.floatParameter(++n2);
                                this.addShapeProperty(arrayList, "red", Float.valueOf(f5));
                                this.addShapeProperty(arrayList, "blue", Float.valueOf(f6));
                                stringBuffer.append(" ").append(f5).append(" ").append(f6);
                                continue block102;
                            }
                            default: {
                                if (this.isColorParam(n2 + 1)) {
                                    int n14 = this.getArgbParam(n2 + 1);
                                    if (this.tokAt(n2 + 2) == 1074790746) {
                                        string4 = this.getColorRange(n2 + 1);
                                        n2 = this.iToken;
                                        break block3;
                                    }
                                }
                                stringBuffer.append(" color");
                            }
                        }
                    }
                    if (this.isColorParam(n2 + 1)) {
                        int n15 = this.getArgbParam(++n2);
                        stringBuffer.append(" ").append(Escape.escapeColor(n15));
                        n2 = this.iToken;
                        this.addShapeProperty(arrayList, "colorRGB", n15);
                        bl19 = true;
                        if (this.isColorParam(n2 + 1)) {
                            n15 = this.getArgbParam(++n2);
                            n2 = this.iToken;
                            this.addShapeProperty(arrayList, "colorRGB", n15);
                            stringBuffer.append(" ").append(Escape.escapeColor(n15));
                            bl8 = true;
                            continue block102;
                        }
                        if (!bl31) continue block102;
                        this.error(23);
                        continue block102;
                    }
                    if (bl31 || sArray != null) continue block102;
                    this.error(23);
                    continue block102;
                }
                case 1073741873: {
                    if (!bl) {
                        this.error(22);
                    }
                    bl14 = !this.isSyntaxCheck;
                    continue block102;
                }
                case 1229984263: {
                    if (this.tokAt(n2 + 1) == 4) continue block102;
                    this.error(23);
                    continue block102;
                }
                case 1112541195: 
                case 1649412112: {
                    if (bl5) {
                        stringBuffer.append(" ").append(this.theToken.value);
                    }
                    RadiusData radiusData = this.encodeRadiusParameter(n2, false, true);
                    if (bl5) {
                        stringBuffer.append(" ").append(radiusData);
                    }
                    if (Float.isNaN(radiusData.value)) {
                        radiusData.value = 100.0f;
                    }
                    object = radiusData;
                    object2 = "radius";
                    bl13 = true;
                    if (bl7) {
                        bl5 = false;
                    }
                    n2 = this.iToken;
                    break;
                }
                case 135266319: {
                    bl6 = true;
                    object2 = "plane";
                    object = this.planeParameter(++n2);
                    n2 = this.iToken;
                    if (!bl5) break;
                    stringBuffer.append(" plane ").append(Escape.escape(object));
                    break;
                }
                case 1073742138: {
                    object2 = "scale";
                    object = Float.valueOf(this.floatParameter(++n2));
                    stringBuffer.append(" scale ").append(object);
                    break;
                }
                case 0x100003: {
                    if (bl19) {
                        this.error(22);
                    }
                    object2 = "thisID";
                    break;
                }
                case 1113198596: {
                    bl5 = true;
                    ++n2;
                    try {
                        object = this.getPoint4f(n2);
                        object2 = "ellipsoid";
                        n2 = this.iToken;
                        stringBuffer.append(" ellipsoid ").append(Escape.escape(object));
                    }
                    catch (ScriptException scriptException) {
                        try {
                            object2 = "ellipsoid";
                            object = this.floatParameterSet(n2, 6, 6);
                            n2 = this.iToken;
                            stringBuffer.append(" ellipsoid ").append(Escape.escape(object));
                        }
                        catch (ScriptException scriptException2) {
                            bitSet = this.atomExpression(n2);
                            stringBuffer.append(" ellipsoid ").append(Escape.escape(bitSet));
                            int n16 = bitSet.nextSetBit(0);
                            Atom[] atomArray = this.viewer.getModelSet().atoms;
                            if (n16 >= 0) {
                                object = atomArray[n16].getEllipsoid();
                            }
                            if (object == null) {
                                return;
                            }
                            n2 = this.iToken;
                            object2 = "ellipsoid";
                            if (this.isSyntaxCheck) break;
                            this.addShapeProperty(arrayList, "center", this.viewer.getAtomPoint3f(n16));
                        }
                    }
                    break;
                }
                case 135267841: {
                    bl6 = true;
                    object2 = "plane";
                    object = this.hklParameter(++n2);
                    n2 = this.iToken;
                    stringBuffer.append(" plane ").append(Escape.escape(object));
                    break;
                }
                case 135182: {
                    int n17;
                    bl5 = true;
                    String string6 = this.parameterAsString(++n2);
                    this.addShapeProperty(arrayList, "lcaoType", string6);
                    stringBuffer.append(" lcaocartoon ").append(Escape.escape(string6));
                    switch (this.getToken((int)(++n2)).tok) {
                        case 10: 
                        case 0x100001: {
                            object2 = "lcaoCartoon";
                            bitSet = this.atomExpression(n2);
                            n2 = this.iToken;
                            if (this.isSyntaxCheck) continue block102;
                            n17 = bitSet.nextSetBit(0);
                            if (n17 < 0) {
                                this.error(14);
                            }
                            stringBuffer.append(" ({").append(n17).append("})");
                            n8 = this.viewer.getAtomModelIndex(n17);
                            this.addShapeProperty(arrayList, "modelIndex", n8);
                            Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(this.viewer.getAtomPoint3f(n17)), new Vector3f()};
                            if (!string6.equalsIgnoreCase("s") && this.viewer.getHybridizationAndAxes(n17, vector3fArray[0], vector3fArray[1], string6) == null) {
                                return;
                            }
                            object = vector3fArray;
                            break;
                        }
                        default: {
                            this.error(14);
                            break;
                        }
                    }
                    break;
                }
                case 0x121012: {
                    int n18;
                    int n19;
                    boolean bl33;
                    int n17 = Integer.MAX_VALUE;
                    int n20 = Integer.MAX_VALUE;
                    boolean bl34 = bl33 = this.tokAt(n2 + 1) == 0x101000A0;
                    if (bl33) {
                        ++n2;
                    }
                    float[] fArray3 = null;
                    switch (this.tokAt(++n2)) {
                        case 0: {
                            this.error(2);
                            break;
                        }
                        case 1073741973: 
                        case 1073742008: {
                            n20 = this.moOffset(n2);
                            n17 = 0;
                            n2 = this.iToken;
                            if (!bl5) break;
                            stringBuffer.append(" mo " + (bl33 ? "-" : "") + "HOMO ");
                            if (n20 > 0) {
                                stringBuffer.append("+");
                            }
                            if (n20 == 0) break;
                            stringBuffer.append(n20);
                            break;
                        }
                        case 2: {
                            n17 = this.intParameter(n2);
                            if (!bl5) break;
                            stringBuffer.append(" mo ").append(n17);
                            break;
                        }
                        default: {
                            if (!this.isArrayParameter(n2)) break;
                            fArray3 = this.floatParameterSet(n2, 2, Integer.MAX_VALUE);
                            n2 = this.iToken;
                        }
                    }
                    if (this.tokAt(n2 + 1) == 0x8100010) {
                        ++n2;
                        n19 = this.intParameter(++n2);
                        n18 = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : (int)(-System.currentTimeMillis()) % 10000;
                        this.addShapeProperty(arrayList, "monteCarloCount", n19);
                        this.addShapeProperty(arrayList, "randomSeed", n18);
                        stringBuffer.append(" points ").append(n19).append(' ').append(n18);
                    }
                    this.setMoData(arrayList, n17, fArray3, n20, bl33, n8, null);
                    bl5 = true;
                    continue block102;
                }
                case 0x400000D4: {
                    int n19;
                    object2 = "nci";
                    if (bl5) {
                        stringBuffer.append(" " + (String)object2);
                    }
                    int n18 = (n19 = this.tokAt(n2 + 1)) != 1229984263 && n19 != 4 && n19 != 1073742033 ? 1 : 0;
                    object = n18 != 0;
                    if (n18 == 0) break;
                    bl5 = true;
                    break;
                }
                case 0x400000C0: 
                case 1073742022: {
                    boolean bl35 = this.theTok == 0x400000C0;
                    Object object5 = object2 = bl35 ? "mep" : "mlp";
                    if (bl5) {
                        stringBuffer.append(" " + (String)object2);
                    }
                    String string7 = null;
                    int n21 = -1;
                    bl5 = true;
                    if (this.tokAt(n2 + 1) == 2) {
                        n21 = this.intParameter(++n2);
                        stringBuffer.append(" " + n21);
                        this.addShapeProperty(arrayList, "mepCalcType", n21);
                    }
                    if (this.tokAt(n2 + 1) == 4) {
                        string7 = this.stringParameter(++n2);
                        if (bl5) {
                            stringBuffer.append(" /*file*/" + Escape.escape(string7));
                        }
                    } else if (this.tokAt(n2 + 1) == 1716520973) {
                        string5 = object2;
                        continue block102;
                    }
                    if (!this.isSyntaxCheck) {
                        try {
                            fArray = string7 == null && bl35 ? this.viewer.getPartialCharges() : this.viewer.getAtomicPotentials(bl35, bitSet2, bitSet3, string7);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.isSyntaxCheck && fArray == null) {
                        this.error(32);
                    }
                    object = fArray;
                    break;
                }
                case 1313866247: {
                    bl11 = !this.isSyntaxCheck;
                    stringBuffer.append(" volume");
                    break;
                }
                case 1074790550: {
                    this.setShapeId(n, ++n2, bl19);
                    bl20 = this.getShapeProperty(n, "ID") == null;
                    n2 = this.iToken;
                    break;
                }
                case 0x40000040: {
                    if (this.tokAt(n2 + 1) == 1073742180) {
                        bl21 = true;
                        ++n2;
                    }
                    if ((string4 = this.parameterAsString(++n2).toLowerCase()).equals("sets")) {
                        stringBuffer.append(" colorScheme \"sets\"");
                        break;
                    }
                    if (!this.isColorParam(n2)) break;
                    string4 = this.getColorRange(n2);
                    n2 = this.iToken;
                    break;
                }
                case 0x40000004: {
                    object2 = "addHydrogens";
                    object = Boolean.TRUE;
                    stringBuffer.append(" addHydrogens");
                    break;
                }
                case 0x4000000C: {
                    object2 = "angstroms";
                    stringBuffer.append(" angstroms");
                    break;
                }
                case 0x4000000E: {
                    object2 = "anisotropy";
                    object = this.getPoint3f(++n2, false);
                    stringBuffer.append(" anisotropy").append(Escape.escape((Point3f)object));
                    n2 = this.iToken;
                    break;
                }
                case 1073741842: {
                    bl10 = !this.isSyntaxCheck;
                    stringBuffer.append(" area");
                    break;
                }
                case 1073741850: 
                case 1073742076: {
                    bl5 = true;
                    if (bl8 && !bl9) {
                        stringBuffer.append(" phase \"_orb\"");
                        this.addShapeProperty(arrayList, "phase", "_orb");
                    }
                    float[] fArray4 = new float[7];
                    fArray4[0] = this.intParameter(++n2);
                    fArray4[1] = this.intParameter(++n2);
                    fArray4[2] = this.intParameter(++n2);
                    float f7 = fArray4[3] = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 6.0f;
                    if (bl5) {
                        stringBuffer.append(" atomicOrbital ").append((int)fArray4[0]).append(" ").append((int)fArray4[1]).append(" ").append((int)fArray4[2]).append(" ").append(fArray4[3]);
                    }
                    if (this.tokAt(n2 + 1) == 0x8100010) {
                        fArray4[4] = this.intParameter(n2 += 2);
                        fArray4[5] = this.tokAt(n2 + 1) == 3 ? this.floatParameter(++n2) : 0.0f;
                        fArray4[6] = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : (int)(-System.currentTimeMillis()) % 10000;
                        if (bl5) {
                            stringBuffer.append(" points ").append((int)fArray4[4]).append(' ').append(fArray4[5]).append(' ').append((int)fArray4[6]);
                        }
                    }
                    object2 = "hydrogenOrbital";
                    object = fArray4;
                    break;
                }
                case 1073741866: {
                    stringBuffer.append(" binary");
                    continue block102;
                }
                case 1073741868: {
                    stringBuffer.append(" blockData");
                    object2 = "blockData";
                    object = Boolean.TRUE;
                    break;
                }
                case 554176565: 
                case 1074790451: {
                    bl16 = true;
                    object2 = (String)this.theToken.value;
                    object = this.getCapSlabObject(n2, false);
                    n2 = this.iToken;
                    break;
                }
                case 0x40000034: {
                    float f8;
                    if (!bl) {
                        this.error(22);
                    }
                    bl12 = true;
                    if (this.isSyntaxCheck) continue block102;
                    float f9 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 1.2f;
                    float f10 = f8 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 10.0f;
                    if (f8 > 10.0f) {
                        this.integerOutOfRange(0, 10);
                    }
                    stringBuffer.append(" cavity ").append(f9).append(" ").append(f8);
                    this.addShapeProperty(arrayList, "envelopeRadius", Float.valueOf(f8));
                    this.addShapeProperty(arrayList, "cavityRadius", Float.valueOf(f9));
                    object2 = "cavity";
                    break;
                }
                case 0x40000048: 
                case 0x4000004C: {
                    object2 = "contour";
                    stringBuffer.append(" contour");
                    switch (this.tokAt(n2 + 1)) {
                        case 0x40000060: {
                            object = this.floatParameterSet(n2 + 2, 1, Integer.MAX_VALUE);
                            stringBuffer.append(" discrete ").append(Escape.escape(object));
                            n2 = this.iToken;
                            break block3;
                        }
                        case 1073741981: {
                            Point3f point3f = this.getPoint3f(n2 + 2, false);
                            if (point3f.z <= 0.0f || point3f.y < point3f.x) {
                                this.error(22);
                            }
                            if (point3f.z == (float)((int)point3f.z) && point3f.z > point3f.y - point3f.x) {
                                point3f.z = (point3f.y - point3f.x) / point3f.z;
                            }
                            object = point3f;
                            n2 = this.iToken;
                            stringBuffer.append(" increment ").append(Escape.escape(point3f));
                            break block3;
                        }
                    }
                    object = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : 0;
                    stringBuffer.append(" ").append(object);
                    break;
                }
                case 2: 
                case 3: 
                case 0x101000A1: 
                case 1073741910: {
                    stringBuffer.append(" cutoff ");
                    if (this.theTok == 1073741910) {
                        ++n2;
                    }
                    if (this.tokAt(n2) == 0x101000A1) {
                        object2 = "cutoffPositive";
                        f2 = this.floatParameter(++n2);
                        object = Float.valueOf(f2);
                        stringBuffer.append("+").append(object);
                        break;
                    }
                    if (this.isFloatParameter(n2)) {
                        object2 = "cutoff";
                        f2 = this.floatParameter(n2);
                        object = Float.valueOf(f2);
                        stringBuffer.append(object);
                        break;
                    }
                    object2 = "cutoffRange";
                    object = this.floatParameterSet(n2, 2, 2);
                    this.addShapeProperty(arrayList, "cutoff", Float.valueOf(0.0f));
                    stringBuffer.append(Escape.escape(object));
                    n2 = this.iToken;
                    break;
                }
                case 1073741928: {
                    object2 = "downsample";
                    object = this.intParameter(++n2);
                    if (!bl5) break;
                    stringBuffer.append(" downsample ").append(object);
                    break;
                }
                case 1073741930: {
                    object2 = "eccentricity";
                    object = this.getPoint4f(++n2);
                    if (bl5) {
                        stringBuffer.append(" eccentricity ").append(Escape.escape(object));
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1074790508: {
                    stringBuffer.append(" ed");
                    this.setMoData(arrayList, -1, null, 0, false, n8, null);
                    bl5 = true;
                    continue block102;
                }
                case 0x20000004: 
                case 1073742041: {
                    stringBuffer.append(" ").append(this.theToken.value);
                    object2 = "debug";
                    object = this.theTok == 0x20000004 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    stringBuffer.append(" fixed");
                    object2 = "fixed";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073741962: {
                    stringBuffer.append(" fullPlane");
                    object2 = "fullPlane";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073741966: 
                case 0x40000090: {
                    Object object6;
                    String string8;
                    boolean bl36 = this.theTok == 0x40000090;
                    object2 = "" + this.theToken.value;
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    object = arrayList2;
                    bl15 = true;
                    if (bl5) {
                        stringBuffer.append(" ").append((String)object2);
                    }
                    if ((string8 = this.parameterAsString(++n2)).equals("=")) {
                        if (bl5) {
                            stringBuffer.append(" =");
                        }
                        string8 = this.parameterAsString(++n2);
                        if (bl5) {
                            stringBuffer.append(" ").append(Escape.escape(string8));
                        }
                        arrayList2.add(string8);
                        if (!this.isSyntaxCheck) {
                            this.addShapeProperty(arrayList, "func", this.createFunction("__iso__", "x,y,z", string8));
                        }
                        bl5 = true;
                        break;
                    }
                    String string9 = Parser.getQuotedAttribute(this.fullCommand, "# DATA" + (bl15 ? "2" : ""));
                    if (string9 == null) {
                        string9 = "inline";
                    } else {
                        string8 = string9;
                    }
                    boolean bl37 = string8.indexOf("data2d_") == 0;
                    boolean bl38 = string8.indexOf("data3d_") == 0;
                    boolean bl39 = string8.equals("inline");
                    if (!bl5) {
                        stringBuffer.append(" inline");
                    }
                    arrayList2.add(string8);
                    Point3f point3f = this.getPoint3f(++n2, false);
                    if (!bl5) {
                        stringBuffer.append(" ").append(Escape.escape(point3f));
                    }
                    arrayList2.add(point3f);
                    int n22 = ++this.iToken;
                    Point4f point4f = this.getPoint4f(n22);
                    arrayList2.add(point4f);
                    if (!bl5) {
                        stringBuffer.append(" ").append(Escape.escape(point4f));
                    }
                    int n23 = (int)point4f.x;
                    int n24 = ++this.iToken;
                    point4f = this.getPoint4f(n24);
                    arrayList2.add(point4f);
                    if (!bl5) {
                        stringBuffer.append(" ").append(Escape.escape(point4f));
                    }
                    int n25 = (int)point4f.x;
                    point4f = this.getPoint4f(++this.iToken);
                    arrayList2.add(point4f);
                    if (!bl5) {
                        stringBuffer.append(" ").append(Escape.escape(point4f));
                    }
                    int n26 = (int)point4f.x;
                    if (n23 == 0 || n25 == 0 || n26 == 0) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        float[][] fArray5 = null;
                        object6 = null;
                        if (bl36) {
                            if (bl39) {
                                n23 = Math.abs(n23);
                                n25 = Math.abs(n25);
                                n26 = Math.abs(n26);
                                object6 = this.floatArraySet(++this.iToken, n23, n25, n26);
                            } else {
                                object6 = bl38 ? (Object)this.viewer.getDataFloat3D(string8) : (Object)this.viewer.functionXYZ(string8, n23, n25, n26);
                            }
                            n23 = Math.abs(n23);
                            n25 = Math.abs(n25);
                            n26 = Math.abs(n26);
                            if (object6 == null) {
                                this.iToken = n22;
                                this.error(53, "xyzdata is null.");
                            }
                            if (((Object)object6).length != n23 || ((Object)object6[0]).length != n25 || ((Object)object6[0][0]).length != n26) {
                                this.iToken = n22;
                                this.error(53, "xyzdata[" + ((Object)object6).length + "][" + ((Object)object6[0]).length + "][" + ((Object)object6[0][0]).length + "] is not of size [" + n23 + "][" + n25 + "][" + n26 + "]");
                            }
                            arrayList2.add(object6);
                            if (!bl5) {
                                stringBuffer.append(" ").append(Escape.escape(object6));
                            }
                        } else {
                            if (bl39) {
                                n23 = Math.abs(n23);
                                n25 = Math.abs(n25);
                                fArray5 = this.floatArraySet(++this.iToken, n23, n25);
                            } else if (bl37) {
                                fArray5 = this.viewer.getDataFloat2D(string8);
                                n23 = fArray5 == null ? 0 : fArray5.length;
                                n25 = 3;
                            } else {
                                fArray5 = this.viewer.functionXY(string8, n23, n25);
                                n23 = Math.abs(n23);
                                n25 = Math.abs(n25);
                            }
                            if (fArray5 == null) {
                                this.iToken = n22;
                                this.error(53, "fdata is null.");
                            }
                            if (fArray5.length != n23 && !bl37) {
                                this.iToken = n22;
                                this.error(53, "fdata length is not correct: " + fArray5.length + " " + n23 + ".");
                            }
                            for (int i = 0; i < n23; ++i) {
                                if (fArray5[i] == null) {
                                    this.iToken = n24;
                                    this.error(53, "fdata[" + i + "] is null.");
                                }
                                if (fArray5[i].length == n25) continue;
                                this.iToken = n24;
                                this.error(53, "fdata[" + i + "] is not the right length: " + fArray5[i].length + " " + n25 + ".");
                            }
                            arrayList2.add(fArray5);
                            if (!bl5) {
                                stringBuffer.append(" ").append(Escape.escape(fArray5));
                            }
                        }
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1073741970: {
                    object2 = "gridPoints";
                    stringBuffer.append(" gridPoints");
                    break;
                }
                case 1073741976: {
                    object2 = "ignore";
                    bitSet3 = this.atomExpression(++n2);
                    object = bitSet3;
                    stringBuffer.append(" ignore ").append(Escape.escape(object));
                    n2 = this.iToken;
                    break;
                }
                case 0x400000A0: {
                    object2 = "insideOut";
                    stringBuffer.append(" insideout");
                    break;
                }
                case 1073741986: 
                case 0x400000A4: 
                case 0x40000114: {
                    if (!bl5) {
                        stringBuffer.append(" ").append(this.theToken.value);
                    }
                    object2 = "pocket";
                    object = this.theTok == 0x40000114 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1073742002: {
                    object2 = "lobe";
                    object = this.getPoint4f(++n2);
                    n2 = this.iToken;
                    if (!bl5) {
                        stringBuffer.append(" lobe ").append(Escape.escape(object));
                    }
                    bl5 = true;
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    object2 = "lp";
                    object = this.getPoint4f(++n2);
                    n2 = this.iToken;
                    if (!bl5) {
                        stringBuffer.append(" lp ").append(Escape.escape(object));
                    }
                    bl5 = true;
                    break;
                }
                case 0x10101C: {
                    if (bl7 || this.statementLength == n2 + 1) {
                        this.error(22);
                    }
                    bl7 = true;
                    if ((bl12 || bl13 || bl17) && !bl5) {
                        bl5 = true;
                        this.addShapeProperty(arrayList, "bsSolvent", bl13 || bl17 ? new BitSet() : this.lookupIdentifierValue("solvent"));
                        this.addShapeProperty(arrayList, "sasurface", Float.valueOf(0.0f));
                    }
                    if (stringBuffer.length() == 0) {
                        Object object7 = this.getShapeProperty(23, "plane");
                        if (object7 == null) {
                            if (this.getShapeProperty(23, "contours") != null) {
                                this.addShapeProperty(arrayList, "nocontour", null);
                            }
                        } else {
                            this.addShapeProperty(arrayList, "plane", object7);
                            stringBuffer.append("plane ").append(Escape.escape(object7));
                            bl6 = true;
                        }
                    } else if (!bl5 && !bl6) {
                        this.error(22);
                    }
                    stringBuffer.append("; isosurface map");
                    object2 = "map";
                    object = bl5 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1073742014: {
                    object2 = "maxset";
                    object = this.intParameter(++n2);
                    stringBuffer.append(" maxSet ").append(object);
                    break;
                }
                case 0x400000C4: {
                    object2 = "minset";
                    object = this.intParameter(++n2);
                    stringBuffer.append(" minSet ").append(object);
                    break;
                }
                case 1073742112: {
                    bl5 = true;
                    object2 = "rad";
                    object = this.getPoint4f(++n2);
                    n2 = this.iToken;
                    if (bl5) break;
                    stringBuffer.append(" radical ").append(Escape.escape(object));
                    break;
                }
                case 0x400000CC: {
                    object2 = "fixed";
                    object = Boolean.FALSE;
                    stringBuffer.append(" modelBased");
                    break;
                }
                case 1073742030: 
                case 1073742136: 
                case 1613758488: {
                    float f11;
                    object3 = this.theToken.value;
                    if (this.theTok == 1073742030) {
                        object2 = "molecular";
                        if (!bl5) {
                            stringBuffer.append(" molecular");
                        }
                        f11 = 1.4f;
                    } else {
                        this.addShapeProperty(arrayList, "bsSolvent", this.lookupIdentifierValue("solvent"));
                        Object object8 = object2 = this.theTok == 1073742136 ? "sasurface" : "solvent";
                        if (!bl5) {
                            stringBuffer.append(" ").append(this.theToken.value);
                        }
                        float f12 = f11 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : this.viewer.getSolventProbeRadius();
                        if (!bl5) {
                            stringBuffer.append(" ").append(f11);
                        }
                    }
                    object = Float.valueOf(f11);
                    if (this.tokAt(n2 + 1) == 1073741961) {
                        this.addShapeProperty(arrayList, "doFullMolecular", null);
                        if (!bl5) {
                            stringBuffer.append(" full");
                        }
                        ++n2;
                    }
                    bl5 = true;
                    break;
                }
                case 1073742033: {
                    this.addShapeProperty(arrayList, "fileType", "MRC");
                    if (bl5) continue block102;
                    stringBuffer.append(" mrc");
                    continue block102;
                }
                case 0x400000EE: 
                case 0x400000F0: {
                    this.addShapeProperty(arrayList, "fileType", "Obj");
                    if (bl5) continue block102;
                    stringBuffer.append(" obj");
                    continue block102;
                }
                case 1073742034: {
                    this.addShapeProperty(arrayList, "fileType", "Msms");
                    if (bl5) continue block102;
                    stringBuffer.append(" msms");
                    continue block102;
                }
                case 1073742094: {
                    if (bl5) {
                        this.error(22);
                    }
                    object2 = "phase";
                    bl9 = true;
                    object = this.tokAt(n2 + 1) == 4 ? this.stringParameter(++n2) : "_orb";
                    stringBuffer.append(" phase ").append(Escape.escape(object));
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    object2 = "resolution";
                    object = Float.valueOf(this.floatParameter(++n2));
                    stringBuffer.append(" resolution ").append(object);
                    break;
                }
                case 1073742124: {
                    object2 = "reverseColor";
                    object = Boolean.TRUE;
                    stringBuffer.append(" reversecolor");
                    break;
                }
                case 1073742146: {
                    object2 = "sigma";
                    f = this.floatParameter(++n2);
                    object = Float.valueOf(f);
                    stringBuffer.append(" sigma ").append(object);
                    break;
                }
                case 1073742154: {
                    object2 = "sphere";
                    object = Float.valueOf(this.floatParameter(++n2));
                    if (!bl5) {
                        stringBuffer.append(" sphere ").append(object);
                    }
                    bl5 = true;
                    break;
                }
                case 1073742156: {
                    object2 = "squareData";
                    object = Boolean.TRUE;
                    stringBuffer.append(" squared");
                    break;
                }
                case 4: 
                case 1073741983: {
                    Object object6 = this.parameterAsString(n2);
                    String string10 = null;
                    boolean bl39 = ((String)object6).equalsIgnoreCase("inline");
                    if (this.tokAt(n2 + 1) == 4) {
                        string10 = this.stringParameter(++n2);
                        if (!bl39) {
                            this.addShapeProperty(arrayList, "calculationType", string10);
                        }
                    }
                    boolean bl40 = !bl5 && !bl6;
                    Object object9 = object2 = bl40 ? "readFile" : "mapColor";
                    if (bl39) {
                        if (string10 == null) {
                            this.error(22);
                        }
                        if (bl2) {
                            string10 = TextFormat.replaceAllCharacters(string10, "{,}|", ' ');
                        }
                        if (this.logMessages) {
                            Logger.debug("pmesh inline data:\n" + string10);
                        }
                        object = this.isSyntaxCheck ? null : string10;
                        this.addShapeProperty(arrayList, "fileName", "");
                        if (!bl5) {
                            stringBuffer.append(" INLINE");
                        }
                        bl5 = true;
                    } else {
                        String[] stringArray;
                        if (((String)object6).startsWith("=") && ((String)object6).length() > 1) {
                            String[] stringArray2 = (String[])this.viewer.setLoadFormat((String)object6, '_', false);
                            object6 = stringArray2[0];
                            String[] stringArray3 = stringArray = !bl40 || !Float.isNaN(f2) ? null : stringArray2[1];
                            if (stringArray != null && !this.isSyntaxCheck && (f2 = ScriptVariable.fValue(ScriptVariable.getVariable(this.viewer.evaluateExpression(stringArray)))) > 0.0f) {
                                if (!Float.isNaN(f)) {
                                    f2 *= f;
                                    f = Float.NaN;
                                    this.addShapeProperty(arrayList, "sigma", Float.valueOf(f));
                                }
                                this.addShapeProperty(arrayList, "cutoff", Float.valueOf(f2));
                                if (!bl5) {
                                    stringBuffer.append(" cutoff ").append(f2);
                                }
                            }
                            if (n6 == 0) {
                                object3 = "=xxxx";
                                if (n8 < 0) {
                                    n8 = this.viewer.getCurrentModelIndex();
                                }
                                bitSet = this.viewer.getModelUndeletedAtomsBitSet(n8);
                                this.getWithinDistanceVector(arrayList, 2.0f, null, bitSet, false);
                                if (!bl5) {
                                    stringBuffer.append(" within 2.0 ").append(Escape.escape(bitSet));
                                }
                            }
                            if (bl40) {
                                bl22 = true;
                            }
                        }
                        if (bl40 && this.viewer.getParameter("_fileType").equals("Pdb") && Float.isNaN(f) && Float.isNaN(f2)) {
                            this.addShapeProperty(arrayList, "sigma", Float.valueOf(-1.0f));
                            if (!bl5) {
                                stringBuffer.append(" sigma -1.0");
                            }
                        }
                        if (((String)object6).equals("TESTDATA") && testData != null) {
                            object = testData;
                            break;
                        }
                        if (((String)object6).equals("TESTDATA2") && testData2 != null) {
                            object = testData2;
                            break;
                        }
                        if (((String)object6).length() == 0) {
                            if (n8 < 0) {
                                n8 = this.viewer.getCurrentModelIndex();
                            }
                            if (bl5 || bl6) {
                                object = this.viewer.getModelAuxiliaryInfo(n8, "jmolMappedDataInfo");
                            }
                            if (object == null) {
                                object = this.viewer.getModelAuxiliaryInfo(n8, "jmolSurfaceInfo");
                            }
                            if (object != null) {
                                bl5 = true;
                                break;
                            }
                            object6 = this.getFullPathName();
                        }
                        int n27 = -1;
                        if (this.tokAt(n2 + 1) == 2) {
                            n27 = this.intParameter(++n2);
                            this.addShapeProperty(arrayList, "fileIndex", n27);
                        }
                        if (!this.isSyntaxCheck) {
                            String string11 = null;
                            if (this.fullCommand.indexOf("# FILE" + n5 + "=") >= 0) {
                                object6 = Parser.getQuotedAttribute(this.fullCommand, "# FILE" + n5);
                                if (this.tokAt(n2 + 1) == 1073741848) {
                                    n2 += 2;
                                }
                            } else if (this.tokAt(n2 + 1) == 1073741848) {
                                this.iToken = n2 += 2;
                                string11 = this.viewer.getFilePath(this.stringParameter(n2), false);
                                stringArray = this.viewer.getFullPathNameOrError(string11);
                                string11 = stringArray[0];
                                if (this.viewer.getPathForAllFiles() != "") {
                                    object6 = string11;
                                    string11 = null;
                                } else {
                                    this.addShapeProperty(arrayList, "localName", string11);
                                    this.viewer.setPrivateKeyForShape(n);
                                }
                            }
                            if (!((String)object6).startsWith("cache://")) {
                                stringArray = this.viewer.getFullPathNameOrError((String)object6);
                                object6 = stringArray[0];
                                if (stringArray[1] != null) {
                                    this.error(17, (String)object6 + ":" + stringArray[1]);
                                }
                            }
                            Logger.info("reading isosurface data from " + (String)object6);
                            this.addShapeProperty(arrayList, "fileName", object6);
                            if (string11 != null) {
                                object6 = string11;
                            }
                            if (!bl5) {
                                stringBuffer.append(" /*file*/").append(Escape.escape((String)object6));
                            }
                        }
                        if (!bl5 && n27 >= 0) {
                            stringBuffer.append(" ").append(n27);
                        }
                    }
                    if (!bl5 && string10 != null) {
                        stringBuffer.append(" ").append(Escape.escape(string10));
                    }
                    bl5 = true;
                    break;
                }
                case 4106: {
                    object2 = "connections";
                    switch (this.tokAt(++n2)) {
                        case 10: 
                        case 0x100001: {
                            object = new int[]{this.atomExpression(n2).nextSetBit(0)};
                            break;
                        }
                        default: {
                            object = new int[]{(int)this.floatParameterSet(n2, 1, 1)[0]};
                        }
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1073741999: {
                    object2 = "link";
                    if (bl5) break;
                    stringBuffer.append(" link");
                    break;
                }
                default: {
                    if (this.theTok == 0x40000000) {
                        object2 = "thisID";
                        object = string2;
                    }
                    if (!this.setMeshDisplayProperty(n, 0, this.theTok)) {
                        if (Token.tokAttr(this.theTok, 0x40000000) && !bl19) {
                            this.setShapeId(n, n2, bl19);
                            n2 = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n3 == 0) {
                        n3 = n2;
                    }
                    n2 = this.statementLength - 1;
                }
            }
            boolean bl41 = bl19 = this.theTok != 12291;
            if (bl20 && bl5) {
                this.error(22);
            }
            if (object2 == null) continue;
            this.addShapeProperty(arrayList, (String)object2, object);
        }
        if (!this.isSyntaxCheck) {
            ColorEncoder colorEncoder;
            if ((bl12 || bl13) && !bl5) {
                bl5 = true;
                this.addShapeProperty(arrayList, "bsSolvent", bl13 ? new BitSet() : this.lookupIdentifierValue("solvent"));
                this.addShapeProperty(arrayList, "sasurface", Float.valueOf(0.0f));
            }
            if (bl6 && !bl5 && !bl7) {
                this.addShapeProperty(arrayList, "nomap", Float.valueOf(0.0f));
                bl5 = true;
            }
            if (n4 >= 0) {
                this.addShapeProperty(arrayList, "getSurfaceSets", n4 - 1);
            }
            if (sArray != null) {
                this.addShapeProperty(arrayList, "colorDiscrete", sArray);
            } else if ("sets".equals(string4)) {
                this.addShapeProperty(arrayList, "setColorScheme", null);
            } else if (string4 != null && (colorEncoder = this.viewer.getColorEncoder(string4)) != null) {
                colorEncoder.isTranslucent = bl21;
                colorEncoder.hi = Float.MAX_VALUE;
                this.addShapeProperty(arrayList, "remapColor", colorEncoder);
            }
            if (bl5 && !bl4 && stringBuffer.indexOf(";") != 0) {
                arrayList.add(0, new Object[]{"newObject", null});
                int n28 = n2 = bitSet2 == null ? 1 : 0;
                if (n2 != 0) {
                    bitSet2 = BitSetUtil.copy(this.viewer.getSelectionSet(false));
                }
                if (n8 < 0) {
                    n8 = this.viewer.getCurrentModelIndex();
                }
                bitSet2.and(this.viewer.getModelUndeletedAtomsBitSet(n8));
                if (object3 != null) {
                    object2 = this.viewer.getModelBitSet(bitSet2, false);
                    if (((BitSet)object2).cardinality() != 1) {
                        this.error(30, "ISOSURFACE " + object3);
                    }
                    if (n2 != 0) {
                        arrayList.add(0, new Object[]{"select", bitSet2});
                        if (stringBuffer.indexOf("; isosurface map") == 0) {
                            stringBuffer = new StringBuffer("; isosurface map select " + Escape.escape(bitSet2) + stringBuffer.substring(16));
                        }
                    }
                }
            }
            if (bl17 && !bl16) {
                if (!bl5) {
                    this.addShapeProperty(arrayList, "sasurface", Float.valueOf(0.0f));
                }
                if (!bl7) {
                    this.addShapeProperty(arrayList, "map", Boolean.TRUE);
                    this.addShapeProperty(arrayList, "select", bitSet);
                    this.addShapeProperty(arrayList, "sasurface", Float.valueOf(0.0f));
                }
                this.addShapeProperty(arrayList, "slab", this.getCapSlabObject(-100, false));
            }
            this.setShapeProperty(n, "setProperties", arrayList);
            if (bl22) {
                this.setShapeProperty(n, "token", 1073742018);
                this.setShapeProperty(n, "token", 1073742046);
                this.setShapeProperty(n, "token", 0x40000088);
                stringBuffer.append(" mesh nofill frontOnly");
            }
        }
        if (n3 > 0 && !this.setMeshDisplayProperty(n, n3, 0)) {
            this.error(22);
        }
        Object object10 = null;
        object2 = null;
        if (bl10) {
            object10 = this.getShapeProperty(n, "area");
            if (object10 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceArea", ((Float)object10).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceArea", ScriptVariable.getVariable(object10));
            }
        }
        if (bl11) {
            Object object11 = object2 = bl11 ? this.getShapeProperty(n, "volume") : null;
            if (object2 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceVolume", ((Float)object2).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceVolume", ScriptVariable.getVariable(object2));
            }
        }
        if (!bl4) {
            if (bl7 && !bl5) {
                this.setShapeProperty(n, "finalize", stringBuffer.toString());
            } else if (bl5) {
                string = stringBuffer.toString();
                this.setShapeProperty(n, "finalize", (string.indexOf("; isosurface map") == 0 ? "" : " select " + Escape.escape(bitSet2) + " ") + string);
                object = (String)this.getShapeProperty(n, "ID");
                if (object != null && !this.tQuiet) {
                    float[] fArray6;
                    f2 = ((Float)this.getShapeProperty(n, "cutoff")).floatValue();
                    if (Float.isNaN(f2) && !Float.isNaN(f)) {
                        Logger.error("sigma not supported");
                    }
                    object = (String)object + " created";
                    if (bl) {
                        object = (String)object + " with cutoff=" + f2;
                    }
                    if ((fArray6 = (float[])this.getShapeProperty(n, "minMaxInfo"))[0] != Float.MAX_VALUE) {
                        object = (String)object + " min=" + fArray6[0] + " max=" + fArray6[1];
                    }
                    object = (String)object + "; " + JmolConstants.shapeClassBases[n].toLowerCase() + " count: " + this.getShapeProperty(n, "count");
                    object = (String)object + this.getIsosurfaceDataRange(n, "\n");
                    if (bl10) {
                        object = (String)object + "\nisosurfaceArea = " + Escape.escapeArray(object10);
                    }
                    if (bl11) {
                        object = (String)object + "\nisosurfaceVolume = " + Escape.escapeArray(object2);
                    }
                    this.showString((String)object);
                }
            } else if (bl10 || bl11) {
                if (bl10) {
                    this.showString("isosurfaceArea = " + Escape.escapeArray(object10));
                }
                if (bl11) {
                    this.showString("isosurfaceVolume = " + Escape.escapeArray(object2));
                }
            }
        }
        if (string3 != null) {
            this.setShapeProperty(n, "translucency", string3);
        }
        this.setShapeProperty(n, "clear", null);
        if (bl14) {
            object = (String)this.getShapeProperty(n, "ID");
            this.viewer.cachePut("isosurface_" + object, this.write(new Token[]{new Token(135180, "isosurface")}));
            this.runScript("isosurface ID \"" + (String)object + "\" delete;isosurface ID \"" + (String)object + "\"" + (n8 >= 0 ? " model " + n8 : "") + " \"cache://isosurface_" + this.getShapeProperty(n, "ID") + "\"");
        }
    }

    private String getColorRange(int n) throws ScriptException {
        int n2 = this.getArgbParam(n);
        if (this.tokAt(++this.iToken) != 1074790746) {
            this.error(22);
        }
        int n3 = this.getArgbParam(++this.iToken);
        int n4 = this.tokAt(this.iToken + 1) == 2 ? this.intParameter(++this.iToken) : 0;
        return ColorEncoder.getColorSchemeList(ColorEncoder.getPaletteAtoB(n2, n3, n4));
    }

    private String getIsosurfaceDataRange(int n, String string) {
        float[] fArray = (float[])this.getShapeProperty(n, "dataRange");
        return fArray != null && fArray[0] != Float.MAX_VALUE && fArray[0] != fArray[1] ? string + "isosurface" + " full data range " + fArray[0] + " to " + fArray[1] + " with color scheme spanning " + fArray[2] + " to " + fArray[3] : "";
    }

    private void getWithinDistanceVector(List<Object[]> list, float f, Point3f point3f, BitSet bitSet, boolean bl) {
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        Point3f[] point3fArray = new Point3f[2];
        if (bitSet == null) {
            Point3f point3f2 = new Point3f(f, f, f);
            Point3f point3f3 = new Point3f(point3f);
            point3f3.sub(point3f2);
            point3f2.add(point3f);
            point3fArray[0] = point3f3;
            point3fArray[1] = point3f2;
            arrayList.add(point3f);
        } else {
            BoxInfo boxInfo = this.viewer.getBoxInfo(bitSet, -Math.abs(f));
            point3fArray[0] = boxInfo.getBboxVertices()[0];
            point3fArray[1] = boxInfo.getBboxVertices()[7];
            if (bitSet.cardinality() == 1) {
                arrayList.add(this.viewer.getAtomPoint3f(bitSet.nextSetBit(0)));
            }
        }
        if (arrayList.size() == 1 && !bl) {
            this.addShapeProperty(list, "withinDistance", Float.valueOf(f));
            this.addShapeProperty(list, "withinPoint", arrayList.get(0));
        }
        this.addShapeProperty(list, bl ? "displayWithin" : "withinPoints", new Object[]{Float.valueOf(f), point3fArray, bitSet, arrayList});
    }

    private boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        boolean bl;
        String string = null;
        Serializable serializable = null;
        boolean bl2 = n == 24;
        boolean bl3 = bl = n2 == 0;
        if (!bl) {
            n3 = this.getToken((int)n2).tok;
        }
        switch (n3) {
            case 0x400000AA: {
                if (n != 23) {
                    return false;
                }
                if (bl) {
                    return true;
                }
                Point3f point3f = this.getPoint3f(this.iToken + 1, false);
                point3f.x = (int)point3f.x;
                point3f.y = (int)point3f.y;
                point3f.z = (int)point3f.z;
                string = "lattice";
                serializable = point3f;
                break;
            }
            case 1766856708: {
                if (!bl2) break;
                ++this.iToken;
            }
            case 1073742074: 
            case 1073742180: {
                if (!bl) {
                    this.colorShape(n, this.iToken, false);
                }
                return true;
            }
            case 0: 
            case 12291: 
            case 12294: 
            case 0x10000C: 
            case 0x10000D: 
            case 3145768: 
            case 3145770: 
            case 1610625028: {
                if (this.iToken == 1 && n >= 0 && this.tokAt(2) == 0) {
                    this.setShapeProperty(n, "thisID", null);
                }
                if (n3 == 0) {
                    return this.iToken == 1;
                }
                if (bl) {
                    return true;
                }
                switch (n3) {
                    case 12291: {
                        this.setShapeProperty(n, "delete", null);
                        return true;
                    }
                    case 12294: 
                    case 3145770: {
                        n3 = 0x10000C;
                        break;
                    }
                    case 3145768: {
                        n3 = 0x10000D;
                        break;
                    }
                    case 1610625028: {
                        if (n2 + 1 != this.statementLength) break;
                        n3 = 0x10000D;
                    }
                }
            }
            case 1073741862: 
            case 0x4000004A: 
            case 1073741938: 
            case 1073741958: 
            case 0x40000088: 
            case 1073741964: 
            case 1073742018: 
            case 1073742039: 
            case 1073742042: 
            case 1073742046: 
            case 0x400000E4: 
            case 1073742058: 
            case 1073742060: 
            case 1073742182: 
            case 1113198595: {
                string = "token";
                serializable = n3;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, serializable);
        if (this.tokAt(this.iToken + 1) != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, 0)) {
            --this.iToken;
        }
        return true;
    }

    private void bind() throws ScriptException {
        String string = this.stringParameter(1);
        String string2 = this.parameterAsString(2);
        Point3f point3f = null;
        Point3f point3f2 = null;
        this.checkLength(3);
        if (!this.isSyntaxCheck) {
            this.viewer.bindAction(string, string2, point3f, point3f2);
        }
    }

    private void unbind() throws ScriptException {
        if (this.statementLength != 1) {
            this.checkLength23();
        }
        String string = this.optParameterAsString(1);
        String string2 = this.optParameterAsString(2);
        if (string.length() == 0 || this.tokAt(1) == 0x100003) {
            string = null;
        }
        if (string2.length() == 0 || this.tokAt(2) == 0x100003) {
            string2 = null;
        }
        if (string2 == null && string != null && ActionManager.getActionFromName(string) >= 0) {
            string2 = string;
            string = null;
        }
        if (!this.isSyntaxCheck) {
            this.viewer.unBindAction(string, string2);
        }
    }

    private void undoRedoMove() throws ScriptException {
        int n = 1;
        int n2 = 2;
        switch (this.tokAt(1)) {
            case 0: {
                n2 = 1;
                break;
            }
            case 0x100003: {
                n = 0;
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.checkLength(n2);
        if (!this.isSyntaxCheck) {
            this.viewer.undoMoveAction(this.tokAt(0), n);
        }
    }

    BitSet getAtomsNearSurface(float f, String string) {
        Object[] objectArray = new Object[]{string, null, null};
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        if (this.getShapeProperty(23, "getVertices", objectArray)) {
            return this.viewer.getAtomsWithin(f, (Point3f[])objectArray[1], (BitSet)objectArray[2]);
        }
        objectArray[1] = 0;
        objectArray[2] = -1;
        if (this.getShapeProperty(22, "getCenter", objectArray)) {
            return this.viewer.getAtomsWithin(f, (Point3f)objectArray[2]);
        }
        return new BitSet();
    }

    static int getFloatEncodedInt(String string) {
        int n = string.indexOf(".");
        if (n < 1 || string.charAt(0) == '-' || string.endsWith(".") || string.contains(".0")) {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 0) {
            try {
                n2 = Integer.parseInt(string.substring(0, n));
                if (n2 < 0) {
                    n2 = -n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        if (n < string.length() - 1) {
            try {
                n3 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (n2 = n2 * 1000000 + n3) < 0 ? Integer.MAX_VALUE : n2;
    }

    static int getPartialBondOrderFromFloatEncodedInt(int n) {
        return (n / 1000000 % 6 << 5) + (n % 1000000 & 0x1F);
    }

    static int getBondOrderFromString(String string) {
        return string.indexOf(32) < 0 ? JmolEdge.getBondOrderFromString(string) : (string.toLowerCase().indexOf("partial ") == 0 ? ScriptEvaluator.getPartialBondOrderFromString(string.substring(8).trim()) : 131071);
    }

    private static int getPartialBondOrderFromString(String string) {
        return ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(ScriptEvaluator.getFloatEncodedInt(string));
    }

    class ScriptException
    extends Exception {
        private String message;
        private String untranslated;

        ScriptException(String string, String string2) {
            ScriptEvaluator.this.errorType = this.message = string;
            ScriptEvaluator.this.iCommandError = ScriptEvaluator.this.pc;
            String string3 = this.untranslated = string2 == null ? string : string2;
            if (this.message == null) {
                this.message = "";
                return;
            }
            String string4 = ScriptEvaluator.this.getScriptContext().getContextTrace(null, true).toString();
            while (ScriptEvaluator.this.thisContext != null) {
                ScriptEvaluator.this.popContext(false, false);
            }
            this.message = this.message + string4;
            this.untranslated = this.untranslated + string4;
            if (ScriptEvaluator.this.isSyntaxCheck || string.indexOf("file recognized as a script file:") >= 0) {
                return;
            }
            Logger.error("eval ERROR: " + this.toString());
            if (ScriptEvaluator.this.viewer.autoExit) {
                ScriptEvaluator.this.viewer.exitJmol();
            }
        }

        protected String getErrorMessageUntranslated() {
            return this.untranslated;
        }

        public String toString() {
            return this.message;
        }
    }
}

