/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3f;
import jspecview.util.TextFormat;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class GaussianReader
extends MOReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private String energyString = "";
    private String energyKey = "";
    private int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    private int stepNumber;

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Step number")) {
            this.equivalentAtomSets = 0;
            ++this.stepNumber;
            int n = this.line.indexOf("scan point");
            this.scanPoint = n > 0 ? this.parseInt(this.line, n + 10) : -1;
            return true;
        }
        if (this.line.indexOf("-- Stationary point found") > 0) {
            if (this.scanPoint >= 0) {
                ++this.scanPoint;
            }
            return true;
        }
        if (this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            Logger.info((String)(this.atomSetCollection.getAtomSetCount() + " model " + this.modelNumber + " step " + this.stepNumber + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line));
            this.readAtoms();
            return false;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" Energy=")) {
            this.setEnergy();
            return true;
        }
        if (this.line.startsWith(" SCF Done:")) {
            this.readSCFDone();
            return true;
        }
        if (this.line.startsWith(" Harmonic frequencies")) {
            this.readFrequencies();
            return true;
        }
        if (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:")) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith(" Dipole moment")) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.startsWith(" Standard basis:") || this.line.startsWith(" General basis read from")) {
            this.energyUnits = "";
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" AO basis set")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0 || this.line.indexOf("Natural Orbital Coefficients") >= 0 || this.line.indexOf("Natural Transition Orbitals") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals();
            Logger.info((String)(this.orbitals.size() + " molecular orbitals read"));
            return true;
        }
        if (this.line.startsWith(" Normal termination of Gaussian")) {
            ++this.calculationNumber;
            this.equivalentAtomSets = 0;
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        String[] stringArray = GaussianReader.getTokens((String)this.line, (int)11);
        if (stringArray.length < 4) {
            return;
        }
        this.energyKey = stringArray[0];
        this.atomSetCollection.setAtomSetEnergy(stringArray[2], this.parseFloat(stringArray[2]));
        this.energyString = stringArray[2] + " " + stringArray[3];
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyString, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetPropertyForSets(this.energyKey, this.energyString, this.equivalentAtomSets);
        stringArray = GaussianReader.getTokens((String)this.readLine());
        if (stringArray.length > 2) {
            this.atomSetCollection.setAtomSetPropertyForSets(stringArray[0], stringArray[2], this.equivalentAtomSets);
            if (stringArray.length > 5) {
                this.atomSetCollection.setAtomSetPropertyForSets(stringArray[3], stringArray[5], this.equivalentAtomSets);
            }
            stringArray = GaussianReader.getTokens((String)this.readLine());
        }
        if (stringArray.length > 2) {
            this.atomSetCollection.setAtomSetPropertyForSets(stringArray[0], stringArray[2], this.equivalentAtomSets);
        }
    }

    private void setEnergy() {
        String[] stringArray = this.getTokens();
        this.energyKey = "Energy";
        this.energyString = stringArray[1];
        this.atomSetCollection.setAtomSetNames("Energy = " + stringArray[1], this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetEnergy(this.energyString, this.parseFloat(this.energyString));
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyString);
        this.atomSetCollection.setAtomSetEnergy(this.energyString, this.parseFloat(this.energyString));
        String string = this.getTokens()[0];
        this.readLines(4);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String[] stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)this.parseInt(stringArray[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            int n = stringArray.length - 3;
            this.setAtomCoord(atom, this.parseFloat(stringArray[n]), this.parseFloat(stringArray[++n]), this.parseFloat(stringArray[++n]));
        }
        this.atomSetCollection.setAtomSetModelProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + string);
    }

    private void readBasis() throws Exception {
        int n;
        int n2;
        String string;
        int[] nArray;
        String[] stringArray;
        boolean bl;
        this.shells = new ArrayList();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n3 = 0;
        this.gaussianCount = 0;
        this.shellCount = 0;
        String string2 = "";
        boolean bl2 = this.calculationType != null && this.calculationType.indexOf("5D") > 0;
        boolean bl3 = this.calculationType != null && this.calculationType.indexOf("7F") > 0;
        boolean bl4 = bl = this.line.indexOf("general basis input") >= 0;
        if (bl) {
            while (this.readLine() != null && this.line.length() > 0) {
                ++this.shellCount;
                stringArray = this.getTokens();
                ++n3;
                while (this.readLine().indexOf("****") < 0) {
                    nArray = new int[4];
                    nArray[0] = n3 - 1;
                    stringArray = this.getTokens();
                    string = stringArray[0];
                    nArray[1] = bl3 && string.indexOf("F") >= 0 || bl2 && string.indexOf("D") >= 0 ? JmolAdapter.getQuantumShellTagIDSpherical((String)string) : JmolAdapter.getQuantumShellTagID((String)string);
                    n2 = this.parseInt(stringArray[1]);
                    nArray[2] = this.gaussianCount;
                    nArray[3] = n2;
                    if (Logger.debugging) {
                        Logger.info((String)("Slater " + this.shells.size() + " " + Escape.escape((Object)nArray)));
                    }
                    this.shells.add(nArray);
                    this.gaussianCount += n2;
                    for (n = 0; n < n2; ++n) {
                        this.readLine();
                        this.line = TextFormat.simpleReplace((String)this.line, (String)"D ", (String)"D+");
                        stringArray = this.getTokens();
                        if (Logger.debugging) {
                            Logger.info((String)("Gaussians " + (n + 1) + " " + Escape.escape((Object)stringArray)));
                        }
                        arrayList.add(stringArray);
                    }
                }
            }
        } else {
            while (this.readLine() != null && this.line.startsWith(" Atom")) {
                ++this.shellCount;
                stringArray = this.getTokens();
                nArray = new int[4];
                if (!stringArray[1].equals(string2)) {
                    ++n3;
                }
                string2 = stringArray[1];
                nArray[0] = n3 - 1;
                string = stringArray[4];
                nArray[1] = bl3 && string.indexOf("F") >= 0 || bl2 && string.indexOf("D") >= 0 ? JmolAdapter.getQuantumShellTagIDSpherical((String)string) : JmolAdapter.getQuantumShellTagID((String)string);
                n2 = this.parseInt(stringArray[5]);
                nArray[2] = this.gaussianCount;
                nArray[3] = n2;
                this.shells.add(nArray);
                this.gaussianCount += n2;
                for (n = 0; n < n2; ++n) {
                    arrayList.add(GaussianReader.getTokens((String)this.readLine()));
                }
            }
        }
        if (n3 == 0) {
            n3 = 1;
        }
        this.gaussians = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            stringArray = (String[])arrayList.get(i);
            this.gaussians[i] = new float[stringArray.length];
            for (int j = 0; j < stringArray.length; ++j) {
                this.gaussians[i][j] = this.parseFloat(stringArray[j]);
            }
        }
        Logger.info((String)(this.shellCount + " slater shells read"));
        Logger.info((String)(this.gaussianCount + " gaussian primitives read"));
    }

    private void readMolecularOrbitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        Map[] mapArray = ArrayUtil.createArrayOfHashtable((int)5);
        List[] listArray = ArrayUtil.createArrayOfArrayList((int)5);
        int n = 0;
        boolean bl = this.line.contains("Natural Orbital");
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            String[] stringArray;
            if (this.line.indexOf("                    ") == 0) {
                int n2;
                this.addMOData(n, listArray, mapArray);
                if (bl) {
                    stringArray = GaussianReader.getTokens((String)this.line);
                    n = stringArray.length;
                    stringArray = GaussianReader.getTokens((String)this.readLine());
                } else {
                    stringArray = GaussianReader.getTokens((String)this.readLine());
                    n = stringArray.length;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    mapArray[n2] = new Hashtable();
                    listArray[n2] = new ArrayList();
                    if (bl) {
                        mapArray[n2].put("occupancy", new Float(Parser.parseFloat((String)stringArray[n2 + 2])));
                        continue;
                    }
                    String string = stringArray[n2];
                    mapArray[n2].put("symmetry", string);
                    if (string.indexOf("O") >= 0) {
                        mapArray[n2].put("occupancy", new Float(2.0f));
                        continue;
                    }
                    if (string.indexOf("V") < 0) continue;
                    mapArray[n2].put("occupancy", new Float(0.0f));
                }
                if (bl) continue;
                this.line = this.readLine().substring(21);
                stringArray = this.getTokens();
                if (stringArray.length != n) {
                    stringArray = GaussianReader.getStrings((String)this.line, (int)n, (int)10);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    mapArray[n2].put("energy", new Float(stringArray[n2]));
                }
                continue;
            }
            if (this.line.length() < 21 || this.line.charAt(5) != ' ' && !Character.isDigit(this.line.charAt(5))) continue;
            try {
                this.line = TextFormat.simpleReplace((String)this.line, (String)" 0 ", (String)"0  ");
                stringArray = this.getTokens();
                String string = stringArray[stringArray.length - n - 1].substring(1);
                if (Character.isDigit(string.charAt(0))) {
                    string = string.substring(1);
                }
                if (!this.isQuantumBasisSupported(string.charAt(0)) && "XYZ".indexOf(string.charAt(0)) >= 0) {
                    string = (string.length() == 2 ? "D" : "F") + string;
                }
                if (!this.isQuantumBasisSupported(string.charAt(0))) continue;
                stringArray = GaussianReader.getStrings((String)this.line.substring(this.line.length() - 10 * n), (int)n, (int)10);
                for (int i = 0; i < n; ++i) {
                    listArray[i].add(stringArray[i]);
                }
            }
            catch (Exception exception) {
                Logger.error((String)("Error reading Gaussian file Molecular Orbitals at line: " + this.line));
                break;
            }
        }
        this.addMOData(n, listArray, mapArray);
        this.setMOData(false);
    }

    private void readFrequencies() throws Exception, IOException {
        this.discardLinesUntilContains(":");
        if (this.line == null) {
            throw new Exception("No frequencies encountered");
        }
        while ((this.line = this.readLine()) != null && this.line.length() > 15) {
            String[] stringArray = GaussianReader.getTokens((String)this.readLine());
            String[] stringArray2 = GaussianReader.getTokens((String)this.discardLinesUntilStartsWith(" Frequencies"), (int)15);
            String[] stringArray3 = GaussianReader.getTokens((String)this.discardLinesUntilStartsWith(" Red. masses"), (int)15);
            String[] stringArray4 = GaussianReader.getTokens((String)this.discardLinesUntilStartsWith(" Frc consts"), (int)15);
            String[] stringArray5 = GaussianReader.getTokens((String)this.discardLinesUntilStartsWith(" IR Inten"), (int)15);
            int n = this.atomSetCollection.getAtomCount();
            int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
            int n3 = stringArray2.length;
            boolean[] blArray = new boolean[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetFrequency("Calculation " + this.calculationNumber, stringArray[i], stringArray2[i], null);
                this.atomSetCollection.setAtomSetModelProperty("ReducedMass", stringArray3[i] + " AMU");
                this.atomSetCollection.setAtomSetModelProperty("ForceConstant", stringArray4[i] + " mDyne/A");
                this.atomSetCollection.setAtomSetModelProperty("IRIntensity", stringArray5[i] + " KM/Mole");
            }
            this.discardLinesUntilContains(" AN ");
            this.fillFrequencyData(n, n2, n2, blArray, true, 0, 0, null, 0);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] stringArray = GaussianReader.getTokens((String)this.readLine());
        if (stringArray.length != 8) {
            return;
        }
        Vector3f vector3f = new Vector3f(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[5]));
        Logger.info((String)("Molecular dipole for model " + this.atomSetCollection.getAtomSetCount() + " = " + vector3f));
        this.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", (Object)vector3f);
    }

    void readPartialCharges() throws Exception {
        this.readLine();
        int n = this.atomSetCollection.getAtomCount();
        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n2; i < n; ++i) {
            float f;
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            atomArray[i].partialCharge = f = this.parseFloat(GaussianReader.getTokens((String)this.readLine())[2]);
        }
        Logger.info((String)("Mulliken charges found for Model " + this.atomSetCollection.getAtomSetCount()));
    }
}

