/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Vectors;

public class VectorsRenderer
extends ShapeRenderer {
    private static final float arrowHeadOffset = -0.2f;
    private final Vector3f vector2 = new Vector3f();
    private final Point3f pointVectorEnd = new Point3f();
    private final Point3f pointArrowHead = new Point3f();
    private final Point3i screenVectorEnd = new Point3i();
    private final Point3i screenArrowHead = new Point3i();
    private final Vector3f headOffsetVector = new Vector3f();
    private int diameter;
    private int headWidthPixels;
    private float vectorScale;
    private boolean vectorSymmetry;
    private float headScale;
    private boolean doShaft;

    protected void render() {
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return;
        }
        short[] sArray = vectors.mads;
        if (sArray == null) {
            return;
        }
        Atom[] atomArray = vectors.atoms;
        short[] sArray2 = vectors.colixes;
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Vector3f vector3f;
            Atom atom = atomArray[n];
            if (!atom.isVisible(this.myVisibilityFlag) || (vector3f = this.viewer.getVibrationVector(n)) == null) continue;
            this.vectorScale = this.viewer.getVectorScale();
            this.vectorSymmetry = this.viewer.getVectorSymmetry();
            if (!this.transform(sArray[n], atom, vector3f) || !this.g3d.setColix(Shape.getColix((short[])sArray2, (int)n, (Atom)atom))) continue;
            this.renderVector(atom);
            if (!this.vectorSymmetry) continue;
            this.vector2.set((Tuple3f)vector3f);
            this.vector2.scale(-1.0f);
            this.transform(sArray[n], atom, this.vector2);
            this.renderVector(atom);
        }
    }

    private boolean transform(short s, Atom atom, Vector3f vector3f) {
        float f = vector3f.length();
        if ((double)Math.abs(f * this.vectorScale) < 0.01) {
            return false;
        }
        this.headScale = -0.2f;
        if (this.vectorScale < 0.0f) {
            this.headScale = -this.headScale;
        }
        this.doShaft = 0.1 + (double)Math.abs(this.headScale / f) < (double)Math.abs(this.vectorScale);
        this.headOffsetVector.set((Tuple3f)vector3f);
        this.headOffsetVector.scale(this.headScale / f);
        this.pointVectorEnd.scaleAdd(this.vectorScale, (Tuple3f)vector3f, (Tuple3f)atom);
        this.pointArrowHead.set((Tuple3f)this.pointVectorEnd);
        this.pointArrowHead.add((Tuple3f)this.headOffsetVector);
        this.screenArrowHead.set((Tuple3i)this.viewer.transformPoint(this.pointArrowHead, vector3f));
        this.screenVectorEnd.set((Tuple3i)this.viewer.transformPoint(this.pointVectorEnd, vector3f));
        this.diameter = s < 1 ? 1 : (s <= 20 ? (int)s : (int)this.viewer.scaleToScreen(this.screenVectorEnd.z, (int)s));
        this.headWidthPixels = (int)((float)this.diameter * 2.0f);
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        return true;
    }

    private void renderVector(Atom atom) {
        if (this.doShaft) {
            this.g3d.fillCylinderScreen((byte)1, this.diameter, atom.screenX, atom.screenY, atom.screenZ, this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
        }
        this.g3d.fillConeScreen((byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd, false);
    }
}

