/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumVdw;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.script.Token;
import org.jmol.shape.Shape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeManager {
    private Graphics3D g3d;
    private ModelSet modelSet;
    private Shape[] shapes;
    private Viewer viewer;
    private static final int[] hoverable = new int[]{29, 24, 23, 22, 34};
    private static int clickableMax = hoverable.length - 1;
    private final BitSet bsRenderableAtoms = new BitSet();
    private final int[] navigationCrossHairMinMax = new int[4];

    public ShapeManager(Viewer viewer, ModelSet modelSet) {
        this(viewer);
        this.resetShapes();
        this.loadDefaultShapes(modelSet);
    }

    ShapeManager(Viewer viewer) {
        this.viewer = viewer;
        this.g3d = viewer.getGraphics3D();
    }

    public void findNearestShapeAtomIndex(int n, int n2, Atom[] atomArray, BitSet bitSet) {
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length && atomArray[0] == null; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].findNearestAtomIndex(n, n2, atomArray, bitSet);
            }
        }
    }

    public Shape[] getShapes() {
        return this.shapes;
    }

    public Object getShapeProperty(int n, String string, int n2) {
        if (this.shapes == null || this.shapes[n] == null) {
            return null;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        Object object = this.shapes[n].getProperty(string, n2);
        this.viewer.setShapeErrorState(-1, null);
        return object;
    }

    public boolean getShapeProperty(int n, String string, Object[] objectArray) {
        if (this.shapes == null || this.shapes[n] == null) {
            return false;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        boolean bl = this.shapes[n].getProperty(string, objectArray);
        this.viewer.setShapeErrorState(-1, null);
        return bl;
    }

    public int getShapeIdFromObjectName(String string) {
        if (this.shapes != null) {
            for (int i = 16; i < 29; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void loadDefaultShapes(ModelSet modelSet) {
        this.modelSet = modelSet;
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(modelSet);
            }
        }
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(6);
        this.loadShape(31);
        this.loadShape(32);
    }

    public Shape loadShape(int n) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[n] != null) {
            return this.shapes[n];
        }
        if (n == 2 || n == 3 || n == 4) {
            return null;
        }
        String string = JmolConstants.getShapeClassName(n);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            this.viewer.setShapeErrorState(n, "allocate");
            shape.initializeShape(this.viewer, this.g3d, this.modelSet, n);
            this.viewer.setShapeErrorState(-1, null);
            this.shapes[n] = shape;
            return this.shapes[n];
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate shape:" + string, exception);
            return null;
        }
    }

    public void refreshShapeTrajectories(int n, BitSet bitSet, Matrix4f matrix4f) {
        Integer n2 = n;
        BitSet bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(n);
        for (int i = 0; i < 35; ++i) {
            if (this.shapes[i] == null) continue;
            this.setShapeProperty(i, "refreshTrajectories", new Object[]{n2, bitSet, matrix4f}, bitSet2);
        }
    }

    public void releaseShape(int n) {
        if (this.shapes != null) {
            this.shapes[n] = null;
        }
    }

    public void resetShapes() {
        if (!this.viewer.noGraphicsAllowed()) {
            this.shapes = new Shape[35];
        }
    }

    public void setShapeSize(int n, int n2, RadiusData radiusData, BitSet bitSet) {
        if (this.shapes == null) {
            return;
        }
        if (bitSet == null && (n != 1 || n2 != Integer.MAX_VALUE)) {
            bitSet = this.viewer.getSelectionSet(false);
        }
        if (radiusData != null && radiusData.value != 0.0f && radiusData.vdwType == EnumVdw.TEMP) {
            this.modelSet.getBfactor100Lo();
        }
        this.viewer.setShapeErrorState(n, "set size");
        if (radiusData != null && radiusData.value != 0.0f || radiusData == null && n2 != 0) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setShapeSize(n2, radiusData, bitSet);
        }
        this.viewer.setShapeErrorState(-1, null);
    }

    public void setLabel(String string, BitSet bitSet) {
        if (string != null) {
            this.loadShape(5);
            this.setShapeSize(5, 0, null, bitSet);
        }
        this.setShapeProperty(5, "label", string, bitSet);
    }

    public void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.shapes == null || this.shapes[n] == null) {
            return;
        }
        this.viewer.setShapeErrorState(n, "set " + string);
        this.shapes[n].setShapeProperty(string.intern(), object, bitSet);
        this.viewer.setShapeErrorState(-1, null);
    }

    boolean checkFrankclicked(int n, int n2) {
        Shape shape = this.shapes[34];
        return shape != null && shape.wasClicked(n, n2);
    }

    Map<String, Object> checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Map<String, Object> map = null;
        if (n3 != 0 && this.viewer.getBondPicking() && (map = this.shapes[1].checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return map;
        }
        for (int i = 0; i < clickableMax; ++i) {
            Shape shape = this.shapes[hoverable[i]];
            if (shape == null || (map = shape.checkObjectClicked(n, n2, n3, bitSet)) == null) continue;
            return map;
        }
        return null;
    }

    boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BitSet bitSet, int n6) {
        boolean bl = false;
        int n7 = n6 > 0 ? n6 + 1 : 35;
        for (int i = n6; !bl && i < n7; ++i) {
            if (this.shapes[i] == null) continue;
            bl = this.shapes[i].checkObjectDragged(n, n2, n3, n4, n5, bitSet);
        }
        return bl;
    }

    boolean checkObjectHovered(int n, int n2, BitSet bitSet, boolean bl) {
        Shape shape = this.shapes[1];
        if (bl && shape != null && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        for (int i = 0; i < hoverable.length; ++i) {
            shape = this.shapes[hoverable[i]];
            if (shape == null || !shape.checkObjectHovered(n, n2, bitSet)) continue;
            return true;
        }
        return false;
    }

    void deleteShapeAtoms(Object[] objectArray, BitSet bitSet) {
        if (this.shapes != null) {
            for (int i = 0; i < 35; ++i) {
                if (this.shapes[i] == null) continue;
                this.setShapeProperty(i, "deleteModelAtoms", objectArray, bitSet);
            }
        }
    }

    void deleteVdwDependentShapes(BitSet bitSet) {
        if (this.shapes[23] != null) {
            this.shapes[23].setShapeProperty("deleteVdw", null, bitSet);
        }
        if (this.shapes[24] != null) {
            this.shapes[24].setShapeProperty("deleteVdw", null, bitSet);
        }
    }

    float getAtomShapeValue(int n, Group group, int n2) {
        int n3 = JmolConstants.shapeTokenIndex(n);
        if (n3 < 0 || this.shapes[n3] == null) {
            return 0.0f;
        }
        int n4 = this.shapes[n3].getSize(n2);
        if (n4 == 0) {
            if ((group.shapeVisibilityFlags & this.shapes[n3].myVisibilityFlag) == 0) {
                return 0.0f;
            }
            n4 = this.shapes[n3].getSize(group);
        }
        return (float)n4 / 2000.0f;
    }

    void getObjectMap(Map<String, Token> map, boolean bl) {
        if (this.shapes == null) {
            return;
        }
        Boolean bl2 = bl;
        for (int i = 16; i < 29; ++i) {
            this.getShapeProperty(i, "getNames", new Object[]{map, bl2});
        }
    }

    Object getProperty(Object object) {
        if (object.equals("getShapes")) {
            return this.shapes;
        }
        return null;
    }

    BitSet getRenderableBitSet() {
        return this.bsRenderableAtoms;
    }

    Shape getShape(int n) {
        return this.shapes == null ? null : this.shapes[n];
    }

    Map<String, Object> getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.shapes != null) {
            for (int i = 0; i < 35; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null) continue;
                String string = JmolConstants.shapeClassBases[i];
                List<Map<String, Object>> list = shape.getShapeDetail();
                if (list == null) continue;
                hashtable.put(string, list);
            }
        }
        if (stringBuffer.length() > 0) {
            hashtable.put("shapeCommands", stringBuffer.toString());
        }
        return hashtable;
    }

    void getShapeState(StringBuffer stringBuffer, boolean bl, int n) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < 35; ++i) {
            String string;
            Shape shape;
            if (n != Integer.MAX_VALUE && i != n || (shape = this.shapes[i]) == null || !bl && !JmolConstants.isShapeSecondary(i) || (string = shape.getShapeState()) == null || string.length() <= 1) continue;
            stringBuffer.append(string);
        }
        stringBuffer.append("  select *;\n");
    }

    void mergeShapes(Shape[] shapeArray) {
        if (shapeArray == null) {
            return;
        }
        if (this.shapes == null) {
            this.shapes = shapeArray;
        } else {
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeArray[i] == null) continue;
                if (this.shapes[i] == null) {
                    this.loadShape(i);
                }
                this.shapes[i].merge(shapeArray[i]);
            }
        }
    }

    void resetBioshapes(BitSet bitSet) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
            this.shapes[i].setModelSet(this.modelSet);
            this.shapes[i].setShapeSize(0, null, bitSet);
            this.shapes[i].setShapeProperty("color", (Object)EnumPalette.NONE, bitSet);
        }
    }

    void setAtomLabel(String string, int n) {
        if (this.shapes == null) {
            return;
        }
        this.loadShape(5);
        this.shapes[5].setProperty("label:" + string, n, null);
    }

    void setModelVisibility() {
        int n;
        if (this.shapes == null || this.shapes[0] == null) {
            return;
        }
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 35; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bitSet);
        }
        this.shapes[0].setVisibilityFlags(bitSet);
        for (n = 0; n < 35; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    int[] transformAtoms(BitSet bitSet, Point3f point3f) {
        int n;
        int n2;
        Vector3f[] vector3fArray;
        Atom[] atomArray;
        if (bitSet != null) {
            atomArray = this.viewer.getAtomSetCenter(bitSet);
            vector3fArray = new Point3f();
            this.viewer.transformPoint((Point3f)atomArray, (Point3f)vector3fArray);
            vector3fArray.add(point3f);
            this.viewer.unTransformPoint((Point3f)vector3fArray, (Point3f)vector3fArray);
            vector3fArray.sub((Tuple3f)atomArray);
            this.viewer.setAtomCoordRelative((Tuple3f)vector3fArray, bitSet);
            point3f.set(0.0f, 0.0f, 0.0f);
        }
        this.bsRenderableAtoms.clear();
        atomArray = this.modelSet.atoms;
        vector3fArray = this.modelSet.vibrationVectors;
        int n3 = this.modelSet.getAtomCount();
        while (--n3 >= 0) {
            Atom atom = atomArray[n3];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            this.bsRenderableAtoms.set(n3);
            Point3i point3i = vector3fArray != null && atom.hasVibration() ? this.viewer.transformPoint((Point3f)atom, vector3fArray[n3]) : this.viewer.transformPoint(atom);
            atom.screenX = point3i.x;
            atom.screenY = point3i.y;
            atom.screenZ = point3i.z;
            atom.screenDiameter = this.viewer.scaleToScreen(point3i.z, Math.abs(atom.madAtom));
        }
        if (this.viewer.getSlabEnabled()) {
            int n4;
            n3 = this.viewer.getSlabByMolecule() ? 1 : 0;
            boolean bl = this.viewer.getSlabByAtom();
            int n5 = this.g3d.getSlab();
            n2 = this.g3d.getDepth();
            if (n3 != 0) {
                JmolMolecule[] jmolMoleculeArray = this.modelSet.getMolecules();
                int n6 = this.modelSet.getMoleculeCountInModel(-1);
                for (n4 = 0; n4 < n6; ++n4) {
                    JmolMolecule jmolMolecule = jmolMoleculeArray[n4];
                    int n7 = 0;
                    int n8 = jmolMolecule.firstAtomIndex;
                    if (!this.bsRenderableAtoms.get(n8)) continue;
                    while (n7 < jmolMolecule.atomCount && !this.g3d.isClippedZ(atomArray[n8].screenZ - (atomArray[n8].screenDiameter >> 1))) {
                        ++n7;
                        ++n8;
                    }
                    if (n7 == jmolMolecule.atomCount) continue;
                    n8 = jmolMolecule.firstAtomIndex;
                    for (int i = 0; i < jmolMolecule.atomCount; ++i) {
                        this.bsRenderableAtoms.clear(n8);
                        atomArray[n8++].screenZ = 0;
                    }
                }
            }
            n = this.bsRenderableAtoms.nextSetBit(0);
            while (n >= 0) {
                Atom atom = atomArray[n];
                if (this.g3d.isClippedZ(atom.screenZ - (bl ? atomArray[n].screenDiameter >> 1 : 0))) {
                    atom.setClickable(0);
                    n4 = (bl ? -1 : 1) * atom.screenDiameter / 2;
                    if (atom.screenZ + n4 < n5 || atom.screenZ - n4 > n2 || !this.g3d.isInDisplayRange(atom.screenX, atom.screenY)) {
                        this.bsRenderableAtoms.clear(n);
                    }
                }
                n = this.bsRenderableAtoms.nextSetBit(n + 1);
            }
        }
        if (this.modelSet.getAtomCount() == 0 || !this.viewer.getShowNavigationPoint()) {
            return null;
        }
        n3 = Integer.MAX_VALUE;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        n2 = Integer.MIN_VALUE;
        n = this.bsRenderableAtoms.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            if (atom.screenX < n3) {
                n3 = atom.screenX;
            }
            if (atom.screenX > n9) {
                n9 = atom.screenX;
            }
            if (atom.screenY < n10) {
                n10 = atom.screenY;
            }
            if (atom.screenY > n2) {
                n2 = atom.screenY;
            }
            n = this.bsRenderableAtoms.nextSetBit(n + 1);
        }
        this.navigationCrossHairMinMax[0] = n3;
        this.navigationCrossHairMinMax[1] = n9;
        this.navigationCrossHairMinMax[2] = n10;
        this.navigationCrossHairMinMax[3] = n2;
        return this.navigationCrossHairMinMax;
    }
}

