/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Eigen;

public class Quadric {
    public float[] lengths;
    public Vector3f[] vectors;
    public boolean isThermalEllipsoid = true;
    public float scale = 1.0f;
    private static float ONE_OVER_ROOT2_PI = (float)(Math.sqrt(0.5) / Math.PI);
    private static float[] crtval = new float[]{0.3389f, 0.4299f, 0.4951f, 0.5479f, 0.5932f, 0.6334f, 0.6699f, 0.7035f, 0.7349f, 0.7644f, 0.7924f, 0.8192f, 0.8447f, 0.8694f, 0.8932f, 0.9162f, 0.9386f, 0.9605f, 0.9818f, 1.0026f, 1.023f, 1.043f, 1.0627f, 1.0821f, 1.1012f, 1.12f, 1.1386f, 1.157f, 1.1751f, 1.1932f, 1.211f, 1.2288f, 1.2464f, 1.2638f, 1.2812f, 1.2985f, 1.3158f, 1.333f, 1.3501f, 1.3672f, 1.3842f, 1.4013f, 1.4183f, 1.4354f, 1.4524f, 1.4695f, 1.4866f, 1.5037f, 1.5209f, 1.5382f, 1.5555f, 1.5729f, 1.5904f, 1.608f, 1.6257f, 1.6436f, 1.6616f, 1.6797f, 1.698f, 1.7164f, 1.7351f, 1.754f, 1.773f, 1.7924f, 1.8119f, 1.8318f, 1.8519f, 1.8724f, 1.8932f, 1.9144f, 1.936f, 1.958f, 1.9804f, 2.0034f, 2.0269f, 2.051f, 2.0757f, 2.1012f, 2.1274f, 2.1544f, 2.1824f, 2.2114f, 2.2416f, 2.273f, 2.3059f, 2.3404f, 2.3767f, 2.4153f, 2.4563f, 2.5003f, 2.5478f, 2.5997f, 2.6571f, 2.7216f, 2.7955f, 2.8829f, 2.9912f, 3.1365f, 3.3682f};

    public void scale(float f) {
        int n = 0;
        while (n < 3) {
            int n2 = n++;
            this.lengths[n2] = this.lengths[n2] * f;
        }
    }

    public String toString() {
        return this.vectors == null ? "" + this.lengths[0] : this.vectors[0] + "\t" + this.lengths[0] + "\n" + this.vectors[1] + "\t" + this.lengths[1] + "\n" + this.vectors[2] + "\t" + this.lengths[2] + "\n";
    }

    public Quadric(Vector3f[] vector3fArray, float[] fArray, boolean bl) {
        this.vectors = vector3fArray;
        this.lengths = fArray;
        this.isThermalEllipsoid = bl;
    }

    public Quadric(double[] dArray) {
        this.isThermalEllipsoid = true;
        this.lengths = new float[3];
        this.vectors = new Vector3f[3];
        Quadric.getAxesForEllipsoid(dArray, this.vectors, this.lengths);
        int n = 0;
        while (n < 3) {
            int n2 = n++;
            this.lengths[n2] = this.lengths[n2] * ONE_OVER_ROOT2_PI;
        }
    }

    public void rotate(Matrix4f matrix4f) {
        if (this.vectors != null) {
            for (int i = 0; i < 3; ++i) {
                matrix4f.transform(this.vectors[i]);
            }
        }
    }

    public void setSize(int n) {
        this.scale = this.isThermalEllipsoid ? Quadric.getRadius(n) : (n < 1 ? 0.0f : (float)n / 100.0f);
    }

    public static void getAxesForEllipsoid(double[] dArray, Vector3f[] vector3fArray, float[] fArray) {
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = dArray[0];
        dArray2[1][1] = dArray[1];
        dArray2[2][2] = dArray[2];
        double d = dArray[3] / 2.0;
        dArray2[1][0] = d;
        dArray2[0][1] = d;
        double d2 = dArray[4] / 2.0;
        dArray2[2][0] = d2;
        dArray2[0][2] = d2;
        double d3 = dArray[5] / 2.0;
        dArray2[2][1] = d3;
        dArray2[1][2] = d3;
        new Eigen(dArray2, vector3fArray, fArray);
    }

    public static Matrix3f setEllipsoidMatrix(Vector3f[] vector3fArray, float[] fArray, Vector3f vector3f, Matrix3f matrix3f) {
        for (int i = 0; i < 3; ++i) {
            vector3f.set(vector3fArray[i]);
            vector3f.scale(fArray[i]);
            matrix3f.setColumn(i, vector3f);
        }
        matrix3f.invert(matrix3f);
        return matrix3f;
    }

    public static void getEquationForQuadricWithCenter(float f, float f2, float f3, Matrix3f matrix3f, Vector3f vector3f, Matrix3f matrix3f2, double[] dArray, Matrix4f matrix4f) {
        vector3f.set(f, f2, f3);
        matrix3f.transform(vector3f);
        double d = 1.0f - vector3f.dot(vector3f);
        matrix3f2.transpose(matrix3f);
        matrix3f2.transform(vector3f);
        matrix3f2.mul(matrix3f);
        dArray[0] = (double)matrix3f2.m00 / d;
        dArray[1] = (double)matrix3f2.m11 / d;
        dArray[2] = (double)matrix3f2.m22 / d;
        dArray[3] = (double)(matrix3f2.m01 * 2.0f) / d;
        dArray[4] = (double)(matrix3f2.m02 * 2.0f) / d;
        dArray[5] = (double)(matrix3f2.m12 * 2.0f) / d;
        dArray[6] = (double)(-2.0f * vector3f.x) / d;
        dArray[7] = (double)(-2.0f * vector3f.y) / d;
        dArray[8] = (double)(-2.0f * vector3f.z) / d;
        dArray[9] = -1.0;
        if (matrix4f == null) {
            return;
        }
        matrix4f.setIdentity();
        matrix4f.m00 = (float)(2.0 * dArray[0]);
        matrix4f.m11 = (float)(2.0 * dArray[1]);
        matrix4f.m22 = (float)(2.0 * dArray[2]);
        matrix4f.m01 = matrix4f.m10 = (float)dArray[3];
        matrix4f.m02 = matrix4f.m20 = (float)dArray[4];
        matrix4f.m12 = matrix4f.m21 = (float)dArray[5];
        matrix4f.m03 = (float)dArray[6];
        matrix4f.m13 = (float)dArray[7];
        matrix4f.m23 = (float)dArray[8];
    }

    public static boolean getQuardricZ(double d, double d2, double[] dArray, double[] dArray2) {
        double d3 = (dArray[4] * d + dArray[5] * d2 + dArray[8]) / dArray[2] / 2.0;
        double d4 = (dArray[0] * d * d + dArray[1] * d2 * d2 + dArray[3] * d * d2 + dArray[6] * d + dArray[7] * d2 - 1.0) / dArray[2];
        double d5 = d3 * d3 - d4;
        if (d5 < 0.0) {
            return false;
        }
        d5 = Math.sqrt(d5);
        dArray2[0] = -d3 - d5;
        dArray2[1] = -d3 + d5;
        return true;
    }

    public static int getOctant(Point3f point3f) {
        int n = 0;
        if (point3f.x < 0.0f) {
            ++n;
        }
        if (point3f.y < 0.0f) {
            n += 2;
        }
        if (point3f.z < 0.0f) {
            n += 4;
        }
        return n;
    }

    public static final float getRadius(int n) {
        return crtval[n < 1 ? 0 : (n > 99 ? 98 : n - 1)];
    }
}

