/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BinaryDocument;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Isosurface
extends MeshCollection
implements MeshDataServer {
    private IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    protected IsosurfaceMesh thisMesh;
    private String actualID;
    protected boolean iHaveBitSets;
    private boolean explicitContours;
    private int atomIndex;
    private int moNumber;
    private float[] moLinearCombination;
    private short defaultColix;
    private short meshColix;
    private Point3f center;
    private float scale3d;
    private boolean isPhaseColored;
    private boolean isColorExplicit;
    private String scriptAppendix = "";
    protected SurfaceGenerator sg;
    protected JvxlData jvxlData;
    private float withinDistance2;
    private boolean isWithinNot;
    private List<Point3f> withinPoints;
    private float[] cutoffRange;
    boolean allowMesh = true;
    private String script;
    private boolean iHaveModelIndex;
    private int nLCAO = 0;
    private Point4f lcaoDir = new Point4f();
    private double privateKey;
    private boolean associateNormals;
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final Point3i ptXY = new Point3i();
    int[] keyXy;

    @Override
    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.isomeshes = (IsosurfaceMesh[])ArrayUtil.ensureLength(this.isomeshes, this.meshCount * 2);
        this.meshes = this.isomeshes;
        this.isomeshes[n] = mesh == null ? new IsosurfaceMesh(string, this.g3d, this.colix, n) : (IsosurfaceMesh)mesh;
        this.thisMesh = this.isomeshes[n];
        this.currentMesh = this.isomeshes[n];
        this.currentMesh.index = n;
        this.jvxlData = this.thisMesh.jvxlData;
        this.sg.setJvxlData(this.jvxlData);
    }

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.newSg();
    }

    protected void newSg() {
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.viewer, this, null, this.jvxlData);
        this.sg.setVersion("Jmol " + Viewer.getJmolVersion());
    }

    protected void clearSg() {
        this.sg = null;
    }

    @Override
    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("navigate" == string) {
            this.navigate((Integer)object);
            return;
        }
        if ("delete" == string) {
            this.setPropertySuper(string, object, bitSet);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("remapColor" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.remapColors((ColorEncoder)object, this.translucentLevel);
            }
            return;
        }
        if ("thisID" == string) {
            if (this.actualID != null) {
                object = this.actualID;
            }
            this.setPropertySuper("thisID", object, null);
            return;
        }
        if ("atomcolor" == string) {
            if (this.thisMesh != null) {
                if (this.thisMesh.vertexSource == null) {
                    short s = !this.thisMesh.isColorSolid ? (short)0 : this.thisMesh.colix;
                    this.setProperty("init", null, null);
                    this.setProperty("map", Boolean.FALSE, null);
                    this.setProperty("property", new float[this.viewer.getAtomCount()], null);
                    if (s != 0) {
                        this.thisMesh.colorCommand = "color isosurface " + Graphics3D.getHexCode(s);
                        this.setProperty("color", new Integer(Graphics3D.getArgb(s)), null);
                    }
                }
                this.thisMesh.colorAtoms(Graphics3D.getColix(object), bitSet);
            }
            return;
        }
        if ("pointSize" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.volumeRenderPointSize = ((Float)object).floatValue();
            }
            return;
        }
        if ("vertexcolor" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.colorVertices(Graphics3D.getColix(object), bitSet);
            }
            return;
        }
        if ("colorPhase" == string) {
            Object[] objectArray = object;
            if (this.thisMesh != null) {
                this.thisMesh.colorPhased = true;
                this.thisMesh.colix = this.thisMesh.jvxlData.minColorIndex = Graphics3D.getColix((Integer)objectArray[0]);
                this.thisMesh.jvxlData.maxColorIndex = Graphics3D.getColix((Integer)objectArray[1]);
                this.thisMesh.jvxlData.isBicolorMap = true;
                this.thisMesh.jvxlData.colorDensity = false;
                this.thisMesh.isColorSolid = false;
                this.thisMesh.remapColors(null, this.translucentLevel);
            }
            return;
        }
        if ("color" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.isColorSolid = true;
                this.thisMesh.polygonColixes = null;
                this.thisMesh.colorEncoder = null;
                this.thisMesh.vertexColorMap = null;
            } else if (!TextFormat.isWild(this.previousMeshID)) {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.isomeshes[n].isColorSolid = true;
                    this.isomeshes[n].polygonColixes = null;
                    this.isomeshes[n].colorEncoder = null;
                    this.isomeshes[n].vertexColorMap = null;
                }
            }
            this.setPropertySuper(string, object, bitSet);
            return;
        }
        if ("nocontour" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.deleteContours();
            }
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.setMesh();
            return;
        }
        if ("newObject" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.clear(this.thisMesh.meshType, false);
            }
            return;
        }
        if ("moveIsosurface" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.updateCoordinates((Matrix4f)object, null);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("refreshTrajectories" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n].connections == null || this.meshes[n].modelIndex != (Integer)((Object[])object)[0]) continue;
                ((IsosurfaceMesh)this.meshes[n]).updateCoordinates((Matrix4f)((Object[])object)[2], (BitSet)((Object[])object)[1]);
            }
            return;
        }
        if ("modelIndex" == string) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)object;
                this.isFixed = this.modelIndex < 0;
                this.sg.setModelIndex(Math.abs(this.modelIndex));
            }
            return;
        }
        if ("lcaoCartoon" == string || "lonePair" == string || "radical" == string) {
            Vector3f[] vector3fArray = (Vector3f[])object;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (!this.sg.setParameter("lcaoCartoonCenter", vector3fArray[2])) {
                this.drawLcaoCartoon(vector3fArray[0], vector3fArray[1], vector3fArray[3], "lonePair" == string ? 2 : ("radical" == string ? 1 : 0));
            }
            return;
        }
        if ("select" == string && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == string && this.iHaveBitSets) {
            return;
        }
        if ("meshcolor" == string) {
            int n = (Integer)object;
            this.meshColix = Graphics3D.getColix(n);
            if (this.thisMesh != null) {
                this.thisMesh.meshColix = this.meshColix;
            }
            return;
        }
        if ("offset" == string) {
            Point3f point3f = new Point3f((Point3f)object);
            if (point3f.equals(JmolConstants.center)) {
                point3f = null;
            }
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(null, point3f, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("rotate" == string) {
            Point4f point4f = (Point4f)object;
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(new Quaternion(point4f), null, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("bsDisplay" == string) {
            this.bsDisplay = (BitSet)object;
            return;
        }
        if ("displayWithin" == string) {
            Object[] objectArray = object;
            this.displayWithinDistance2 = ((Float)objectArray[0]).floatValue();
            this.isDisplayWithinNot = this.displayWithinDistance2 < 0.0f;
            this.displayWithinDistance2 *= this.displayWithinDistance2;
            this.displayWithinPoints = (List)objectArray[3];
            if (this.displayWithinPoints.size() == 0) {
                this.displayWithinPoints = this.viewer.getAtomPointVector((BitSet)objectArray[2]);
            }
            return;
        }
        if ("finalize" == string) {
            if (this.thisMesh != null) {
                String string2 = (String)object;
                if (string2 != null && !string2.startsWith("; isosurface map")) {
                    this.thisMesh.setDiscreteColixes(this.sg.getParams().contoursDiscrete, this.sg.getParams().contourColixes);
                    this.setJvxlInfo();
                }
                this.setScriptInfo(string2);
            }
            this.clearSg();
            return;
        }
        if ("privateKey" == string) {
            this.privateKey = (Double)object;
            return;
        }
        if ("connections" == string) {
            if (this.currentMesh != null) {
                this.connections = (int[])object;
                if (this.connections[0] >= 0 && this.connections[0] < this.viewer.getAtomCount()) {
                    this.currentMesh.connections = this.connections;
                } else {
                    this.currentMesh.connections = null;
                    this.connections = null;
                }
            }
            return;
        }
        if ("cutoffRange" == string) {
            this.cutoffRange = (float[])object;
            return;
        }
        if ("slab" == string) {
            if (object instanceof Integer) {
                if (this.thisMesh != null) {
                    this.thisMesh.jvxlData.slabValue = (Integer)object;
                }
                return;
            }
            if (this.thisMesh != null) {
                Object[] objectArray = object;
                int n = (Integer)objectArray[0];
                switch (n) {
                    case 1073742018: {
                        Object[] objectArray2 = (Object[])objectArray[1];
                        Mesh mesh = this.getMesh((String)objectArray2[1]);
                        if (mesh == null) {
                            return;
                        }
                        objectArray2[1] = mesh;
                    }
                }
                this.slabPolygons(objectArray);
                return;
            }
        }
        if ("cap" == string && this.thisMesh != null && this.thisMesh.polygonCount != 0) {
            this.thisMesh.slabPolygons((Object[])object, true);
            this.thisMesh.initialize(this.thisMesh.lighting, null, null);
            return;
        }
        if ("map" == string) {
            this.setProperty("squareData", Boolean.FALSE, null);
            if (this.thisMesh == null || this.thisMesh.vertexCount == 0) {
                return;
            }
        }
        if ("deleteVdw" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.isomeshes[n].bsVdw == null || bitSet != null && !bitSet.intersects(this.isomeshes[n].bsVdw)) continue;
                this.deleteMesh(n);
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("mapColor" == string || "readFile" == string) {
            if (object == null) {
                object = this.viewer.getBufferedReaderOrErrorMessageFromName(this.sg.getFileName(), null, true);
                if (object instanceof String) {
                    Logger.error("Isosurface: could not open file " + this.sg.getFileName() + " -- " + object);
                    return;
                }
                if (!(object instanceof BufferedReader)) {
                    try {
                        object = new BufferedReader(new InputStreamReader((InputStream)object, "ISO-8859-1"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
        } else if ("atomIndex" == string) {
            this.atomIndex = (Integer)object;
        } else if ("center" == string) {
            this.center.set((Point3f)object);
        } else if ("colorRGB" == string) {
            int n = (Integer)object;
            this.defaultColix = Graphics3D.getColix(n);
        } else if ("contour" == string) {
            this.explicitContours = true;
        } else if ("functionXY" == string) {
            if (this.sg.isStateDataRead()) {
                this.setScriptInfo(null);
            }
        } else if ("init" == string) {
            this.newSg();
        } else if ("getSurfaceSets" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.jvxlData.thisSet = (Integer)object;
                this.thisMesh.calculatedVolume = null;
                this.thisMesh.calculatedArea = null;
            }
        } else if ("localName" == string) {
            object = this.viewer.getOutputStream((String)object, null);
            string = "outputStream";
        } else if ("molecularOrbital" == string) {
            if (object instanceof Integer) {
                this.moNumber = (Integer)object;
                this.moLinearCombination = null;
            } else {
                this.moLinearCombination = (float[])object;
                this.moNumber = 0;
            }
            if (!this.isColorExplicit) {
                this.isPhaseColored = true;
            }
        } else if ("phase" == string) {
            this.isPhaseColored = true;
        } else if ("plane" != string && "pocket" != string) {
            if ("scale3d" == string) {
                this.scale3d = ((Float)object).floatValue();
                if (this.thisMesh != null) {
                    this.thisMesh.scale3d = this.thisMesh.jvxlData.scale3d = this.scale3d;
                    this.thisMesh.altVertices = null;
                }
            } else if ("title" == string) {
                if (object instanceof String && "-".equals(object)) {
                    object = null;
                }
                this.setPropertySuper(string, object, bitSet);
                object = this.title;
            } else if ("withinPoints" == string) {
                Object[] objectArray = object;
                this.withinDistance2 = ((Float)objectArray[0]).floatValue();
                this.isWithinNot = this.withinDistance2 < 0.0f;
                this.withinDistance2 *= this.withinDistance2;
                this.withinPoints = (List)objectArray[3];
                if (this.withinPoints.size() == 0) {
                    this.withinPoints = this.viewer.getAtomPointVector((BitSet)objectArray[2]);
                }
            } else if (("nci" == string || "orbital" == string) && this.sg != null) {
                int n = this.sg.getParams().testFlags = this.viewer.getTestFlag(2) ? 2 : 0;
            }
        }
        if (this.sg != null && this.sg.setParameter(string, object, bitSet)) {
            if (this.sg.isValid()) {
                return;
            }
            string = "delete";
        }
        if ("init" == string) {
            this.explicitID = false;
            this.scriptAppendix = "";
            String string3 = object instanceof String ? (String)object : null;
            int n = string3 == null ? -1 : string3.indexOf("# ID=");
            this.actualID = n >= 0 ? Parser.getNextQuotedString(string3, n) : null;
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            if (string3 != null && !(this.iHaveBitSets = this.getScriptBitSets(string3, null))) {
                this.sg.setParameter("select", bitSet);
            }
            this.initializeIsosurface();
            this.sg.setModelIndex(this.isFixed ? -1 : this.modelIndex);
            return;
        }
        if ("clear" == string) {
            this.discardTempData(true);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = ((int[])((Object[])object)[2])[1];
            int n3 = ((int[])((Object[])object)[2])[2];
            int n4 = this.meshCount;
            while (--n4 >= 0) {
                Mesh mesh = this.meshes[n4];
                if (mesh == null) continue;
                if (mesh.connections != null) {
                    int n5 = mesh.connections[0];
                    if (n5 >= n2 + n3) {
                        mesh.connections[0] = n5 - n3;
                    } else if (n5 >= n2) {
                        mesh.connections = null;
                    }
                }
                mesh.connections = null;
                if (mesh.modelIndex == n) {
                    --this.meshCount;
                    if (mesh == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, n4, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (mesh.modelIndex <= n) continue;
                --mesh.modelIndex;
                if (mesh.atomIndex < n2) continue;
                mesh.atomIndex -= n3;
            }
            return;
        }
        this.setPropertySuper(string, object, bitSet);
    }

    protected void slabPolygons(Object[] objectArray) {
        this.thisMesh.slabPolygons(objectArray, false);
        this.thisMesh.reinitializeLightingAndColor();
    }

    private void setPropertySuper(String string, Object object, BitSet bitSet) {
        if (string == "thisID" && this.currentMesh != null && this.currentMesh.thisID.equals(object)) {
            this.checkExplicit((String)object);
            return;
        }
        this.currentMesh = this.thisMesh;
        super.setProperty(string, object, bitSet);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        JvxlData jvxlData = this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
        if (this.sg != null) {
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    @Override
    public boolean getProperty(String string, Object[] objectArray) {
        int n;
        if (string == "colorEncoder") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            return isosurfaceMesh != null && (objectArray[1] = isosurfaceMesh.colorEncoder) != null;
        }
        if (string == "intersectPlane") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            if (isosurfaceMesh == null) {
                return false;
            }
            objectArray[3] = isosurfaceMesh.modelIndex;
            isosurfaceMesh.getIntersection(0.0f, (Point4f)objectArray[1], null, (List)objectArray[2], null, null, null, false, false, 135266319, false);
            return true;
        }
        if (string == "getBoundingBox") {
            String string2 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string2);
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null) {
                return false;
            }
            objectArray[2] = isosurfaceMesh.jvxlData.boundingBox;
            if (isosurfaceMesh.mat4 != null) {
                Point3f[] point3fArray = new Point3f[]{new Point3f(isosurfaceMesh.jvxlData.boundingBox[0]), new Point3f(isosurfaceMesh.jvxlData.boundingBox[1])};
                Vector3f vector3f = new Vector3f();
                isosurfaceMesh.mat4.get(vector3f);
                point3fArray[0].add(vector3f);
                point3fArray[1].add(vector3f);
                objectArray[2] = point3fArray;
            }
            return true;
        }
        if (string == "unitCell") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            return isosurfaceMesh != null && (objectArray[1] = isosurfaceMesh.getUnitCell()) != null;
        }
        if (string == "getCenter" && (n = ((Integer)objectArray[1]).intValue()) == Integer.MIN_VALUE) {
            String string3 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string3);
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null) {
                return false;
            }
            Point3f point3f = new Point3f(isosurfaceMesh.jvxlData.boundingBox[0]);
            point3f.add(isosurfaceMesh.jvxlData.boundingBox[1]);
            point3f.scale(0.5f);
            if (isosurfaceMesh.mat4 != null) {
                Vector3f vector3f = new Vector3f();
                isosurfaceMesh.mat4.get(vector3f);
                point3f.add(vector3f);
            }
            objectArray[2] = point3f;
            return true;
        }
        return super.getProperty(string, objectArray);
    }

    @Override
    public Object getProperty(String string, int n) {
        Object object = super.getProperty(string, n);
        if (object != null) {
            return object;
        }
        if (string == "dataRange") {
            float[] fArray;
            if (this.thisMesh == null || this.jvxlData.jvxlPlane != null && this.thisMesh.colorEncoder == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[4];
                fArray2[0] = this.jvxlData.mappedDataMin;
                fArray2[1] = this.jvxlData.mappedDataMax;
                fArray2[2] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue : this.jvxlData.valueMappedToRed;
                fArray = fArray2;
                fArray2[3] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToBlue;
            }
            return fArray;
        }
        if (string == "moNumber") {
            return this.moNumber;
        }
        if (string == "moLinearCombination") {
            return this.moLinearCombination;
        }
        if (string == "nSets") {
            return this.thisMesh == null ? 0 : this.thisMesh.nSets;
        }
        if (string == "area") {
            return this.thisMesh == null ? new Float(Float.NaN) : this.calculateVolumeOrArea(true);
        }
        if (string == "volume") {
            return this.thisMesh == null ? new Float(Float.NaN) : this.calculateVolumeOrArea(false);
        }
        if (this.thisMesh == null) {
            return null;
        }
        if (string == "cutoff") {
            return new Float(this.jvxlData.cutoff);
        }
        if (string == "minMaxInfo") {
            return new float[]{this.jvxlData.dataMin, this.jvxlData.dataMax};
        }
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "contours") {
            return this.thisMesh.getContours();
        }
        if (string == "jvxlDataXml" || string == "jvxlMeshXml") {
            MeshData meshData = null;
            this.jvxlData.slabInfo = null;
            if (string == "jvxlMeshXml" || this.jvxlData.vertexDataOnly || this.thisMesh.bsSlabDisplay != null && this.thisMesh.bsSlabGhost == null) {
                meshData = new MeshData();
                this.fillMeshData(meshData, 1, null);
                meshData.polygonColorData = Isosurface.getPolygonColorData(meshData.polygonCount, meshData.polygonColixes, meshData.bsSlabDisplay);
            } else if (this.thisMesh.bsSlabGhost != null) {
                this.jvxlData.slabInfo = this.thisMesh.slabOptions.toString();
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.getMeshCommand(stringBuffer, this.thisMesh.index);
            this.thisMesh.setJvxlColorMap(true);
            return JvxlCoder.jvxlGetFile(this.jvxlData, meshData, this.title, "", true, 1, stringBuffer.toString(), null);
        }
        if (string == "jvxlFileInfo") {
            this.thisMesh.setJvxlColorMap(false);
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        if (string == "command") {
            String string2 = this.previousMeshID.toUpperCase();
            boolean bl = TextFormat.isWild(string2);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.meshCount;
            while (--n2 >= 0) {
                String string3 = this.meshes[n2].thisID.toUpperCase();
                if (!string3.equals(string2) && (!bl || !TextFormat.isMatch(string3, string2, true, true))) continue;
                this.getMeshCommand(stringBuffer, n2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private Object calculateVolumeOrArea(boolean bl) {
        if (bl) {
            if (this.thisMesh.calculatedArea != null) {
                return this.thisMesh.calculatedArea;
            }
        } else if (this.thisMesh.calculatedVolume != null) {
            return this.thisMesh.calculatedVolume;
        }
        MeshData meshData = new MeshData();
        this.fillMeshData(meshData, 1, null);
        meshData.nSets = this.thisMesh.nSets;
        meshData.vertexSets = this.thisMesh.vertexSets;
        if (!bl && this.thisMesh.jvxlData.colorDensity) {
            float f = this.thisMesh.jvxlData.voxelVolume;
            this.thisMesh.calculatedVolume = Float.valueOf(f *= (float)(this.thisMesh.bsSlabDisplay == null ? this.thisMesh.vertexCount : this.thisMesh.bsSlabDisplay.cardinality()));
            return this.thisMesh.calculatedVolume;
        }
        Object object = meshData.calculateVolumeOrArea(this.thisMesh.jvxlData.thisSet, bl, false);
        if (bl) {
            this.thisMesh.calculatedArea = object;
        } else {
            this.thisMesh.calculatedVolume = object;
        }
        return object;
    }

    public static String getPolygonColorData(int n, short[] sArray, BitSet bitSet) {
        if (sArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        short s = 0;
        boolean bl = false;
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                bl = true;
                if (!true) break;
            }
            if (bl || bitSet == null || bitSet.get(n3)) {
                if (bl || sArray[n3] != s) {
                    if (n2 != 0) {
                        stringBuffer.append(" ").append(n2).append(" ").append(s == 0 ? 0 : Graphics3D.getArgb(s));
                    }
                    if (bl) break;
                    s = sArray[n3];
                    n2 = 1;
                } else {
                    ++n2;
                }
            }
            ++n3;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String getShapeState() {
        this.clean();
        StringBuffer stringBuffer = new StringBuffer("\n");
        for (int i = 0; i < this.meshCount; ++i) {
            this.getMeshCommand(stringBuffer, i);
        }
        return stringBuffer.toString();
    }

    private void getMeshCommand(StringBuffer stringBuffer, int n) {
        IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.meshes[n];
        if (isosurfaceMesh == null || isosurfaceMesh.scriptCommand == null) {
            return;
        }
        String string = isosurfaceMesh.scriptCommand;
        int n2 = this.viewer.getModelCount();
        if (n2 > 1) {
            Isosurface.appendCmd(stringBuffer, "frame " + this.viewer.getModelNumberDotted(isosurfaceMesh.modelIndex));
        }
        string = TextFormat.simpleReplace(string, "; isosurface map", " map");
        string = string.replace('\t', ' ');
        int n3 = (string = TextFormat.simpleReplace(string, ";#", "; #")).indexOf("; #");
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if (isosurfaceMesh.connections != null) {
            string = string + " connect " + Escape.escape(isosurfaceMesh.connections);
        }
        string = TextFormat.trim(string, ";");
        if (isosurfaceMesh.linkedMesh != null) {
            string = string + " LINK";
        }
        Isosurface.appendCmd(stringBuffer, string);
        String string2 = this.myType + " ID " + Escape.escape(isosurfaceMesh.thisID);
        if (isosurfaceMesh.jvxlData.thisSet >= 0) {
            Isosurface.appendCmd(stringBuffer, string2 + " set " + (isosurfaceMesh.jvxlData.thisSet + 1));
        }
        if (isosurfaceMesh.mat4 != null) {
            Isosurface.appendCmd(stringBuffer, string2 + " move " + Escape.matrixToScript(isosurfaceMesh.mat4));
        }
        if (isosurfaceMesh.scale3d != 0.0f) {
            Isosurface.appendCmd(stringBuffer, string2 + " scale3d " + isosurfaceMesh.scale3d);
        }
        if (isosurfaceMesh.jvxlData.slabValue != Integer.MIN_VALUE) {
            Isosurface.appendCmd(stringBuffer, string2 + " slab " + isosurfaceMesh.jvxlData.slabValue);
        }
        if (isosurfaceMesh.slabOptions != null) {
            Isosurface.appendCmd(stringBuffer, isosurfaceMesh.slabOptions.toString());
        }
        if (string.charAt(0) != '#') {
            boolean bl;
            if (this.allowMesh) {
                Isosurface.appendCmd(stringBuffer, isosurfaceMesh.getState(this.myType));
            }
            if (!isosurfaceMesh.isColorSolid && Graphics3D.isColixTranslucent(isosurfaceMesh.colix)) {
                Isosurface.appendCmd(stringBuffer, "color " + this.myType + " " + Isosurface.getTranslucentLabel(isosurfaceMesh.colix));
            }
            if (isosurfaceMesh.colorCommand != null) {
                Isosurface.appendCmd(stringBuffer, isosurfaceMesh.colorCommand);
            }
            boolean bl2 = bl = isosurfaceMesh.isColorSolid && isosurfaceMesh.polygonColixes != null;
            if (isosurfaceMesh.isColorSolid && !bl) {
                Isosurface.appendCmd(stringBuffer, this.getColorCommand(this.myType, isosurfaceMesh.colix));
            } else if (isosurfaceMesh.jvxlData.isBicolorMap && isosurfaceMesh.colorPhased) {
                Isosurface.appendCmd(stringBuffer, "color isosurface phase " + Isosurface.encodeColor(isosurfaceMesh.jvxlData.minColorIndex) + " " + Isosurface.encodeColor(isosurfaceMesh.jvxlData.maxColorIndex));
            }
            if (isosurfaceMesh.vertexColorMap != null) {
                for (Map.Entry entry : isosurfaceMesh.vertexColorMap.entrySet()) {
                    BitSet bitSet = (BitSet)entry.getValue();
                    if (bitSet.isEmpty()) continue;
                    Isosurface.appendCmd(stringBuffer, "color " + this.myType + " " + Escape.escape(bitSet, true) + " " + (String)entry.getKey());
                }
            }
        }
    }

    private boolean getScriptBitSets(String string, BitSet[] bitSetArray) {
        BitSet bitSet;
        int n;
        int n2;
        this.script = string;
        this.iHaveModelIndex = false;
        this.modelIndex = -1;
        if (string != null && (n2 = string.indexOf("MODEL({")) >= 0 && (n = string.indexOf("})", n2)) > 0) {
            bitSet = Escape.unescapeBitset(string.substring(n2 + 3, n + 1));
            this.modelIndex = bitSet == null ? -1 : bitSet.nextSetBit(0);
            boolean bl = this.iHaveModelIndex = this.modelIndex >= 0;
        }
        if (string == null) {
            return false;
        }
        this.getCapSlabInfo(string);
        n2 = string.indexOf("# ({");
        if (n2 < 0) {
            return false;
        }
        n = string.indexOf("})", n2);
        if (n < 0) {
            return false;
        }
        bitSet = Escape.unescapeBitset(string.substring(n2 + 2, n + 2));
        if (bitSetArray == null) {
            this.sg.setParameter("select", bitSet);
        } else {
            bitSetArray[0] = bitSet;
        }
        n2 = string.indexOf("({", n);
        if (n2 < 0) {
            return true;
        }
        n = string.indexOf("})", n2);
        if (n < 0) {
            return false;
        }
        bitSet = Escape.unescapeBitset(string.substring(n2 + 1, n + 1));
        if (bitSetArray == null) {
            this.sg.setParameter("ignore", bitSet);
        } else {
            bitSetArray[1] = bitSet;
        }
        n2 = string.indexOf("/({", n);
        if (n2 == n + 2) {
            n = string.indexOf("})", n2);
            if (n < 0) {
                return false;
            }
            bitSet = Escape.unescapeBitset(string.substring(n2 + 3, n + 1));
            if (bitSetArray == null) {
                this.viewer.setTrajectory(bitSet);
            } else {
                bitSetArray[2] = bitSet;
            }
        }
        return true;
    }

    protected void getCapSlabInfo(String string) {
        int n = string.indexOf("# SLAB=");
        if (n >= 0) {
            this.sg.setParameter("slab", MeshSurface.getCapSlabObject(Parser.getNextQuotedString(string, n), false));
        }
        if ((n = string.indexOf("# CAP=")) >= 0) {
            this.sg.setParameter("slab", MeshSurface.getCapSlabObject(Parser.getNextQuotedString(string, n), true));
        }
    }

    private void initializeIsosurface() {
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.viewer.getCurrentModelIndex();
        }
        boolean bl = this.isFixed = this.modelIndex < 0;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.title = null;
        this.explicitContours = false;
        this.atomIndex = -1;
        this.colix = (short)5;
        this.meshColix = 0;
        this.defaultColix = 0;
        this.isColorExplicit = false;
        this.isPhaseColored = false;
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.scale3d = 0.0f;
        this.withinPoints = null;
        this.cutoffRange = null;
        this.displayWithinPoints = null;
        this.bsDisplay = null;
        this.linkedMesh = null;
        this.connections = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void setMesh() {
        this.thisMesh.visible = true;
        this.thisMesh.atomIndex = this.atomIndex;
        this.thisMesh.modelIndex = this.thisMesh.atomIndex >= 0 ? this.viewer.getAtomModelIndex(this.atomIndex) : (this.isFixed ? -1 : (this.modelIndex >= 0 ? this.modelIndex : this.viewer.getCurrentModelIndex()));
        this.thisMesh.scriptCommand = this.script;
        this.thisMesh.ptCenter.set(this.center);
        this.thisMesh.scale3d = this.thisMesh.jvxlData.jvxlPlane == null ? 0.0f : this.scale3d;
    }

    protected void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.isCubeData()) {
            return this.colix;
        }
        int n = this.sg.getCutoff() >= 0.0f ? -11525984 : -6283184;
        return Graphics3D.getColix(n);
    }

    private void drawLcaoCartoon(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, int n) {
        Object object;
        Object object2;
        boolean bl;
        String string = this.sg.setLcao();
        float f = vector3f3.x + vector3f3.y + vector3f3.z;
        this.defaultColix = Graphics3D.getColix(this.sg.getColor(1));
        short s = Graphics3D.getColix(this.sg.getColor(-1));
        Vector3f vector3f4 = new Vector3f();
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '-';
        if (bl) {
            string = string.substring(1);
        }
        int n2 = bl ? -1 : 1;
        vector3f4.cross(vector3f, vector3f2);
        if (f != 0.0f) {
            object2 = new AxisAngle4f();
            if (vector3f3.x != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f2, f);
            } else if (vector3f3.y != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f4, f);
            } else {
                ((AxisAngle4f)object2).set(vector3f, f);
            }
            object = new Matrix3f();
            ((Matrix3f)object).set((AxisAngle4f)object2);
            ((Matrix3f)object).transform(vector3f2);
            ((Matrix3f)object).transform(vector3f4);
            ((Matrix3f)object).transform(vector3f);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        Object object3 = this.thisMesh == null ? (n > 0 ? "lp" : "lcao") + ++this.nLCAO + "_" + string : (object2 = this.thisMesh.thisID);
        if (this.thisMesh == null) {
            this.allocMesh((String)object2, null);
        }
        if (string.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f2, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f2, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f4, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f4, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pza") || string.indexOf("sp") == 0 || string.indexOf("d") == 0 || string.indexOf("lp") == 0) {
            this.createLcaoLobe(vector3f, n2, n);
            return;
        }
        if (string.equals("pzb")) {
            this.createLcaoLobe(vector3f, -n2, n);
            return;
        }
        if (string.equals("pxa")) {
            this.createLcaoLobe(vector3f2, n2, n);
            return;
        }
        if (string.equals("pxb")) {
            this.createLcaoLobe(vector3f2, -n2, n);
            return;
        }
        if (string.equals("pya")) {
            this.createLcaoLobe(vector3f4, n2, n);
            return;
        }
        if (string.equals("pyb")) {
            this.createLcaoLobe(vector3f4, -n2, n);
            return;
        }
        if (string.equals("spacefill") || string.equals("cpk")) {
            this.createLcaoLobe(null, 2.0f * this.viewer.getAtomRadius(this.atomIndex), n);
            return;
        }
        this.createLcaoLobe(null, 1.0f, n);
    }

    private void createLcaoLobe(Vector3f vector3f, float f, int n) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        if (vector3f == null) {
            this.setProperty("sphere", new Float(f / 2.0f), null);
        } else {
            this.lcaoDir.x = vector3f.x * f;
            this.lcaoDir.y = vector3f.y * f;
            this.lcaoDir.z = vector3f.z * f;
            this.lcaoDir.w = 0.7f;
            this.setProperty(n == 2 ? "lp" : (n == 1 ? "rad" : "lobe"), this.lcaoDir, null);
        }
        this.thisMesh.colix = this.defaultColix;
        this.setScriptInfo(null);
    }

    @Override
    public void invalidateTriangles() {
        this.thisMesh.invalidatePolygons();
    }

    @Override
    public void setOutputStream(BinaryDocument binaryDocument, OutputStream outputStream) {
        binaryDocument.setOutputStream(outputStream, this.viewer, this.privateKey);
    }

    @Override
    public void fillMeshData(MeshData meshData, int n, IsosurfaceMesh isosurfaceMesh) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
            }
            if (!this.thisMesh.isMerged) {
                this.thisMesh.clear(this.myType, this.sg.getIAddGridPoints());
            }
            this.thisMesh.connections = this.connections;
            this.thisMesh.colix = this.getDefaultColix();
            this.thisMesh.meshColix = this.meshColix;
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        if (isosurfaceMesh == null) {
            isosurfaceMesh = this.thisMesh;
        }
        if (isosurfaceMesh == null) {
            return;
        }
        switch (n) {
            case 1: {
                meshData.mergeVertexCount0 = isosurfaceMesh.mergeVertexCount0;
                meshData.vertices = isosurfaceMesh.vertices;
                meshData.vertexSource = isosurfaceMesh.vertexSource;
                meshData.vertexValues = isosurfaceMesh.vertexValues;
                meshData.vertexCount = isosurfaceMesh.vertexCount;
                meshData.vertexIncrement = isosurfaceMesh.vertexIncrement;
                meshData.polygonCount = isosurfaceMesh.polygonCount;
                meshData.polygonIndexes = isosurfaceMesh.polygonIndexes;
                meshData.polygonColixes = isosurfaceMesh.polygonColixes;
                meshData.bsSlabDisplay = isosurfaceMesh.bsSlabDisplay;
                meshData.bsSlabGhost = isosurfaceMesh.bsSlabGhost;
                meshData.slabColix = isosurfaceMesh.slabColix;
                meshData.slabMeshType = isosurfaceMesh.slabMeshType;
                meshData.polygonCount0 = isosurfaceMesh.polygonCount0;
                meshData.vertexCount0 = isosurfaceMesh.vertexCount0;
                meshData.slabOptions = isosurfaceMesh.slabOptions;
                return;
            }
            case 2: {
                if (isosurfaceMesh.vertexColixes == null || isosurfaceMesh.vertexCount > isosurfaceMesh.vertexColixes.length) {
                    isosurfaceMesh.vertexColixes = new short[isosurfaceMesh.vertexCount];
                }
                meshData.vertexColixes = isosurfaceMesh.vertexColixes;
                return;
            }
            case 3: {
                isosurfaceMesh.surfaceSet = meshData.surfaceSet;
                isosurfaceMesh.vertexSets = meshData.vertexSets;
                isosurfaceMesh.nSets = meshData.nSets;
                return;
            }
            case 4: {
                isosurfaceMesh.vertices = meshData.vertices;
                isosurfaceMesh.vertexValues = meshData.vertexValues;
                isosurfaceMesh.vertexCount = meshData.vertexCount;
                isosurfaceMesh.vertexIncrement = meshData.vertexIncrement;
                isosurfaceMesh.vertexSource = meshData.vertexSource;
                isosurfaceMesh.polygonCount = meshData.polygonCount;
                isosurfaceMesh.polygonIndexes = meshData.polygonIndexes;
                isosurfaceMesh.polygonColixes = meshData.polygonColixes;
                isosurfaceMesh.bsSlabDisplay = meshData.bsSlabDisplay;
                isosurfaceMesh.bsSlabGhost = meshData.bsSlabGhost;
                isosurfaceMesh.slabColix = meshData.slabColix;
                isosurfaceMesh.slabMeshType = meshData.slabMeshType;
                isosurfaceMesh.polygonCount0 = meshData.polygonCount0;
                isosurfaceMesh.vertexCount0 = meshData.vertexCount0;
                isosurfaceMesh.mergeVertexCount0 = meshData.mergeVertexCount0;
                isosurfaceMesh.slabOptions = meshData.slabOptions;
                return;
            }
        }
    }

    @Override
    public void notifySurfaceGenerationCompleted() {
        this.setMesh();
        this.setBsVdw();
        this.thisMesh.insideOut = this.sg.isInsideOut();
        this.thisMesh.vertexSource = this.sg.getVertexSource();
        this.thisMesh.spanningVectors = this.sg.getSpanningVectors();
        this.thisMesh.calculatedArea = null;
        this.thisMesh.calculatedVolume = null;
        Parameters parameters = this.sg.getParams();
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.getPlane());
        }
        if (!parameters.allowVolumeRender) {
            this.thisMesh.jvxlData.allowVolumeRender = false;
        }
        this.thisMesh.setColorsFromJvxlData(this.sg.getParams().colorRgb);
        if (this.thisMesh.jvxlData.slabInfo != null) {
            this.viewer.runScriptImmediately("isosurface " + this.thisMesh.jvxlData.slabInfo);
        }
        if (this.sg.getParams().psi_monteCarloCount > 0) {
            this.thisMesh.diameter = -1;
        }
    }

    @Override
    public void notifySurfaceMappingCompleted() {
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.getPlane());
            this.thisMesh.setJvxlDataRendering();
        }
        this.setBsVdw();
        this.thisMesh.isColorSolid = false;
        this.thisMesh.colorDensity = this.jvxlData.colorDensity;
        this.thisMesh.colorEncoder = this.sg.getColorEncoder();
        this.thisMesh.getContours();
        if (this.thisMesh.jvxlData.nContours != 0 && this.thisMesh.jvxlData.nContours != -1) {
            this.explicitContours = true;
        }
        if (this.explicitContours && this.thisMesh.jvxlData.jvxlPlane != null) {
            this.thisMesh.havePlanarContours = true;
        }
        this.setPropertySuper("token", this.explicitContours ? 1073742046 : 1073741938, null);
        this.setPropertySuper("token", this.explicitContours ? 0x4000004A : 1073742039, null);
        List<Object[]> list = this.sg.getSlabInfo();
        if (list != null) {
            this.thisMesh.slabPolygons(list, false);
            this.thisMesh.reinitializeLightingAndColor();
        }
        this.thisMesh.setColorCommand();
    }

    private void setBsVdw() {
        BitSet bitSet = this.sg.geVdwBitSet();
        if (bitSet == null) {
            return;
        }
        if (this.thisMesh.bsVdw == null) {
            this.thisMesh.bsVdw = new BitSet();
        }
        this.thisMesh.bsVdw.or(bitSet);
    }

    @Override
    public Point3f[] calculateGeodesicSurface(BitSet bitSet, float f) {
        return this.viewer.calculateSurface(bitSet, f);
    }

    @Override
    public int getSurfacePointIndexAndFraction(float f, boolean bl, int n, int n2, int n3, Point3i point3i, int n4, int n5, float f2, float f3, Point3f point3f, Vector3f vector3f, boolean bl2, float[] fArray) {
        return 0;
    }

    @Override
    public int addVertexCopy(Point3f point3f, float f, int n) {
        if (this.cutoffRange != null && (f < this.cutoffRange[0] || f > this.cutoffRange[1])) {
            return -1;
        }
        return this.withinPoints != null && !Mesh.checkWithin(point3f, this.withinPoints, this.withinDistance2, this.isWithinNot) ? -1 : this.thisMesh.addVertexCopy(point3f, f, n, this.associateNormals);
    }

    @Override
    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        return n < 0 || n2 < 0 || n3 < 0 || bl && !MeshData.checkCutoff(n, n2, n3, this.thisMesh.vertexValues) ? -1 : this.thisMesh.addTriangleCheck(n, n2, n3, n4, n5, n6);
    }

    protected void setScriptInfo(String string) {
        int n;
        String string2 = string == null ? this.sg.getScript() : string;
        int n2 = n = string2 == null ? -1 : string2.indexOf("; isosurface map");
        if (n == 0) {
            if (this.thisMesh.scriptCommand == null) {
                return;
            }
            n = this.thisMesh.scriptCommand.indexOf("; isosurface map");
            if (n >= 0) {
                this.thisMesh.scriptCommand = this.thisMesh.scriptCommand.substring(0, n);
            }
            this.thisMesh.scriptCommand = this.thisMesh.scriptCommand + string2;
            return;
        }
        this.thisMesh.title = this.sg.getTitle();
        this.thisMesh.dataType = this.sg.getParams().dataType;
        this.thisMesh.scale3d = this.sg.getParams().scale3d;
        if (string2 != null && string2.charAt(0) == ' ') {
            string2 = this.myType + " ID " + Escape.escape(this.thisMesh.thisID) + string2;
            n = string2.indexOf("; isosurface map");
        }
        this.thisMesh.scriptCommand = n > 0 && this.scriptAppendix.length() > 0 ? string2.substring(0, n) + this.scriptAppendix + string2.substring(n) : string2 + this.scriptAppendix;
        if (!this.explicitID && string2 != null && (n = string2.indexOf("# ID=")) >= 0) {
            this.thisMesh.thisID = Parser.getNextQuotedString(string2, n);
        }
    }

    @Override
    public void addRequiredFile(String string) {
        string = " # /*file*/\"" + string + "\"";
        if (this.scriptAppendix.indexOf(string) < 0) {
            this.scriptAppendix = this.scriptAppendix + string;
        }
    }

    private void setJvxlInfo() {
        if (this.sg.getJvxlData() != this.jvxlData || this.sg.getJvxlData() != this.thisMesh.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.getJvxlData();
        }
    }

    @Override
    public List<Map<String, Object>> getShapeDetail() {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null || isosurfaceMesh.vertexCount == 0 && isosurfaceMesh.polygonCount == 0) continue;
            this.addMeshInfo(isosurfaceMesh, hashtable);
            arrayList.add(hashtable);
        }
        return arrayList;
    }

    protected void addMeshInfo(IsosurfaceMesh isosurfaceMesh, Map<String, Object> map) {
        map.put("ID", isosurfaceMesh.thisID == null ? "<noid>" : isosurfaceMesh.thisID);
        map.put("vertexCount", isosurfaceMesh.vertexCount);
        if (isosurfaceMesh.calculatedVolume != null) {
            map.put("volume", isosurfaceMesh.calculatedVolume);
        }
        if (isosurfaceMesh.calculatedArea != null) {
            map.put("area", isosurfaceMesh.calculatedArea);
        }
        if (isosurfaceMesh.ptCenter.x != Float.MAX_VALUE) {
            map.put("center", isosurfaceMesh.ptCenter);
        }
        if (isosurfaceMesh.mat4 != null) {
            map.put("mat4", isosurfaceMesh.mat4);
        }
        if (isosurfaceMesh.scale3d != 0.0f) {
            map.put("scale3d", new Float(isosurfaceMesh.scale3d));
        }
        map.put("xyzMin", isosurfaceMesh.jvxlData.boundingBox[0]);
        map.put("xyzMax", isosurfaceMesh.jvxlData.boundingBox[1]);
        String string = JvxlCoder.jvxlGetInfo(isosurfaceMesh.jvxlData);
        if (string != null) {
            map.put("jvxlInfo", string.replace('\n', ' '));
        }
        map.put("modelIndex", isosurfaceMesh.modelIndex);
        map.put("color", ColorUtil.colorPointFromInt2(Graphics3D.getArgb(isosurfaceMesh.colix)));
        if (isosurfaceMesh.colorEncoder != null) {
            map.put("colorKey", isosurfaceMesh.colorEncoder.getColorKey());
        }
        if (isosurfaceMesh.title != null) {
            map.put("title", isosurfaceMesh.title);
        }
        if (isosurfaceMesh.jvxlData.contourValues != null || isosurfaceMesh.jvxlData.contourValuesUsed != null) {
            map.put("contours", isosurfaceMesh.getContourList(this.viewer));
        }
    }

    @Override
    public float[] getPlane(int n) {
        return null;
    }

    @Override
    public float getValue(int n, int n2, int n3, int n4) {
        return 0.0f;
    }

    @Override
    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        if (this.keyXy != null && n >= this.keyXy[0] && n2 >= this.keyXy[1] && n < this.keyXy[2] && n2 < this.keyXy[3]) {
            this.hoverKey(n, n2);
            return true;
        }
        if (!this.viewer.getDrawHover()) {
            return false;
        }
        String string = this.findValue(n, n2, false, bitSet);
        if (string == null) {
            return false;
        }
        if (this.g3d.isDisplayAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.viewer.hoverOn(n, n2, string, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    private void hoverKey(int n, int n2) {
        try {
            String string;
            float f = 1.0f - 1.0f * (float)(n2 - this.keyXy[1]) / (float)(this.keyXy[3] - this.keyXy[1]);
            if (this.thisMesh.showContourLines) {
                List<Object>[] listArray = this.thisMesh.getContours();
                if (listArray == null) {
                    if (this.thisMesh.jvxlData.contourValues == null) {
                        return;
                    }
                    int n3 = (int)(f * (float)this.thisMesh.jvxlData.contourValues.length);
                    if (n3 < 0 || n3 > this.thisMesh.jvxlData.contourValues.length) {
                        return;
                    }
                    string = "" + this.thisMesh.jvxlData.contourValues[n3];
                } else {
                    int n4 = (int)(f * (float)listArray.length);
                    if (n4 < 0 || n4 > listArray.length) {
                        return;
                    }
                    string = "" + ((Float)listArray[n4].get(2)).floatValue();
                }
            } else {
                float f2 = this.thisMesh.colorEncoder.quantize(f, true);
                f = this.thisMesh.colorEncoder.quantize(f, false);
                string = "" + f2 + " - " + f;
            }
            if (this.g3d.isAntialiased()) {
                n <<= 1;
                n2 <<= 1;
            }
            this.viewer.hoverOn(n, n2, string, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Object object;
        Object object2;
        int n4;
        if (!(this.viewer.getDrawPicking() || this.viewer.getNavigationMode() && this.viewer.getNavigateSurface())) {
            return null;
        }
        if (!this.viewer.isBound(n3, 38)) {
            return null;
        }
        int n5 = 100;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n5 <<= 1;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        boolean bl = this.viewer.getDrawPicking();
        for (n4 = 0; n4 < this.meshCount; ++n4) {
            object2 = this.isomeshes[n4];
            if (!this.isPickable((IsosurfaceMesh)object2, bitSet)) continue;
            Object object3 = object = bl ? ((IsosurfaceMesh)object2).vertices : ((IsosurfaceMesh)object2).getCenters();
            if (object == null) continue;
            int n11 = ((Point3f[])object).length;
            while (--n11 >= 0) {
                int n12;
                Point3f point3f = object[n11];
                if (point3f == null || (n12 = this.coordinateInRange(n, n2, point3f, n5, this.ptXY)) < 0) continue;
                if (this.ptXY.z < n10) {
                    if (bl) {
                        n6 = n4;
                    }
                    n10 = this.ptXY.z;
                    n8 = n11;
                }
                if (this.ptXY.z <= n9) continue;
                if (!bl) {
                    n6 = n4;
                }
                n9 = this.ptXY.z;
                n7 = n11;
            }
        }
        if (n6 < 0) {
            return null;
        }
        this.pickedMesh = this.isomeshes[n6];
        this.setPropertySuper("thisID", this.pickedMesh.thisID, null);
        this.pickedVertex = bl ? n8 : n7;
        n4 = this.pickedVertex;
        object2 = new Point3f();
        ((Tuple3f)object2).set(bl ? this.pickedMesh.vertices[this.pickedVertex] : ((IsosurfaceMesh)this.pickedMesh).centers[n4]);
        this.pickedModel = (short)this.pickedMesh.modelIndex;
        if (bl) {
            this.setStatusPicked(-4, (Point3f)object2);
        } else {
            object = new Vector3f();
            ((IsosurfaceMesh)this.pickedMesh).getFacePlane(n4, (Vector3f)object);
            ((Tuple3f)object).scale(-1.0f);
            this.setHeading((Point3f)object2, (Vector3f)object, 2);
        }
        return this.getPickedPoint((Point3f)object2, this.pickedModel);
    }

    private boolean isPickable(IsosurfaceMesh isosurfaceMesh, BitSet bitSet) {
        return isosurfaceMesh.visibilityFlags != 0 && (isosurfaceMesh.modelIndex < 0 || bitSet.get(isosurfaceMesh.modelIndex)) && !Graphics3D.isColixTranslucent(isosurfaceMesh.colix);
    }

    private void navigate(int n) {
        if (this.thisMesh == null) {
            return;
        }
        Point3f point3f = new Point3f(this.viewer.getNavigationOffset());
        Point3f point3f2 = new Point3f();
        this.viewer.unTransformPoint(point3f, point3f2);
        point3f.z += (float)n;
        this.viewer.unTransformPoint(point3f, point3f2);
        Point3f point3f3 = new Point3f();
        Vector3f vector3f = new Vector3f();
        if (!this.getClosestNormal(this.thisMesh, point3f2, point3f3, vector3f)) {
            return;
        }
        Point3f point3f4 = new Point3f(point3f3);
        point3f4.add(vector3f);
        Point3f point3f5 = new Point3f();
        this.viewer.transformPoint(point3f4, point3f5);
        if (point3f5.y > point3f.y) {
            vector3f.scale(-1.0f);
        }
        this.setHeading(point3f3, vector3f, 0);
    }

    private void setHeading(Point3f point3f, Vector3f vector3f, int n) {
        StateManager.Orientation orientation = this.viewer.getOrientation();
        this.viewer.navigate(0.0f, point3f);
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f(vector3f);
        point3f3.add(point3f);
        this.viewer.transformPoint(point3f3, point3f2);
        Point3f point3f4 = new Point3f(this.viewer.getNavigationOffset());
        point3f2.sub(point3f4);
        point3f2.z = 0.0f;
        float f = Measure.computeTorsion(JmolConstants.axisNY, JmolConstants.center, JmolConstants.axisZ, point3f2, true);
        this.viewer.navigate(0.0f, JmolConstants.axisZ, f);
        point3f3.set(vector3f);
        point3f3.add(point3f);
        this.viewer.transformPoint(point3f3, point3f2);
        point3f2.sub(point3f4);
        f = Measure.computeTorsion(JmolConstants.axisNY, JmolConstants.center, JmolConstants.axisX, point3f2, true);
        this.viewer.navigate(0.0f, JmolConstants.axisX, 20.0f - f);
        point3f4 = new Point3f(this.viewer.getNavigationOffset());
        if (n <= 0) {
            return;
        }
        this.viewer.saveOrientation("_navsurf");
        orientation.restore(0.0f, true);
        this.viewer.script("restore orientation _navsurf " + n);
    }

    private boolean getClosestNormal(IsosurfaceMesh isosurfaceMesh, Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Point3f[] point3fArray = isosurfaceMesh.getCenters();
        float f = Float.MAX_VALUE;
        int n = -1;
        int n2 = point3fArray.length;
        while (--n2 >= 0) {
            float f2;
            float f3 = point3fArray[n2].distance(point3f);
            if (f2 >= f) continue;
            f = f3;
            n = n2;
        }
        if (n < 0) {
            return false;
        }
        this.getClosestPoint(isosurfaceMesh, n, point3f, point3f2, vector3f);
        return true;
    }

    private void getClosestPoint(IsosurfaceMesh isosurfaceMesh, int n, Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Point4f point4f = isosurfaceMesh.getFacePlane(n, vector3f);
        float f = Measure.distanceToPlane(point4f, point3f);
        vector3f.scale(-f);
        point3f2.set(point3f);
        point3f2.add(vector3f);
        f = Measure.distanceToPlane(point4f, point3f2);
        if (isosurfaceMesh.centers[n].distance(point3f) < point3f2.distance(point3f)) {
            point3f2.set(isosurfaceMesh.centers[n]);
        }
    }

    private String findValue(int n, int n2, boolean bl, BitSet bitSet) {
        int n3 = 100;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        int n4 = -1;
        List<Object> list = null;
        IsosurfaceMesh isosurfaceMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n5;
            int n6;
            int n7;
            isosurfaceMesh = this.isomeshes[i];
            if (!this.isPickable(isosurfaceMesh, bitSet)) continue;
            List<Object>[] listArray = isosurfaceMesh.jvxlData.vContours;
            int n8 = isosurfaceMesh.firstRealVertex < 0 ? 0 : isosurfaceMesh.firstRealVertex;
            int n9 = 0;
            if (listArray != null && listArray.length > 0) {
                for (n7 = 0; n7 < listArray.length; ++n7) {
                    List<Object> list2 = listArray[n7];
                    n6 = list2.size() - 1;
                    for (n5 = 6; n5 < n6; ++n5) {
                        Point3f point3f = (Point3f)list2.get(n5);
                        int n10 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
                        if (n10 < 0) continue;
                        n3 = n10;
                        list = list2;
                        n9 = n7;
                        this.pickedMesh = isosurfaceMesh;
                        this.pickedPt = point3f;
                    }
                }
                if (list == null) continue;
                return list.get(2).toString() + (Logger.debugging ? " " + n9 : "");
            }
            if (isosurfaceMesh.jvxlData.jvxlPlane != null && isosurfaceMesh.vertexValues != null) {
                Point3f[] point3fArray = isosurfaceMesh.mat4 == null && isosurfaceMesh.scale3d == 0.0f ? isosurfaceMesh.vertices : isosurfaceMesh.getOffsetVertices(isosurfaceMesh.jvxlData.jvxlPlane);
                int n11 = isosurfaceMesh.vertexCount;
                while (--n11 >= n8) {
                    Point3f point3f = point3fArray[n11];
                    n5 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
                    if (n5 < 0) continue;
                    n3 = n5;
                    n4 = n11;
                    this.pickedMesh = isosurfaceMesh;
                    this.pickedPt = point3f;
                }
                if (n4 == -1) continue;
                break;
            }
            if (isosurfaceMesh.vertexValues == null) continue;
            n7 = isosurfaceMesh.vertexCount;
            while (--n7 >= n8) {
                Point3f point3f = isosurfaceMesh.vertices[n7];
                n6 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
                if (n6 < 0) continue;
                n3 = n6;
                n4 = n7;
                this.pickedMesh = isosurfaceMesh;
                this.pickedPt = point3f;
            }
            if (n4 != -1) break;
        }
        return n4 == -1 ? null : (Logger.debugging ? "$" + isosurfaceMesh.thisID + "[" + (n4 + 1) + "] " + isosurfaceMesh.vertices[n4] + ": " : isosurfaceMesh.thisID + ": ") + isosurfaceMesh.vertexValues[n4];
    }

    @Override
    public void merge(Shape shape) {
        super.merge(shape);
    }

    public String getCmd(int n) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        this.getMeshCommand(stringBuffer, n);
        return stringBuffer.toString();
    }
}

