/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jmol.api.JmolMeasurementClient;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.TickInfo;
import org.jmol.shape.FontLineShape;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measures
extends Shape
implements JmolMeasurementClient {
    private BitSet bsColixSet;
    private BitSet bsSelected;
    private String strFormat;
    private boolean mustBeConnected = false;
    private boolean mustNotBeConnected = false;
    private RadiusData radiusData;
    private Boolean intramolecular;
    private Atom[] atoms;
    int measurementCount = 0;
    final List<Measurement> measurements = new ArrayList<Measurement>();
    MeasurementPending measurementPending;
    short mad = (short)-1;
    short colix;
    Font3D font3d;
    TickInfo tickInfo;
    TickInfo defaultTickInfo;
    private int tokAction;

    @Override
    protected void initModelSet() {
        int n = this.measurements.size();
        while (--n >= 0) {
            Measurement measurement = this.measurements.get(n);
            if (measurement == null) continue;
            measurement.modelSet = this.modelSet;
        }
        this.atoms = this.modelSet.atoms;
    }

    @Override
    public void initShape() {
        super.initShape();
        this.font3d = this.g3d.getFont3D(15.0f);
    }

    @Override
    protected void setSize(int n, BitSet bitSet) {
        this.mad = (short)n;
    }

    @Override
    public void setProperty(String string, Object object, BitSet bitSet) {
        int n;
        int n2;
        if ("clearModelIndex" == string) {
            for (int i = 0; i < this.measurementCount; ++i) {
                this.measurements.get(i).setModelIndex((short)0);
            }
            return;
        }
        if ("color" == string) {
            this.setColor(object == null ? (short)0 : Graphics3D.getColix(object));
            return;
        }
        if ("delete" == string) {
            this.delete(object);
            this.setIndices();
            return;
        }
        if ("font" == string) {
            this.font3d = (Font3D)object;
            return;
        }
        if ("hideAll" == string) {
            this.showHide((Boolean)object);
            return;
        }
        if ("pending" == string) {
            this.pending((MeasurementPending)object);
            return;
        }
        boolean bl = "refresh" == string;
        if (bl || "refreshTrajectories" == string) {
            int n3 = this.measurements.size();
            while (--n3 >= 0) {
                Measurement measurement = this.measurements.get(n3);
                if (measurement == null || !bl && !measurement.isTrajectory()) continue;
                measurement.refresh();
            }
            return;
        }
        if ("select" == string) {
            BitSet bitSet2 = (BitSet)object;
            if (bitSet2 == null || BitSetUtil.cardinalityOf(bitSet2) == 0) {
                this.bsSelected = null;
            } else {
                this.bsSelected = new BitSet();
                this.bsSelected.or(bitSet2);
            }
            return;
        }
        if ("setFormats" == string) {
            this.setFormats((String)object);
            return;
        }
        this.bsSelected = null;
        if ("maps" == string) {
            int[][] nArray = (int[][])object;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2].length;
                if (n < 2 || n > 4) continue;
                int[] nArray2 = new int[n + 1];
                nArray2[0] = n;
                System.arraycopy(nArray[n2], 0, nArray2, 1, n);
                this.toggleOn(nArray2);
            }
        } else if ("measure" == string) {
            MeasurementData measurementData = (MeasurementData)object;
            this.tickInfo = measurementData.tickInfo;
            if (measurementData.tickInfo != null && measurementData.tickInfo.id.equals("default")) {
                this.defaultTickInfo = measurementData.tickInfo;
                return;
            }
            this.radiusData = measurementData.radiusData;
            this.mustBeConnected = measurementData.mustBeConnected;
            this.mustNotBeConnected = measurementData.mustNotBeConnected;
            this.intramolecular = measurementData.intramolecular;
            this.strFormat = measurementData.strFormat;
            if (measurementData.isAll) {
                if (this.tickInfo != null) {
                    this.define(measurementData, 12291);
                }
                this.define(measurementData, measurementData.tokAction);
                this.setIndices();
                return;
            }
            Measurement measurement = this.setSingleItem(measurementData.points);
            switch (measurementData.tokAction) {
                case 12291: {
                    this.define(Integer.MIN_VALUE, measurement, true, false, false);
                    this.setIndices();
                    break;
                }
                case 0x10000D: {
                    this.showHide(measurement, false);
                    break;
                }
                case 0x10000C: {
                    this.showHide(measurement, true);
                    break;
                }
                case 1060866: {
                    this.delete(measurement);
                    this.toggle(measurement);
                    break;
                }
                case 269484114: {
                    this.toggle(measurement);
                }
            }
            return;
        }
        if ("clear" == string) {
            this.clear();
            return;
        }
        if ("deleteModelAtoms" == string) {
            this.atoms = (Atom[])((Object[])object)[1];
            int n4 = ((int[])((Object[])object)[2])[0];
            n2 = ((int[])((Object[])object)[2])[1];
            n = ((int[])((Object[])object)[2])[2];
            int n5 = n2 + n;
            int n6 = this.measurementCount;
            block10: while (--n6 >= 0) {
                Measurement measurement = this.measurements.get(n6);
                int[] nArray = measurement.getCountPlusIndices();
                for (int i = 1; i <= nArray[0]; ++i) {
                    int n7 = nArray[i];
                    if (n7 >= n2) {
                        if (n7 < n5) {
                            this.deleteMeasurement(n6);
                            continue block10;
                        }
                        int n8 = i;
                        nArray[n8] = nArray[n8] - n;
                        continue;
                    }
                    if (n7 >= 0) continue;
                    Point3fi point3fi = measurement.getAtom(i);
                    if (point3fi.modelIndex > n4) {
                        point3fi.modelIndex = (short)(point3fi.modelIndex - 1);
                        continue;
                    }
                    if (point3fi.modelIndex != n4) continue;
                    this.deleteMeasurement(n6);
                    continue block10;
                }
            }
            return;
        }
        if ("hide" == string) {
            this.showHide(new Measurement(this.modelSet, (int[])object, null, null), true);
            return;
        }
        if ("reformatDistances" == string) {
            this.reformatDistances();
            return;
        }
        if ("show" == string) {
            this.showHide(new Measurement(this.modelSet, (int[])object, null, null), false);
            return;
        }
        if ("toggle" == string) {
            this.toggle(new Measurement(this.modelSet, (int[])object, null, null));
            return;
        }
        if ("toggleOn" == string) {
            this.toggleOn((int[])object);
            return;
        }
    }

    private Measurement setSingleItem(List<Object> list) {
        Point3fi[] point3fiArray = new Point3fi[4];
        int[] nArray = new int[5];
        nArray[0] = list.size();
        int n = list.size();
        while (--n >= 0) {
            Object object = list.get(n);
            if (object instanceof BitSet) {
                int n2 = ((BitSet)object).nextSetBit(0);
                if (n2 < 0) {
                    return null;
                }
                nArray[n + 1] = n2;
                continue;
            }
            point3fiArray[n] = (Point3fi)object;
            nArray[n + 1] = -2 - n;
        }
        return new Measurement(this.modelSet, nArray, point3fiArray, this.tickInfo == null ? this.defaultTickInfo : this.tickInfo);
    }

    @Override
    public Object getProperty(String string, int n) {
        if ("pending".equals(string)) {
            return this.measurementPending;
        }
        if ("count".equals(string)) {
            return this.measurementCount;
        }
        if ("countPlusIndices".equals(string)) {
            return n < this.measurementCount ? this.measurements.get(n).getCountPlusIndices() : null;
        }
        if ("stringValue".equals(string)) {
            return n < this.measurementCount ? this.measurements.get(n).getString() : null;
        }
        if ("pointInfo".equals(string)) {
            return this.measurements.get(n / 10).getLabel(n % 10, false, false);
        }
        if ("info".equals(string)) {
            return this.getAllInfo();
        }
        if ("infostring".equals(string)) {
            return this.getAllInfoAsString();
        }
        return null;
    }

    private void clear() {
        if (this.measurementCount == 0) {
            return;
        }
        this.measurementCount = 0;
        this.measurements.clear();
        this.viewer.setStatusMeasuring("measureDeleted", -1, "all", 0.0f);
    }

    private void setColor(short s) {
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        if (this.bsSelected == null) {
            this.colix = s;
        }
        int n = this.measurements.size();
        while (--n >= 0) {
            Measurement measurement = this.measurements.get(n);
            if (measurement == null || (this.bsSelected == null || !this.bsSelected.get(n)) && (this.bsSelected != null || s != 0 && measurement.getColix() != 0)) continue;
            measurement.setColix(s);
            this.bsColixSet.set(n);
        }
    }

    private void setFormats(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        int n = this.measurements.size();
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            this.measurements.get(n).formatMeasurement(string, null, false);
        }
    }

    private void showHide(boolean bl) {
        int n = this.measurements.size();
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            this.measurements.get(n).setHidden(bl);
        }
    }

    private void showHide(Measurement measurement, boolean bl) {
        int n = this.find(measurement);
        if (n >= 0) {
            this.measurements.get(n).setHidden(bl);
        }
    }

    private void toggle(Measurement measurement) {
        Measurement measurement2;
        this.radiusData = null;
        int n = this.find(measurement);
        if (n >= 0 && !(measurement2 = this.measurements.get(n)).isHidden()) {
            this.define(n, measurement2, true, false, false);
        } else {
            this.define(-1, measurement, false, true, false);
        }
        this.setIndices();
    }

    private void toggleOn(int[] nArray) {
        this.radiusData = null;
        this.bsSelected = new BitSet();
        this.define(Integer.MIN_VALUE, new Measurement(this.modelSet, nArray, null, this.defaultTickInfo), false, true, true);
        this.setIndices();
        this.reformatDistances();
    }

    private void delete(Measurement measurement) {
        this.radiusData = null;
        int n = this.find(measurement);
        if (n >= 0) {
            this.define(n, this.measurements.get(n), true, false, false);
        }
        this.setIndices();
    }

    private void delete(Object object) {
        if (object instanceof int[]) {
            this.define(Integer.MIN_VALUE, new Measurement(this.modelSet, (int[])object, null, null), true, false, false);
            return;
        }
        if (object instanceof Integer) {
            this.deleteMeasurement((Integer)object);
        }
    }

    private void define(int n, Measurement measurement, boolean bl, boolean bl2, boolean bl3) {
        if (!this.viewer.getMeasureAllModelsFlag()) {
            if (bl) {
                if (n == Integer.MIN_VALUE) {
                    n = this.find(measurement);
                }
                if (n >= 0) {
                    this.deleteMeasurement(n);
                }
                return;
            }
            this.defineMeasurement(n, measurement, bl3);
            return;
        }
        if (bl2) {
            this.define(n, measurement, true, false, false);
            if (bl) {
                return;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = measurement.getCount();
        for (int i = 1; i <= n2; ++i) {
            int n3 = measurement.getAtomIndex(i);
            arrayList.add(n3 >= 0 ? this.viewer.getAtomBits(1095763969, this.atoms[n3].getAtomNumber()) : measurement.getAtom(i));
        }
        MeasurementData measurementData = new MeasurementData(this.viewer, arrayList, this.tokAction, this.radiusData, this.strFormat, null, this.tickInfo, this.mustBeConnected, this.mustNotBeConnected, this.intramolecular, true);
        this.define(measurementData, bl ? 12291 : 1060866);
    }

    private int find(Measurement measurement) {
        return Measurement.find(this.measurements, measurement);
    }

    private void setIndices() {
        for (int i = 0; i < this.measurementCount; ++i) {
            this.measurements.get(i).setIndex(i);
        }
    }

    private void define(MeasurementData measurementData, int n) {
        this.tokAction = n;
        measurementData.define(this, this.modelSet);
    }

    @Override
    public void processNextMeasure(Measurement measurement) {
        int n = this.find(measurement);
        if (n >= 0) {
            if (this.tokAction == 12291) {
                this.deleteMeasurement(n);
            } else if (this.strFormat != null) {
                this.measurements.get(n).formatMeasurement(this.strFormat, null, true);
            } else {
                this.measurements.get(n).setHidden(this.tokAction == 0x10000C);
            }
        } else if (this.tokAction == 1060866 || this.tokAction == 269484114) {
            measurement.tickInfo = this.tickInfo == null ? this.defaultTickInfo : this.tickInfo;
            this.defineMeasurement(-1, measurement, true);
        }
    }

    private void defineMeasurement(int n, Measurement measurement, boolean bl) {
        float f = measurement.getMeasurement();
        if (this.radiusData != null && !measurement.isInRange(this.radiusData, f)) {
            return;
        }
        if (n == Integer.MIN_VALUE) {
            n = this.find(measurement);
        }
        if (n >= 0) {
            this.measurements.get(n).setHidden(false);
            if (bl) {
                this.bsSelected.set(n);
            }
            return;
        }
        Measurement measurement2 = new Measurement(this.modelSet, measurement, f, this.colix, this.strFormat, this.measurementCount);
        this.measurements.add(measurement2);
        this.viewer.setStatusMeasuring("measureCompleted", this.measurementCount++, measurement2.toVector(false).toString(), measurement2.getValue());
    }

    private void deleteMeasurement(int n) {
        String string = this.measurements.get(n).toVector(true).toString();
        this.measurements.remove(n);
        --this.measurementCount;
        this.viewer.setStatusMeasuring("measureDeleted", n, string, 0.0f);
    }

    private void pending(MeasurementPending measurementPending) {
        this.measurementPending = measurementPending;
        if (measurementPending == null) {
            return;
        }
        if (measurementPending.getCount() > 1) {
            this.viewer.setStatusMeasuring("measurePending", measurementPending.getCount(), measurementPending.toVector(false).toString(), measurementPending.getValue());
        }
    }

    private void reformatDistances() {
        int n = this.measurementCount;
        while (--n >= 0) {
            this.measurements.get(n).reformatDistanceIfSelected();
        }
    }

    private List<Map<String, Object>> getAllInfo() {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.measurementCount; ++i) {
            arrayList.add(this.getInfo(i));
        }
        return arrayList;
    }

    private String getAllInfoAsString() {
        String string = "Measurement Information";
        for (int i = 0; i < this.measurementCount; ++i) {
            string = string + "\n" + this.getInfoAsString(i);
        }
        return string;
    }

    private Map<String, Object> getInfo(int n) {
        Measurement measurement = this.measurements.get(n);
        int n2 = measurement.getCount();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("index", n);
        hashtable.put("type", n2 == 2 ? "distance" : (n2 == 3 ? "angle" : "dihedral"));
        hashtable.put("strMeasurement", measurement.getString());
        hashtable.put("count", n2);
        hashtable.put("value", new Float(measurement.getValue()));
        TickInfo tickInfo = measurement.getTickInfo();
        if (tickInfo != null) {
            hashtable.put("ticks", tickInfo.ticks);
            if (tickInfo.scale != null) {
                hashtable.put("tickScale", tickInfo.scale);
            }
            if (tickInfo.tickLabelFormats != null) {
                hashtable.put("tickLabelFormats", tickInfo.tickLabelFormats);
            }
            if (!Float.isNaN(tickInfo.first)) {
                hashtable.put("tickStart", new Float(tickInfo.first));
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 1; i <= n2; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            int n3 = measurement.getAtomIndex(i);
            hashtable2.put("_ipt", n3);
            hashtable2.put("coord", Escape.escape(measurement.getAtom(i)));
            hashtable2.put("atomno", n3 < 0 ? -1 : this.atoms[n3].getAtomNumber());
            hashtable2.put("info", n3 < 0 ? "<point>" : this.atoms[n3].getInfo());
            arrayList.add(hashtable2);
        }
        hashtable.put("atoms", arrayList);
        return hashtable;
    }

    private String getInfoAsString(int n) {
        return this.measurements.get(n).getInfoAsString(null);
    }

    void setVisibilityInfo() {
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        int n = this.measurementCount;
        block0: while (--n >= 0) {
            Measurement measurement = this.measurements.get(n);
            measurement.setVisible(false);
            if (this.mad == 0 || measurement.isHidden()) continue;
            for (int i = measurement.getCount(); i > 0; --i) {
                short s;
                int n2 = measurement.getAtomIndex(i);
                if (n2 >= 0 ? !this.modelSet.atoms[n2].isClickable() : (s = measurement.getAtom((int)i).modelIndex) >= 0 && !bitSet.get(s)) continue block0;
            }
            measurement.setVisible(true);
        }
    }

    @Override
    public String getShapeState() {
        String string;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        Measures.appendCmd(stringBuffer, "measures delete");
        for (n2 = 0; n2 < this.measurementCount; ++n2) {
            Measures.appendCmd(stringBuffer, this.getState(n2));
        }
        Measures.appendCmd(stringBuffer, "select *; set measures " + this.viewer.getMeasureDistanceUnits());
        Measures.appendCmd(stringBuffer, Measures.getFontCommand("measures", this.font3d));
        n2 = 0;
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        BitSet bitSet = new BitSet(this.measurementCount);
        for (n = 0; n < this.measurementCount; ++n) {
            Measurement measurement = this.measurements.get(n);
            if (measurement.isHidden()) {
                ++n2;
                bitSet.set(n);
            }
            if (this.bsColixSet != null && this.bsColixSet.get(n)) {
                Measures.setStateInfo(hashtable, n, this.getColorCommand("measure", measurement.getColix()));
            }
            if (measurement.getStrFormat() == null) continue;
            Measures.setStateInfo(hashtable, n, "measure " + Escape.escape(measurement.getStrFormat()));
        }
        if (n2 > 0) {
            if (n2 == this.measurementCount) {
                Measures.appendCmd(stringBuffer, "measures off; # lines and numbers off");
            } else {
                for (n = 0; n < this.measurementCount; ++n) {
                    if (!bitSet.get(n)) continue;
                    Measures.setStateInfo(hashtable, n, "measure off");
                }
            }
        }
        if (this.defaultTickInfo != null) {
            stringBuffer.append(" measure ");
            FontLineShape.addTickInfo(stringBuffer, this.defaultTickInfo, true);
            stringBuffer.append(";\n");
        }
        if (this.mad >= 0) {
            stringBuffer.append(" set measurements " + (float)this.mad / 2000.0f).append(";\n");
        }
        if ((string = Measures.getShapeCommands(hashtable, null, "select measures")) != null && string.length() != 0) {
            stringBuffer.append(string);
            Measures.appendCmd(stringBuffer, "select measures ({null})");
        }
        return stringBuffer.toString();
    }

    private String getState(int n) {
        Measurement measurement = this.measurements.get(n);
        int n2 = measurement.getCount();
        StringBuffer stringBuffer = new StringBuffer("measure");
        TickInfo tickInfo = measurement.getTickInfo();
        if (tickInfo != null) {
            FontLineShape.addTickInfo(stringBuffer, tickInfo, true);
        }
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(" ").append(measurement.getLabel(i, true, true));
        }
        stringBuffer.append("; # " + this.getInfoAsString(n));
        return stringBuffer.toString();
    }
}

