/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jmol.api.JmolMeasurementClient;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementData
implements JmolMeasurementClient {
    private JmolMeasurementClient client;
    private List<String> measurementStrings;
    private Atom[] atoms;
    public boolean mustBeConnected;
    public boolean mustNotBeConnected;
    public TickInfo tickInfo;
    public int tokAction;
    public List<Object> points;
    public RadiusData radiusData;
    public String strFormat;
    public boolean isAll;
    private String units;
    public Boolean intramolecular;
    private float[] minArray;
    private Viewer viewer;
    private int iFirstAtom;
    private boolean justOneModel = true;

    public MeasurementData(Viewer viewer, List<Object> list, int n, RadiusData radiusData, String string, String string2, TickInfo tickInfo, boolean bl, boolean bl2, Boolean bl3, boolean bl4) {
        this.viewer = viewer;
        this.tokAction = n;
        this.points = list;
        if (list.size() >= 2 && list.get(0) instanceof BitSet && list.get(1) instanceof BitSet) {
            this.justOneModel = BitSetUtil.haveCommon(viewer.getModelBitSet((BitSet)list.get(0), false), viewer.getModelBitSet((BitSet)list.get(1), false));
        }
        this.radiusData = radiusData;
        this.strFormat = string;
        this.units = string2;
        this.tickInfo = tickInfo;
        this.mustBeConnected = bl;
        this.mustNotBeConnected = bl2;
        this.intramolecular = bl3;
        this.isAll = bl4;
    }

    @Override
    public void processNextMeasure(Measurement measurement) {
        float f = measurement.getMeasurement();
        if (this.radiusData != null && !measurement.isInRange(this.radiusData, f)) {
            return;
        }
        if (this.measurementStrings == null) {
            float f2 = this.minArray[this.iFirstAtom];
            measurement.value = f;
            f = measurement.fixValue(this.units, false);
            this.minArray[this.iFirstAtom] = 1.0f / f2 == Float.NEGATIVE_INFINITY ? f : Math.min(f2, f);
            return;
        }
        this.measurementStrings.add(measurement.getString(this.viewer, this.strFormat, this.units));
    }

    public Object getMeasurements(boolean bl) {
        if (bl) {
            this.minArray = new float[((BitSet)this.points.get(0)).cardinality()];
            for (int i = 0; i < this.minArray.length; ++i) {
                this.minArray[i] = -0.0f;
            }
            this.define(null, this.viewer.getModelSet());
            return this.minArray;
        }
        this.measurementStrings = new ArrayList<String>();
        this.define(null, this.viewer.getModelSet());
        return this.measurementStrings;
    }

    public void define(JmolMeasurementClient jmolMeasurementClient, ModelSet modelSet) {
        this.client = jmolMeasurementClient == null ? this : jmolMeasurementClient;
        this.atoms = modelSet.atoms;
        int n = this.points.size();
        if (n < 2) {
            return;
        }
        int n2 = -1;
        Point3fi[] point3fiArray = new Point3fi[4];
        int[] nArray = new int[5];
        Measurement measurement = new Measurement(modelSet, nArray, point3fiArray, null);
        measurement.setCount(n);
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            Object object = this.points.get(i);
            if (object instanceof BitSet) {
                BitSet bitSet = (BitSet)object;
                int n4 = bitSet.cardinality();
                if (n4 == 0) {
                    return;
                }
                if (n4 > 1) {
                    n2 = 0;
                }
                n3 = i;
                if (i == 0) {
                    this.iFirstAtom = 0;
                }
                nArray[i + 1] = bitSet.nextSetBit(0);
                continue;
            }
            point3fiArray[i] = (Point3fi)object;
            nArray[i + 1] = -2 - i;
        }
        this.nextMeasure(0, n3, measurement, n2);
    }

    private void nextMeasure(int n, int n2, Measurement measurement, int n3) {
        int n4;
        if (n > n2) {
            if (!(!measurement.isValid() || this.mustBeConnected && !measurement.isConnected(this.atoms, n) || this.mustNotBeConnected && measurement.isConnected(this.atoms, n) || this.intramolecular != null && measurement.isIntramolecular(this.atoms, n) != this.intramolecular.booleanValue())) {
                this.client.processNextMeasure(measurement);
            }
            return;
        }
        BitSet bitSet = (BitSet)this.points.get(n);
        int[] nArray = measurement.getCountPlusIndices();
        int n5 = n4 = n == 0 ? Integer.MAX_VALUE : nArray[n];
        if (n4 < 0) {
            this.nextMeasure(n + 1, n2, measurement, n3);
            return;
        }
        boolean bl = false;
        int n6 = bitSet.nextSetBit(0);
        int n7 = 0;
        while (n6 >= 0) {
            block9: {
                block10: {
                    int n8;
                    block11: {
                        if (n6 == n4) break block9;
                        n8 = this.atoms[n6].getModelIndex();
                        if (n3 < 0 || !this.justOneModel) break block10;
                        if (n != 0) break block11;
                        n3 = n8;
                        break block10;
                    }
                    if (n3 != n8) break block9;
                }
                nArray[n + 1] = n6;
                if (n == 0) {
                    this.iFirstAtom = n7;
                }
                bl = true;
                this.nextMeasure(n + 1, n2, measurement, n3);
            }
            n6 = bitSet.nextSetBit(n6 + 1);
            ++n7;
        }
        if (!bl) {
            this.nextMeasure(n + 1, n2, measurement, n3);
        }
    }
}

