/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.ApbsReader;
import org.jmol.jvxl.readers.AtomPropertyMapper;
import org.jmol.jvxl.readers.CastepDensityReader;
import org.jmol.jvxl.readers.CubeReader;
import org.jmol.jvxl.readers.Dsn6BinaryReader;
import org.jmol.jvxl.readers.EfvetReader;
import org.jmol.jvxl.readers.IsoFxyReader;
import org.jmol.jvxl.readers.IsoFxyzReader;
import org.jmol.jvxl.readers.IsoIntersectReader;
import org.jmol.jvxl.readers.IsoMOReader;
import org.jmol.jvxl.readers.IsoMepReader;
import org.jmol.jvxl.readers.IsoMlpReader;
import org.jmol.jvxl.readers.IsoPlaneReader;
import org.jmol.jvxl.readers.IsoShapeReader;
import org.jmol.jvxl.readers.IsoSolventReader;
import org.jmol.jvxl.readers.JaguarReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.JvxlXmlReader;
import org.jmol.jvxl.readers.KinemageReader;
import org.jmol.jvxl.readers.MrcBinaryReader;
import org.jmol.jvxl.readers.MsmsReader;
import org.jmol.jvxl.readers.NffFileReader;
import org.jmol.jvxl.readers.ObjReader;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.PltFormattedReader;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.jvxl.readers.XplorReader;
import org.jmol.jvxl.readers.XsfReader;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BinaryDocument;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.SurfaceFileTyper;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceGenerator {
    private JvxlData jvxlData;
    private MeshData meshData;
    private Parameters params;
    private VolumeData volumeData;
    private MeshDataServer meshDataServer;
    private AtomDataServer atomDataServer;
    private MarchingSquares marchingSquares;
    private String version;
    private boolean isValid = true;
    private String fileType;
    private OutputStream os;
    SurfaceReader surfaceReader;
    int colorPtr;
    final Vector3f vAC = new Vector3f();
    final Vector3f vAB = new Vector3f();
    final Vector3f vNorm = new Vector3f();
    final Point3f ptRef = new Point3f(0.0f, 0.0f, 1.0E15f);
    BitSet bsVdw;

    public boolean isValid() {
        return this.isValid;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public SurfaceGenerator() {
        this.setup(null, null, null, null);
    }

    public SurfaceGenerator(AtomDataServer atomDataServer, MeshDataServer meshDataServer, MeshData meshData, JvxlData jvxlData) {
        this.setup(atomDataServer, meshDataServer, meshData, jvxlData);
    }

    private void setup(AtomDataServer atomDataServer, MeshDataServer meshDataServer, MeshData meshData, JvxlData jvxlData) {
        this.atomDataServer = atomDataServer;
        this.meshDataServer = meshDataServer;
        this.params = new Parameters();
        this.meshData = meshData == null ? new MeshData() : meshData;
        this.jvxlData = jvxlData == null ? new JvxlData() : jvxlData;
        this.volumeData = new VolumeData();
        this.initializeIsosurface();
    }

    public boolean isStateDataRead() {
        return this.params.state == 2;
    }

    public String getFileName() {
        return this.params.fileName;
    }

    MeshDataServer getMeshDataServer() {
        return this.meshDataServer;
    }

    AtomDataServer getAtomDataServer() {
        return this.atomDataServer;
    }

    public ColorEncoder getColorEncoder() {
        return this.params.colorEncoder;
    }

    public int[] getVertexSource() {
        return this.params.vertexSource;
    }

    public void setJvxlData(JvxlData jvxlData) {
        this.jvxlData = jvxlData;
        if (jvxlData != null) {
            jvxlData.version = this.version;
        }
    }

    public JvxlData getJvxlData() {
        return this.jvxlData;
    }

    MeshData getMeshData() {
        return this.meshData;
    }

    void setMarchingSquares(MarchingSquares marchingSquares) {
        this.marchingSquares = marchingSquares;
    }

    MarchingSquares getMarchingSquares() {
        return this.marchingSquares;
    }

    public Parameters getParams() {
        return this.params;
    }

    public String getScript() {
        return this.params.script;
    }

    public String[] getTitle() {
        return this.params.title;
    }

    public BitSet getBsSelected() {
        return this.params.bsSelected;
    }

    public BitSet getBsIgnore() {
        return this.params.bsIgnore;
    }

    public VolumeData getVolumeData() {
        return this.volumeData;
    }

    public Point4f getPlane() {
        return this.params.thePlane;
    }

    public int getColor(int n) {
        switch (n) {
            case -1: {
                return this.params.colorNeg;
            }
            case 1: {
                return this.params.colorPos;
            }
        }
        return 0;
    }

    public void setModelIndex(int n) {
        this.params.modelIndex = n;
    }

    public boolean getIAddGridPoints() {
        return this.params.iAddGridPoints;
    }

    public boolean getIsPositiveOnly() {
        return this.params.isPositiveOnly;
    }

    public boolean isInsideOut() {
        return this.params.insideOut != this.params.dataXYReversed;
    }

    public float getCutoff() {
        return this.params.cutoff;
    }

    public Map<String, Object> getMoData() {
        return this.params.moData;
    }

    public boolean isCubeData() {
        return this.jvxlData.wasCubic;
    }

    public boolean setParameter(String string, Object object) {
        return this.setParameter(string, object, null);
    }

    public boolean setParameter(String string, Object object, BitSet bitSet) {
        if ("debug" == string) {
            boolean bl;
            this.params.logMessages = bl = ((Boolean)object).booleanValue();
            this.params.logCube = bl;
            return true;
        }
        if ("init" == string) {
            this.initializeIsosurface();
            if (object instanceof Parameters) {
                this.params = (Parameters)object;
            } else {
                this.params.script = (String)object;
                if (this.params.script != null && this.params.script.indexOf(";#") >= 0) {
                    this.params.script = TextFormat.simpleReplace(this.params.script, ";#", "; #");
                }
            }
            return false;
        }
        if ("map" == string) {
            this.params.resetForMapping((Boolean)object);
            if (this.surfaceReader != null) {
                this.surfaceReader.minMax = null;
            }
            return true;
        }
        if ("finalize" == string) {
            this.initializeIsosurface();
            return true;
        }
        if ("clear" == string) {
            if (this.surfaceReader != null) {
                this.surfaceReader.discardTempData(true);
            }
            return false;
        }
        if ("fileIndex" == string) {
            this.params.fileIndex = (Integer)object;
            if (this.params.fileIndex < 1) {
                this.params.fileIndex = 1;
            }
            this.params.readAllData = false;
            return true;
        }
        if ("blockData" == string) {
            this.params.blockCubeData = (Boolean)object;
            return true;
        }
        if ("withinPoints" == string) {
            this.params.boundingBox = (Point3f[])((Object[])object)[1];
            return true;
        }
        if ("boundingBox" == string) {
            Point3f[] point3fArray = (Point3f[])object;
            this.params.boundingBox = new Point3f[]{new Point3f(point3fArray[0]), new Point3f(point3fArray[point3fArray.length - 1])};
            return true;
        }
        if ("func" == string) {
            this.params.func = object;
            return true;
        }
        if ("intersection" == string) {
            this.params.intersection = (BitSet[])object;
            return true;
        }
        if ("bsSolvent" == string) {
            this.params.bsSolvent = (BitSet)object;
            return true;
        }
        if ("select" == string) {
            this.params.bsSelected = (BitSet)object;
            return true;
        }
        if ("ignore" == string) {
            this.params.bsIgnore = (BitSet)object;
            return true;
        }
        if ("propertySmoothing" == string) {
            this.params.propertySmoothing = (Boolean)object;
            return true;
        }
        if ("propertyDistanceMax" == string) {
            this.params.propertyDistanceMax = ((Float)object).floatValue();
            return true;
        }
        if ("propertySmoothingPower" == string) {
            this.params.propertySmoothingPower = (Integer)object;
            return true;
        }
        if ("title" == string) {
            if (object == null) {
                this.params.title = null;
                return true;
            }
            if (object instanceof String[]) {
                this.params.title = (String[])object;
                for (int i = 0; i < this.params.title.length; ++i) {
                    if (this.params.title[i].length() <= 0) continue;
                    Logger.info(this.params.title[i]);
                }
            }
            return true;
        }
        if ("sigma" == string) {
            this.params.cutoff = this.params.sigma = ((Float)object).floatValue();
            this.params.isPositiveOnly = false;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("cutoff" == string) {
            this.params.cutoff = ((Float)object).floatValue();
            this.params.isPositiveOnly = false;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("parameters" == string) {
            this.params.parameters = ArrayUtil.ensureLength((float[])object, 2);
            if (this.params.parameters.length > 0 && this.params.parameters[0] != 0.0f) {
                this.params.cutoff = this.params.parameters[0];
            }
            return true;
        }
        if ("cutoffPositive" == string) {
            this.params.cutoff = ((Float)object).floatValue();
            this.params.isPositiveOnly = true;
            return true;
        }
        if ("cap" == string || "slab" == string) {
            if (object != null) {
                this.params.addSlabInfo((Object[])object);
            }
            return true;
        }
        if ("scale" == string) {
            this.params.scale = ((Float)object).floatValue();
            return true;
        }
        if ("scale3d" == string) {
            this.params.scale3d = ((Float)object).floatValue();
            return true;
        }
        if ("angstroms" == string) {
            this.params.isAngstroms = true;
            return true;
        }
        if ("resolution" == string) {
            float f = ((Float)object).floatValue();
            this.params.resolution = f > 0.0f ? f : Float.MAX_VALUE;
            return true;
        }
        if ("downsample" == string) {
            int n = (Integer)object;
            this.params.downsampleFactor = n >= 0 ? n : 0;
            return true;
        }
        if ("anisotropy" == string) {
            if ((this.params.dataType & 0x20) == 0) {
                this.params.setAnisotropy((Point3f)object);
            }
            return true;
        }
        if ("eccentricity" == string) {
            this.params.setEccentricity((Point4f)object);
            return true;
        }
        if ("addHydrogens" == string) {
            this.params.addHydrogens = (Boolean)object;
            return true;
        }
        if ("squareData" == string) {
            this.params.isSquared = (Boolean)object;
            return true;
        }
        if ("gridPoints" == string) {
            this.params.iAddGridPoints = true;
            return true;
        }
        if ("atomIndex" == string) {
            this.params.atomIndex = (Integer)object;
            return true;
        }
        if ("insideOut" == string) {
            this.params.insideOut = true;
            return true;
        }
        if ("sign" == string) {
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.colorPtr = 0;
            return true;
        }
        if ("colorRGB" == string) {
            int n;
            this.params.colorPos = this.params.colorPosLCAO = (n = ((Integer)object).intValue());
            this.params.colorRgb = this.params.colorPosLCAO;
            if (this.colorPtr++ == 0) {
                this.params.colorNeg = this.params.colorNegLCAO = n;
            } else {
                this.params.colorRgb = Integer.MAX_VALUE;
            }
            return true;
        }
        if ("monteCarloCount" == string) {
            this.params.psi_monteCarloCount = (Integer)object;
            return true;
        }
        if ("rangeAll" == string) {
            this.params.rangeAll = true;
            return true;
        }
        if ("rangeSelected" == string) {
            this.params.rangeSelected = true;
            return true;
        }
        if ("red" == string) {
            this.params.valueMappedToRed = ((Float)object).floatValue();
            return true;
        }
        if ("blue" == string) {
            this.params.valueMappedToBlue = ((Float)object).floatValue();
            if (this.params.valueMappedToRed > this.params.valueMappedToBlue) {
                float f = this.params.valueMappedToRed;
                this.params.valueMappedToRed = this.params.valueMappedToBlue;
                this.params.valueMappedToBlue = f;
                this.params.isColorReversed = !this.params.isColorReversed;
            }
            this.params.rangeDefined = true;
            this.params.rangeAll = false;
            return true;
        }
        if ("reverseColor" == string) {
            this.params.isColorReversed = true;
            return true;
        }
        if ("setColorScheme" == string) {
            this.getSurfaceSets();
            this.params.colorBySets = true;
            this.mapSurface();
            return true;
        }
        if ("center" == string) {
            this.params.center.set((Point3f)object);
            return true;
        }
        if ("volumeData" == string) {
            this.params.volumeData = (VolumeData)object;
            return true;
        }
        if ("origin" == string) {
            this.params.origin = (Point3f)object;
            return true;
        }
        if ("step" == string) {
            this.params.steps = (Point3f)object;
            return true;
        }
        if ("point" == string) {
            this.params.points = (Point3f)object;
            return true;
        }
        if ("withinDistance" == string) {
            this.params.distance = ((Float)object).floatValue();
            return true;
        }
        if ("withinPoint" == string) {
            this.params.point = (Point3f)object;
            return true;
        }
        if ("progressive" == string) {
            this.params.isXLowToHigh = true;
            return true;
        }
        if ("phase" == string) {
            String string2 = (String)object;
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.params.colorByPhase = true;
            this.params.colorPhase = SurfaceReader.getColorPhaseIndex(string2);
            if (this.params.colorPhase < 0) {
                Logger.warn(" invalid color phase: " + string2);
                this.params.colorPhase = 0;
            }
            boolean bl = this.params.colorByPhase = this.params.colorPhase != 0;
            if (this.params.state >= 2) {
                this.params.dataType = this.params.surfaceType;
                this.params.state = 3;
                this.params.isBicolorMap = true;
                this.surfaceReader.applyColorScale();
            }
            return true;
        }
        if ("radius" == string) {
            Logger.info("solvent probe radius set to " + object);
            this.params.atomRadiusData = (RadiusData)object;
            return true;
        }
        if ("envelopeRadius" == string) {
            this.params.envelopeRadius = ((Float)object).floatValue();
            return true;
        }
        if ("cavityRadius" == string) {
            this.params.cavityRadius = ((Float)object).floatValue();
            return true;
        }
        if ("cavity" == string) {
            this.params.isCavity = true;
            return true;
        }
        if ("doFullMolecular" == string) {
            this.params.doFullMolecular = true;
            return true;
        }
        if ("pocket" == string) {
            this.params.pocket = (Boolean)object;
            this.params.fullyLit = this.params.pocket;
            return true;
        }
        if ("minset" == string) {
            this.params.minSet = (Integer)object;
            return true;
        }
        if ("maxset" == string) {
            this.params.maxSet = (Integer)object;
            return true;
        }
        if ("plane" == string) {
            this.params.setPlane((Point4f)object);
            return true;
        }
        if ("contour" == string) {
            this.params.isContoured = true;
            if (object instanceof float[]) {
                this.params.contoursDiscrete = (float[])object;
                this.params.nContours = this.params.contoursDiscrete.length;
            } else if (object instanceof Point3f) {
                Point3f point3f = this.params.contourIncrements = (Point3f)object;
                float f = point3f.x;
                float f2 = point3f.y;
                float f3 = point3f.z;
                if (f3 <= 0.0f) {
                    f3 = 1.0f;
                }
                int n = 0;
                float f4 = f;
                while (f4 <= f2 + f3 / 10.0f) {
                    f4 += f3;
                    ++n;
                }
                this.params.contoursDiscrete = new float[n];
                f4 = f;
                int n2 = 0;
                while (n2 < n) {
                    this.params.contoursDiscrete[n2] = f4;
                    ++n2;
                    f4 += f3;
                }
                this.params.nContours = n;
            } else {
                int n = (Integer)object;
                if (n == 0) {
                    this.params.nContours = 9;
                } else if (n > 0) {
                    this.params.nContours = n;
                } else {
                    this.params.thisContour = -n;
                }
            }
            return true;
        }
        if ("colorDiscrete" == string) {
            this.params.contourColixes = (short[])object;
            return true;
        }
        if ("colorDensity" == string) {
            this.params.colorDensity = true;
            return true;
        }
        if ("fullPlane" == string) {
            this.params.contourFromZero = (Boolean)object == false;
            return true;
        }
        if ("property" == string) {
            this.params.dataType = 1206;
            this.params.theProperty = (float[])object;
            this.mapSurface();
            return true;
        }
        if ("sphere" == string) {
            this.params.setSphere(((Float)object).floatValue());
            this.surfaceReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("ellipsoid" == string) {
            if (object instanceof Point4f) {
                this.params.setEllipsoid((Point4f)object);
            } else if (object instanceof float[]) {
                this.params.setEllipsoid((float[])object);
            } else {
                return true;
            }
            this.surfaceReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("ellipsoid3" == string) {
            this.params.setEllipsoid((float[])object);
            this.surfaceReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("lp" == string) {
            this.params.setLp((Point4f)object);
            this.surfaceReader = new IsoShapeReader(this, 3, 2, 0, 15.0f, 0);
            this.generateSurface();
            return true;
        }
        if ("rad" == string) {
            this.params.setRadical((Point4f)object);
            this.surfaceReader = new IsoShapeReader(this, 3, 2, 0, 15.0f, 0);
            this.generateSurface();
            return true;
        }
        if ("lobe" == string) {
            this.params.setLobe((Point4f)object);
            this.surfaceReader = new IsoShapeReader(this, 3, 2, 0, 15.0f, 0);
            this.generateSurface();
            return true;
        }
        if ("hydrogenOrbital" == string) {
            if (!this.params.setAtomicOrbital((float[])object)) {
                this.isValid = false;
                return true;
            }
            this.surfaceReader = new IsoShapeReader(this, this.params.psi_n, this.params.psi_l, this.params.psi_m, this.params.psi_Znuc, this.params.psi_monteCarloCount);
            this.processState();
            return true;
        }
        if ("functionXY" == string) {
            this.params.setFunctionXY((List)object);
            if (this.params.isContoured) {
                this.volumeData.setPlaneParameters(new Point4f(0.0f, 0.0f, 1.0f, 0.0f));
            }
            if (((String)this.params.functionInfo.get(0)).indexOf("_xyz") >= 0) {
                this.getFunctionZfromXY();
            }
            this.processState();
            return true;
        }
        if ("functionXYZ" == string) {
            this.params.setFunctionXYZ((List)object);
            this.processState();
            return true;
        }
        if ("lcaoType" == string) {
            this.params.setLcao((String)object, this.colorPtr);
            return true;
        }
        if ("lcaoCartoonCenter" == string) {
            if (++this.params.state != 2) {
                return true;
            }
            if (this.params.center.x == Float.MAX_VALUE) {
                this.params.center.set((Vector3f)object);
            }
            return false;
        }
        if ("molecular" == string || "solvent" == string || "sasurface" == string || "nomap" == string) {
            this.params.setSolvent(string, ((Float)object).floatValue());
            Logger.info(this.params.calculationType);
            this.processState();
            return true;
        }
        if ("moData" == string) {
            this.params.moData = (Map)object;
            return true;
        }
        if ("mepCalcType" == string) {
            this.params.mep_calcType = (Integer)object;
            return true;
        }
        if ("mep" == string) {
            this.params.setMep((float[])object, false);
            this.processState();
            return true;
        }
        if ("mlp" == string) {
            this.params.setMep((float[])object, true);
            this.processState();
            return true;
        }
        if ("nci" == string) {
            boolean bl = (Boolean)object;
            this.params.setNci(bl);
            if (bl) {
                this.processState();
            }
            return true;
        }
        if ("calculationType" == string) {
            this.params.calculationType = (String)object;
            return true;
        }
        if ("charges" == string) {
            this.params.theProperty = (float[])object;
            return true;
        }
        if ("randomSeed" == string) {
            this.params.randomSeed = (Integer)object;
            return true;
        }
        if ("molecularOrbital" == string) {
            int n = 0;
            float[] fArray = null;
            if (object instanceof Integer) {
                n = (Integer)object;
            } else {
                fArray = (float[])object;
            }
            this.params.setMO(n, fArray);
            Logger.info(this.params.calculationType);
            this.processState();
            return true;
        }
        if ("fileType" == string) {
            this.fileType = (String)object;
            return true;
        }
        if ("fileName" == string) {
            this.params.fileName = (String)object;
            return true;
        }
        if ("outputStream" == string) {
            this.os = (OutputStream)object;
            return true;
        }
        if ("readFile" == string) {
            this.surfaceReader = this.setFileData(object);
            if (this.surfaceReader == null) {
                Logger.error("Could not set the surface data");
                return true;
            }
            this.surfaceReader.setOutputStream(this.os);
            this.generateSurface();
            return true;
        }
        if ("getSurfaceSets" == string) {
            this.getSurfaceSets();
            return true;
        }
        if ("mapColor" == string) {
            this.surfaceReader = this.setFileData(object);
            if (this.surfaceReader == null) {
                Logger.error("Could not set the mapping data");
                return true;
            }
            this.surfaceReader.setOutputStream(this.os);
            this.mapSurface();
            return true;
        }
        if ("periodic" == string) {
            this.params.isPeriodic = true;
        }
        return false;
    }

    private void getSurfaceSets() {
        if (this.meshDataServer == null) {
            this.meshData.getSurfaceSet();
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
            this.meshData.getSurfaceSet();
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    private void processState() {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (this.params.state >= 2) {
            this.mapSurface();
        } else {
            this.generateSurface();
        }
    }

    private boolean setReader() {
        if (this.surfaceReader != null) {
            return !this.surfaceReader.vertexDataOnly;
        }
        switch (this.params.dataType) {
            case 1205: {
                this.surfaceReader = new IsoPlaneReader(this);
                break;
            }
            case 1206: {
                this.surfaceReader = new AtomPropertyMapper(this, null);
                break;
            }
            case 1333: {
                this.surfaceReader = new IsoIntersectReader(this);
                break;
            }
            case 1195: 
            case 1196: 
            case 1203: {
                this.surfaceReader = new IsoSolventReader(this);
                break;
            }
            case 1837: 
            case 1844: {
                this.surfaceReader = new IsoMOReader(this);
                break;
            }
            case 8: {
                this.surfaceReader = new IsoFxyReader(this);
                break;
            }
            case 9: {
                this.surfaceReader = new IsoFxyzReader(this);
                break;
            }
            case 1328: {
                if (this.params.state == 3) {
                    this.surfaceReader = new AtomPropertyMapper(this, "Mep");
                    break;
                }
                this.surfaceReader = new IsoMepReader(this);
                break;
            }
            case 1329: {
                this.surfaceReader = this.params.state == 3 ? new AtomPropertyMapper(this, "Mlp") : new IsoMlpReader(this);
            }
        }
        Logger.info("Using surface reader " + this.surfaceReader);
        return true;
    }

    private void generateSurface() {
        boolean bl;
        if (++this.params.state != 2) {
            return;
        }
        this.setReader();
        boolean bl2 = bl = this.meshDataServer != null;
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.surfaceReader == null) {
            Logger.error("surfaceReader is null for " + this.params.dataType);
            return;
        }
        if (!this.surfaceReader.createIsosurface(false)) {
            Logger.error("Could not create isosurface");
            this.params.cutoff = Float.NaN;
            this.surfaceReader.closeReader();
            return;
        }
        if (this.params.pocket != null && bl) {
            this.surfaceReader.selectPocket(this.params.pocket == false);
        }
        if (this.params.minSet > 0) {
            this.surfaceReader.excludeMinimumSet();
        }
        if (this.params.maxSet > 0) {
            this.surfaceReader.excludeMaximumSet();
        }
        if (this.params.slabInfo != null) {
            this.surfaceReader.slabIsosurface(this.params.slabInfo);
        }
        if (bl) {
            this.meshDataServer.notifySurfaceGenerationCompleted();
        }
        if (this.jvxlData.thisSet >= 0) {
            this.getSurfaceSets();
        }
        if (this.jvxlData.jvxlDataIs2dContour) {
            this.surfaceReader.colorIsosurface();
            this.params.state = 3;
        }
        if (this.jvxlData.jvxlDataIsColorDensity) {
            this.params.state = 3;
        }
        if (this.params.colorBySign || this.params.isBicolorMap) {
            this.params.state = 3;
            this.surfaceReader.applyColorScale();
        }
        this.surfaceReader.jvxlUpdateInfo();
        this.setMarchingSquares(this.surfaceReader.marchingSquares);
        this.surfaceReader.discardTempData(false);
        this.params.mappedDataMin = Float.MAX_VALUE;
        this.surfaceReader.closeReader();
        if (this.params.state != 3 && (this.surfaceReader.hasColorData || this.params.colorDensity)) {
            this.params.state = 3;
            this.colorIsosurface();
        }
        this.surfaceReader = null;
    }

    private void mapSurface() {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (++this.params.state < 3) {
            return;
        }
        if (!this.setReader()) {
            return;
        }
        if (this.params.isPeriodic) {
            this.volumeData.isPeriodic = true;
        }
        if (this.params.thePlane != null) {
            boolean bl = this.params.isSquared;
            this.params.isSquared = false;
            this.params.cutoff = 0.0f;
            this.volumeData.setMappingPlane(this.params.thePlane);
            this.surfaceReader.createIsosurface(!this.params.isPeriodic);
            this.volumeData.setMappingPlane(null);
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            if (this.params.dataType == 1205) {
                this.surfaceReader.discardTempData(true);
                return;
            }
            this.params.isSquared = bl;
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
        } else if (!this.params.colorBySets && !this.params.colorDensity) {
            this.surfaceReader.readAndSetVolumeParameters(true);
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
        }
        this.colorIsosurface();
        this.surfaceReader.closeReader();
        this.surfaceReader = null;
    }

    public List<Object[]> getSlabInfo() {
        return this.params.slabInfo;
    }

    void colorIsosurface() {
        this.surfaceReader.colorIsosurface();
        this.surfaceReader.jvxlUpdateInfo();
        this.surfaceReader.updateTriangles();
        this.surfaceReader.discardTempData(true);
        if (this.meshDataServer != null) {
            this.meshDataServer.notifySurfaceMappingCompleted();
        }
    }

    public Object getProperty(String string, int n) {
        if (string == "jvxlFileData") {
            return JvxlCoder.jvxlGetFile(this.jvxlData, null, this.params.title, "", true, n, null, null);
        }
        if (string == "jvxlFileInfo") {
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        return null;
    }

    private SurfaceReader setFileData(Object object) {
        String string = this.fileType;
        this.fileType = null;
        if (object instanceof VolumeData) {
            this.volumeData = (VolumeData)object;
            return new VolumeDataReader(this);
        }
        if (object instanceof Map) {
            this.volumeData = (VolumeData)((Map)object).get("volumeData");
            return new VolumeDataReader(this);
        }
        String string2 = null;
        if (object instanceof String) {
            string2 = (String)object;
            object = new BufferedReader(new StringReader((String)object));
        }
        BufferedReader bufferedReader = (BufferedReader)object;
        if (string == null) {
            string = SurfaceFileTyper.determineSurfaceFileType(bufferedReader);
        }
        if (string != null && string.startsWith("UPPSALA")) {
            String string3 = this.params.fileName;
            string3 = string3.substring(0, string3.indexOf("/", 10));
            this.params.fileName = string3 = string3 + Parser.getNextQuotedString(string, string.indexOf("A HREF") + 1);
            object = this.atomDataServer.getBufferedInputStream(string3);
            if (object == null) {
                Logger.error("Isosurface: could not open file " + string3);
                return null;
            }
            bufferedReader = new BufferedReader(new InputStreamReader((BufferedInputStream)object));
            string = SurfaceFileTyper.determineSurfaceFileType(bufferedReader);
        }
        if (string == null) {
            string = "UNKNOWN";
        }
        Logger.info("data file type was determined to be " + string);
        if (string.equals("Jvxl+")) {
            return new JvxlReader(this, bufferedReader);
        }
        if (string.equals("Jvxl")) {
            return new JvxlReader(this, bufferedReader);
        }
        if (string.equals("JvxlXML")) {
            return new JvxlXmlReader(this, bufferedReader);
        }
        if (string.equals("Apbs")) {
            return new ApbsReader(this, bufferedReader);
        }
        if (string.equals("Cube")) {
            return new CubeReader(this, bufferedReader);
        }
        if (string.equals("Jaguar")) {
            return new JaguarReader(this, bufferedReader);
        }
        if (string.equals("Xplor")) {
            return new XplorReader(this, bufferedReader);
        }
        if (string.equals("Xsf")) {
            return new XsfReader(this, bufferedReader);
        }
        if (string.equals("PltFormatted")) {
            return new PltFormattedReader(this, bufferedReader);
        }
        if (string.equals("MRC")) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bufferedReader = null;
            return new MrcBinaryReader(this, this.params.fileName);
        }
        if (string.equals("DSN6")) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bufferedReader = null;
            return new Dsn6BinaryReader(this, this.params.fileName, string2);
        }
        if (string.equals("Efvet")) {
            return new EfvetReader(this, bufferedReader);
        }
        if (string.equals("Pmesh")) {
            return new PmeshReader(this, this.params.fileName, bufferedReader);
        }
        if (string.equals("Obj")) {
            return new ObjReader(this, bufferedReader);
        }
        if (string.equals("Msms")) {
            return new MsmsReader(this, this.params.fileName, bufferedReader);
        }
        if (string.equals("Kinemage")) {
            return new KinemageReader(this, bufferedReader);
        }
        if (string.equals("CastepDensity")) {
            return new CastepDensityReader(this, bufferedReader);
        }
        if (string.equals("Nff")) {
            return new NffFileReader(this, bufferedReader);
        }
        return null;
    }

    void initializeIsosurface() {
        this.params.initialize();
        this.colorPtr = 0;
        this.surfaceReader = null;
        this.marchingSquares = null;
        this.initState();
    }

    public void initState() {
        this.params.state = 1;
        this.params.surfaceType = 0;
        this.params.dataType = 0;
    }

    public String setLcao() {
        this.params.colorPos = this.params.colorPosLCAO;
        this.params.colorNeg = this.params.colorNegLCAO;
        return this.params.lcaoType;
    }

    private void getFunctionZfromXY() {
        int n;
        Point3f point3f = (Point3f)this.params.functionInfo.get(1);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        Vector3f[] vector3fArray = new Vector3f[3];
        for (n = 0; n < 3; ++n) {
            Point4f point4f = (Point4f)this.params.functionInfo.get(n + 2);
            nArray[n] = Math.abs((int)point4f.x);
            vector3fArray[n] = new Vector3f(point4f.y, point4f.z, point4f.w);
        }
        n = nArray[0];
        int n2 = nArray[1];
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        Point3f point3f5 = new Point3f();
        float[][] fArray = (float[][])this.params.functionInfo.get(5);
        float[][] fArray2 = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                point3f2.scaleAdd(i, vector3fArray[0], point3f);
                point3f2.scaleAdd(j, vector3fArray[1], point3f2);
                float f = SurfaceGenerator.findNearestThreePoints(point3f2.x, point3f2.y, fArray, nArray2);
                float[] fArray3 = fArray[nArray2[0]];
                point3f3.set(fArray3[0], fArray3[1], fArray3[2]);
                if ((double)f < 1.0E-5) {
                    point3f2.z = fArray3[2];
                } else {
                    fArray3 = fArray[nArray2[1]];
                    point3f4.set(fArray3[0], fArray3[1], fArray3[2]);
                    fArray3 = fArray[nArray2[2]];
                    point3f5.set(fArray3[0], fArray3[1], fArray3[2]);
                    point3f2.z = this.distanceVerticalToPlane(point3f2.x, point3f2.y, point3f3, point3f4, point3f5);
                }
                fArray2[i][j] = point3f2.z;
            }
        }
        this.params.functionInfo.set(5, fArray2);
    }

    private float distanceVerticalToPlane(float f, float f2, Point3f point3f, Point3f point3f2, Point3f point3f3) {
        float f3 = Measure.getDirectedNormalThroughPoints(point3f, point3f2, point3f3, this.ptRef, this.vNorm, this.vAB, this.vAC);
        return (this.vNorm.x * f + this.vNorm.y * f2 + f3) / -this.vNorm.z;
    }

    private static float findNearestThreePoints(float f, float f2, float[][] fArray, int[] nArray) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MAX_VALUE;
        int n4 = fArray.length;
        while (--n4 >= 0) {
            float f6 = fArray[n4][0] - f;
            float f7 = f6 * f6;
            f6 = fArray[n4][1] - f2;
            if ((f6 = f7 + f6 * f6) < f5) {
                f3 = f4;
                f4 = f5;
                f5 = f6;
                n = n2;
                n2 = n3;
                n3 = n4;
                continue;
            }
            if (f6 < f4) {
                f3 = f4;
                f4 = f6;
                n = n2;
                n2 = n4;
                continue;
            }
            if (!(f6 < f3)) continue;
            f3 = f6;
            n = n4;
        }
        nArray[0] = n3;
        nArray[1] = n2;
        nArray[2] = n;
        return f5;
    }

    public void addRequiredFile(String string) {
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.addRequiredFile(string);
    }

    void log(String string) {
        if (this.atomDataServer == null) {
            System.out.println(string);
        } else {
            this.atomDataServer.log(string);
        }
    }

    void setOutputStream(BinaryDocument binaryDocument, OutputStream outputStream) {
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.setOutputStream(binaryDocument, outputStream);
    }

    public boolean isFullyLit() {
        return this.params.thePlane != null || this.params.fullyLit;
    }

    public BitSet geVdwBitSet() {
        return this.bsVdw;
    }

    void fillAtomData(AtomData atomData, int n) {
        if ((n & 2) != 0 && atomData.bsSelected != null) {
            if (this.bsVdw == null) {
                this.bsVdw = new BitSet();
            }
            this.bsVdw.or(atomData.bsSelected);
        }
        this.atomDataServer.fillAtomData(atomData, n);
    }

    public Vector3f[] getSpanningVectors() {
        return this.surfaceReader.getSpanningVectors();
    }
}

