/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolViewer;
import org.jmol.console.JmolFrame;
import org.jmol.console.KeyJMenuItem;
import org.jmol.console.ScriptEditor;
import org.jmol.constant.EnumCallback;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public abstract class JmolConsole
implements JmolCallbackListener,
ActionListener,
WindowListener {
    public JmolViewer viewer;
    protected JFrame viewerFrame;
    protected Container externalContainer;
    protected JButton editButton;
    protected JButton runButton;
    protected JButton historyButton;
    protected JButton stateButton;
    protected Map<String, String> labels;
    protected Map<String, AbstractButton> menuMap = new Hashtable<String, AbstractButton>();
    protected ScriptEditor scriptEditor;
    public int nTab = 0;
    private String incompleteCmd;
    protected String defaultMessage;
    protected JLabel label1;

    protected abstract void setupLabels();

    public void dispose() {
        if (this.externalContainer instanceof Window) {
            ((Window)this.externalContainer).dispose();
        } else {
            this.externalContainer.setVisible(false);
        }
    }

    protected Container getPane() {
        return this.externalContainer instanceof JFrame ? ((JFrame)this.externalContainer).getContentPane() : this.externalContainer;
    }

    protected String getLabel(String string) {
        if (this.labels == null) {
            this.labels = new Hashtable<String, String>();
            this.labels.put("title", GT._("Jmol Script Console") + " " + Viewer.getJmolVersion());
            this.setupLabels();
        }
        return this.labels.get(string);
    }

    protected void setTitle() {
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setTitle(this.getLabel("title"));
        } else if (this.externalContainer instanceof JDialog) {
            ((JDialog)this.externalContainer).setTitle(this.getLabel("title"));
        }
    }

    public void setVisible(boolean bl) {
        this.externalContainer.setVisible(bl);
    }

    void setScriptEditor(ScriptEditor scriptEditor) {
        this.scriptEditor = scriptEditor;
    }

    public JmolScriptEditorInterface getScriptEditor() {
        return this.scriptEditor == null ? (this.scriptEditor = new ScriptEditor(this.viewer, this.viewerFrame, this)) : this.scriptEditor;
    }

    protected abstract void clearContent(String var1);

    protected abstract void execute(String var1);

    public abstract String getText();

    public String completeCommand(String string) {
        String string2;
        if (string.length() == 0) {
            return null;
        }
        this.incompleteCmd = string2 = this.nTab <= 0 || this.incompleteCmd == null ? string : this.incompleteCmd;
        String[] stringArray = ScriptCompiler.splitCommandLine(string);
        if (stringArray == null) {
            return null;
        }
        boolean bl = stringArray[2] == null;
        String string3 = stringArray[bl ? 1 : 2];
        String string4 = stringArray[1];
        if (string3.length() == 0) {
            return null;
        }
        stringArray = ScriptCompiler.splitCommandLine(string2);
        String string5 = null;
        if (!(bl || string3.charAt(0) != '\"' && string3.charAt(0) != '\'')) {
            char c = string3.charAt(0);
            string3 = TextFormat.trim(string3, "\"'");
            String string6 = TextFormat.trim(stringArray[2], "\"'");
            string5 = this.nextFileName(string6, this.nTab);
            if (string5 != null) {
                string5 = stringArray[0] + stringArray[1] + c + string5 + c;
            }
        } else {
            Hashtable<String, Token> hashtable = null;
            if (!bl) {
                string3 = string4;
                if (stringArray[2].startsWith("$") || string4.equalsIgnoreCase("isosurface ") || string4.equalsIgnoreCase("contact ") || string4.equalsIgnoreCase("draw ")) {
                    hashtable = new Hashtable<String, Token>();
                    this.viewer.getObjectMap(hashtable, stringArray[2].startsWith("$"));
                }
            }
            string5 = Token.completeCommand(hashtable, string4.equalsIgnoreCase("set "), bl, bl ? stringArray[1] : stringArray[2], this.nTab);
            string5 = stringArray[0] + (string5 == null ? string3 : (bl ? string5 : stringArray[1] + string5));
        }
        return string5 == null || string5.equals(string2) ? null : string5;
    }

    private String nextFileName(String string, int n) {
        Object object;
        String string2 = FileManager.getLocalPathForWritingFile(this.viewer, string);
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6);
        }
        if (string2.indexOf("/") >= 0) {
            if (string3.equals(string2)) {
                string = "";
            } else {
                object = new File(string2);
                string2 = ((File)object).getParent();
                string = ((File)object).getName();
            }
        }
        object = new FileChecker(string);
        try {
            new File(string2).list((FilenameFilter)object);
            return string3 + ((FileChecker)object).getFile(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void setEnabled(JButton jButton, boolean bl) {
        if (jButton != null) {
            jButton.setEnabled(bl);
        }
    }

    protected JButton setButton(String string) {
        JButton jButton = new JButton(this.getLabel(string));
        jButton.addActionListener(this);
        this.menuMap.put(string, jButton);
        return jButton;
    }

    protected void updateLabels() {
        boolean bl = GT.getDoTranslate();
        this.labels = null;
        GT.setDoTranslate(true);
        this.defaultMessage = this.getLabel("default");
        KeyJMenuItem.setAbstractButtonLabels(this.menuMap, this.labels);
        this.setTitle();
        if (this.label1 != null) {
            this.label1.setText(this.getLabel("label1"));
        }
        GT.setDoTranslate(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runButton) {
            this.execute(null);
        } else if (object == this.editButton) {
            this.viewer.getProperty("DATA_API", "scriptEditor", null);
        } else if (object == this.historyButton) {
            this.clearContent(this.viewer.getSetHistory(Integer.MAX_VALUE));
        } else if (object == this.stateButton) {
            this.clearContent(this.viewer.getStateInfo());
        }
    }

    protected void addWindowListener() {
        Window window = JmolConsole.getWindow(this.externalContainer);
        if (window != null) {
            window.addWindowListener(this);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    private void destroyConsole() {
        if (this.viewer.isApplet()) {
            this.viewer.getProperty("DATA_API", "getAppConsole", Boolean.FALSE);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public boolean notifyEnabled(EnumCallback enumCallback) {
        switch (enumCallback) {
            case ECHO: 
            case MEASURE: 
            case MESSAGE: 
            case PICK: {
                return true;
            }
        }
        return false;
    }

    public abstract void sendConsoleMessage(String var1);

    public abstract void sendConsoleEcho(String var1);

    public void notifyCallback(EnumCallback enumCallback, Object[] objectArray) {
        String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
        switch (enumCallback) {
            case ECHO: {
                this.sendConsoleEcho(string);
                break;
            }
            case MEASURE: {
                String string2 = (String)objectArray[3];
                if (string2.indexOf("Picked") >= 0 || string2.indexOf("Sequence") >= 0) {
                    this.sendConsoleMessage(string);
                    break;
                }
                if (string2.indexOf("Completed") < 0) break;
                this.sendConsoleEcho(string.substring(string.lastIndexOf(",") + 2, string.length() - 1));
                break;
            }
            case MESSAGE: {
                this.sendConsoleMessage(objectArray == null ? null : string);
                break;
            }
            case PICK: {
                this.sendConsoleMessage(string);
            }
        }
    }

    public void setCallbackFunction(String string, String string2) {
    }

    public static Window getWindow(Container container) {
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            if (container instanceof JDialog) {
                return (JDialog)container;
            }
            if (container instanceof JmolFrame) {
                return ((JmolFrame)((Object)container)).getFrame();
            }
            container = container.getParent();
        }
        return null;
    }

    protected class FileChecker
    implements FilenameFilter {
        private String stub;
        private List<String> v = new ArrayList<String>();

        protected FileChecker(String string) {
            this.stub = string.toLowerCase();
        }

        public boolean accept(File file, String string) {
            if (!string.toLowerCase().startsWith(this.stub)) {
                return false;
            }
            this.v.add(string);
            return true;
        }

        protected String getFile(int n) {
            return ArrayUtil.sortedItem(this.v, n);
        }
    }
}

