/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.Quaternion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mesh
extends MeshSurface {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    public String[] title;
    public short meshColix;
    public short[] normixes;
    public List<Point3f[]> lineData;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public Point3f lattice;
    public boolean visible = true;
    public int lighting = 1073741958;
    public float scale = 1.0f;
    public boolean haveXyPoints;
    public int diameter;
    public float width;
    public Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
    public Mesh linkedMesh;
    public Map<String, BitSet> vertexColorMap;
    public int color;
    public SymmetryInterface unitCell;
    public float scale3d = 0.0f;
    public int index;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public boolean insideOut;
    public int checkByteCount;
    public boolean showContourLines = false;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isTwoSided = true;
    public boolean havePlanarContours = false;
    public final Vector3f vAB = new Vector3f();
    public final Vector3f vAC = new Vector3f();
    public final Vector3f vTemp = new Vector3f();
    public List<Object> xmlProperties;
    public boolean colorDensity;
    public Object cappingObject;
    public Object slabbingObject;
    public int[] connections;
    public boolean recalcAltVertices;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh(String string, JmolRendererInterface jmolRendererInterface, short s, int n) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            string = null;
        }
        this.thisID = string;
        this.colix = s;
        this.index = n;
    }

    public void clear(String string) {
        this.altVertices = null;
        this.bsDisplay = null;
        this.bsSlabDisplay = null;
        this.bsSlabGhost = null;
        this.cappingObject = null;
        this.colix = (short)23;
        this.colorDensity = false;
        this.connections = null;
        this.diameter = 0;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.frontOnly = false;
        this.havePlanarContours = false;
        this.haveXyPoints = false;
        this.isTriangleSet = false;
        this.isTwoSided = false;
        this.lattice = null;
        this.mat4 = null;
        this.normixes = null;
        this.scale3d = 1.0f;
        this.polygonIndexes = null;
        this.scale = 1.0f;
        this.showContourLines = false;
        this.showPoints = false;
        this.showTriangles = false;
        this.slabbingObject = null;
        this.slabOptions = null;
        this.title = null;
        this.unitCell = null;
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.polygonCount0 = 0;
        this.vertexCount0 = 0;
        this.vertices = null;
        this.spanningVectors = null;
        this.meshType = string;
    }

    public void initialize(int n, Point3f[] point3fArray, Point4f point4f) {
        if (point3fArray == null) {
            point3fArray = this.vertices;
        }
        Vector3f[] vector3fArray = this.getNormals(point3fArray, point4f);
        this.normixes = new short[this.normixCount];
        BitSet bitSet = new BitSet();
        if (this.haveXyPoints) {
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                this.normixes[n2] = 9999;
            }
        } else {
            int n3 = this.normixCount;
            while (--n3 >= 0) {
                this.normixes[n3] = Graphics3D.getNormix(vector3fArray[n3], bitSet);
            }
        }
        this.lighting = 1073741958;
        if (this.insideOut) {
            this.invertNormixes();
        }
        this.setLighting(n);
    }

    public Vector3f[] getNormals(Point3f[] point3fArray, Point4f point4f) {
        this.normixCount = this.isTriangleSet ? this.polygonCount : this.vertexCount;
        Vector3f[] vector3fArray = new Vector3f[this.normixCount];
        int n = this.normixCount;
        while (--n >= 0) {
            vector3fArray[n] = new Vector3f();
        }
        if (point4f == null) {
            this.sumVertexNormals(point3fArray, vector3fArray);
        } else {
            Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                vector3fArray[n2] = vector3f;
            }
        }
        if (!this.isTriangleSet) {
            int n3 = this.normixCount;
            while (--n3 >= 0) {
                vector3fArray[n3].normalize();
            }
        }
        return vector3fArray;
    }

    public void setLighting(int n) {
        boolean bl = this.isTwoSided = n == 1073741964;
        if (n == this.lighting) {
            return;
        }
        this.flipLighting(this.lighting);
        this.lighting = n;
        this.flipLighting(this.lighting);
    }

    private void flipLighting(int n) {
        if (n == 1073741964) {
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                this.normixes[n2] = ~this.normixes[n2];
            }
        } else if (n == 1073741958 == this.insideOut) {
            this.invertNormixes();
        }
    }

    private void invertNormixes() {
        int n = this.normixCount;
        while (--n >= 0) {
            this.normixes[n] = Graphics3D.getInverseNormix(this.normixes[n]);
        }
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, bl, f);
    }

    protected void sumVertexNormals(Point3f[] point3fArray, Vector3f[] vector3fArray) {
        int n = this.checkByteCount;
        float f = this.getMinDistanceForVertexGrouping();
        f *= f;
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            try {
                if (!this.setABC(n2)) continue;
                Point3f point3f = point3fArray[this.iA];
                Point3f point3f2 = point3fArray[this.iB];
                Point3f point3f3 = point3fArray[this.iC];
                if (point3f.distanceSquared(point3f2) < f || point3f2.distanceSquared(point3f3) < f || point3f.distanceSquared(point3f3) < f) continue;
                Measure.calcNormalizedNormal(point3f, point3f2, point3f3, this.vTemp, this.vAB, this.vAC);
                if (this.isTriangleSet) {
                    vector3fArray[n2].set(this.vTemp);
                    continue;
                }
                float f2 = this.vTemp.length();
                if (!((double)f2 > 0.9) || !((double)f2 < 1.1)) continue;
                int n3 = this.polygonIndexes[n2].length - n;
                while (--n3 >= 0) {
                    int n4 = this.polygonIndexes[n2][n3];
                    vector3fArray[n4].add(this.vTemp);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    protected float getMinDistanceForVertexGrouping() {
        return 1.0E-4f;
    }

    public String getState(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (!string.equals("mo")) {
            stringBuffer.append(" ID ").append(Escape.escape(this.thisID));
        }
        if (this.lattice != null) {
            stringBuffer.append(" lattice ").append(Escape.escape(this.lattice));
        }
        if (this.meshColix != 0) {
            stringBuffer.append(" color mesh ").append(Graphics3D.getHexCode(this.meshColix));
        }
        stringBuffer.append(this.getRendering());
        if (!this.visible) {
            stringBuffer.append(" hidden");
        }
        if (this.bsDisplay != null) {
            stringBuffer.append(";\n  ").append(string);
            if (!string.equals("mo")) {
                stringBuffer.append(" ID ").append(Escape.escape(this.thisID));
            }
            stringBuffer.append(" display " + Escape.escape(this.bsDisplay));
        }
        return stringBuffer.toString();
    }

    protected String getRendering() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fillTriangles ? " fill" : " noFill");
        stringBuffer.append(this.drawTriangles ? " mesh" : " noMesh");
        stringBuffer.append(this.showPoints ? " dots" : " noDots");
        stringBuffer.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showContourLines) {
            stringBuffer.append(" contourlines");
        }
        if (this.showTriangles) {
            stringBuffer.append(" triangles");
        }
        stringBuffer.append(" ").append(Token.nameOf(this.lighting));
        return stringBuffer.toString();
    }

    public Point3f[] getOffsetVertices(Point4f point4f) {
        if (this.altVertices != null && !this.recalcAltVertices) {
            return (Point3f[])this.altVertices;
        }
        this.altVertices = new Point3f[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            this.altVertices[i] = new Point3f(this.vertices[i]);
        }
        Vector3f vector3f = null;
        float f = 0.0f;
        if (this.scale3d != 0.0f && this.vertexValues != null && point4f != null) {
            vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
            vector3f.normalize();
            vector3f.scale(this.scale3d);
            if (this.mat4 != null) {
                Matrix3f matrix3f = new Matrix3f();
                this.mat4.get(matrix3f);
                matrix3f.transform(vector3f);
            }
        }
        for (int i = 0; i < this.vertexCount; ++i) {
            if (this.vertexValues != null && Float.isNaN(f = this.vertexValues[i])) continue;
            if (this.mat4 != null) {
                this.mat4.transform((Point3f)this.altVertices[i]);
            }
            Point3f point3f = (Point3f)this.altVertices[i];
            if (vector3f == null || f == 0.0f) continue;
            point3f.scaleAdd(f, vector3f, point3f);
        }
        this.initialize(this.lighting, (Point3f[])this.altVertices, null);
        this.recalcAltVertices = false;
        return (Point3f[])this.altVertices;
    }

    public void setShowWithin(List<Point3f> list, float f, boolean bl) {
        if (list.size() == 0) {
            this.bsDisplay = bl ? BitSetUtil.newBitSet(0, this.vertexCount) : null;
            return;
        }
        this.bsDisplay = new BitSet();
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!Mesh.checkWithin(this.vertices[i], list, f, bl)) continue;
            this.bsDisplay.set(i);
        }
    }

    public static boolean checkWithin(Point3f point3f, List<Point3f> list, float f, boolean bl) {
        if (list.size() != 0) {
            int n = list.size();
            while (--n >= 0) {
                if (!(point3f.distanceSquared(list.get(n)) <= f)) continue;
                return !bl;
            }
        }
        return bl;
    }

    public int getVertexIndexFromNumber(int n) {
        if (--n < 0) {
            n = this.vertexCount + n;
        }
        return this.vertexCount <= n ? this.vertexCount - 1 : (n < 0 ? 0 : n);
    }

    public BitSet getVisibleVertexBitSet() {
        BitSet bitSet = new BitSet();
        if (this.polygonCount == 0 && this.bsSlabDisplay != null) {
            BitSetUtil.copy(this.bsSlabDisplay, bitSet);
        } else {
            int n = this.polygonCount;
            while (--n >= 0) {
                int[] nArray;
                if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(n) || (nArray = this.polygonIndexes[n]) == null) continue;
                bitSet.set(nArray[0]);
                bitSet.set(nArray[1]);
                bitSet.set(nArray[2]);
            }
        }
        return bitSet;
    }

    BitSet getVisibleGhostBitSet() {
        BitSet bitSet = new BitSet();
        if (this.polygonCount == 0 && this.bsSlabGhost != null) {
            BitSetUtil.copy(this.bsSlabGhost, bitSet);
        } else {
            int n = this.polygonCount;
            while (--n >= 0) {
                int[] nArray;
                if (this.bsSlabGhost != null && !this.bsSlabGhost.get(n) || (nArray = this.polygonIndexes[n]) == null) continue;
                bitSet.set(nArray[0]);
                bitSet.set(nArray[1]);
                bitSet.set(nArray[2]);
            }
        }
        return bitSet;
    }

    public void setTokenProperty(int n, boolean bl) {
        switch (n) {
            case 0x40000088: 
            case 1073742058: {
                this.frontOnly = n == 0x40000088 ? bl : !bl;
                return;
            }
            case 1073741862: 
            case 1073741958: 
            case 1073741964: {
                this.setLighting(n);
                return;
            }
            case 1073742042: 
            case 1113198595: {
                this.showPoints = n == 1113198595 ? bl : !bl;
                return;
            }
            case 1073742018: 
            case 0x400000E4: {
                this.drawTriangles = n == 1073742018 ? bl : !bl;
                return;
            }
            case 1073741938: 
            case 1073742046: {
                this.fillTriangles = n == 1073741938 ? bl : !bl;
                return;
            }
            case 1073742060: 
            case 1073742182: {
                this.showTriangles = n == 1073742182 ? bl : !bl;
                return;
            }
            case 0x4000004A: 
            case 1073742039: {
                this.showContourLines = n == 0x4000004A ? bl : !bl;
                return;
            }
        }
    }

    Object getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", this.thisID);
        hashtable.put("vertexCount", this.vertexCount);
        hashtable.put("polygonCount", this.polygonCount);
        hashtable.put("haveQuads", this.haveQuads);
        if (this.vertexCount > 0) {
            hashtable.put("vertices", ArrayUtil.setLength(this.vertices, this.vertexCount));
        }
        if (this.vertexValues != null) {
            hashtable.put("vertexValues", ArrayUtil.setLength(this.vertexValues, this.vertexCount));
        }
        if (this.polygonCount > 0) {
            hashtable.put("polygons", ArrayUtil.setLength(this.polygonIndexes, this.polygonCount));
        }
        return hashtable;
    }

    public Point3f[] getBoundingBox() {
        return null;
    }

    public SymmetryInterface getUnitCell() {
        return null;
    }

    public void rotateTranslate(Quaternion quaternion, Tuple3f tuple3f, boolean bl) {
        if (quaternion == null && tuple3f == null) {
            this.mat4 = null;
            return;
        }
        Matrix3f matrix3f = new Matrix3f();
        Vector3f vector3f = new Vector3f();
        if (this.mat4 == null) {
            this.mat4 = new Matrix4f();
            this.mat4.setIdentity();
        }
        float f = this.mat4.get(matrix3f, vector3f);
        if (quaternion == null) {
            if (bl) {
                vector3f.set(tuple3f);
            } else {
                vector3f.add(tuple3f);
            }
        } else {
            matrix3f.mul(quaternion.getMatrix());
        }
        this.mat4 = new Matrix4f(matrix3f, vector3f, f);
        this.recalcAltVertices = true;
    }
}

