/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Point3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.OutputStringBuffer;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    public ModelSet modelSet;
    public int modelIndex;
    int fileIndex;
    public int hydrogenCount;
    public boolean isBioModel;
    public boolean isPdbWithMultipleBonds;
    public int trajectoryBaseIndex;
    protected boolean hasRasmolHBonds;
    String loadState = "";
    StringBuffer loadScript = new StringBuffer();
    boolean isModelKit;
    boolean isTrajectory;
    int selectedTrajectory = -1;
    Map<String, Integer> dataFrames;
    int dataSourceFrame = -1;
    String jmolData;
    String jmolFrameType;
    protected int firstAtomIndex;
    protected int atomCount = 0;
    protected final BitSet bsAtoms = new BitSet();
    final BitSet bsAtomsDeleted = new BitSet();
    private int bondCount = -1;
    int firstMoleculeIndex;
    int moleculeCount;
    public int nAltLocs;
    int nInsertions;
    int groupCount = -1;
    protected int chainCount = 0;
    protected Chain[] chains = new Chain[8];
    int biosymmetryCount;
    protected Map<String, Object> auxiliaryInfo;
    Properties properties;
    float defaultRotationRadius;
    String defaultStructure;
    StateManager.Orientation orientation;
    protected boolean structureTainted;
    boolean isJmolDataFrame;
    public long frameDelay;
    public SymmetryInterface unitCell;

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public boolean isModelkit() {
        return this.isModelKit;
    }

    public int getTrueAtomCount() {
        return this.bsAtoms.cardinality() - this.bsAtomsDeleted.cardinality();
    }

    public void resetBoundCount() {
        this.bondCount = -1;
    }

    protected int getBondCount() {
        if (this.bondCount >= 0) {
            return this.bondCount;
        }
        Bond[] bondArray = this.modelSet.getBonds();
        this.bondCount = 0;
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            if (bondArray[n].atom1.modelIndex != this.modelIndex) continue;
            ++this.bondCount;
        }
        return this.bondCount;
    }

    public Model(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        this.modelSet = modelSet;
        this.dataSourceFrame = this.modelIndex = n;
        this.isTrajectory = n2 >= 0;
        int n3 = this.trajectoryBaseIndex = this.isTrajectory ? n2 : n;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        this.auxiliaryInfo = map;
        if (map.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)map.get("biosymmetryCount");
        }
        this.properties = properties;
        if (string == null) {
            this.jmolFrameType = "modelSet";
        } else {
            this.jmolData = string;
            this.isJmolDataFrame = true;
            map.put("jmolData", string);
            map.put("title", string);
            this.jmolFrameType = string.indexOf("ramachandran") >= 0 ? "ramachandran" : (string.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
    }

    void setNAltLocs(int n) {
        this.nAltLocs = n;
    }

    void setNInsertions(int n) {
        this.nInsertions = n;
    }

    public String getModelNumberDotted() {
        return this.modelSet.getModelNumberDotted(this.modelIndex);
    }

    public String getModelTitle() {
        return this.modelSet.getModelTitle(this.modelIndex);
    }

    public boolean isStructureTainted() {
        return this.structureTainted;
    }

    public Chain[] getChains() {
        return this.chains;
    }

    public int getChainCount(boolean bl) {
        if (this.chainCount > 1 && !bl) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != '\u0000') continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    public int getGroupCount(boolean bl) {
        int n = 0;
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            int n3 = this.chains[n2].groupCount;
            while (--n3 >= 0) {
                if (this.chains[n2].groups[n3].isHetero() != bl) continue;
                ++n;
            }
        }
        return n;
    }

    void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.chainCount;
        while (--n >= 0) {
            this.chains[n].calcSelectedGroupsCount(bitSet);
        }
    }

    int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int n = this.chainCount;
            while (--n >= 0) {
                this.groupCount += this.chains[n].getGroupCount();
            }
        }
        return this.groupCount;
    }

    Chain getChain(int n) {
        return n < this.chainCount ? this.chains[n] : null;
    }

    Chain getChain(char c) {
        int n = this.chainCount;
        while (--n >= 0) {
            Chain chain = this.chains[n];
            if (chain.chainID != c) continue;
            return chain;
        }
        return null;
    }

    public void fixIndices(int n, int n2, BitSet bitSet) {
        if (this.dataSourceFrame > n) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > n) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= n2;
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].fixIndices(n2, bitSet);
        }
        BitSetUtil.deleteBits(this.bsAtoms, bitSet);
        BitSetUtil.deleteBits(this.bsAtomsDeleted, bitSet);
    }

    public void freeze() {
        this.chains = (Chain[])ArrayUtil.setLength(this.chains, this.chainCount);
        this.groupCount = -1;
        this.getGroupCount();
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].groups = (Group[])ArrayUtil.setLength(this.chains[i].groups, this.chains[i].groupCount);
        }
    }

    public void getPdbData(Viewer viewer, String string, char c, boolean bl, BitSet bitSet, OutputStringBuffer outputStringBuffer, LabelToken[] labelTokenArray, StringBuffer stringBuffer, BitSet bitSet2) {
    }

    public void getDefaultLargePDBRendering(StringBuffer stringBuffer, int n) {
    }

    public List<BitSet> getBioBranches(List<BitSet> list) {
        return list;
    }

    public void getGroupsWithin(int n, BitSet bitSet, BitSet bitSet2) {
    }

    public void getSequenceBits(String string, BitSet bitSet, BitSet bitSet2) {
    }

    public void getRasmolHydrogenBonds(BitSet bitSet, BitSet bitSet2, List<Bond> list, boolean bl, int n, boolean bl2, BitSet bitSet3) {
    }

    public void clearRasmolHydrogenBonds(BitSet bitSet) {
    }

    public void clearBioPolymers() {
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
    }

    public void calculatePolymers(Group[] groupArray, int n, int n2, BitSet bitSet) {
    }

    public void getAllPolymerInfo(BitSet bitSet, Map<String, List<Map<String, Object>>> map, List<Map<String, Object>> list) {
    }

    public int getBioPolymerCount() {
        return 0;
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, List<Point3f[]> list, boolean bl, float f) {
    }

    public Point3f[] getPolymerLeadMidPoints(int n) {
        return null;
    }

    public void recalculateLeadMidpointsAndWingVectors() {
    }

    public void addSecondaryStructure(EnumStructure enumStructure, String string, int n, int n2, char c, int n3, char c2, int n4) {
    }

    public String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return "";
    }

    public void setStructureList(Map<EnumStructure, float[]> map) {
    }

    public void getChimeInfo(StringBuffer stringBuffer, int n) {
        stringBuffer.append("\nNumber of Atoms ..... " + (this.modelSet.atomCount - n));
        if (n > 0) {
            stringBuffer.append(" (" + n + ")");
        }
        stringBuffer.append("\nNumber of Bonds ..... " + this.modelSet.bondCount);
        stringBuffer.append("\nNumber of Models ...... " + this.modelSet.modelCount);
    }

    public int calculateStruts(ModelSet modelSet, BitSet bitSet, BitSet bitSet2) {
        return 0;
    }

    public void calculateStraightness(Viewer viewer, char c, char c2, int n) {
    }

    public void selectSeqcodeRange(int n, int n2, char c, BitSet bitSet, boolean bl) {
    }

    public void setConformation(BitSet bitSet) {
    }

    public boolean getPdbConformation(BitSet bitSet, int n) {
        return false;
    }

    public String getProteinStructureState(BitSet bitSet, boolean bl, boolean bl2, int n) {
        return null;
    }

    public String getFullPDBHeader() {
        return null;
    }
}

