/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolLineReader;
import org.jmol.constant.EnumStructure;
import org.jmol.util.CifDataReader;
import org.jmol.util.Logger;

public class CifReader
extends AtomSetCollectionReader
implements JmolLineReader {
    private CifDataReader tokenizer = new CifDataReader((JmolLineReader)this);
    private String thisDataSetName = "";
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    private boolean iHaveDesiredModel;
    private boolean isPDB = false;
    private Map<String, String> htHetero;
    private boolean isMolecular;
    private String molecularType = "GEOM_BOND default";
    private char lastAltLoc;
    private int configurationPtr = Integer.MIN_VALUE;
    private int conformationIndex;
    private int nMolecular = 0;
    public static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma"};
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    private String key;
    private String data;
    private Map<String, Float> atomTypes;
    private List<Object[]> bondTypes = new ArrayList<Object[]>();
    private String disorderAssembly = ".";
    private String lastDisorderAssembly;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    private static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte COMP_ID = 11;
    private static final byte ASYM_ID = 12;
    private static final byte SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_Beta_11 = 41;
    private static final byte ANISO_Beta_22 = 42;
    private static final byte ANISO_Beta_33 = 43;
    private static final byte ANISO_Beta_12 = 44;
    private static final byte ANISO_Beta_13 = 45;
    private static final byte ANISO_Beta_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final byte CHEM_COMP_AC_ID = 48;
    private static final byte CHEM_COMP_AC_NAME = 49;
    private static final byte CHEM_COMP_AC_SYM = 50;
    private static final byte CHEM_COMP_AC_CHARGE = 51;
    private static final byte CHEM_COMP_AC_X = 52;
    private static final byte CHEM_COMP_AC_Y = 53;
    private static final byte CHEM_COMP_AC_Z = 54;
    private static final byte CHEM_COMP_AC_X_IDEAL = 55;
    private static final byte CHEM_COMP_AC_Y_IDEAL = 56;
    private static final byte CHEM_COMP_AC_Z_IDEAL = 57;
    private static final byte DISORDER_ASSEMBLY = 58;
    private static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site_Cartn_x", "_atom_site_Cartn_y", "_atom_site_Cartn_z", "_atom_site_occupancy", "_atom_site_b_iso_or_equiv", "_atom_site_auth_comp_id", "_atom_site_auth_asym_id", "_atom_site_auth_seq_id", "_atom_site_pdbx_PDB_ins_code", "_atom_site_label_alt_id", "_atom_site_group_PDB", "_atom_site_pdbx_PDB_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group", "_atom_site_aniso_label", "_atom_site_anisotrop_id", "_atom_site_aniso_U_11", "_atom_site_aniso_U_22", "_atom_site_aniso_U_33", "_atom_site_aniso_U_12", "_atom_site_aniso_U_13", "_atom_site_aniso_U_23", "_atom_site_anisotrop_U[1][1]", "_atom_site_anisotrop_U[2][2]", "_atom_site_anisotrop_U[3][3]", "_atom_site_anisotrop_U[1][2]", "_atom_site_anisotrop_U[1][3]", "_atom_site_anisotrop_U[2][3]", "_atom_site_U_iso_or_equiv", "_atom_site_aniso_B_11", "_atom_site_aniso_B_22", "_atom_site_aniso_B_33", "_atom_site_aniso_B_12", "_atom_site_aniso_B_13", "_atom_site_aniso_B_23", "_atom_site_aniso_Beta_11", "_atom_site_aniso_Beta_22", "_atom_site_aniso_Beta_33", "_atom_site_aniso_Beta_12", "_atom_site_aniso_Beta_13", "_atom_site_aniso_Beta_23", "_atom_site_adp_type", "_chem_comp_atom_comp_id", "_chem_comp_atom_atom_id", "_chem_comp_atom_type_symbol", "_chem_comp_atom_charge", "_chem_comp_atom_model_Cartn_x", "_chem_comp_atom_model_Cartn_y", "_chem_comp_atom_model_Cartn_z", "_chem_comp_atom_pdbx_model_Cartn_x_ideal", "_chem_comp_atom_pdbx_model_Cartn_y_ideal", "_chem_comp_atom_pdbx_model_Cartn_z_ideal", "_atom_site_disorder_assembly"};
    private static final byte CHEM_COMP_BOND_ATOM_ID_1 = 0;
    private static final byte CHEM_COMP_BOND_ATOM_ID_2 = 1;
    private static final byte CHEM_COMP_BOND_VALUE_ORDER = 2;
    private static final byte CHEM_COMP_BOND_AROMATIC_FLAG = 3;
    private static final String[] chemCompBondFields = new String[]{"_chem_comp_bond_atom_id_1", "_chem_comp_bond_atom_id_2", "_chem_comp_bond_value_order", "_chem_comp_bond_pdbx_aromatic_flag"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_DISTANCE = 2;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_distance"};
    private static final byte NONPOLY_ENTITY_ID = 0;
    private static final byte NONPOLY_NAME = 1;
    private static final byte NONPOLY_COMP_ID = 2;
    private static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly_entity_id", "_pdbx_entity_nonpoly_name", "_pdbx_entity_nonpoly_comp_id"};
    private String[] hetatmData;
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final byte STRUCT_ID = 7;
    private static final byte SERIAL_NO = 8;
    private static final byte HELIX_CLASS = 9;
    private static final String[] structConfFields = new String[]{"_struct_conf_conf_type_id", "_struct_conf_beg_auth_asym_id", "_struct_conf_beg_auth_seq_id", "_struct_conf_pdbx_beg_PDB_ins_code", "_struct_conf_end_auth_asym_id", "_struct_conf_end_auth_seq_id", "_struct_conf_pdbx_end_PDB_ins_code", "_struct_conf_id", "_struct_conf_pdbx_PDB_helix_id", "_struct_conf_pdbx_PDB_helix_class"};
    private static final byte SHEET_ID = 0;
    private static final byte STRAND_ID = 7;
    private static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range_sheet_id", "_struct_sheet_range_beg_auth_asym_id", "_struct_sheet_range_beg_auth_seq_id", "_struct_sheet_range_pdbx_beg_PDB_ins_code", "_struct_sheet_range_end_auth_asym_id", "_struct_sheet_range_end_auth_seq_id", "_struct_sheet_range_pdbx_end_PDB_ins_code", "_struct_sheet_range_id"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String[] structSiteRangeFields = new String[]{"_struct_site_gen_site_id", "_struct_site_gen_auth_comp_id", "_struct_site_gen_auth_asym_id", "_struct_site_gen_auth_seq_id", "_struct_site_gen_label_alt_id"};
    private Map<String, Map<String, Object>> htSites;
    private static final byte SYMOP_XYZ = 0;
    private static final byte SYM_EQUIV_XYZ = 1;
    private static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz"};
    String field;
    private char firstChar;
    private int[] propertyOf = new int[100];
    private byte[] fieldOf = new byte[atomFields.length];
    private int propertyCount;
    private float[] atomRadius;
    private BitSet[] bsConnected;
    private BitSet[] bsSets;
    private final Point3f ptOffset = new Point3f();
    private BitSet bsMolecule;
    private BitSet bsExclude;
    private int firstAtom;
    private int atomCount;
    private Atom[] atoms;

    public void initializeReader() throws Exception {
        if (this.checkFilter("CONF ")) {
            this.configurationPtr = this.parseInt(this.filter, this.filter.indexOf("CONF ") + 5);
        }
        boolean bl = this.isMolecular = this.filter != null && this.filter.indexOf("MOLECUL") >= 0;
        if (this.isMolecular) {
            if (!this.doApplySymmetry) {
                this.doApplySymmetry = true;
                this.latticeCells[0] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[2] = 1;
            }
            this.molecularType = "filter \"MOLECULAR\"";
        }
        int n = 0;
        this.line = "";
        boolean bl2 = false;
        while ((this.key = this.tokenizer.peekToken()) != null) {
            if (this.key.startsWith("data_")) {
                if (this.iHaveDesiredModel) break;
                boolean bl3 = bl2 = !this.doGetModel(++this.modelNumber, null);
                if (bl2) {
                    this.tokenizer.getTokenPeeked();
                    continue;
                }
                this.chemicalName = "";
                this.thisStructuralFormula = "";
                this.thisFormula = "";
                if (n == this.atomSetCollection.getAtomCount()) {
                    this.atomSetCollection.removeAtomSet();
                } else {
                    this.applySymmetryAndSetTrajectory();
                }
                this.processDataParameter();
                this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
                n = this.atomSetCollection.getAtomCount();
                continue;
            }
            if (this.key.startsWith("loop_")) {
                if (bl2) {
                    this.tokenizer.getTokenPeeked();
                    this.skipLoop();
                    continue;
                }
                this.processLoopBlock();
                continue;
            }
            if (this.key.indexOf("_") != 0) {
                Logger.warn((String)("CIF ERROR ? should be an underscore: " + this.key));
                this.tokenizer.getTokenPeeked();
            } else if (!this.getData()) continue;
            if (bl2) continue;
            this.key = this.key.replace('.', '_');
            if (this.key.startsWith("_chemical_name") || this.key.equals("_chem_comp_name")) {
                this.processChemicalInfo("name");
                continue;
            }
            if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
                continue;
            }
            if (this.key.startsWith("_chemical_formula_sum") || this.key.equals("_chem_comp_formula")) {
                this.processChemicalInfo("formula");
                continue;
            }
            if (this.key.startsWith("_cell_")) {
                this.processCellParameter();
                continue;
            }
            if (this.key.startsWith("_symmetry_space_group_name_H-M") || this.key.startsWith("_symmetry_space_group_name_Hall")) {
                this.processSymmetrySpaceGroupName();
                continue;
            }
            if (this.key.startsWith("_atom_sites_fract_tran")) {
                this.processUnitCellTransformMatrix();
                continue;
            }
            if (!this.key.startsWith("_pdbx_entity_nonpoly")) continue;
            this.processNonpolyData();
        }
        if (this.atomSetCollection.getAtomCount() == n) {
            this.atomSetCollection.removeAtomSet();
        } else {
            this.applySymmetryAndSetTrajectory();
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        this.atomSetCollection.setCollectionName("<collection of " + this.atomSetCollection.getAtomSetCount() + " models>");
        this.continuing = false;
    }

    protected void finalizeReader() throws Exception {
        super.finalizeReader();
        String string = this.tokenizer.getFileHeader();
        if (string.length() > 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", (Object)string);
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.atomSetCollection.setCheckSpecial(!this.isPDB);
        boolean bl = this.doCheckUnitCell && !this.isPDB;
        super.applySymmetryAndSetTrajectory();
        if (bl && (this.bondTypes.size() > 0 || this.isMolecular)) {
            this.setBondingAndMolecules();
        }
    }

    private void processDataParameter() {
        this.bondTypes.clear();
        this.tokenizer.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
                this.atomSetCollection.newAtomSet();
            } else {
                this.atomSetCollection.setCollectionName(this.thisDataSetName);
            }
        }
        Logger.debug((String)this.key);
    }

    private String processChemicalInfo(String string) throws Exception {
        if (string.equals("name")) {
            this.chemicalName = this.data = this.tokenizer.fullTrim(this.data);
            if (!this.data.equals("?")) {
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("modelLoadNote", (Object)this.data);
            }
        } else if (string.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.tokenizer.fullTrim(this.data);
        } else if (string.equals("formula")) {
            this.thisFormula = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (Logger.debugging) {
            Logger.debug((String)(string + " = " + this.data));
        }
        return this.data;
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        this.setSpaceGroupName((this.key.equals("_symmetry_space_group_name_H-M") ? "HM:" : "Hall:") + this.data);
    }

    private void processCellParameter() throws Exception {
        int n = cellParamNames.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, cellParamNames[n])) continue;
            this.setUnitCellItem(n, this.parseFloat(this.data));
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float f = this.parseFloat(this.data);
        if (Float.isNaN(f)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, f);
            return;
        }
    }

    private boolean getData() throws Exception {
        this.key = this.tokenizer.getTokenPeeked();
        this.data = this.tokenizer.getNextToken();
        if (Logger.debugging) {
            Logger.debug((String)(this.key + " " + this.data));
        }
        if (this.data == null) {
            Logger.warn((String)("CIF ERROR ? end of file; data missing: " + this.key));
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.tokenizer.getTokenPeeked();
        String string = this.tokenizer.peekToken();
        if (string == null) {
            return;
        }
        boolean bl = false;
        if (string.startsWith("_atom_site_") || string.startsWith("_atom_site.") || (bl = string.equals("_chem_comp_atom.comp_id"))) {
            if (!this.processAtomSiteLoopBlock(bl)) {
                return;
            }
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", (Object)this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", (Object)this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", (Object)this.thisFormula);
            return;
        }
        if (string.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp_bond")) {
            this.processLigandBondLoopBlock();
            return;
        }
        if (string.startsWith("_geom_bond")) {
            if (!this.doApplySymmetry) {
                this.isMolecular = true;
                this.doApplySymmetry = true;
                this.latticeCells[0] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[2] = 1;
            }
            if (this.isMolecular) {
                this.processGeomBondLoopBlock();
            } else {
                this.skipLoop();
            }
            return;
        }
        if (string.startsWith("_pdbx_entity_nonpoly")) {
            this.processNonpolyLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp")) {
            this.processChemCompLoopBlock();
            return;
        }
        if (string.startsWith("_struct_conf") && !string.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (string.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (string.startsWith("_symmetry_equiv_pos") || string.startsWith("_space_group_symop")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn((String)"ignoring file-based symmetry operators");
                this.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (string.startsWith("_struct_site")) {
            this.processStructSiteBlock();
            return;
        }
        this.skipLoop();
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            String string = null;
            float f = Float.NaN;
            block7: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        string = this.field;
                        continue block7;
                    }
                    case 1: {
                        f = this.parseFloat(this.field);
                    }
                }
            }
            if (string == null || Float.isNaN(f)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable<String, Float>();
            }
            this.atomTypes.put(string, new Float(f));
        }
    }

    boolean processAtomSiteLoopBlock(boolean bl) throws Exception {
        int n = -1;
        boolean bl2 = false;
        this.parseLoopParameters(atomFields);
        if (this.fieldOf[55] != -1) {
            this.isPDB = false;
            this.setFractionalCoordinates(false);
        } else if (this.fieldOf[6] != -1 || this.fieldOf[52] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
        } else if (this.fieldOf[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.fieldOf[20] != -1) {
            bl2 = true;
        } else if (this.fieldOf[21] != -1) {
            bl2 = true;
        } else {
            this.skipLoop();
            return false;
        }
        int n2 = -1;
        while (this.tokenizer.getData()) {
            Atom atom = new Atom();
            block31: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block31;
                    }
                    case 0: 
                    case 50: {
                        char c;
                        String string = this.field.length() < 2 ? this.field : (Atom.isValidElementSymbol((char)this.firstChar, (char)(c = Character.toLowerCase(this.field.charAt(1)))) ? "" + this.firstChar + c : "" + this.firstChar);
                        atom.elementSymbol = string;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(this.field)) continue block31;
                        float f = this.atomTypes.get(this.field).floatValue();
                        atom.formalCharge = (int)((double)f + (f < 0.0f ? -0.5 : 0.5));
                        if (!((double)Math.abs((float)atom.formalCharge - f) > 0.1) || !Logger.debugging) continue block31;
                        Logger.debug((String)("CIF charge on " + this.field + " was " + f + "; rounded to " + atom.formalCharge));
                        continue block31;
                    }
                    case 1: 
                    case 2: 
                    case 49: {
                        atom.atomName = this.field;
                        continue block31;
                    }
                    case 55: {
                        float f = this.parseFloat(this.field);
                        if (Float.isNaN(f)) continue block31;
                        atom.x = f;
                        continue block31;
                    }
                    case 56: {
                        float f = this.parseFloat(this.field);
                        if (Float.isNaN(f)) continue block31;
                        atom.y = f;
                        continue block31;
                    }
                    case 57: {
                        float f = this.parseFloat(this.field);
                        if (Float.isNaN(f)) continue block31;
                        atom.z = f;
                        continue block31;
                    }
                    case 3: 
                    case 6: 
                    case 52: {
                        atom.x = this.parseFloat(this.field);
                        continue block31;
                    }
                    case 4: 
                    case 7: 
                    case 53: {
                        atom.y = this.parseFloat(this.field);
                        continue block31;
                    }
                    case 5: 
                    case 8: 
                    case 54: {
                        atom.z = this.parseFloat(this.field);
                        continue block31;
                    }
                    case 51: {
                        atom.formalCharge = this.parseInt(this.field);
                        continue block31;
                    }
                    case 9: {
                        float f = this.parseFloat(this.field);
                        if (Float.isNaN(f)) continue block31;
                        atom.occupancy = (int)(f * 100.0f);
                        continue block31;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloat(this.field) * (this.isPDB ? 1.0f : 100.0f);
                        continue block31;
                    }
                    case 11: 
                    case 48: {
                        atom.group3 = this.field;
                        continue block31;
                    }
                    case 12: {
                        if (this.field.length() > 1) {
                            Logger.warn((String)("Don't know how to deal with chains more than 1 char: " + this.field));
                        }
                        atom.chainID = this.firstChar;
                        continue block31;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseInt(this.field);
                        continue block31;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        continue block31;
                    }
                    case 15: {
                        atom.alternateLocationID = this.firstChar;
                        continue block31;
                    }
                    case 58: {
                        this.disorderAssembly = this.field;
                        continue block31;
                    }
                    case 19: {
                        if (this.firstChar == '-' && this.field.length() > 1) {
                            atom.alternateLocationID = this.field.charAt(1);
                            atom.ignoreSymmetry = true;
                            continue block31;
                        }
                        atom.alternateLocationID = this.firstChar;
                        continue block31;
                    }
                    case 16: {
                        this.isPDB = true;
                        if (!"HETATM".equals(this.field)) continue block31;
                        atom.isHetero = true;
                        continue block31;
                    }
                    case 17: {
                        int n3 = this.parseInt(this.field);
                        if (n3 == n) continue block31;
                        this.atomSetCollection.newAtomSet();
                        n = n3;
                        continue block31;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) continue block31;
                        atom.x = Float.NaN;
                        continue block31;
                    }
                    case 47: {
                        int n4;
                        if (!this.field.equalsIgnoreCase("Uiso") || (n4 = this.fieldOf[34]) == -1) continue block31;
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
                        }
                        fArray[7] = this.parseFloat(this.tokenizer.loopData[n4]);
                        continue block31;
                    }
                    case 20: {
                        n2 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        if (n2 < 0) continue block31;
                        atom = this.atomSetCollection.getAtom(n2);
                        continue block31;
                    }
                    case 21: {
                        atom = this.atomSetCollection.getAtom(++n2);
                        continue block31;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
                        }
                        int n4 = (this.propertyOf[i] - 22) % 6;
                        fArray[n4] = this.parseFloat(this.field);
                        continue block31;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 4);
                        }
                        int n5 = (this.propertyOf[i] - 35) % 6;
                        fArray[n5] = this.parseFloat(this.field);
                        continue block31;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 0);
                        }
                        int n6 = (this.propertyOf[i] - 41) % 6;
                        fArray[n6] = this.parseFloat(this.field);
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn((String)("atom " + atom.atomName + " has invalid/unknown coordinates"));
                continue;
            }
            if (bl2 || !this.filterAtom(atom, n2)) continue;
            this.setAtomCoord(atom);
            this.atomSetCollection.addAtomWithMappedName(atom);
            if (!atom.isHetero || this.htHetero == null) continue;
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
        if (this.isPDB) {
            this.setIsPDB();
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isCIF", (Object)Boolean.TRUE);
        return true;
    }

    protected boolean filterAtom(Atom atom, int n) {
        if (!super.filterAtom(atom, n)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (!this.disorderAssembly.equals(this.lastDisorderAssembly)) {
                this.lastDisorderAssembly = this.disorderAssembly;
                this.lastAltLoc = '\u0000';
                this.conformationIndex = this.configurationPtr;
            }
            if (atom.alternateLocationID != '\u0000') {
                if (this.conformationIndex >= 0 && atom.alternateLocationID != this.lastAltLoc) {
                    this.lastAltLoc = atom.alternateLocationID;
                    --this.conformationIndex;
                }
                if (this.conformationIndex != 0) {
                    Logger.info((String)("ignoring " + atom.atomName));
                    return false;
                }
            }
        }
        return true;
    }

    private void processLigandBondLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn((String)("?que? missing _chem_comp_bond property:" + n));
            this.skipLoop();
            return;
        }
        n = 0;
        boolean bl = false;
        while (this.tokenizer.getData()) {
            int n2 = -1;
            int n3 = -1;
            n = 0;
            bl = false;
            block12: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        n2 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        continue block12;
                    }
                    case 1: {
                        n3 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        continue block12;
                    }
                    case 3: {
                        bl = this.field.charAt(0) == 'Y';
                        continue block12;
                    }
                    case 2: {
                        n = 1;
                        if (this.field.equals("SING")) {
                            n = 1;
                            continue block12;
                        }
                        if (this.field.equals("DOUB")) {
                            n = 2;
                            continue block12;
                        }
                        if (this.field.equals("TRIP")) {
                            n = 3;
                            continue block12;
                        }
                        Logger.warn((String)("unknown CIF bond order: " + this.field));
                    }
                }
            }
            if (n2 < 0 || n3 < 0) continue;
            if (bl) {
                switch (n) {
                    case 1: {
                        n = 513;
                        break;
                    }
                    case 2: {
                        n = 514;
                    }
                }
            }
            this.atomSetCollection.addNewBond(n2, n3, n);
        }
    }

    private void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn((String)("?que? missing _geom_bond property:" + n));
            this.skipLoop();
            return;
        }
        String string = null;
        String string2 = null;
        while (this.tokenizer.getData()) {
            int n2 = -1;
            int n3 = -1;
            float f = 0.0f;
            float f2 = 0.0f;
            block8: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block8;
                    }
                    case 0: {
                        string = this.field;
                        n2 = this.atomSetCollection.getAtomIndexFromName(string);
                        continue block8;
                    }
                    case 1: {
                        string2 = this.field;
                        n3 = this.atomSetCollection.getAtomIndexFromName(string2);
                        continue block8;
                    }
                    case 2: {
                        f = this.parseFloat(this.field);
                        int n4 = this.field.indexOf(40);
                        if (n4 >= 0) {
                            char[] cArray = this.field.toCharArray();
                            String string3 = this.field.substring(n4 + 1, this.field.length() - 1);
                            int n5 = string3.length();
                            int n6 = n4;
                            while (--n6 >= 0) {
                                if (cArray[n6] == '.') {
                                    --n6;
                                }
                                cArray[n6] = --n5 < 0 ? 48 : (int)string3.charAt(n5);
                            }
                            f2 = this.parseFloat(String.valueOf(cArray));
                            if (!Float.isNaN(f2)) continue block8;
                            Logger.info((String)("error reading uncertainty for " + this.line));
                            f2 = 0.015f;
                            continue block8;
                        }
                        f2 = 0.015f;
                    }
                }
            }
            if (n2 < 0 || n3 < 0 || !(f > 0.0f)) continue;
            this.bondTypes.add(new Object[]{string, string2, new Float(f), new Float(f2)});
        }
    }

    private void processNonpolyData() {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int n = nonpolyFields.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, nonpolyFields[n])) continue;
            this.hetatmData[n] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    private void processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) continue;
            this.addHetero(string, string2);
        }
    }

    private void processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) {
                return;
            }
            this.addHetero(string, string2);
        }
    }

    private void addHetero(String string, String string2) {
        if (!JmolAdapter.isHetero((String)string)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        this.htHetero.put(string, string2);
        if (Logger.debugging) {
            Logger.debug((String)("hetero: " + string + " = " + string2));
        }
    }

    private void processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn((String)("?que? missing _struct_conf property:" + n));
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(EnumStructure.HELIX);
            block15: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block15;
                    }
                    case 0: {
                        if (this.field.startsWith("TURN")) {
                            structure.structureType = structure.substructureType = EnumStructure.TURN;
                            continue block15;
                        }
                        if (this.field.startsWith("HELX")) continue block15;
                        structure.structureType = structure.substructureType = EnumStructure.NONE;
                        continue block15;
                    }
                    case 1: {
                        structure.startChainID = this.firstChar;
                        continue block15;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(this.field);
                        continue block15;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 4: {
                        structure.endChainID = this.firstChar;
                        continue block15;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(this.field);
                        continue block15;
                    }
                    case 9: {
                        structure.substructureType = Structure.getHelixType((int)this.parseInt(this.field));
                        continue block15;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 7: {
                        structure.structureID = this.field;
                        continue block15;
                    }
                    case 8: {
                        structure.serialID = this.parseInt(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn((String)("?que? missing _struct_conf property:" + n));
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(EnumStructure.SHEET);
            block12: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 1: {
                        structure.startChainID = this.firstChar;
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(this.field);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = this.firstChar;
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(this.field);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 0: {
                        structure.strandCount = 1;
                        structure.structureID = this.field;
                        continue block12;
                    }
                    case 7: {
                        structure.serialID = this.parseInt(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSiteBlock() throws Exception {
        this.parseLoopParameters(structSiteRangeFields);
        int n = 3;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn((String)("?que? missing _struct_site property:" + n));
            this.skipLoop();
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Map<String, Object> map = null;
        this.htSites = new Hashtable<String, Map<String, Object>>();
        while (this.tokenizer.getData()) {
            for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        if (string6 != "") {
                            String string7 = (String)map.get("groups");
                            string7 = string7 + (string7.length() == 0 ? "" : ",") + string6;
                            string6 = "";
                            map.put("groups", string7);
                        }
                        if ((map = this.htSites.get(string = this.field)) == null) {
                            map = new Hashtable<String, Object>();
                            map.put("groups", "");
                            this.htSites.put(string, map);
                        }
                        string2 = "";
                        string3 = "";
                        string4 = "";
                        string5 = "";
                        break;
                    }
                    case 1: {
                        string5 = this.field;
                        break;
                    }
                    case 2: {
                        string4 = this.field;
                        break;
                    }
                    case 3: {
                        string2 = this.field;
                        break;
                    }
                    case 4: {
                        string3 = this.field;
                    }
                }
                if (string2 == "" || string5 == "") continue;
                string6 = "[" + string5 + "]" + string2 + (string3.length() > 0 ? "^" + string3 : "") + (string4.length() > 0 ? ":" + string4 : "");
            }
        }
        if (string6 != "") {
            String string8 = (String)map.get("groups");
            string8 = string8 + (string8.length() == 0 ? "" : ",") + string6;
            string6 = "";
            map.put("groups", string8);
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int n = 0;
        int n2 = this.propertyCount;
        while (--n2 >= 0) {
            if (this.fieldOf[n2] == -1) continue;
            ++n;
        }
        if (n != 1) {
            Logger.warn((String)"?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            for (n2 = 0; n2 < this.tokenizer.fieldCount; ++n2) {
                switch (this.fieldProperty(n2)) {
                    case 0: 
                    case 1: {
                        this.setSymmetryOperator(this.field);
                    }
                }
            }
        }
    }

    private int fieldProperty(int n) {
        this.field = this.tokenizer.loopData[n];
        return this.field.length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.propertyOf[n] : -1;
    }

    private void parseLoopParameters(String[] stringArray) throws Exception {
        this.tokenizer.fieldCount = 0;
        int n = stringArray.length;
        while (--n >= 0) {
            this.fieldOf[n] = -1;
        }
        this.propertyCount = stringArray.length;
        while (true) {
            String string;
            if ((string = this.tokenizer.peekToken()) == null) {
                this.tokenizer.fieldCount = 0;
                break;
            }
            if (string.charAt(0) != '_') break;
            this.tokenizer.getTokenPeeked();
            this.propertyOf[this.tokenizer.fieldCount] = -1;
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (!CifReader.isMatch(string, stringArray[n2])) continue;
                this.propertyOf[this.tokenizer.fieldCount] = n2;
                this.fieldOf[n2] = (byte)this.tokenizer.fieldCount;
                break;
            }
            ++this.tokenizer.fieldCount;
        }
        if (this.tokenizer.fieldCount > 0) {
            this.tokenizer.loopData = new String[this.tokenizer.fieldCount];
        }
    }

    public String readLine() throws Exception {
        super.readLine();
        if (this.line.indexOf("#jmolscript:") >= 0) {
            this.checkLineForScript();
        }
        return this.line;
    }

    private void disableField(int n) {
        byte by = this.fieldOf[n];
        if (by != -1) {
            this.propertyOf[by] = -1;
        }
    }

    private void skipLoop() throws Exception {
        String string;
        while ((string = this.tokenizer.peekToken()) != null && string.charAt(0) == '_') {
            string = this.tokenizer.getTokenPeeked();
        }
        while (this.tokenizer.getNextDataToken() != null) {
        }
    }

    private static boolean isMatch(String string, String string2) {
        int n = string.length();
        if (string2.length() != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = string2.charAt(n2)) || (c2 == '_' || c2 == '.') && (c == '_' || c == '.')) continue;
            if (c2 <= 'Z' && c2 >= 'A') {
                c2 = (char)(c2 + 32);
            } else if (c <= 'Z' && c >= 'A') {
                c = (char)(c + 32);
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    private void setBondingAndMolecules() {
        int n;
        int n2;
        Logger.info((String)("CIF creating molecule " + (this.bondTypes.size() > 0 ? " using GEOM_BOND records" : "")));
        this.atoms = this.atomSetCollection.getAtoms();
        this.firstAtom = this.atomSetCollection.getLastAtomSetAtomIndex();
        int n3 = this.atomSetCollection.getLastAtomSetAtomCount();
        this.atomCount = this.firstAtom + n3;
        this.bsSets = new BitSet[n3];
        this.symmetry = this.atomSetCollection.getSymmetry();
        for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
            n = this.atomSetCollection.getAtomIndexFromName(this.atoms[n2].atomName) - this.firstAtom;
            if (this.bsSets[n] == null) {
                this.bsSets[n] = new BitSet();
            }
            this.bsSets[n].set(n2 - this.firstAtom);
        }
        if (this.isMolecular) {
            this.atomRadius = new float[this.atomCount];
            for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
                int n4;
                this.atoms[n2].elementNumber = JmolAdapter.getElementNumber((String)this.atoms[n2].getElementSymbol());
                n = this.atoms[n2].elementNumber;
                int n5 = n4 = this.atoms[n2].formalCharge == Integer.MIN_VALUE ? 0 : this.atoms[n2].formalCharge;
                if (n <= 0) continue;
                this.atomRadius[n2] = JmolAdapter.getBondingRadiusFloat((short)n, (int)n4);
            }
            this.bsConnected = new BitSet[this.atomCount];
            for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
                this.bsConnected[n2] = new BitSet();
            }
            this.bsMolecule = new BitSet();
            this.bsExclude = new BitSet();
        }
        n2 = 1;
        while (this.createBonds(n2 != 0)) {
            n2 = 0;
        }
        if (this.isMolecular) {
            if (this.atomSetCollection.bsAtoms == null) {
                this.atomSetCollection.bsAtoms = new BitSet();
            }
            this.atomSetCollection.bsAtoms.clear(this.firstAtom, this.atomCount);
            this.atomSetCollection.bsAtoms.or(this.bsMolecule);
            this.atomSetCollection.bsAtoms.andNot(this.bsExclude);
            for (n = this.firstAtom; n < this.atomCount; ++n) {
                if (this.atomSetCollection.bsAtoms.get(n)) {
                    this.symmetry.toCartesian((Point3f)this.atoms[n], true);
                    continue;
                }
                if (!Logger.debugging) continue;
                Logger.info((String)(this.molecularType + " removing " + n + " " + this.atoms[n].atomName + " " + this.atoms[n]));
            }
            this.atomSetCollection.setAtomSetAuxiliaryInfo("notionalUnitcell", null);
            if (this.nMolecular++ == this.atomSetCollection.getCurrentAtomSetIndex()) {
                this.atomSetCollection.clearGlobalBoolean(0);
                this.atomSetCollection.clearGlobalBoolean(1);
                this.atomSetCollection.clearGlobalBoolean(2);
            }
        }
        if (this.bondTypes.size() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hasBonds", (Object)Boolean.TRUE);
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("fileHasUnitCell", (Object)Boolean.TRUE);
        this.bondTypes.clear();
        this.atomRadius = null;
        this.bsSets = null;
        this.bsConnected = null;
        this.bsMolecule = null;
        this.bsExclude = null;
    }

    private boolean createBonds(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.bondTypes.size();
        while (--n4 >= 0) {
            Object[] objectArray = this.bondTypes.get(n4);
            float f = ((Float)objectArray[2]).floatValue();
            float f2 = ((Float)objectArray[3]).floatValue();
            n3 = this.atomSetCollection.getAtomIndexFromName((String)objectArray[0]);
            n2 = this.atomSetCollection.getAtomIndexFromName((String)objectArray[1]);
            BitSet bitSet = this.bsSets[n3 - this.firstAtom];
            BitSet bitSet2 = this.bsSets[n2 - this.firstAtom];
            if (bitSet == null || bitSet2 == null) continue;
            int n5 = bitSet.nextSetBit(0);
            while (n5 >= 0) {
                n = bitSet2.nextSetBit(0);
                while (n >= 0) {
                    if (!(this.isMolecular && this.bsConnected[n5 + this.firstAtom].get(n) || !this.symmetry.checkDistance((Point3f)this.atoms[n5 + this.firstAtom], (Point3f)this.atoms[n + this.firstAtom], f, f2, 0, 0, 0, this.ptOffset))) {
                        this.addNewBond(n5 + this.firstAtom, n + this.firstAtom);
                    }
                    n = bitSet2.nextSetBit(n + 1);
                }
                n5 = bitSet.nextSetBit(n5 + 1);
            }
        }
        if (this.bondTypes.size() > 0) {
            for (n4 = this.firstAtom; n4 < this.atomCount; ++n4) {
                if (this.atoms[n4].elementNumber != 1) continue;
                boolean bl2 = this.atoms[n4].alternateLocationID != '\u0000';
                for (int i = this.firstAtom; i < this.atomCount; ++i) {
                    if (i == n4 || this.atoms[i].elementNumber == 1 || bl2 && this.atoms[i].alternateLocationID != '\u0000' && this.atoms[i].alternateLocationID != this.atoms[n4].alternateLocationID || this.bsConnected[n4].get(i) || !this.symmetry.checkDistance((Point3f)this.atoms[n4], (Point3f)this.atoms[i], 1.1f, 0.0f, 0, 0, 0, this.ptOffset)) continue;
                    this.addNewBond(n4, i);
                }
            }
        }
        if (!this.isMolecular) {
            return false;
        }
        if (bl) {
            for (n4 = this.firstAtom; n4 < this.atomCount; ++n4) {
                if (this.atoms[n4].atomSite + this.firstAtom != n4 || this.bsMolecule.get(n4)) continue;
                this.setBs(this.atoms, n4, this.bsConnected, this.bsMolecule);
            }
        }
        float f = this.viewer.getBondTolerance();
        BitSet bitSet = new BitSet();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        n3 = 2;
        for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
            if (this.bsMolecule.get(n2) || this.bsExclude.get(n2)) continue;
            int n6 = this.bsMolecule.nextSetBit(0);
            while (n6 >= 0) {
                if (this.symmetry.checkDistance((Point3f)this.atoms[n6], (Point3f)this.atoms[n2], this.atomRadius[n2] + this.atomRadius[n6] + f, 0.0f, n3, n3, n3, this.ptOffset)) {
                    this.setBs(this.atoms, n2, this.bsConnected, bitSet);
                    int n7 = bitSet.nextSetBit(0);
                    while (n7 >= 0) {
                        this.atoms[n7].add((Tuple3f)this.ptOffset);
                        point3f.set((Tuple3f)this.atoms[n7]);
                        this.symmetry.toCartesian(point3f, true);
                        BitSet bitSet3 = this.bsSets[this.atomSetCollection.getAtomIndexFromName(this.atoms[n7].atomName) - this.firstAtom];
                        if (bitSet3 != null) {
                            n = bitSet3.nextSetBit(0);
                            while (n >= 0) {
                                if (n + this.firstAtom != n7) {
                                    point3f2.set((Tuple3f)this.atoms[n + this.firstAtom]);
                                    this.symmetry.toCartesian(point3f2, true);
                                    if (point3f2.distance(point3f) < 0.1f) {
                                        this.bsExclude.set(n7);
                                        break;
                                    }
                                }
                                n = bitSet3.nextSetBit(n + 1);
                            }
                        }
                        this.bsMolecule.set(n7);
                        n7 = bitSet.nextSetBit(n7 + 1);
                    }
                    return true;
                }
                n6 = this.bsMolecule.nextSetBit(n6 + 1);
            }
        }
        return false;
    }

    private void addNewBond(int n, int n2) {
        this.atomSetCollection.addNewBond(n, n2);
        if (!this.isMolecular) {
            return;
        }
        this.bsConnected[n].set(n2);
        this.bsConnected[n2].set(n);
    }

    private void setBs(Atom[] atomArray, int n, BitSet[] bitSetArray, BitSet bitSet) {
        BitSet bitSet2 = bitSetArray[n];
        bitSet.set(n);
        int n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            if (!bitSet.get(n2)) {
                this.setBs(atomArray, n2, bitSetArray, bitSet);
            }
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
    }
}

