/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.Map;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlQEReader
extends XmlReader {
    int atomCount;
    private float a;
    private float b;
    private float c;
    float alpha;
    float beta;
    float gamma;

    XmlQEReader() {
    }

    @Override
    protected String[] getImplementedAttributes() {
        return new String[]{"SPECIES", "TAU"};
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, Object object, XmlReader.JmolXmlHandler jmolXmlHandler) {
        xmlReader.doProcessLines = true;
        super.processXml(xmlReader, atomSetCollection, bufferedReader, object, jmolXmlHandler);
    }

    @Override
    public void processStartElement(String string, String string2, String string3, Map<String, String> map) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlqe: start " + string2));
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("NUMBER_OF_ATOMS".equals(string2) || "CELL_DIMENSIONS".equals(string2) || "AT".equals(string2)) {
            this.keepChars = true;
            return;
        }
        if (string2.startsWith("ATOM.")) {
            float[] fArray = XmlQEReader.getTokensFloat((String)map.get("TAU"), null, (int)3);
            this.atom = this.atomSetCollection.addNewAtom();
            this.atom.elementSymbol = map.get("SPECIES").trim();
            this.parent.setAtomCoord(this.atom, fArray[0] * 0.5291772f, fArray[1] * 0.5291772f, fArray[2] * 0.5291772f);
        }
        if ("structure".equals(string2)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.atomSetCollection.setDoFixPeriodic();
            this.atomSetCollection.newAtomSet();
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
    }

    @Override
    public void processEndElement(String string, String string2, String string3) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlqe: end " + string2));
        }
        if (this.parent.doProcessLines) {
            if ("NUMBER_OF_ATOMS".equals(string2)) {
                this.atomCount = this.parseInt(this.chars);
            } else if ("CELL_DIMENSIONS".equals(string2)) {
                this.parent.setFractionalCoordinates(true);
                float[] fArray = XmlQEReader.getTokensFloat((String)this.chars, null, (int)6);
                this.a = fArray[0];
                this.b = fArray[1] == 0.0f ? this.a : fArray[1];
                this.c = fArray[2] == 0.0f ? this.a : fArray[2];
                this.alpha = fArray[3] == 0.0f ? 90.0f : fArray[3];
                this.beta = fArray[4] == 0.0f ? 90.0f : fArray[4];
                this.gamma = fArray[5] == 0.0f ? 90.0f : fArray[5];
            } else if ("AT".equals(string2)) {
                float[] fArray = XmlQEReader.getTokensFloat((String)this.chars, null, (int)9);
                for (int i = 0; i < 9; i += 3) {
                    int n = i;
                    fArray[n] = fArray[n] * this.a;
                    int n2 = i + 1;
                    fArray[n2] = fArray[n2] * this.b;
                    int n3 = i + 2;
                    fArray[n3] = fArray[n3] * this.c;
                }
                this.parent.addPrimitiveLatticeVector(0, fArray, 0);
                this.parent.addPrimitiveLatticeVector(1, fArray, 3);
                this.parent.addPrimitiveLatticeVector(2, fArray, 6);
            } else if ("GEOMETRY_INFO".equals(string2)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.chars = null;
        this.keepChars = false;
    }
}

