/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Map;
import org.jmol.adapter.readers.xml.XmlCmlReader;
import org.jmol.adapter.readers.xml.XmlReader;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMolproReader
extends XmlCmlReader {
    XmlMolproReader() {
    }

    @Override
    protected String[] getImplementedAttributes() {
        return new String[]{"id", "length", "type", "x3", "y3", "z3", "elementType", "name", "groups", "cartesianLength", "primitives", "minL", "maxL", "angular", "contractions", "occupation", "energy", "symmetryID", "wavenumber", "units"};
    }

    public void processStartElement2(String string, Map<String, String> map) {
        if (string.equals("normalCoordinate")) {
            this.keepChars = false;
            if (!this.parent.doGetVibration(++this.vibrationNumber)) {
                return;
            }
            try {
                this.atomSetCollection.cloneLastAtomSet();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.atomSetCollection.errorMessage = "Error processing normalCoordinate: " + exception.getMessage();
                this.vibrationNumber = 0;
                return;
            }
            if (map.containsKey("wavenumber")) {
                String string2 = map.get("wavenumber");
                String string3 = "cm^-1";
                if (map.containsKey("units") && (string3 = map.get("units")).startsWith("inverseCent")) {
                    string3 = "cm^-1";
                }
                this.atomSetCollection.setAtomSetFrequency(null, null, string2, string3);
                this.keepChars = true;
            }
            return;
        }
        if (string.equals("vibrations")) {
            this.vibrationNumber = 0;
            return;
        }
    }

    public void processEndElement2(String string) {
        if (string.equals("normalCoordinate")) {
            if (!this.keepChars) {
                return;
            }
            int n = this.atomSetCollection.getLastAtomSetAtomCount();
            int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
            this.tokens = XmlMolproReader.getTokens((String)this.chars);
            int n3 = this.tokens.length - n * 3;
            for (int i = 0; i < n; ++i) {
                this.atomSetCollection.addVibrationVector(i + n2, this.parseFloat(this.tokens[n3++]), this.parseFloat(this.tokens[n3++]), this.parseFloat(this.tokens[n3++]));
            }
        }
    }

    @Override
    protected XmlReader.JmolXmlHandler getHandler(Object object) {
        return new MolproHandler(object);
    }

    class MolproHandler
    extends XmlReader.JmolXmlHandler {
        public MolproHandler(Object object) {
            super(XmlMolproReader.this, object);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            super.startElement(string, string2, string3, attributes);
            XmlMolproReader.this.processStartElement2(string2, this.atts);
        }

        public void endElement(String string, String string2, String string3) {
            XmlMolproReader.this.processEndElement2(string2);
            super.endElement(string, string2, string3);
        }
    }
}

