/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import jspecview.util.TextFormat;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class JcampdxReader
extends MolReader {
    private String modelID;
    private AtomSetCollection models;
    private String modelIdList = "";
    private List<String> peakData = new ArrayList<String>();
    private String lastModel = "";
    private int selectedModel;
    private int[] peakIndex;
    private String peakFilePath;
    private String allTypes;

    public void initializeReader() throws Exception {
        if (this.isTrajectory) {
            Logger.warn((String)"TRAJECTORY keyword ignored");
            this.isTrajectory = false;
        }
        if (this.reverseModels) {
            Logger.warn((String)"REVERSE keyword ignored");
            this.reverseModels = false;
        }
        this.selectedModel = this.desiredModelNumber;
        this.desiredModelNumber = Integer.MIN_VALUE;
        this.peakFilePath = Escape.escape((String)this.filePath);
        this.htParams.remove("modelNumber");
        if (this.htParams.containsKey("zipSet")) {
            this.peakIndex = (int[])this.htParams.get("peakIndex");
            if (this.peakIndex == null) {
                this.peakIndex = new int[1];
                this.htParams.put("peakIndex", this.peakIndex);
            }
            if (!this.htParams.containsKey("subFileName")) {
                this.peakFilePath = Escape.escape((String)TextFormat.split((String)this.filePath, (char)'|')[0]);
            }
        } else {
            this.peakIndex = new int[1];
        }
        if (!this.checkFilter("NOSYNC")) {
            this.addJmolScript("sync on");
        }
    }

    public boolean checkLine() throws Exception {
        int n = this.line.indexOf("=");
        if (n < 0 || !this.line.startsWith("##")) {
            return true;
        }
        String string = this.line.substring(0, n).trim();
        if (string.equals("##$MODELS")) {
            return this.readModels();
        }
        if (string.equals("##$PEAKS")) {
            return this.readPeaks();
        }
        return true;
    }

    public void finalizeReader() throws Exception {
        this.processPeakData();
        super.finalizeReader();
    }

    private int findModelById(String string) {
        int n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            if (!string.equals(this.atomSetCollection.getAtomSetAuxiliaryInfo(n, "modelID"))) continue;
            return n;
        }
        return -1;
    }

    private boolean readModels() throws Exception {
        if (this.line.indexOf("<Models") < 0) {
            this.discardLinesUntilContains("<Models", "##");
            if (this.line.indexOf("<Models") < 0) {
                return false;
            }
        }
        this.models = null;
        this.line = "";
        this.modelID = "";
        boolean bl = true;
        while (true) {
            int n = this.atomSetCollection.getCurrentAtomSetIndex();
            this.discardLinesUntilNonBlank();
            if (this.line == null || !this.line.contains("<ModelData")) break;
            this.models = this.getModelAtomSetCollection();
            if (this.models != null) {
                this.atomSetCollection.appendAtomSetCollection(-1, this.models);
            }
            this.updateModelIDs(n, bl);
            bl = false;
        }
        return true;
    }

    private void updateModelIDs(int n, boolean bl) {
        int n2 = this.atomSetCollection.getAtomSetCount();
        if (bl && n2 == n + 2) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("modelID", (Object)this.modelID);
            return;
        }
        int n3 = 0;
        int n4 = n;
        while (++n4 < n2) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("modelID", (Object)(this.modelID + "." + ++n3), n4);
        }
    }

    private static String getAttribute(String string, String string2) {
        String string3 = Parser.getQuotedAttribute((String)string, (String)string2);
        return string3 == null ? "" : string3;
    }

    private AtomSetCollection getModelAtomSetCollection() throws Exception {
        int n;
        int n2;
        this.lastModel = this.modelID;
        this.modelID = JcampdxReader.getAttribute(this.line, "id");
        String string = ";" + this.modelID + ";";
        if (this.modelIdList.indexOf(string) >= 0) {
            this.discardLinesUntilContains("</ModelData>");
            return null;
        }
        this.modelIdList = this.modelIdList + string;
        String string2 = JcampdxReader.getAttribute(this.line, "baseModel");
        String string3 = JcampdxReader.getAttribute(this.line, "type").toLowerCase();
        float f = Parser.parseFloat((String)JcampdxReader.getAttribute(this.line, "vibrationScale"));
        if (string3.equals("xyzvib")) {
            string3 = "xyz";
        } else if (string3.length() == 0) {
            string3 = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && !this.line.contains("</ModelData>")) {
            stringBuffer.append(this.line).append('\n');
        }
        String string4 = stringBuffer.toString();
        Object object = SmarterJmolAdapter.staticGetAtomSetCollectionReader((String)this.filePath, (String)string3, (BufferedReader)new BufferedReader(new StringReader(string4)), (Map)this.htParams);
        if (object instanceof String) {
            Logger.warn((String)("" + object));
            return null;
        }
        if ((object = SmarterJmolAdapter.staticGetAtomSetCollection((AtomSetCollectionReader)((AtomSetCollectionReader)object))) instanceof String) {
            Logger.warn((String)("" + object));
            return null;
        }
        AtomSetCollection atomSetCollection = (AtomSetCollection)object;
        if (string2.length() == 0) {
            string2 = this.lastModel;
        }
        if (string2.length() != 0 && (n2 = this.findModelById(string2)) >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("jdxModelID", (Object)string2, n2);
            n = atomSetCollection.getAtomSetCount();
            while (--n >= 0) {
                atomSetCollection.setAtomSetAuxiliaryInfo("jdxBaseModel", (Object)string2, n);
            }
            if (atomSetCollection.getBondCount() == 0) {
                this.setBonding(atomSetCollection, n2);
            }
        }
        if (!Float.isNaN(f)) {
            Logger.info((String)("jdx applying vibrationScale of " + f + " to " + atomSetCollection.getAtomCount() + " atoms"));
            Atom[] atomArray = atomSetCollection.getAtoms();
            n = atomSetCollection.getAtomCount();
            while (--n >= 0) {
                atomArray[n].scaleVector(f);
            }
        }
        Logger.info((String)("jdx model=" + this.modelID + " type=" + atomSetCollection.getFileTypeName()));
        return atomSetCollection;
    }

    private void setBonding(AtomSetCollection atomSetCollection, int n) {
        int n2;
        int n3 = this.atomSetCollection.getAtomSetAtomCount(n);
        int n4 = atomSetCollection.getAtomCount();
        if (n4 % n3 != 0) {
            Logger.warn((String)("atom count in secondary model (" + n4 + ") is not a multiple of " + n3 + " -- bonding ignored"));
            return;
        }
        Bond[] bondArray = this.atomSetCollection.getBonds();
        int n5 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n5 += this.atomSetCollection.getAtomSetBondCount(n2);
        }
        n2 = n5 + this.atomSetCollection.getAtomSetBondCount(n);
        int n6 = this.atomSetCollection.getAtomSetAtomIndex(n);
        int n7 = atomSetCollection.getAtomSetCount();
        for (int i = 0; i < n7; ++i) {
            int n8 = atomSetCollection.getAtomSetAtomIndex(i) - n6;
            if (atomSetCollection.getAtomSetAtomCount(i) != n3) {
                Logger.warn((String)("atom set atom count in secondary model (" + atomSetCollection.getAtomSetAtomCount(i) + ") is not equal to " + n3 + " -- bonding ignored"));
                return;
            }
            for (int j = n5; j < n2; ++j) {
                atomSetCollection.addNewBond(bondArray[j].atomIndex1 + n8, bondArray[j].atomIndex2 + n8, bondArray[j].order);
            }
        }
    }

    private boolean readPeaks() throws Exception {
        if (this.line.indexOf("<Peaks") < 0) {
            this.discardLinesUntilContains("<Peaks", "##");
        }
        if (this.line.indexOf("<Peaks") < 0) {
            return false;
        }
        String string = JcampdxReader.getAttribute(this.line, "type").toUpperCase();
        if (string.equals("HNMR")) {
            string = "1HNMR";
        } else if (string.equals("CNMR")) {
            string = "13CNMR";
        }
        while (this.readLine() != null && !(this.line = this.line.trim()).startsWith("</Peaks>")) {
            if (!this.line.startsWith("<PeakData")) continue;
            this.peakIndex[0] = this.peakIndex[0] + 1;
            this.peakData.add("<PeakData file=" + this.peakFilePath + " index=\"" + this.peakIndex[0] + "\"" + " type=\"" + string + "\" " + this.line.substring(9).trim());
        }
        return true;
    }

    private void processPeakData() {
        int n;
        if (this.peakData.size() == 0) {
            return;
        }
        BitSet bitSet = new BitSet();
        int n2 = this.peakData.size();
        boolean bl = n2 > 0;
        for (n = 0; n < n2; ++n) {
            String string;
            this.line = this.peakData.get(n);
            String string2 = JcampdxReader.getAttribute(this.line, "type");
            this.modelID = JcampdxReader.getAttribute(this.line, "model");
            int n3 = this.findModelById(this.modelID);
            if (n3 < 0) {
                Logger.warn((String)("cannot find model " + this.modelID + " required for " + this.line));
                continue;
            }
            this.addType(n3, string2);
            String string3 = string2 + ": " + JcampdxReader.getAttribute(this.line, "title");
            String string4 = "jdxAtomSelect_" + JcampdxReader.getAttribute(this.line, "type");
            bitSet.set(n3);
            if (JcampdxReader.getAttribute(this.line, "atoms").length() != 0) {
                ArrayList<String> arrayList = (ArrayList<String>)this.atomSetCollection.getAtomSetAuxiliaryInfo(n3, string4);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    this.atomSetCollection.setAtomSetAuxiliaryInfo(string4, arrayList, n3);
                }
                arrayList.add(this.line);
                string = string2 + ": ";
            } else if (this.atomSetCollection.getAtomSetAuxiliaryInfo(n3, "jdxModelSelect") == null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("name", (Object)string3, n3);
                this.atomSetCollection.setAtomSetAuxiliaryInfo("jdxModelSelect", (Object)this.line, n3);
                string = "model: ";
            } else {
                string = "ignored: ";
            }
            Logger.info((String)(string + this.line));
        }
        n = n2 = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.modelID = (String)this.atomSetCollection.getAtomSetAuxiliaryInfo(n, "modelID");
            if (!bl || bitSet.get(n) || this.modelID.indexOf(".") < 0) continue;
            this.atomSetCollection.removeAtomSet(n);
            --n2;
        }
        if (this.selectedModel == Integer.MIN_VALUE) {
            if (this.allTypes != null) {
                this.appendLoadNote(this.allTypes);
            }
        } else {
            if (this.selectedModel == 0) {
                this.selectedModel = n2 - 1;
            }
            n = this.atomSetCollection.getAtomSetCount();
            while (--n >= 0) {
                if (n + 1 == this.selectedModel) continue;
                this.atomSetCollection.removeAtomSet(n);
            }
            if (n2 > 0) {
                this.appendLoadNote((String)this.atomSetCollection.getAtomSetAuxiliaryInfo(0, "name"));
            }
        }
        n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.atomSetCollection.setAtomSetNumber(n, n + 1);
        }
        this.atomSetCollection.centralize();
    }

    private void addType(int n, String string) {
        String string2 = this.addType((String)this.atomSetCollection.getAtomSetAuxiliaryInfo(n, "spectrumTypes"), string);
        if (string2 == null) {
            return;
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("spectrumTypes", (Object)string2, n);
        String string3 = this.addType(this.allTypes, string);
        if (string3 != null) {
            this.allTypes = string3;
        }
    }

    private String addType(String string, String string2) {
        if (string != null && string.contains(string2)) {
            return null;
        }
        string = string == null ? "" : string + ",";
        return string + string2;
    }
}

