/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

class MsmsReader
extends PmeshReader {
    private String fileName;

    MsmsReader(SurfaceGenerator surfaceGenerator, String string, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.fileName = string;
        this.type = "msms";
        this.onePerLine = true;
        this.fixedCount = 3;
        this.vertexBase = 1;
        this.setHeader();
    }

    protected boolean readVertices() throws Exception {
        this.skipHeader();
        return super.readVertices();
    }

    protected boolean readPolygons() throws Exception {
        this.br.close();
        this.fileName = TextFormat.simpleReplace((String)this.fileName, (String)".vert", (String)".face");
        Logger.info((String)("reading from file " + this.fileName));
        try {
            this.br = new BufferedReader(new InputStreamReader(this.sg.getAtomDataServer().getBufferedInputStream(this.fileName)));
        }
        catch (Exception exception) {
            Logger.info((String)("Note: file " + this.fileName + " was not found"));
            this.br = null;
            return true;
        }
        this.sg.addRequiredFile(this.fileName);
        this.skipHeader();
        return super.readPolygons();
    }

    private void skipHeader() throws Exception {
        while (this.readLine() != null && this.line.indexOf("#") >= 0) {
        }
        this.tokens = this.getTokens();
        this.iToken = 0;
    }
}

