/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.server.Group;
import com.sparshui.server.ServerToClientProtocol;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientConnection {
    private ServerToClientProtocol _protocol;
    private Map<Integer, Group> _groups;

    ClientConnection(Socket socket) throws IOException {
        this._protocol = new ServerToClientProtocol(socket);
        this._groups = new Hashtable<Integer, Group>();
    }

    boolean processBirth(TouchPoint touchPoint) throws IOException {
        Group group;
        int n = touchPoint == null ? 0x10000000 : this.getGroupID(touchPoint);
        int n2 = n & 0xF0000000;
        if (n2 != 0) {
            switch (n2) {
                case 0x10000000: {
                    this._groups = new Hashtable<Integer, Group>();
                }
            }
            n &= ~n2;
        }
        if ((group = this.getGroup(n)) != null) {
            touchPoint.setGroup(group);
            return true;
        }
        return false;
    }

    private List<GestureType> getGestures(int n) throws IOException {
        return this._protocol.getGestures(n);
    }

    private int getGroupID(TouchPoint touchPoint) throws IOException {
        return this._protocol.getGroupID(touchPoint);
    }

    private Group getGroup(int n) throws IOException {
        if (n == 0) {
            return null;
        }
        Group group = null;
        Integer n2 = new Integer(n);
        if (this._groups.containsKey(n2)) {
            group = this._groups.get(n2);
        } else {
            List<GestureType> list = this.getGestures(n);
            group = new Group(n, list, this._protocol);
            this._groups.put(n2, group);
        }
        return group;
    }

    public void processError(int n) {
        try {
            this._protocol.processError(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

