/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jsonkiosk;

import com.json.JSONArray;
import com.json.JSONException;
import com.json.JSONObject;
import com.json.JSONTokener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import javax.vecmath.Point3f;
import naga.ConnectionAcceptor;
import naga.NIOServerSocket;
import naga.NIOService;
import naga.NIOSocket;
import naga.ServerSocketObserverAdapter;
import naga.SocketObserver;
import naga.SocketObserverAdapter;
import naga.packetreader.AsciiLinePacketReader;
import naga.packetwriter.RawPacketWriter;
import org.jmol.api.JmolViewer;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;

public class JsonNioService
extends NIOService
implements JsonNioServer {
    protected String myName;
    protected boolean halt;
    protected boolean isPaused;
    protected long latestMoveTime;
    protected int port;
    private Thread thread;
    private Thread serverThread;
    private NIOSocket inSocket;
    protected NIOSocket outSocket;
    private NIOServerSocket serverSocket;
    private JmolViewer jmolViewer;
    private JsonNioClient client;
    private boolean wasSpinOn;
    private String contentPath = "./%ID%.json";
    private String terminatorMessage = "NEXT_SCRIPT";
    private String resetMessage = "RESET_SCRIPT";
    protected int version = 1;
    private int nFast;
    private float swipeCutoff = 100.0f;
    private int swipeCount = 2;
    private float swipeDelayMs = 3000.0f;
    private long previousMoveTime;
    private long swipeStartTime;
    private float swipeFactor = 30.0f;
    private boolean motionDisabled;
    private boolean contentDisabled;

    public void scriptCallback(String string) {
        if (string == null) {
            return;
        }
        if (string.startsWith("banner:")) {
            this.setBanner(string.substring(7).trim(), false);
        } else if (string.equals(this.terminatorMessage)) {
            this.sendMessage(null, "!script_terminated!", null);
        } else if (this.contentDisabled && string.equals(this.resetMessage)) {
            this.client.nioRunContent(null);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void send(int n, String string) {
        try {
            if (n != this.port) {
                if (this.inSocket != null) {
                    this.inSocket.close();
                    if (this.outSocket != null) {
                        this.outSocket.close();
                    }
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.startService(n, this.client, this.jmolViewer, this.myName, 1);
            }
            if (string.startsWith("Mouse:")) {
                string = "{\"type\":\"move\",\"style\":\"sync\", \"sync\":\"" + string.substring(6) + "\"}";
            }
            this.sendMessage(null, string, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startService(int n, JsonNioClient jsonNioClient, JmolViewer jmolViewer, String string, int n2) throws IOException {
        this.version = n2;
        this.port = Math.abs(n);
        this.client = jsonNioClient;
        this.jmolViewer = jmolViewer;
        String string2 = this.myName = string == null ? "" : string;
        if (n < 0) {
            this.startServerService();
            return;
        }
        if (string != null) {
            String string3 = JmolViewer.getJmolValueAsString(jmolViewer, "NIOcontentPath");
            if (string3 != "") {
                this.contentPath = string3;
            }
            if ((string3 = JmolViewer.getJmolValueAsString(jmolViewer, "NIOterminatorMessage")) != "") {
                this.terminatorMessage = string3;
            }
            if ((string3 = JmolViewer.getJmolValueAsString(jmolViewer, "NIOresetMessage")) != "") {
                this.resetMessage = string3;
            }
            this.setEnabled();
            Logger.info("NIOcontentPath=" + this.contentPath);
            Logger.info("NIOterminatorMessage=" + this.terminatorMessage);
            Logger.info("NIOresetMessage=" + this.resetMessage);
            Logger.info("NIOcontentDisabled=" + this.contentDisabled);
            Logger.info("NIOmotionDisabled=" + this.motionDisabled);
        }
        Logger.info("JsonNioService" + this.myName + " using port " + n);
        if (n != 0) {
            this.inSocket = this.openSocket("127.0.0.1", n);
            this.inSocket.setPacketReader(new AsciiLinePacketReader());
            this.inSocket.setPacketWriter(new RawPacketWriter());
            this.inSocket.listen(new SocketObserver(){

                public void connectionOpened(NIOSocket nIOSocket) {
                    JsonNioService.this.initialize("out", nIOSocket);
                }

                public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                    JsonNioService.this.processMessage(byArray, null);
                }

                public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                    JsonNioService.this.halt = true;
                    Logger.info(Thread.currentThread().getName() + " inSocket connectionBroken");
                }
            });
            if (n2 == 1) {
                this.outSocket = this.openSocket("127.0.0.1", n);
                this.outSocket.setPacketReader(new AsciiLinePacketReader());
                this.outSocket.setPacketWriter(new RawPacketWriter());
                this.outSocket.listen(new SocketObserver(){

                    public void connectionOpened(NIOSocket nIOSocket) {
                        JsonNioService.this.initialize("in", nIOSocket);
                    }

                    public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                        Logger.info("outpacketreceived");
                    }

                    public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                        JsonNioService.this.halt = true;
                        Logger.info(Thread.currentThread().getName() + " outSocket connectionBroken");
                    }
                });
            }
        }
        if (n != 0) {
            this.thread = new Thread((Runnable)new JsonNioThread(), "JsonNiosThread" + this.myName);
            this.thread.start();
        }
        if (n == 0 && this.contentDisabled) {
            jsonNioClient.nioRunContent(this);
        }
    }

    private void setEnabled() {
        this.contentDisabled = JmolViewer.getJmolValueAsString(this.jmolViewer, "NIOcontentDisabled").equals("true");
        this.motionDisabled = JmolViewer.getJmolValueAsString(this.jmolViewer, "NIOmotionDisabled").equals("true");
    }

    public void close() {
        Logger.info("JsonNioService" + this.myName + " close");
        try {
            this.halt = true;
            super.close();
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            if (this.serverThread != null) {
                this.serverThread.interrupt();
                this.serverThread = null;
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            if (this.outSocket != null) {
                this.outSocket.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.client != null) {
            this.client.nioClosed(this);
        }
    }

    protected void initialize(String string, NIOSocket nIOSocket) {
        try {
            Logger.info("JsonNioService" + this.myName + " initialize " + string);
            JSONObject jSONObject = new JSONObject();
            if (this.version == 1) {
                jSONObject.put("magic", (Object)"JmolApp");
                jSONObject.put("role", (Object)string);
            } else {
                jSONObject.put("source", (Object)"Jmol");
                jSONObject.put("type", (Object)"login");
            }
            this.sendMessage(jSONObject, null, nIOSocket);
        }
        catch (JSONException jSONException) {
            this.close();
        }
    }

    private void startServerService() {
        try {
            this.serverSocket = this.openServerSocket(this.port);
            this.serverSocket.listen(new ServerSocketObserverAdapter(){

                public void newConnection(NIOSocket nIOSocket) {
                    Logger.info(Thread.currentThread().getName() + " Received connection: " + nIOSocket);
                    nIOSocket.setPacketReader(new AsciiLinePacketReader());
                    nIOSocket.setPacketWriter(new RawPacketWriter());
                    nIOSocket.listen(new SocketObserverAdapter(){

                        public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                            JsonNioService.this.processMessage(byArray, nIOSocket);
                        }

                        public void connectionOpened(NIOSocket nIOSocket) {
                        }

                        public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                            Logger.info("JsonNioService" + JsonNioService.this.myName + " server connection broken");
                            if (nIOSocket == JsonNioService.this.outSocket) {
                                JsonNioService.this.outSocket = null;
                            }
                        }
                    });
                }
            });
            this.serverSocket.setConnectionAcceptor(new ConnectionAcceptor(){

                public boolean acceptConnection(InetSocketAddress inetSocketAddress) {
                    boolean bl = inetSocketAddress.getAddress().isLoopbackAddress();
                    return bl;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        this.serverThread = new Thread((Runnable)new JsonNioServerThread(), "JsonNioServerThread" + this.myName);
        this.serverThread.start();
    }

    protected void processMessage(byte[] byArray, NIOSocket nIOSocket) {
        try {
            String string = new String(byArray);
            Logger.info("JNIOS received " + string);
            if (this.jmolViewer == null) {
                return;
            }
            JSONObject jSONObject = new JSONObject(string);
            if (this.version == 1) {
                if (nIOSocket != null && jSONObject.has("magic") && jSONObject.getString("magic").equals("JmolApp") && jSONObject.getString("role").equals("out")) {
                    this.outSocket = nIOSocket;
                }
            } else {
                this.outSocket = this.inSocket;
            }
            if (!jSONObject.has("type")) {
                return;
            }
            this.processJSON(jSONObject, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void processJSON(JSONObject jSONObject, String string) throws FileNotFoundException, JSONException {
        if (jSONObject == null) {
            jSONObject = new JSONObject(string);
        }
        int n = "banner....command...content...move......quit......sync......touch.....".indexOf(jSONObject.getString("type"));
        this.setEnabled();
        switch (n) {
            case 0: {
                if (this.contentDisabled) break;
                this.setBanner((String)(jSONObject.has("text") ? jSONObject.getString("text") : (jSONObject.getString("visibility").equalsIgnoreCase("off") ? null : "")), false);
                break;
            }
            case 10: {
                if (this.contentDisabled) break;
                this.sendScript(jSONObject.getString("command"));
                break;
            }
            case 20: {
                if (this.contentDisabled) {
                    this.client.nioRunContent(this);
                    break;
                }
                String string2 = jSONObject.getString("id");
                String string3 = TextFormat.simpleReplace(this.contentPath, "%ID%", string2).replace('\\', '/');
                File file = new File(string3);
                FileInputStream fileInputStream = new FileInputStream(file);
                Logger.info("JsonNiosService Setting path to " + file.getAbsolutePath());
                n = string3.lastIndexOf(47);
                string3 = n >= 0 ? string3.substring(0, n) : ".";
                JSONObject jSONObject2 = new JSONObject(new JSONTokener((InputStream)fileInputStream));
                String string4 = null;
                if (jSONObject2.has("scripts")) {
                    JSONArray jSONArray = jSONObject2.getJSONArray("scripts");
                    int n2 = jSONArray.length();
                    while (--n2 >= 0) {
                        JSONObject jSONObject3 = jSONArray.getJSONObject(n2);
                        if (!jSONObject3.getString("startup").equals("yes")) continue;
                        string4 = jSONObject3.getString("filename");
                        break;
                    }
                    if (string4 == null) {
                        throw new JSONException("scripts startup:yes not found");
                    }
                } else {
                    string4 = jSONObject2.getString("startup_script");
                }
                Logger.info("JsonNiosService startup_script=" + string4);
                this.setBanner("", false);
                this.sendScript("exit");
                this.sendScript("zap;cd \"" + string3 + "\";script " + string4);
                this.setBanner(jSONObject2.getString("banner").equals("off") ? null : jSONObject2.getString("banner_text"), true);
                break;
            }
            case 30: {
                n = "rotate....translate.zoom......".indexOf(jSONObject.getString("style"));
                if (this.motionDisabled) break;
                if (n != 0 && !this.isPaused) {
                    this.pauseScript(true);
                }
                long l = this.latestMoveTime = System.currentTimeMillis();
                switch (n) {
                    case 0: {
                        boolean bl;
                        float f = (float)jSONObject.getDouble("x");
                        float f2 = (float)jSONObject.getDouble("y");
                        float f3 = f * f + f2 * f2;
                        boolean bl2 = f3 > this.swipeCutoff;
                        boolean bl3 = bl = this.jmolViewer.getBooleanProperty("isNavigating") || !this.jmolViewer.getBooleanProperty("allowGestures");
                        if (bl || bl2 || (float)(l - this.swipeStartTime) > this.swipeDelayMs) {
                            string = null;
                            if (!bl) {
                                if (bl2) {
                                    if (++this.nFast > this.swipeCount) {
                                        this.swipeStartTime = l;
                                        string = "Mouse: spinXYBy " + (int)f + " " + (int)f2 + " " + Math.sqrt(f3) * (double)this.swipeFactor / (double)(l - this.previousMoveTime);
                                    }
                                } else if (this.nFast > 0) {
                                    this.nFast = 0;
                                    string = "Mouse: spinXYBy 0 0 0";
                                }
                            }
                            if (string == null) {
                                string = "Mouse: rotateXYBy " + f + " " + f2;
                            }
                            this.syncScript(string);
                        }
                        this.previousMoveTime = l;
                        break;
                    }
                    case 10: {
                        this.jmolViewer.syncScript("Mouse: translateXYBy " + jSONObject.getString("x") + " " + jSONObject.getString("y"), "=", 0);
                        break;
                    }
                    case 20: {
                        float f = (float)(jSONObject.getDouble("scale") / (double)(this.jmolViewer.getZoomPercentFloat() / 100.0f));
                        this.syncScript("Mouse: zoomByFactor " + f);
                    }
                }
                break;
            }
            case 40: {
                this.halt = true;
                Logger.info("JsonNiosService quitting");
                break;
            }
            case 50: {
                if (this.motionDisabled) break;
                this.syncScript("Mouse: " + jSONObject.getString("sync"));
                break;
            }
            case 60: {
                if (this.motionDisabled) break;
                this.jmolViewer.processEvent(0, jSONObject.getInt("eventType"), jSONObject.getInt("touchID"), jSONObject.getInt("iData"), new Point3f((float)jSONObject.getDouble("x"), (float)jSONObject.getDouble("y"), (float)jSONObject.getDouble("z")), jSONObject.getLong("time"));
            }
        }
    }

    private void sendScript(String string) {
        Logger.info("JsonNiosService sendScript " + string);
        this.jmolViewer.evalStringQuiet(string);
    }

    private void syncScript(String string) {
        Logger.info("JsonNiosService syncScript " + string);
        this.jmolViewer.syncScript(string, "=", 0);
    }

    private void setBanner(String string, boolean bl) {
        if (string == null) {
            this.client.setBannerLabel(null);
        } else {
            if (bl) {
                string = "<center>" + string + "</center>";
            }
            this.client.setBannerLabel("<html>" + string + "</html>");
        }
    }

    protected void pauseScript(boolean bl) {
        String string;
        if (bl) {
            this.wasSpinOn = this.jmolViewer.getBooleanProperty("spinOn");
            string = "pause; save orientation 'JsonNios-save'; spin off";
            this.isPaused = true;
        } else {
            string = "restore rotation 'JsonNios-save' 1; resume; spin " + this.wasSpinOn;
            this.wasSpinOn = false;
        }
        this.isPaused = bl;
        this.sendScript(string);
    }

    private void sendMessage(JSONObject jSONObject, String string, NIOSocket nIOSocket) {
        if (nIOSocket == null && (nIOSocket = this.outSocket) == null) {
            return;
        }
        try {
            if (jSONObject != null) {
                string = jSONObject.toString();
            } else if (string != null && string.indexOf("{") != 0) {
                jSONObject = new JSONObject();
                if (string.equalsIgnoreCase("!script_terminated!")) {
                    jSONObject.put("type", (Object)"script");
                    jSONObject.put("event", (Object)"done");
                } else {
                    jSONObject.put("type", (Object)"command");
                    jSONObject.put("command", (Object)string);
                }
                string = jSONObject.toString();
            }
            string = string + "\r\n";
            Logger.info(Thread.currentThread().getName() + " sending " + string + " to " + nIOSocket);
            nIOSocket.write(string.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected class JsonNioServerThread
    implements Runnable {
        protected JsonNioServerThread() {
        }

        public void run() {
            Logger.info(Thread.currentThread().getName() + " JsonNioServerSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectBlocking();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JsonNioService.this.close();
        }
    }

    protected class JsonNioThread
    implements Runnable {
        protected JsonNioThread() {
        }

        public void run() {
            Logger.info(Thread.currentThread().getName() + " JsonNioSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectNonBlocking();
                    long l = System.currentTimeMillis();
                    if (JsonNioService.this.isPaused && l - JsonNioService.this.latestMoveTime > 5000L) {
                        JsonNioService.this.pauseScript(false);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            JsonNioService.this.close();
        }
    }
}

