/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jmol.api.ApiPlatform;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.api.JmolViewer;
import org.jmol.script.ScriptCompiler;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Base64;
import org.jmol.util.BinaryDocument;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManager {
    protected Viewer viewer;
    private String pathForAllFiles = "";
    String nameAsGiven = "zapped";
    String fullPathName;
    String fileName;
    private URL appletDocumentBase = null;
    private URL appletCodeBase = null;
    private String appletProxy;
    ZipUtil jmolZip;
    private static final int URL_LOCAL = 3;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};
    private static String[] scriptFilePrefixes = new String[]{"/*file*/\"", "FILE0=\"", "FILE1=\""};
    private Map<String, byte[]> pngjCache;
    private static final String SCENE_TAG = "###scene.spt###";

    FileManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.fileName = this.nameAsGiven = this.viewer.getZapName();
        this.fullPathName = this.nameAsGiven;
    }

    private void setLoadState(Map<String, Object> map) {
        if (this.viewer.getPreserveState()) {
            map.put("loadState", this.viewer.getLoadState(map));
        }
    }

    String getPathForAllFiles() {
        return this.pathForAllFiles;
    }

    String setPathForAllFiles(String string) {
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("|")) {
            string = string + "/";
        }
        this.pathForAllFiles = string;
        return this.pathForAllFiles;
    }

    void setFileInfo(String[] stringArray) {
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[1];
        this.nameAsGiven = stringArray[2];
    }

    String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.nameAsGiven};
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        return this.appletDocumentBase == null ? "" : this.appletDocumentBase.toString();
    }

    void setAppletContext(URL uRL, URL uRL2, String string) {
        this.appletDocumentBase = uRL;
        this.appletCodeBase = uRL2;
        this.appletProxy = string;
        Logger.info("appletDocumentBase=" + this.appletDocumentBase + "\nappletCodeBase=" + this.appletCodeBase);
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setFileState;\n");
            stringBuffer2.append("function _setFileState() {\n\n");
        }
        if (stringBuffer2.indexOf("append") < 0 && this.viewer.getModelSetFileName().equals("zapped")) {
            stringBuffer2.append("  zap;\n");
        }
        this.viewer.appendLoadStates(stringBuffer2);
        if (stringBuffer != null) {
            stringBuffer2.append("\n}\n\n");
        }
        return stringBuffer2.toString();
    }

    String getFileTypeName(String string) {
        int n = string.indexOf("::");
        if (n >= 0) {
            return string.substring(0, n);
        }
        if (string.startsWith("=")) {
            return "pdb";
        }
        Object object = this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false, true, true);
        if (object instanceof BufferedReader) {
            return this.viewer.getModelAdapter().getFileTypeName(object);
        }
        if (object instanceof ZipInputStream) {
            String string2 = this.getZipDirectoryAsString(string);
            if (string2.indexOf("JmolManifest") >= 0) {
                return "Jmol";
            }
            return this.viewer.getModelAdapter().getFileTypeName(FileManager.getBufferedReaderForString(string2));
        }
        if (object instanceof String[]) {
            return ((String[])object)[0];
        }
        return null;
    }

    static BufferedReader getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    private String getZipDirectoryAsString(String string) {
        return ZipUtil.getZipDirectoryAsStringAndClose((BufferedInputStream)this.getBufferedInputStreamOrErrorMessageFromName(string, string, false, false, null));
    }

    Object createAtomSetCollectionFromFile(String string, Map<String, Object> map, boolean bl) {
        int n;
        if (map.get("atomDataOnly") == null) {
            this.setLoadState(map);
        }
        String string2 = (n = (string = this.viewer.resolveDatabaseFormat(string)).indexOf("::")) >= 0 ? string.substring(n + 2) : string;
        String string3 = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + string2 + ")" + (string.equals(string2) ? "" : " //" + string));
        String[] stringArray = this.classifyName(string2, true);
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        map.put("fullPathName", (string3 == null ? "" : string3 + "::") + string4.replace('\\', '/'));
        if (this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
            this.viewer.scriptStatus("Requesting " + string4);
        }
        FileReader fileReader = new FileReader(string5, string4, string2, string3, null, map, bl);
        fileReader.run();
        return fileReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromFiles(String[] stringArray, Map<String, Object> map, boolean bl) {
        this.setLoadState(map);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            String string = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            String string2 = n >= 0 ? stringArray[i].substring(0, n) : null;
            String[] stringArray5 = this.classifyName(string, true);
            if (stringArray5.length == 1) {
                return stringArray5[0];
            }
            stringArray2[i] = stringArray5[0];
            stringArray[i] = stringArray5[0].replace('\\', '/');
            stringArray4[i] = string2;
            stringArray3[i] = string;
        }
        map.put("fullPathNames", stringArray2);
        map.put("fileTypes", stringArray4);
        FilesReader filesReader = new FilesReader(stringArray2, stringArray3, stringArray4, null, map, bl);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromString(String string, StringBuffer stringBuffer, Map<String, Object> map, boolean bl, boolean bl2) {
        if (!bl2) {
            DataManager.getInlineData(stringBuffer, string, bl, this.viewer.getDefaultLoadFilter());
        }
        this.setLoadState(map);
        boolean bl3 = string.indexOf("Viewer.AddHydrogens") >= 0;
        String[] stringArray = bl3 ? this.getFileInfo() : null;
        FileReader fileReader = new FileReader("string", "string", "string", null, FileManager.getBufferedReaderForString(string), map, bl);
        fileReader.run();
        if (stringArray != null) {
            this.setFileInfo(stringArray);
        }
        if (!bl && !(fileReader.atomSetCollection instanceof String)) {
            this.viewer.zap(false, true, false);
            this.fileName = string == "1 0 C 0 0" ? "Jmol Model Kit" : "string";
            this.fullPathName = this.fileName;
        }
        return fileReader.atomSetCollection;
    }

    Object createAtomSeCollectionFromStrings(String[] stringArray, StringBuffer stringBuffer, Map<String, Object> map, boolean bl) {
        DataReader[] dataReaderArray;
        String[] stringArray2;
        if (!map.containsKey("isData")) {
            stringArray2 = "\"" + this.viewer.getDataSeparator() + "\"";
            dataReaderArray = "\"" + (bl ? "append" : "model") + " inline\"";
            StringBuffer stringBuffer2 = new StringBuffer("set dataSeparator \"~~~next file~~~\";\ndata ");
            stringBuffer2.append((String)dataReaderArray);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer2.append("~~~next file~~~");
                }
                stringBuffer2.append(stringArray[i]);
            }
            stringBuffer2.append("end ").append((String)dataReaderArray).append(";set dataSeparator ").append((String)stringArray2);
            stringBuffer.append(stringBuffer2);
        }
        this.setLoadState(map);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        stringArray2 = new String[stringArray.length];
        dataReaderArray = new StringDataReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            dataReaderArray[i] = new StringDataReader(stringArray[i]);
        }
        FilesReader filesReader = new FilesReader(stringArray2, stringArray2, null, dataReaderArray, map, bl);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSeCollectionFromArrayData(List<Object> list, Map<String, Object> map, boolean bl) {
        Logger.info("FileManager.getAtomSetCollectionFromArrayData(Vector)");
        int n = list.size();
        String[] stringArray = new String[n];
        DataReader[] dataReaderArray = new DataReader[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "String[" + i + "]";
            Object object = list.get(i);
            if (object instanceof String) {
                dataReaderArray[i] = new StringDataReader((String)list.get(i));
                continue;
            }
            if (object instanceof String[]) {
                dataReaderArray[i] = new ArrayDataReader((String[])list.get(i));
                continue;
            }
            if (!(object instanceof List)) continue;
            dataReaderArray[i] = new VectorDataReader((List)list.get(i));
        }
        FilesReader filesReader = new FilesReader(stringArray, stringArray, null, dataReaderArray, map, bl);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromDOM(Object object, Map<String, Object> map) {
        DOMReader dOMReader = new DOMReader(object, map);
        dOMReader.run();
        return dOMReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromReader(String string, String string2, Reader reader, Map<String, Object> map) {
        FileReader fileReader = new FileReader(string2, string, string2, null, new BufferedReader(reader), map, false);
        fileReader.run();
        return fileReader.atomSetCollection;
    }

    BufferedInputStream getBufferedInputStream(String string) {
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, new String[2], true, true);
        return object instanceof BufferedInputStream ? (BufferedInputStream)object : null;
    }

    Object getBufferedInputStreamOrErrorMessageFromName(String string, String string2, boolean bl, boolean bl2, byte[] byArray) {
        Object object;
        boolean bl3;
        byte[] byArray2 = string2 == null ? null : this.getCachedPngjBytes(string2);
        boolean bl4 = string.indexOf("?POST?_PNGJBIN_") >= 0;
        boolean bl5 = bl3 = bl4 || string.indexOf("?POST?_PNGJ_") >= 0;
        if (string.indexOf("?POST?_PNG_") > 0 || bl3) {
            object = this.viewer.getImageAs(bl3 ? "PNGJ" : "PNG", -1, 0, 0, null, null);
            if (!(object instanceof byte[])) {
                return object;
            }
            if (bl4) {
                byArray = (byte[])object;
                string = TextFormat.simpleReplace(string, "?_", "=_");
            } else {
                string = new StringBuffer(string).append("=").append(Base64.getBase64((byte[])object)).toString();
            }
        }
        object = null;
        int n = urlPrefixes.length;
        while (--n >= 0 && !string.startsWith(urlPrefixes[n])) {
        }
        boolean bl6 = n >= 0;
        String string3 = null;
        if (bl6 && (n = string.indexOf("?POST?")) >= 0) {
            string3 = string.substring(n + 6);
            string = string.substring(0, n);
        }
        boolean bl7 = this.appletDocumentBase != null;
        BufferedInputStream bufferedInputStream = null;
        try {
            if (byArray2 != null) {
                bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray2));
            } else if (bl7 || bl6) {
                if (bl7 && bl6 && this.appletProxy != null) {
                    string = this.appletProxy + "?url=" + URLEncoder.encode(string, "utf-8");
                }
                URL uRL = bl7 ? new URL(this.appletDocumentBase, string) : new URL(string);
                string = uRL.toString();
                if (bl && !bl2 && string.toLowerCase().indexOf("password") < 0) {
                    Logger.info("FileManager opening " + string);
                }
                URLConnection uRLConnection = uRL.openConnection();
                if (byArray != null && !bl2) {
                    uRLConnection.setRequestProperty("Content-Type", "application/octet-stream;");
                    uRLConnection.setDoOutput(true);
                    uRLConnection.getOutputStream().write(byArray);
                    uRLConnection.getOutputStream().flush();
                } else if (string3 != null && !bl2) {
                    uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    uRLConnection.setDoOutput(true);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                    outputStreamWriter.write(string3);
                    outputStreamWriter.flush();
                }
                bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            } else {
                if (bl) {
                    Logger.info("FileManager opening " + string);
                }
                File file = new File(string);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            }
            if (bl2) {
                bufferedInputStream.close();
                bufferedInputStream = null;
            }
            return bufferedInputStream;
        }
        catch (Exception exception) {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = "" + exception;
            return object;
        }
    }

    String[] getFullPathNameOrError(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null || stringArray[0] == null || stringArray.length < 2) {
            return new String[]{null, "cannot read file name: " + string};
        }
        String string2 = stringArray[0];
        String string3 = stringArray[0].replace('\\', '/');
        string2 = FileManager.getZipRoot(string2);
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string2, string3, false, true, null);
        return new String[]{string3, object instanceof String ? (String)object : null};
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2 = this.classifyName(string, true);
        if (stringArray2 == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = stringArray2[0].replace('\\', '/');
        }
        return this.getUnzippedBufferedReaderOrErrorMessageFromName(stringArray2[0], false, bl, false, bl2);
    }

    public String getEmbeddedFileState(String string) {
        String[] stringArray = null;
        stringArray = this.getZipDirectory(string, false);
        if (stringArray.length == 0) {
            String string2 = this.viewer.getFileAsString(string, Integer.MAX_VALUE, false, true);
            return string2.indexOf("**** Jmol Embedded Script ****") < 0 ? "" : ScriptCompiler.getEmbeddedScript(string2);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(".spt") < 0) continue;
            String[] stringArray2 = new String[]{string + "|" + stringArray[i], null};
            this.getFileDataOrErrorAsString(stringArray2, Integer.MAX_VALUE, false, false);
            return stringArray2[1];
        }
        return "";
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        String[] stringArray;
        String[] stringArray2 = null;
        String[] stringArray3 = stringArray = bl4 ? this.viewer.getModelAdapter().specialLoad(string, "filesNeeded?") : null;
        if (stringArray != null) {
            if (bl3) {
                return stringArray;
            }
            if (stringArray[2] != null) {
                CharSequence charSequence;
                String string2 = stringArray[1];
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (stringArray.length == 3) {
                    charSequence = this.getObjectAsSections(stringArray[2], string2, hashtable);
                    hashtable.put("OUTPUT", (String)charSequence);
                    stringArray = this.viewer.getModelAdapter().specialLoad(string, (String)hashtable.get(charSequence));
                    if (stringArray.length == 3) {
                        charSequence = this.getObjectAsSections(stringArray[2], string2, hashtable);
                        hashtable.put("OUTPUT", (String)charSequence);
                        stringArray = this.viewer.getModelAdapter().specialLoad(stringArray[1], (String)hashtable.get(charSequence));
                    }
                }
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append((String)hashtable.get(hashtable.get("OUTPUT")));
                for (int i = 2; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    string = this.getObjectAsSections(string, string2, hashtable);
                    Logger.info("reading " + string);
                    String string3 = (String)hashtable.get(string);
                    ((StringBuffer)charSequence).append(string3);
                }
                return FileManager.getBufferedReaderForString(((StringBuffer)charSequence).toString());
            }
        }
        byte[] byArray = this.getCachedPngjBytes(string);
        String string4 = string;
        if (string.indexOf("|") >= 0) {
            stringArray2 = TextFormat.split(string, "|");
            if (byArray == null) {
                Logger.info("FileManager opening " + string);
            }
            string = stringArray2[0];
        }
        Object object2 = object = byArray == null ? this.getBufferedInputStreamOrErrorMessageFromName(string, string4, true, false, null) : new BufferedInputStream(new ByteArrayInputStream(byArray));
        if (object instanceof String) {
            return object;
        }
        try {
            BufferedInputStream bufferedInputStream = (BufferedInputStream)object;
            if (ZipUtil.isGzip(bufferedInputStream)) {
                while (ZipUtil.isGzip(bufferedInputStream = new BufferedInputStream(new GZIPInputStream(bufferedInputStream)))) {
                }
            } else {
                if (CompoundDocument.isCompoundDocument(bufferedInputStream)) {
                    CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                    return FileManager.getBufferedReaderForString(compoundDocument.getAllData("Molecule", "Input").toString());
                }
                if (ZipUtil.isZipFile(bufferedInputStream = ZipUtil.checkPngZipStream(bufferedInputStream))) {
                    if (bl) {
                        return new ZipInputStream(bufferedInputStream);
                    }
                    if (bl2) {
                        return ZipUtil.getZipFileContents(bufferedInputStream, stringArray2, 1, true);
                    }
                    String string5 = (String)ZipUtil.getZipFileContents(bufferedInputStream, stringArray2, 1, false);
                    bufferedInputStream.close();
                    return FileManager.getBufferedReaderForString(string5);
                }
            }
            if (bl2) {
                return bufferedInputStream;
            }
            return new BufferedReader(new InputStreamReader(bufferedInputStream));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    String[] getZipDirectory(String string, boolean bl) {
        return ZipUtil.getZipDirectoryAndClose((BufferedInputStream)this.getBufferedInputStreamOrErrorMessageFromName(string, string, false, false, null), bl);
    }

    private String getObjectAsSections(String string, String string2, Map<String, String> map) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        boolean bl = false;
        String string3 = string.replace('\\', '/');
        if (string.indexOf(":asBinaryString") >= 0) {
            bl = true;
            string = string.substring(0, string.indexOf(":asBinaryString"));
        }
        StringBuffer stringBuffer = null;
        if (map.containsKey(string3)) {
            return string3;
        }
        if (string.indexOf("#JMOL_MODEL ") >= 0) {
            map.put(string3, string3 + "\n");
            return string3;
        }
        String string4 = string;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, string4, false, false, null);
            if (object instanceof String) {
                map.put(string3, (String)object + "\n");
                return string3;
            }
            bufferedInputStream = (BufferedInputStream)object;
            if (CompoundDocument.isCompoundDocument(bufferedInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                compoundDocument.getAllData(string.replace('\\', '/'), "Molecule", map);
            } else if (ZipUtil.isZipFile(bufferedInputStream)) {
                ZipUtil.getAllData(bufferedInputStream, stringArray, string.replace('\\', '/'), "Molecule", map);
            } else if (bl) {
                BinaryDocument binaryDocument = new BinaryDocument();
                binaryDocument.setStream(bufferedInputStream, false);
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                try {
                    while (true) {
                        stringBuffer.append(Integer.toHexString(binaryDocument.readByte() & 0xFF)).append(' ');
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append('\n');
                    if (string2 != null) {
                        stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                    }
                    map.put(string3, stringBuffer.toString());
                }
            } else {
                String string5;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ZipUtil.isGzip(bufferedInputStream) ? new GZIPInputStream(bufferedInputStream) : bufferedInputStream));
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                while ((string5 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string5);
                    stringBuffer.append('\n');
                }
                bufferedReader.close();
                if (string2 != null) {
                    stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                }
                map.put(string3, stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            map.put(string3, exception.getMessage());
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!map.containsKey(string3)) {
            map.put(string3, "FILE NOT FOUND: " + string3 + "\n");
        }
        return string3;
    }

    Object getFileAsBytes(String string, OutputStream outputStream) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = string;
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        if ((object = this.getBufferedInputStreamOrErrorMessageFromName(string, string2, false, false, null)) instanceof String) {
            return "Error:" + object;
        }
        try {
            BufferedInputStream bufferedInputStream = (BufferedInputStream)object;
            Object object2 = outputStream != null || stringArray == null || stringArray.length <= 1 || !ZipUtil.isZipFile(bufferedInputStream) && !ZipUtil.isPngZipStream(bufferedInputStream) ? FileManager.getStreamAsBytes(bufferedInputStream, outputStream) : (Object)ZipUtil.getZipFileContentsAsBytes(bufferedInputStream, stringArray, 1);
            bufferedInputStream.close();
            return object2;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    private static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = outputStream == null ? new byte[4096] : null;
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            n2 += n;
            if (outputStream == null) {
                if (n2 >= byArray2.length) {
                    byArray2 = ArrayUtil.ensureLength(byArray2, n2 * 2);
                }
                System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                continue;
            }
            outputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        if (outputStream == null) {
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
            return byArray;
        }
        return n2 + " bytes";
    }

    boolean getFileDataOrErrorAsString(String[] stringArray, int n, boolean bl, boolean bl2) {
        stringArray[1] = "";
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, stringArray, false, bl);
        if (object instanceof String) {
            stringArray[1] = (String)object;
            return false;
        }
        try {
            BufferedReader bufferedReader = (BufferedReader)object;
            StringBuffer stringBuffer = new StringBuffer(8192);
            if (n == Integer.MAX_VALUE) {
                String string2 = bufferedReader.readLine();
                if (bl2 || string2 != null && string2.indexOf(0) < 0 && (string2.length() != 4 || string2.charAt(0) != '\ufffd' || string2.indexOf("PNG") != 1)) {
                    stringBuffer.append(string2).append('\n');
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string2).append('\n');
                    }
                }
            } else {
                String string3;
                int n2;
                for (int i = 0; i < n && (string3 = bufferedReader.readLine()) != null; i += n2 + 1) {
                    n2 = string3.length();
                    if (n - i < n2 + 1) {
                        string3 = string3.substring(0, n - i - 1);
                    }
                    stringBuffer.append(string3).append('\n');
                }
            }
            bufferedReader.close();
            stringArray[1] = stringBuffer.toString();
            FileManager.fixUnicode(stringArray, 1);
            return true;
        }
        catch (Exception exception) {
            stringArray[1] = exception.getMessage();
            return false;
        }
    }

    private static void fixUnicode(String[] stringArray, int n) {
        String string = stringArray[n];
        Encoding encoding = Encoding.NONE;
        if (string.indexOf("\u00ef\u00bb\u00bf") == 0) {
            encoding = Encoding.UTF8;
        } else if (string.indexOf("\u0000\u0000\u00fe\u00ff") == 0) {
            encoding = Encoding.UTF_32BE;
        } else if (string.indexOf("\u00ff\u00fe\u0000\u0000") == 0) {
            encoding = Encoding.UTF_32LE;
        } else if (string.indexOf("\u00ff\u00fe") == 0) {
            encoding = Encoding.UTF_16LE;
        } else if (string.indexOf("\u00fe\u00ff") == 0) {
            encoding = Encoding.UTF_16BE;
        }
        if (encoding == Encoding.NONE) {
            return;
        }
        Logger.info("FileManager found encoding " + encoding.name());
        try {
            string = new String(string.getBytes(), encoding.name().replace('_', '-'));
            switch (encoding) {
                case UTF8: 
                case UTF_16BE: {
                    string = string.substring(1);
                    break;
                }
                case UTF_16LE: {
                    string = string.substring(1, string.length() - 1);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
        stringArray[n] = string;
    }

    Object getFileAsImage(String string, String[] stringArray) {
        if (string == null) {
            stringArray[0] = "";
            return null;
        }
        String[] stringArray2 = this.classifyName(string, true);
        if (stringArray2 == null) {
            stringArray[0] = "cannot read file name: " + string;
            return null;
        }
        Object object = null;
        ApiPlatform apiPlatform = this.viewer.getApiPlatform();
        String string2 = stringArray2[0].replace('\\', '/');
        if (string2.indexOf("|") > 0) {
            Object object2 = this.getFileAsBytes(string2, null);
            if (!(object2 instanceof byte[])) {
                stringArray[0] = "" + object2;
                return null;
            }
            object = apiPlatform.createImage(object2);
        } else if (FileManager.urlTypeIndex(string2) >= 0) {
            try {
                object = apiPlatform.createImage(new URL(string2));
            }
            catch (Exception exception) {
                stringArray[0] = "bad URL: " + string2;
                return null;
            }
        } else {
            object = apiPlatform.createImage(string2);
        }
        if (object == null) {
            return null;
        }
        try {
            if (!apiPlatform.waitForDisplay(this.viewer.getDisplay(), object)) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stringArray[0] = exception.getMessage() + " opening " + string2;
            return null;
        }
        if (apiPlatform.getImageWidth(object) < 1) {
            stringArray[0] = "invalid or missing image " + string2;
            return null;
        }
        stringArray[0] = string2;
        return object;
    }

    private static int urlTypeIndex(String string) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] classifyName(String string, boolean bl) {
        int n;
        String string2;
        boolean bl2;
        if (string == null) {
            return new String[]{null};
        }
        boolean bl3 = bl2 = this.pathForAllFiles.length() > 0;
        if (string.startsWith("?")) {
            if ((string = this.viewer.dialogAsk("load", string.substring(1))) == null) {
                return new String[]{bl ? "#CANCELED#" : null};
            }
            bl2 = false;
        }
        File file = null;
        URL uRL = null;
        String[] stringArray = null;
        if ((string = this.viewer.resolveDatabaseFormat(string)).indexOf(":") < 0 && string.indexOf("/") != 0) {
            string = FileManager.addDirectory(this.viewer.getDefaultDirectory(), string);
        }
        if (this.appletDocumentBase != null) {
            try {
                if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                    string = "file:/" + string;
                }
                uRL = new URL(this.appletDocumentBase, string);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.getMessage() : null};
            }
        } else if (FileManager.urlTypeIndex(string) >= 0 || this.viewer.isRestricted(Viewer.ACCESS.NONE) || this.viewer.isRestricted(Viewer.ACCESS.READSPT) && !string.endsWith(".spt") && !string.endsWith("/")) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.getMessage() : null};
            }
        } else {
            file = new File(string);
            stringArray = new String[]{file.getAbsolutePath(), file.getName(), "file:/" + file.getAbsolutePath().replace('\\', '/')};
        }
        if (uRL != null) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = uRL.toString();
            stringArray[1] = FileManager.stripPath(stringArray[0]);
        }
        if (bl2) {
            string2 = stringArray[0];
            stringArray[0] = this.pathForAllFiles + stringArray[1];
            Logger.info("FileManager substituting " + string2 + " --> " + stringArray[0]);
        }
        if (bl && (file != null || FileManager.urlTypeIndex(stringArray[0]) == 3) && (n = (string2 = file == null ? TextFormat.trim(stringArray[0].substring(5), "/") : stringArray[0]).length() - stringArray[1].length() - 1) > 0) {
            string2 = string2.substring(0, n);
            FileManager.setLocalPath(this.viewer, string2, true);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String string, String string2) {
        String string3;
        if (string.length() == 0) {
            return string2;
        }
        int n = string2.length() > 0 ? (int)string2.charAt(0) : 32;
        String string4 = string.toLowerCase();
        if ((string4.endsWith(".zip") || string4.endsWith(".tar")) && n != 124 && n != 47) {
            string = string + "|";
        }
        StringBuilder stringBuilder = new StringBuilder().append(string);
        if (n != 47 && n != 47) {
            char c = string.charAt(string.length() - 1);
            n = c;
            if (c != '|' && n != 47) {
                string3 = "/";
                return stringBuilder.append(string3).append(string2).toString();
            }
        }
        string3 = "";
        return stringBuilder.append(string3).append(string2).toString();
    }

    String getDefaultDirectory(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null) {
            return "";
        }
        string = FileManager.fixPath(stringArray[0]);
        return string == null ? "" : string.substring(0, string.lastIndexOf("/"));
    }

    private static String fixPath(String string) {
        string = string.replace('\\', '/');
        int n = (string = TextFormat.simpleReplace(string, "/./", "/")).lastIndexOf("//") + 1;
        if (n < 1) {
            n = string.indexOf(":/") + 1;
        }
        if (n < 1) {
            n = string.indexOf("/");
        }
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n);
        while ((n = string.lastIndexOf("/../")) >= 0) {
            int n2 = string.substring(0, n).lastIndexOf("/");
            if (n2 < 0) {
                return TextFormat.simpleReplace(string2 + string, "/../", "/");
            }
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string2 + string;
    }

    public String getFilePath(String string, boolean bl, boolean bl2) {
        String[] stringArray = this.classifyName(string, false);
        return stringArray == null || stringArray.length == 1 ? "" : (bl2 ? stringArray[1] : (bl ? stringArray[2] : (stringArray[0] == null ? "" : stringArray[0].replace('\\', '/'))));
    }

    public static String getLocalUrl(File file) {
        int n;
        if (file.getName().startsWith("=")) {
            return file.getName();
        }
        String string = file.getAbsolutePath().replace('\\', '/');
        for (n = 0; n < urlPrefixPairs.length; ++n) {
            if (string.indexOf(urlPrefixPairs[n]) != 0) continue;
            return null;
        }
        for (n = 0; n < urlPrefixPairs.length; n += 2) {
            if (string.indexOf(urlPrefixPairs[n]) <= 0) continue;
            return urlPrefixPairs[n + 1] + TextFormat.trim(string.substring(string.indexOf(urlPrefixPairs[n]) + urlPrefixPairs[n].length()), "/");
        }
        return null;
    }

    public static File getLocalDirectory(JmolViewer jmolViewer, boolean bl) {
        File file;
        String string = (String)jmolViewer.getParameter(bl ? "currentLocalPath" : "defaultDirectoryLocal");
        if (bl && string.length() == 0) {
            string = (String)jmolViewer.getParameter("defaultDirectoryLocal");
        }
        if (string.length() == 0) {
            return jmolViewer.isApplet() ? null : new File(System.getProperty("user.dir"));
        }
        if (jmolViewer.isApplet() && string.indexOf("file:/") == 0) {
            string = string.substring(6);
        }
        return (file = new File(string)).isDirectory() ? file : file.getParentFile();
    }

    public static void setLocalPath(JmolViewer jmolViewer, String string, boolean bl) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        jmolViewer.setStringProperty("currentLocalPath", string);
        if (!bl) {
            jmolViewer.setStringProperty("defaultDirectoryLocal", string);
        }
    }

    public static String getLocalPathForWritingFile(JmolViewer jmolViewer, String string) {
        if (string.indexOf("file:/") == 0) {
            return string.substring(6);
        }
        if (string.indexOf("/") == 0 || string.indexOf(":") >= 0) {
            return string;
        }
        File file = FileManager.getLocalDirectory(jmolViewer, false);
        return file == null ? string : FileManager.fixPath(file.toString() + "/" + string);
    }

    public static String setScriptFileReferences(String string, String string2, String string3, String string4) {
        if (string2 != null) {
            string = FileManager.setScriptFileReferences(string, string2, true);
        }
        if (string3 != null) {
            string = FileManager.setScriptFileReferences(string, string3, false);
        }
        string = TextFormat.simpleReplace(string, "\u0001\"", "\"");
        if (string4 != null) {
            while (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            for (int i = 0; i < scriptFilePrefixes.length; ++i) {
                String string5 = scriptFilePrefixes[i];
                string = TextFormat.simpleReplace(string, string5 + ".", string5 + string4);
            }
        }
        return string;
    }

    private static String setScriptFileReferences(String string, String string2, boolean bl) {
        if (string2 == null) {
            return string;
        }
        boolean bl2 = string2.length() == 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        FileManager.getFileReferences(string, arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            String string4 = string3;
            int n2 = FileManager.urlTypeIndex(string4);
            if (bl == (n2 < 0 || n2 == 3)) {
                int n3;
                int n4 = n3 = bl2 ? -1 : string4.indexOf("/" + string2 + "/");
                if (n3 >= 0) {
                    string4 = string4.substring(n3 + 1);
                } else {
                    n3 = string4.lastIndexOf("/");
                    if (n3 < 0 && !bl2) {
                        string4 = "/" + string4;
                    }
                    if (n3 < 0 || bl2) {
                        ++n3;
                    }
                    string4 = string2 + string4.substring(n3);
                }
            }
            Logger.info("FileManager substituting " + string3 + " --> " + string4);
            arrayList2.add("\"" + string3 + "\"");
            arrayList3.add("\u0001\"" + string4 + "\"");
        }
        return TextFormat.replaceStrings(string, arrayList2, arrayList3);
    }

    public static void getFileReferences(String string, List<String> list) {
        for (int i = 0; i < scriptFilePrefixes.length; ++i) {
            String string2 = scriptFilePrefixes[i];
            int n = -1;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                String string3 = Parser.getNextQuotedString(string, n);
                if (string3.indexOf("::") >= 0) {
                    string3 = TextFormat.split(string3, "::")[1];
                }
                list.add(string3);
            }
        }
    }

    Object createZipSet(String string, String string2, String[] stringArray, boolean bl) {
        Object object;
        String string3;
        String string4;
        int n;
        boolean bl2;
        boolean bl3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        boolean bl4 = stringArray != null && stringArray.length == 3 && stringArray[1].startsWith(SCENE_TAG);
        boolean bl5 = bl3 = bl4 && stringArray[2].equals("min");
        if (!bl3) {
            FileManager.getFileReferences(string2, arrayList2);
            if (bl4) {
                FileManager.getFileReferences(stringArray[1], arrayList2);
            }
        }
        boolean bl6 = bl2 = !bl4 && stringArray != null && stringArray.length > 0;
        if (bl2) {
            string2 = FileManager.wrapPathForAllFiles("script " + Escape.escape(stringArray[0]), "");
            for (n = 0; n < stringArray.length; ++n) {
                arrayList2.add(stringArray[n]);
            }
        }
        n = arrayList2.size();
        if (string != null) {
            string = string.replace('\\', '/');
        }
        if ((string4 = string) != null && (string4 = string.substring(string.lastIndexOf("/") + 1)).indexOf(".") >= 0) {
            string4 = string4.substring(0, string4.indexOf("."));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string3 = (String)arrayList2.get(i);
            int n2 = FileManager.urlTypeIndex(string3);
            boolean bl7 = n2 < 0 || n2 == 3;
            String string5 = string3;
            if (bl7 || bl) {
                int n3 = string3.lastIndexOf("/");
                string5 = string3.indexOf("?") > 0 && string3.indexOf("|") < 0 ? TextFormat.replaceAllCharacters(string3, "/:?\"'=&", "_") : FileManager.stripPath(string3);
                string5 = TextFormat.replaceAllCharacters(string5, "[]", "_");
                if (bl7 && string3.indexOf("|") < 0) {
                    arrayList.add(string3);
                    arrayList.add(string5);
                    arrayList.add(null);
                } else {
                    Object object2 = this.getFileAsBytes(string3, null);
                    if (!(object2 instanceof byte[])) {
                        return object2;
                    }
                    CRC32 cRC32 = new CRC32();
                    cRC32.update((byte[])object2);
                    Long l = cRC32.getValue();
                    if (hashtable.containsKey(l)) {
                        string5 = (String)hashtable.get(l);
                    } else {
                        if (hashtable.containsKey(string5)) {
                            int n4 = string5.lastIndexOf(".");
                            string5 = n4 > n3 ? string5.substring(0, n4) + "[" + i + "]" + string5.substring(n4) : string5 + "[" + i + "]";
                        }
                        arrayList.add(string3);
                        arrayList.add(string5);
                        arrayList.add(object2);
                        hashtable.put(l, string5);
                    }
                }
                string3 = "$SCRIPT_PATH$" + string5;
            }
            hashtable.put(string5, string5);
            arrayList3.add(string3);
        }
        if (!bl3) {
            string2 = TextFormat.replaceQuotedStrings(string2, arrayList2, arrayList3);
            arrayList.add("state.spt");
            arrayList.add(null);
            arrayList.add(string2.getBytes());
        }
        if (bl4) {
            if (stringArray[0] != null) {
                arrayList.add("animate.spt");
                arrayList.add(null);
                arrayList.add(stringArray[0].getBytes());
            }
            arrayList.add("scene.spt");
            arrayList.add(null);
            string2 = TextFormat.replaceQuotedStrings(stringArray[1], arrayList2, arrayList3);
            arrayList.add(string2.getBytes());
        }
        String string6 = bl4 ? "scene.spt" : "state.spt";
        arrayList.add("JmolManifest.txt");
        arrayList.add(null);
        string3 = "# Jmol Manifest Zip Format 1.1\n# Created " + DateFormat.getDateInstance().format(new Date()) + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string6;
        arrayList.add(string3.getBytes());
        arrayList.add("Jmol_version_" + Viewer.getJmolVersion().replace(' ', '_').replace(':', '.'));
        arrayList.add(null);
        arrayList.add(new byte[0]);
        if (string4 != null && (object = this.viewer.getImageAs("PNG", -1, -1, -1, null, null, null, JmolConstants.embedScript(string2))) instanceof byte[]) {
            arrayList.add("preview.png");
            arrayList.add(null);
            arrayList.add(object);
        }
        return this.writeZipFile(string, arrayList, "OK JMOL");
    }

    static String wrapPathForAllFiles(String string, String string2) {
        String string3 = "v__" + ("" + Math.random()).substring(3);
        return "# Jmol script\n{\n\tVar " + string3 + " = pathForAllFiles\n\tpathForAllFiles=\"$SCRIPT_PATH$\"\n\ttry{\n\t\t" + string + "\n\t}catch(e){" + string2 + "}\n\tpathForAllFiles = " + string3 + "\n}\n";
    }

    private static String stripPath(String string) {
        int n = Math.max(string.lastIndexOf("|"), string.lastIndexOf("/"));
        return string.substring(n + 1);
    }

    private Object writeZipFile(String string, List<Object> list, String string2) {
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        Logger.info("creating zip file " + (string == null ? "" : string) + "...");
        String string3 = null;
        String string4 = "";
        try {
            String string5;
            ByteArrayOutputStream byteArrayOutputStream = string == null || string.startsWith("http://") ? new ByteArrayOutputStream() : null;
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream == null ? new FileOutputStream(string) : byteArrayOutputStream);
            for (int i = 0; i < list.size(); i += 3) {
                String string6;
                String string7;
                string5 = (String)list.get(i);
                byte[] byArray2 = null;
                if (string5.indexOf("file:/") == 0) {
                    if ((string5 = string5.substring(5)).length() > 2 && string5.charAt(2) == ':') {
                        string5 = string5.substring(1);
                    }
                } else if (string5.indexOf("cache://") == 0) {
                    string5 = string5.substring(8);
                    byArray2 = this.viewer.cacheGet(string5).getBytes();
                }
                if ((string7 = (String)list.get(i + 1)) == null) {
                    string7 = string5;
                }
                if (byArray2 == null) {
                    byArray2 = (byte[])list.get(i + 2);
                }
                if (string4.indexOf(string6 = ";" + string7 + ";") >= 0) {
                    Logger.info("duplicate entry");
                    continue;
                }
                string4 = string4 + string6;
                zipOutputStream.putNextEntry(new ZipEntry(string7));
                int n = 0;
                if (byArray2 == null) {
                    int n2;
                    FileInputStream fileInputStream = new FileInputStream(string5);
                    while ((n2 = fileInputStream.read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n2);
                        n += n2;
                    }
                    fileInputStream.close();
                } else {
                    zipOutputStream.write(byArray2, 0, byArray2.length);
                    n += byArray2.length;
                }
                l += (long)n;
                zipOutputStream.closeEntry();
                Logger.info("...added " + string5 + " (" + n + " bytes)");
            }
            zipOutputStream.close();
            Logger.info(l + " bytes prior to compression");
            if (byteArrayOutputStream != null) {
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                if (string == null) {
                    return byArray3;
                }
                string3 = string;
                l2 = byArray3.length;
                string5 = this.postByteArray(string, byArray3);
                if (string5.indexOf("Exception") >= 0) {
                    return string5;
                }
                string2 = string2 + " " + string5;
            } else {
                File file = new File(string);
                string3 = file.getAbsolutePath().replace('\\', '/');
                l2 = file.length();
            }
        }
        catch (IOException iOException) {
            Logger.info(iOException.getMessage());
            return iOException.getMessage();
        }
        return string2 + " " + l2 + " " + string3;
    }

    private String postByteArray(String string, byte[] byArray) {
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, null, false, false, byArray);
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = FileManager.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (IOException iOException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return new String((byte[])object);
    }

    public static String fixFileNameVariables(String string, String string2) {
        String string3 = TextFormat.simpleReplace(string, "%FILE", string2);
        if (string3.indexOf("%LC") < 0) {
            return string3;
        }
        string2 = string2.toLowerCase();
        string3 = TextFormat.simpleReplace(string3, "%LCFILE", string2);
        if (string2.length() == 4) {
            string3 = TextFormat.simpleReplace(string3, "%LC13", string2.substring(1, 3));
        }
        return string3;
    }

    void clearPngjCache() {
        this.pngjCache = null;
    }

    private byte[] getCachedPngjBytes(String string) {
        boolean bl;
        if (string.indexOf(".png") < 0) {
            return null;
        }
        Logger.info("FileManager checking PNGJ cache for " + string);
        Object object = this.shortSceneFilename(string);
        if (this.pngjCache == null && !this.cachePngjFile(new String[]{string, null})) {
            return null;
        }
        boolean bl2 = bl = string.indexOf(".min.") >= 0;
        if (!bl) {
            String string2 = this.getCanonicalName(FileManager.getZipRoot(string));
            if (!this.pngjCache.containsKey(string2) && !this.cachePngjFile(new String[]{string, null})) {
                return null;
            }
            if (string.indexOf("|") < 0) {
                object = string2;
            }
        }
        if (this.pngjCache.containsKey(object)) {
            Logger.info("FileManager using memory cache " + (String)object);
            return this.pngjCache.get(object);
        }
        for (String string3 : this.pngjCache.keySet()) {
            System.out.println(string3);
        }
        System.out.println("FileManager memory cache (" + this.pngjCache.size() + ") did not find " + string + " as " + (String)object);
        if (!bl || !this.cachePngjFile(new String[]{string, null})) {
            return null;
        }
        Logger.info("FileManager using memory cache " + (String)object);
        return this.pngjCache.get(object);
    }

    boolean cachePngjFile(String[] stringArray) {
        this.pngjCache = new Hashtable<String, byte[]>();
        stringArray[1] = null;
        if (stringArray[0] == null) {
            return false;
        }
        stringArray[0] = FileManager.getZipRoot(stringArray[0]);
        String string = this.shortSceneFilename(stringArray[0]);
        try {
            stringArray[1] = ZipUtil.cacheZipContents(ZipUtil.checkPngZipStream((BufferedInputStream)this.getBufferedInputStreamOrErrorMessageFromName(stringArray[0], null, false, false, null)), string, this.pngjCache);
        }
        catch (Exception exception) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        byte[] byArray = stringArray[1].getBytes();
        this.pngjCache.put(this.getCanonicalName(stringArray[0]), byArray);
        if (string.indexOf("_scene_") >= 0) {
            this.pngjCache.put(this.shortSceneFilename(stringArray[0]), byArray);
            byArray = this.pngjCache.remove(string + "|state.spt");
            if (byArray != null) {
                this.pngjCache.put(this.shortSceneFilename(stringArray[0] + "|state.spt"), byArray);
            }
        }
        for (String string2 : this.pngjCache.keySet()) {
            System.out.println(string2);
        }
        return true;
    }

    private static String getZipRoot(String string) {
        int n = string.indexOf("|");
        return n < 0 ? string : string.substring(0, n);
    }

    private String getCanonicalName(String string) {
        String[] stringArray = this.classifyName(string, true);
        return stringArray == null ? string : stringArray[2];
    }

    private String shortSceneFilename(String string) {
        int n;
        int n2 = (string = this.getCanonicalName(string)).indexOf("_scene_") + 7;
        if (n2 < 7) {
            return string;
        }
        String string2 = "";
        if (string.endsWith("|state.spt")) {
            n = string.indexOf(46, n2);
            if (n < 0) {
                return string;
            }
            string2 = string.substring(n2, n);
        }
        n = string.lastIndexOf("|");
        return string.substring(0, n2) + string2 + (n > 0 ? string.substring(n) : "");
    }

    public static String getSceneScript(String[] stringArray, Map<String, String> map, List<Integer> list) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("###scene.spt### Jmol " + JmolViewer.getJmolVersion() + "\n{\nsceneScripts={");
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i - 1] = TextFormat.trim(stringArray[i - 1], "\t\n\r ");
            int[] nArray = new int[1];
            n2 = Parser.parseInt(stringArray[i], nArray);
            if (n2 == Integer.MIN_VALUE) {
                return "bad scene ID: " + n2;
            }
            stringArray[i] = stringArray[i].substring(nArray[0]);
            list.add(n2);
            String string = n + "-" + n2;
            map.put(string, stringArray[i - 1]);
            if (i > 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append('\n').append(Escape.escape(string)).append(": ").append(Escape.escape(stringArray[i - 1]));
            n = n2;
        }
        stringBuffer.append("\n}\n");
        if (list.size() == 0) {
            return "no lines 'pause scene n'";
        }
        stringBuffer.append("\nthisSceneRoot = '$SCRIPT_PATH$'.split('_scene_')[1];\n").append("thisSceneID = 0 + ('$SCRIPT_PATH$'.split('_scene_')[2]).split('.')[1];\n").append("var thisSceneState = '$SCRIPT_PATH$'.replace('.min.png','.all.png') + 'state.spt';\n").append("var spath = ''+currentSceneID+'-'+thisSceneID;\n").append("print thisSceneRoot + ' ' + spath;\n").append("var sscript = sceneScripts[spath];\n").append("var isOK = true;\n").append("try{\n").append("if (thisSceneRoot != currentSceneRoot){\n").append(" isOK = false;\n").append("} else if (sscript != '') {\n").append(" isOK = true;\n").append("} else if (thisSceneID <= currentSceneID){\n").append(" isOK = false;\n").append("} else {\n").append(" sscript = '';\n").append(" for (var i = currentSceneID; i < thisSceneID; i++){\n").append("  var key = ''+i+'-'+(i + 1); var script = sceneScripts[key];\n").append("  if (script = '') {isOK = false;break;}\n").append("  sscript += ';'+script;\n").append(" }\n").append("}\n}catch(e){print e;isOK = false}\n").append("if (isOK) {" + FileManager.wrapPathForAllFiles("script inline @sscript", "print e;isOK = false") + "}\n").append("if (!isOK){script @thisSceneState}\n").append("currentSceneRoot = thisSceneRoot; currentSceneID = thisSceneID;\n}\n");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EnumFileStatus {
        DELETED(5),
        CREATED(3),
        CREATING_MODELSET(2),
        ZAPPED(0),
        NOT_LOADED(-1);

        private int code;

        int getCode() {
            return this.code;
        }

        private EnumFileStatus(int n2) {
            this.code = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VectorDataReader
    extends DataReader {
        private List<String> data;
        private int pt;
        private int len;
        int ptMark;

        VectorDataReader(List<String> list) {
            super(new StringReader(""));
            this.data = list;
            this.len = list.size();
        }

        @Override
        public int read(char[] cArray) throws IOException {
            return this.readBuf(cArray);
        }

        @Override
        public String readLine() {
            return this.pt < this.len ? this.data.get(this.pt++) : null;
        }

        public void mark(long l) {
            this.ptMark = this.pt;
        }

        @Override
        public void reset() {
            this.pt = this.ptMark;
        }
    }

    class StringDataReader
    extends DataReader {
        StringDataReader(String string) {
            super(new StringReader(string));
        }
    }

    class ArrayDataReader
    extends DataReader {
        private String[] data;
        private int pt;
        private int len;
        int ptMark;

        ArrayDataReader(String[] stringArray) {
            super(new StringReader(""));
            this.data = stringArray;
            this.len = stringArray.length;
        }

        public int read(char[] cArray) throws IOException {
            return this.readBuf(cArray);
        }

        public String readLine() {
            return this.pt < this.len ? this.data[this.pt++] : null;
        }

        public void mark(long l) {
            this.ptMark = this.pt;
        }

        public void reset() {
            this.pt = this.ptMark;
        }
    }

    abstract class DataReader
    extends BufferedReader {
        DataReader(Reader reader) {
            super(reader);
        }

        BufferedReader getBufferedReader() {
            return this;
        }

        protected int readBuf(char[] cArray) throws IOException {
            int n = 0;
            String string = this.readLine();
            if (string == null) {
                return 0;
            }
            int n2 = 0;
            int n3 = string.length();
            for (int i = 0; i < cArray.length && n3 >= 0; ++i) {
                if (n2 >= n3) {
                    n2 = 0;
                    cArray[i] = 10;
                    string = this.readLine();
                    n3 = string == null ? -1 : string.length();
                } else {
                    cArray[i] = string.charAt(n2++);
                }
                ++n;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilesReader
    implements JmolFilesReaderInterface {
        private String[] fullPathNamesIn;
        private String[] namesAsGivenIn;
        private String[] fileTypesIn;
        Object atomSetCollection;
        private DataReader[] stringReaders;
        private Map<String, Object> htParams;
        private boolean isAppend;

        FilesReader(String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
            this.fullPathNamesIn = stringArray;
            this.namesAsGivenIn = stringArray2;
            this.fileTypesIn = stringArray3;
            this.stringReaders = dataReaderArray;
            this.htParams = map;
            this.isAppend = bl;
        }

        void run() {
            if (!this.isAppend && FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            boolean bl = !FileManager.this.viewer.displayLoadErrors;
            this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionReaders(this, this.fullPathNamesIn, this.fileTypesIn, this.htParams, bl);
            this.stringReaders = null;
            if (bl && !(this.atomSetCollection instanceof String)) {
                this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromSet(this.atomSetCollection, null, this.htParams);
            }
            if (this.atomSetCollection instanceof String) {
                Logger.error("file ERROR: " + this.atomSetCollection);
                return;
            }
            if (!this.isAppend && !FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            FileManager.this.nameAsGiven = this.stringReaders == null ? "file[]" : "String[]";
            FileManager.this.fileName = FileManager.this.nameAsGiven;
            FileManager.this.fullPathName = FileManager.this.nameAsGiven;
        }

        @Override
        public Object getBufferedReaderOrBinaryDocument(int n, boolean bl) {
            Object object;
            if (this.stringReaders != null) {
                return bl ? null : this.stringReaders[n].getBufferedReader();
            }
            String string = this.fullPathNamesIn[n];
            String[] stringArray = null;
            this.htParams.remove("subFileList");
            if (string.indexOf("|") >= 0) {
                stringArray = TextFormat.split(string, "|");
                string = stringArray[0];
            }
            if ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, bl, false, true)) instanceof ZipInputStream) {
                if (stringArray != null) {
                    this.htParams.put("subFileList", stringArray);
                }
                String[] stringArray2 = FileManager.this.getZipDirectory(string, true);
                BufferedInputStream bufferedInputStream = (BufferedInputStream)FileManager.this.getBufferedInputStreamOrErrorMessageFromName(string, this.fullPathNamesIn[n], false, false, null);
                object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(bufferedInputStream, string, stringArray2, this.htParams, true, bl);
            }
            if (object instanceof BufferedInputStream) {
                return new BinaryDocument((BufferedInputStream)object);
            }
            if (object instanceof BufferedReader || object instanceof BinaryDocument) {
                return object;
            }
            return object == null ? "error opening:" + this.namesAsGivenIn[n] : (String)object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileReader {
        private String fileNameIn;
        private String fullPathNameIn;
        private String nameAsGivenIn;
        private String fileTypeIn;
        Object atomSetCollection;
        private BufferedReader reader;
        private Map<String, Object> htParams;
        private boolean isAppend;

        FileReader(String string, String string2, String string3, String string4, BufferedReader bufferedReader, Map<String, Object> map, boolean bl) {
            this.fileNameIn = string;
            this.fullPathNameIn = string2;
            this.nameAsGivenIn = string3;
            this.fileTypeIn = string4;
            this.reader = bufferedReader;
            this.htParams = map;
            this.isAppend = bl;
        }

        void run() {
            if (!this.isAppend && FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            String string = null;
            Object object = null;
            if (this.reader == null && ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(this.fullPathNameIn, true, false, false, true)) == null || object instanceof String)) {
                String string2 = string = object == null ? "error opening:" + this.nameAsGivenIn : (String)object;
                if (!string.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + string);
                }
                this.atomSetCollection = string;
                return;
            }
            if (this.reader == null) {
                if (object instanceof BufferedReader) {
                    this.reader = (BufferedReader)object;
                } else if (object instanceof ZipInputStream) {
                    String string3 = this.fullPathNameIn;
                    String[] stringArray = null;
                    if (string3.indexOf("|") >= 0) {
                        stringArray = TextFormat.split(string3, "|");
                        string3 = stringArray[0];
                    }
                    if (stringArray != null) {
                        this.htParams.put("subFileList", stringArray);
                    }
                    ZipInputStream zipInputStream = (ZipInputStream)object;
                    String[] stringArray2 = FileManager.this.getZipDirectory(string3, true);
                    this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(zipInputStream, string3, stringArray2, this.htParams, false, false);
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.reader != null) {
                this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionReader(this.fullPathNameIn, this.fileTypeIn, this.reader, this.htParams);
                if (!(this.atomSetCollection instanceof String)) {
                    this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollection(this.atomSetCollection);
                }
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.atomSetCollection instanceof String) {
                return;
            }
            if (!this.isAppend && !FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            FileManager.this.fullPathName = this.fullPathNameIn;
            FileManager.this.nameAsGiven = this.nameAsGivenIn;
            FileManager.this.fileName = this.fileNameIn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DOMReader {
        private Object aDOMNode;
        Object atomSetCollection;
        Map<String, Object> htParams;

        DOMReader(Object object, Map<String, Object> map) {
            this.aDOMNode = object;
            this.htParams = map;
        }

        void run() {
            this.htParams.put("nameSpaceInfo", FileManager.this.viewer.getApiPlatform().getJsObjectInfo(this.aDOMNode, null, null));
            this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromDOM(this.aDOMNode, this.htParams);
            if (this.atomSetCollection instanceof String) {
                return;
            }
            FileManager.this.viewer.zap(false, true, false);
            FileManager.this.nameAsGiven = "JSNode";
            FileManager.this.fileName = "JSNode";
            FileManager.this.fullPathName = "JSNode";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Encoding {
        NONE,
        UTF8,
        UTF_16BE,
        UTF_16LE,
        UTF_32BE,
        UTF_32LE;

    }
}

