/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.ArrayList;
import java.util.List;

public final class CommandHistory {
    public static final String ERROR_FLAG = "#??";
    public static final String NOHISTORYLINE_FLAG = "#--";
    public static final String NOHISTORYATALL_FLAG = "#----";
    static final int DEFAULT_MAX_SIZE = 100;
    private List<String> commandList = null;
    private int maxSize = 100;
    private int nextCommand;
    private int cursorPos;
    boolean isOn = true;

    public CommandHistory() {
        this.reset(100);
    }

    public CommandHistory(int n) {
        this.reset(n);
    }

    public void clear() {
        this.reset(this.maxSize);
    }

    public void reset(int n) {
        this.maxSize = n;
        this.commandList = new ArrayList<String>();
        this.nextCommand = 0;
        this.commandList.add("");
        this.cursorPos = 0;
    }

    public void setMaxSize(int n) {
        if (n == this.maxSize) {
            return;
        }
        if (n < 2) {
            n = 2;
        }
        while (this.nextCommand > n) {
            this.commandList.remove(0);
            --this.nextCommand;
        }
        if (this.nextCommand > n) {
            this.nextCommand = n - 1;
        }
        this.cursorPos = this.nextCommand;
        this.maxSize = n;
    }

    public String getCommandUp() {
        if (this.cursorPos <= 0) {
            return null;
        }
        --this.cursorPos;
        String string = this.getCommand();
        if (string.endsWith(ERROR_FLAG)) {
            this.removeCommand(this.cursorPos--);
        }
        if (this.cursorPos < 0) {
            this.cursorPos = 0;
        }
        return string;
    }

    public String getCommandDown() {
        if (this.cursorPos >= this.nextCommand) {
            return null;
        }
        ++this.cursorPos;
        return this.getCommand();
    }

    private String getCommand() {
        return this.commandList.get(this.cursorPos);
    }

    public void addCommand(String string) {
        int n;
        if (!this.isOn && !string.endsWith(ERROR_FLAG)) {
            return;
        }
        if (string.endsWith(NOHISTORYATALL_FLAG)) {
            return;
        }
        while ((n = string.indexOf("\n")) >= 0) {
            String string2 = string.substring(0, n);
            if (string2.length() > 0) {
                this.addCommandLine(string2);
            }
            string = string.substring(n + 1);
        }
        if (string.length() > 0) {
            this.addCommandLine(string);
        }
    }

    public String getSetHistory(int n) {
        this.isOn = n == -2 ? this.isOn : true;
        switch (n) {
            case 0: {
                this.isOn = false;
                this.clear();
                return "";
            }
            case -2147483648: 
            case -2: {
                this.clear();
                return "";
            }
            case -1: {
                return this.getCommandUp();
            }
            case 1: {
                return this.getCommandDown();
            }
        }
        if (n < 0) {
            this.setMaxSize(-2 - n);
            return "";
        }
        n = Math.max(this.nextCommand - n, 0);
        String string = "";
        for (int i = n; i < this.nextCommand; ++i) {
            if (this.commandList.get(i).toUpperCase().startsWith("WRITE HISTORY")) continue;
            string = string + this.commandList.get(i) + "\n";
        }
        return string;
    }

    public String removeCommand() {
        return this.removeCommand(this.nextCommand - 1);
    }

    public String removeCommand(int n) {
        if (n < 0 || n >= this.nextCommand) {
            return "";
        }
        String string = this.commandList.remove(n);
        --this.nextCommand;
        return string;
    }

    private void addCommandLine(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.endsWith(NOHISTORYLINE_FLAG)) {
            return;
        }
        if (this.nextCommand >= this.maxSize) {
            this.commandList.remove(0);
            this.nextCommand = this.maxSize - 1;
        }
        this.commandList.add(this.nextCommand, string);
        ++this.nextCommand;
        this.cursorPos = this.nextCommand;
        this.commandList.add(this.nextCommand, "");
    }
}

