/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.FastBitSet;
import org.jmol.util.Logger;

public class Dots
extends AtomShape {
    public EnvelopeCalculation ec;
    public boolean isSurface = false;
    static final float SURFACE_DISTANCE_FOR_CALCULATION = 10.0f;
    BitSet bsOn = new BitSet();
    private BitSet bsSelected;
    private BitSet bsIgnore;
    static int MAX_LEVEL = 3;
    int thisAtom;
    float thisRadius;
    int thisArgb;
    RadiusData rdLast = new RadiusData();

    public void initShape() {
        super.initShape();
        this.translucentAllowed = false;
        this.ec = new EnvelopeCalculation(this.viewer, this.atomCount, this.mads);
    }

    public int getSize(int n) {
        return this.mads == null ? (int)(this.ec.getRadius(n) * 2000.0f) : this.mads[n] * 2;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("init" == string) {
            this.initialize();
            return;
        }
        if ("translucency" == string && !this.translucentAllowed) {
            return;
        }
        if ("ignore" == string) {
            this.bsIgnore = (BitSet)object;
            return;
        }
        if ("select" == string) {
            this.bsSelected = (BitSet)object;
            return;
        }
        if ("radius" == string) {
            this.thisRadius = ((Float)object).floatValue();
            if (this.thisRadius > 16.0f) {
                this.thisRadius = 16.0f;
            }
            return;
        }
        if ("colorRGB" == string) {
            this.thisArgb = (Integer)object;
            return;
        }
        if ("atom" == string) {
            this.thisAtom = (Integer)object;
            if (this.thisAtom >= this.atoms.length) {
                return;
            }
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            this.ec.allocDotsConvexMaps(this.atomCount);
            return;
        }
        if ("dots" == string) {
            if (this.thisAtom >= this.atoms.length) {
                return;
            }
            this.isActive = true;
            this.ec.setFromBits(this.thisAtom, (BitSet)object);
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            if (this.mads == null) {
                this.ec.setMads(null);
                this.mads = new short[this.atomCount];
                for (int i = 0; i < this.atomCount; ++i) {
                    if (!this.atoms[i].isInFrame() || !this.atoms[i].isShapeVisible(this.myVisibilityFlag)) continue;
                    try {
                        this.mads[i] = (short)(this.ec.getAppropriateRadius(i) * 1000.0f);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.ec.setMads(this.mads);
            }
            this.mads[this.thisAtom] = (short)(this.thisRadius * 1000.0f);
            if (this.colixes == null) {
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            this.colixes[this.thisAtom] = Graphics3D.getColix(this.thisArgb);
            this.bsOn.set(this.thisAtom);
            return;
        }
        if ("refreshTrajectories" == string) {
            bitSet = (BitSet)((Object[])object)[1];
            Matrix4f matrix4f = (Matrix4f)((Object[])object)[2];
            if (matrix4f == null) {
                return;
            }
            Matrix3f matrix3f = new Matrix3f();
            matrix4f.get(matrix3f);
            this.ec.reCalculate(bitSet, matrix3f);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[1];
            int n2 = ((int[])((Object[])object)[2])[2];
            BitSetUtil.deleteBits(this.bsOn, bitSet);
            this.ec.deleteAtoms(n, n2);
        }
        super.setProperty(string, object, bitSet);
    }

    void initialize() {
        this.bsSelected = null;
        this.bsIgnore = null;
        this.isActive = false;
        if (this.ec == null) {
            this.ec = new EnvelopeCalculation(this.viewer, this.atomCount, this.mads);
        }
    }

    protected void setSize(RadiusData radiusData, BitSet bitSet) {
        FastBitSet[] fastBitSetArray;
        int n;
        int n2;
        boolean bl;
        float f;
        if (radiusData == null) {
            radiusData = new RadiusData(0.0f, RadiusData.EnumType.ABSOLUTE, null);
        }
        if (this.bsSelected != null) {
            bitSet = this.bsSelected;
        }
        if (Logger.debugging) {
            Logger.debug("Dots.setSize " + radiusData.value);
        }
        boolean bl2 = true;
        float f2 = Float.MAX_VALUE;
        this.isActive = true;
        switch (radiusData.factorType) {
            case OFFSET: {
                break;
            }
            case ABSOLUTE: {
                if (radiusData.value == 0.0f) {
                    bl2 = false;
                }
                f2 = radiusData.value;
            }
            default: {
                radiusData.valueExtended = this.viewer.getCurrentSolventProbeRadius();
            }
        }
        switch (radiusData.vdwType) {
            case ADPMIN: 
            case ADPMAX: 
            case HYDRO: 
            case TEMP: {
                f = f2;
                break;
            }
            case IONIC: {
                f = this.modelSet.getMaxVanderwaalsRadius() * 2.0f;
                break;
            }
            default: {
                f = this.modelSet.getMaxVanderwaalsRadius();
            }
        }
        if (Logger.debugging) {
            Logger.startTimer();
        }
        boolean bl3 = bl = this.rdLast.value != radiusData.value || this.rdLast.valueExtended != radiusData.valueExtended || this.rdLast.factorType != radiusData.factorType || this.rdLast.vdwType != radiusData.vdwType || this.ec.getDotsConvexMax() == 0;
        if (bl2) {
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.bsOn.get(n2)) {
                    this.bsOn.set(n2);
                    bl = true;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        } else {
            n2 = bitSet == null ? 1 : 0;
            int n3 = n = n2 != 0 ? this.atomCount - 1 : bitSet.nextSetBit(0);
            while (n3 >= 0) {
                this.bsOn.set(n3, false);
                n3 = n2 != 0 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
            }
        }
        n2 = this.atomCount;
        while (--n2 >= 0) {
            this.atoms[n2].setShapeVisibility(this.myVisibilityFlag, this.bsOn.get(n2));
        }
        if (!bl2) {
            return;
        }
        if (bl) {
            this.mads = null;
            this.ec.newSet();
        }
        if ((fastBitSetArray = this.ec.getDotsConvexMaps()) != null) {
            n = this.atomCount;
            while (--n >= 0) {
                if (!this.bsOn.get(n)) continue;
                fastBitSetArray[n] = null;
            }
        }
        if (fastBitSetArray == null) {
            this.colixes = new short[this.atomCount];
            this.paletteIDs = new byte[this.atomCount];
        }
        this.ec.calculate(radiusData, f, this.bsOn, this.bsIgnore, !this.viewer.getDotSurfaceFlag(), this.viewer.getDotsSelectedOnlyFlag(), this.isSurface, true);
        this.rdLast = radiusData;
        if (Logger.debugging) {
            Logger.checkTimer("dots generation time");
        }
    }

    public void setModelClickability() {
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        FastBitSet[] fastBitSetArray = this.ec.getDotsConvexMaps();
        if (fastBitSetArray == null || this.ec.getDotsConvexMax() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        int n = this.viewer.getAtomCount();
        String string = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < n; ++i) {
            FastBitSet fastBitSet;
            if (!this.bsOn.get(i) || fastBitSetArray[i] == null) continue;
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Dots.setStateInfo(hashtable, i, this.getColorCommand(string, this.paletteIDs[i], this.colixes[i]));
            }
            if ((fastBitSet = fastBitSetArray[i]).isEmpty()) continue;
            float f = this.ec.getAppropriateRadius(i);
            Dots.appendCmd(stringBuffer, string + i + " radius " + f + " " + Escape.escape(fastBitSet.toBitSet()));
        }
        stringBuffer.append(Dots.getShapeCommands(hashtable, null));
        return stringBuffer.toString();
    }
}

