/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumAxesMode;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.TickInfo;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Point3fi;
import org.jmol.util.TextFormat;

abstract class FontLineShapeRenderer
extends ShapeRenderer {
    protected float imageFontScaling;
    protected Point3fi atomA;
    protected Point3fi atomB;
    protected Point3fi atomC;
    protected Point3fi atomD;
    protected Font3D font3d;
    protected final Point3i pt0 = new Point3i();
    protected final Point3i pt1 = new Point3i();
    protected final Point3i pt2 = new Point3i();
    protected final Point3f pointT = new Point3f();
    protected final Point3f pointT2 = new Point3f();
    protected final Point3f pointT3 = new Point3f();
    protected final Vector3f vectorT = new Vector3f();
    protected final Vector3f vectorT2 = new Vector3f();
    protected final Vector3f vectorT3 = new Vector3f();
    protected TickInfo tickInfo;
    protected boolean draw000 = true;
    protected byte endcap = (byte)3;

    FontLineShapeRenderer() {
    }

    protected int getDiameter(int n, int n2) {
        int n3;
        boolean bl = n2 > 20;
        switch (this.exportType) {
            case 1: {
                n3 = bl ? n2 : (int)(this.viewer.unscaleToScreen(n, n2 * 2) * 1000.0f);
                break;
            }
            default: {
                if (bl) {
                    n3 = this.viewer.scaleToScreen(n, n2);
                    break;
                }
                if (this.g3d.isAntialiased()) {
                    n2 += n2;
                }
                n3 = n2;
            }
        }
        return n3;
    }

    protected void renderLine(Point3f point3f, Point3f point3f2, int n, Point3i point3i, Point3i point3i2, boolean bl) {
        point3i.set((int)point3f.x, (int)point3f.y, (int)point3f.z);
        point3i2.set((int)point3f2.x, (int)point3f2.y, (int)point3f2.z);
        if (n < 0) {
            this.g3d.drawDottedLine(point3i, point3i2);
        } else {
            this.g3d.fillCylinder(this.endcap, n, point3i, point3i2);
        }
        if (!bl || this.tickInfo == null) {
            return;
        }
        this.atomA.screenX = point3i.x;
        this.atomA.screenY = point3i.y;
        this.atomA.screenZ = point3i.z;
        this.atomB.screenX = point3i2.x;
        this.atomB.screenY = point3i2.y;
        this.atomB.screenZ = point3i2.z;
        this.drawTicks(this.atomA, this.atomB, n, true);
    }

    protected void drawTicks(Point3fi point3fi, Point3fi point3fi2, int n, boolean bl) {
        String[] stringArray;
        if (Float.isNaN(this.tickInfo.first)) {
            this.tickInfo.first = 0.0f;
        }
        float f = this.tickInfo.ticks.x;
        if (!bl) {
            stringArray = null;
        } else if (this.tickInfo.tickLabelFormats == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "%0.2f";
        } else {
            stringArray = this.tickInfo.tickLabelFormats;
        }
        this.drawTicks(point3fi, point3fi2, f, 8, n, stringArray);
        this.drawTicks(point3fi, point3fi2, this.tickInfo.ticks.y, 4, n, null);
        this.drawTicks(point3fi, point3fi2, this.tickInfo.ticks.z, 2, n, null);
    }

    private void drawTicks(Point3fi point3fi, Point3fi point3fi2, float f, int n, int n2, String[] stringArray) {
        int n3;
        boolean bl;
        float f2;
        if (f == 0.0f) {
            return;
        }
        if (this.g3d.isAntialiased()) {
            n *= 2;
        }
        this.vectorT2.set(point3fi2.screenX, point3fi2.screenY, 0.0f);
        this.vectorT.set(point3fi.screenX, point3fi.screenY, 0.0f);
        this.vectorT2.sub(this.vectorT);
        if (this.vectorT2.length() < 50.0f) {
            return;
        }
        float f3 = this.tickInfo.signFactor;
        this.vectorT.set(point3fi2);
        this.vectorT.sub(point3fi);
        float f4 = this.vectorT.length();
        if (this.tickInfo.scale != null) {
            if (Float.isNaN(this.tickInfo.scale.x)) {
                f2 = this.viewer.getUnitCellInfo(0);
                if (!Float.isNaN(f2)) {
                    this.vectorT.set(this.vectorT.x / f2, this.vectorT.y / this.viewer.getUnitCellInfo(1), this.vectorT.z / this.viewer.getUnitCellInfo(2));
                }
            } else {
                this.vectorT.set(this.vectorT.x * this.tickInfo.scale.x, this.vectorT.y * this.tickInfo.scale.y, this.vectorT.z * this.tickInfo.scale.z);
            }
        }
        if ((f2 = this.vectorT.length() + 1.0E-4f * f) < f) {
            return;
        }
        float f5 = f / f2 * f4 / f2;
        this.vectorT.scale(f5);
        float f6 = (float)(point3fi2.screenZ - point3fi.screenZ) / (f2 / f);
        f2 += this.tickInfo.first;
        float f7 = (float)((int)(this.tickInfo.first / f)) * f - this.tickInfo.first;
        this.pointT.scaleAdd(f7 / f, this.vectorT, point3fi);
        f7 += this.tickInfo.first;
        float f8 = point3fi.screenZ;
        if (n2 < 0) {
            n2 = 1;
        }
        this.vectorT2.set(-this.vectorT2.y, this.vectorT2.x, 0.0f);
        this.vectorT2.scale((float)n / this.vectorT2.length());
        Point3f point3f = this.tickInfo.reference;
        if (point3f == null) {
            this.pointT3.set(this.viewer.getBoundBoxCenter());
            if (this.viewer.getAxesMode() == EnumAxesMode.BOUNDBOX) {
                this.pointT3.x = (float)((double)this.pointT3.x + 1.0);
                this.pointT3.y = (float)((double)this.pointT3.y + 1.0);
                this.pointT3.z = (float)((double)this.pointT3.z + 1.0);
            }
        } else {
            this.pointT3.set(point3f);
        }
        this.viewer.transformPoint(this.pointT3, this.pt2);
        boolean bl2 = bl = (double)Math.abs(this.vectorT2.x / this.vectorT2.y) < 0.2;
        boolean bl3 = !bl;
        boolean bl4 = !bl2 && this.vectorT2.x < 0.0f;
        boolean bl5 = stringArray != null && stringArray.length > 0;
        Object[] objectArray = new Object[1];
        int n4 = n3 = this.draw000 ? 0 : -1;
        while (f7 < f2) {
            if (f7 >= this.tickInfo.first) {
                this.pointT2.set(this.pointT);
                this.viewer.transformPoint(this.pointT2, this.pointT2);
                int n5 = (int)(this.pointT2.x + this.vectorT2.x);
                int n6 = (int)(this.pointT2.y + this.vectorT2.y);
                this.drawLine((int)this.pointT2.x, (int)this.pointT2.y, (int)f8, n5, n6, (int)f8, n2);
                if (bl5 && (this.draw000 || f7 != 0.0f)) {
                    objectArray[0] = new Float(f7 == 0.0f ? 0.0f : f7 * f3);
                    String string = TextFormat.sprintf(stringArray[n3 % stringArray.length], objectArray);
                    this.drawString(n5, n6, (int)f8, 4, bl4, bl2, bl3, (int)this.pointT2.y, string);
                }
            }
            this.pointT.add(this.vectorT);
            f7 += f;
            f8 += f6;
            ++n3;
        }
    }

    protected int drawLine(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.pt0.set(n, n2, n3);
        this.pt1.set(n4, n5, n6);
        if (n7 < 0) {
            this.g3d.drawDashedLine(4, 2, this.pt0, this.pt1);
            return 1;
        }
        this.g3d.fillCylinder((byte)2, n7, this.pt0, this.pt1);
        return (n7 + 1) / 2;
    }

    protected void drawString(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, int n5, String string) {
        if (string == null) {
            return;
        }
        int n6 = this.font3d.stringWidth(string);
        int n7 = this.font3d.getAscent();
        int n8 = n;
        n8 = bl ? (n8 -= n4 / 2 + 2 + n6) : (bl2 ? (n8 -= n4 / 2 + 2 + n6 / 2) : (n8 += n4 / 2 + 2));
        int n9 = n2;
        n9 = bl3 ? (n9 += n7 / 2) : (n5 == 0 || n5 < n2 ? (n9 += n7) : (n9 -= n4 / 2));
        int n10 = n3 - n4 - 2;
        if (n10 < 1) {
            n10 = 1;
        }
        this.g3d.drawString(string, this.font3d, n8, n9, n10, n10);
    }
}

