/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinModelSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.OutputStringBuffer;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quadric;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.util.TriangleData;
import org.jmol.util.XmlUtil;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelCollection
extends BondCollection {
    protected BitSet bsSymmetry;
    public String modelSetName;
    protected Model[] models = new Model[1];
    protected int modelCount;
    SymmetryInterface[] unitCells;
    protected int[] modelNumbers = new int[1];
    protected int[] modelFileNumbers = new int[1];
    protected String[] modelNumbersForAtomLabel = new String[1];
    protected String[] modelNames = new String[1];
    protected String[] frameTitles = new String[1];
    protected BitSet[] elementsPresent;
    protected boolean isXYZ;
    protected boolean isPDB;
    protected Properties modelSetProperties;
    protected Map<String, Object> modelSetAuxiliaryInfo;
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    protected final Point3f ptTemp = new Point3f();
    private final Point3f averageAtomPoint = new Point3f();
    private boolean isBbcageDefault;
    private BitSet bboxModels;
    private BitSet bboxAtoms;
    private final BoxInfo boxInfo = new BoxInfo();
    protected List<StateScript> stateScripts;
    private int thisStateModel;
    protected List<Point3f[]> trajectorySteps;
    protected List<Vector3f[]> vibrationSteps;
    private BitSet selectedMolecules;
    private int selectedMoleculeCount;
    private static final boolean showRebondTimes = true;
    protected BitSet bsAll;
    protected ShapeManager shapeManager;
    private static float hbondMin = 2.5f;
    public boolean proteinStructureTainted;
    private SymmetryInterface symTemp;
    private Hashtable<String, BitSet> htPeaks;

    public ModelCollection() {
        this.boxInfo.addBoundBoxPoint(new Point3f(-10.0f, -10.0f, -10.0f));
        this.boxInfo.addBoundBoxPoint(new Point3f(10.0f, 10.0f, 10.0f));
        this.stateScripts = new ArrayList<StateScript>();
        this.thisStateModel = 0;
        this.selectedMolecules = new BitSet();
        this.proteinStructureTainted = false;
    }

    protected void mergeModelArrays(ModelSet modelSet) {
        this.atoms = modelSet.atoms;
        this.bonds = modelSet.bonds;
        this.stateScripts = modelSet.stateScripts;
        this.proteinStructureTainted = modelSet.proteinStructureTainted;
        this.thisStateModel = -1;
        this.bsSymmetry = modelSet.bsSymmetry;
        this.modelFileNumbers = modelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = modelSet.modelNumbersForAtomLabel;
        this.modelNames = modelSet.modelNames;
        this.modelNumbers = modelSet.modelNumbers;
        this.frameTitles = modelSet.frameTitles;
        this.mergeAtomArrays(modelSet);
    }

    @Override
    protected void releaseModelSet() {
        this.models = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        super.releaseModelSet();
    }

    public String getModelSetName() {
        return this.modelSetName;
    }

    public Model[] getModels() {
        return this.models;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public SymmetryInterface[] getCellInfos() {
        return this.unitCells;
    }

    public boolean haveUnitCells() {
        if (this.unitCells != null) {
            return true;
        }
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].unitCell == null) continue;
            return true;
        }
        return false;
    }

    public SymmetryInterface getUnitCell(int n) {
        if (n < 0 || n >= this.modelCount) {
            return null;
        }
        if (this.models[n].unitCell != null) {
            return this.models[n].unitCell;
        }
        return this.unitCells == null || n >= this.unitCells.length || !this.unitCells[n].haveUnitCell() ? null : this.unitCells[n];
    }

    public void setUnitCell(int n, SymmetryInterface symmetryInterface) {
        if (n < 0 || n >= this.modelCount) {
            return;
        }
        this.models[n].unitCell = symmetryInterface;
    }

    public List<Object> getPlaneIntersection(int n, Point4f point4f, float f, int n2, int n3) {
        Object object;
        Point3f[] point3fArray = null;
        switch (n) {
            case 1614417948: {
                object = this.getUnitCell(n3);
                if (object == null) {
                    return null;
                }
                point3fArray = object.getCanonicalCopy(f);
                break;
            }
            case 1679429641: {
                point3fArray = this.boxInfo.getCanonicalCopy(f);
            }
        }
        object = new ArrayList();
        object.add(point3fArray);
        return TriangleData.intersectPlane(point4f, (List<Object>)object, n2);
    }

    public String getModelName(int n) {
        return this.modelCount < 1 ? "" : (n >= 0 ? this.modelNames[n] : this.modelNumbersForAtomLabel[-1 - n]);
    }

    public String getModelTitle(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "title");
    }

    public String getModelFileName(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "fileName");
    }

    public void setFrameTitle(BitSet bitSet, Object object) {
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n = bitSet.nextSetBit(0);
            int n2 = 0;
            while (n >= 0) {
                if (n2 < stringArray.length) {
                    this.frameTitles[n] = stringArray[n2++];
                }
                n = bitSet.nextSetBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                this.frameTitles[n] = (String)object;
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    public String getFrameTitle(int n) {
        return n >= 0 && n < this.modelCount ? this.frameTitles[n] : "";
    }

    public String getModelNumberForAtomLabel(int n) {
        return this.modelNumbersForAtomLabel[n];
    }

    protected void calculatePolymers(Group[] groupArray, int n, int n2, BitSet bitSet) {
        if (!this.isPDB) {
            return;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && bitSet.get(i) || !this.models[i].isBioModel) continue;
            this.models[i].calculatePolymers(groupArray, n, n2, bitSet);
            return;
        }
    }

    public Group[] getGroups() {
        int n = 0;
        for (int i = 0; i < this.modelCount; ++i) {
            n += this.models[i].getGroupCount();
        }
        Group[] groupArray = new Group[n];
        int n2 = 0;
        for (int i = 0; i < this.modelCount; ++i) {
            for (int j = 0; j < this.models[i].chainCount; ++j) {
                for (int k = 0; k < this.models[i].chains[j].groupCount; ++k) {
                    groupArray[n2] = this.models[i].chains[j].groups[k];
                    groupArray[n2].groupIndex = n2;
                    ++n2;
                }
            }
        }
        return groupArray;
    }

    public float[] getNotionalUnitcell() {
        SymmetryInterface symmetryInterface = this.getUnitCell(0);
        return symmetryInterface == null ? null : symmetryInterface.getNotionalUnitCell();
    }

    public boolean setCrystallographicDefaults() {
        return !this.isPDB && this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public Point3f getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    public Point3f getBoundBoxCenter(int n) {
        if (this.isJmolDataFrame(n)) {
            return new Point3f();
        }
        return this.boxInfo.getBoundBoxCenter();
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3fi[] getBboxVertices() {
        return this.boxInfo.getBboxVertices();
    }

    public Map<String, Object> getBoundBoxInfo() {
        return this.boxInfo.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.bboxModels;
    }

    public void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl, float f) {
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(point3f, point3f2, bl, f);
    }

    public String getBoundBoxCommand(boolean bl) {
        if (!bl && this.bboxAtoms != null) {
            return "boundbox " + Escape.escape(this.bboxAtoms);
        }
        this.ptTemp.set(this.boxInfo.getBoundBoxCenter());
        Vector3f vector3f = this.boxInfo.getBoundBoxCornerVector();
        String string = bl ? "boundbox " + Escape.escape(this.ptTemp) + " " + Escape.escape(vector3f) + "\n#or\n" : "";
        this.ptTemp.sub(vector3f);
        string = string + "boundbox corners " + Escape.escape(this.ptTemp) + " ";
        this.ptTemp.scaleAdd(2.0f, vector3f, this.ptTemp);
        float f = Math.abs(8.0f * vector3f.x * vector3f.y * vector3f.z);
        string = string + Escape.escape(this.ptTemp) + " # volume = " + f;
        return string;
    }

    public EnumVdw getDefaultVdwType(int n) {
        return !this.models[n].isBioModel ? EnumVdw.AUTO_BABEL : (this.models[n].hydrogenCount == 0 ? EnumVdw.AUTO_JMOL : EnumVdw.AUTO_BABEL);
    }

    public boolean setRotationRadius(int n, float f) {
        if (this.isJmolDataFrame(n)) {
            this.models[n].defaultRotationRadius = f;
            return false;
        }
        return true;
    }

    public float calcRotationRadius(int n, Point3f point3f) {
        if (this.isJmolDataFrame(n)) {
            float f = this.models[n].defaultRotationRadius;
            return f == 0.0f ? 10.0f : f;
        }
        float f = 0.0f;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.isJmolDataFrame(this.atoms[n2])) {
                n = this.atoms[n2].modelIndex;
                while (n2 >= 0 && this.atoms[n2].modelIndex == n) {
                    --n2;
                }
                continue;
            }
            Atom atom = this.atoms[n2];
            float f2 = point3f.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (!(f3 > f)) continue;
            f = f3;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public void calcBoundBoxDimensions(BitSet bitSet, float f) {
        if (bitSet != null && bitSet.nextSetBit(0) < 0) {
            bitSet = null;
        }
        if (bitSet == null && this.isBbcageDefault || this.atomCount < 2) {
            return;
        }
        this.bboxAtoms = BitSetUtil.copy(bitSet);
        this.bboxModels = this.getModelBitSet(this.bboxAtoms, false);
        if (this.calcAtomsMinMax(bitSet, this.boxInfo) == this.atomCount) {
            this.isBbcageDefault = true;
        }
        if (bitSet == null) {
            this.averageAtomPoint.set(this.getAtomSetCenter(null));
            if (this.unitCells != null) {
                this.calcUnitCellMinMax();
            }
        }
        this.boxInfo.setBbcage(f);
    }

    public BoxInfo getBoxInfo(BitSet bitSet, float f) {
        if (bitSet == null) {
            return this.boxInfo;
        }
        BoxInfo boxInfo = new BoxInfo();
        this.calcAtomsMinMax(bitSet, boxInfo);
        boxInfo.setBbcage(f);
        return boxInfo;
    }

    public int calcAtomsMinMax(BitSet bitSet, BoxInfo boxInfo) {
        int n;
        boxInfo.reset();
        int n2 = 0;
        boolean bl = bitSet == null;
        int n3 = n = bl ? this.atomCount - 1 : bitSet.nextSetBit(0);
        while (n3 >= 0) {
            ++n2;
            if (!this.isJmolDataFrame(this.atoms[n3])) {
                boxInfo.addBoundBoxPoint(this.atoms[n3]);
            }
            n3 = bl ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        return n2;
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            Point3f[] point3fArray = this.unitCells[i].getUnitCellVertices();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(point3fArray[j]);
            }
        }
    }

    public float calcRotationRadius(BitSet bitSet) {
        Point3f point3f = this.getAtomSetCenter(bitSet);
        float f = 0.0f;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.atoms[n];
            float f2 = point3f.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (f3 > f) {
                f = f3;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return f == 0.0f ? 10.0f : f;
    }

    public Point3f[][] getCenterAndPoints(List<BitSet[]> list, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2;
        int n = bl ? 1 : 0;
        int n2 = list.size();
        while (--n2 >= 0) {
            BitSet[] bitSetArray = list.get(n2);
            bitSet2 = bitSetArray[0];
            bitSet = bitSetArray[1];
            n += Math.min(bitSet2.cardinality(), bitSet.cardinality());
        }
        Point3f[][] point3fArray = new Point3f[2][n];
        if (bl) {
            point3fArray[0][0] = new Point3f();
            point3fArray[1][0] = new Point3f();
        }
        int n3 = list.size();
        while (--n3 >= 0) {
            BitSet[] bitSetArray = list.get(n3);
            bitSet2 = bitSetArray[0];
            bitSet = bitSetArray[1];
            int n4 = bitSet2.nextSetBit(0);
            int n5 = bitSet.nextSetBit(0);
            while (n4 >= 0 && n5 >= 0) {
                point3fArray[0][--n] = this.atoms[n4];
                point3fArray[1][n] = this.atoms[n5];
                if (bl) {
                    point3fArray[0][0].add(this.atoms[n4]);
                    point3fArray[1][0].add(this.atoms[n5]);
                }
                n4 = bitSet2.nextSetBit(n4 + 1);
                n5 = bitSet.nextSetBit(n5 + 1);
            }
        }
        if (bl) {
            point3fArray[0][0].scale(1.0f / (float)(point3fArray[0].length - 1));
            point3fArray[1][0].scale(1.0f / (float)(point3fArray[1].length - 1));
        }
        return point3fArray;
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        int n = 0;
        if (bitSet != null) {
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.isJmolDataFrame(this.atoms[n2])) {
                    ++n;
                    point3f.add(this.atoms[n2]);
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        if (n > 0) {
            point3f.scale(1.0f / (float)n);
        }
        return point3f;
    }

    @Override
    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        super.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
        if ((n == 1095763988 || n == 1632634889) && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds();
        }
    }

    public StateScript addStateScript(String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl, boolean bl2) {
        int n = this.viewer.getCurrentModelIndex();
        if (bl) {
            if (this.thisStateModel != n) {
                string = "frame " + (n < 0 ? "all #" + n : this.getModelNumberDotted(n)) + ";\n  " + string;
            }
            this.thisStateModel = n;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, string, bitSet, bitSet2, bitSet3, string2, bl2);
        if (stateScript.isValid()) {
            this.stateScripts.add(stateScript);
        }
        return stateScript;
    }

    protected String calculateStructuresAllExcept(BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.freezeModels();
        String string = "";
        BitSet bitSet2 = BitSetUtil.copyInvert(bitSet, this.modelCount);
        if (bl4) {
            this.setDefaultStructure(bitSet2);
        }
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            string = string + this.models[n].calculateStructures(bl, bl2, bl3, bl4, bl5);
            n = bitSet2.nextSetBit(n + 1);
        }
        if (bl4) {
            this.setStructureIds();
        }
        return string;
    }

    public void setDefaultStructure(BitSet bitSet) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (this.models[n].isBioModel && this.models[n].defaultStructure == null) {
                this.models[n].defaultStructure = this.getProteinStructureState(this.models[n].bsAtoms, false, false, 0);
            }
            n = bitSet.nextSetBit(n + 1);
        }
    }

    public void setProteinType(BitSet bitSet, EnumStructure enumStructure) {
        short s;
        int n;
        int n2 = -1;
        int n3 = -1;
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        this.setDefaultStructure(bitSet2);
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            if (n3 != n4 - 1) {
                n2 = -1;
            }
            n2 = this.atoms[n4].group.setProteinStructureType(enumStructure, n2);
            n = this.atoms[n4].modelIndex;
            this.models[n].structureTainted = true;
            this.proteinStructureTainted = true;
            n3 = n4 = this.atoms[n4].group.lastAtomIndex;
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        int[] nArray = new int[this.modelCount];
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bitSet2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            n3 = this.atoms[n].getStrucNo();
            if (n3 < 1000 && n3 > nArray[s]) {
                nArray[s] = n3;
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bitSet2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            if (this.atoms[n].getStrucNo() > 1000) {
                short s2 = s;
                int n5 = nArray[s2] + 1;
                nArray[s2] = n5;
                this.atoms[n].group.setProteinStructureId(n5);
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
    }

    void freezeModels() {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].freeze();
        }
    }

    public Map<EnumStructure, float[]> getStructureList() {
        return this.viewer.getStructureList();
    }

    public void setStructureList(Map<EnumStructure, float[]> map) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].setStructureList(map);
        }
    }

    public BitSet setConformation(BitSet bitSet) {
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            this.models[n].setConformation(bitSet);
            n = bitSet2.nextSetBit(n + 1);
        }
        return bitSet;
    }

    public BitSet getConformation(int n, int n2, boolean bl) {
        BitSet bitSet = new BitSet();
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            if (n3 != n && n >= 0) continue;
            String string = this.getAltLocListInModel(n3);
            int n4 = this.getAltLocCountInModel(n3);
            if (n2 > 0 && n2 >= n4) continue;
            BitSet bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(n3);
            if (n2 >= 0 && !this.models[n3].getPdbConformation(bitSet2, n2)) {
                int n5 = n4;
                while (--n5 >= 0) {
                    if (n5 == n2) continue;
                    bitSet2.andNot(this.getAtomBitsMaybeDeleted(0x10001F, string.substring(n5, n5 + 1)));
                }
            }
            if (bitSet2.nextSetBit(0) < 0) continue;
            bitSet.or(bitSet2);
            if (!bl) continue;
            this.models[n3].setConformation(bitSet2);
        }
        return bitSet;
    }

    public Map<String, String> getHeteroList(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Map map;
            if (n >= 0 && n2 != n || (map = (Map)this.getModelAuxiliaryInfo(n2, "hetNames")) == null) continue;
            bl = true;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                hashtable.put(string, (String)entry.getValue());
            }
        }
        return bl ? hashtable : (Map)this.getModelSetAuxiliaryInfo("hetNames");
    }

    public Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    public Map<String, Object> getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    public String getModelSetProperty(String string) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(string);
    }

    public boolean getModelSetAuxiliaryInfoBoolean(String string) {
        return this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(string) && (Boolean)this.modelSetAuxiliaryInfo.get(string) != false;
    }

    protected int getMergeTrajectoryCount(boolean bl) {
        if (this.trajectorySteps == null) {
            if (!bl) {
                return 0;
            }
            this.trajectorySteps = new ArrayList<Point3f[]>();
        }
        for (int i = this.trajectorySteps.size(); i < this.modelCount; ++i) {
            this.trajectorySteps.add(null);
        }
        return this.modelCount;
    }

    public int getTrajectoryIndex(int n) {
        return this.models[n].trajectoryBaseIndex;
    }

    public boolean isTrajectory(int n) {
        return this.models[n].isTrajectory;
    }

    public boolean isTrajectory(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n = nArray[0];
        for (int i = 1; i <= n; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || !this.models[this.atoms[n2].modelIndex].isTrajectory) continue;
            return true;
        }
        return false;
    }

    public BitSet getModelBitSet(BitSet bitSet, boolean bl) {
        int n;
        BitSet bitSet2 = new BitSet();
        short s = 0;
        boolean bl2 = bitSet == null;
        int n2 = n = bl2 ? 0 : bitSet.nextSetBit(0);
        while (n2 >= 0 && n2 < this.atomCount) {
            s = this.atoms[n2].modelIndex;
            bitSet2.set(s);
            if (bl) {
                int n3 = this.models[s].trajectoryBaseIndex;
                for (int i = 0; i < this.modelCount; ++i) {
                    if (this.models[i].trajectoryBaseIndex != n3) continue;
                    bitSet2.set(i);
                }
            }
            n2 = this.models[s].firstAtomIndex + this.models[s].atomCount - 1;
            n2 = bl2 ? n2 + 1 : bitSet.nextSetBit(n2 + 1);
        }
        return bitSet2;
    }

    public BitSet getIterativeModels(boolean bl) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bl && this.isJmolDataFrame(i) || this.models[i].trajectoryBaseIndex != i) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    protected boolean isTrajectorySubFrame(int n) {
        return this.models[n].isTrajectory && this.models[n].trajectoryBaseIndex != n;
    }

    public void selectDisplayedTrajectories(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isTrajectory || this.atoms[this.models[i].firstAtomIndex].modelIndex == i) continue;
            bitSet.clear(i);
        }
    }

    @Override
    public void fillAtomData(AtomData atomData, int n) {
        Object object;
        if ((n & 4) != 0) {
            this.getMolecules();
            atomData.bsMolecules = new BitSet[this.molecules.length];
            atomData.atomMolecule = new int[this.atomCount];
            for (int i = 0; i < this.molecules.length; ++i) {
                atomData.bsMolecules[i] = this.molecules[i].atomList;
                object = atomData.bsMolecules[i];
                int n2 = ((BitSet)object).nextSetBit(0);
                while (n2 >= 0) {
                    atomData.atomMolecule[n2] = i;
                    n2 = ((BitSet)object).nextSetBit(n2 + 1);
                }
            }
        }
        if ((n & 8) != 0) {
            object = new int[1];
            atomData.hAtomRadius = (float)this.viewer.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.calculateHydrogens(atomData.bsSelected, (int[])object, false, true, null);
            atomData.hydrogenAtomCount = object[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? (atomData.bsSelected == null ? 0 : Math.max(0, atomData.bsSelected.nextSetBit(0))) : this.models[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        super.fillAtomData(atomData, n);
    }

    public String getModelNumberDotted(int n) {
        return this.modelCount < 1 || n >= this.modelCount || n < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[n]);
    }

    public int getModelNumber(int n) {
        if (n == Integer.MAX_VALUE) {
            n = this.modelCount - 1;
        }
        return this.modelNumbers[n];
    }

    public int getModelFileNumber(int n) {
        return this.modelFileNumbers[n];
    }

    public Properties getModelProperties(int n) {
        return this.models[n].properties;
    }

    public String getModelProperty(int n, String string) {
        Properties properties = this.models[n].properties;
        return properties == null ? null : properties.getProperty(string);
    }

    public Map<String, Object> getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.models[n].auxiliaryInfo;
    }

    public void setModelAuxiliaryInfo(int n, Object object, Object object2) {
        this.models[n].auxiliaryInfo.put((String)object, object2);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        if (n < 0) {
            return null;
        }
        return this.models[n].auxiliaryInfo.get(string);
    }

    protected boolean getModelAuxiliaryInfoBoolean(int n, String string) {
        Map<String, Object> map = this.models[n].auxiliaryInfo;
        return map != null && map.containsKey(string) && (Boolean)map.get(string) != false;
    }

    protected int getModelAuxiliaryInfoInt(int n, String string) {
        Map<String, Object> map = this.models[n].auxiliaryInfo;
        if (map != null && map.containsKey(string)) {
            return (Integer)map.get(string);
        }
        return Integer.MIN_VALUE;
    }

    public String getModelAtomProperty(Atom atom, String string) {
        Object object = this.getModelAuxiliaryInfo(atom.modelIndex, string);
        if (!(object instanceof Object[])) {
            return "";
        }
        int n = atom.index - this.models[atom.modelIndex].firstAtomIndex;
        Object[] objectArray = (Object[])object;
        return n < objectArray.length ? objectArray[n].toString() : "";
    }

    public int getInsertionCountInModel(int n) {
        return this.models[n].nInsertions;
    }

    public String getModelFileType(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "fileType");
    }

    public static int modelFileNumberFromFloat(float f) {
        int n;
        int n2 = (int)f;
        for (n = (int)(((double)(f - (float)n2) + 1.0E-5) * 10000.0); n != 0 && n % 10 == 0; n /= 10) {
        }
        return n2 * 1000000 + n;
    }

    public int getAltLocCountInModel(int n) {
        return this.models[n].nAltLocs;
    }

    public int getChainCount(boolean bl) {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getChainCount(bl);
        }
        return n;
    }

    public int getBioPolymerCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (this.isTrajectorySubFrame(n2)) continue;
            n += this.models[n2].getBioPolymerCount();
        }
        return n;
    }

    public int getBioPolymerCountInModel(int n) {
        return n < 0 ? this.getBioPolymerCount() : (this.isTrajectorySubFrame(n) ? 0 : this.models[n].getBioPolymerCount());
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, List<Point3f[]> list) {
        boolean bl = this.viewer.getTraceAlpha();
        float f = this.viewer.getSheetSmoothing();
        for (int i = 0; i < this.modelCount; ++i) {
            this.models[i].getPolymerPointsAndVectors(bitSet, list, bl, f);
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int n) {
        if (n < 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                this.recalculateLeadMidpointsAndWingVectors(i);
            }
            return;
        }
        this.models[n].recalculateLeadMidpointsAndWingVectors();
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.models[n].getPolymerLeadMidPoints(n2);
    }

    public int getChainCountInModel(int n, boolean bl) {
        if (n < 0) {
            return this.getChainCount(bl);
        }
        return this.models[n].getChainCount(bl);
    }

    public int getGroupCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getGroupCount();
        }
        return n;
    }

    public int getGroupCountInModel(int n) {
        if (n < 0) {
            return this.getGroupCount();
        }
        return this.models[n].getGroupCount();
    }

    public void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedGroupsCount(bitSet);
        }
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedMonomersCount(bitSet);
        }
    }

    public void calcRasmolHydrogenBonds(BitSet bitSet, BitSet bitSet2, List<Bond> list, boolean bl, int n, boolean bl2, BitSet bitSet3) {
        boolean bl3 = bitSet2 == null || bitSet.equals(bitSet2);
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (!this.models[n2].isBioModel || this.models[n2].trajectoryBaseIndex != n2) continue;
            if (list == null) {
                this.models[n2].clearRasmolHydrogenBonds(bitSet);
                if (!bl3) {
                    this.models[n2].clearRasmolHydrogenBonds(bitSet2);
                }
            }
            this.models[n2].getRasmolHydrogenBonds(bitSet, bitSet2, list, bl, n, bl2, bitSet3);
        }
    }

    public void calculateStraightness() {
        if (this.getHaveStraightness()) {
            return;
        }
        char c = 'S';
        char c2 = this.viewer.getQuaternionFrame();
        int n = this.viewer.getHelixStep();
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            this.models[n2].calculateStraightness(this.viewer, c, c2, n);
        }
        this.setHaveStraightness(true);
    }

    public Quaternion[] getAtomGroupQuaternions(BitSet bitSet, int n, char c) {
        int n2 = 0;
        ArrayList<Quaternion> arrayList = new ArrayList<Quaternion>();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0 && n2 < n) {
            block6: {
                Quaternion quaternion;
                Group group;
                block5: {
                    group = this.atoms[n3].group;
                    quaternion = group.getQuaternion(c);
                    if (quaternion != null) break block5;
                    if (group.seqcode == Integer.MIN_VALUE) {
                        quaternion = group.getQuaternionFrame(this.atoms);
                    }
                    if (quaternion == null) break block6;
                }
                ++n2;
                arrayList.add(quaternion);
                n3 = group.lastAtomIndex;
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        return arrayList.toArray(new Quaternion[arrayList.size()]);
    }

    public String getPdbAtomData(BitSet bitSet, OutputStringBuffer outputStringBuffer) {
        int n;
        if (this.atomCount == 0 || bitSet.nextSetBit(0) < 0) {
            return "";
        }
        if (outputStringBuffer == null) {
            outputStringBuffer = new OutputStringBuffer(null);
        }
        short s = this.atoms[bitSet.nextSetBit((int)0)].modelIndex;
        short s2 = -1;
        boolean bl = "PQR".equals(outputStringBuffer.type);
        String string = "%6.2Q%6.2b          ";
        if (bl) {
            string = "%8.4P%7.4V       ";
            float f = 0.0f;
            n = bitSet.nextSetBit(0);
            while (n >= 0) {
                f += this.atoms[n].getPartialCharge();
                n = bitSet.nextSetBit(n + 1);
            }
            outputStringBuffer.append("REMARK   1 PQR file generated by Jmol " + Viewer.getJmolVersion()).append("\nREMARK   1 created " + new Date()).append("\nREMARK   1 Forcefield Used: unknown\nREMARK   1").append("\nREMARK   5").append("\nREMARK   6 Total charge on this protein: " + f + " e\nREMARK   6\n");
        }
        int n2 = bitSet.length() - 1;
        n = s != this.atoms[n2].modelIndex ? 1 : 0;
        StringBuffer stringBuffer = n != 0 ? null : new StringBuffer();
        boolean bl2 = this.models[s].isPdbWithMultipleBonds;
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            Bond[] bondArray;
            Atom atom = this.atoms[n3];
            if (n != 0 && atom.modelIndex != s2) {
                if (s2 != -1) {
                    outputStringBuffer.append("ENDMDL\n");
                }
                s2 = atom.modelIndex;
                outputStringBuffer.append("MODEL     " + (s2 + 1) + "\n");
            }
            String string2 = atom.getAtomName();
            boolean bl3 = atom.getElementSymbol().length() == 2 || string2.length() >= 4 || Character.isDigit(string2.charAt(0));
            boolean bl4 = this.models[atom.modelIndex].isBioModel;
            boolean bl5 = atom.isHetero();
            LabelToken[] labelTokenArray = !bl4 ? (bl3 ? LabelToken.compile(this.viewer, "HETATM%5.-5i %-4.4a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.viewer, "HETATM%5.-5i  %-3.3a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl5 ? (bl3 ? LabelToken.compile(this.viewer, "HETATM%5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.viewer, "HETATM%5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl3 ? LabelToken.compile(this.viewer, "ATOM  %5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.viewer, "ATOM  %5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)));
            String string3 = atom.getElementSymbol(false).toUpperCase();
            outputStringBuffer.append(LabelToken.formatLabel(this.viewer, atom, labelTokenArray, '\u0000', null)).append(string3.length() == 1 ? " " + string3 : string3.substring(0, 2)).append("  \n");
            if (n == 0 && (!bl4 || bl5 || bl2) && (bondArray = atom.getBonds()) != null) {
                block6: for (int i = 0; i < bondArray.length; ++i) {
                    int n4;
                    int n5 = atom.getAtomNumber();
                    Atom atom2 = bondArray[i].getOtherAtom(atom);
                    if (!bitSet.get(atom2.index) || (n4 = bondArray[i].getCovalentOrder()) == 1 && bl2 && !bl5) continue;
                    int n6 = atom2.getAtomNumber();
                    switch (n4) {
                        case 2: 
                        case 3: {
                            if (n6 < n5) continue block6;
                        }
                        case 1: {
                            stringBuffer.append("CONECT").append(TextFormat.formatString("%5i", "i", n5));
                            for (int j = 0; j < n4; ++j) {
                                stringBuffer.append(TextFormat.formatString("%5i", "i", n6));
                            }
                            stringBuffer.append('\n');
                        }
                    }
                }
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        if (n != 0) {
            outputStringBuffer.append("ENDMDL\n");
        } else {
            outputStringBuffer.append(stringBuffer.toString());
        }
        return outputStringBuffer.toString();
    }

    public String getPdbData(int n, String string, BitSet bitSet, Object[] objectArray, OutputStringBuffer outputStringBuffer) {
        if (this.isJmolDataFrame(n)) {
            n = this.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        boolean bl = this.models[n].isBioModel;
        if (objectArray == null && !bl) {
            return null;
        }
        Model model = this.models[n];
        if (outputStringBuffer == null) {
            outputStringBuffer = new OutputStringBuffer(null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = string.indexOf("draw") >= 0;
        BitSet bitSet2 = null;
        BitSet bitSet3 = new BitSet();
        char c = '\u0000';
        LabelToken[] labelTokenArray = LabelToken.compile(this.viewer, "ATOM  %-6i%4a%1A%3n %1c%4R%1E   ", '\u0000', null);
        if (objectArray == null) {
            c = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'R';
            model.getPdbData(this.viewer, string, c, bl2, bitSet, outputStringBuffer, labelTokenArray, stringBuffer, bitSet3);
            bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(n);
        } else {
            bitSet2 = (BitSet)objectArray[0];
            float[] fArray = (float[])objectArray[1];
            float[] fArray2 = (float[])objectArray[2];
            float[] fArray3 = (float[])objectArray[3];
            boolean bl3 = fArray3 != null;
            Point3f point3f = (Point3f)objectArray[4];
            Point3f point3f2 = (Point3f)objectArray[5];
            Point3f point3f3 = (Point3f)objectArray[6];
            Point3f point3f4 = (Point3f)objectArray[7];
            outputStringBuffer.append("REMARK   6 Jmol PDB-encoded data: ").append(string).append(";\n");
            outputStringBuffer.append("REMARK   6 Jmol data").append(" min = ").append(Escape.escape(point3f)).append(" max = ").append(Escape.escape(point3f2)).append(" unScaledXyz = xyz * ").append(Escape.escape(point3f3)).append(" + ").append(Escape.escape(point3f4)).append(";\n");
            String string2 = "";
            Atom atom = null;
            int n2 = bitSet2.nextSetBit(0);
            int n3 = 0;
            while (n2 >= 0) {
                float f;
                float f2 = fArray[n3];
                float f3 = fArray2[n3];
                float f4 = f = bl3 ? fArray3[n3] : 0.0f;
                if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f))) {
                    Atom atom2 = this.atoms[n2];
                    outputStringBuffer.append(LabelToken.formatLabel(this.viewer, atom2, labelTokenArray, '\u0000', null));
                    if (bl) {
                        bitSet3.set(n2);
                    }
                    outputStringBuffer.append(TextFormat.sprintf("%-8.2f%-8.2f%-10.2f    %6.3f          %2s    %s\n", new Object[]{atom2.getElementSymbol(false).toUpperCase(), string2, new float[]{f2, f3, f, 0.0f}}));
                    if (atom != null && atom.getPolymerIndexInModel() == atom2.getPolymerIndexInModel()) {
                        stringBuffer.append("CONECT").append(TextFormat.formatString("%5i", "i", atom.getAtomNumber())).append(TextFormat.formatString("%5i", "i", atom2.getAtomNumber())).append('\n');
                    }
                    atom = atom2;
                }
                n2 = bitSet2.nextSetBit(n2 + 1);
                ++n3;
            }
        }
        outputStringBuffer.append(stringBuffer.toString());
        if (bl2) {
            return outputStringBuffer.toString();
        }
        bitSet.and(bitSet2);
        if (bl) {
            outputStringBuffer.append("\n\n" + this.getProteinStructureState(bitSet3, false, c == 'R', 1));
        }
        return outputStringBuffer.toString();
    }

    public boolean isJmolDataFrame(int n) {
        return n >= 0 && n < this.modelCount && this.models[n].isJmolDataFrame;
    }

    private boolean isJmolDataFrame(Atom atom) {
        return this.models[atom.modelIndex].isJmolDataFrame;
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        Model model = this.models[string == null ? this.models[n2].dataSourceFrame : n];
        if (string == null) {
            string = this.models[n2].jmolFrameType;
        }
        if (n >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable<String, Integer>();
            }
            this.models[n2].dataSourceFrame = n;
            this.models[n2].jmolFrameType = string;
            model.dataFrames.put(string, n2);
        }
        if (string.startsWith("quaternion") && string.indexOf("deriv") < 0) {
            string = string.substring(0, string.indexOf(" "));
            model.dataFrames.put(string, n2);
        }
    }

    public int getJmolDataFrameIndex(int n, String string) {
        if (this.models[n].dataFrames == null) {
            return -1;
        }
        Integer n2 = this.models[n].dataFrames.get(string);
        return n2 == null ? -1 : n2;
    }

    protected void clearDataFrameReference(int n) {
        for (int i = 0; i < this.modelCount; ++i) {
            Map<String, Integer> map = this.models[i].dataFrames;
            if (map == null) continue;
            Iterator<Integer> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != n) continue;
                iterator.remove();
            }
        }
    }

    public String getJmolFrameType(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int n, StateManager.Orientation orientation) {
        this.models[n].orientation = orientation;
    }

    public StateManager.Orientation getModelOrientation(int n) {
        return this.models[n].orientation;
    }

    public String getPDBHeader(int n) {
        return this.models[n].isBioModel ? this.models[n].getFullPDBHeader() : this.getFileHeader(n);
    }

    public String getFileHeader(int n) {
        if (n < 0) {
            return "";
        }
        if (this.models[n].isBioModel) {
            return this.models[n].getFullPDBHeader();
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "fileHeader");
        if (string == null) {
            string = this.modelSetName;
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public Map<String, Object> getLigandInfo(BitSet bitSet) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList arrayList = new ArrayList();
        hashtable.put("ligands", arrayList);
        BitSet bitSet2 = BitSetUtil.copyInvert(bitSet, this.atomCount);
        bitSet2.or(this.viewer.getAtomBitSet("solvent"));
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (this.atoms[n].isProtein() || this.atoms[n].isNucleic()) {
                bitSet2.set(n);
            }
            n = bitSet.nextSetBit(n + 1);
        }
        BitSet[] bitSetArray = new BitSet[this.modelCount];
        for (int i = 0; i < this.modelCount; ++i) {
            bitSetArray[i] = this.viewer.getModelUndeletedAtomsBitSet(i);
            bitSetArray[i].andNot(bitSet2);
        }
        JmolMolecule[] jmolMoleculeArray = JmolMolecule.getMolecules(this.atoms, bitSetArray, null, bitSet2);
        for (int i = 0; i < jmolMoleculeArray.length; ++i) {
            BitSet bitSet3 = jmolMoleculeArray[i].atomList;
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            arrayList.add(hashtable2);
            hashtable2.put("atoms", Escape.escape(bitSet3));
            String string = "";
            String string2 = "";
            Group group = null;
            char c = '\u0000';
            String string3 = "";
            String string4 = "";
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = bitSet3.nextSetBit(0);
            while (n4 >= 0) {
                Atom atom = this.atoms[n4];
                if (group != atom.group) {
                    group = atom.group;
                    int n5 = atom.getResno();
                    char c2 = atom.getChainID();
                    if (n2 != n5 - 1) {
                        if (string3.length() != 0 && n2 != n3) {
                            string3 = string3 + "-" + n2;
                        }
                        c2 = '\u0001';
                        n3 = n5;
                    }
                    string4 = "/" + this.getModelNumberDotted(atom.modelIndex);
                    if (c != '\u0000' && c2 != c) {
                        string3 = string3 + ":" + c + string4;
                    }
                    if (c2 == '\u0001') {
                        string3 = string3 + " " + n5;
                    }
                    n2 = n5;
                    c = atom.getChainID();
                    string = string + string2 + atom.getGroup3(false);
                    string2 = "-";
                }
                n4 = bitSet3.nextSetBit(n4 + 1);
            }
            string3 = string3 + (n3 == n2 ? "" : "-" + n2) + (c == '\u0000' ? "" : ":" + c) + string4;
            hashtable2.put("groupNames", string);
            hashtable2.put("residueList", string3.substring(1));
        }
        return hashtable;
    }

    public Map<String, Object> getModelInfo(BitSet bitSet) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", this.modelSetName);
        hashtable.put("modelCount", this.modelCount);
        hashtable.put("isTainted", this.tainted != null);
        hashtable.put("canSkipLoad", this.canSkipLoad);
        hashtable.put("modelSetHasVibrationVectors", this.modelSetHasVibrationVectors());
        if (this.modelSetProperties != null) {
            hashtable.put("modelSetProperties", this.modelSetProperties);
        }
        hashtable.put("modelCountSelected", BitSetUtil.cardinalityOf(bitSet));
        hashtable.put("modelsSelected", bitSet);
        ArrayList arrayList = new ArrayList();
        this.getMolecules();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Float f;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", n);
            hashtable2.put("num", this.getModelNumber(n));
            hashtable2.put("file_model", this.getModelNumberDotted(n));
            hashtable2.put("name", this.getModelName(n));
            String string = this.getModelTitle(n);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = this.getModelFileName(n)) != null) {
                hashtable2.put("file", string);
            }
            if ((string = (String)this.getModelAuxiliaryInfo(n, "modelID")) != null) {
                hashtable2.put("id", string);
            }
            hashtable2.put("vibrationVectors", this.modelHasVibrationVectors(n));
            hashtable2.put("atomCount", this.models[n].atomCount);
            hashtable2.put("bondCount", this.models[n].getBondCount());
            hashtable2.put("groupCount", this.models[n].getGroupCount());
            hashtable2.put("moleculeCount", this.models[n].moleculeCount);
            hashtable2.put("polymerCount", this.models[n].getBioPolymerCount());
            hashtable2.put("chainCount", this.getChainCountInModel(n, true));
            if (this.models[n].properties != null) {
                hashtable2.put("modelProperties", this.models[n].properties);
            }
            if ((f = (Float)this.getModelAuxiliaryInfo(n, "Energy")) != null) {
                hashtable2.put("energy", f);
            }
            hashtable2.put("atomCount", this.models[n].atomCount);
            arrayList.add(hashtable2);
            n = bitSet.nextSetBit(n + 1);
        }
        hashtable.put("models", arrayList);
        return hashtable;
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public String getAltLocListInModel(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        return string == null ? "" : string;
    }

    private String getInsertionListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        return string == null ? "" : string;
    }

    public int getModelSymmetryCount(int n) {
        String[] stringArray;
        return this.models[n].biosymmetryCount > 0 || this.unitCells == null || this.unitCells[n] == null || (stringArray = this.unitCells[n].getSymmetryOperations()) == null ? this.models[n].biosymmetryCount : stringArray.length;
    }

    public String getSymmetryOperation(int n, String string, int n2, Point3f point3f, Point3f point3f2, String string2, boolean bl) {
        Map<String, Object> map = this.getSpaceGroupInfo(n, string, n2, point3f, point3f2, string2);
        if (map == null) {
            return "";
        }
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        --n2;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || n2 >= 0 && n2 != i) continue;
            if (string2 != null) {
                return (String)objectArray[i][3];
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            if (!bl) {
                if (n2 < 0) {
                    stringBuffer.append(i + 1).append("\t");
                }
                stringBuffer.append(objectArray[i][0]).append("\t");
            }
            stringBuffer.append(objectArray[i][2]);
        }
        if (stringBuffer.length() == 0 && string2 != null) {
            stringBuffer.append("draw " + string2 + "* delete");
        }
        return stringBuffer.toString();
    }

    public int[] getModelCellRange(int n) {
        if (this.unitCells == null) {
            return null;
        }
        return this.unitCells[n].getCellRange();
    }

    public boolean modelHasVibrationVectors(int n) {
        if (this.vibrationVectors != null) {
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (n >= 0 && this.atoms[n2].modelIndex != n || this.vibrationVectors[n2] == null || !(this.vibrationVectors[n2].length() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public BitSet getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            bitSet.or(this.elementsPresent[i]);
        }
        return bitSet;
    }

    private String getSymmetryInfoAsString(int n) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        return symmetryInterface == null ? "no symmetry information" : symmetryInterface.getSymmetryInfoString();
    }

    public List<Map<String, Object>> getMoleculeInfo(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.moleculeCount; ++i) {
            bitSet2 = BitSetUtil.copy(bitSet);
            JmolMolecule jmolMolecule = this.molecules[i];
            bitSet2.and(jmolMolecule.atomList);
            if (bitSet2.length() <= 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("mf", jmolMolecule.getMolecularFormula(false));
            hashtable.put("number", jmolMolecule.moleculeIndex + 1);
            hashtable.put("modelNumber", this.getModelNumberDotted(jmolMolecule.modelIndex));
            hashtable.put("numberInModel", jmolMolecule.indexInModel + 1);
            hashtable.put("nAtoms", jmolMolecule.atomCount);
            hashtable.put("nElements", jmolMolecule.nElements);
            arrayList.add(hashtable);
        }
        return arrayList;
    }

    public int getMoleculeIndex(int n, boolean bl) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return bl ? this.molecules[i].indexInModel : i;
        }
        return 0;
    }

    public BitSet getMoleculeBitSet(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bitSet2 = BitSetUtil.copy(bitSet);
        BitSet bitSet3 = BitSetUtil.copy(bitSet);
        int n = 0;
        BitSet bitSet4 = new BitSet();
        while ((n = bitSet3.length() - 1) >= 0) {
            bitSet4 = this.getMoleculeBitSet(n);
            if (bitSet4 == null) {
                bitSet3.clear(n);
                bitSet2.clear(n);
                continue;
            }
            bitSet3.andNot(bitSet4);
            bitSet2.or(bitSet4);
        }
        return bitSet2;
    }

    public BitSet getMoleculeBitSet(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public Vector3f getModelDipole(int n) {
        if (n < 0) {
            return null;
        }
        Vector3f vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "dipole");
        if (vector3f == null) {
            vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "DIPOLE_VEC");
        }
        return vector3f;
    }

    public Vector3f calculateMolecularDipole(int n) {
        if (this.partialCharges == null || n < 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != n) continue;
            float f3 = this.partialCharges[i];
            if (f3 < 0.0f) {
                ++n3;
                f2 += f3;
                vector3f2.scaleAdd(f3, this.atoms[i], vector3f2);
                continue;
            }
            if (!(f3 > 0.0f)) continue;
            ++n2;
            f += f3;
            vector3f.scaleAdd(f3, this.atoms[i], vector3f);
        }
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        vector3f.scale(1.0f / f);
        vector3f2.scale(1.0f / f2);
        vector3f.sub(vector3f2);
        Logger.warn("CalculateMolecularDipole: this is an approximate result -- needs checking");
        vector3f.scale(f * 4.8f);
        return vector3f;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        if (n < 0) {
            return this.moleculeCount;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (n != i) continue;
            n2 += this.models[i].moleculeCount;
        }
        return n2;
    }

    public void calcSelectedMoleculesCount(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.moleculeCount; ++i) {
            BitSetUtil.copy(bitSet, bitSet2);
            bitSet2.and(this.molecules[i].atomList);
            if (bitSet2.length() <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    public void setCentroid(int n, int n2, int[] nArray) {
        try {
            SymmetryInterface symmetryInterface = this.getUnitCell(this.atoms[n].modelIndex);
            if (symmetryInterface == null) {
                return;
            }
            BitSet bitSet = new BitSet();
            this.getMolecules();
            boolean bl = this.molecules[this.moleculeCount - 1].firstAtomIndex == this.models[this.atoms[n2].modelIndex].firstAtomIndex;
            Point3f point3f = new Point3f();
            boolean bl2 = nArray[6] == 1;
            int n3 = this.moleculeCount;
            block2: while (--n3 >= 0 && this.molecules[n3].firstAtomIndex >= n && this.molecules[n3].firstAtomIndex < n2) {
                BitSet bitSet2 = this.molecules[n3].atomList;
                point3f.set(0.0f, 0.0f, 0.0f);
                int n4 = 0;
                int n5 = bitSet2.nextSetBit(0);
                while (n5 >= 0) {
                    if (bl || bl2) {
                        point3f.set(this.atoms[n5]);
                        if (ModelCollection.isNotCentroid(point3f, 1, symmetryInterface, nArray, bl2)) {
                            if (bl) {
                                bitSet.set(n5);
                            }
                        } else if (!bl) {
                            continue block2;
                        }
                    } else {
                        point3f.add(this.atoms[n5]);
                        ++n4;
                    }
                    n5 = bitSet2.nextSetBit(n5 + 1);
                }
                if (!bl2 && (n4 <= 0 || !ModelCollection.isNotCentroid(point3f, n4, symmetryInterface, nArray, false))) continue;
                bitSet.or(bitSet2);
            }
            if (bitSet.nextSetBit(0) >= 0) {
                this.viewer.deleteAtoms(bitSet, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isNotCentroid(Point3f point3f, int n, SymmetryInterface symmetryInterface, int[] nArray, boolean bl) {
        point3f.scale(1.0f / (float)n);
        symmetryInterface.toFractional(point3f, false);
        if (bl) {
            return point3f.x + 5.0E-6f <= (float)nArray[0] || point3f.x - 5.0E-6f > (float)nArray[3] || point3f.y + 5.0E-6f <= (float)nArray[1] || point3f.y - 5.0E-6f > (float)nArray[4] || point3f.z + 5.0E-6f <= (float)nArray[2] || point3f.z - 5.0E-6f > (float)nArray[5];
        }
        return point3f.x + 5.0E-6f <= (float)nArray[0] || point3f.x + 1.0E-5f > (float)nArray[3] || point3f.y + 5.0E-6f <= (float)nArray[1] || point3f.y + 1.0E-5f > (float)nArray[4] || point3f.z + 5.0E-6f <= (float)nArray[2] || point3f.z + 1.0E-5f > (float)nArray[5];
    }

    public JmolMolecule[] getMolecules() {
        int n;
        if (this.moleculeCount > 0) {
            return this.molecules;
        }
        if (this.molecules == null) {
            this.molecules = new JmolMolecule[4];
        }
        this.moleculeCount = 0;
        Model model = null;
        BitSet[] bitSetArray = new BitSet[this.modelCount];
        List<BitSet> list = null;
        for (n = 0; n < this.modelCount; ++n) {
            bitSetArray[n] = this.viewer.getModelUndeletedAtomsBitSet(n);
            model = this.models[n];
            model.moleculeCount = 0;
            list = model.getBioBranches(list);
        }
        this.molecules = JmolMolecule.getMolecules(this.atoms, bitSetArray, list, null);
        n = this.moleculeCount = this.molecules.length;
        while (--n >= 0) {
            model = this.models[this.molecules[n].modelIndex];
            model.firstMoleculeIndex = n;
            ++model.moleculeCount;
        }
        return this.molecules;
    }

    protected void initializeBspf() {
        if (this.bspf != null && this.bspf.isInitialized()) {
            return;
        }
        if (Logger.debugging) {
            Logger.startTimer();
        }
        Bspf bspf = new Bspf(3);
        Logger.debug("sequential bspt order");
        BitSet bitSet = new BitSet(this.modelCount);
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if (atom.isDeleted()) continue;
            bspf.addTuple(this.models[atom.modelIndex].trajectoryBaseIndex, atom);
            bitSet.set(atom.modelIndex);
        }
        if (Logger.debugging) {
            Logger.checkTimer("Time to build bspf");
            bspf.stats();
        }
        n = bitSet.nextSetBit(0);
        while (n >= 0) {
            bspf.validate(n, true);
            n = bitSet.nextSetBit(n + 1);
        }
        bspf.validate(true);
        this.bspf = bspf;
    }

    protected void initializeBspt(int n) {
        this.initializeBspf();
        if (this.bspf.isInitialized(n)) {
            return;
        }
        this.bspf.initialize(n, this.atoms, this.viewer.getModelUndeletedAtomsBitSet(n));
    }

    public void setIteratorForPoint(AtomIndexIterator atomIndexIterator, int n, Point3f point3f, float f) {
        if (n < 0) {
            atomIndexIterator.set(point3f, f);
            return;
        }
        this.initializeBspt(n);
        atomIndexIterator.set(this, n, this.models[n].firstAtomIndex, Integer.MAX_VALUE, point3f, f, null);
    }

    public void setIteratorForAtom(AtomIndexIterator atomIndexIterator, int n, int n2, float f, RadiusData radiusData) {
        if (n < 0) {
            n = this.atoms[n2].modelIndex;
        }
        n = this.models[n].trajectoryBaseIndex;
        this.initializeBspt(n);
        atomIndexIterator.set(this, n, this.models[n].firstAtomIndex, n2, this.atoms[n2], f, radiusData);
    }

    public AtomIndexIterator getSelectedAtomIterator(BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AtomIteratorWithinModel atomIteratorWithinModel;
        this.initializeBspf();
        if (bl4) {
            BitSet bitSet2 = this.getModelBitSet(bitSet, false);
            int n = bitSet2.nextSetBit(0);
            while (n >= 0) {
                this.initializeBspt(n);
                n = bitSet2.nextSetBit(n + 1);
            }
            atomIteratorWithinModel = new AtomIteratorWithinModelSet(bitSet2);
        } else {
            atomIteratorWithinModel = new AtomIteratorWithinModel();
        }
        atomIteratorWithinModel.initialize(this.bspf, bitSet, bl, bl2, bl3, this.viewer.isParallel());
        return atomIteratorWithinModel;
    }

    @Override
    public int getBondCountInModel(int n) {
        return n < 0 ? this.bondCount : this.models[n].getBondCount();
    }

    public int calculateStruts(BitSet bitSet, BitSet bitSet2) {
        this.makeConnections(0.0f, Float.MAX_VALUE, 32768, 12291, bitSet, bitSet2, null, false, false, 0.0f);
        int n = bitSet.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        Model model = this.models[this.atoms[n].modelIndex];
        return model.isBioModel ? model.calculateStruts((ModelSet)this, bitSet, bitSet2) : 0;
    }

    public int getAtomCountInModel(int n) {
        return n < 0 ? this.atomCount : this.models[n].atomCount;
    }

    public BitSet getModelAtomBitSetIncludingDeleted(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        if (bitSet == null && this.bsAll == null) {
            this.bsAll = BitSetUtil.setAll(this.atomCount);
        }
        if (bitSet == null) {
            bitSet2.or(this.bsAll);
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bitSet2.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return bitSet2;
    }

    public BitSet getModelAtomBitSetIncludingDeleted(int n, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = n < 0 ? this.bsAll : this.models[n].bsAtoms;
        if (bitSet == null) {
            bitSet = this.bsAll = BitSetUtil.setAll(this.atomCount);
        }
        return bl ? BitSetUtil.copy(bitSet) : bitSet;
    }

    public BitSet getAtomBits(int n, Object object) {
        return BitSetUtil.andNot(this.getAtomBitsMaybeDeleted(n, object), this.viewer.getDeletedAtoms());
    }

    @Override
    protected BitSet getAtomBitsMaybeDeleted(int n, Object object) {
        switch (n) {
            default: {
                return super.getAtomBitsMaybeDeleted(n, object);
            }
            case 1073741864: {
                return this.getBasePairBits((String)object);
            }
            case 1679429641: {
                BoxInfo boxInfo = this.getBoxInfo((BitSet)object, 1.0f);
                BitSet bitSet = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                int n2 = bitSet.nextSetBit(0);
                while (n2 >= 0) {
                    if (!boxInfo.isWithin(this.atoms[n2])) {
                        bitSet.clear(n2);
                    }
                    n2 = bitSet.nextSetBit(n2 + 1);
                }
                return bitSet;
            }
            case 1095761934: {
                return this.getMoleculeBitSet((BitSet)object);
            }
            case 1087373320: {
                return this.getSequenceBits((String)object, null);
            }
            case 1048615: {
                int[] nArray = (int[])object;
                int n3 = nArray[0];
                int n4 = nArray[1];
                char c = (char)nArray[2];
                BitSet bitSet = new BitSet();
                boolean bl = this.viewer.getChainCaseSensitive();
                if (!bl) {
                    c = Character.toUpperCase(c);
                }
                int n5 = this.modelCount;
                while (--n5 >= 0) {
                    if (!this.models[n5].isBioModel) continue;
                    this.models[n5].selectSeqcodeRange(n3, n4, c, bitSet, bl);
                }
                return bitSet;
            }
            case 3145772: {
                BitSet bitSet = new BitSet(this.atomCount);
                short s = -1;
                int n6 = 0;
                int n7 = this.atomCount;
                block13: while (--n7 >= 0) {
                    Atom atom = this.atoms[n7];
                    BitSet bitSet2 = atom.getAtomSymmetry();
                    if (bitSet2 == null) continue;
                    if (atom.modelIndex != s) {
                        s = atom.modelIndex;
                        if (this.getModelCellRange(s) == null) continue;
                        n6 = this.getModelSymmetryCount(s);
                    }
                    int n8 = 0;
                    int n9 = n6;
                    while (--n9 >= 0) {
                        if (!bitSet2.get(n9) || ++n8 <= 1) continue;
                        bitSet.set(n7);
                        continue block13;
                    }
                }
                return bitSet;
            }
            case 1089470478: {
                return BitSetUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = new BitSet(this.atomCount)) : this.bsSymmetry);
            }
            case 1614417948: {
                BitSet bitSet = new BitSet();
                SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                if (symmetryInterface == null) {
                    return bitSet;
                }
                Point3f point3f = new Point3f(1.0f, 1.0f, 1.0f);
                Point3f point3f2 = new Point3f();
                int n10 = this.atomCount;
                while (--n10 >= 0) {
                    if (!this.isInLatticeCell(n10, point3f, point3f2, false)) continue;
                    bitSet.set(n10);
                }
                return bitSet;
            }
            case 1095761925: 
        }
        BitSet bitSet = new BitSet();
        int[] nArray = (int[])object;
        Point3f point3f = new Point3f((float)nArray[0] / 1000.0f, (float)nArray[1] / 1000.0f, (float)nArray[2] / 1000.0f);
        Point3f point3f3 = new Point3f();
        boolean bl = !this.viewer.getFractionalRelative();
        int n11 = this.atomCount;
        while (--n11 >= 0) {
            if (!this.isInLatticeCell(n11, point3f, point3f3, bl)) continue;
            bitSet.set(n11);
        }
        return bitSet;
    }

    private boolean isInLatticeCell(int n, Point3f point3f, Point3f point3f2, boolean bl) {
        short s = this.atoms[n].modelIndex;
        SymmetryInterface symmetryInterface = this.getUnitCell(s);
        if (symmetryInterface == null) {
            return false;
        }
        point3f2.set(this.atoms[n]);
        symmetryInterface.toFractional(point3f2, bl);
        float f = 0.02f;
        if (point3f2.x < point3f.x - 1.0f - f || point3f2.x > point3f.x + f) {
            return false;
        }
        if (point3f2.y < point3f.y - 1.0f - f || point3f2.y > point3f.y + f) {
            return false;
        }
        return !(point3f2.z < point3f.z - 1.0f - f) && !(point3f2.z > point3f.z + f);
    }

    public BitSet getAtomsWithin(float f, BitSet bitSet, boolean bl, RadiusData radiusData) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = this.getIterativeModels(false);
        bitSet = BitSetUtil.andNot(bitSet, this.viewer.getDeletedAtoms());
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        if (bl) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                int n2 = this.modelCount;
                while (--n2 >= 0) {
                    if (!bitSet3.get(n2)) continue;
                    if (f < 0.0f) {
                        this.getAtomsWithin(f, this.atoms[n].getFractionalUnitCoord(true), bitSet2, -1);
                        continue;
                    }
                    this.setIteratorForAtom(atomIndexIterator, n2, n, f, radiusData);
                    atomIndexIterator.addAtoms(bitSet2);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        } else {
            bitSet2.or(bitSet);
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (f < 0.0f) {
                    this.getAtomsWithin(f, this.atoms[n], bitSet2, this.atoms[n].modelIndex);
                } else {
                    this.setIteratorForAtom(atomIndexIterator, -1, n, f, radiusData);
                    atomIndexIterator.addAtoms(bitSet2);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }
        atomIndexIterator.release();
        return bitSet2;
    }

    public BitSet getGroupsWithin(int n, BitSet bitSet) {
        BitSet bitSet2 = this.getIterativeModels(false);
        BitSet bitSet3 = new BitSet();
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (!bitSet2.get(n2) || !this.models[n2].isBioModel) continue;
            this.models[n2].getGroupsWithin(n, bitSet, bitSet3);
        }
        return bitSet3;
    }

    public BitSet getAtomsWithin(float f, Point3f point3f, BitSet bitSet, int n) {
        if (bitSet == null) {
            bitSet = new BitSet();
        }
        if (f < 0.0f) {
            f = -f;
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                Atom atom = this.atoms[n2];
                if (n >= 0 && this.atoms[n2].modelIndex != n || bitSet.get(n2) || !(atom.getFractionalUnitDistance(point3f, point3f2, point3f3) <= f)) continue;
                bitSet.set(atom.index);
            }
            return bitSet;
        }
        BitSet bitSet2 = this.getIterativeModels(true);
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            if (!bitSet2.get(n3)) continue;
            this.setIteratorForAtom(atomIndexIterator, -1, this.models[n3].firstAtomIndex, -1.0f, null);
            atomIndexIterator.set(point3f, f);
            atomIndexIterator.addAtoms(bitSet);
        }
        atomIndexIterator.release();
        return bitSet;
    }

    private String getBasePairInfo(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Bond> arrayList = new ArrayList<Bond>();
        this.calcRasmolHydrogenBonds(bitSet, bitSet, arrayList, true, 1, false, null);
        int n = arrayList.size();
        while (--n >= 0) {
            Bond bond = (Bond)arrayList.get(n);
            ModelCollection.getAtomResidueInfo(stringBuffer, bond.atom1);
            stringBuffer.append(" - ");
            ModelCollection.getAtomResidueInfo(stringBuffer, bond.atom2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static void getAtomResidueInfo(StringBuffer stringBuffer, Atom atom) {
        stringBuffer.append("[").append(atom.getGroup3(false)).append("]").append(atom.getSeqcodeString()).append(":");
        char c = atom.getChainID();
        stringBuffer.append(c == '\u0000' ? " " : "" + c);
    }

    private BitSet getBasePairBits(String string) {
        BitSet bitSet = new BitSet();
        if (string.length() % 2 != 0) {
            return bitSet;
        }
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        ArrayList<Bond> arrayList = new ArrayList<Bond>();
        if (string.length() == 0) {
            bitSet2 = bitSet3 = this.viewer.getModelUndeletedAtomsBitSet(-1);
            this.calcRasmolHydrogenBonds(bitSet2, bitSet3, arrayList, true, 1, false, null);
        } else {
            int n = 0;
            while (n < string.length()) {
                if ((bitSet2 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0 || (bitSet3 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0) continue;
                this.calcRasmolHydrogenBonds(bitSet2, bitSet3, arrayList, true, 1, false, null);
            }
        }
        BitSet bitSet4 = new BitSet();
        int n = arrayList.size();
        while (--n >= 0) {
            Bond bond = (Bond)arrayList.get(n);
            bitSet4.set(bond.atom1.index);
            bitSet4.set(bond.atom2.index);
        }
        return super.getAtomBitsMaybeDeleted(1087373318, bitSet4);
    }

    public BitSet getSequenceBits(String string, BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.viewer.getModelUndeletedAtomsBitSet(-1);
        }
        BitSet bitSet2 = new BitSet();
        if (string.length() > 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (!this.models[i].isBioModel) continue;
                this.models[i].getSequenceBits(string, bitSet, bitSet2);
            }
        }
        return bitSet2;
    }

    @Override
    public void deleteBonds(BitSet bitSet, boolean bl) {
        if (!bl) {
            BitSet bitSet2 = new BitSet();
            BitSet bitSet3 = new BitSet();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                Atom atom = this.bonds[n].atom1;
                if (!this.models[atom.modelIndex].isModelKit) {
                    bitSet2.clear();
                    bitSet3.clear();
                    bitSet2.set(atom.index);
                    bitSet3.set(this.bonds[n].getAtomIndex2());
                    this.addStateScript("connect ", null, bitSet2, bitSet3, "delete", false, true);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }
        super.deleteBonds(bitSet, bl);
    }

    protected int[] makeConnections(float f, float f2, int n, int n2, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, float f3) {
        boolean bl3;
        boolean bl4;
        if (bitSet3 == null) {
            bitSet3 = new BitSet();
        }
        boolean bl5 = n == 65535;
        boolean bl6 = bl4 = n == 131071;
        if (bl4) {
            n = 1;
        }
        boolean bl7 = Bond.isHydrogen(n);
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        float f4 = f * f;
        float f5 = f2 * f2;
        switch (n2) {
            case 12291: {
                return this.deleteConnections(f, f2, n, bitSet, bitSet2, bl, bl4, f4, f5);
            }
            case 603979874: 
            case 1073741852: {
                if (n != 515) {
                    return this.autoBond(bitSet, bitSet2, bitSet3, bl, bl7, n2 == 603979874);
                }
                bl9 = true;
                bl11 = true;
                break;
            }
            case 1087373321: {
                bl8 = true;
                break;
            }
            case 1073742025: {
                bl9 = true;
                break;
            }
            case 0x40000050: {
                bl10 = true;
            }
        }
        this.defaultCovalentMad = this.viewer.getMadBond();
        boolean bl12 = f < 0.0f;
        boolean bl13 = bl3 = f2 < 0.0f;
        if (bl12) {
            f = -f;
        }
        if (bl3) {
            f2 = -f2;
        }
        short s = this.getDefaultMadFromOrder(n);
        int n3 = 0;
        int n4 = 0;
        Bond bond = null;
        int n5 = bl ? 1 : this.atomCount;
        Atom atom = null;
        Atom atom2 = null;
        float f6 = 0.0f;
        float f7 = 0.0f;
        short s2 = (short)(n | 0x20000);
        int n6 = bitSet.nextSetBit(0);
        while (n6 >= 0) {
            block28: {
                int n7;
                block27: {
                    block26: {
                        if (!bl) break block26;
                        bond = this.bonds[n6];
                        atom = bond.atom1;
                        atom2 = bond.atom2;
                        break block27;
                    }
                    atom = this.atoms[n6];
                    if (atom.isDeleted()) break block28;
                }
                int n8 = n7 = bl ? n5 : bitSet2.nextSetBit(0);
                while (n7 >= 0) {
                    block30: {
                        block29: {
                            if (bl) break block29;
                            if (n7 == n6) break block30;
                            atom2 = this.atoms[n7];
                            if (atom.modelIndex != atom2.modelIndex || atom2.isDeleted() || atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != '\u0000' && atom2.alternateLocationID != '\u0000') break block30;
                            bond = atom.getBond(atom2);
                        }
                        if (!(bond == null && (bl8 || bl9) || bond != null && bl10)) {
                            float f8 = atom.distanceSquared(atom2);
                            if (bl12 || bl3) {
                                f6 = atom.distance(atom2);
                                f7 = atom.getBondingRadiusFloat() + atom2.getBondingRadiusFloat();
                            }
                            if (!(!bl12 ? f8 < f4 : f6 < f7 * f) && !(!bl3 ? f8 > f5 : f6 > f7 * f2)) {
                                if (bond != null) {
                                    if (!bl8 && !bl5) {
                                        bond.setOrder(n);
                                        this.bsAromatic.clear(bond.index);
                                    }
                                    if (!bl8 || bl5 || n == bond.order || s2 == bond.order || bl7 && bond.isHydrogen()) {
                                        bitSet3.set(bond.index);
                                        ++n4;
                                    }
                                } else {
                                    bitSet3.set(this.bondAtoms((Atom)atom, (Atom)atom2, (int)n, (short)s, (BitSet)bitSet3, (float)f3, (boolean)bl2, (boolean)true).index);
                                    ++n3;
                                }
                            }
                        }
                    }
                    n7 = bl ? n7 - 1 : bitSet2.nextSetBit(n7 + 1);
                }
            }
            n6 = bitSet.nextSetBit(n6 + 1);
        }
        if (bl11) {
            this.assignAromaticBonds(true, bitSet3);
        }
        if (!bl8) {
            this.shapeManager.setShapeSize(1, Integer.MIN_VALUE, null, bitSet3);
        }
        return new int[]{n3, n4};
    }

    /*
     * Enabled aggressive block sorting
     */
    public int autoBond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, short s, boolean bl) {
        BitSet bitSet5;
        int n;
        boolean bl2;
        if (bl) {
            return this.autoBond_Pre_11_9_24(bitSet, bitSet2, bitSet3, bitSet4, s);
        }
        if (this.atomCount == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getBondTolerance();
        float f2 = this.viewer.getMinBondDistance();
        float f3 = f2 * f2;
        int n2 = 0;
        Logger.startTimer();
        short s2 = -1;
        boolean bl3 = bl2 = bitSet == null;
        if (bl2) {
            n = 0;
            bitSet5 = null;
        } else {
            if (bitSet.equals(bitSet2)) {
                bitSet5 = bitSet;
            } else {
                bitSet5 = BitSetUtil.copy(bitSet);
                bitSet5.or(bitSet2);
            }
            n = bitSet5.nextSetBit(0);
        }
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, true, false);
        int n3 = n;
        while (true) {
            block11: {
                boolean bl4;
                float f4;
                Atom atom;
                boolean bl5;
                boolean bl6;
                block13: {
                    block10: {
                        block12: {
                            if (n3 < 0 || n3 >= this.atomCount) break block10;
                            bl6 = bl2 || bitSet.get(n3);
                            bl5 = bl2 || bitSet2.get(n3);
                            atom = this.atoms[n3];
                            if (atom.isDeleted()) break block11;
                            short s3 = atom.modelIndex;
                            if (s3 == s2) break block12;
                            s2 = s3;
                            if (!this.isJmolDataFrame(s3)) break block12;
                            n3 = this.models[s3].firstAtomIndex + this.models[s3].atomCount - 1;
                            break block11;
                        }
                        if ((f4 = atom.getBondingRadiusFloat()) == 0.0f) break block11;
                        bl4 = bitSet3 != null && bitSet3.get(n3);
                        float f5 = f4 + this.maxBondingRadius + f;
                        this.setIteratorForAtom(atomIndexIterator, -1, n3, f5, null);
                        break block13;
                    }
                    Logger.checkTimer("Time to autoBond");
                    return n2;
                }
                while (atomIndexIterator.hasNext()) {
                    short s4;
                    boolean bl7;
                    Atom atom2 = this.atoms[atomIndexIterator.next()];
                    if (atom2.isDeleted()) continue;
                    int n4 = atom2.index;
                    boolean bl8 = bl2 || bitSet.get(n4);
                    boolean bl9 = bl7 = bl2 || bitSet2.get(n4);
                    if (!bl8 && !bl7 || (!bl6 || !bl7) && (!bl5 || !bl8) || bl4 && bitSet3.get(n4) || (s4 = ModelCollection.getBondOrder(f4, atom2.getBondingRadiusFloat(), atomIndexIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bitSet4)) continue;
                    ++n2;
                }
                atomIndexIterator.release();
            }
            n3 = bl2 ? n3 + 1 : bitSet5.nextSetBit(n3 + 1);
        }
    }

    private int autoBond_Pre_11_9_24(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, short s) {
        if (this.atomCount == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getBondTolerance();
        float f2 = this.viewer.getMinBondDistance();
        float f3 = f2 * f2;
        int n = 0;
        this.initializeBspf();
        if (Logger.debugging) {
            Logger.startTimer();
        }
        short s2 = -1;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            float f4;
            Atom atom;
            boolean bl;
            boolean bl2 = bitSet == null || bitSet.get(n2);
            boolean bl3 = bl = bitSet2 == null || bitSet2.get(n2);
            if (!bl2 && !bl || (atom = this.atoms[n2]).isDeleted()) continue;
            short s3 = atom.modelIndex;
            if (s3 != s2) {
                s2 = s3;
                if (this.isJmolDataFrame(s3)) {
                    while (--n2 >= 0 && this.atoms[n2].modelIndex == s3) {
                    }
                    ++n2;
                    continue;
                }
            }
            if ((f4 = atom.getBondingRadiusFloat()) == 0.0f) continue;
            float f5 = f4 + this.maxBondingRadius + f;
            this.initializeBspt(s3);
            CubeIterator cubeIterator = this.bspf.getCubeIterator(s3);
            cubeIterator.initialize(atom, f5, true);
            while (cubeIterator.hasMoreElements()) {
                short s4;
                boolean bl4;
                Atom atom2 = (Atom)cubeIterator.nextElement();
                if (atom2 == atom || atom2.isDeleted()) continue;
                int n3 = atom2.index;
                boolean bl5 = bitSet == null || bitSet.get(n3);
                boolean bl6 = bl4 = bitSet2 == null || bitSet2.get(n3);
                if (!bl5 && !bl4 || bitSet3 != null && bitSet3.get(n3) && bitSet3.get(n2) || (!bl2 || !bl4) && (!bl || !bl5) || (s4 = ModelCollection.getBondOrder(f4, atom2.getBondingRadiusFloat(), cubeIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bitSet4)) continue;
                ++n;
            }
            cubeIterator.release();
        }
        if (Logger.debugging) {
            Logger.checkTimer("Time to autoBond");
        }
        return n;
    }

    private int[] autoBond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            BitSet bitSet4 = bitSet;
            bitSet = new BitSet();
            bitSet2 = new BitSet();
            int n = bitSet4.nextSetBit(0);
            while (n >= 0) {
                bitSet.set(this.bonds[n].atom1.index);
                bitSet2.set(this.bonds[n].atom2.index);
                n = bitSet4.nextSetBit(n + 1);
            }
        }
        return new int[]{bl2 ? this.autoHbond(bitSet, bitSet2, false) : this.autoBond(bitSet, bitSet2, null, bitSet3, this.viewer.getMadBond(), bl3), 0};
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2, boolean bl) {
        int n;
        if (bl) {
            BitSet bitSet3 = this.getModelBitSet(bitSet, false);
            n = bitSet3.nextSetBit(0);
            while (n >= 0 && bl) {
                bl = !this.models[n].hasRasmolHBonds;
                n = bitSet3.nextSetBit(n + 1);
            }
            if (bl) {
                return 0;
            }
        }
        boolean bl2 = false;
        n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (this.atoms[n].getElementNumber() == 1) {
                bl2 = true;
                break;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        BitSet bitSet4 = new BitSet();
        boolean bl3 = this.viewer.getHbondsRasmol();
        if (bitSet2 == null || bl3 && !bl2) {
            Logger.info((bitSet2 == null ? "DSSP " : "RasMol") + " pseudo-hbond calculation");
            this.calcRasmolHydrogenBonds(bitSet, bitSet2, null, false, Integer.MAX_VALUE, false, bitSet4);
            return -BitSetUtil.cardinalityOf(bitSet4);
        }
        Logger.info(bl2 ? "Standard Hbond calculation" : "Jmol pseudo-hbond calculation");
        BitSet bitSet5 = null;
        if (!bl2) {
            bitSet5 = new BitSet();
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                byte by = this.atoms[n2].atomID;
                switch (by) {
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 64: {
                        bitSet5.set(n2);
                    }
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        float f = this.viewer.getHbondsDistanceMax();
        float f2 = (float)((double)this.viewer.getHbondsAngleMin() * Math.PI / 180.0);
        float f3 = f * f;
        float f4 = hbondMin * hbondMin;
        float f5 = 1.0f;
        float f6 = f > hbondMin ? f4 : f3;
        float f7 = f > hbondMin ? hbondMin : f;
        int n3 = 0;
        float f8 = 0.0f;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        if (Logger.debugging) {
            Logger.startTimer();
        }
        Point3f point3f = null;
        Point3f point3f2 = null;
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(bitSet2, false, false, false, false);
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            block19: {
                boolean bl4;
                float f9;
                float f10;
                float f11;
                short s;
                Object object;
                boolean bl5;
                Atom atom;
                block21: {
                    block20: {
                        atom = this.atoms[n4];
                        short s2 = atom.getElementNumber();
                        boolean bl6 = bl5 = s2 == 1;
                        if (!bl5 && (bl2 || s2 != 7 && s2 != 8) || bl5 && !bl2) break block19;
                        if (!bl5) break block20;
                        object = atom.bonds;
                        if (object == null) break block19;
                        s = 0;
                        for (int i = 0; i < ((Bond[])object).length && s == 0; ++i) {
                            Atom atom2 = object[i].getOtherAtom(atom);
                            short s3 = atom2.getElementNumber();
                            s = s3 == 7 || s3 == 8 ? (short)1 : 0;
                        }
                        if (s == 0) break block19;
                        f11 = f7;
                        f10 = f5;
                        f9 = f6;
                        bl4 = false;
                        break block21;
                    }
                    f11 = f;
                    f10 = f4;
                    f9 = f3;
                    bl4 = bitSet5.get(n4);
                }
                this.setIteratorForAtom(atomIndexIterator, -1, atom.index, f11, null);
                while (atomIndexIterator.hasNext()) {
                    int n5;
                    object = this.atoms[atomIndexIterator.next()];
                    s = ((Atom)object).getElementNumber();
                    if (object == atom || !bl5 && s != 7 && s != 8 || bl5 && s == 1 || (f8 = atomIndexIterator.foundDistance2()) < f10 || f8 > f9 || bl4 && bitSet5.get(((Atom)object).index) || atom.isBonded((Atom)object)) continue;
                    if (f2 > 0.0f) {
                        vector3f.sub(atom, (Tuple3f)object);
                        point3f2 = ModelCollection.checkMinAttachedAngle(atom, f2, vector3f, vector3f2, bl2);
                        if (point3f2 == null) continue;
                        vector3f.scale(-1.0f);
                        point3f = ModelCollection.checkMinAttachedAngle((Atom)object, f2, vector3f, vector3f2, bl2);
                        if (point3f == null) continue;
                    }
                    float f12 = 0.0f;
                    if (bl5 && !Float.isNaN(point3f.x) && !Float.isNaN(point3f2.x)) {
                        n5 = 4096;
                        f12 = (float)HBond.getEnergy((float)Math.sqrt(f8), point3f.distance(atom), point3f.distance(point3f2), ((Point3f)object).distance(point3f2)) / 1000.0f;
                    } else {
                        n5 = 2048;
                    }
                    bitSet4.set(this.addHBond(atom, (Atom)object, n5, f12));
                    ++n3;
                }
            }
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        atomIndexIterator.release();
        this.shapeManager.setShapeSize(1, Integer.MIN_VALUE, null, bitSet4);
        if (Logger.debugging) {
            Logger.checkTimer("Time to hbond");
        }
        return bl2 ? n3 : -n3;
    }

    private static Point3f checkMinAttachedAngle(Atom atom, float f, Vector3f vector3f, Vector3f vector3f2, boolean bl) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null || bondArray.length == 0) {
            return new Point3f(Float.NaN, 0.0f, 0.0f);
        }
        Atom atom2 = null;
        float f2 = Float.MAX_VALUE;
        int n = bondArray.length;
        while (--n >= 0) {
            if (!bondArray[n].isCovalent()) continue;
            Atom atom3 = bondArray[n].getOtherAtom(atom);
            if (!bl && atom3.getElementNumber() == 1) continue;
            vector3f2.sub(atom, atom3);
            float f3 = vector3f2.angle(vector3f);
            if (f3 < f) {
                return null;
            }
            if (!(f3 < f2)) continue;
            atom2 = atom3;
            f2 = f3;
        }
        return atom2;
    }

    void setStructureIds() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            int n5;
            int n6 = this.atoms[i].modelIndex;
            n3 = n6;
            if (n6 != n4) {
                n = 0;
                n4 = n3;
                n2 = -1;
            }
            if ((n5 = this.atoms[i].getStrucNo()) == n2 || n5 == 0) continue;
            this.atoms[i].getGroup().setProteinStructureId(++n);
            n2 = n;
        }
    }

    public String getProteinStructureState(BitSet bitSet, boolean bl, boolean bl2, int n) {
        if (!this.isPDB) {
            return "";
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isBioModel) continue;
            return this.models[i].getProteinStructureState(bitSet, bl, bl2, n);
        }
        return "";
    }

    public String getModelInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("<models count=\"");
        stringBuffer.append(this.modelCount).append("\" modelSetHasVibrationVectors=\"").append(this.modelSetHasVibrationVectors() + "\">\n<properties>");
        if (this.modelSetProperties != null) {
            Enumeration<?> enumeration = this.modelSetProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n <property name=\"").append(string).append("\" value=").append(Escape.escape(this.modelSetProperties.getProperty(string))).append(" />");
            }
            stringBuffer.append("\n</properties>");
        }
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\n<model index=\"").append(i).append("\" n=\"").append(this.getModelNumberDotted(i)).append("\" id=").append(Escape.escape("" + this.getModelAuxiliaryInfo(i, "modelID")));
            int n = this.getBaseModelIndex(i);
            if (n != i) {
                stringBuffer.append(" baseModelId=").append(Escape.escape(this.getModelAuxiliaryInfo(n, "jdxModelID")));
            }
            stringBuffer.append(" name=").append(Escape.escape(this.getModelName(i))).append(" title=").append(Escape.escape(this.getModelTitle(i))).append(" hasVibrationVectors=\"").append(this.modelHasVibrationVectors(i)).append("\" />");
        }
        stringBuffer.append("\n</models>");
        return stringBuffer.toString();
    }

    public String getSymmetryInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("Symmetry Information:");
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n").append(this.getSymmetryInfoAsString(i));
        }
        return stringBuffer.toString();
    }

    public BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        int n2;
        int n3;
        BitSet bitSet2 = new BitSet();
        int[] nArray = new int[this.atomCount];
        boolean bl = n == 30720;
        boolean bl2 = n == 65535;
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bonds[n3];
            if (!bl2 && !bond.is(n) && (!bl || !bond.isHydrogen())) continue;
            if (bitSet.get(bond.atom1.index)) {
                n2 = bond.atom2.index;
                nArray[n2] = nArray[n2] + 1;
                bitSet2.set(n2);
            }
            if (!bitSet.get(bond.atom2.index)) continue;
            n2 = bond.atom1.index;
            nArray[n2] = nArray[n2] + 1;
            bitSet2.set(n2);
        }
        n3 = f == 0.0f ? 1 : 0;
        n2 = this.atomCount;
        while (--n2 >= 0) {
            int n4 = nArray[n2];
            if ((float)n4 < f || (float)n4 > f2) {
                bitSet2.clear(n2);
                continue;
            }
            if (n3 == 0 || n4 != 0) continue;
            bitSet2.set(n2);
        }
        return bitSet2;
    }

    public String getModelExtract(BitSet bitSet, boolean bl, boolean bl2, String string) {
        Quaternion quaternion;
        Object object;
        boolean bl3 = string.equalsIgnoreCase("V3000");
        boolean bl4 = string.equalsIgnoreCase("SDF");
        boolean bl5 = string.equalsIgnoreCase("XYZVIB");
        boolean bl6 = string.equalsIgnoreCase("CD");
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl5 && !bl6) {
            stringBuffer.append(bl2 ? "Jmol Model Kit" : this.viewer.getFullPathName().replace('\\', '/'));
            object = Viewer.getJmolVersion();
            Calendar calendar = Calendar.getInstance();
            stringBuffer.append("\n__Jmol-").append(((String)object).substring(0, 2));
            TextFormat.rFill(stringBuffer, "_00", "" + (1 + calendar.get(2)));
            TextFormat.rFill(stringBuffer, "00", "" + calendar.get(5));
            stringBuffer.append(("" + calendar.get(1)).substring(2, 4));
            TextFormat.rFill(stringBuffer, "00", "" + calendar.get(11));
            TextFormat.rFill(stringBuffer, "00", "" + calendar.get(12));
            stringBuffer.append("3D 1   1.00000     0.00000     0");
            stringBuffer.append("\nJmol version ").append(Viewer.getJmolVersion()).append(" EXTRACT: ").append(Escape.escape(bitSet)).append("\n");
        }
        object = BitSetUtil.copy(bitSet);
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (bl && this.atoms[n].isDeleted()) {
                ((BitSet)object).clear(n);
            }
            n = bitSet.nextSetBit(n + 1);
        }
        BitSet bitSet2 = this.getCovalentBondsForAtoms((BitSet)object);
        if (!bl5 && ((BitSet)object).cardinality() == 0) {
            return "";
        }
        boolean bl7 = true;
        Quaternion quaternion2 = quaternion = bl ? this.viewer.getRotationQuaternion() : null;
        if (bl4) {
            String string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            BitSet bitSet3 = this.getModelBitSet((BitSet)object, true);
            int n2 = bitSet3.nextSetBit(0);
            while (n2 >= 0) {
                stringBuffer.append(string2);
                BitSet bitSet4 = BitSetUtil.copy((BitSet)object);
                bitSet4.and(this.getModelAtomBitSetIncludingDeleted(n2, false));
                bitSet2 = this.getCovalentBondsForAtoms(bitSet4);
                bl7 = this.addMolFile(stringBuffer, bitSet4, bitSet2, false, false, quaternion);
                if (bl7) {
                    stringBuffer.append("$$$$\n");
                    n2 = bitSet3.nextSetBit(n2 + 1);
                    continue;
                }
                break;
            }
        } else if (bl5) {
            LabelToken[] labelTokenArray = LabelToken.compile(this.viewer, "%-2e %10.5x %10.5y %10.5z %10.5vx %10.5vy %10.5vz\n", '\u0000', null);
            LabelToken[] labelTokenArray2 = LabelToken.compile(this.viewer, "%-2e %10.5x %10.5y %10.5z\n", '\u0000', null);
            BitSet bitSet5 = this.getModelBitSet((BitSet)object, true);
            int n3 = bitSet5.nextSetBit(0);
            while (n3 >= 0) {
                BitSet bitSet6 = BitSetUtil.copy((BitSet)object);
                bitSet6.and(this.getModelAtomBitSetIncludingDeleted(n3, false));
                if (bitSet6.cardinality() != 0) {
                    stringBuffer.append(bitSet6.cardinality()).append('\n');
                    Properties properties = this.models[n3].properties;
                    stringBuffer.append("Model[" + (n3 + 1) + "]: ");
                    if (this.frameTitles[n3] != null && this.frameTitles[n3].length() > 0) {
                        stringBuffer.append(this.frameTitles[n3].replace('\n', ' '));
                    } else if (properties == null) {
                        stringBuffer.append("Jmol " + Viewer.getJmolVersion());
                    } else {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        Enumeration<?> enumeration = properties.propertyNames();
                        String string3 = null;
                        while (enumeration.hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            if (string4.equals(".PATH")) {
                                string3 = properties.getProperty(string4);
                                continue;
                            }
                            stringBuffer2.append(";").append(string4).append("=").append(properties.getProperty(string4));
                        }
                        if (string3 != null) {
                            stringBuffer2.append(";PATH=").append(string3);
                        }
                        string3 = stringBuffer2.substring(stringBuffer2.length() > 0 ? 1 : 0);
                        stringBuffer.append(string3.replace('\n', ' '));
                    }
                    stringBuffer.append('\n');
                    int n4 = bitSet6.nextSetBit(0);
                    while (n4 >= 0) {
                        stringBuffer.append(LabelToken.formatLabel(this.viewer, this.atoms[n4], this.getVibrationVector(n4, false) == null ? labelTokenArray2 : labelTokenArray, '\u0000', null));
                        n4 = bitSet6.nextSetBit(n4 + 1);
                    }
                }
                n3 = bitSet5.nextSetBit(n3 + 1);
            }
        } else {
            bl7 = this.addMolFile(stringBuffer, (BitSet)object, bitSet2, bl3, bl6, quaternion);
        }
        return bl7 ? stringBuffer.toString() : "ERROR: Too many atoms or bonds -- use V3000 format.";
    }

    private boolean addMolFile(StringBuffer stringBuffer, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, Quaternion quaternion) {
        float[] fArray;
        int n = bitSet.cardinality();
        int n2 = bitSet2.cardinality();
        if (!(bl || bl2 || n <= 999 && n2 <= 999)) {
            return false;
        }
        int[] nArray = new int[this.atomCount];
        Point3f point3f = new Point3f();
        if (bl) {
            stringBuffer.append("  0  0  0  0  0  0            999 V3000");
        } else if (bl2) {
            stringBuffer.append("{\"mol\":{\"scaling\":[20,-20,20],\"a\":[");
        } else {
            TextFormat.rFill(stringBuffer, "   ", "" + n);
            TextFormat.rFill(stringBuffer, "   ", "" + n2);
            stringBuffer.append("  0  0  0  0              1 V2000");
        }
        if (!bl2) {
            stringBuffer.append("\n");
        }
        if (bl) {
            stringBuffer.append("M  V30 BEGIN CTAB\nM  V30 COUNTS ").append(n).append(" ").append(n2).append(" 0 0 0\n").append("M  V30 BEGIN ATOM\n");
        }
        int n3 = bitSet.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            nArray[n3] = ++n4;
            this.getAtomRecordMOL(stringBuffer, nArray[n3], this.atoms[n3], quaternion, point3f, bl, bl2);
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        if (bl) {
            stringBuffer.append("M  V30 END ATOM\nM  V30 BEGIN BOND\n");
        } else if (bl2) {
            stringBuffer.append("],\"b\":[");
        }
        n3 = bitSet2.nextSetBit(0);
        n4 = 0;
        while (n3 >= 0) {
            this.getBondRecordMOL(stringBuffer, ++n4, this.bonds[n3], nArray, bl, bl2);
            n3 = bitSet2.nextSetBit(n3 + 1);
        }
        if (bl) {
            stringBuffer.append("M  V30 END BOND\nM  V30 END CTAB\n");
        }
        if (bl2) {
            stringBuffer.append("]}}");
        } else {
            stringBuffer.append("M  END\n");
        }
        if (!bl2 && !bl && (fArray = this.getPartialCharges()) != null) {
            stringBuffer.append("> <JMOL_PARTIAL_CHARGES>\n").append(n).append('\n');
            n4 = bitSet.nextSetBit(0);
            int n5 = 0;
            while (n4 >= 0) {
                stringBuffer.append(++n5).append(" ").append(fArray[n4]).append('\n');
                n4 = bitSet.nextSetBit(n4 + 1);
            }
        }
        return true;
    }

    private BitSet getCovalentBondsForAtoms(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.bondCount; ++i) {
            Bond bond = this.bonds[i];
            if (!bitSet.get(bond.atom1.index) || !bitSet.get(bond.atom2.index) || !bond.isCovalent()) continue;
            bitSet2.set(i);
        }
        return bitSet2;
    }

    private void getAtomRecordMOL(StringBuffer stringBuffer, int n, Atom atom, Quaternion quaternion, Point3f point3f, boolean bl, boolean bl2) {
        if (this.models[atom.modelIndex].isTrajectory) {
            atom.setFractionalCoord(this.ptTemp, this.trajectorySteps.get(atom.modelIndex)[atom.index - this.models[atom.modelIndex].firstAtomIndex], true);
        } else {
            point3f.set(atom);
        }
        if (quaternion != null) {
            quaternion.transform(point3f, point3f);
        }
        short s = atom.getElementNumber();
        String string = atom.isDeleted() ? "Xx" : Elements.elementSymbolFromNumber(s);
        int n2 = atom.getIsotopeNumber();
        int n3 = atom.getFormalCharge();
        if (bl) {
            stringBuffer.append("M  V30 ").append(n).append(" ").append(string).append(" ").append(point3f.x).append(" ").append(point3f.y).append(" ").append(point3f.z).append(" 0");
            if (n3 != 0) {
                stringBuffer.append(" CHG=").append(n3);
            }
            if (n2 != 0) {
                stringBuffer.append(" MASS=").append(n2);
            }
            stringBuffer.append("\n");
        } else if (bl2) {
            if (n != 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{");
            if (atom.getElementNumber() != 6) {
                stringBuffer.append("\"l\":\"").append(atom.getElementSymbol()).append("\",");
            }
            if (n3 != 0) {
                stringBuffer.append("\"c\":").append(n3).append(",");
            }
            if (n2 != 0 && n2 != Elements.getNaturalIsotope(s)) {
                stringBuffer.append("\"m\":").append(n2).append(",");
            }
            stringBuffer.append("\"x\":").append(atom.x * 20.0f).append(",\"y\":").append(-atom.y * 20.0f).append(",\"z\":").append(atom.z * 20.0f).append("}");
        } else {
            stringBuffer.append(TextFormat.sprintf("%10.5p%10.5p%10.5p", new Object[]{point3f}));
            stringBuffer.append(" ").append(string);
            if (string.length() == 1) {
                stringBuffer.append(" ");
            }
            if (n2 > 0) {
                n2 -= Elements.getNaturalIsotope(atom.getElementNumber());
            }
            stringBuffer.append(" ");
            TextFormat.rFill(stringBuffer, "  ", "" + n2);
            TextFormat.rFill(stringBuffer, "   ", "" + (n3 == 0 ? 0 : 4 - n3));
            stringBuffer.append("  0  0  0  0\n");
        }
    }

    private void getBondRecordMOL(StringBuffer stringBuffer, int n, Bond bond, int[] nArray, boolean bl, boolean bl2) {
        int n2 = nArray[bond.atom1.index];
        int n3 = nArray[bond.atom2.index];
        int n4 = bond.getValence();
        if (n4 > 3) {
            n4 = 1;
        }
        switch (bond.order & 0xFFFDFFFF) {
            case 515: {
                n4 = bl2 ? 2 : 4;
                break;
            }
            case 66: {
                n4 = bl2 ? 1 : 5;
                break;
            }
            case 513: {
                n4 = bl2 ? 1 : 6;
                break;
            }
            case 514: {
                n4 = bl2 ? 2 : 7;
                break;
            }
            case 33: {
                int n5 = n4 = bl2 ? 1 : 8;
            }
        }
        if (bl) {
            stringBuffer.append("M  V30 ").append(n).append(" ").append(n4).append(" ").append(n2).append(" ").append(n3).append('\n');
        } else if (bl2) {
            if (n != 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{\"b\":").append(n2 - 1).append(",\"e\":").append(n3 - 1);
            if (n4 != 1) {
                stringBuffer.append(",\"o\":").append(n4);
            }
            stringBuffer.append("}");
        } else {
            TextFormat.rFill(stringBuffer, "   ", "" + n2);
            TextFormat.rFill(stringBuffer, "   ", "" + n3);
            stringBuffer.append("  ").append(n4).append("  0  0  0\n");
        }
    }

    @Override
    public String getChimeInfo(int n, BitSet bitSet) {
        switch (n) {
            case 1073741982: {
                break;
            }
            case 1073741864: {
                return this.getBasePairInfo(bitSet);
            }
            default: {
                return super.getChimeInfo(n, bitSet);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.models[0].getChimeInfo(stringBuffer, 0);
        return stringBuffer.append('\n').toString().substring(1);
    }

    public String getModelFileInfo(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            String string = "[\"" + this.getModelNumberDotted(i) + "\"] = ";
            stringBuffer.append("\n\nfile").append(string).append(Escape.escape(this.getModelFileName(i)));
            String string2 = (String)this.getModelAuxiliaryInfo(i, "modelID");
            if (string2 != null) {
                stringBuffer.append("\nid").append(string).append(Escape.escape(string2));
            }
            stringBuffer.append("\ntitle").append(string).append(Escape.escape(this.getModelTitle(i)));
            stringBuffer.append("\nname").append(string).append(Escape.escape(this.getModelName(i)));
        }
        return stringBuffer.toString();
    }

    public Map<String, Object> getAuxiliaryInfo(BitSet bitSet) {
        Map<String, Object> map = this.modelSetAuxiliaryInfo;
        if (map == null) {
            return null;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            Map<String, Object> map2 = this.getModelAuxiliaryInfo(i);
            arrayList.add(map2);
        }
        map.put("models", arrayList);
        return map;
    }

    public List<Map<String, Object>> getAllAtomInfo(BitSet bitSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            arrayList.add(this.getAtomInfoLong(n));
            n = bitSet.nextSetBit(n + 1);
        }
        return arrayList;
    }

    public void getAtomIdentityInfo(int n, Map<String, Object> map) {
        map.put("_ipt", n);
        map.put("atomIndex", n);
        map.put("atomno", this.getAtomNumber(n));
        map.put("info", this.getAtomInfo(n, null));
        map.put("sym", this.getElementSymbol(n));
    }

    private Map<String, Object> getAtomInfoLong(int n) {
        Atom atom = this.atoms[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(n, hashtable);
        hashtable.put("element", this.getElementName(n));
        hashtable.put("elemno", this.getElementNumber(n));
        hashtable.put("x", Float.valueOf(atom.x));
        hashtable.put("y", Float.valueOf(atom.y));
        hashtable.put("z", Float.valueOf(atom.z));
        hashtable.put("coord", new Point3f(atom));
        if (this.vibrationVectors != null && this.vibrationVectors[n] != null) {
            hashtable.put("vibVector", new Vector3f(this.vibrationVectors[n]));
        }
        hashtable.put("bondCount", atom.getCovalentBondCount());
        hashtable.put("radius", Float.valueOf((float)((double)atom.getRasMolRadius() / 120.0)));
        hashtable.put("model", atom.getModelNumberForLabel());
        hashtable.put("shape", Atom.atomPropertyString(this.viewer, atom, 1087373323));
        hashtable.put("visible", atom.isVisible(0));
        hashtable.put("clickabilityFlags", atom.clickabilityFlags);
        hashtable.put("visibilityFlags", atom.shapeVisibilityFlags);
        hashtable.put("spacefill", Float.valueOf(atom.getRadius()));
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(atom.colixAtom));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", atom.colixAtom);
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", atom.getFormalCharge());
        hashtable.put("partialCharge", Float.valueOf(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", Float.valueOf(f));
        }
        if (this.models[atom.modelIndex].isBioModel) {
            hashtable.put("resname", atom.getGroup3(false));
            int n2 = atom.getSeqNumber();
            char c = atom.getInsertionCode();
            if (n2 > 0) {
                hashtable.put("resno", n2);
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            char c2 = atom.getChainID();
            hashtable.put("name", this.getAtomName(n));
            hashtable.put("chain", c2 == '\u0000' ? "" : "" + c2);
            hashtable.put("atomID", atom.atomID);
            hashtable.put("groupID", atom.getGroupID());
            if (atom.alternateLocationID != '\u0000') {
                hashtable.put("altLocation", "" + atom.alternateLocationID);
            }
            hashtable.put("structure", atom.getProteinStructureType().getId());
            hashtable.put("polymerLength", atom.getPolymerLength());
            hashtable.put("occupancy", atom.getOccupancy100());
            int n3 = atom.getBfactor100();
            hashtable.put("temp", n3 / 100);
        }
        return hashtable;
    }

    public List<Map<String, Object>> getAllBondInfo(BitSet bitSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        if (bitSet instanceof Bond.BondSet) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0 && n < this.bondCount) {
                arrayList.add(this.getBondInfo(n));
                n = bitSet.nextSetBit(n + 1);
            }
            return arrayList;
        }
        int n = bitSet.cardinality() == 1 ? bitSet.nextSetBit(0) : -1;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!(n >= 0 ? this.bonds[i].atom1.index == n || this.bonds[i].atom2.index == n : bitSet.get(this.bonds[i].atom1.index) && bitSet.get(this.bonds[i].atom2.index))) continue;
            arrayList.add(this.getBondInfo(i));
        }
        return arrayList;
    }

    private Map<String, Object> getBondInfo(int n) {
        Bond bond = this.bonds[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", n);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(atom.index, hashtable2);
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(atom2.index, hashtable3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", Float.valueOf(JmolEdge.getBondOrderNumberFromOrder(this.bonds[n].order)));
        hashtable.put("radius", Float.valueOf((float)((double)bond.mad / 2000.0)));
        hashtable.put("length_Ang", Float.valueOf(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(bond.colix));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", Integer.valueOf(bond.colix));
        boolean bl = bond.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        return hashtable;
    }

    public Map<String, List<Map<String, Object>>> getAllChainInfo(BitSet bitSet) {
        Hashtable<String, List<Map<String, Object>>> hashtable = new Hashtable<String, List<Map<String, Object>>>();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            List<Map<String, List<Map<String, Object>>>> list = this.getChainInfo(i, bitSet);
            if (list.size() <= 0) continue;
            hashtable2.put("modelIndex", i);
            hashtable2.put("chains", list);
            arrayList.add(hashtable2);
        }
        hashtable.put("models", arrayList);
        return hashtable;
    }

    private List<Map<String, List<Map<String, Object>>>> getChainInfo(int n, BitSet bitSet) {
        Model model = this.models[n];
        int n2 = model.getChainCount(true);
        ArrayList<Map<String, List<Map<String, Object>>>> arrayList = new ArrayList<Map<String, List<Map<String, Object>>>>();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChain(i);
            ArrayList<Map<String, Object>> arrayList2 = new ArrayList<Map<String, Object>>();
            int n3 = chain.getGroupCount();
            Hashtable<String, ArrayList<Map<String, Object>>> hashtable = new Hashtable<String, ArrayList<Map<String, Object>>>();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bitSet.get(group.firstAtomIndex)) continue;
                arrayList2.add(group.getGroupInfo(j));
            }
            if (arrayList2.isEmpty()) continue;
            hashtable.put("residues", arrayList2);
            arrayList.add(hashtable);
        }
        return arrayList;
    }

    public Map<String, List<Map<String, Object>>> getAllPolymerInfo(BitSet bitSet) {
        Hashtable<String, List<Map<String, Object>>> hashtable = new Hashtable<String, List<Map<String, Object>>>();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isBioModel) continue;
            this.models[i].getAllPolymerInfo(bitSet, hashtable, arrayList);
        }
        hashtable.put("models", arrayList);
        return hashtable;
    }

    public String getUnitCellInfoText() {
        int n = this.viewer.getCurrentModelIndex();
        if (n < 0) {
            return "no single current model";
        }
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        return symmetryInterface == null ? "not applicable" : symmetryInterface.getUnitCellInfo();
    }

    public Map<String, Object> getSpaceGroupInfo(int n, String string, int n2, Point3f point3f, Point3f point3f2, String string2) {
        Object object;
        String string3 = null;
        Map<String, Object> map = null;
        SymmetryInterface symmetryInterface = null;
        Object[][] objectArray = null;
        if (string == null) {
            if (n <= 0) {
                int n3 = n = point3f instanceof Atom ? ((Atom)point3f).modelIndex : this.viewer.getCurrentModelIndex();
            }
            if (n < 0) {
                string3 = "no single current model";
            } else {
                symmetryInterface = this.getUnitCell(n);
                if (symmetryInterface == null) {
                    string3 = "not applicable";
                }
            }
            if (string3 != null) {
                map = new Hashtable();
                map.put("spaceGroupInfo", string3);
                map.put("symmetryInfo", "");
            } else if (point3f == null && string2 == null && n2 != 0) {
                map = (Map)this.getModelAuxiliaryInfo(n, "spaceGroupInfo");
            }
            if (map != null) {
                return map;
            }
            map = new Hashtable();
            if (point3f == null && string2 == null && n2 == 0) {
                this.setModelAuxiliaryInfo(n, "spaceGroupInfo", map);
            }
            string = symmetryInterface.getSpaceGroupName();
            object = symmetryInterface.getSymmetryOperations();
            if (object == null) {
                string3 = "\n no symmetry operations employed";
            } else {
                this.getSymTemp(true);
                this.symTemp.setSpaceGroup(false);
                string3 = "\n" + ((String[])object).length + " symmetry operations employed:";
                objectArray = new Object[((String[])object).length][];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    int n4 = this.symTemp.addSpaceGroupOperation("=" + object[i], i + 1);
                    if (n4 < 0) continue;
                    Object[] objectArray2 = objectArray[i] = n2 > 0 && n2 - 1 != n4 ? null : this.symTemp.getSymmetryOperationDescription(n4, symmetryInterface, point3f, point3f2, string2);
                    if (objectArray[i] == null) continue;
                    string3 = string3 + "\n" + (i + 1) + "\t" + objectArray[i][0] + "\t" + objectArray[i][2];
                }
            }
        } else {
            map = new Hashtable<String, Object>();
        }
        map.put("spaceGroupName", string);
        this.getSymTemp(true);
        object = this.symTemp.getSpaceGroupInfo(string, symmetryInterface);
        if (objectArray != null) {
            map.put("operations", objectArray);
            map.put("symmetryInfo", string3);
        }
        if (object == null) {
            object = "could not identify space group from name: " + string + "\nformat: show spacegroup \"2\" or \"P 2c\" " + "or \"C m m m\" or \"x, y, z;-x ,-y, -z\"";
        }
        map.put("spaceGroupInfo", object);
        return map;
    }

    public Object getSymmetryInfo(BitSet bitSet, String string, int n, Point3f point3f, Point3f point3f2, String string2, int n2) {
        int n3;
        int n4 = -1;
        if (bitSet == null) {
            n4 = this.viewer.getCurrentModelIndex();
            if (n4 < 0) {
                return "";
            }
            bitSet = this.viewer.getModelUndeletedAtomsBitSet(n4);
        }
        if ((n3 = bitSet.nextSetBit(0)) < 0) {
            return "";
        }
        n4 = this.atoms[n3].modelIndex;
        SymmetryInterface symmetryInterface = this.getUnitCell(n4);
        if (symmetryInterface == null) {
            return "";
        }
        if (point3f2 != null) {
            return this.getSymmetryOperation(n4, null, n, point3f, point3f2, string2 == null ? "sym" : string2, n2 == 1826248715);
        }
        if (string == null) {
            String[] stringArray = symmetryInterface.getSymmetryOperations();
            if (stringArray == null || n == 0 || Math.abs(n) > stringArray.length) {
                return "";
            }
            string = n > 0 ? stringArray[n - 1] : stringArray[-1 - n];
        } else {
            n = 0;
        }
        this.getSymTemp(false);
        this.symTemp.setSpaceGroup(false);
        int n5 = this.symTemp.addSpaceGroupOperation((n < 0 ? "!" : "=") + string, Math.abs(n));
        if (n5 < 0) {
            return "";
        }
        this.symTemp.setUnitCell(symmetryInterface.getNotionalUnitCell());
        point3f = new Point3f(point3f == null ? this.atoms[n3] : point3f);
        if (n2 == 0x8100010) {
            symmetryInterface.toFractional(point3f, false);
            if (Float.isNaN(point3f.x)) {
                return "";
            }
            Point3f point3f3 = new Point3f();
            this.symTemp.newSpaceGroupPoint(n5, point3f, point3f3, 0, 0, 0);
            this.symTemp.toCartesian(point3f3, false);
            return point3f3;
        }
        Object[] objectArray = this.symTemp.getSymmetryOperationDescription(n5, symmetryInterface, point3f, point3f2, string2 == null ? "sym" : string2);
        int n6 = (Integer)objectArray[9];
        switch (n2) {
            case 135266306: {
                return objectArray;
            }
            case 1073742001: {
                String[] stringArray = new String[]{(String)objectArray[0], (String)objectArray[1], (String)objectArray[2], Escape.escape((Vector3f)objectArray[4]), Escape.escape((Vector3f)objectArray[5]), Escape.escape((Point3f)objectArray[6]), Escape.escape((Point3f)objectArray[7]), Escape.escape((Vector3f)objectArray[8]), "" + objectArray[9], "" + Escape.escape(objectArray[10])};
                return stringArray;
            }
            case 1073741982: {
                return objectArray[0];
            }
            default: {
                return objectArray[2];
            }
            case 135176: {
                return objectArray[3];
            }
            case 1073742178: {
                return objectArray[5];
            }
            case 12289: {
                return objectArray[6];
            }
            case 0x8100010: {
                return objectArray[7];
            }
            case 135266319: 
            case 1073741854: {
                return n6 == 0 == (n2 == 135266319) ? (Vector3f)objectArray[8] : null;
            }
            case 0x8100001: {
                return objectArray[9];
            }
            case 12: 
        }
        return objectArray[10];
    }

    private void getSymTemp(boolean bl) {
        if (this.symTemp == null || bl) {
            this.symTemp = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
    }

    protected void deleteModel(int n, int n2, int n3, BitSet bitSet, BitSet bitSet2) {
        int n4;
        if (n < 0) {
            this.validateBspf(false);
            this.bsAll = null;
            this.resetMolecules();
            this.isBbcageDefault = false;
            this.calcBoundBoxDimensions(null, 1.0f);
            return;
        }
        this.modelNumbers = (int[])ArrayUtil.deleteElements(this.modelNumbers, n, 1);
        this.modelFileNumbers = (int[])ArrayUtil.deleteElements(this.modelFileNumbers, n, 1);
        this.modelNumbersForAtomLabel = (String[])ArrayUtil.deleteElements(this.modelNumbersForAtomLabel, n, 1);
        this.modelNames = (String[])ArrayUtil.deleteElements(this.modelNames, n, 1);
        this.frameTitles = (String[])ArrayUtil.deleteElements(this.frameTitles, n, 1);
        this.thisStateModel = -1;
        String[] stringArray = (String[])this.getModelSetAuxiliaryInfo("group3Lists");
        int[][] nArray = (int[][])this.getModelSetAuxiliaryInfo("group3Counts");
        int n5 = n + 1;
        if (stringArray != null && stringArray[n5] != null) {
            n4 = stringArray[n5].length() / 6;
            while (--n4 >= 0) {
                if (nArray[n5][n4] <= 0) continue;
                int[] nArray2 = nArray[0];
                int n6 = n4;
                nArray2[n6] = nArray2[n6] - nArray[n5][n4];
                if (nArray[0][n4] != 0) continue;
                stringArray[0] = stringArray[0].substring(0, n4 * 6) + ",[" + stringArray[0].substring(n4 * 6 + 2);
            }
        }
        if (stringArray != null) {
            this.modelSetAuxiliaryInfo.put("group3Lists", ArrayUtil.deleteElements(stringArray, n, 1));
            this.modelSetAuxiliaryInfo.put("group3Counts", ArrayUtil.deleteElements(nArray, n, 1));
        }
        if (this.unitCells != null) {
            this.unitCells = (SymmetryInterface[])ArrayUtil.deleteElements(this.unitCells, n, 1);
        }
        n4 = this.stateScripts.size();
        while (--n4 >= 0) {
            if (this.stateScripts.get(n4).deleteAtoms(n, bitSet2, bitSet)) continue;
            this.stateScripts.remove(n4);
        }
        this.deleteModelAtoms(n2, n3, bitSet);
        this.viewer.deleteModelAtoms(n2, n3, bitSet);
    }

    public String getMoInfo(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            int n2;
            Map map;
            if (n >= 0 && i != n || (map = (Map)this.viewer.getModelAuxiliaryInfo(i, "moData")) == null) continue;
            List list = (List)map.get("mos");
            int n3 = n2 = list == null ? 0 : list.size();
            if (n2 == 0) continue;
            int n4 = n2;
            while (--n4 >= 0) {
                String string;
                String string2;
                Float f;
                String string3;
                Map map2 = (Map)list.get(n4);
                String string4 = (String)map2.get("type");
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = (String)map2.get("energyUnits")) == null) {
                    string3 = "";
                }
                if ((f = (Float)map2.get("occupancy")) != null) {
                    string4 = "occupancy " + f.floatValue() + " " + string4;
                }
                if ((string2 = (String)map2.get("symmetry")) != null) {
                    string4 = string4 + string2;
                }
                if (Float.isNaN(Parser.parseFloat(string = "" + map2.get("energy")))) {
                    stringBuffer.append(TextFormat.sprintf("model %-2s;  mo %-2i # %s\n", new Object[]{this.getModelNumberDotted(i), n4 + 1, string4}));
                    continue;
                }
                stringBuffer.append(TextFormat.sprintf("model %-2s;  mo %-2i # energy %-8.3f %s %s\n", new Object[]{this.getModelNumberDotted(i), n4 + 1, map2.get("energy"), string3, string4}));
            }
        }
        return stringBuffer.toString();
    }

    public void assignAtom(int n, String string, boolean bl) {
        Serializable serializable;
        if (string == null) {
            string = "C";
        }
        Atom atom = this.atoms[n];
        BitSet bitSet = new BitSet();
        boolean bl2 = atom.getElementNumber() == 1;
        short s = Elements.elementNumberFromSymbol(string, true);
        boolean bl3 = false;
        if (s > 0) {
            this.setElement(atom, s);
            this.viewer.setShapeSize(0, this.viewer.getDefaultRadiusData(), BitSetUtil.setBit(n));
            this.setAtomName(n, string + atom.getAtomNumber());
            if (!this.models[atom.modelIndex].isModelKit) {
                this.taint(n, (byte)0);
            }
        } else if (string.equals("Pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (string.equals("Mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (string.equals("X")) {
            bl3 = true;
        } else if (!string.equals(".")) {
            return;
        }
        this.removeUnnecessaryBonds(atom, bl3);
        float f = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (bl2) {
                f = 1.5f;
            } else if (!bl2 && s == 1) {
                f = 1.0f;
            }
        }
        if (f != 0.0f) {
            serializable = new Vector3f(atom);
            ((Tuple3f)serializable).sub(this.atoms[atom.getBondedAtomIndex(0)]);
            float f2 = ((Vector3f)serializable).length();
            ((Vector3f)serializable).normalize();
            ((Tuple3f)serializable).scale(f - f2);
            this.setAtomCoordRelative(n, ((Vector3f)serializable).x, ((Vector3f)serializable).y, ((Vector3f)serializable).z);
        }
        serializable = BitSetUtil.setBit(n);
        if (s != 1 && bl) {
            this.validateBspf(false);
            bitSet = this.getAtomsWithin(1.0f, (BitSet)serializable, false, null);
            bitSet.andNot((BitSet)serializable);
            if (bitSet.nextSetBit(0) >= 0) {
                this.viewer.deleteAtoms(bitSet, false);
            }
            bitSet = this.viewer.getModelUndeletedAtomsBitSet(atom.modelIndex);
            bitSet.andNot(this.getAtomBitsMaybeDeleted(1613758476, null));
            this.makeConnections(0.1f, 1.8f, 1, 0x40000050, (BitSet)serializable, bitSet, null, false, false, 0.0f);
        }
        this.viewer.addHydrogens((BitSet)serializable, false, true);
    }

    public void deleteAtoms(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n >= 0 && n < this.atomCount) {
            this.atoms[n].delete(bitSet2);
            n = bitSet.nextSetBit(n + 1);
        }
        for (n = 0; n < this.modelCount; ++n) {
            this.models[n].bsAtomsDeleted.or(bitSet);
            this.models[n].bsAtomsDeleted.and(this.models[n].bsAtoms);
        }
        this.deleteBonds(bitSet2, false);
    }

    public void appendLoadStates(StringBuffer stringBuffer) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.isJmolDataFrame(i) || this.isTrajectorySubFrame(i)) continue;
            n = stringBuffer2.indexOf(this.models[i].loadState);
            if (n < 0 || n != stringBuffer2.lastIndexOf(this.models[i].loadState)) {
                stringBuffer2.append(this.models[i].loadState);
            }
            if (this.models[i].isModelKit) {
                BitSet bitSet = this.getModelAtomBitSetIncludingDeleted(i, false);
                if (this.tainted != null) {
                    if (this.tainted[2] != null) {
                        this.tainted[2].andNot(bitSet);
                    }
                    if (this.tainted[3] != null) {
                        this.tainted[3].andNot(bitSet);
                    }
                }
                this.models[i].loadScript = new StringBuffer();
                Viewer.getInlineData(stringBuffer2, this.getModelExtract(bitSet, false, true, "MOL"), i > 0);
                continue;
            }
            stringBuffer2.append(this.models[i].loadScript);
        }
        String string = stringBuffer2.toString();
        n = string.indexOf("load /*data*/");
        int n2 = string.indexOf("load /*file*/");
        if (n2 >= 0 && n2 < n) {
            n = n2;
        }
        if ((n2 = string.indexOf("load \"@")) >= 0 && n2 < n) {
            n = n2;
        }
        if (n >= 0) {
            string = string.substring(0, n) + "zap;" + string.substring(n);
        }
        stringBuffer.append(string);
    }

    public String getModelCml(BitSet bitSet, int n, boolean bl) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = BitSetUtil.cardinalityOf(bitSet);
        if (n2 == 0) {
            return "";
        }
        XmlUtil.openTag(stringBuffer, "molecule");
        XmlUtil.openTag(stringBuffer, "atomArray");
        BitSet bitSet2 = new BitSet();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0 && --n >= 0) {
            object2 = this.atoms[n3];
            object = ((Atom)object2).getAtomName();
            TextFormat.simpleReplace((String)object, "\"", "''");
            bitSet2.set(((Atom)object2).index);
            XmlUtil.appendTag(stringBuffer, "atom/", new String[]{"id", "a" + (((Atom)object2).index + 1), "title", ((Atom)object2).getAtomName(), "elementType", ((Atom)object2).getElementSymbol(), "x3", "" + ((Atom)object2).x, "y3", "" + ((Atom)object2).y, "z3", "" + ((Atom)object2).z});
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        XmlUtil.closeTag(stringBuffer, "atomArray");
        if (bl) {
            XmlUtil.openTag(stringBuffer, "bondArray");
            for (n3 = 0; n3 < this.bondCount; ++n3) {
                String string;
                object2 = this.bonds[n3];
                object = ((Bond)object2).atom1;
                Atom atom = ((Bond)object2).atom2;
                if (!bitSet2.get(((Atom)object).index) || !bitSet2.get(atom.index) || (string = JmolEdge.getCmlBondOrder(((Bond)object2).order)) == null) continue;
                XmlUtil.appendTag(stringBuffer, "bond/", new String[]{"atomRefs2", "a" + (((Bond)object2).atom1.index + 1) + " a" + (((Bond)object2).atom2.index + 1), "order", string});
            }
            XmlUtil.closeTag(stringBuffer, "bondArray");
        }
        XmlUtil.closeTag(stringBuffer, "molecule");
        return stringBuffer.toString();
    }

    void adjustAtomArrays(int[] nArray, int n, int n2) {
        int n3;
        this.atomCount = n2;
        for (n3 = n; n3 < n2; ++n3) {
            this.atoms[n3] = this.atoms[nArray[n3]];
            this.atoms[n3].index = n3;
            Model model = this.models[this.atoms[n3].modelIndex];
            if (model.firstAtomIndex == nArray[n3]) {
                model.firstAtomIndex = n3;
            }
            model.bsAtoms.set(n3);
        }
        if (this.vibrationVectors != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.vibrationVectors[n3] = this.vibrationVectors[nArray[n3]];
            }
        }
        if (this.occupancies != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.occupancies[n3] = this.occupancies[nArray[n3]];
            }
        }
        if (this.bfactor100s != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.bfactor100s[n3] = this.bfactor100s[nArray[n3]];
            }
        }
        if (this.partialCharges != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.partialCharges[n3] = this.partialCharges[nArray[n3]];
            }
        }
        if (this.ellipsoids != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.ellipsoids[n3] = this.ellipsoids[nArray[n3]];
            }
        }
        if (this.atomNames != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomNames[n3] = this.atomNames[nArray[n3]];
            }
        }
        if (this.atomTypes != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomTypes[n3] = this.atomTypes[nArray[n3]];
            }
        }
        if (this.atomSerials != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomSerials[n3] = this.atomSerials[nArray[n3]];
            }
        }
    }

    protected void growAtomArrays(int n) {
        this.atoms = (Atom[])ArrayUtil.setLength(this.atoms, n);
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])ArrayUtil.setLength(this.vibrationVectors, n);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.setLength(this.occupancies, n);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.setLength(this.bfactor100s, n);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.setLength(this.partialCharges, n);
        }
        if (this.ellipsoids != null) {
            this.ellipsoids = (Quadric[][])ArrayUtil.setLength(this.ellipsoids, n);
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.setLength(this.atomNames, n);
        }
        if (this.atomTypes != null) {
            this.atomTypes = ArrayUtil.setLength(this.atomTypes, n);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.setLength(this.atomSerials, n);
        }
    }

    protected Atom addAtom(int n, Group group, short s, String string, int n2, int n3, float f, float f2, float f3) {
        return this.addAtom(n, group, s, string, n2, n3, f, f2, f3, Float.NaN, Float.NaN, Float.NaN, Float.NaN, 0, 0.0f, 100, Float.NaN, null, false, '\u0000', (byte)0, null);
    }

    public Atom addAtom(int n, Group group, short s, String string, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, int n4, float f8, int n5, float f9, Quadric[] quadricArray, boolean bl, char c, byte by, BitSet bitSet) {
        Atom atom = new Atom(n, this.atomCount, f, f2, f3, f4, bitSet, n3, s, n4, bl, c);
        ++this.models[n].atomCount;
        this.models[n].bsAtoms.set(this.atomCount);
        if (s % 128 == 1) {
            ++this.models[n].hydrogenCount;
        }
        if (this.atomCount >= this.atoms.length) {
            this.growAtomArrays(this.atomCount + 100);
        }
        this.atoms[this.atomCount] = atom;
        this.setBFactor(this.atomCount, f9);
        this.setOccupancy(this.atomCount, n5);
        this.setPartialCharge(this.atomCount, f8);
        if (quadricArray != null) {
            this.setEllipsoid(this.atomCount, quadricArray);
        }
        atom.group = group;
        atom.colixAtom = this.viewer.getColixAtomPalette(atom, EnumPalette.CPK.id);
        if (string != null) {
            int n6 = string.indexOf(0);
            if (n6 >= 0) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.atoms.length];
                }
                this.atomTypes[this.atomCount] = string.substring(n6 + 1);
                string = string.substring(0, n6);
            }
            atom.atomID = by;
            if (by == 0) {
                if (this.atomNames == null) {
                    this.atomNames = new String[this.atoms.length];
                }
                this.atomNames[this.atomCount] = string.intern();
            }
        }
        if (n2 != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.atoms.length];
            }
            this.atomSerials[this.atomCount] = n2;
        }
        if (!Float.isNaN(f5)) {
            this.setVibrationVector(this.atomCount, f5, f6, f7);
        }
        ++this.atomCount;
        return atom;
    }

    public String getInlineData(int n) {
        StringBuffer stringBuffer = null;
        if (n >= 0) {
            stringBuffer = this.models[n].loadScript;
        } else {
            n = this.modelCount;
            while (--n >= 0 && (stringBuffer = this.models[n].loadScript).length() <= 0) {
            }
        }
        int n2 = stringBuffer.lastIndexOf("data \"");
        if (n2 < 0) {
            return null;
        }
        n2 = stringBuffer.indexOf("\"", n2 + 7);
        int n3 = stringBuffer.lastIndexOf("end \"");
        if (n3 < n2 || n2 < 0) {
            return null;
        }
        return stringBuffer.substring(n2 + 2, n3);
    }

    public boolean isAtomPDB(int n) {
        return n >= 0 && this.models[this.atoms[n].modelIndex].isBioModel;
    }

    public boolean isAtomAssignable(int n) {
        return n >= 0 && this.atoms[n].modelIndex == this.modelCount - 1;
    }

    public int getGroupAtom(Atom atom, int n, String string) {
        Group group = atom.group;
        int n2 = group.getMonomerIndex();
        if (n2 < 0) {
            return -1;
        }
        Group[] groupArray = group.getGroups();
        int n3 = n2 + n;
        if (n3 >= 0 && n3 < groupArray.length) {
            Group group2 = groupArray[n3];
            if (n == 1 && !group2.isConnectedPrevious()) {
                return -1;
            }
            if ("0".equals(string)) {
                return group2.leadAtomIndex;
            }
            for (int i = group2.firstAtomIndex; i <= group2.lastAtomIndex; ++i) {
                if (string != null && !string.equalsIgnoreCase(this.atoms[i].getAtomName())) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean haveModelKit() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isModelKit) continue;
            return true;
        }
        return false;
    }

    public BitSet getModelKitStateBitset(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = BitSetUtil.copy(bitSet2);
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.models[i].isModelKit) continue;
            bitSet3.andNot(this.models[i].bsAtoms);
        }
        return BitSetUtil.deleteBits(bitSet, bitSet3);
    }

    public void setAtomNamesAndNumbers(int n, int n2, AtomCollection atomCollection) {
        if (n2 < 0) {
            n = this.models[this.atoms[n].modelIndex].firstAtomIndex;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atomCount];
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        boolean bl = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
        int s = Integer.MAX_VALUE;
        int n3 = 1;
        for (int i = n; i < this.atomCount; ++i) {
            short s2;
            Atom atom = this.atoms[i];
            if (atom.modelIndex != s2) {
                s2 = atom.modelIndex;
                int n4 = n3 = bl ? 0 : 1;
            }
            if (this.atomSerials[i] == 0 || n2 < 0) {
                int n5 = this.atomSerials[i] = i < n2 ? atomCollection.atomSerials[i] : n3;
            }
            if (this.atomNames[i] == null || n2 < 0) {
                this.atomNames[i] = (atom.getElementSymbol() + this.atomSerials[i]).intern();
            }
            if (this.models[s2].isModelKit && (atom.getElementNumber() <= 0 || atom.isDeleted())) continue;
            ++n3;
        }
    }

    public void setUnitCellOffset(int n, Point3f point3f, int n2) {
        for (int i = n; i < this.modelCount; ++i) {
            SymmetryInterface symmetryInterface;
            if (i < 0 || n >= 0 && i != n && this.models[i].trajectoryBaseIndex != n || (symmetryInterface = this.getUnitCell(i)) == null) continue;
            if (point3f == null) {
                symmetryInterface.setOffset(n2);
                continue;
            }
            symmetryInterface.setUnitCellOffset(point3f);
        }
    }

    public void connect(float[][] fArray) {
        this.resetMolecules();
        BitSet bitSet = new BitSet();
        for (int i = 0; i < fArray.length; ++i) {
            short s;
            int n;
            int n2;
            boolean bl;
            float[] fArray2 = fArray[i];
            if (fArray2 == null || fArray2.length < 2) continue;
            int n3 = (int)fArray2[0];
            boolean bl2 = bl = n3 < 0;
            if (bl) {
                n3 = -1 - n3;
            }
            if ((n2 = (int)fArray2[1]) < 0 || n3 >= this.atomCount || n2 >= this.atomCount) continue;
            int n4 = n = fArray2.length > 2 ? (int)fArray2[2] : 1;
            if (n < 0) {
                n &= 0xFFFF;
            }
            short s2 = s = fArray2.length > 3 ? (short)(1000.0f * fArray[i][3]) : this.getDefaultMadFromOrder(n);
            if (n == 0 || s == 0 && n != 32768 && !Bond.isHydrogen(n)) {
                Bond bond = this.atoms[n3].getBond(this.atoms[n2]);
                if (bond == null) continue;
                bitSet.set(bond.index);
                continue;
            }
            float f = fArray2.length > 4 ? fArray2[4] : 0.0f;
            this.bondAtoms(this.atoms[n3], this.atoms[n2], n, s, null, f, bl, true);
        }
        if (bitSet.nextSetBit(0) >= 0) {
            this.deleteBonds(bitSet, false);
        }
    }

    public boolean allowSpecAtom() {
        return this.modelCount != 1 || this.models[0].isBioModel;
    }

    public void setFrameDelayMs(long l, BitSet bitSet) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            this.models[this.models[n].trajectoryBaseIndex].frameDelay = l;
            n = bitSet.nextSetBit(n + 1);
        }
    }

    public long getFrameDelayMs(int n) {
        return n < this.models.length && n >= 0 ? this.models[this.models[n].trajectoryBaseIndex].frameDelay : 0L;
    }

    public int getModelIndexFromId(String string) {
        boolean bl = string.indexOf("#") >= 0;
        boolean bl2 = string.toLowerCase().endsWith(".basemodel");
        if (bl2) {
            string = string.substring(0, string.length() - 10);
        }
        int n = -1;
        String string2 = null;
        for (int i = 0; i < this.modelCount; ++i) {
            String string3 = (String)this.getModelAuxiliaryInfo(i, "modelID");
            if (string3 == null && (string3 = this.getModelTitle(i)) == null) continue;
            if (bl) {
                string2 = this.getModelFileName(i) + "#";
                string3 = string2 + string3;
            }
            if (string.equalsIgnoreCase(string3)) {
                return bl2 ? this.getBaseModelIndex(i) : i;
            }
            if (string2 == null || !string.startsWith(string2)) continue;
            n = -2;
        }
        return string2 == null && !bl ? -2 : n;
    }

    public String getPeakAtomRecord(int n) {
        short s = this.atoms[n].modelIndex;
        String string = null;
        switch (this.atoms[n].getElementNumber()) {
            case 1: {
                string = "1HNMR";
                break;
            }
            case 6: {
                string = "13CNMR";
                break;
            }
            default: {
                return null;
            }
        }
        List list = (List)this.getModelAuxiliaryInfo(s, "jdxAtomSelect_" + string);
        if (list == null) {
            return null;
        }
        this.htPeaks = null;
        if (this.htPeaks == null) {
            this.htPeaks = new Hashtable();
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            BitSet bitSet = this.htPeaks.get(string2);
            if (bitSet == null) {
                bitSet = new BitSet();
                this.htPeaks.put(string2, bitSet);
                String string3 = Parser.getQuotedAttribute(string2, "atoms");
                String string4 = Parser.getQuotedAttribute(string2, "select");
                String string5 = "";
                if (string3 != null) {
                    string5 = string5 + "visible & (atomno=" + TextFormat.simpleReplace(string3, ",", " or atomno=") + ")";
                } else if (string4 != null) {
                    string5 = string5 + "visible & (" + string4 + ")";
                }
                bitSet.or(this.viewer.getAtomBitSet(string5));
            }
            if (!bitSet.get(n)) continue;
            return string2;
        }
        return null;
    }

    public BitSet getBaseModelBitSet(int n) {
        return this.getModelAtomBitSetIncludingDeleted(this.getBaseModelIndex(n), true);
    }

    private int getBaseModelIndex(int n) {
        String string = (String)this.getModelAuxiliaryInfo(n, "jdxBaseModel");
        if (string != null) {
            int n2 = this.models.length;
            while (--n2 >= 0) {
                if (!string.equals(this.getModelAuxiliaryInfo(n2, "jdxModelID"))) continue;
                return n2;
            }
        }
        return n;
    }

    public static class StateScript {
        private int modelIndex;
        private BitSet bsBonds;
        private BitSet bsAtoms1;
        private BitSet bsAtoms2;
        private String script1;
        private String script2;
        boolean inDefinedStateBlock;

        StateScript(int n, String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl) {
            this.modelIndex = n;
            this.script1 = string;
            this.bsBonds = BitSetUtil.copy(bitSet);
            this.bsAtoms1 = BitSetUtil.copy(bitSet2);
            this.bsAtoms2 = BitSetUtil.copy(bitSet3);
            this.script2 = string2;
            this.inDefinedStateBlock = bl;
        }

        public boolean isValid() {
            return !(this.script1 == null || this.script1.length() <= 0 || this.bsBonds != null && this.bsBonds.nextSetBit(0) < 0 || this.bsAtoms1 != null && this.bsAtoms1.nextSetBit(0) < 0 || this.bsAtoms2 != null && this.bsAtoms2.nextSetBit(0) < 0);
        }

        public String toString() {
            String string;
            if (!this.isValid()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.script1);
            if (this.bsBonds != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsBonds, false));
            }
            if (this.bsAtoms1 != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsAtoms1));
            }
            if (this.bsAtoms2 != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsAtoms2));
            }
            if (this.script2 != null) {
                stringBuffer.append(" ").append(this.script2);
            }
            if (!(string = stringBuffer.toString()).endsWith(";")) {
                string = string + ";";
            }
            return string;
        }

        public boolean isConnect() {
            return this.script1.indexOf("connect") >= 0;
        }

        public boolean deleteAtoms(int n, BitSet bitSet, BitSet bitSet2) {
            if (n == this.modelIndex) {
                return false;
            }
            if (n > this.modelIndex) {
                return true;
            }
            BitSetUtil.deleteBits(this.bsBonds, bitSet);
            BitSetUtil.deleteBits(this.bsAtoms1, bitSet2);
            BitSetUtil.deleteBits(this.bsAtoms2, bitSet2);
            return this.isValid();
        }

        public void setModelIndex(int n) {
            this.modelIndex = n;
        }
    }
}

