/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.util.MeshSurface;
import org.jmol.util.Quaternion;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ___Exporter {
    protected Viewer viewer;
    protected double privateKey;
    protected JmolRendererInterface jmolRenderer;
    protected StringBuffer output;
    protected BufferedWriter bw;
    private FileOutputStream os;
    protected String fileName;
    protected String commandLineOptions;
    protected boolean isToFile;
    protected Graphics3D g3d;
    protected short backgroundColix;
    protected int screenWidth;
    protected int screenHeight;
    protected int slabZ;
    protected int depthZ;
    protected Point3f lightSource = Graphics3D.getLightSource();
    protected Point3f fixedRotationCenter;
    protected Point3f referenceCenter;
    protected Point3f cameraPosition;
    protected float cameraDistance;
    protected float aperatureAngle;
    protected float scalePixelsPerAngstrom;
    int exportType;
    protected static final float degreesPerRadian = 57.29578f;
    protected final Point3f tempP1 = new Point3f();
    protected final Point3f tempP2 = new Point3f();
    protected final Point3f tempP3 = new Point3f();
    protected final Point3f center = new Point3f();
    protected final Vector3f tempV1 = new Vector3f();
    protected final Vector3f tempV2 = new Vector3f();
    protected final Vector3f tempV3 = new Vector3f();
    protected final AxisAngle4f tempA = new AxisAngle4f();
    protected int nBytes;
    protected String commentChar;
    private int nText;
    private int nImage;
    public short lineWidthMad;

    void setRenderer(JmolRendererInterface jmolRendererInterface) {
        this.jmolRenderer = jmolRendererInterface;
    }

    boolean initializeOutput(Viewer viewer, double d, Graphics3D graphics3D, Object object) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.privateKey = d;
        this.backgroundColix = viewer.getObjectColix(0);
        this.center.set(viewer.getRotationCenter());
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = viewer.getScreenWidth();
            this.screenHeight = viewer.getScreenHeight();
        }
        this.slabZ = graphics3D.getSlab();
        this.depthZ = graphics3D.getDepth();
        Point3f[] point3fArray = viewer.getCameraFactors();
        this.referenceCenter = point3fArray[0];
        this.cameraPosition = point3fArray[1];
        this.fixedRotationCenter = point3fArray[2];
        this.cameraDistance = point3fArray[3].x;
        this.aperatureAngle = point3fArray[3].y;
        this.scalePixelsPerAngstrom = point3fArray[3].z;
        this.isToFile = object instanceof String;
        if (this.isToFile) {
            this.fileName = (String)object;
            int n = this.fileName.indexOf(":::");
            if (n > 0) {
                this.commandLineOptions = this.fileName.substring(n + 3);
                this.fileName = this.fileName.substring(0, n);
            }
            try {
                File file = new File(this.fileName);
                System.out.println("__Exporter writing to " + file.getAbsolutePath());
                this.os = new FileOutputStream(this.fileName);
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        } else {
            this.output = (StringBuffer)object;
        }
        this.outputHeader();
        return true;
    }

    protected abstract void outputHeader();

    protected void output(String string) {
        this.nBytes += string.length();
        try {
            if (this.bw == null) {
                this.output.append(string);
            } else {
                this.bw.write(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void outputComment(String string) {
        if (this.commentChar != null) {
            this.output(this.commentChar + string + "\n");
        }
    }

    protected static void setTempVertex(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        point3f3.set(point3f);
        if (point3f2 != null) {
            point3f3.add(point3f2);
        }
    }

    protected void outputVertices(Point3f[] point3fArray, int n, Point3f point3f) {
        for (int i = 0; i < n; ++i) {
            if (Float.isNaN(point3fArray[i].x)) continue;
            this.outputVertex(point3fArray[i], point3f);
            this.output("\n");
        }
    }

    protected void outputVertex(Point3f point3f, Point3f point3f2) {
        ___Exporter.setTempVertex(point3f, point3f2, this.tempP1);
        this.output(this.tempP1);
    }

    protected abstract void output(Tuple3f var1);

    protected void outputJmolPerspective() {
        this.outputComment(this.getJmolPerspective());
    }

    protected String getJmolPerspective() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.commentChar).append("Jmol perspective:");
        stringBuffer.append("\n").append(this.commentChar).append("screen width height dim: " + this.screenWidth + " " + this.screenHeight + " " + this.viewer.getScreenDim());
        stringBuffer.append("\n").append(this.commentChar).append("perspectiveDepth: " + this.viewer.getPerspectiveDepth());
        stringBuffer.append("\n").append(this.commentChar).append("cameraDistance(angstroms): " + this.cameraDistance);
        stringBuffer.append("\n").append(this.commentChar).append("aperatureAngle(degrees): " + this.aperatureAngle);
        stringBuffer.append("\n").append(this.commentChar).append("scalePixelsPerAngstrom: " + this.scalePixelsPerAngstrom);
        stringBuffer.append("\n").append(this.commentChar).append("light source: " + this.lightSource);
        stringBuffer.append("\n").append(this.commentChar).append("lighting: " + this.viewer.getSpecularState().replace('\n', ' '));
        stringBuffer.append("\n").append(this.commentChar).append("center: " + this.center);
        stringBuffer.append("\n").append(this.commentChar).append("rotationRadius: " + this.viewer.getRotationRadius());
        stringBuffer.append("\n").append(this.commentChar).append("boundboxCenter: " + this.viewer.getBoundBoxCenter());
        stringBuffer.append("\n").append(this.commentChar).append("translationOffset: " + this.viewer.getTranslationScript());
        stringBuffer.append("\n").append(this.commentChar).append("zoom: " + this.viewer.getZoomPercentFloat());
        stringBuffer.append("\n").append(this.commentChar).append("moveto command: " + this.viewer.getOrientationText(4130, null));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void outputFooter() {
    }

    String finalizeOutput() {
        this.outputFooter();
        if (!this.isToFile) {
            return this.output.toString();
        }
        try {
            this.bw.flush();
            this.bw.close();
            this.os = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "ERROR EXPORTING FILE";
        }
        return "OK " + this.nBytes + " " + this.jmolRenderer.getExportName() + " " + this.fileName;
    }

    protected static String getExportDate() {
        return new SimpleDateFormat("yyyy-MM-dd', 'HH:mm").format(new Date());
    }

    protected String rgbFractionalFromColix(short s, char c) {
        return ___Exporter.rgbFractionalFromArgb(this.g3d.getColorArgbOrGray(s), c);
    }

    protected static String rgbFractionalFromArgb(int n, char c) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return "" + ___Exporter.round(n2 == 0 ? 0.0 : (double)((float)(n2 + 1) / 256.0f)) + c + ___Exporter.round(n3 == 0 ? 0.0 : (double)((float)(n3 + 1) / 256.0f)) + c + ___Exporter.round(n4 == 0 ? 0.0 : (double)((float)(n4 + 1) / 256.0f));
    }

    protected static String translucencyFractionalFromColix(short s) {
        return ___Exporter.round(Graphics3D.getColixTranslucencyFractional(s));
    }

    protected static String opacityFractionalFromColix(short s) {
        return ___Exporter.round(1.0f - Graphics3D.getColixTranslucencyFractional(s));
    }

    protected static String opacityFractionalFromArgb(int n) {
        int n2 = n >> 24 & 0xFF;
        return ___Exporter.round(n2 == 0 ? 0.0 : (double)((float)(n2 + 1) / 256.0f));
    }

    protected static String round(double d) {
        String string;
        return d == 0.0 ? "0" : (d == 1.0 ? "1" : ((string = "" + (double)Math.round(d * 1000.0) / 1000.0).startsWith("0.") ? string.substring(1) : (string.startsWith("-0.") ? "-" + string.substring(2) : (string.endsWith(".0") ? string.substring(0, string.length() - 2) : string))));
    }

    protected static String round(Tuple3f tuple3f) {
        return ___Exporter.round(tuple3f.x) + " " + ___Exporter.round(tuple3f.y) + " " + ___Exporter.round(tuple3f.z);
    }

    protected List<Short> getColorList(int n, short[] sArray, int n2, BitSet bitSet, Map<Short, Integer> map) {
        int n3;
        int n4 = 0;
        ArrayList<Short> arrayList = new ArrayList<Short>();
        boolean bl = bitSet == null;
        int n5 = n3 = bl ? n2 - 1 : bitSet.nextSetBit(0);
        while (n5 >= 0) {
            Short s = sArray[n5];
            if (!map.containsKey(s)) {
                arrayList.add(s);
                map.put(s, n + n4++);
            }
            n5 = bl ? n5 - 1 : bitSet.nextSetBit(n5 + 1);
        }
        return arrayList;
    }

    protected static MeshSurface getConeMesh(Point3f point3f, Matrix3f matrix3f, short s) {
        int n;
        MeshSurface meshSurface = new MeshSurface();
        int n2 = 10;
        int n3 = 360 / n2;
        meshSurface.colix = s;
        meshSurface.vertexCount = n3 + 1;
        meshSurface.vertices = new Point3f[meshSurface.vertexCount];
        meshSurface.polygonCount = n3;
        meshSurface.polygonIndexes = new int[meshSurface.polygonCount][];
        for (int i = 0; i < n3; ++i) {
            meshSurface.polygonIndexes[i] = new int[]{i, (i + 1) % n3, n3};
        }
        double d = (double)n2 / 180.0 * Math.PI;
        for (n = 0; n < n3; ++n) {
            float f = (float)Math.cos((double)n * d);
            float f2 = (float)Math.sin((double)n * d);
            meshSurface.vertices[n] = new Point3f(f, f2, 0.0f);
        }
        meshSurface.vertices[n3] = new Point3f(0.0f, 0.0f, 1.0f);
        if (matrix3f != null) {
            meshSurface.normals = new Vector3f[meshSurface.vertexCount];
            for (n = 0; n < meshSurface.vertexCount; ++n) {
                matrix3f.transform(meshSurface.vertices[n]);
                meshSurface.normals[n] = new Vector3f();
                meshSurface.normals[n].set(meshSurface.vertices[n]);
                ((Vector3f)meshSurface.normals[n]).normalize();
                meshSurface.vertices[n].add(point3f);
            }
        }
        return meshSurface;
    }

    protected Matrix3f getRotationMatrix(Point3f point3f, Point3f point3f2, float f) {
        Matrix3f matrix3f;
        Matrix3f matrix3f2 = new Matrix3f();
        if (point3f2.x == point3f.x && point3f2.y == point3f.y) {
            matrix3f = new Matrix3f();
            matrix3f.setIdentity();
            if (point3f.z > point3f2.z) {
                matrix3f.m22 = -1.0f;
                matrix3f.m11 = -1.0f;
            }
        } else {
            this.tempV1.set(point3f2);
            this.tempV1.sub(point3f);
            this.tempV2.set(0.0f, 0.0f, 1.0f);
            this.tempV2.cross(this.tempV2, this.tempV1);
            this.tempV1.cross(this.tempV1, this.tempV2);
            Quaternion quaternion = Quaternion.getQuaternionFrame(this.tempV2, this.tempV1, null, false);
            matrix3f = quaternion.getMatrix();
        }
        matrix3f2.m00 = f;
        matrix3f2.m11 = f;
        matrix3f2.m22 = point3f2.distance(point3f);
        matrix3f.mul(matrix3f2);
        return matrix3f;
    }

    protected Matrix3f getRotationMatrix(Point3f point3f, Point3f point3f2, float f, Point3f point3f3, Point3f point3f4) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.m00 = point3f3.distance(point3f) * f;
        matrix3f.m11 = point3f4.distance(point3f) * f;
        matrix3f.m22 = point3f2.distance(point3f) * 2.0f;
        Quaternion quaternion = Quaternion.getQuaternionFrame(point3f, point3f3, point3f4);
        Matrix3f matrix3f2 = quaternion.getMatrix();
        matrix3f2.mul(matrix3f);
        return matrix3f2;
    }

    abstract void drawAtom(Atom var1);

    abstract void drawCircle(int var1, int var2, int var3, int var4, short var5, boolean var6);

    abstract boolean drawEllipse(Point3f var1, Point3f var2, Point3f var3, short var4, boolean var5);

    void drawSurface(MeshSurface meshSurface, short s) {
        int n;
        int n2 = meshSurface.vertexCount;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = meshSurface.polygonCount;
        BitSet bitSet = meshSurface.bsPolygons;
        int n5 = meshSurface.haveQuads ? 4 : 3;
        int[][] nArray = meshSurface.polygonIndexes;
        boolean bl = bitSet == null;
        int n6 = n = bl ? n4 - 1 : bitSet.nextSetBit(0);
        while (n6 >= 0) {
            n3 += n5 == 4 && nArray[n6].length == 4 ? 2 : 1;
            n6 = bl ? n6 - 1 : bitSet.nextSetBit(n6 + 1);
        }
        if (n3 == 0) {
            return;
        }
        Point3f[] point3fArray = (Point3f[])meshSurface.getVertices();
        Vector3f[] vector3fArray = (Vector3f[])meshSurface.normals;
        boolean bl2 = s != 0;
        short[] sArray = bl2 ? null : meshSurface.vertexColixes;
        short[] sArray2 = bl2 ? meshSurface.polygonColixes : null;
        Hashtable<Short, Integer> hashtable = new Hashtable<Short, Integer>();
        List<Short> list = null;
        if (sArray2 != null) {
            list = this.getColorList(0, sArray2, n4, bitSet, hashtable);
        } else if (sArray != null) {
            list = this.getColorList(0, sArray, n2, null, hashtable);
        }
        this.outputSurface(point3fArray, vector3fArray, sArray, nArray, sArray2, n2, n4, n3, bitSet, n5, s, list, hashtable, meshSurface.offset);
    }

    protected void outputSurface(Point3f[] point3fArray, Vector3f[] vector3fArray, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BitSet bitSet, int n4, short s, List<Short> list, Map<Short, Integer> map, Point3f point3f) {
    }

    abstract void drawPixel(short var1, int var2, int var3, int var4, int var5);

    abstract void drawTextPixel(int var1, int var2, int var3, int var4);

    abstract void fillConeScreen(short var1, byte var2, int var3, Point3f var4, Point3f var5, boolean var6);

    abstract void drawCylinder(Point3f var1, Point3f var2, short var3, short var4, byte var5, int var6, int var7);

    abstract void fillCylinderScreenMad(short var1, byte var2, int var3, Point3f var4, Point3f var5);

    abstract void fillCylinderScreen(short var1, byte var2, int var3, Point3f var4, Point3f var5);

    abstract void fillEllipsoid(Point3f var1, Point3f[] var2, short var3, int var4, int var5, int var6, int var7, Matrix3f var8, double[] var9, Matrix4f var10, Point3i[] var11);

    void drawFilledCircle(short s, short s2, int n, int n2, int n3, int n4) {
        if (s != 0) {
            this.drawCircle(n2, n3, n4, n, s, false);
        }
        if (s2 != 0) {
            this.drawCircle(n2, n3, n4, n, s2, true);
        }
    }

    abstract void fillSphere(short var1, int var2, Point3f var3);

    protected abstract void fillTriangle(short var1, Point3f var2, Point3f var3, Point3f var4, boolean var5);

    void plotImage(int n, int n2, int n3, Image image, short s, int n4, int n5) {
        if (n3 < 3) {
            n3 = this.viewer.getFrontPlane();
        }
        this.outputComment("start image " + ++this.nImage);
        this.g3d.plotImage(n, n2, n3, image, this.jmolRenderer, s, n4, n5);
        this.outputComment("end image " + this.nImage);
    }

    void plotText(int n, int n2, int n3, short s, String string, Font3D font3D) {
        if (n3 < 3) {
            n3 = this.viewer.getFrontPlane();
        }
        this.outputComment("start text " + ++this.nText + ": " + string);
        this.g3d.plotText(n, n2, n3, this.g3d.getColorArgbOrGray(s), string, font3D, this.jmolRenderer);
        this.outputComment("end text " + this.nText + ": " + string);
    }
}

