/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javax.vecmath.Tuple3f;
import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

public class Mol2Reader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int atomCount = 0;
    private boolean isPDB = false;
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private char chainID = (char)64;

    protected void initializeReader() throws Exception {
        this.setUserAtomTypes();
    }

    public boolean checkLine() throws Exception {
        if (this.line.equals("@<TRIPOS>MOLECULE")) {
            if (!this.processMolecule()) {
                return true;
            }
            this.continuing = !this.isLastModel(this.modelNumber);
            return false;
        }
        if (this.line.length() != 0 && this.line.charAt(0) == '#') {
            this.checkLineForScript();
        }
        return true;
    }

    private boolean processMolecule() throws Exception {
        this.isPDB = false;
        String string = this.readLine().trim();
        if (!this.doGetModel(++this.modelNumber, string)) {
            return false;
        }
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.chainID = (char)64;
        this.readLine();
        this.line = this.line + " 0 0 0 0 0 0";
        this.atomCount = this.parseInt(this.line);
        int n = this.parseInt();
        int n2 = this.parseInt();
        this.readLine();
        this.readLine();
        if (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.readLine() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            if (this.line.indexOf("jmolscript:") >= 0) {
                this.checkLineForScript();
                if (this.line.equals("#")) {
                    this.line = "";
                }
            }
            if (this.line.length() != 0) {
                string = string + ": " + this.line.trim();
            }
        }
        this.newAtomSet(string);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.atomCount);
                this.atomSetCollection.setAtomSetName(string);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(n);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(n2);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.readLine();
        }
        this.nAtoms += this.atomCount;
        if (this.isPDB) {
            this.setIsPDB();
        }
        this.applySymmetryAndSetTrajectory();
        return true;
    }

    private void readAtoms(int n) throws Exception {
        Object object;
        Object object2;
        if (n == 0) {
            return;
        }
        int n2 = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < n; ++i) {
            object2 = this.atomSetCollection.addNewAtom();
            String[] stringArray = Mol2Reader.getTokens(this.readLine());
            object = stringArray[5];
            ((Atom)object2).atomName = stringArray[1] + '\u0000' + (String)object;
            ((Tuple3f)object2).set(this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
            if (stringArray.length > 6) {
                ((Atom)object2).sequenceNumber = this.parseInt(stringArray[6]);
                if (((Atom)object2).sequenceNumber < this.lastSequenceNumber) {
                    if (this.chainID == 'Z') {
                        this.chainID = (char)96;
                    }
                    this.chainID = (char)(this.chainID + '\u0001');
                }
                this.lastSequenceNumber = ((Atom)object2).sequenceNumber;
                ((Atom)object2).chainID = this.chainID;
            }
            if (stringArray.length > 7) {
                ((Atom)object2).group3 = stringArray[7];
            }
            if (stringArray.length <= 8) continue;
            ((Atom)object2).partialCharge = this.parseFloat(stringArray[8]);
            if (((Atom)object2).partialCharge != (float)((int)((Atom)object2).partialCharge)) continue;
            ((Atom)object2).formalCharge = (int)((Atom)object2).partialCharge;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        object2 = atomArray[n2].group3;
        if (object2 == null) {
            return;
        }
        this.isPDB = false;
        int n3 = this.atomSetCollection.getAtomCount();
        while (--n3 >= n2) {
            if (((String)object2).equals(atomArray[this.atomSetCollection.getAtomCount() - 1].group3)) continue;
            this.isPDB = true;
            break;
        }
        if (this.isPDB) {
            this.isPDB = false;
            n3 = this.atomSetCollection.getAtomCount();
            while (--n3 >= n2) {
                object = atomArray[n3];
                if (((Atom)object).group3.length() > 3 || JmolAdapter.lookupGroupID(((Atom)object).group3) < 0) continue;
                this.isPDB = true;
                break;
            }
            if (this.isPDB) {
                n3 = this.atomSetCollection.getAtomCount();
                while (--n3 >= n2) {
                    object = atomArray[n3];
                    ((Atom)object).isHetero = JmolAdapter.isHetero(((Atom)object).group3);
                    String string = ((Atom)object).atomName.substring(((Atom)object).atomName.indexOf(0) + 1);
                    boolean bl = !this.getElementSymbol((Atom)object, string);
                    if (!bl) continue;
                    ((Atom)object).elementSymbol = Mol2Reader.deducePdbElementSymbol(((Atom)object).isHetero, string, ((Atom)object).group3);
                }
                return;
            }
        }
        if (!this.isPDB) {
            n3 = this.atomSetCollection.getAtomCount();
            while (--n3 >= n2) {
                atomArray[n3].group3 = null;
            }
        }
    }

    private void readBonds(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String[] stringArray = Mol2Reader.getTokens(this.readLine());
            int n2 = this.parseInt(stringArray[1]);
            int n3 = this.parseInt(stringArray[2]);
            int n4 = this.parseInt(stringArray[3]);
            if (n4 == Integer.MIN_VALUE) {
                n4 = stringArray[3].equals("ar") ? 515 : (stringArray[3].equals("am") ? 1 : 17);
            }
            this.atomSetCollection.addBond(new Bond(this.nAtoms + n2 - 1, this.nAtoms + n3 - 1, n4));
        }
    }

    private void readResInfo(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
        }
    }

    private void readCrystalInfo() throws Exception {
        int n;
        this.readLine();
        String[] stringArray = this.getTokens();
        if (stringArray.length < 6) {
            return;
        }
        String string = "";
        for (n = 6; n < stringArray.length; ++n) {
            string = string + " " + stringArray[n];
        }
        string = string == "" ? " P1" : string + " *";
        string = string.substring(1);
        this.setSpaceGroupName(string);
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (n = 0; n < 6; ++n) {
            this.setUnitCellItem(n, this.parseFloat(stringArray[n]));
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            this.setAtomCoord(atomArray[this.nAtoms + i]);
        }
    }
}

