/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.util.Logger;
import jspecview.util.SimpleXmlReader;

abstract class XMLReader {
    protected JDXSource source;
    protected String filePath = "";
    protected SimpleXmlReader reader;
    protected String tagName = "START";
    protected String attrList = "";
    protected String title = "";
    protected String owner = "UNKNOWN";
    protected String origin = "UNKNOWN";
    protected String tmpEnd = "END";
    protected String molForm = "";
    protected String techname = "";
    protected int npoints = -1;
    protected int samplenum = -1;
    protected double[] yaxisData;
    protected double[] xaxisData;
    protected String xUnits = "";
    protected String yUnits = "ARBITRARY UNITS";
    protected String vendor = "na";
    protected String modelType = "MODEL UNKNOWN";
    protected String LongDate = "";
    protected String pathlength = "na";
    protected String identifier = "";
    protected String plLabel = "";
    protected String resolution = "na";
    protected String resLabel = "";
    protected String LocName = "";
    protected String LocContact = "";
    protected String casName = "";
    protected String sampleowner = "";
    protected String obNucleus = "";
    protected String StrObFreq = "";
    protected boolean increasing = false;
    protected boolean continuous = false;
    protected int ivspoints;
    protected int evspoints;
    protected int sampleRefNum = 0;
    protected double deltaX = Double.MAX_VALUE;
    protected double xFactor = Double.MAX_VALUE;
    protected double yFactor = Double.MAX_VALUE;
    protected double firstX = Double.MAX_VALUE;
    protected double lastX = Double.MAX_VALUE;
    protected double firstY = Double.MAX_VALUE;
    protected double obFreq = Double.MAX_VALUE;
    protected double refPoint = Double.MAX_VALUE;
    protected String casRN = "";
    protected String sampleID;
    protected StringBuffer errorLog = new StringBuffer();
    static final String[] tagNames = new String[]{"audittrail", "experimentstepset", "sampleset", "xx result", "spectrum", "metadatalist", "conditionlist", "parameterlist", "sample", "spectrumdata", "peaklist", "author", "peaklist"};
    static final int AML_0 = 0;
    static final int AML_AUDITTRAIL = 0;
    static final int AML_EXPERIMENTSTEPSET = 1;
    static final int AML_SAMPLESET = 2;
    static final int AML_RESULT = 3;
    static final int AML_1 = 3;
    static final int CML_0 = 4;
    static final int CML_SPECTRUM = 4;
    static final int CML_METADATALIST = 5;
    static final int CML_CONDITIONLIST = 6;
    static final int CML_PARAMETERLIST = 7;
    static final int CML_SAMPLE = 8;
    static final int CML_SPECTRUMDATA = 9;
    static final int CML_PEAKLIST = 10;
    static final int CML_1 = 10;
    static final int AML_AUTHOR = 11;
    static final int CML_PEAKLIST2 = 12;

    protected abstract boolean processTag(int var1) throws Exception;

    protected abstract void processEndTag(int var1) throws Exception;

    public XMLReader(String filePath) {
        this.filePath = filePath;
    }

    protected void getSimpleXmlReader(BufferedReader br) {
        this.reader = new SimpleXmlReader(br);
    }

    protected void checkStart() throws Exception {
        if (this.reader.peek() == 1) {
            return;
        }
        String errMsg = "Error: XML <xxx> not found at beginning of file; not an XML document?";
        this.errorLog.append(errMsg);
        throw new IOException(errMsg);
    }

    protected void populateVariables() {
        ArrayList<String[]> LDRTable = new ArrayList<String[]>(20);
        JDXSpectrum spectrum = new JDXSpectrum();
        spectrum.setTitle(this.title);
        spectrum.setJcampdx("5.01");
        spectrum.setDataClass("XYDATA");
        spectrum.setDataType(this.techname);
        spectrum.setContinuous(this.continuous);
        spectrum.setIncreasing(this.increasing);
        spectrum.setXFactor(this.xFactor);
        spectrum.setYFactor(this.yFactor);
        spectrum.setLongDate(this.LongDate);
        spectrum.setOrigin(this.origin);
        spectrum.setOwner(this.owner);
        FileReader.addHeader(LDRTable, "##PATHLENGTH", this.pathlength);
        FileReader.addHeader(LDRTable, "##RESOLUTION", this.resolution);
        if (!this.StrObFreq.equals("")) {
            FileReader.addHeader(LDRTable, "##.OBSERVEFREQUENCY", this.StrObFreq);
        }
        if (!this.obNucleus.equals("")) {
            FileReader.addHeader(LDRTable, "##.OBSERVENUCLEUS", this.obNucleus);
        }
        FileReader.addHeader(LDRTable, "##$MANUFACTURER", this.vendor);
        if (!this.casRN.equals("")) {
            FileReader.addHeader(LDRTable, "##CASREGISTRYNO", this.casRN);
        }
        if (!this.molForm.equals("")) {
            FileReader.addHeader(LDRTable, "##MOLFORM", this.molForm);
        }
        if (!this.modelType.equals("")) {
            FileReader.addHeader(LDRTable, "##SPECTROMETER/DATA SYSTEM", this.modelType);
        }
        spectrum.setHeaderTable(LDRTable);
        double xScale = 1.0;
        if (this.obFreq != Double.MAX_VALUE) {
            spectrum.setObservedFreq(this.obFreq);
            if (this.xUnits.toUpperCase().equals("HZ")) {
                this.xUnits = "PPM";
                spectrum.setHZtoPPM(true);
                xScale = this.obFreq;
            }
        }
        Coordinate[] xyCoords = new Coordinate[this.npoints];
        int x = 0;
        while (x < this.npoints) {
            xyCoords[x] = new Coordinate(this.xaxisData[x] / xScale, this.yaxisData[x]);
            ++x;
        }
        if (!this.increasing) {
            xyCoords = Coordinate.reverse(xyCoords);
        }
        spectrum.setXUnits(this.xUnits);
        spectrum.setYUnits(this.yUnits);
        spectrum.setXYCoords(xyCoords);
        this.source.addJDXSpectrum(this.filePath, spectrum, false);
    }

    protected boolean checkPointCount() {
        if (this.continuous && this.npoints < 5) {
            System.err.println("Insufficient points to plot");
            this.errorLog.append("Insufficient points to plot \n");
            this.source.setErrorLog(this.errorLog.toString());
            return false;
        }
        return true;
    }

    protected void processErrors(String type) {
        this.reader = null;
        if (this.errorLog.length() > 0) {
            this.errorLog.append("these errors were found in " + type + " \n");
            this.errorLog.append("=====================\n");
        }
        this.source.setErrorLog(this.errorLog.toString());
    }

    protected void processXML(int i0, int i1) throws Exception {
        block0: while (this.reader.hasNext()) {
            if (this.reader.nextEvent() != 1) continue;
            String theTag = this.reader.getTagName();
            boolean requiresEndTag = this.reader.requiresEndTag();
            if (Logger.debugging) {
                Logger.info(this.tagName);
            }
            int i = i0;
            while (i <= i1) {
                if (theTag.equals(tagNames[i])) {
                    this.process(i, requiresEndTag);
                    continue block0;
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void process(int tagId, boolean requiresEndTag) {
        thisTagName = XMLReader.tagNames[tagId];
        try {
            this.tagName = this.reader.getTagName();
            this.attrList = this.reader.getAttributeList();
            if (this.processTag(tagId) && requiresEndTag) ** GOTO lbl20
            return;
lbl-1000:
            // 1 sources

            {
                switch (this.reader.nextEvent()) {
                    default: {
                        break;
                    }
                    case 2: {
                        if (!this.reader.getEndTag().equals(thisTagName)) continue block6;
                        this.processEndTag(tagId);
                        return;
                    }
                    case 1: {
                        this.tagName = this.reader.getTagName();
                        if (this.tagName.startsWith("!--")) continue block6;
                        this.attrList = this.reader.getAttributeList();
                        if (this.processTag(tagId)) continue block6;
                        return;
                    }
                }
lbl20:
                // 5 sources

                ** while (this.reader.hasNext())
            }
lbl21:
            // 1 sources

        }
        catch (Exception e) {
            msg = "error reading " + this.tagName + " section: " + e.getMessage() + "\n" + e.getStackTrace();
            Logger.error(msg);
            this.errorLog.append(String.valueOf(msg) + "\n");
        }
    }
}

