/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.OutputStream;
import jspecview.common.AwtPanel;
import jspecview.common.PdfCreatorInterface;
import jspecview.common.PrintLayout;

public class PdfCreator
implements PdfCreatorInterface {
    public void createPdfDocument(AwtPanel awtPanel, PrintLayout pl, OutputStream os) {
        boolean isLandscape = pl.layout.equals("landscape");
        Document document = new Document(isLandscape ? PageSize.LETTER.rotate() : PageSize.LETTER);
        Dimension d = PrintLayout.getDimension(pl.paper);
        PageFormat pf = new PageFormat();
        Paper p = new Paper();
        p.setImageableArea(0.0, 0.0, d.width, d.height);
        pf.setPaper(p);
        pf.setOrientation(pl.layout.equals("landscape") ? 0 : 1);
        int w = isLandscape ? d.height : d.width;
        int h = isLandscape ? d.width : d.height;
        try {
            PdfWriter writer = PdfWriter.getInstance(document, os);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(w, h);
            Graphics2D g2 = tp.createGraphics(w, h);
            g2.setStroke(new BasicStroke(0.1f));
            tp.setWidth(w);
            tp.setHeight(h);
            awtPanel.print(g2, pf, 0);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (Exception e) {
            awtPanel.showMessage(e.getMessage(), "PDF Creation Error");
        }
        document.close();
    }
}

