/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javax.swing.JComboBox;
import javax.swing.JTextField;
import jspecview.common.Annotation;
import jspecview.common.AwtAnnotationDialog;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.Measurement;
import jspecview.common.PanelData;
import jspecview.common.PeakData;
import jspecview.common.ScriptInterface;
import jspecview.util.TextFormat;

class AwtPeakListDialog
extends AwtAnnotationDialog {
    private static final long serialVersionUID = 1L;
    private static int[] posXY;
    private JTextField txtThreshold;
    private JComboBox cbInterpolation;
    private boolean skipCreate;

    static {
        int[] nArray = new int[2];
        nArray[0] = Integer.MIN_VALUE;
        posXY = nArray;
    }

    protected AwtPeakListDialog(String title, ScriptInterface si, JDXSpectrum spec, JSVPanel jsvp) {
        super(si, spec, jsvp);
        this.thisType = Annotation.AType.PeakList;
        this.setTitle(title);
        this.setup();
    }

    protected int[] getPosXY() {
        return posXY;
    }

    protected void addControls() {
        this.txtThreshold = this.dialogHelper.addInputOption("Threshold", null, null, "", "", true);
        this.setThreshold(Double.NaN);
        this.cbInterpolation = this.dialogHelper.addSelectOption("Interpolation", null, new String[]{"parabolic", "none"}, 0, true);
    }

    private void setThreshold(double y) {
        if (Double.isNaN(y)) {
            PanelData pd = this.jsvp.getPanelData();
            double f = pd.getSpectrum().isInverted() ? 0.1 : 0.9;
            Coordinate c = pd.getClickedCoordinate();
            y = c == null ? (pd.getView().minYOnScale * f + pd.getView().maxYOnScale) * (1.0 - f) : c.getYVal();
        }
        String sy = TextFormat.getDecimalFormat(y < 1000.0 ? "#0.00" : "0.00E0").format(y);
        this.txtThreshold.setText(" " + sy);
    }

    protected void applyButtonPressed() {
        this.createData();
        this.skipCreate = true;
        this.apply();
    }

    public void apply() {
        if (!this.skipCreate) {
            this.setThreshold(Double.NaN);
            this.createData();
        }
        this.skipCreate = false;
        super.apply();
    }

    public void setFields() {
        this.myParams = this.xyData.getParameters();
        this.setThreshold(this.myParams.peakListThreshold);
        this.cbInterpolation.setSelectedIndex(this.myParams.peakListInterpolation.equals("none") ? 1 : 0);
        this.createData();
    }

    protected void setParams() {
        try {
            String s = this.txtThreshold.getText();
            this.myParams.peakListThreshold = Double.valueOf(s);
            this.myParams.peakListInterpolation = this.cbInterpolation.getSelectedItem().toString();
            super.setParams();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void clear() {
    }

    protected void done() {
        super.done();
    }

    protected void updateValues() {
        this.loadData();
    }

    protected void createData() {
        this.setParams();
        PeakData md = new PeakData(Annotation.AType.PeakList, this.spec);
        md.setPeakList(this.myParams, this.numberFormatter, this.jsvp.getPanelData().getView());
        this.xyData = md;
        this.loadData();
    }

    private void loadData() {
        if (this.xyData == null) {
            this.createData();
        }
        String[][] data = ((PeakData)this.xyData).getMeasurementListArray(null);
        String[] header = ((PeakData)this.xyData).getDataHeader();
        int[] widths = new int[]{40, 65, 50, 50, 50, 50, 50};
        this.loadData(data, header, widths);
        this.dataTable.setCellSelectionEnabled(true);
    }

    public synchronized void update(Coordinate clicked) {
        this.apply();
        if (this.xyData == null || clicked == null) {
            return;
        }
        int ipt = 0;
        double dx0 = 1.0E100;
        double xval = clicked.getXVal();
        PeakData md = (PeakData)this.xyData;
        int i = md.size();
        while (--i >= 0) {
            double dx = Math.abs(xval - ((Measurement)md.get(i)).getXVal());
            if (dx < dx0) {
                dx0 = dx;
                ipt = i;
            }
            if (!(dx0 < 0.1)) continue;
            this.dataTable.getSelectionModel().setSelectionInterval(md.size() - 2 - ipt, md.size() - 1 - ipt);
        }
    }

    public void tableCellSelectedEvent(int iRow, int iCol) {
        try {
            String value = this.tableData[iRow][1];
            switch (iCol) {
                case 4: 
                case 5: 
                case 6: {
                    String value2 = this.tableData[iRow + 3 - iCol][1];
                    this.jsvp.getPanelData().findX2(this.spec, Double.parseDouble(value), this.spec, Double.parseDouble(value2));
                    break;
                }
                default: {
                    this.jsvp.getPanelData().findX(this.spec, Double.parseDouble(value));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.jsvp.getPanelData().findX(this.spec, 1.0E100);
        }
        this.jsvp.doRepaint();
    }

    public void reEnable() {
        this.skipCreate = true;
        super.reEnable();
    }
}

