/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.util.ColorUtil;

public class AwtParameters
extends Parameters {
    static final Object[] defaultColors = new Object[]{Color.BLACK, Color.RED, Color.BLACK, Color.RED, Color.LIGHT_GRAY, Color.BLUE, Color.WHITE, new Color(192, 192, 192), Color.RED, Color.RED, Color.darkGray};
    public static final Color[] defaultPlotColors = new Color[]{Color.blue, AwtParameters.getColorFromString("darkGreen"), AwtParameters.getColorFromString("darkred"), AwtParameters.getColorFromString("orange"), AwtParameters.getColorFromString("magenta"), AwtParameters.getColorFromString("cyan"), AwtParameters.getColorFromString("maroon"), AwtParameters.getColorFromString("darkGray")};

    public AwtParameters(String name) {
        super(name);
        this.setDefaultColors(defaultColors);
        this.setParamDefaults();
        this.plotColors = new Color[defaultPlotColors.length];
        System.arraycopy(defaultPlotColors, 0, this.plotColors, 0, defaultPlotColors.length);
    }

    protected Object getPlotColors(String plotColorsStr) {
        if (plotColorsStr == null) {
            ((Color[])this.plotColors)[0] = (Color)this.getColor(ScriptToken.PLOTCOLOR);
            return this.plotColors;
        }
        StringTokenizer st = new StringTokenizer(plotColorsStr, ",;.- ");
        ArrayList<Color> colors = new ArrayList<Color>();
        try {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                colors.add(AwtParameters.getColorFromString(token));
            }
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return colors.toArray(new Color[colors.size()]);
    }

    protected Object setColorFromString(ScriptToken st, String value) {
        return this.setColor(st, AwtParameters.getColorFromString(value));
    }

    protected Object getFontName(ScriptToken st, String value) {
        switch (st) {
            case TITLEFONTNAME: {
                GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
                List<String> fontList = Arrays.asList(g.getAvailableFontFamilyNames());
                for (String s : fontList) {
                    if (!value.equalsIgnoreCase(s)) continue;
                    this.titleFont = value;
                    break;
                }
                return this.titleFont;
            }
            case DISPLAYFONTNAME: {
                GraphicsEnvironment g2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
                List<String> fontList2 = Arrays.asList(g2.getAvailableFontFamilyNames());
                for (String s2 : fontList2) {
                    if (!value.equalsIgnoreCase(s2)) continue;
                    this.displayFont = value;
                    break;
                }
                return this.displayFont;
            }
        }
        return null;
    }

    public static String colorToHexString(Object oColor) {
        String b;
        String g;
        if (oColor == null) {
            return "";
        }
        Color color = (Color)oColor;
        String r = Integer.toHexString(color.getRed());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(color.getGreen())).length() == 1) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(color.getBlue())).length() == 1) {
            b = "0" + b;
        }
        return "#" + r + g + b;
    }

    public static Color getColorFromString(String strColor) {
        return new Color(ColorUtil.getArgbFromString(strColor.trim()));
    }
}

