/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jspecview.common.Annotation;
import jspecview.common.AwtAnnotationDialog;
import jspecview.common.Coordinate;
import jspecview.common.IntegralData;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.Measurement;
import jspecview.common.ScriptInterface;
import jspecview.util.TextFormat;

class AwtIntegralListDialog
extends AwtAnnotationDialog {
    private static final long serialVersionUID = 1L;
    private static int[] posXY;
    private JTextField txtScale;
    private JTextField txtOffset;
    private AwtIntegralListDialog dialog;
    private int iSelected = -1;
    protected double lastNorm = 1.0;
    double lastMin = 0.0;

    static {
        int[] nArray = new int[2];
        nArray[0] = Integer.MIN_VALUE;
        posXY = nArray;
    }

    protected AwtIntegralListDialog(String title, ScriptInterface si, JDXSpectrum spec, JSVPanel jsvp) {
        super(si, spec, jsvp);
        this.thisType = Annotation.AType.Integration;
        this.setTitle(title);
        this.setup();
        this.myParams.integralOffset = si.getParameters().integralOffset;
        this.myParams.integralRange = si.getParameters().integralRange;
        this.xyData = new IntegralData(spec, this.myParams);
        this.dialog = this;
    }

    protected int[] getPosXY() {
        return posXY;
    }

    protected void addControls() {
        this.txtScale = this.dialogHelper.addInputOption("Scale", "Scale", null, "%", "" + this.si.getParameters().integralRange, true);
        this.txtOffset = this.dialogHelper.addInputOption("BaselineOffset", "Baseline Offset", null, "%", "" + this.si.getParameters().integralOffset, true);
        JButton autoButton = this.newJButton();
        autoButton.setText("Auto");
        autoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtIntegralListDialog.this.si.runScript("integrate auto");
            }
        });
        this.dialogHelper.addButton(autoButton);
        JButton deleteButton = this.newJButton();
        deleteButton.setText("Delete");
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtIntegralListDialog.this.delete();
            }
        });
        this.dialogHelper.addButton(deleteButton);
        JButton normalizeButton = this.newJButton();
        normalizeButton.setText("Normalize");
        normalizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtIntegralListDialog.this.normalize();
            }
        });
        this.dialogHelper.addButton(normalizeButton);
        JButton minButton = this.newJButton();
        minButton.setText("Minimum");
        minButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtIntegralListDialog.this.setMinimum();
            }
        });
        this.dialogHelper.addButton(minButton);
    }

    protected void delete() {
        if (!this.checkSelected()) {
            return;
        }
        this.xyData.remove(this.iSelected);
        this.iSelected = -1;
        this.iRowColSelected = -1;
        this.apply();
        this.jsvp.doRepaint();
    }

    private boolean checkSelected() {
        if (this.iSelected < 0) {
            JOptionPane.showMessageDialog(this.dialog, "Select a line on the table first, then click this button.");
            return false;
        }
        return true;
    }

    protected void normalize() {
        if (!this.checkSelected()) {
            return;
        }
        try {
            String ret = (String)JOptionPane.showInputDialog(this.dialog, "Enter a normalization factor", "Normalize", 3, null, null, "" + this.lastNorm);
            double val = Double.parseDouble(ret);
            if (val > 0.0) {
                this.lastNorm = val;
            }
            ((IntegralData)this.xyData).setSelectedIntegral((Measurement)this.xyData.get(this.iSelected), val);
            this.apply();
            this.jsvp.doRepaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setMinimum() {
        try {
            String ret = (String)JOptionPane.showInputDialog(this.dialog, "Minimum value?", "Set Minimum Value", 3, null, null, "" + this.lastMin);
            double val = Double.parseDouble(ret);
            ((IntegralData)this.xyData).setMinimumIntegral(val);
            this.apply();
            this.jsvp.doRepaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void apply() {
        try {
            this.myParams.integralOffset = Double.valueOf(this.txtOffset.getText());
            this.myParams.integralRange = Double.valueOf(this.txtScale.getText());
            this.myParams.integralDrawAll = false;
            ((IntegralData)this.getData()).update(this.myParams);
            this.jsvp.doRepaint();
            super.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void done() {
        super.done();
    }

    public void update(Coordinate clicked) {
        this.updateValues();
        this.checkEnables();
    }

    protected void updateValues() {
        this.loadData();
    }

    private void loadData() {
        if (this.xyData == null) {
            this.createData();
        }
        this.iSelected = -1;
        String[][] data = ((IntegralData)this.xyData).getMeasurementListArray(null);
        String[] header = this.xyData.getDataHeader();
        int[] widths = new int[]{40, 65, 65, 50};
        this.loadData(data, header, widths);
    }

    protected void createData() {
        this.xyData = new IntegralData(this.spec, this.myParams);
        this.iSelected = -1;
    }

    public void tableCellSelectedEvent(int iRow, int iCol) {
        DecimalFormat df2 = TextFormat.getDecimalFormat("#0.00");
        String value = this.tableData[iRow][1];
        int i = 0;
        while (i < this.xyData.size()) {
            if (df2.format(((Measurement)this.xyData.get(i)).getXVal()).equals(value)) {
                this.iSelected = i;
                this.jsvp.getPanelData().findX2(this.spec, ((Measurement)this.xyData.get(i)).getXVal(), this.spec, ((Measurement)this.xyData.get(i)).getXVal2());
                this.jsvp.doRepaint();
                break;
            }
            ++i;
        }
        this.checkEnables();
    }
}

