/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jspecview.applet.JSVAppletPrivatePro;
import jspecview.application.AppMenu;
import jspecview.application.AppToolBar;
import jspecview.application.CommandHistory;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.application.JSpecView;
import jspecview.application.PreferencesDialog;
import jspecview.application.TextDialog;
import jspecview.common.AwtOverlayLegendDialog;
import jspecview.common.AwtPanel;
import jspecview.common.AwtParameters;
import jspecview.common.AwtPopupMenu;
import jspecview.common.DialogHelper;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVAppletInterface;
import jspecview.common.JSVDialog;
import jspecview.common.JSVDropTargetListener;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelNode;
import jspecview.common.JSVTree;
import jspecview.common.JSVTreeNode;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelListener;
import jspecview.common.Parameters;
import jspecview.common.PeakPickEvent;
import jspecview.common.RepaintManager;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ViewDialog;
import jspecview.common.ViewPanel;
import jspecview.common.ZoomEvent;
import jspecview.export.Exporter;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.util.Escape;
import jspecview.util.FileManager;
import jspecview.util.Logger;
import jspecview.util.TextFormat;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolSyncInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame
implements JmolSyncInterface,
PanelListener,
ScriptInterface,
JSVAppletInterface {
    private static final long serialVersionUID = 1L;
    private static final int MAX_RECENT = 10;
    private AppMenu appMenu;
    private AppToolBar toolBar;
    private JTextField commandInput = new JTextField();
    private BorderLayout mainborderLayout = new BorderLayout();
    private JSplitPane mainSplitPane = new JSplitPane();
    private final JPanel nullPanel = new JPanel();
    private JSplitPane sideSplitPane = new JSplitPane();
    private JSVAppletPrivatePro advancedApplet;
    private CommandHistory commandHistory;
    private JDXSource currentSource;
    private DialogHelper dialogHelper;
    private DisplaySchemesProcessor dsp;
    public DropTargetListener dtl;
    private JmolSyncInterface jmol;
    private Component jmolDisplay;
    private Dimension jmolDimensionOld;
    private Container jmolFrame;
    private Dimension jmolDimensionNew = new Dimension(250, 200);
    private JSVInterface jmolOrAdvancedApplet;
    private AwtPopupMenu jsvpPopupMenu = new AwtPopupMenu(this);
    private List<JSVPanelNode> panelNodes = new ArrayList<JSVPanelNode>();
    private AwtParameters parameters = new AwtParameters("application");
    private JSVPanel prevPanel;
    private Properties properties;
    private List<String> recentFilePaths = new ArrayList<String>(10);
    private RepaintManager repaintManager;
    private JSVPanel selectedPanel;
    private JSVTree spectraTree;
    private JScrollPane spectraTreeScrollPane;
    private ViewPanel spectrumPanel;
    private JPanel statusPanel = new JPanel();
    private JLabel statusLabel = new JLabel();
    private JDXSpectrum.IRMode irMode = JDXSpectrum.IRMode.NO_CONVERT;
    private boolean autoIntegrate;
    private boolean autoShowLegend;
    private boolean isEmbedded;
    private boolean isHidden;
    private boolean interfaceOverlaid;
    private boolean loadImaginary = false;
    private boolean sidePanelOn;
    private boolean showExitDialog;
    private boolean statusbarOn;
    private boolean svgForInkscape = false;
    private boolean toolbarOn;
    private int mainSplitPosition = 200;
    private int fileCount;
    private int nViews;
    private int scriptLevelCount;
    private int splitPosition;
    private String tempDS;
    private String returnFromJmolModel;
    private String recentOpenURL = "http://";
    private String defaultDisplaySchemeName;
    private String recentURL;
    private String integrationRatios;

    public static void main(String[] args) {
        JSpecView.main(args);
    }

    @Override
    public boolean isPro() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean getAutoCombine() {
        return this.interfaceOverlaid;
    }

    @Override
    public boolean getAutoShowLegend() {
        return this.autoShowLegend;
    }

    @Override
    public JDXSource getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public int getFileCount() {
        return this.fileCount;
    }

    @Override
    public void setFileCount(int n) {
        this.fileCount = n;
    }

    @Override
    public String getIntegrationRatios() {
        return this.integrationRatios;
    }

    @Override
    public void setIntegrationRatios(String value) {
        this.integrationRatios = value;
    }

    @Override
    public JDXSpectrum.IRMode getIRMode() {
        return this.irMode;
    }

    @Override
    public void setIRMode(JDXSpectrum.IRMode mode) {
        this.irMode = mode;
    }

    @Override
    public void setLoadImaginary(boolean TF) {
        this.loadImaginary = TF;
    }

    @Override
    public List<JSVPanelNode> getPanelNodes() {
        return this.panelNodes;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Object getPopupMenu() {
        return this.jsvpPopupMenu;
    }

    @Override
    public void setReturnFromJmolModel(String model) {
        this.returnFromJmolModel = model;
    }

    @Override
    public String getReturnFromJmolModel() {
        return this.returnFromJmolModel;
    }

    @Override
    public JSVPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    @Override
    public Object getSpectraTree() {
        return this.spectraTree;
    }

    @Override
    public int incrementScriptLevelCount(int n) {
        return this.scriptLevelCount += n;
    }

    @Override
    public int incrementViewCount(int n) {
        return this.nViews += n;
    }

    public MainFrame(Component jmolDisplay, JSVInterface jmolOrAdvancedApplet) {
        this.repaintManager = new RepaintManager(this);
        this.dialogHelper = new DialogHelper(this);
        this.jmolDisplay = jmolDisplay;
        if (jmolDisplay != null) {
            this.jmolFrame = jmolDisplay.getParent();
        }
        this.jmolOrAdvancedApplet = jmolOrAdvancedApplet;
        this.advancedApplet = jmolOrAdvancedApplet instanceof JSVAppletPrivatePro ? (JSVAppletPrivatePro)jmolOrAdvancedApplet : null;
        this.onProgramStart();
    }

    void exitJSpecView(boolean withDialog) {
        this.jmolOrAdvancedApplet.saveProperties(this.properties);
        if (this.isEmbedded) {
            this.awaken(false);
            return;
        }
        this.dsp.getDisplaySchemes().remove("Current");
        this.jmolOrAdvancedApplet.exitJSpecView(withDialog && this.showExitDialog, this);
    }

    public void awaken(boolean visible) {
        if (this.jmolDisplay == null) {
            return;
        }
        try {
            if (visible) {
                this.jmolDimensionOld = new Dimension();
                this.jmolDisplay.getSize(this.jmolDimensionOld);
                this.jmolDisplay.setSize(this.jmolDimensionNew);
                this.jmolFrame.remove(this.jmolDisplay);
                this.jmolFrame.add(this.nullPanel);
                this.sideSplitPane.setBottomComponent(this.jmolDisplay);
                this.sideSplitPane.setDividerLocation(this.splitPosition);
                this.sideSplitPane.validate();
                this.jmolFrame.validate();
            } else {
                this.sideSplitPane.setBottomComponent(this.nullPanel);
                this.splitPosition = this.sideSplitPane.getDividerLocation();
                this.jmolFrame.add(this.jmolDisplay);
                this.jmolDisplay.getSize(this.jmolDimensionNew);
                this.jmolDisplay.setSize(this.jmolDimensionOld);
                this.sideSplitPane.validate();
                this.jmolFrame.validate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(visible);
    }

    private void onProgramStart() {
        new DropTarget(this, this.getDropListener());
        Class<?> cl = this.getClass();
        URL iconURL = cl.getResource("icons/spec16.gif");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));
        this.properties = new Properties();
        this.properties.setProperty("recentFilePaths", "");
        this.properties.setProperty("confirmBeforeExit", "true");
        this.properties.setProperty("automaticallyOverlay", "false");
        this.properties.setProperty("automaticallyShowLegend", "false");
        this.properties.setProperty("useDirectoryLastOpenedFile", "true");
        this.properties.setProperty("useDirectoryLastExportedFile", "false");
        this.properties.setProperty("directoryLastOpenedFile", "");
        this.properties.setProperty("directoryLastExportedFile", "");
        this.properties.setProperty("showSidePanel", "true");
        this.properties.setProperty("showToolBar", "true");
        this.properties.setProperty("showStatusBar", "true");
        this.properties.setProperty("defaultDisplaySchemeName", "Default");
        this.properties.setProperty("showGrid", "false");
        this.properties.setProperty("showCoordinates", "false");
        this.properties.setProperty("showXScale", "true");
        this.properties.setProperty("showYScale", "true");
        this.properties.setProperty("svgForInkscape", "false");
        this.properties.setProperty("automaticTAConversion", "false");
        this.properties.setProperty("AtoTSeparateWindow", "false");
        this.properties.setProperty("automaticallyIntegrate", "false");
        this.properties.setProperty("integralMinY", "0.1");
        this.properties.setProperty("integralFactor", "50");
        this.properties.setProperty("integralOffset", "30");
        this.properties.setProperty("integralPlotColor", "#ff0000");
        this.jmolOrAdvancedApplet.setProperties(this.properties);
        this.dsp = new DisplaySchemesProcessor();
        if (!this.dsp.load("displaySchemes.xml") && !this.dsp.load(this.getClass().getResourceAsStream("resources/displaySchemes.xml"))) {
            this.writeStatus("Problem loading Display Scheme");
        }
        this.setApplicationProperties(true);
        this.tempDS = this.defaultDisplaySchemeName;
        this.spectraTree = new JSVTree(this);
        this.spectraTree.setCellRenderer(new SpectraTreeCellRenderer());
        this.spectraTree.putClientProperty("JTree.lineStyle", "Angled");
        this.spectraTree.setShowsRootHandles(true);
        this.spectraTree.setEditable(false);
        this.spectraTree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MainFrame.this.getSelectedPanel() != null) {
                    MainFrame.this.getSelectedPanel().getPanelData().setZoom(0.0, 0.0, 0.0, 0.0);
                    MainFrame.this.repaint();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        new DropTarget(this.spectraTree, this.getDropListener());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setApplicationElements();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                MainFrame.this.windowClosing_actionPerformed();
            }
        });
        this.setSize(800, 500);
    }

    private void setApplicationElements() {
        this.appMenu.setSelections(this.sidePanelOn, this.toolbarOn, this.statusbarOn, this.getSelectedPanel());
        this.toolBar.setSelections(this.getSelectedPanel());
    }

    private void setApplicationProperties(boolean shouldApplySpectrumDisplaySettings) {
        String autoATConversion;
        String recentFilesString = this.properties.getProperty("recentFilePaths");
        this.recentFilePaths.clear();
        if (!recentFilesString.equals("")) {
            StringTokenizer st = new StringTokenizer(recentFilesString, ",");
            while (st.hasMoreTokens()) {
                this.recentFilePaths.add(st.nextToken().trim());
            }
        }
        this.showExitDialog = Boolean.parseBoolean(this.properties.getProperty("confirmBeforeExit"));
        this.interfaceOverlaid = Boolean.parseBoolean(this.properties.getProperty("automaticallyOverlay"));
        this.autoShowLegend = Boolean.parseBoolean(this.properties.getProperty("automaticallyShowLegend"));
        this.dialogHelper.useDirLastOpened = Boolean.parseBoolean(this.properties.getProperty("useDirectoryLastOpenedFile"));
        this.dialogHelper.useDirLastExported = Boolean.parseBoolean(this.properties.getProperty("useDirectoryLastExportedFile"));
        this.dialogHelper.dirLastOpened = this.properties.getProperty("directoryLastOpenedFile");
        this.dialogHelper.dirLastExported = this.properties.getProperty("directoryLastExportedFile");
        this.sidePanelOn = Boolean.parseBoolean(this.properties.getProperty("showSidePanel"));
        this.toolbarOn = Boolean.parseBoolean(this.properties.getProperty("showToolBar"));
        this.statusbarOn = Boolean.parseBoolean(this.properties.getProperty("showStatusBar"));
        this.defaultDisplaySchemeName = this.properties.getProperty("defaultDisplaySchemeName");
        if (shouldApplySpectrumDisplaySettings) {
            this.parameters.setBoolean(ScriptToken.GRIDON, Parameters.isTrue(this.properties.getProperty("showGrid")));
            this.parameters.setBoolean(ScriptToken.COORDINATESON, Parameters.isTrue(this.properties.getProperty("showCoordinates")));
            this.parameters.setBoolean(ScriptToken.XSCALEON, Parameters.isTrue(this.properties.getProperty("showXScale")));
            this.parameters.setBoolean(ScriptToken.YSCALEON, Parameters.isTrue(this.properties.getProperty("showYScale")));
        }
        if ((autoATConversion = this.properties.getProperty("automaticTAConversion")).equals("AtoT")) {
            this.irMode = JDXSpectrum.IRMode.TO_TRANS;
        } else if (autoATConversion.equals("TtoA")) {
            this.irMode = JDXSpectrum.IRMode.TO_ABS;
        }
        try {
            this.autoIntegrate = Boolean.parseBoolean(this.properties.getProperty("automaticallyIntegrate"));
            this.parameters.integralMinY = Double.parseDouble(this.properties.getProperty("integralMinY"));
            this.parameters.integralRange = Double.parseDouble(this.properties.getProperty("integralRange"));
            this.parameters.integralOffset = Double.parseDouble(this.properties.getProperty("integralOffset"));
            this.parameters.set(null, ScriptToken.INTEGRALPLOTCOLOR, this.properties.getProperty("integralPlotColor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.svgForInkscape = Boolean.parseBoolean(this.properties.getProperty("svgForInkscape"));
    }

    private DropTargetListener getDropListener() {
        if (this.dtl == null) {
            this.dtl = new JSVDropTargetListener(this);
        }
        return this.dtl;
    }

    private void jbInit() throws Exception {
        this.toolBar = new AppToolBar(this);
        this.appMenu = new AppMenu(this, this.jsvpPopupMenu);
        this.appMenu.setRecentMenu(this.recentFilePaths);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.appMenu);
        this.setTitle("JSpecView");
        this.getContentPane().setLayout(this.mainborderLayout);
        this.sideSplitPane.setOrientation(0);
        this.sideSplitPane.setOneTouchExpandable(true);
        this.statusLabel.setToolTipText("");
        this.statusLabel.setHorizontalTextPosition(10);
        this.statusLabel.setText("  ");
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        BorderLayout bl = new BorderLayout();
        bl.setHgap(2);
        bl.setVgap(2);
        this.statusPanel.setLayout(bl);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(0.3);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusPanel.add((Component)this.commandInput, "South");
        this.commandHistory = new CommandHistory(this, this.commandInput);
        this.commandInput.setFocusTraversalKeysEnabled(false);
        this.commandInput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                MainFrame.this.keyPressedEvent(e.getKeyCode(), e.getKeyChar());
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.spectraTreeScrollPane = new JScrollPane(this.spectraTree);
        if (this.jmolDisplay != null) {
            JSplitPane leftPanel = new JSplitPane();
            BorderLayout bl1 = new BorderLayout();
            leftPanel.setLayout(bl1);
            JPanel jmolDisplayPanel = new JPanel();
            jmolDisplayPanel.setBackground(Color.blue);
            leftPanel.add((Component)jmolDisplayPanel, "South");
            leftPanel.add((Component)this.spectraTreeScrollPane, "North");
            this.sideSplitPane.setTopComponent(this.spectraTreeScrollPane);
            this.splitPosition = 200;
            this.sideSplitPane.setDividerLocation(200);
            this.awaken(true);
            this.mainSplitPane.setLeftComponent(this.sideSplitPane);
        } else {
            this.mainSplitPane.setLeftComponent(this.spectraTreeScrollPane);
        }
        this.spectrumPanel = new ViewPanel(new BorderLayout());
        this.mainSplitPane.setRightComponent(this.spectrumPanel);
    }

    protected void keyPressedEvent(int keyCode, char keyChar) {
        this.commandHistory.keyPressed(keyCode);
        this.checkCommandLineForTip(keyChar);
        this.commandInput.requestFocusInWindow();
    }

    protected void checkCommandLineForTip(char c) {
        String tip;
        if (c != '\t' && (c == '\n' || c < ' ' || c > '~')) {
            return;
        }
        String cmd = String.valueOf(this.commandInput.getText()) + (Character.isISOControl(c) ? "" : "" + c);
        if (cmd.indexOf(";") >= 0) {
            cmd = cmd.substring(cmd.lastIndexOf(";") + 1);
        }
        while (cmd.startsWith(" ")) {
            cmd = cmd.substring(1);
        }
        if (cmd.length() == 0) {
            tip = "Enter a command:";
        } else {
            List<String> tokens = ScriptToken.getTokens(cmd);
            if (tokens.size() == 0) {
                return;
            }
            boolean isExact = cmd.endsWith(" ") || tokens.size() > 1;
            List<ScriptToken> list = ScriptToken.getScriptTokenList(tokens.get(0), isExact);
            switch (list.size()) {
                case 0: {
                    tip = "?";
                    break;
                }
                case 1: {
                    ScriptToken st = list.get(0);
                    tip = st.getTip();
                    tip = tip.indexOf("TRUE") >= 0 ? " (" + this.parameters.getBoolean(st) + ")" : (st.name().indexOf("COLOR") >= 0 ? " (" + AwtParameters.colorToHexString(this.parameters.getColor(st)) + ")" : "");
                    if (c == '\t' || isExact) {
                        tip = String.valueOf(st.name()) + " " + st.getTip() + tip;
                        if (c != '\t') break;
                        this.commandInput.setText(String.valueOf(st.name()) + " ");
                        break;
                    }
                    tip = String.valueOf(st.name()) + " " + tip;
                    break;
                }
                default: {
                    tip = ScriptToken.getNameList(list);
                }
            }
        }
        this.writeStatus(tip);
    }

    void showFileOpenDialog() {
        File file = this.dialogHelper.showFileOpenDialog(this);
        if (file != null) {
            this.openFile(file.getAbsolutePath(), true);
        }
    }

    @Override
    public void openDataOrFile(String data, String name, List<JDXSpectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend) {
        JSVTree.openDataOrFile(this, data, name, specs, url, firstSpec, lastSpec, isAppend);
        this.validateAndRepaint();
    }

    @Override
    public void setCurrentSource(JDXSource source) {
        this.currentSource = source;
        if (source != null) {
            this.appMenu.setCloseMenuItem(FileManager.getName(source.getFilePath()));
        }
        boolean isError = source != null && source.getErrorLog().length() > 0;
        this.setError(isError, isError && source.getErrorLog().indexOf("Warning") >= 0);
    }

    private void setError(boolean isError, boolean isWarningOnly) {
        this.appMenu.setError(isError, isWarningOnly);
        this.toolBar.setError(isError, isWarningOnly);
    }

    @Override
    public void setPropertiesFromPreferences(JSVPanel jsvp, boolean includeMeasures) {
        Parameters ds = this.dsp.getDisplaySchemes().get(this.defaultDisplaySchemeName);
        jsvp.getPanelData().addListener(this);
        this.parameters.setFor(jsvp, ds == null ? this.dsp.getDefaultScheme() : ds, includeMeasures);
        if (this.autoIntegrate) {
            jsvp.getPanelData().integrateAll(this.parameters);
        }
        jsvp.doRepaint();
    }

    public void showNotImplementedOptionPane() {
        JOptionPane.showMessageDialog(this, "Not Yet Implemented", "Not Yet Implemented", 1);
    }

    public void processCommand(String script) {
        this.runScriptNow(script);
    }

    @Override
    public boolean runScriptNow(String peakScript) {
        return JSViewer.runScriptNow(this, peakScript);
    }

    @Override
    public void panelEvent(Object eventObj) {
        SubSpecChangeEvent e;
        if (eventObj instanceof PeakPickEvent) {
            JSViewer.processPeakPickEvent(this, eventObj, true);
        } else if (eventObj instanceof ZoomEvent) {
            this.writeStatus("Double-Click highlighted spectrum in menu to zoom out; CTRL+/CTRL- to adjust Y scaling.");
        } else if (eventObj instanceof SubSpecChangeEvent && !(e = (SubSpecChangeEvent)eventObj).isValid()) {
            this.advanceSpectrumBy(-e.getSubIndex());
        }
    }

    @Override
    public void setSelectedPanel(JSVPanel jsvp) {
        if (this.selectedPanel != null) {
            this.mainSplitPosition = this.mainSplitPane.getDividerLocation();
        }
        this.spectrumPanel.setSelectedPanel(jsvp, this.panelNodes);
        this.selectedPanel = jsvp;
        this.spectraTree.setSelectedPanel(this, jsvp);
        this.validate();
        if (jsvp != null) {
            jsvp.setEnabled(true);
            jsvp.setFocusable(true);
        }
        if (this.mainSplitPosition != 0) {
            this.mainSplitPane.setDividerLocation(this.mainSplitPosition);
        }
    }

    @Override
    public void sendPanelChange(JSVPanel jsvp) {
        if (jsvp == this.prevPanel) {
            return;
        }
        this.prevPanel = jsvp;
        JSViewer.sendPanelChange(this, jsvp);
    }

    public void setSplitPane(boolean TF) {
        if (TF) {
            this.mainSplitPane.setDividerLocation(200);
        } else {
            this.mainSplitPane.setDividerLocation(0);
        }
    }

    public void enableToolbar(boolean isEnabled) {
        if (isEnabled) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else {
            this.getContentPane().remove(this.toolBar);
        }
        this.validate();
    }

    public void showPreferences() {
        PreferencesDialog pd = new PreferencesDialog(this, "Preferences", true, this.properties, this.dsp);
        this.properties = pd.getPreferences();
        boolean shouldApplySpectrumDisplaySetting = pd.shouldApplySpectrumDisplaySettingsNow();
        this.setApplicationProperties(shouldApplySpectrumDisplaySetting);
        int i = this.panelNodes.size();
        while (--i >= 0) {
            this.setPropertiesFromPreferences(this.panelNodes.get((int)i).jsvp, shouldApplySpectrumDisplaySetting);
        }
        this.setApplicationElements();
        this.dsp.getDisplaySchemes();
        if (this.defaultDisplaySchemeName.equals("Current")) {
            this.properties.setProperty("defaultDisplaySchemeName", this.tempDS);
        }
    }

    void exportSpectrumViaMenu(String command) {
        this.dialogHelper.exportSpectrum(this, command);
    }

    protected void windowClosing_actionPerformed() {
        this.exitJSpecView(true);
    }

    private void advanceSpectrumBy(int n) {
        int i = this.panelNodes.size();
        while (--i >= 0) {
            if (this.panelNodes.get((int)i).jsvp == this.getSelectedPanel()) break;
        }
        JSVTree.setFrameAndTreeNode(this, i + n);
        this.getSelectedPanel().getFocusNow(false);
    }

    @Override
    public Map<String, Object> getProperty(String key) {
        return JSViewer.getPropertyAsJavaObject(this, key);
    }

    @Override
    public void register(String appletID, JmolSyncInterface jmolStatusListener) {
        this.jmol = jmolStatusListener;
        this.isEmbedded = true;
    }

    @Override
    public synchronized void syncToJmol(String msg) {
        Logger.info("JSV>Jmol " + msg);
        if (this.jmol != null) {
            this.jmol.syncScript(msg);
            return;
        }
        if (this.jmolOrAdvancedApplet != null) {
            this.jmolOrAdvancedApplet.syncToJmol(msg);
        }
    }

    @Override
    public synchronized void syncScript(String peakScript) {
        this.spectraTree.setEnabled(false);
        JSViewer.syncScript(this, peakScript);
        this.spectraTree.setEnabled(true);
    }

    @Override
    public void syncLoad(String filePath) {
        this.closeSource(null);
        this.openDataOrFile(null, null, null, filePath, -1, -1, false);
        if (this.currentSource == null) {
            return;
        }
        if (this.panelNodes.get(0).getSpectrum().isAutoOverlayFromJmolClick()) {
            JSViewer.execView(this, "*", false);
        }
    }

    @Override
    public void validateAndRepaint() {
        this.validate();
        this.requestRepaint();
    }

    @Override
    public void execClose(String value, boolean fromScript) {
        JSVTree.close(this, TextFormat.trimQuotes(value));
        if (!fromScript || this.panelNodes.size() == 0) {
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void execHidden(boolean b) {
        this.isHidden = this.jmol != null && b;
        this.setVisible(!this.isHidden);
    }

    @Override
    public String execLoad(String value) {
        JSVTree.load(this, value);
        if (this.getSelectedPanel() == null) {
            return null;
        }
        PanelData pd = this.getSelectedPanel().getPanelData();
        if (!pd.getSpectrum().is1D() && pd.getDisplay1D()) {
            return "Click on the spectrum and use UP or DOWN keys to see subspectra.";
        }
        return null;
    }

    @Override
    public String execExport(JSVPanel jsvp, String value) {
        return Exporter.exportCmd(jsvp, ScriptToken.getTokens(value), this.svgForInkscape);
    }

    @Override
    public void execSetInterface(String value) {
        this.interfaceOverlaid = value.equalsIgnoreCase("overlay");
    }

    @Override
    public void execScriptComplete(String msg, boolean isOK) {
        this.requestRepaint();
        if (msg != null) {
            this.writeStatus(msg);
            if (msg.length() == 0) {
                msg = null;
            }
        }
    }

    @Override
    public JSVPanel setSpectrum(String value) {
        return JSVTree.setSpectrum(this, value);
    }

    @Override
    public void execSetAutoIntegrate(boolean b) {
        this.autoIntegrate = b;
    }

    @Override
    public PanelData getPanelData() {
        return this.getSelectedPanel().getPanelData();
    }

    @Override
    public JSVDialog getOverlayLegend(JSVPanel jsvp) {
        return new AwtOverlayLegendDialog((Frame)this, jsvp);
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        this.advancedApplet.addHighlight(x1, x2, r, g, b, a);
    }

    @Override
    public String exportSpectrum(String type, int n) {
        return this.advancedApplet.exportSpectrum(type, n);
    }

    @Override
    public String getCoordinate() {
        return this.advancedApplet.getCoordinate();
    }

    @Override
    public String getPropertyAsJSON(String key) {
        return this.advancedApplet.getPropertyAsJSON(key);
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return this.advancedApplet.getPropertyAsJavaObject(key);
    }

    @Override
    public String getSolnColour() {
        return this.advancedApplet.getSolnColour();
    }

    @Override
    public void loadInline(String data) {
        this.openDataOrFile(data, null, null, null, -1, -1, true);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.processCommand("load " + tmpFilePath);
    }

    @Override
    public void runScript(String script) {
        this.runScriptNow(script);
    }

    @Override
    public void removeAllHighlights() {
        this.advancedApplet.removeAllHighlights();
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        this.advancedApplet.removeHighlight(x1, x2);
    }

    @Override
    public void reversePlot() {
        this.advancedApplet.reversePlot();
    }

    @Override
    public void setSpectrumNumber(int i) {
        this.advancedApplet.setSpectrumNumber(i);
    }

    @Override
    public void toggleCoordinate() {
        this.advancedApplet.toggleCoordinate();
    }

    @Override
    public void toggleGrid() {
        this.advancedApplet.toggleGrid();
    }

    @Override
    public void toggleIntegration() {
        this.advancedApplet.toggleIntegration();
    }

    @Override
    public void execSetCallback(ScriptToken st, String value) {
        if (this.advancedApplet != null) {
            this.advancedApplet.execSetCallback(st, value);
        }
    }

    public void openFile(String fileName, boolean closeFirst) {
        JDXSource source;
        if (closeFirst && (source = JSVPanelNode.findSourceByNameOrId(new File(fileName).getAbsolutePath(), this.panelNodes)) != null) {
            this.closeSource(source);
        }
        this.openDataOrFile(null, null, null, fileName, -1, -1, true);
    }

    @Override
    public void showProperties() {
        TextDialog.showProperties(this, this.getPanelData().getSpectrum());
    }

    @Override
    public void updateBoolean(ScriptToken st, boolean TF) {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        switch (st) {
            case COORDINATESON: {
                this.toolBar.coordsToggleButton.setSelected(TF);
                break;
            }
            case GRIDON: {
                this.toolBar.gridToggleButton.setSelected(TF);
            }
        }
    }

    public void enableStatus(boolean TF) {
        if (TF) {
            this.getContentPane().add((Component)this.statusPanel, "South");
        } else {
            this.getContentPane().remove(this.statusPanel);
        }
        this.validate();
    }

    public void openURL() {
        String msg = this.recentURL == null ? this.recentOpenURL : this.recentURL;
        String url = (String)JOptionPane.showInputDialog(null, "Enter the URL of a JCAMP-DX File", "Open URL", -1, null, null, msg);
        if (url == null) {
            return;
        }
        this.recentOpenURL = url;
        this.openDataOrFile(null, null, null, url, -1, -1, false);
    }

    @Override
    public String print(String pdfFileName) {
        return this.dialogHelper.print(this, pdfFileName);
    }

    public void toggleOverlayKey() {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        JSViewer.setOverlayLegendVisibility(this, jsvp, true);
    }

    @Override
    public void checkCallbacks(String title) {
    }

    @Override
    public JSVPanelNode setOverlayVisibility(JSVPanelNode node) {
        JSViewer.setOverlayLegendVisibility(this, node.jsvp, this.appMenu.overlayKeyMenuItem.isSelected());
        return node;
    }

    @Override
    public void setNode(JSVPanelNode panelNode, boolean fromTree) {
        if (panelNode.jsvp != this.getSelectedPanel()) {
            this.setSelectedPanel(panelNode.jsvp);
        }
        this.sendPanelChange(panelNode.jsvp);
        this.setMenuEnables(panelNode, false);
        this.writeStatus("");
    }

    @Override
    public void closeSource(JDXSource source) {
        JSVTree.closeSource(this, source);
        this.appMenu.clearSourceMenu(source);
        this.setError(false, false);
        this.setTitle("JSpecView");
        this.validateAndRepaint();
    }

    @Override
    public void setRecentURL(String filePath) {
        this.recentURL = filePath;
    }

    @Override
    public void writeStatus(String msg) {
        if (msg == null) {
            msg = "Unexpected Error";
        }
        if (msg.length() == 0) {
            msg = "Enter a command:";
        }
        this.statusLabel.setText(msg);
    }

    @Override
    public void setLoaded(String fileName, String filePath) {
        this.appMenu.setCloseMenuItem(fileName);
        this.setTitle("JSpecView - " + filePath);
        this.appMenu.setSourceEnabled(true);
    }

    @Override
    public void updateRecentMenus(String filePath) {
        if (this.recentFilePaths.size() >= 10) {
            this.recentFilePaths.remove(9);
        }
        if (this.recentFilePaths.contains(filePath)) {
            this.recentFilePaths.remove(filePath);
        }
        this.recentFilePaths.add(0, filePath);
        StringBuffer filePaths = new StringBuffer();
        int n = this.recentFilePaths.size();
        int index = 0;
        while (index < n) {
            filePaths.append(", ").append(this.recentFilePaths.get(index));
            ++index;
        }
        this.properties.setProperty("recentFilePaths", n == 0 ? "" : filePaths.substring(2));
        this.appMenu.updateRecentMenus(this.recentFilePaths);
    }

    @Override
    public void setMenuEnables(JSVPanelNode node, boolean isSplit) {
        this.appMenu.setMenuEnables(node);
        this.toolBar.setMenuEnables(node);
    }

    @Override
    public JDXSource createSource(String data, String filePath, URL base, int firstSpec, int lastSpec) throws Exception {
        return FileReader.createJDXSource(FileManager.getBufferedReaderForString(data), filePath, null, false, this.loadImaginary, firstSpec, lastSpec);
    }

    @Override
    public URL getDocumentBase() {
        return null;
    }

    @Override
    public JSVPanel getNewJSVPanel(List<JDXSpectrum> specs) {
        return AwtPanel.getJSVPanel(this, specs, 0, 0, this.jsvpPopupMenu);
    }

    @Override
    public JSVPanel getNewJSVPanel(JDXSpectrum spec) {
        return spec == null ? null : AwtPanel.getNewPanel(this, spec, this.jsvpPopupMenu);
    }

    @Override
    public JSVPanelNode getNewPanelNode(String id, String fileName, JDXSource source, JSVPanel jsvp) {
        return new JSVPanelNode(id, fileName, source, jsvp);
    }

    @Override
    public void checkOverlay() {
        if (this.spectrumPanel != null) {
            this.spectrumPanel.markSelectedPanels(this.panelNodes);
        }
        new ViewDialog(this, this.spectraTreeScrollPane, false);
    }

    @Override
    public void setCursorObject(Object c) {
        this.setCursor((Cursor)c);
    }

    @Override
    public void execTest(String value) {
        System.out.println(Escape.toJSON(null, JSViewer.getPropertyAsJavaObject(this, value), false));
    }

    @Override
    public void requestRepaint() {
        if (this.getSelectedPanel() != null) {
            this.repaintManager.refresh();
        }
    }

    @Override
    public void repaintCompleted() {
        this.repaintManager.repaintDone();
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public String getFileAsString(String value) {
        return FileManager.getFileAsString(value, null);
    }

    private class SpectraTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        JSVTreeNode node;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.node = (JSVTreeNode)value;
            return this;
        }

        public Font getFont() {
            return new Font("Dialog", this.node == null || this.node.panelNode == null || this.node.panelNode.jsvp == null ? 1 : 2, 12);
        }
    }
}

