/*
 * Decompiled with CFR 0.152.
 */
package jspecview.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import jspecview.applet.JSVApplet;
import jspecview.applet.JSVAppletPopupMenu;
import jspecview.application.TextDialog;
import jspecview.common.AwtOverlayLegendDialog;
import jspecview.common.AwtPanel;
import jspecview.common.AwtParameters;
import jspecview.common.Coordinate;
import jspecview.common.DialogHelper;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVAppletInterface;
import jspecview.common.JSVDialog;
import jspecview.common.JSVDropTargetListener;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelNode;
import jspecview.common.JSVTree;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelListener;
import jspecview.common.Parameters;
import jspecview.common.PeakPickEvent;
import jspecview.common.RepaintManager;
import jspecview.common.ScriptCommandTokenizer;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ViewDialog;
import jspecview.common.ViewPanel;
import jspecview.common.ZoomEvent;
import jspecview.export.Exporter;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.util.Escape;
import jspecview.util.FileManager;
import jspecview.util.Logger;
import jspecview.util.TextFormat;
import netscape.javascript.JSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSVAppletPrivate
implements PanelListener,
ScriptInterface,
JSVAppletInterface {
    private JSVAppletPopupMenu appletPopupMenu;
    protected Thread commandWatcherThread;
    private JDXSource currentSource;
    private DialogHelper dialogHelper;
    protected JSVApplet jsvApplet;
    private JFrame offWindowFrame;
    private AwtOverlayLegendDialog overlayLegendDialog;
    private List<JSVPanelNode> panelNodes = new ArrayList<JSVPanelNode>();
    private AwtParameters parameters = new AwtParameters("applet");
    private RepaintManager repaintManager;
    private JSVPanel selectedPanel;
    private JSVTree spectraTree;
    private ViewPanel spectrumPanel;
    private ViewDialog viewDialog;
    private String appletID;
    private String fullName;
    private String syncID;
    private int fileCount;
    private int nViews;
    private int scriptLevelCount;
    boolean isNewWindow;
    private JDXSpectrum.IRMode irMode = JDXSpectrum.IRMode.NO_CONVERT;
    private boolean allowCompoundMenu = true;
    private boolean allowMenu = true;
    private boolean autoIntegrate;
    private boolean interfaceOverlaid;
    private boolean loadImaginary = false;
    private Boolean obscureTitleFromUser;
    private int initialStartIndex = -1;
    private int initialEndIndex = -1;
    private String integrationRatios;
    private String appletReadyCallbackFunctionName;
    private String coordCallbackFunctionName;
    private String loadFileCallbackFunctionName;
    private String peakCallbackFunctionName;
    private String syncCallbackFunctionName;
    private DropTargetListener dtl;
    private JSVPanel prevPanel;
    List<String> scriptQueue;
    private String returnFromJmolModel;

    JSVAppletPrivate(JSVApplet jsvApplet) {
        this.jsvApplet = jsvApplet;
        this.repaintManager = new RepaintManager(this);
        this.dialogHelper = new DialogHelper(this);
        this.init();
    }

    @Override
    public boolean isPro() {
        return this.isSigned();
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public JDXSource getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public void setCurrentSource(JDXSource source) {
        this.currentSource = source;
    }

    @Override
    public int getFileCount() {
        return this.fileCount;
    }

    @Override
    public void setFileCount(int n) {
        this.fileCount = n;
    }

    @Override
    public void setIntegrationRatios(String value) {
        this.integrationRatios = value;
    }

    @Override
    public String getIntegrationRatios() {
        return this.integrationRatios;
    }

    @Override
    public void setIRMode(JDXSpectrum.IRMode mode) {
        this.irMode = mode;
    }

    @Override
    public JDXSpectrum.IRMode getIRMode() {
        return this.irMode;
    }

    JSVApplet getJsvApplet() {
        return this.jsvApplet;
    }

    @Override
    public void setLoadImaginary(boolean TF) {
        this.loadImaginary = TF;
    }

    @Override
    public List<JSVPanelNode> getPanelNodes() {
        return this.panelNodes;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Object getPopupMenu() {
        return this.appletPopupMenu;
    }

    @Override
    public int incrementScriptLevelCount(int n) {
        return this.scriptLevelCount += n;
    }

    @Override
    public JSVPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    @Override
    public Object getSpectraTree() {
        return this.spectraTree;
    }

    @Override
    public int incrementViewCount(int n) {
        return this.nViews += n;
    }

    void dispose() {
        this.dialogHelper = null;
        try {
            if (this.viewDialog != null) {
                this.viewDialog.dispose();
            }
            this.viewDialog = null;
            if (this.overlayLegendDialog != null) {
                this.overlayLegendDialog.dispose();
            }
            this.overlayLegendDialog = null;
            if (this.commandWatcherThread != null) {
                this.commandWatcherThread.interrupt();
                this.commandWatcherThread = null;
            }
            if (this.panelNodes != null) {
                int i = this.panelNodes.size();
                while (--i >= 0) {
                    this.panelNodes.get(i).dispose();
                    this.panelNodes.remove(i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return JSViewer.getPropertyAsJavaObject(this, key);
    }

    @Override
    public String getPropertyAsJSON(String key) {
        return Escape.toJSON(null, this.getPropertyAsJavaObject(key), false);
    }

    @Override
    public String getCoordinate() {
        return JSViewer.getCoordinate(this);
    }

    @Override
    public void loadInline(String data) {
        this.openDataOrFile(data, null, null, null, -1, -1, true);
        this.jsvApplet.getContentPane().validate();
        this.spectrumPanel.validate();
    }

    @Override
    public String exportSpectrum(String type, int n) {
        return ((AwtPanel)this.getSelectedPanel()).export(type, n);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.runScript("load " + Escape.escape(tmpFilePath));
    }

    @Override
    public void setSpectrumNumber(int n) {
        this.runScript((Object)((Object)ScriptToken.SPECTRUMNUMBER) + " " + n);
    }

    @Override
    public void reversePlot() {
        this.toggle(ScriptToken.REVERSEPLOT);
    }

    @Override
    public void toggleGrid() {
        this.toggle(ScriptToken.GRIDON);
    }

    @Override
    public void toggleCoordinate() {
        this.toggle(ScriptToken.COORDINATESON);
    }

    @Override
    public void toggleIntegration() {
        this.toggle(ScriptToken.INTEGRATE);
    }

    private void toggle(ScriptToken st) {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp != null) {
            this.runScript((Object)((Object)st) + " TOGGLE");
        }
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        JSViewer.addHighLight(this, x1, x2, r, g, b, a);
    }

    @Override
    public void removeAllHighlights() {
        JSViewer.removeAllHighlights(this);
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        JSViewer.removeHighlights(this, x1, x2);
    }

    @Override
    public void syncScript(String peakScript) {
        JSViewer.syncScript(this, peakScript);
    }

    @Override
    public void writeStatus(String msg) {
        Logger.info(msg);
    }

    private void init() {
        this.spectraTree = new JSVTree(this);
        this.scriptQueue = new ArrayList<String>();
        this.commandWatcherThread = new Thread(new CommandWatcher());
        this.commandWatcherThread.setName("CommmandWatcherThread");
        this.commandWatcherThread.start();
        this.initParams(this.jsvApplet.getParameter("script"));
        if (this.appletReadyCallbackFunctionName != null && this.fullName != null) {
            this.callToJavaScript(this.appletReadyCallbackFunctionName, new Object[]{this.appletID, this.fullName, Boolean.TRUE, this.jsvApplet});
        }
        if (this.isSigned()) {
            new DropTarget(this.jsvApplet, this.getDropListener());
        }
    }

    private DropTargetListener getDropListener() {
        if (this.dtl == null) {
            this.dtl = new JSVDropTargetListener(this);
        }
        return this.dtl;
    }

    void initParams(String params) {
        this.parseInitScript(params);
        this.newAppletPanel();
        this.appletPopupMenu = new JSVAppletPopupMenu(this, this.allowMenu, this.parameters.getBoolean(ScriptToken.ENABLEZOOM));
        this.runScriptNow(params);
    }

    private void newAppletPanel() {
        Logger.info("newAppletPanel");
        this.jsvApplet.getContentPane().removeAll();
        this.spectrumPanel = new ViewPanel(new BorderLayout());
        this.jsvApplet.getContentPane().add(this.spectrumPanel);
    }

    @Override
    public void sendPanelChange(JSVPanel jsvp) {
        if (jsvp == this.prevPanel) {
            return;
        }
        this.prevPanel = jsvp;
        JSViewer.sendPanelChange(this, jsvp);
    }

    protected void showOverlayKey(boolean visible) {
        JSViewer.setOverlayLegendVisibility(this, this.getSelectedPanel(), visible);
    }

    void showHeader() {
        this.getSelectedPanel().showHeader(this.jsvApplet);
    }

    public void print() {
        this.print("");
    }

    @Override
    public String print(String pdfFileName) {
        boolean needWindow = false;
        if (needWindow) {
            this.newWindow(true);
        }
        String s = this.dialogHelper.print(this.offWindowFrame, pdfFileName);
        if (needWindow) {
            this.newWindow(false);
        }
        return s;
    }

    void newWindow(boolean isSelected) {
        this.isNewWindow = isSelected;
        if (isSelected) {
            this.offWindowFrame = new JFrame("JSpecView");
            this.offWindowFrame.setSize(this.jsvApplet.getSize());
            final Dimension d = this.spectrumPanel.getSize();
            this.offWindowFrame.add(this.spectrumPanel);
            this.offWindowFrame.validate();
            this.offWindowFrame.setVisible(true);
            this.jsvApplet.remove(this.spectrumPanel);
            this.validateAndRepaint();
            this.offWindowFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    JSVAppletPrivate.this.windowClosingEvent(d);
                }
            });
        } else {
            this.jsvApplet.getContentPane().add(this.spectrumPanel);
            this.validateAndRepaint();
            this.offWindowFrame.removeAll();
            this.offWindowFrame.dispose();
            this.offWindowFrame = null;
        }
    }

    protected void windowClosingEvent(Dimension d) {
        this.spectrumPanel.setSize(d);
        this.jsvApplet.getContentPane().add(this.spectrumPanel);
        this.jsvApplet.setVisible(true);
        this.validateAndRepaint();
        this.offWindowFrame.removeAll();
        this.offWindowFrame.dispose();
        this.appletPopupMenu.windowMenuItem.setSelected(false);
        this.isNewWindow = false;
    }

    @Override
    public void repaint() {
        this.jsvApplet.repaint();
    }

    @Override
    public void validateAndRepaint() {
        this.jsvApplet.validate();
        this.jsvApplet.repaint();
    }

    void exportSpectrumViaMenu(String type) {
        if (!this.isSigned()) {
            Logger.info(this.exportSpectrum(type, -1));
            return;
        }
        this.dialogHelper.exportSpectrum(this.offWindowFrame, type);
        this.getSelectedPanel().getFocusNow(true);
    }

    @Override
    public void syncLoad(String filePath) {
        this.newAppletPanel();
        Logger.info("JSVP syncLoad reading " + filePath);
        this.openDataOrFile(null, null, null, filePath, -1, -1, false);
        this.jsvApplet.getContentPane().validate();
        this.spectrumPanel.validate();
    }

    private void callToJavaScript(String callback, Object[] params) {
        try {
            JSObject jso = JSObject.getWindow((Applet)this.jsvApplet);
            if (callback.length() > 0) {
                if (callback.indexOf(".") > 0) {
                    String[] mods = TextFormat.split(callback, '.');
                    int i = 0;
                    while (i < mods.length - 1) {
                        jso = (JSObject)jso.getMember(mods[i]);
                        ++i;
                    }
                    callback = mods[mods.length - 1];
                }
                Logger.info("JSVApplet calling " + jso + " " + callback);
                jso.call(callback, params);
            }
        }
        catch (Exception npe) {
            Logger.warn("EXCEPTION-> " + npe.getMessage());
        }
    }

    private void parseInitScript(String params) {
        if (params == null) {
            params = "";
        }
        ScriptCommandTokenizer allParamTokens = new ScriptCommandTokenizer(params, ";\n");
        if (Logger.debugging) {
            Logger.info("Running in DEBUG mode");
        }
        block17: while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            StringTokenizer eachParam = new StringTokenizer(token);
            String key = eachParam.nextToken();
            if (key.equalsIgnoreCase("SET")) {
                key = eachParam.nextToken();
            }
            key = key.toUpperCase();
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            if (Logger.debugging) {
                Logger.info("KEY-> " + key + " VALUE-> " + value + " : " + (Object)((Object)st));
            }
            try {
                switch (st) {
                    default: {
                        this.parameters.set(null, st, value);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    case APPLETID: {
                        this.appletID = value;
                        this.fullName = String.valueOf(this.appletID) + "__" + this.syncID + "__";
                        break;
                    }
                    case APPLETREADYCALLBACKFUNCTIONNAME: {
                        this.appletReadyCallbackFunctionName = value;
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = Parameters.isTrue(value);
                        break;
                    }
                    case COMPOUNDMENUON: {
                        this.allowCompoundMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: 
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: {
                        this.execSetCallback(st, value);
                        break;
                    }
                    case ENDINDEX: {
                        this.initialEndIndex = Integer.parseInt(value);
                        break;
                    }
                    case INTERFACE: {
                        this.execSetInterface(value);
                        break;
                    }
                    case IRMODE: {
                        this.irMode = JDXSpectrum.IRMode.getMode(value);
                        break;
                    }
                    case MENUON: {
                        this.allowMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case OBSCURE: {
                        if (this.obscureTitleFromUser != null) continue block17;
                        this.obscureTitleFromUser = Boolean.valueOf(value);
                        break;
                    }
                    case STARTINDEX: {
                        this.initialStartIndex = Integer.parseInt(value);
                        break;
                    }
                    case SYNCID: {
                        this.syncID = value;
                        this.fullName = String.valueOf(this.appletID) + "__" + this.syncID + "__";
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void openDataOrFile(String data, String name, List<JDXSpectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend) {
        int status = JSVTree.openDataOrFile(this, data, name, specs, url, firstSpec, lastSpec, isAppend);
        if (status == -1) {
            return;
        }
        if (status != 0) {
            this.setSelectedPanel(null);
            return;
        }
        this.appletPopupMenu.setCompoundMenu(this.panelNodes, this.allowCompoundMenu);
        Logger.info(String.valueOf(this.jsvApplet.getAppletInfo()) + " File " + this.currentSource.getFilePath() + " Loaded Successfully");
    }

    protected void processCommand(String script) {
        this.runScriptNow(script);
    }

    @Override
    public boolean runScriptNow(String params) {
        return JSViewer.runScriptNow(this, params);
    }

    private void checkCallbacks() {
        Coordinate actualCoord;
        if (this.coordCallbackFunctionName == null && this.peakCallbackFunctionName == null) {
            return;
        }
        Coordinate coord = new Coordinate();
        Coordinate coordinate = actualCoord = this.peakCallbackFunctionName == null ? null : new Coordinate();
        if (!this.getSelectedPanel().getPanelData().getPickedCoordinates(coord, actualCoord)) {
            return;
        }
        int iSpec = this.spectrumPanel.getCurrentSpectrumIndex();
        if (actualCoord == null) {
            this.callToJavaScript(this.coordCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), iSpec + 1});
        } else {
            this.callToJavaScript(this.peakCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), actualCoord.getXVal(), actualCoord.getYVal(), iSpec + 1});
        }
    }

    @Override
    public void setSelectedPanel(JSVPanel jsvp) {
        this.spectrumPanel.setSelectedPanel(jsvp, this.panelNodes);
        this.selectedPanel = jsvp;
        this.spectraTree.setSelectedPanel(this, jsvp);
        this.jsvApplet.validate();
        if (jsvp != null) {
            jsvp.setEnabled(true);
            jsvp.setFocusable(true);
        }
    }

    void doAdvanced(String filePath) {
    }

    @Override
    public void panelEvent(Object eventObj) {
        if (eventObj instanceof PeakPickEvent) {
            JSViewer.processPeakPickEvent(this, eventObj, false);
        } else if (!(eventObj instanceof ZoomEvent)) {
            boolean cfr_ignored_0 = eventObj instanceof SubSpecChangeEvent;
        }
    }

    @Override
    public void runScript(String script) {
        if (this.scriptQueue == null) {
            this.processCommand(script);
        } else {
            this.scriptQueue.add(script);
        }
    }

    @Override
    public String execExport(JSVPanel jsvp, String value) {
        if (jsvp != null && this.isPro()) {
            this.writeStatus(Exporter.exportCmd(jsvp, ScriptToken.getTokens(value), false));
        }
        return null;
    }

    @Override
    public void execSetCallback(ScriptToken st, String value) {
        switch (st) {
            case LOADFILECALLBACKFUNCTIONNAME: {
                this.loadFileCallbackFunctionName = value;
                break;
            }
            case PEAKCALLBACKFUNCTIONNAME: {
                this.peakCallbackFunctionName = value;
                break;
            }
            case SYNCCALLBACKFUNCTIONNAME: {
                this.syncCallbackFunctionName = value;
                break;
            }
            case COORDCALLBACKFUNCTIONNAME: {
                this.coordCallbackFunctionName = value;
            }
        }
    }

    @Override
    public String getSolnColour() {
        return this.getSelectedPanel().getPanelData().getSolutionColor();
    }

    @Override
    public void execClose(String value, boolean fromScript) {
        JSVTree.close(this, value);
        if (!fromScript) {
            this.validateAndRepaint();
        }
    }

    @Override
    public String execLoad(String value) {
        JSVTree.load(this, value);
        if (this.getSelectedPanel() == null) {
            return null;
        }
        if (this.loadFileCallbackFunctionName != null) {
            this.callToJavaScript(this.loadFileCallbackFunctionName, new Object[]{this.appletID, value});
        }
        return null;
    }

    @Override
    public void execHidden(boolean b) {
    }

    @Override
    public void execSetInterface(String value) {
        this.interfaceOverlaid = value.equalsIgnoreCase("single") || value.equalsIgnoreCase("overlay");
    }

    @Override
    public void execScriptComplete(String msg, boolean isOK) {
        this.validateAndRepaint();
    }

    @Override
    public JSVPanel setSpectrum(String value) {
        return JSVTree.setSpectrum(this, value);
    }

    @Override
    public void execSetAutoIntegrate(boolean b) {
        this.autoIntegrate = b;
    }

    @Override
    public PanelData getPanelData() {
        return this.getSelectedPanel().getPanelData();
    }

    @Override
    public JSVDialog getOverlayLegend(JSVPanel jsvp) {
        this.overlayLegendDialog = new AwtOverlayLegendDialog(null, this.getSelectedPanel());
        return this.overlayLegendDialog;
    }

    @Override
    public synchronized void syncToJmol(String msg) {
        if (this.syncCallbackFunctionName == null) {
            return;
        }
        Logger.info("JSV>Jmol " + msg);
        this.callToJavaScript(this.syncCallbackFunctionName, new Object[]{this.fullName, msg});
    }

    @Override
    public void setVisible(boolean b) {
        this.spectrumPanel.setVisible(b);
    }

    @Override
    public void showProperties() {
        TextDialog.showProperties(this.jsvApplet, this.getPanelData().getSpectrum());
    }

    @Override
    public void updateBoolean(ScriptToken st, boolean TF) {
    }

    @Override
    public void checkCallbacks(String title) {
        this.checkCallbacks();
    }

    @Override
    public JSVPanelNode setOverlayVisibility(JSVPanelNode node) {
        JSViewer.setOverlayLegendVisibility(this, this.getSelectedPanel(), this.appletPopupMenu.overlayKeyMenuItem.isSelected());
        return node;
    }

    @Override
    public void setNode(JSVPanelNode panelNode, boolean fromTree) {
        if (panelNode.jsvp != this.getSelectedPanel()) {
            this.setSelectedPanel(panelNode.jsvp);
        }
        this.sendPanelChange(panelNode.jsvp);
        this.spectrumPanel.validate();
        this.validateAndRepaint();
    }

    @Override
    public void closeSource(JDXSource source) {
        JSVTree.closeSource(this, source);
    }

    public void process(List<JDXSpectrum> specs) {
        JDXSpectrum.process(specs, this.irMode);
    }

    @Override
    public void setCursorObject(Object c) {
        this.jsvApplet.setCursor((Cursor)c);
    }

    @Override
    public boolean getAutoCombine() {
        return this.interfaceOverlaid;
    }

    @Override
    public URL getDocumentBase() {
        return this.jsvApplet.getDocumentBase();
    }

    @Override
    public JDXSource createSource(String data, String filePath, URL base, int firstSpec, int lastSpec) throws Exception {
        return FileReader.createJDXSource(FileManager.getBufferedReaderForString(data), filePath, base, this.obscureTitleFromUser == Boolean.TRUE, this.loadImaginary, -1, -1);
    }

    @Override
    public JSVPanel getNewJSVPanel(List<JDXSpectrum> specs) {
        AwtPanel jsvp = AwtPanel.getJSVPanel(this, specs, this.initialStartIndex, this.initialEndIndex, this.appletPopupMenu);
        this.initialStartIndex = -1;
        this.initialEndIndex = -1;
        jsvp.getPanelData().addListener(this);
        this.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public JSVPanel getNewJSVPanel(JDXSpectrum spec) {
        if (spec == null) {
            this.initialStartIndex = -1;
            this.initialEndIndex = -1;
            return null;
        }
        ArrayList<JDXSpectrum> specs = new ArrayList<JDXSpectrum>();
        specs.add(spec);
        AwtPanel jsvp = AwtPanel.getJSVPanel(this, specs, this.initialStartIndex, this.initialEndIndex, this.appletPopupMenu);
        jsvp.getPanelData().addListener(this);
        this.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public JSVPanelNode getNewPanelNode(String id, String fileName, JDXSource source, JSVPanel jsvp) {
        return new JSVPanelNode(id, fileName, source, jsvp);
    }

    @Override
    public boolean getAutoShowLegend() {
        return false;
    }

    @Override
    public void checkOverlay() {
        if (this.spectrumPanel != null) {
            this.spectrumPanel.markSelectedPanels(this.panelNodes);
        }
        this.viewDialog = new ViewDialog(this, this.spectrumPanel, false);
    }

    @Override
    public void setReturnFromJmolModel(String model) {
        this.returnFromJmolModel = model;
    }

    @Override
    public String getReturnFromJmolModel() {
        return this.returnFromJmolModel;
    }

    @Override
    public void setPropertiesFromPreferences(JSVPanel jsvp, boolean includeMeasures) {
        if (this.autoIntegrate) {
            jsvp.getPanelData().integrateAll(this.parameters);
        }
    }

    @Override
    public void requestRepaint() {
        if (this.getSelectedPanel() != null) {
            this.repaintManager.refresh();
        }
    }

    @Override
    public void repaintCompleted() {
        this.repaintManager.repaintDone();
    }

    @Override
    public void setLoaded(String fileName, String filePath) {
    }

    @Override
    public void setMenuEnables(JSVPanelNode node, boolean isSplit) {
    }

    @Override
    public void setRecentURL(String filePath) {
    }

    @Override
    public void updateRecentMenus(String filePath) {
    }

    @Override
    public void execTest(String value) {
    }

    @Override
    public void setProperty(String key, String value) {
    }

    @Override
    public String getFileAsString(String value) {
        return FileManager.getFileAsString(value, this.jsvApplet.getDocumentBase());
    }

    class CommandWatcher
    implements Runnable {
        CommandWatcher() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            Thread.currentThread().setPriority(1);
            commandDelay = 200;
            while (JSVAppletPrivate.this.commandWatcherThread != null) {
                try {
                    Thread.sleep(commandDelay);
                    if (JSVAppletPrivate.this.commandWatcherThread == null || JSVAppletPrivate.this.scriptQueue.size() <= 0 || (scriptItem = JSVAppletPrivate.this.scriptQueue.remove(0)) == null) continue;
                    JSVAppletPrivate.this.processCommand(scriptItem);
                    continue;
                }
                catch (InterruptedException ie) {
                    Logger.info("CommandWatcher InterruptedException!");
                    break;
                }
                catch (Exception ie) {
                    s = "script processing ERROR:\n\n" + ie.toString();
                    i = 0;
                    ** while (i < ie.getStackTrace().length)
                }
lbl-1000:
                // 1 sources

                {
                    s = String.valueOf(s) + "\n" + ie.getStackTrace()[i].toString();
                    ++i;
                    continue;
                }
lbl19:
                // 1 sources

                Logger.info("CommandWatcher Exception! " + s);
                break;
            }
            JSVAppletPrivate.this.commandWatcherThread = null;
        }
    }
}

