/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.Map;
import javax.vecmath.Vector3f;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlVaspReader
extends XmlReader {
    String[] vaspImplementedAttributes = new String[]{"name"};
    private StringBuffer data;
    private String name;
    private int atomCount;
    private int iAtom;
    private boolean isE_wo_entrp = false;
    private boolean isE_fr_energy = false;
    private String enthalpy = null;
    private String gibbsEnergy = null;
    boolean haveUnitCell = false;
    String[] atomNames;
    String[] atomSyms;
    String atomName;
    String atomSym;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;

    XmlVaspReader() {
    }

    @Override
    protected String[] getImplementedAttributes() {
        return this.vaspImplementedAttributes;
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, Object object, XmlReader.JmolXmlHandler jmolXmlHandler) {
        xmlReader.doProcessLines = true;
        super.processXml(xmlReader, atomSetCollection, bufferedReader, object, jmolXmlHandler);
    }

    @Override
    public void processStartElement(String string, String string2, String string3, Map<String, String> map) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlvasp: start " + string2));
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("calculation".equals(string2)) {
            this.enthalpy = null;
            this.gibbsEnergy = null;
            return;
        }
        if ("i".equals(string2)) {
            String string4 = map.get("name");
            if (string4.charAt(0) != 'e') {
                return;
            }
            this.isE_wo_entrp = string4.equals("e_wo_entrp");
            this.isE_fr_energy = string4.equals("e_fr_energy");
            this.keepChars = this.isE_wo_entrp || this.isE_fr_energy;
            return;
        }
        if ("structure".equals(string2)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.atomSetCollection.setDoFixPeriodic();
            this.atomSetCollection.newAtomSet();
            if (this.enthalpy != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("enthalpy", (Object)Double.valueOf(this.enthalpy));
            }
            if (this.gibbsEnergy != null) {
                this.atomSetCollection.setAtomSetEnergy("" + this.gibbsEnergy, this.parseFloat(this.gibbsEnergy));
                this.atomSetCollection.setAtomSetAuxiliaryInfo("gibbsEnergy", (Object)Double.valueOf(this.gibbsEnergy));
            }
            if (this.enthalpy != null && this.gibbsEnergy != null) {
                this.atomSetCollection.setAtomSetName("Enthalpy = " + this.enthalpy + " eV Gibbs Energy = " + this.gibbsEnergy + " eV");
            }
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
        if ("v".equals(string2)) {
            this.keepChars = this.data != null;
            return;
        }
        if ("c".equals(string2)) {
            this.keepChars = this.iAtom < this.atomCount;
            return;
        }
        if ("varray".equals(string2)) {
            this.name = map.get("name");
            if (this.name != null && Parser.isOneOf((String)this.name, (String)"basis;positions;forces")) {
                this.data = new StringBuffer();
            }
            return;
        }
        if ("atoms".equals(string2)) {
            this.keepChars = true;
            return;
        }
    }

    @Override
    public void processEndElement(String string, String string2, String string3) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlvasp: end " + string2));
        }
        if (this.parent.doProcessLines) {
            if (this.isE_wo_entrp) {
                this.isE_wo_entrp = false;
                this.enthalpy = this.chars.trim();
            } else if (this.isE_fr_energy) {
                this.isE_fr_energy = false;
                this.gibbsEnergy = this.chars.trim();
            } else if ("v".equals(string2) && this.data != null) {
                this.data.append(this.chars);
            } else if ("c".equals(string2)) {
                if (this.iAtom < this.atomCount) {
                    if (this.atomName == null) {
                        this.atomName = this.atomSym = this.chars.trim();
                    } else {
                        this.atomNames[this.iAtom++] = this.atomName + this.chars.trim();
                        this.atomName = null;
                    }
                }
            } else if ("atoms".equals(string2)) {
                this.atomCount = this.parseInt(this.chars);
                this.atomNames = new String[this.atomCount];
                this.atomSyms = new String[this.atomCount];
                this.iAtom = 0;
            } else if ("varray".equals(string2) && this.data != null) {
                if (this.name != null) {
                    if ("basis".equals(this.name) && !this.haveUnitCell) {
                        this.haveUnitCell = true;
                        float[] fArray = XmlVaspReader.getTokensFloat((String)this.data.toString(), null, (int)9);
                        Vector3f vector3f = new Vector3f(fArray[0], fArray[1], fArray[2]);
                        Vector3f vector3f2 = new Vector3f(fArray[3], fArray[4], fArray[5]);
                        Vector3f vector3f3 = new Vector3f(fArray[6], fArray[7], fArray[8]);
                        this.a = vector3f.length();
                        this.b = vector3f2.length();
                        this.c = vector3f3.length();
                        vector3f.normalize();
                        vector3f2.normalize();
                        vector3f3.normalize();
                        this.alpha = (float)(Math.acos(vector3f2.dot(vector3f3)) * 180.0 / Math.PI);
                        this.beta = (float)(Math.acos(vector3f.dot(vector3f3)) * 180.0 / Math.PI);
                        this.gamma = (float)(Math.acos(vector3f.dot(vector3f2)) * 180.0 / Math.PI);
                    } else if ("positions".equals(this.name)) {
                        this.parent.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
                        float[] fArray = new float[this.atomCount * 3];
                        XmlVaspReader.getTokensFloat((String)this.data.toString(), (float[])fArray, (int)(this.atomCount * 3));
                        int n = 0;
                        for (int i = 0; i < this.atomCount; ++i) {
                            Atom atom = this.atomSetCollection.addNewAtom();
                            this.parent.setAtomCoord(atom, fArray[n++], fArray[n++], fArray[n++]);
                            atom.elementSymbol = this.atomSyms[i];
                            atom.atomName = this.atomNames[i];
                        }
                    } else if ("forces".equals(this.name)) {
                        float[] fArray = new float[this.atomCount * 3];
                        XmlVaspReader.getTokensFloat((String)this.data.toString(), (float[])fArray, (int)(this.atomCount * 3));
                        int n = 0;
                        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
                        for (int i = 0; i < this.atomCount; ++i) {
                            this.atomSetCollection.addVibrationVector(n2 + i, fArray[n++], fArray[n++], fArray[n++]);
                        }
                    }
                }
                this.data = null;
            } else if ("structure".equals(string2)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.chars = null;
        this.keepChars = false;
    }
}

